// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"time"
)

// Creates a new version of an annotation store.
func (c *Client) CreateAnnotationStoreVersion(ctx context.Context, params *CreateAnnotationStoreVersionInput, optFns ...func(*Options)) (*CreateAnnotationStoreVersionOutput, error) {
	if params == nil {
		params = &CreateAnnotationStoreVersionInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "CreateAnnotationStoreVersion", params, optFns, c.addOperationCreateAnnotationStoreVersionMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*CreateAnnotationStoreVersionOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type CreateAnnotationStoreVersionInput struct {

	// The name of an annotation store version from which versions are being created.
	//
	// This member is required.
	Name *string

	// The name given to an annotation store version to distinguish it from other
	// versions.
	//
	// This member is required.
	VersionName *string

	// The description of an annotation store version.
	Description *string

	// Any tags added to annotation store version.
	Tags map[string]string

	// The options for an annotation store version.
	VersionOptions types.VersionOptions

	noSmithyDocumentSerde
}

type CreateAnnotationStoreVersionOutput struct {

	// The time stamp for the creation of an annotation store version.
	//
	// This member is required.
	CreationTime *time.Time

	// A generated ID for the annotation store
	//
	// This member is required.
	Id *string

	// The name given to an annotation store version to distinguish it from other
	// versions.
	//
	// This member is required.
	Name *string

	// The status of a annotation store version.
	//
	// This member is required.
	Status types.VersionStatus

	// The ID for the annotation store from which new versions are being created.
	//
	// This member is required.
	StoreId *string

	// The name given to an annotation store version to distinguish it from other
	// versions.
	//
	// This member is required.
	VersionName *string

	// The options for an annotation store version.
	VersionOptions types.VersionOptions

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationCreateAnnotationStoreVersionMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpCreateAnnotationStoreVersion{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpCreateAnnotationStoreVersion{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "CreateAnnotationStoreVersion"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opCreateAnnotationStoreVersionMiddleware(stack); err != nil {
		return err
	}
	if err = addOpCreateAnnotationStoreVersionValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opCreateAnnotationStoreVersion(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opCreateAnnotationStoreVersionMiddleware struct {
}

func (*endpointPrefix_opCreateAnnotationStoreVersionMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opCreateAnnotationStoreVersionMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "analytics-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opCreateAnnotationStoreVersionMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opCreateAnnotationStoreVersionMiddleware{}, "ResolveEndpointV2", middleware.After)
}

func newServiceMetadataMiddleware_opCreateAnnotationStoreVersion(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "CreateAnnotationStoreVersion",
	}
}
