// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Includes basic information for a data column such as its description, name, and
// type.
type Column struct {

	// The description for a column.
	Description *string

	// The column name.
	Name *string

	// The kind of data a column stores.
	Type *string

	noSmithyDocumentSerde
}

// The SQL query of column selections and row filters from the data table you want.
type DataQuery struct {

	// The query statement.
	//
	// This member is required.
	QueryStatement *string

	// The table configuration.
	TableConfigurations map[string]map[string]string

	noSmithyDocumentSerde
}

// The destinations used for data exports.
type DestinationConfigurations struct {

	// An object that describes the destination of the data exports file.
	//
	// This member is required.
	S3Destination *S3Destination

	noSmithyDocumentSerde
}

// The reference for the data export update.
type ExecutionReference struct {

	// The ID for this specific execution.
	//
	// This member is required.
	ExecutionId *string

	// The status of this specific execution.
	//
	// This member is required.
	ExecutionStatus *ExecutionStatus

	noSmithyDocumentSerde
}

// The status of the execution.
type ExecutionStatus struct {

	// The time when the execution was completed.
	CompletedAt *time.Time

	// The time when the execution was created.
	CreatedAt *time.Time

	// The time when the execution was last updated.
	LastUpdatedAt *time.Time

	// The code for the status of the execution.
	StatusCode ExecutionStatusCode

	// The reason for the failed status.
	StatusReason ExecutionStatusReason

	noSmithyDocumentSerde
}

// The details that are available for an export.
type Export struct {

	// The data query for this specific data export.
	//
	// This member is required.
	DataQuery *DataQuery

	// The destination configuration for this specific data export.
	//
	// This member is required.
	DestinationConfigurations *DestinationConfigurations

	// The name of this specific data export.
	//
	// This member is required.
	Name *string

	// The cadence for Amazon Web Services to update the export in your S3 bucket.
	//
	// This member is required.
	RefreshCadence *RefreshCadence

	// The description for this specific data export.
	Description *string

	// The Amazon Resource Name (ARN) for this export.
	ExportArn *string

	noSmithyDocumentSerde
}

// The reference details for a given export.
type ExportReference struct {

	// The Amazon Resource Name (ARN) for this export.
	//
	// This member is required.
	ExportArn *string

	// The name of this specific data export.
	//
	// This member is required.
	ExportName *string

	// The status of this specific data export.
	//
	// This member is required.
	ExportStatus *ExportStatus

	noSmithyDocumentSerde
}

// The status of the data export.
type ExportStatus struct {

	// The timestamp of when the export was created.
	CreatedAt *time.Time

	// The timestamp of when the export was last generated.
	LastRefreshedAt *time.Time

	// The timestamp of when the export was updated.
	LastUpdatedAt *time.Time

	// The status code for the request.
	StatusCode ExportStatusCode

	// The description for the status code.
	StatusReason ExecutionStatusReason

	noSmithyDocumentSerde
}

// The cadence for Amazon Web Services to update the data export in your S3 bucket.
type RefreshCadence struct {

	// The frequency that data exports are updated. The export refreshes each time the
	// source data updates, up to three times daily.
	//
	// This member is required.
	Frequency FrequencyOption

	noSmithyDocumentSerde
}

// The tag structure that contains a tag key and value.
type ResourceTag struct {

	// The key that's associated with the tag.
	//
	// This member is required.
	Key *string

	// The value that's associated with the tag.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes the destination Amazon Simple Storage Service (Amazon S3) bucket name
// and object keys of a data exports file.
type S3Destination struct {

	// The name of the Amazon S3 bucket used as the destination of a data export file.
	//
	// This member is required.
	S3Bucket *string

	// The output configuration for the data export.
	//
	// This member is required.
	S3OutputConfigurations *S3OutputConfigurations

	// The S3 path prefix you want prepended to the name of your data export.
	//
	// This member is required.
	S3Prefix *string

	// The S3 bucket Region.
	//
	// This member is required.
	S3Region *string

	noSmithyDocumentSerde
}

// The compression type, file format, and overwrite preference for the data export.
type S3OutputConfigurations struct {

	// The compression type for the data export.
	//
	// This member is required.
	Compression CompressionOption

	// The file format for the data export.
	//
	// This member is required.
	Format FormatOption

	// The output type for the data export.
	//
	// This member is required.
	OutputType S3OutputType

	// The rule to follow when generating a version of the data export file. You have
	// the choice to overwrite the previous version or to be delivered in addition to
	// the previous versions. Overwriting exports can save on Amazon S3 storage costs.
	// Creating new export versions allows you to track the changes in cost and usage
	// data over time.
	//
	// This member is required.
	Overwrite OverwriteOption

	noSmithyDocumentSerde
}

// The details for the data export table.
type Table struct {

	// The description for the table.
	Description *string

	// The name of the table.
	TableName *string

	// The properties for the table.
	TableProperties []TablePropertyDescription

	noSmithyDocumentSerde
}

// The properties for the data export table.
type TablePropertyDescription struct {

	// The default value for the table.
	DefaultValue *string

	// The description for the table.
	Description *string

	// The name of the table.
	Name *string

	// The valid values for the table.
	ValidValues []string

	noSmithyDocumentSerde
}

// The input failed to meet the constraints specified by the Amazon Web Services
// service in a specified field.
type ValidationExceptionField struct {

	// A message with the reason for the validation exception error.
	//
	// This member is required.
	Message *string

	// The field name where the invalid entry was detected.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
