// Code generated by smithy-go-codegen DO NOT EDIT.

package auditmanager

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/auditmanager/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Disassociates a list of evidence from an assessment report in Audit Manager.
func (c *Client) BatchDisassociateAssessmentReportEvidence(ctx context.Context, params *BatchDisassociateAssessmentReportEvidenceInput, optFns ...func(*Options)) (*BatchDisassociateAssessmentReportEvidenceOutput, error) {
	if params == nil {
		params = &BatchDisassociateAssessmentReportEvidenceInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "BatchDisassociateAssessmentReportEvidence", params, optFns, c.addOperationBatchDisassociateAssessmentReportEvidenceMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*BatchDisassociateAssessmentReportEvidenceOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type BatchDisassociateAssessmentReportEvidenceInput struct {

	// The identifier for the assessment.
	//
	// This member is required.
	AssessmentId *string

	// The identifier for the folder that the evidence is stored in.
	//
	// This member is required.
	EvidenceFolderId *string

	// The list of evidence identifiers.
	//
	// This member is required.
	EvidenceIds []string

	noSmithyDocumentSerde
}

type BatchDisassociateAssessmentReportEvidenceOutput struct {

	// A list of errors that the BatchDisassociateAssessmentReportEvidence API
	// returned.
	Errors []types.AssessmentReportEvidenceError

	// The identifier for the evidence.
	EvidenceIds []string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationBatchDisassociateAssessmentReportEvidenceMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpBatchDisassociateAssessmentReportEvidence{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpBatchDisassociateAssessmentReportEvidence{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "BatchDisassociateAssessmentReportEvidence"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addOpBatchDisassociateAssessmentReportEvidenceValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opBatchDisassociateAssessmentReportEvidence(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opBatchDisassociateAssessmentReportEvidence(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "BatchDisassociateAssessmentReportEvidence",
	}
}
