// Code generated by smithy-go-codegen DO NOT EDIT.

package securitylake

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/securitylake/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a snapshot of the current Region, including whether Amazon Security
// Lake is enabled for those accounts and which sources Security Lake is collecting
// data from.
func (c *Client) GetDatalakeStatus(ctx context.Context, params *GetDatalakeStatusInput, optFns ...func(*Options)) (*GetDatalakeStatusOutput, error) {
	if params == nil {
		params = &GetDatalakeStatusInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "GetDatalakeStatus", params, optFns, c.addOperationGetDatalakeStatusMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*GetDatalakeStatusOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type GetDatalakeStatusInput struct {

	// The Amazon Web Services account ID for which a static snapshot of the current
	// Amazon Web Services Region, including enabled accounts and log sources, is
	// retrieved.
	AccountSet []string

	// The maximum limit of accounts for which the static snapshot of the current
	// Region, including enabled accounts and log sources, is retrieved.
	MaxAccountResults *int32

	// Lists if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token to
	// retrieve the next page. Keep all other arguments unchanged. Each pagination
	// token expires after 24 hours. Using an expired pagination token will return an
	// HTTP 400 InvalidToken error.
	NextToken *string

	noSmithyDocumentSerde
}

type GetDatalakeStatusOutput struct {

	// The list of enabled accounts and enabled sources.
	//
	// This member is required.
	AccountSourcesList []types.AccountSources

	// Lists if there are more results available. The value of nextToken is a unique
	// pagination token for each page. Repeat the call using the returned token to
	// retrieve the next page. Keep all other arguments unchanged. Each pagination
	// token expires after 24 hours. Using an expired pagination token will return an
	// HTTP 400 InvalidToken error.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationGetDatalakeStatusMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsRestjson1_serializeOpGetDatalakeStatus{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpGetDatalakeStatus{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opGetDatalakeStatus(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// GetDatalakeStatusAPIClient is a client that implements the GetDatalakeStatus
// operation.
type GetDatalakeStatusAPIClient interface {
	GetDatalakeStatus(context.Context, *GetDatalakeStatusInput, ...func(*Options)) (*GetDatalakeStatusOutput, error)
}

var _ GetDatalakeStatusAPIClient = (*Client)(nil)

// GetDatalakeStatusPaginatorOptions is the paginator options for GetDatalakeStatus
type GetDatalakeStatusPaginatorOptions struct {
	// The maximum limit of accounts for which the static snapshot of the current
	// Region, including enabled accounts and log sources, is retrieved.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// GetDatalakeStatusPaginator is a paginator for GetDatalakeStatus
type GetDatalakeStatusPaginator struct {
	options   GetDatalakeStatusPaginatorOptions
	client    GetDatalakeStatusAPIClient
	params    *GetDatalakeStatusInput
	nextToken *string
	firstPage bool
}

// NewGetDatalakeStatusPaginator returns a new GetDatalakeStatusPaginator
func NewGetDatalakeStatusPaginator(client GetDatalakeStatusAPIClient, params *GetDatalakeStatusInput, optFns ...func(*GetDatalakeStatusPaginatorOptions)) *GetDatalakeStatusPaginator {
	if params == nil {
		params = &GetDatalakeStatusInput{}
	}

	options := GetDatalakeStatusPaginatorOptions{}
	if params.MaxAccountResults != nil {
		options.Limit = *params.MaxAccountResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &GetDatalakeStatusPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *GetDatalakeStatusPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next GetDatalakeStatus page.
func (p *GetDatalakeStatusPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*GetDatalakeStatusOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxAccountResults = limit

	result, err := p.client.GetDatalakeStatus(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opGetDatalakeStatus(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "securitylake",
		OperationName: "GetDatalakeStatus",
	}
}
