// Code generated by smithy-go-codegen DO NOT EDIT.

package opensearchserverless

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/opensearchserverless/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Returns information about configured OpenSearch Serverless security
// configurations. For more information, see SAML authentication for Amazon
// OpenSearch Serverless
// (https://docs.aws.amazon.com/opensearch-service/latest/developerguide/serverless-saml.html).
func (c *Client) ListSecurityConfigs(ctx context.Context, params *ListSecurityConfigsInput, optFns ...func(*Options)) (*ListSecurityConfigsOutput, error) {
	if params == nil {
		params = &ListSecurityConfigsInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListSecurityConfigs", params, optFns, c.addOperationListSecurityConfigsMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListSecurityConfigsOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListSecurityConfigsInput struct {

	// The type of security configuration.
	//
	// This member is required.
	Type types.SecurityConfigType

	// An optional parameter that specifies the maximum number of results to return.
	// You can use nextToken to get the next page of results. The default is 20.
	MaxResults *int32

	// If your initial ListSecurityConfigs operation returns a nextToken, you can
	// include the returned nextToken in subsequent ListSecurityConfigs operations,
	// which returns results in the next page.
	NextToken *string

	noSmithyDocumentSerde
}

type ListSecurityConfigsOutput struct {

	// When nextToken is returned, there are more results available. The value of
	// nextToken is a unique pagination token for each page. Make the call again using
	// the returned token to retrieve the next page.
	NextToken *string

	// Details about the security configurations in your account.
	SecurityConfigSummaries []types.SecurityConfigSummary

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListSecurityConfigsMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListSecurityConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListSecurityConfigs{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addOpListSecurityConfigsValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListSecurityConfigs(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

// ListSecurityConfigsAPIClient is a client that implements the ListSecurityConfigs
// operation.
type ListSecurityConfigsAPIClient interface {
	ListSecurityConfigs(context.Context, *ListSecurityConfigsInput, ...func(*Options)) (*ListSecurityConfigsOutput, error)
}

var _ ListSecurityConfigsAPIClient = (*Client)(nil)

// ListSecurityConfigsPaginatorOptions is the paginator options for
// ListSecurityConfigs
type ListSecurityConfigsPaginatorOptions struct {
	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListSecurityConfigsPaginator is a paginator for ListSecurityConfigs
type ListSecurityConfigsPaginator struct {
	options   ListSecurityConfigsPaginatorOptions
	client    ListSecurityConfigsAPIClient
	params    *ListSecurityConfigsInput
	nextToken *string
	firstPage bool
}

// NewListSecurityConfigsPaginator returns a new ListSecurityConfigsPaginator
func NewListSecurityConfigsPaginator(client ListSecurityConfigsAPIClient, params *ListSecurityConfigsInput, optFns ...func(*ListSecurityConfigsPaginatorOptions)) *ListSecurityConfigsPaginator {
	if params == nil {
		params = &ListSecurityConfigsInput{}
	}

	options := ListSecurityConfigsPaginatorOptions{}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListSecurityConfigsPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListSecurityConfigsPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListSecurityConfigs page.
func (p *ListSecurityConfigsPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListSecurityConfigsOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	result, err := p.client.ListSecurityConfigs(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListSecurityConfigs(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "aoss",
		OperationName: "ListSecurityConfigs",
	}
}
