// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// The properties of the Accessor.
type Accessor struct {

	// The Amazon Resource Name (ARN) of the accessor. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The billing token is a property of the accessor. Use this token to make Ethereum
	// API calls to your Ethereum node. The billing token is used to track your
	// accessor object for billing Ethereum API requests made to your Ethereum nodes.
	BillingToken *string

	// The creation date and time of the accessor.
	CreationDate *time.Time

	// The unique identifier of the accessor.
	Id *string

	// The current status of the accessor.
	Status AccessorStatus

	// The tags assigned to the Accessor. For more information about tags, see Tagging
	// Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]string

	// The type of the accessor. Currently accessor type is restricted to
	// BILLING_TOKEN.
	Type AccessorType

	noSmithyDocumentSerde
}

// A summary of accessor properties.
type AccessorSummary struct {

	// The Amazon Resource Name (ARN) of the accessor. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The creation date and time of the accessor.
	CreationDate *time.Time

	// The unique identifier of the accessor.
	Id *string

	// The current status of the accessor.
	Status AccessorStatus

	// The type of the accessor. Currently accessor type is restricted to
	// BILLING_TOKEN.
	Type AccessorType

	noSmithyDocumentSerde
}

// A policy type that defines the voting rules for the network. The rules decide if
// a proposal is approved. Approval may be based on criteria such as the percentage
// of YES votes and the duration of the proposal. The policy applies to all
// proposals and is specified when the network is created. Applies only to
// Hyperledger Fabric.
type ApprovalThresholdPolicy struct {

	// The duration from the time that a proposal is created until it expires. If
	// members cast neither the required number of YES votes to approve the proposal
	// nor the number of NO votes required to reject it before the duration expires,
	// the proposal is EXPIRED and ProposalActions aren't carried out.
	ProposalDurationInHours *int32

	// Determines whether the vote percentage must be greater than the
	// ThresholdPercentage or must be greater than or equal to the ThreholdPercentage
	// to be approved.
	ThresholdComparator ThresholdComparator

	// The percentage of votes among all members that must be YES for a proposal to be
	// approved. For example, a ThresholdPercentage value of 50 indicates 50%. The
	// ThresholdComparator determines the precise comparison. If a ThresholdPercentage
	// value of 50 is specified on a network with 10 members, along with a
	// ThresholdComparator value of GREATER_THAN, this indicates that 6 YES votes are
	// required for the proposal to be approved.
	ThresholdPercentage *int32

	noSmithyDocumentSerde
}

// An invitation to an Amazon Web Services account to create a member and join the
// network. Applies only to Hyperledger Fabric.
type Invitation struct {

	// The Amazon Resource Name (ARN) of the invitation. For more information about
	// ARNs and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The date and time that the invitation was created.
	CreationDate *time.Time

	// The date and time that the invitation expires. This is the CreationDate plus the
	// ProposalDurationInHours that is specified in the ProposalThresholdPolicy. After
	// this date and time, the invitee can no longer create a member and join the
	// network using this InvitationId.
	ExpirationDate *time.Time

	// The unique identifier for the invitation.
	InvitationId *string

	// A summary of network configuration properties.
	NetworkSummary *NetworkSummary

	// The status of the invitation:
	//
	// * PENDING - The invitee hasn't created a member
	// to join the network, and the invitation hasn't yet expired.
	//
	// * ACCEPTING - The
	// invitee has begun creating a member, and creation hasn't yet completed.
	//
	// *
	// ACCEPTED - The invitee created a member and joined the network using the
	// InvitationID.
	//
	// * REJECTED - The invitee rejected the invitation.
	//
	// * EXPIRED -
	// The invitee neither created a member nor rejected the invitation before the
	// ExpirationDate.
	Status InvitationStatus

	noSmithyDocumentSerde
}

// An action to invite a specific Amazon Web Services account to create a member
// and join the network. The InviteAction is carried out when a Proposal is
// APPROVED. Applies only to Hyperledger Fabric.
type InviteAction struct {

	// The Amazon Web Services account ID to invite.
	//
	// This member is required.
	Principal *string

	noSmithyDocumentSerde
}

// A configuration for logging events.
type LogConfiguration struct {

	// Indicates whether logging is enabled.
	Enabled *bool

	noSmithyDocumentSerde
}

// A collection of log configurations.
type LogConfigurations struct {

	// Parameters for publishing logs to Amazon CloudWatch Logs.
	Cloudwatch *LogConfiguration

	noSmithyDocumentSerde
}

// Member configuration properties. Applies only to Hyperledger Fabric.
type Member struct {

	// The Amazon Resource Name (ARN) of the member. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The date and time that the member was created.
	CreationDate *time.Time

	// An optional description for the member.
	Description *string

	// Attributes relevant to a member for the blockchain framework that the Managed
	// Blockchain network uses.
	FrameworkAttributes *MemberFrameworkAttributes

	// The unique identifier of the member.
	Id *string

	// The Amazon Resource Name (ARN) of the customer managed key in Key Management
	// Service (KMS) that the member uses for encryption at rest. If the value of this
	// parameter is "AWS Owned KMS Key", the member uses an Amazon Web Services owned
	// KMS key for encryption. This parameter is inherited by the nodes that this
	// member owns. For more information, see Encryption at Rest
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	KmsKeyArn *string

	// Configuration properties for logging events associated with a member.
	LogPublishingConfiguration *MemberLogPublishingConfiguration

	// The name of the member.
	Name *string

	// The unique identifier of the network to which the member belongs.
	NetworkId *string

	// The status of a member.
	//
	// * CREATING - The Amazon Web Services account is in the
	// process of creating a member.
	//
	// * AVAILABLE - The member has been created and can
	// participate in the network.
	//
	// * CREATE_FAILED - The Amazon Web Services account
	// attempted to create a member and creation failed.
	//
	// * UPDATING - The member is in
	// the process of being updated.
	//
	// * DELETING - The member and all associated
	// resources are in the process of being deleted. Either the Amazon Web Services
	// account that owns the member deleted it, or the member is being deleted as the
	// result of an APPROVEDPROPOSAL to remove the member.
	//
	// * DELETED - The member can
	// no longer participate on the network and all associated resources are deleted.
	// Either the Amazon Web Services account that owns the member deleted it, or the
	// member is being deleted as the result of an APPROVEDPROPOSAL to remove the
	// member.
	//
	// * INACCESSIBLE_ENCRYPTION_KEY - The member is impaired and might not
	// function as expected because it cannot access the specified customer managed key
	// in KMS for encryption at rest. Either the KMS key was disabled or deleted, or
	// the grants on the key were revoked. The effect of disabling or deleting a key or
	// of revoking a grant isn't immediate. It might take some time for the member
	// resource to discover that the key is inaccessible. When a resource is in this
	// state, we recommend deleting and recreating the resource.
	Status MemberStatus

	// Tags assigned to the member. Tags consist of a key and optional value. For more
	// information about tags, see Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Configuration properties of the member. Applies only to Hyperledger Fabric.
type MemberConfiguration struct {

	// Configuration properties of the blockchain framework relevant to the member.
	//
	// This member is required.
	FrameworkConfiguration *MemberFrameworkConfiguration

	// The name of the member.
	//
	// This member is required.
	Name *string

	// An optional description of the member.
	Description *string

	// The Amazon Resource Name (ARN) of the customer managed key in Key Management
	// Service (KMS) to use for encryption at rest in the member. This parameter is
	// inherited by any nodes that this member creates. For more information, see
	// Encryption at Rest
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide. Use one of
	// the following options to specify this parameter:
	//
	// * Undefined or empty string -
	// By default, use an KMS key that is owned and managed by Amazon Web Services on
	// your behalf.
	//
	// * A valid symmetric customer managed KMS key - Use the specified
	// KMS key in your account that you create, own, and manage. Amazon Managed
	// Blockchain doesn't support asymmetric keys. For more information, see Using
	// symmetric and asymmetric keys
	// (https://docs.aws.amazon.com/kms/latest/developerguide/symmetric-asymmetric.html)
	// in the Key Management Service Developer Guide. The following is an example of a
	// KMS key ARN:
	// arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab
	KmsKeyArn *string

	// Configuration properties for logging events associated with a member of a
	// Managed Blockchain network.
	LogPublishingConfiguration *MemberLogPublishingConfiguration

	// Tags assigned to the member. Tags consist of a key and optional value. When
	// specifying tags during creation, you can specify multiple key-value pairs in a
	// single request, with an overall maximum of 50 tags added to each resource. For
	// more information about tags, see Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Attributes of Hyperledger Fabric for a member in a Managed Blockchain network
// using the Hyperledger Fabric framework.
type MemberFabricAttributes struct {

	// The user name for the initial administrator user for the member.
	AdminUsername *string

	// The endpoint used to access the member's certificate authority.
	CaEndpoint *string

	noSmithyDocumentSerde
}

// Configuration properties for Hyperledger Fabric for a member in a Managed
// Blockchain network using the Hyperledger Fabric framework.
type MemberFabricConfiguration struct {

	// The password for the member's initial administrative user. The AdminPassword
	// must be at least eight characters long and no more than 32 characters. It must
	// contain at least one uppercase letter, one lowercase letter, and one digit. It
	// cannot have a single quotation mark (‘), a double quotation marks (“), a forward
	// slash(/), a backward slash(\), @, or a space.
	//
	// This member is required.
	AdminPassword *string

	// The user name for the member's initial administrative user.
	//
	// This member is required.
	AdminUsername *string

	noSmithyDocumentSerde
}

// Configuration properties for logging events associated with a member of a
// Managed Blockchain network using the Hyperledger Fabric framework.
type MemberFabricLogPublishingConfiguration struct {

	// Configuration properties for logging events associated with a member's
	// Certificate Authority (CA). CA logs help you determine when a member in your
	// account joins the network, or when new peers register with a member CA.
	CaLogs *LogConfigurations

	noSmithyDocumentSerde
}

// Attributes relevant to a member for the blockchain framework that the Managed
// Blockchain network uses.
type MemberFrameworkAttributes struct {

	// Attributes of Hyperledger Fabric relevant to a member on a Managed Blockchain
	// network that uses Hyperledger Fabric.
	Fabric *MemberFabricAttributes

	noSmithyDocumentSerde
}

// Configuration properties relevant to a member for the blockchain framework that
// the Managed Blockchain network uses.
type MemberFrameworkConfiguration struct {

	// Attributes of Hyperledger Fabric for a member on a Managed Blockchain network
	// that uses Hyperledger Fabric.
	Fabric *MemberFabricConfiguration

	noSmithyDocumentSerde
}

// Configuration properties for logging events associated with a member of a
// Managed Blockchain network.
type MemberLogPublishingConfiguration struct {

	// Configuration properties for logging events associated with a member of a
	// Managed Blockchain network using the Hyperledger Fabric framework.
	Fabric *MemberFabricLogPublishingConfiguration

	noSmithyDocumentSerde
}

// A summary of configuration properties for a member. Applies only to Hyperledger
// Fabric.
type MemberSummary struct {

	// The Amazon Resource Name (ARN) of the member. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The date and time that the member was created.
	CreationDate *time.Time

	// An optional description of the member.
	Description *string

	// The unique identifier of the member.
	Id *string

	// An indicator of whether the member is owned by your Amazon Web Services account
	// or a different Amazon Web Services account.
	IsOwned *bool

	// The name of the member.
	Name *string

	// The status of the member.
	//
	// * CREATING - The Amazon Web Services account is in
	// the process of creating a member.
	//
	// * AVAILABLE - The member has been created and
	// can participate in the network.
	//
	// * CREATE_FAILED - The Amazon Web Services
	// account attempted to create a member and creation failed.
	//
	// * UPDATING - The
	// member is in the process of being updated.
	//
	// * DELETING - The member and all
	// associated resources are in the process of being deleted. Either the Amazon Web
	// Services account that owns the member deleted it, or the member is being deleted
	// as the result of an APPROVEDPROPOSAL to remove the member.
	//
	// * DELETED - The
	// member can no longer participate on the network and all associated resources are
	// deleted. Either the Amazon Web Services account that owns the member deleted it,
	// or the member is being deleted as the result of an APPROVEDPROPOSAL to remove
	// the member.
	//
	// * INACCESSIBLE_ENCRYPTION_KEY - The member is impaired and might
	// not function as expected because it cannot access the specified customer managed
	// key in Key Management Service (KMS) for encryption at rest. Either the KMS key
	// was disabled or deleted, or the grants on the key were revoked. The effect of
	// disabling or deleting a key or of revoking a grant isn't immediate. It might
	// take some time for the member resource to discover that the key is inaccessible.
	// When a resource is in this state, we recommend deleting and recreating the
	// resource.
	Status MemberStatus

	noSmithyDocumentSerde
}

// Network configuration properties.
type Network struct {

	// The Amazon Resource Name (ARN) of the network. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The date and time that the network was created.
	CreationDate *time.Time

	// Attributes of the blockchain framework for the network.
	Description *string

	// The blockchain framework that the network uses.
	Framework Framework

	// Attributes of the blockchain framework that the network uses.
	FrameworkAttributes *NetworkFrameworkAttributes

	// The version of the blockchain framework that the network uses.
	FrameworkVersion *string

	// The unique identifier of the network.
	Id *string

	// The name of the network.
	Name *string

	// The current status of the network.
	Status NetworkStatus

	// Tags assigned to the network. Each tag consists of a key and optional value. For
	// more information about tags, see Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]string

	// The voting rules for the network to decide if a proposal is accepted.
	VotingPolicy *VotingPolicy

	// The VPC endpoint service name of the VPC endpoint service of the network.
	// Members use the VPC endpoint service name to create a VPC endpoint to access
	// network resources.
	VpcEndpointServiceName *string

	noSmithyDocumentSerde
}

// Attributes of Ethereum for a network.
type NetworkEthereumAttributes struct {

	// The Ethereum CHAIN_ID associated with the Ethereum network. Chain IDs are as
	// follows:
	//
	// * mainnet = 1
	//
	// * goerli = 5
	//
	// * rinkeby = 4
	//
	// * ropsten = 3
	ChainId *string

	noSmithyDocumentSerde
}

// Attributes of Hyperledger Fabric for a network.
type NetworkFabricAttributes struct {

	// The edition of Amazon Managed Blockchain that Hyperledger Fabric uses. For more
	// information, see Amazon Managed Blockchain Pricing
	// (http://aws.amazon.com/managed-blockchain/pricing/).
	Edition Edition

	// The endpoint of the ordering service for the network.
	OrderingServiceEndpoint *string

	noSmithyDocumentSerde
}

// Hyperledger Fabric configuration properties for the network.
type NetworkFabricConfiguration struct {

	// The edition of Amazon Managed Blockchain that the network uses. For more
	// information, see Amazon Managed Blockchain Pricing
	// (http://aws.amazon.com/managed-blockchain/pricing/).
	//
	// This member is required.
	Edition Edition

	noSmithyDocumentSerde
}

// Attributes relevant to the network for the blockchain framework that the network
// uses.
type NetworkFrameworkAttributes struct {

	// Attributes of an Ethereum network for Managed Blockchain resources participating
	// in an Ethereum network.
	Ethereum *NetworkEthereumAttributes

	// Attributes of Hyperledger Fabric for a Managed Blockchain network that uses
	// Hyperledger Fabric.
	Fabric *NetworkFabricAttributes

	noSmithyDocumentSerde
}

// Configuration properties relevant to the network for the blockchain framework
// that the network uses.
type NetworkFrameworkConfiguration struct {

	// Hyperledger Fabric configuration properties for a Managed Blockchain network
	// that uses Hyperledger Fabric.
	Fabric *NetworkFabricConfiguration

	noSmithyDocumentSerde
}

// A summary of network configuration properties.
type NetworkSummary struct {

	// The Amazon Resource Name (ARN) of the network. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The date and time that the network was created.
	CreationDate *time.Time

	// An optional description of the network.
	Description *string

	// The blockchain framework that the network uses.
	Framework Framework

	// The version of the blockchain framework that the network uses.
	FrameworkVersion *string

	// The unique identifier of the network.
	Id *string

	// The name of the network.
	Name *string

	// The current status of the network.
	Status NetworkStatus

	noSmithyDocumentSerde
}

// Configuration properties of a node.
type Node struct {

	// The Amazon Resource Name (ARN) of the node. For more information about ARNs and
	// their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The Availability Zone in which the node exists. Required for Ethereum nodes.
	AvailabilityZone *string

	// The date and time that the node was created.
	CreationDate *time.Time

	// Attributes of the blockchain framework being used.
	FrameworkAttributes *NodeFrameworkAttributes

	// The unique identifier of the node.
	Id *string

	// The instance type of the node.
	InstanceType *string

	// The Amazon Resource Name (ARN) of the customer managed key in Key Management
	// Service (KMS) that the node uses for encryption at rest. If the value of this
	// parameter is "AWS Owned KMS Key", the node uses an Amazon Web Services owned KMS
	// key for encryption. The node inherits this parameter from the member that it
	// belongs to. For more information, see Encryption at Rest
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/managed-blockchain-encryption-at-rest.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide. Applies
	// only to Hyperledger Fabric.
	KmsKeyArn *string

	// Configuration properties for logging events associated with a peer node on a
	// Hyperledger Fabric network on Managed Blockchain.
	LogPublishingConfiguration *NodeLogPublishingConfiguration

	// The unique identifier of the member to which the node belongs. Applies only to
	// Hyperledger Fabric.
	MemberId *string

	// The unique identifier of the network that the node is on.
	NetworkId *string

	// The state database that the node uses. Values are LevelDB or CouchDB. Applies
	// only to Hyperledger Fabric.
	StateDB StateDBType

	// The status of the node.
	//
	// * CREATING - The Amazon Web Services account is in the
	// process of creating a node.
	//
	// * AVAILABLE - The node has been created and can
	// participate in the network.
	//
	// * UNHEALTHY - The node is impaired and might not
	// function as expected. Amazon Managed Blockchain automatically finds nodes in
	// this state and tries to recover them. If a node is recoverable, it returns to
	// AVAILABLE. Otherwise, it moves to FAILED status.
	//
	// * CREATE_FAILED - The Amazon
	// Web Services account attempted to create a node and creation failed.
	//
	// * UPDATING
	// - The node is in the process of being updated.
	//
	// * DELETING - The node is in the
	// process of being deleted.
	//
	// * DELETED - The node can no longer participate on the
	// network.
	//
	// * FAILED - The node is no longer functional, cannot be recovered, and
	// must be deleted.
	//
	// * INACCESSIBLE_ENCRYPTION_KEY - The node is impaired and might
	// not function as expected because it cannot access the specified customer managed
	// key in KMS for encryption at rest. Either the KMS key was disabled or deleted,
	// or the grants on the key were revoked. The effect of disabling or deleting a key
	// or of revoking a grant isn't immediate. It might take some time for the node
	// resource to discover that the key is inaccessible. When a resource is in this
	// state, we recommend deleting and recreating the resource.
	Status NodeStatus

	// Tags assigned to the node. Each tag consists of a key and optional value. For
	// more information about tags, see Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]string

	noSmithyDocumentSerde
}

// Configuration properties of a node.
type NodeConfiguration struct {

	// The Amazon Managed Blockchain instance type for the node.
	//
	// This member is required.
	InstanceType *string

	// The Availability Zone in which the node exists. Required for Ethereum nodes.
	AvailabilityZone *string

	// Configuration properties for logging events associated with a peer node on a
	// Hyperledger Fabric network on Managed Blockchain.
	LogPublishingConfiguration *NodeLogPublishingConfiguration

	// The state database that the node uses. Values are LevelDB or CouchDB. When using
	// an Amazon Managed Blockchain network with Hyperledger Fabric version 1.4 or
	// later, the default is CouchDB. Applies only to Hyperledger Fabric.
	StateDB StateDBType

	noSmithyDocumentSerde
}

// Attributes of an Ethereum node.
type NodeEthereumAttributes struct {

	// The endpoint on which the Ethereum node listens to run Ethereum API methods over
	// HTTP connections from a client. Use this endpoint in client code for smart
	// contracts when using an HTTP connection. Connections to this endpoint are
	// authenticated using Signature Version 4
	// (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	HttpEndpoint *string

	// The endpoint on which the Ethereum node listens to run Ethereum JSON-RPC methods
	// over WebSocket connections from a client. Use this endpoint in client code for
	// smart contracts when using a WebSocket connection. Connections to this endpoint
	// are authenticated using Signature Version 4
	// (https://docs.aws.amazon.com/general/latest/gr/signature-version-4.html).
	WebSocketEndpoint *string

	noSmithyDocumentSerde
}

// Attributes of Hyperledger Fabric for a peer node on a Hyperledger Fabric network
// on Managed Blockchain.
type NodeFabricAttributes struct {

	// The endpoint that identifies the peer node for all services except peer
	// channel-based event services.
	PeerEndpoint *string

	// The endpoint that identifies the peer node for peer channel-based event
	// services.
	PeerEventEndpoint *string

	noSmithyDocumentSerde
}

// Configuration properties for logging events associated with a peer node owned by
// a member in a Managed Blockchain network.
type NodeFabricLogPublishingConfiguration struct {

	// Configuration properties for logging events associated with chaincode execution
	// on a peer node. Chaincode logs contain the results of instantiating, invoking,
	// and querying the chaincode. A peer can run multiple instances of chaincode. When
	// enabled, a log stream is created for all chaincodes, with an individual log
	// stream for each chaincode.
	ChaincodeLogs *LogConfigurations

	// Configuration properties for a peer node log. Peer node logs contain messages
	// generated when your client submits transaction proposals to peer nodes, requests
	// to join channels, enrolls an admin peer, and lists the chaincode instances on a
	// peer node.
	PeerLogs *LogConfigurations

	noSmithyDocumentSerde
}

// Attributes relevant to a node on a Managed Blockchain network for the blockchain
// framework that the network uses.
type NodeFrameworkAttributes struct {

	// Attributes of Ethereum for a node on a Managed Blockchain network that uses
	// Ethereum.
	Ethereum *NodeEthereumAttributes

	// Attributes of Hyperledger Fabric for a peer node on a Managed Blockchain network
	// that uses Hyperledger Fabric.
	Fabric *NodeFabricAttributes

	noSmithyDocumentSerde
}

// Configuration properties for logging events associated with a peer node on a
// Hyperledger Fabric network on Managed Blockchain.
type NodeLogPublishingConfiguration struct {

	// Configuration properties for logging events associated with a node that is owned
	// by a member of a Managed Blockchain network using the Hyperledger Fabric
	// framework.
	Fabric *NodeFabricLogPublishingConfiguration

	noSmithyDocumentSerde
}

// A summary of configuration properties for a node.
type NodeSummary struct {

	// The Amazon Resource Name (ARN) of the node. For more information about ARNs and
	// their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The Availability Zone in which the node exists.
	AvailabilityZone *string

	// The date and time that the node was created.
	CreationDate *time.Time

	// The unique identifier of the node.
	Id *string

	// The EC2 instance type for the node.
	InstanceType *string

	// The status of the node.
	Status NodeStatus

	noSmithyDocumentSerde
}

// Properties of a proposal on a Managed Blockchain network. Applies only to
// Hyperledger Fabric.
type Proposal struct {

	// The actions to perform on the network if the proposal is APPROVED.
	Actions *ProposalActions

	// The Amazon Resource Name (ARN) of the proposal. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The date and time that the proposal was created.
	CreationDate *time.Time

	// The description of the proposal.
	Description *string

	// The date and time that the proposal expires. This is the CreationDate plus the
	// ProposalDurationInHours that is specified in the ProposalThresholdPolicy. After
	// this date and time, if members haven't cast enough votes to determine the
	// outcome according to the voting policy, the proposal is EXPIRED and Actions
	// aren't carried out.
	ExpirationDate *time.Time

	// The unique identifier of the network for which the proposal is made.
	NetworkId *string

	// The current total of NO votes cast on the proposal by members.
	NoVoteCount *int32

	// The number of votes remaining to be cast on the proposal by members. In other
	// words, the number of members minus the sum of YES votes and NO votes.
	OutstandingVoteCount *int32

	// The unique identifier of the proposal.
	ProposalId *string

	// The unique identifier of the member that created the proposal.
	ProposedByMemberId *string

	// The name of the member that created the proposal.
	ProposedByMemberName *string

	// The status of the proposal. Values are as follows:
	//
	// * IN_PROGRESS - The proposal
	// is active and open for member voting.
	//
	// * APPROVED - The proposal was approved
	// with sufficient YES votes among members according to the VotingPolicy specified
	// for the Network. The specified proposal actions are carried out.
	//
	// * REJECTED -
	// The proposal was rejected with insufficient YES votes among members according to
	// the VotingPolicy specified for the Network. The specified ProposalActions aren't
	// carried out.
	//
	// * EXPIRED - Members didn't cast the number of votes required to
	// determine the proposal outcome before the proposal expired. The specified
	// ProposalActions aren't carried out.
	//
	// * ACTION_FAILED - One or more of the
	// specified ProposalActions in a proposal that was approved couldn't be completed
	// because of an error. The ACTION_FAILED status occurs even if only one
	// ProposalAction fails and other actions are successful.
	Status ProposalStatus

	// Tags assigned to the proposal. Each tag consists of a key and optional value.
	// For more information about tags, see Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/ethereum-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Ethereum Developer Guide, or Tagging Resources
	// (https://docs.aws.amazon.com/managed-blockchain/latest/hyperledger-fabric-dev/tagging-resources.html)
	// in the Amazon Managed Blockchain Hyperledger Fabric Developer Guide.
	Tags map[string]string

	// The current total of YES votes cast on the proposal by members.
	YesVoteCount *int32

	noSmithyDocumentSerde
}

// The actions to carry out if a proposal is APPROVED. Applies only to Hyperledger
// Fabric.
type ProposalActions struct {

	// The actions to perform for an APPROVED proposal to invite an Amazon Web Services
	// account to create a member and join the network.
	Invitations []InviteAction

	// The actions to perform for an APPROVED proposal to remove a member from the
	// network, which deletes the member and all associated member resources from the
	// network.
	Removals []RemoveAction

	noSmithyDocumentSerde
}

// Properties of a proposal. Applies only to Hyperledger Fabric.
type ProposalSummary struct {

	// The Amazon Resource Name (ARN) of the proposal. For more information about ARNs
	// and their format, see Amazon Resource Names (ARNs)
	// (https://docs.aws.amazon.com/general/latest/gr/aws-arns-and-namespaces.html) in
	// the Amazon Web Services General Reference.
	Arn *string

	// The date and time that the proposal was created.
	CreationDate *time.Time

	// The description of the proposal.
	Description *string

	// The date and time that the proposal expires. This is the CreationDate plus the
	// ProposalDurationInHours that is specified in the ProposalThresholdPolicy. After
	// this date and time, if members haven't cast enough votes to determine the
	// outcome according to the voting policy, the proposal is EXPIRED and Actions
	// aren't carried out.
	ExpirationDate *time.Time

	// The unique identifier of the proposal.
	ProposalId *string

	// The unique identifier of the member that created the proposal.
	ProposedByMemberId *string

	// The name of the member that created the proposal.
	ProposedByMemberName *string

	// The status of the proposal. Values are as follows:
	//
	// * IN_PROGRESS - The proposal
	// is active and open for member voting.
	//
	// * APPROVED - The proposal was approved
	// with sufficient YES votes among members according to the VotingPolicy specified
	// for the Network. The specified proposal actions are carried out.
	//
	// * REJECTED -
	// The proposal was rejected with insufficient YES votes among members according to
	// the VotingPolicy specified for the Network. The specified ProposalActions aren't
	// carried out.
	//
	// * EXPIRED - Members didn't cast the number of votes required to
	// determine the proposal outcome before the proposal expired. The specified
	// ProposalActions aren't carried out.
	//
	// * ACTION_FAILED - One or more of the
	// specified ProposalActions in a proposal that was approved couldn't be completed
	// because of an error.
	Status ProposalStatus

	noSmithyDocumentSerde
}

// An action to remove a member from a Managed Blockchain network as the result of
// a removal proposal that is APPROVED. The member and all associated resources are
// deleted from the network. Applies only to Hyperledger Fabric.
type RemoveAction struct {

	// The unique identifier of the member to remove.
	//
	// This member is required.
	MemberId *string

	noSmithyDocumentSerde
}

// Properties of an individual vote that a member cast for a proposal. Applies only
// to Hyperledger Fabric.
type VoteSummary struct {

	// The unique identifier of the member that cast the vote.
	MemberId *string

	// The name of the member that cast the vote.
	MemberName *string

	// The vote value, either YES or NO.
	Vote VoteValue

	noSmithyDocumentSerde
}

// The voting rules for the network to decide if a proposal is accepted Applies
// only to Hyperledger Fabric.
type VotingPolicy struct {

	// Defines the rules for the network for voting on proposals, such as the
	// percentage of YES votes required for the proposal to be approved and the
	// duration of the proposal. The policy applies to all proposals and is specified
	// when the network is created.
	ApprovalThresholdPolicy *ApprovalThresholdPolicy

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde
