// Code generated by smithy-go-codegen DO NOT EDIT.

package keyspaces

import (
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/keyspaces/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/middleware"
)

type validateOpCreateKeyspace struct {
}

func (*validateOpCreateKeyspace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateKeyspace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateKeyspaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateKeyspaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpCreateTable struct {
}

func (*validateOpCreateTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpCreateTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*CreateTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpCreateTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteKeyspace struct {
}

func (*validateOpDeleteKeyspace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteKeyspace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteKeyspaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteKeyspaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpDeleteTable struct {
}

func (*validateOpDeleteTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpDeleteTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*DeleteTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpDeleteTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetKeyspace struct {
}

func (*validateOpGetKeyspace) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetKeyspace) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetKeyspaceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetKeyspaceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpGetTable struct {
}

func (*validateOpGetTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpGetTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*GetTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpGetTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTables struct {
}

func (*validateOpListTables) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTables) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTablesInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTablesInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpListTagsForResource struct {
}

func (*validateOpListTagsForResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpListTagsForResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*ListTagsForResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpListTagsForResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpRestoreTable struct {
}

func (*validateOpRestoreTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpRestoreTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*RestoreTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpRestoreTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpTagResource struct {
}

func (*validateOpTagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpTagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*TagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpTagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUntagResource struct {
}

func (*validateOpUntagResource) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUntagResource) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UntagResourceInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUntagResourceInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

type validateOpUpdateTable struct {
}

func (*validateOpUpdateTable) ID() string {
	return "OperationInputValidation"
}

func (m *validateOpUpdateTable) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	input, ok := in.Parameters.(*UpdateTableInput)
	if !ok {
		return out, metadata, fmt.Errorf("unknown input parameters type %T", in.Parameters)
	}
	if err := validateOpUpdateTableInput(input); err != nil {
		return out, metadata, err
	}
	return next.HandleInitialize(ctx, in)
}

func addOpCreateKeyspaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateKeyspace{}, middleware.After)
}

func addOpCreateTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpCreateTable{}, middleware.After)
}

func addOpDeleteKeyspaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteKeyspace{}, middleware.After)
}

func addOpDeleteTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpDeleteTable{}, middleware.After)
}

func addOpGetKeyspaceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetKeyspace{}, middleware.After)
}

func addOpGetTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpGetTable{}, middleware.After)
}

func addOpListTablesValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTables{}, middleware.After)
}

func addOpListTagsForResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpListTagsForResource{}, middleware.After)
}

func addOpRestoreTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpRestoreTable{}, middleware.After)
}

func addOpTagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpTagResource{}, middleware.After)
}

func addOpUntagResourceValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUntagResource{}, middleware.After)
}

func addOpUpdateTableValidationMiddleware(stack *middleware.Stack) error {
	return stack.Initialize.Add(&validateOpUpdateTable{}, middleware.After)
}

func validateCapacitySpecification(v *types.CapacitySpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CapacitySpecification"}
	if len(v.ThroughputMode) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("ThroughputMode"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClientSideTimestamps(v *types.ClientSideTimestamps) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClientSideTimestamps"}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClusteringKey(v *types.ClusteringKey) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClusteringKey"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if len(v.OrderBy) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("OrderBy"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateClusteringKeyList(v []types.ClusteringKey) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ClusteringKeyList"}
	for i := range v {
		if err := validateClusteringKey(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateColumnDefinition(v *types.ColumnDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ColumnDefinition"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if v.Type == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateColumnDefinitionList(v []types.ColumnDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ColumnDefinitionList"}
	for i := range v {
		if err := validateColumnDefinition(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateComment(v *types.Comment) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Comment"}
	if v.Message == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Message"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateEncryptionSpecification(v *types.EncryptionSpecification) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "EncryptionSpecification"}
	if len(v.Type) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Type"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePartitionKey(v *types.PartitionKey) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PartitionKey"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePartitionKeyList(v []types.PartitionKey) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PartitionKeyList"}
	for i := range v {
		if err := validatePartitionKey(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validatePointInTimeRecovery(v *types.PointInTimeRecovery) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "PointInTimeRecovery"}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateSchemaDefinition(v *types.SchemaDefinition) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "SchemaDefinition"}
	if v.AllColumns == nil {
		invalidParams.Add(smithy.NewErrParamRequired("AllColumns"))
	} else if v.AllColumns != nil {
		if err := validateColumnDefinitionList(v.AllColumns); err != nil {
			invalidParams.AddNested("AllColumns", err.(smithy.InvalidParamsError))
		}
	}
	if v.PartitionKeys == nil {
		invalidParams.Add(smithy.NewErrParamRequired("PartitionKeys"))
	} else if v.PartitionKeys != nil {
		if err := validatePartitionKeyList(v.PartitionKeys); err != nil {
			invalidParams.AddNested("PartitionKeys", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClusteringKeys != nil {
		if err := validateClusteringKeyList(v.ClusteringKeys); err != nil {
			invalidParams.AddNested("ClusteringKeys", err.(smithy.InvalidParamsError))
		}
	}
	if v.StaticColumns != nil {
		if err := validateStaticColumnList(v.StaticColumns); err != nil {
			invalidParams.AddNested("StaticColumns", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStaticColumn(v *types.StaticColumn) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StaticColumn"}
	if v.Name == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Name"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateStaticColumnList(v []types.StaticColumn) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "StaticColumnList"}
	for i := range v {
		if err := validateStaticColumn(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTag(v *types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "Tag"}
	if v.Key == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Key"))
	}
	if v.Value == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Value"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTagList(v []types.Tag) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagList"}
	for i := range v {
		if err := validateTag(&v[i]); err != nil {
			invalidParams.AddNested(fmt.Sprintf("[%d]", i), err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateTimeToLive(v *types.TimeToLive) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TimeToLive"}
	if len(v.Status) == 0 {
		invalidParams.Add(smithy.NewErrParamRequired("Status"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateKeyspaceInput(v *CreateKeyspaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateKeyspaceInput"}
	if v.KeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyspaceName"))
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpCreateTableInput(v *CreateTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "CreateTableInput"}
	if v.KeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyspaceName"))
	}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if v.SchemaDefinition == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SchemaDefinition"))
	} else if v.SchemaDefinition != nil {
		if err := validateSchemaDefinition(v.SchemaDefinition); err != nil {
			invalidParams.AddNested("SchemaDefinition", err.(smithy.InvalidParamsError))
		}
	}
	if v.Comment != nil {
		if err := validateComment(v.Comment); err != nil {
			invalidParams.AddNested("Comment", err.(smithy.InvalidParamsError))
		}
	}
	if v.CapacitySpecification != nil {
		if err := validateCapacitySpecification(v.CapacitySpecification); err != nil {
			invalidParams.AddNested("CapacitySpecification", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptionSpecification != nil {
		if err := validateEncryptionSpecification(v.EncryptionSpecification); err != nil {
			invalidParams.AddNested("EncryptionSpecification", err.(smithy.InvalidParamsError))
		}
	}
	if v.PointInTimeRecovery != nil {
		if err := validatePointInTimeRecovery(v.PointInTimeRecovery); err != nil {
			invalidParams.AddNested("PointInTimeRecovery", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ttl != nil {
		if err := validateTimeToLive(v.Ttl); err != nil {
			invalidParams.AddNested("Ttl", err.(smithy.InvalidParamsError))
		}
	}
	if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientSideTimestamps != nil {
		if err := validateClientSideTimestamps(v.ClientSideTimestamps); err != nil {
			invalidParams.AddNested("ClientSideTimestamps", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteKeyspaceInput(v *DeleteKeyspaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteKeyspaceInput"}
	if v.KeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyspaceName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpDeleteTableInput(v *DeleteTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "DeleteTableInput"}
	if v.KeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyspaceName"))
	}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetKeyspaceInput(v *GetKeyspaceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetKeyspaceInput"}
	if v.KeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyspaceName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpGetTableInput(v *GetTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "GetTableInput"}
	if v.KeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyspaceName"))
	}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTablesInput(v *ListTablesInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTablesInput"}
	if v.KeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyspaceName"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpListTagsForResourceInput(v *ListTagsForResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "ListTagsForResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpRestoreTableInput(v *RestoreTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "RestoreTableInput"}
	if v.SourceKeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceKeyspaceName"))
	}
	if v.SourceTableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("SourceTableName"))
	}
	if v.TargetKeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetKeyspaceName"))
	}
	if v.TargetTableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TargetTableName"))
	}
	if v.CapacitySpecificationOverride != nil {
		if err := validateCapacitySpecification(v.CapacitySpecificationOverride); err != nil {
			invalidParams.AddNested("CapacitySpecificationOverride", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptionSpecificationOverride != nil {
		if err := validateEncryptionSpecification(v.EncryptionSpecificationOverride); err != nil {
			invalidParams.AddNested("EncryptionSpecificationOverride", err.(smithy.InvalidParamsError))
		}
	}
	if v.PointInTimeRecoveryOverride != nil {
		if err := validatePointInTimeRecovery(v.PointInTimeRecoveryOverride); err != nil {
			invalidParams.AddNested("PointInTimeRecoveryOverride", err.(smithy.InvalidParamsError))
		}
	}
	if v.TagsOverride != nil {
		if err := validateTagList(v.TagsOverride); err != nil {
			invalidParams.AddNested("TagsOverride", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpTagResourceInput(v *TagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "TagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUntagResourceInput(v *UntagResourceInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UntagResourceInput"}
	if v.ResourceArn == nil {
		invalidParams.Add(smithy.NewErrParamRequired("ResourceArn"))
	}
	if v.Tags == nil {
		invalidParams.Add(smithy.NewErrParamRequired("Tags"))
	} else if v.Tags != nil {
		if err := validateTagList(v.Tags); err != nil {
			invalidParams.AddNested("Tags", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}

func validateOpUpdateTableInput(v *UpdateTableInput) error {
	if v == nil {
		return nil
	}
	invalidParams := smithy.InvalidParamsError{Context: "UpdateTableInput"}
	if v.KeyspaceName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("KeyspaceName"))
	}
	if v.TableName == nil {
		invalidParams.Add(smithy.NewErrParamRequired("TableName"))
	}
	if v.AddColumns != nil {
		if err := validateColumnDefinitionList(v.AddColumns); err != nil {
			invalidParams.AddNested("AddColumns", err.(smithy.InvalidParamsError))
		}
	}
	if v.CapacitySpecification != nil {
		if err := validateCapacitySpecification(v.CapacitySpecification); err != nil {
			invalidParams.AddNested("CapacitySpecification", err.(smithy.InvalidParamsError))
		}
	}
	if v.EncryptionSpecification != nil {
		if err := validateEncryptionSpecification(v.EncryptionSpecification); err != nil {
			invalidParams.AddNested("EncryptionSpecification", err.(smithy.InvalidParamsError))
		}
	}
	if v.PointInTimeRecovery != nil {
		if err := validatePointInTimeRecovery(v.PointInTimeRecovery); err != nil {
			invalidParams.AddNested("PointInTimeRecovery", err.(smithy.InvalidParamsError))
		}
	}
	if v.Ttl != nil {
		if err := validateTimeToLive(v.Ttl); err != nil {
			invalidParams.AddNested("Ttl", err.(smithy.InvalidParamsError))
		}
	}
	if v.ClientSideTimestamps != nil {
		if err := validateClientSideTimestamps(v.ClientSideTimestamps); err != nil {
			invalidParams.AddNested("ClientSideTimestamps", err.(smithy.InvalidParamsError))
		}
	}
	if invalidParams.Len() > 0 {
		return invalidParams
	} else {
		return nil
	}
}
