// Code generated by smithy-go-codegen DO NOT EDIT.

package fsx

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/fsx/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Use this action to associate one or more Domain Name Server (DNS) aliases with
// an existing Amazon FSx for Windows File Server file system. A file system can
// have a maximum of 50 DNS aliases associated with it at any one time. If you try
// to associate a DNS alias that is already associated with the file system, FSx
// takes no action on that alias in the request. For more information, see Working
// with DNS Aliases
// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/managing-dns-aliases.html)
// and Walkthrough 5: Using DNS aliases to access your file system
// (https://docs.aws.amazon.com/fsx/latest/WindowsGuide/walkthrough05-file-system-custom-CNAME.html),
// including additional steps you must take to be able to access your file system
// using a DNS alias. The system response shows the DNS aliases that Amazon FSx is
// attempting to associate with the file system. Use the API operation to monitor
// the status of the aliases Amazon FSx is associating with the file system.
func (c *Client) AssociateFileSystemAliases(ctx context.Context, params *AssociateFileSystemAliasesInput, optFns ...func(*Options)) (*AssociateFileSystemAliasesOutput, error) {
	if params == nil {
		params = &AssociateFileSystemAliasesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "AssociateFileSystemAliases", params, optFns, c.addOperationAssociateFileSystemAliasesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*AssociateFileSystemAliasesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// The request object specifying one or more DNS alias names to associate with an
// Amazon FSx for Windows File Server file system.
type AssociateFileSystemAliasesInput struct {

	// An array of one or more DNS alias names to associate with the file system. The
	// alias name has to comply with the following formatting requirements:
	//
	// *
	// Formatted as a fully-qualified domain name (FQDN), hostname.domain , for
	// example, accounting.corp.example.com.
	//
	// * Can contain alphanumeric characters and
	// the hyphen (-).
	//
	// * Cannot start or end with a hyphen.
	//
	// * Can start with a
	// numeric.
	//
	// For DNS alias names, Amazon FSx stores alphabetic characters as
	// lowercase letters (a-z), regardless of how you specify them: as uppercase
	// letters, lowercase letters, or the corresponding letters in escape codes.
	//
	// This member is required.
	Aliases []string

	// Specifies the file system with which you want to associate one or more DNS
	// aliases.
	//
	// This member is required.
	FileSystemId *string

	// (Optional) An idempotency token for resource creation, in a string of up to 64
	// ASCII characters. This token is automatically filled on your behalf when you use
	// the Command Line Interface (CLI) or an Amazon Web Services SDK.
	ClientRequestToken *string

	noSmithyDocumentSerde
}

// The system generated response showing the DNS aliases that Amazon FSx is
// attempting to associate with the file system. Use the API operation to monitor
// the status of the aliases Amazon FSx is associating with the file system. It can
// take up to 2.5 minutes for the alias status to change from CREATING to
// AVAILABLE.
type AssociateFileSystemAliasesOutput struct {

	// An array of the DNS aliases that Amazon FSx is associating with the file system.
	Aliases []types.Alias

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationAssociateFileSystemAliasesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	err = stack.Serialize.Add(&awsAwsjson11_serializeOpAssociateFileSystemAliases{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson11_deserializeOpAssociateFileSystemAliases{}, middleware.After)
	if err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = addHTTPSignerV4Middleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addIdempotencyToken_opAssociateFileSystemAliasesMiddleware(stack, options); err != nil {
		return err
	}
	if err = addOpAssociateFileSystemAliasesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opAssociateFileSystemAliases(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	return nil
}

type idempotencyToken_initializeOpAssociateFileSystemAliases struct {
	tokenProvider IdempotencyTokenProvider
}

func (*idempotencyToken_initializeOpAssociateFileSystemAliases) ID() string {
	return "OperationIdempotencyTokenAutoFill"
}

func (m *idempotencyToken_initializeOpAssociateFileSystemAliases) HandleInitialize(ctx context.Context, in middleware.InitializeInput, next middleware.InitializeHandler) (
	out middleware.InitializeOutput, metadata middleware.Metadata, err error,
) {
	if m.tokenProvider == nil {
		return next.HandleInitialize(ctx, in)
	}

	input, ok := in.Parameters.(*AssociateFileSystemAliasesInput)
	if !ok {
		return out, metadata, fmt.Errorf("expected middleware input to be of type *AssociateFileSystemAliasesInput ")
	}

	if input.ClientRequestToken == nil {
		t, err := m.tokenProvider.GetIdempotencyToken()
		if err != nil {
			return out, metadata, err
		}
		input.ClientRequestToken = &t
	}
	return next.HandleInitialize(ctx, in)
}
func addIdempotencyToken_opAssociateFileSystemAliasesMiddleware(stack *middleware.Stack, cfg Options) error {
	return stack.Initialize.Add(&idempotencyToken_initializeOpAssociateFileSystemAliases{tokenProvider: cfg.IdempotencyTokenProvider}, middleware.Before)
}

func newServiceMetadataMiddleware_opAssociateFileSystemAliases(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		SigningName:   "fsx",
		OperationName: "AssociateFileSystemAliases",
	}
}
