package styles

import (
	"github.com/alecthomas/chroma/v2"
)

// Doom One style. Inspired by Atom One and Doom Emacs's Atom One theme
var DoomOne = Register(chroma.MustNewStyle("doom-one", chroma.StyleEntries{
	chroma.Text:                 "#b0c4de",
	chroma.Error:                "#b0c4de",
	chroma.Comment:              "italic #8a93a5",
	chroma.CommentHashbang:      "bold",
	chroma.Keyword:              "#c678dd",
	chroma.KeywordType:          "#ef8383",
	chroma.KeywordConstant:      "bold #b756ff",
	chroma.Operator:             "#c7bf54",
	chroma.OperatorWord:         "bold #b756ff",
	chroma.Punctuation:          "#b0c4de",
	chroma.Name:                 "#c1abea",
	chroma.NameAttribute:        "#b3d23c",
	chroma.NameBuiltin:          "#ef8383",
	chroma.NameClass:            "#76a9f9",
	chroma.NameConstant:         "bold #b756ff",
	chroma.NameDecorator:        "#e5c07b",
	chroma.NameEntity:           "#bda26f",
	chroma.NameException:        "bold #fd7474",
	chroma.NameFunction:         "#00b1f7",
	chroma.NameProperty:         "#cebc3a",
	chroma.NameLabel:            "#f5a40d",
	chroma.NameNamespace:        "#76a9f9",
	chroma.NameTag:              "#e06c75",
	chroma.NameVariable:         "#DCAEEA",
	chroma.NameVariableGlobal:   "bold #DCAEEA",
	chroma.NameVariableInstance: "#e06c75",
	chroma.Literal:              "#98c379",
	chroma.Number:               "#d19a66",
	chroma.String:               "#98c379",
	chroma.StringDoc:            "#7e97c3",
	chroma.StringDouble:         "#63c381",
	chroma.StringEscape:         "bold #d26464",
	chroma.StringHeredoc:        "#98c379",
	chroma.StringInterpol:       "#98c379",
	chroma.StringOther:          "#70b33f",
	chroma.StringRegex:          "#56b6c2",
	chroma.StringSingle:         "#98c379",
	chroma.StringSymbol:         "#56b6c2",
	chroma.Generic:              "#b0c4de",
	chroma.GenericEmph:          "italic",
	chroma.GenericHeading:       "bold #a2cbff",
	chroma.GenericInserted:      "#a6e22e",
	chroma.GenericOutput:        "#a6e22e",
	chroma.GenericUnderline:     "underline",
	chroma.GenericPrompt:        "#a6e22e",
	chroma.GenericStrong:        "bold",
	chroma.GenericSubheading:    "#a2cbff",
	chroma.GenericTraceback:     "#a2cbff",
	chroma.Background:           "#b0c4de bg:#282c34",
}))
