// Copyright 2020 The Go Authors. All rights reserved.
// Use of this source code is governed by a BSD-style
// license that can be found in the LICENSE file.

// +build darwin,arm64,x509omitbundledroots

package x509

import (
	"strings"
	"testing"
)

func TestOmitBundledRoots(t *testing.T) {
	cp, err := loadSystemRoots()
	if err == nil {
		t.Fatalf("loadSystemRoots = (pool %p, error %v); want non-nil error", cp, err)
	}
	if !strings.Contains(err.Error(), "root bundling disabled") {
		t.Errorf("unexpected error doesn't mention bundling: %v", err)
	}
}
