// DO NOT EDIT
// generated by pyang using OpenConfig https://github.com/openconfig/public
//
// Copyright (C) 2014-2016 Nippon Telegraph and Telephone Corporation.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//    http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or
// implied.
// See the License for the specific language governing permissions and
// limitations under the License.

package config

import (
	"bytes"
	"fmt"
)

func mapkey(index int, name string) string {
	if name != "" {
		return name
	}
	return fmt.Sprintf("%v", index)
}

// typedef for typedef openconfig-types:std-regexp
type StdRegexp string

// typedef for typedef openconfig-types:percentage
type Percentage uint8

// typedef for typedef bgp-types:rr-cluster-id-type
type RrClusterIdType string

// typedef for identity bgp-types:remove-private-as-option
type RemovePrivateAsOption string

const (
	REMOVE_PRIVATE_AS_OPTION_ALL     RemovePrivateAsOption = "all"
	REMOVE_PRIVATE_AS_OPTION_REPLACE RemovePrivateAsOption = "replace"
)

var RemovePrivateAsOptionToIntMap = map[RemovePrivateAsOption]int{
	REMOVE_PRIVATE_AS_OPTION_ALL:     0,
	REMOVE_PRIVATE_AS_OPTION_REPLACE: 1,
}

func (v RemovePrivateAsOption) ToInt() int {
	i, ok := RemovePrivateAsOptionToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToRemovePrivateAsOptionMap = map[int]RemovePrivateAsOption{
	0: REMOVE_PRIVATE_AS_OPTION_ALL,
	1: REMOVE_PRIVATE_AS_OPTION_REPLACE,
}

func (v RemovePrivateAsOption) Validate() error {
	if _, ok := RemovePrivateAsOptionToIntMap[v]; !ok {
		return fmt.Errorf("invalid RemovePrivateAsOption: %s", v)
	}
	return nil
}

// typedef for typedef bgp-types:bgp-community-regexp-type
type BgpCommunityRegexpType StdRegexp

// typedef for identity bgp-types:community-type
type CommunityType string

const (
	COMMUNITY_TYPE_STANDARD CommunityType = "standard"
	COMMUNITY_TYPE_EXTENDED CommunityType = "extended"
	COMMUNITY_TYPE_BOTH     CommunityType = "both"
	COMMUNITY_TYPE_NONE     CommunityType = "none"
)

var CommunityTypeToIntMap = map[CommunityType]int{
	COMMUNITY_TYPE_STANDARD: 0,
	COMMUNITY_TYPE_EXTENDED: 1,
	COMMUNITY_TYPE_BOTH:     2,
	COMMUNITY_TYPE_NONE:     3,
}

func (v CommunityType) ToInt() int {
	i, ok := CommunityTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToCommunityTypeMap = map[int]CommunityType{
	0: COMMUNITY_TYPE_STANDARD,
	1: COMMUNITY_TYPE_EXTENDED,
	2: COMMUNITY_TYPE_BOTH,
	3: COMMUNITY_TYPE_NONE,
}

func (v CommunityType) Validate() error {
	if _, ok := CommunityTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid CommunityType: %s", v)
	}
	return nil
}

// typedef for typedef bgp-types:bgp-ext-community-type
type BgpExtCommunityType string

// typedef for typedef bgp-types:bgp-std-community-type
type BgpStdCommunityType string

// typedef for identity bgp-types:peer-type
type PeerType string

const (
	PEER_TYPE_INTERNAL PeerType = "internal"
	PEER_TYPE_EXTERNAL PeerType = "external"
)

var PeerTypeToIntMap = map[PeerType]int{
	PEER_TYPE_INTERNAL: 0,
	PEER_TYPE_EXTERNAL: 1,
}

func (v PeerType) ToInt() int {
	i, ok := PeerTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToPeerTypeMap = map[int]PeerType{
	0: PEER_TYPE_INTERNAL,
	1: PEER_TYPE_EXTERNAL,
}

func (v PeerType) Validate() error {
	if _, ok := PeerTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid PeerType: %s", v)
	}
	return nil
}

// typedef for identity bgp-types:bgp-session-direction
type BgpSessionDirection string

const (
	BGP_SESSION_DIRECTION_INBOUND  BgpSessionDirection = "inbound"
	BGP_SESSION_DIRECTION_OUTBOUND BgpSessionDirection = "outbound"
)

var BgpSessionDirectionToIntMap = map[BgpSessionDirection]int{
	BGP_SESSION_DIRECTION_INBOUND:  0,
	BGP_SESSION_DIRECTION_OUTBOUND: 1,
}

func (v BgpSessionDirection) ToInt() int {
	i, ok := BgpSessionDirectionToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToBgpSessionDirectionMap = map[int]BgpSessionDirection{
	0: BGP_SESSION_DIRECTION_INBOUND,
	1: BGP_SESSION_DIRECTION_OUTBOUND,
}

func (v BgpSessionDirection) Validate() error {
	if _, ok := BgpSessionDirectionToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpSessionDirection: %s", v)
	}
	return nil
}

// typedef for identity bgp-types:bgp-origin-attr-type
type BgpOriginAttrType string

const (
	BGP_ORIGIN_ATTR_TYPE_IGP        BgpOriginAttrType = "igp"
	BGP_ORIGIN_ATTR_TYPE_EGP        BgpOriginAttrType = "egp"
	BGP_ORIGIN_ATTR_TYPE_INCOMPLETE BgpOriginAttrType = "incomplete"
)

var BgpOriginAttrTypeToIntMap = map[BgpOriginAttrType]int{
	BGP_ORIGIN_ATTR_TYPE_IGP:        0,
	BGP_ORIGIN_ATTR_TYPE_EGP:        1,
	BGP_ORIGIN_ATTR_TYPE_INCOMPLETE: 2,
}

func (v BgpOriginAttrType) ToInt() int {
	i, ok := BgpOriginAttrTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToBgpOriginAttrTypeMap = map[int]BgpOriginAttrType{
	0: BGP_ORIGIN_ATTR_TYPE_IGP,
	1: BGP_ORIGIN_ATTR_TYPE_EGP,
	2: BGP_ORIGIN_ATTR_TYPE_INCOMPLETE,
}

func (v BgpOriginAttrType) Validate() error {
	if _, ok := BgpOriginAttrTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpOriginAttrType: %s", v)
	}
	return nil
}

// typedef for identity bgp-types:afi-safi-type
type AfiSafiType string

const (
	AFI_SAFI_TYPE_IPV4_UNICAST          AfiSafiType = "ipv4-unicast"
	AFI_SAFI_TYPE_IPV6_UNICAST          AfiSafiType = "ipv6-unicast"
	AFI_SAFI_TYPE_IPV4_LABELLED_UNICAST AfiSafiType = "ipv4-labelled-unicast"
	AFI_SAFI_TYPE_IPV6_LABELLED_UNICAST AfiSafiType = "ipv6-labelled-unicast"
	AFI_SAFI_TYPE_L3VPN_IPV4_UNICAST    AfiSafiType = "l3vpn-ipv4-unicast"
	AFI_SAFI_TYPE_L3VPN_IPV6_UNICAST    AfiSafiType = "l3vpn-ipv6-unicast"
	AFI_SAFI_TYPE_L3VPN_IPV4_MULTICAST  AfiSafiType = "l3vpn-ipv4-multicast"
	AFI_SAFI_TYPE_L3VPN_IPV6_MULTICAST  AfiSafiType = "l3vpn-ipv6-multicast"
	AFI_SAFI_TYPE_L2VPN_VPLS            AfiSafiType = "l2vpn-vpls"
	AFI_SAFI_TYPE_L2VPN_EVPN            AfiSafiType = "l2vpn-evpn"
	AFI_SAFI_TYPE_IPV4_MULTICAST        AfiSafiType = "ipv4-multicast"
	AFI_SAFI_TYPE_IPV6_MULTICAST        AfiSafiType = "ipv6-multicast"
	AFI_SAFI_TYPE_RTC                   AfiSafiType = "rtc"
	AFI_SAFI_TYPE_IPV4_ENCAP            AfiSafiType = "ipv4-encap"
	AFI_SAFI_TYPE_IPV6_ENCAP            AfiSafiType = "ipv6-encap"
	AFI_SAFI_TYPE_IPV4_FLOWSPEC         AfiSafiType = "ipv4-flowspec"
	AFI_SAFI_TYPE_L3VPN_IPV4_FLOWSPEC   AfiSafiType = "l3vpn-ipv4-flowspec"
	AFI_SAFI_TYPE_IPV6_FLOWSPEC         AfiSafiType = "ipv6-flowspec"
	AFI_SAFI_TYPE_L3VPN_IPV6_FLOWSPEC   AfiSafiType = "l3vpn-ipv6-flowspec"
	AFI_SAFI_TYPE_L2VPN_FLOWSPEC        AfiSafiType = "l2vpn-flowspec"
	AFI_SAFI_TYPE_OPAQUE                AfiSafiType = "opaque"
)

var AfiSafiTypeToIntMap = map[AfiSafiType]int{
	AFI_SAFI_TYPE_IPV4_UNICAST:          0,
	AFI_SAFI_TYPE_IPV6_UNICAST:          1,
	AFI_SAFI_TYPE_IPV4_LABELLED_UNICAST: 2,
	AFI_SAFI_TYPE_IPV6_LABELLED_UNICAST: 3,
	AFI_SAFI_TYPE_L3VPN_IPV4_UNICAST:    4,
	AFI_SAFI_TYPE_L3VPN_IPV6_UNICAST:    5,
	AFI_SAFI_TYPE_L3VPN_IPV4_MULTICAST:  6,
	AFI_SAFI_TYPE_L3VPN_IPV6_MULTICAST:  7,
	AFI_SAFI_TYPE_L2VPN_VPLS:            8,
	AFI_SAFI_TYPE_L2VPN_EVPN:            9,
	AFI_SAFI_TYPE_IPV4_MULTICAST:        10,
	AFI_SAFI_TYPE_IPV6_MULTICAST:        11,
	AFI_SAFI_TYPE_RTC:                   12,
	AFI_SAFI_TYPE_IPV4_ENCAP:            13,
	AFI_SAFI_TYPE_IPV6_ENCAP:            14,
	AFI_SAFI_TYPE_IPV4_FLOWSPEC:         15,
	AFI_SAFI_TYPE_L3VPN_IPV4_FLOWSPEC:   16,
	AFI_SAFI_TYPE_IPV6_FLOWSPEC:         17,
	AFI_SAFI_TYPE_L3VPN_IPV6_FLOWSPEC:   18,
	AFI_SAFI_TYPE_L2VPN_FLOWSPEC:        19,
	AFI_SAFI_TYPE_OPAQUE:                20,
}

func (v AfiSafiType) ToInt() int {
	i, ok := AfiSafiTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToAfiSafiTypeMap = map[int]AfiSafiType{
	0:  AFI_SAFI_TYPE_IPV4_UNICAST,
	1:  AFI_SAFI_TYPE_IPV6_UNICAST,
	2:  AFI_SAFI_TYPE_IPV4_LABELLED_UNICAST,
	3:  AFI_SAFI_TYPE_IPV6_LABELLED_UNICAST,
	4:  AFI_SAFI_TYPE_L3VPN_IPV4_UNICAST,
	5:  AFI_SAFI_TYPE_L3VPN_IPV6_UNICAST,
	6:  AFI_SAFI_TYPE_L3VPN_IPV4_MULTICAST,
	7:  AFI_SAFI_TYPE_L3VPN_IPV6_MULTICAST,
	8:  AFI_SAFI_TYPE_L2VPN_VPLS,
	9:  AFI_SAFI_TYPE_L2VPN_EVPN,
	10: AFI_SAFI_TYPE_IPV4_MULTICAST,
	11: AFI_SAFI_TYPE_IPV6_MULTICAST,
	12: AFI_SAFI_TYPE_RTC,
	13: AFI_SAFI_TYPE_IPV4_ENCAP,
	14: AFI_SAFI_TYPE_IPV6_ENCAP,
	15: AFI_SAFI_TYPE_IPV4_FLOWSPEC,
	16: AFI_SAFI_TYPE_L3VPN_IPV4_FLOWSPEC,
	17: AFI_SAFI_TYPE_IPV6_FLOWSPEC,
	18: AFI_SAFI_TYPE_L3VPN_IPV6_FLOWSPEC,
	19: AFI_SAFI_TYPE_L2VPN_FLOWSPEC,
	20: AFI_SAFI_TYPE_OPAQUE,
}

func (v AfiSafiType) Validate() error {
	if _, ok := AfiSafiTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid AfiSafiType: %s", v)
	}
	return nil
}

// typedef for identity bgp-types:bgp-capability
type BgpCapability string

const (
	BGP_CAPABILITY_MPBGP            BgpCapability = "mpbgp"
	BGP_CAPABILITY_ROUTE_REFRESH    BgpCapability = "route-refresh"
	BGP_CAPABILITY_ASN32            BgpCapability = "asn32"
	BGP_CAPABILITY_GRACEFUL_RESTART BgpCapability = "graceful-restart"
	BGP_CAPABILITY_ADD_PATHS        BgpCapability = "add-paths"
)

var BgpCapabilityToIntMap = map[BgpCapability]int{
	BGP_CAPABILITY_MPBGP:            0,
	BGP_CAPABILITY_ROUTE_REFRESH:    1,
	BGP_CAPABILITY_ASN32:            2,
	BGP_CAPABILITY_GRACEFUL_RESTART: 3,
	BGP_CAPABILITY_ADD_PATHS:        4,
}

func (v BgpCapability) ToInt() int {
	i, ok := BgpCapabilityToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToBgpCapabilityMap = map[int]BgpCapability{
	0: BGP_CAPABILITY_MPBGP,
	1: BGP_CAPABILITY_ROUTE_REFRESH,
	2: BGP_CAPABILITY_ASN32,
	3: BGP_CAPABILITY_GRACEFUL_RESTART,
	4: BGP_CAPABILITY_ADD_PATHS,
}

func (v BgpCapability) Validate() error {
	if _, ok := BgpCapabilityToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpCapability: %s", v)
	}
	return nil
}

// typedef for identity bgp-types:bgp-well-known-std-community
type BgpWellKnownStdCommunity string

const (
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT           BgpWellKnownStdCommunity = "no_export"
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_ADVERTISE        BgpWellKnownStdCommunity = "no_advertise"
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT_SUBCONFED BgpWellKnownStdCommunity = "no_export_subconfed"
	BGP_WELL_KNOWN_STD_COMMUNITY_NOPEER              BgpWellKnownStdCommunity = "nopeer"
)

var BgpWellKnownStdCommunityToIntMap = map[BgpWellKnownStdCommunity]int{
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT:           0,
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_ADVERTISE:        1,
	BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT_SUBCONFED: 2,
	BGP_WELL_KNOWN_STD_COMMUNITY_NOPEER:              3,
}

func (v BgpWellKnownStdCommunity) ToInt() int {
	i, ok := BgpWellKnownStdCommunityToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToBgpWellKnownStdCommunityMap = map[int]BgpWellKnownStdCommunity{
	0: BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT,
	1: BGP_WELL_KNOWN_STD_COMMUNITY_NO_ADVERTISE,
	2: BGP_WELL_KNOWN_STD_COMMUNITY_NO_EXPORT_SUBCONFED,
	3: BGP_WELL_KNOWN_STD_COMMUNITY_NOPEER,
}

func (v BgpWellKnownStdCommunity) Validate() error {
	if _, ok := BgpWellKnownStdCommunityToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpWellKnownStdCommunity: %s", v)
	}
	return nil
}

// typedef for identity ptypes:match-set-options-restricted-type
type MatchSetOptionsRestrictedType string

const (
	MATCH_SET_OPTIONS_RESTRICTED_TYPE_ANY    MatchSetOptionsRestrictedType = "any"
	MATCH_SET_OPTIONS_RESTRICTED_TYPE_INVERT MatchSetOptionsRestrictedType = "invert"
)

var MatchSetOptionsRestrictedTypeToIntMap = map[MatchSetOptionsRestrictedType]int{
	MATCH_SET_OPTIONS_RESTRICTED_TYPE_ANY:    0,
	MATCH_SET_OPTIONS_RESTRICTED_TYPE_INVERT: 1,
}

func (v MatchSetOptionsRestrictedType) ToInt() int {
	i, ok := MatchSetOptionsRestrictedTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToMatchSetOptionsRestrictedTypeMap = map[int]MatchSetOptionsRestrictedType{
	0: MATCH_SET_OPTIONS_RESTRICTED_TYPE_ANY,
	1: MATCH_SET_OPTIONS_RESTRICTED_TYPE_INVERT,
}

func (v MatchSetOptionsRestrictedType) Validate() error {
	if _, ok := MatchSetOptionsRestrictedTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid MatchSetOptionsRestrictedType: %s", v)
	}
	return nil
}

func (v MatchSetOptionsRestrictedType) Default() MatchSetOptionsRestrictedType {
	return MATCH_SET_OPTIONS_RESTRICTED_TYPE_ANY
}

func (v MatchSetOptionsRestrictedType) DefaultAsNeeded() MatchSetOptionsRestrictedType {
	if string(v) == "" {
		return v.Default()
	}
	return v
}

// typedef for identity ptypes:match-set-options-type
type MatchSetOptionsType string

const (
	MATCH_SET_OPTIONS_TYPE_ANY    MatchSetOptionsType = "any"
	MATCH_SET_OPTIONS_TYPE_ALL    MatchSetOptionsType = "all"
	MATCH_SET_OPTIONS_TYPE_INVERT MatchSetOptionsType = "invert"
)

var MatchSetOptionsTypeToIntMap = map[MatchSetOptionsType]int{
	MATCH_SET_OPTIONS_TYPE_ANY:    0,
	MATCH_SET_OPTIONS_TYPE_ALL:    1,
	MATCH_SET_OPTIONS_TYPE_INVERT: 2,
}

func (v MatchSetOptionsType) ToInt() int {
	i, ok := MatchSetOptionsTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToMatchSetOptionsTypeMap = map[int]MatchSetOptionsType{
	0: MATCH_SET_OPTIONS_TYPE_ANY,
	1: MATCH_SET_OPTIONS_TYPE_ALL,
	2: MATCH_SET_OPTIONS_TYPE_INVERT,
}

func (v MatchSetOptionsType) Validate() error {
	if _, ok := MatchSetOptionsTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid MatchSetOptionsType: %s", v)
	}
	return nil
}

func (v MatchSetOptionsType) Default() MatchSetOptionsType {
	return MATCH_SET_OPTIONS_TYPE_ANY
}

func (v MatchSetOptionsType) DefaultAsNeeded() MatchSetOptionsType {
	if string(v) == "" {
		return v.Default()
	}
	return v
}

// typedef for typedef ptypes:tag-type
type TagType string

// typedef for identity ptypes:install-protocol-type
type InstallProtocolType string

const (
	INSTALL_PROTOCOL_TYPE_BGP                InstallProtocolType = "bgp"
	INSTALL_PROTOCOL_TYPE_ISIS               InstallProtocolType = "isis"
	INSTALL_PROTOCOL_TYPE_OSPF               InstallProtocolType = "ospf"
	INSTALL_PROTOCOL_TYPE_OSPF3              InstallProtocolType = "ospf3"
	INSTALL_PROTOCOL_TYPE_STATIC             InstallProtocolType = "static"
	INSTALL_PROTOCOL_TYPE_DIRECTLY_CONNECTED InstallProtocolType = "directly-connected"
	INSTALL_PROTOCOL_TYPE_LOCAL_AGGREGATE    InstallProtocolType = "local-aggregate"
)

var InstallProtocolTypeToIntMap = map[InstallProtocolType]int{
	INSTALL_PROTOCOL_TYPE_BGP:                0,
	INSTALL_PROTOCOL_TYPE_ISIS:               1,
	INSTALL_PROTOCOL_TYPE_OSPF:               2,
	INSTALL_PROTOCOL_TYPE_OSPF3:              3,
	INSTALL_PROTOCOL_TYPE_STATIC:             4,
	INSTALL_PROTOCOL_TYPE_DIRECTLY_CONNECTED: 5,
	INSTALL_PROTOCOL_TYPE_LOCAL_AGGREGATE:    6,
}

func (v InstallProtocolType) ToInt() int {
	i, ok := InstallProtocolTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToInstallProtocolTypeMap = map[int]InstallProtocolType{
	0: INSTALL_PROTOCOL_TYPE_BGP,
	1: INSTALL_PROTOCOL_TYPE_ISIS,
	2: INSTALL_PROTOCOL_TYPE_OSPF,
	3: INSTALL_PROTOCOL_TYPE_OSPF3,
	4: INSTALL_PROTOCOL_TYPE_STATIC,
	5: INSTALL_PROTOCOL_TYPE_DIRECTLY_CONNECTED,
	6: INSTALL_PROTOCOL_TYPE_LOCAL_AGGREGATE,
}

func (v InstallProtocolType) Validate() error {
	if _, ok := InstallProtocolTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid InstallProtocolType: %s", v)
	}
	return nil
}

// typedef for identity ptypes:attribute-comparison
type AttributeComparison string

const (
	ATTRIBUTE_COMPARISON_ATTRIBUTE_EQ AttributeComparison = "attribute-eq"
	ATTRIBUTE_COMPARISON_ATTRIBUTE_GE AttributeComparison = "attribute-ge"
	ATTRIBUTE_COMPARISON_ATTRIBUTE_LE AttributeComparison = "attribute-le"
	ATTRIBUTE_COMPARISON_EQ           AttributeComparison = "eq"
	ATTRIBUTE_COMPARISON_GE           AttributeComparison = "ge"
	ATTRIBUTE_COMPARISON_LE           AttributeComparison = "le"
)

var AttributeComparisonToIntMap = map[AttributeComparison]int{
	ATTRIBUTE_COMPARISON_ATTRIBUTE_EQ: 0,
	ATTRIBUTE_COMPARISON_ATTRIBUTE_GE: 1,
	ATTRIBUTE_COMPARISON_ATTRIBUTE_LE: 2,
	ATTRIBUTE_COMPARISON_EQ:           3,
	ATTRIBUTE_COMPARISON_GE:           4,
	ATTRIBUTE_COMPARISON_LE:           5,
}

func (v AttributeComparison) ToInt() int {
	i, ok := AttributeComparisonToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToAttributeComparisonMap = map[int]AttributeComparison{
	0: ATTRIBUTE_COMPARISON_ATTRIBUTE_EQ,
	1: ATTRIBUTE_COMPARISON_ATTRIBUTE_GE,
	2: ATTRIBUTE_COMPARISON_ATTRIBUTE_LE,
	3: ATTRIBUTE_COMPARISON_EQ,
	4: ATTRIBUTE_COMPARISON_GE,
	5: ATTRIBUTE_COMPARISON_LE,
}

func (v AttributeComparison) Validate() error {
	if _, ok := AttributeComparisonToIntMap[v]; !ok {
		return fmt.Errorf("invalid AttributeComparison: %s", v)
	}
	return nil
}

// typedef for identity rpol:route-type
type RouteType string

const (
	ROUTE_TYPE_NONE     RouteType = "none"
	ROUTE_TYPE_INTERNAL RouteType = "internal"
	ROUTE_TYPE_EXTERNAL RouteType = "external"
	ROUTE_TYPE_LOCAL    RouteType = "local"
)

var RouteTypeToIntMap = map[RouteType]int{
	ROUTE_TYPE_NONE:     0,
	ROUTE_TYPE_INTERNAL: 1,
	ROUTE_TYPE_EXTERNAL: 2,
	ROUTE_TYPE_LOCAL:    3,
}

func (v RouteType) ToInt() int {
	i, ok := RouteTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToRouteTypeMap = map[int]RouteType{
	0: ROUTE_TYPE_NONE,
	1: ROUTE_TYPE_INTERNAL,
	2: ROUTE_TYPE_EXTERNAL,
	3: ROUTE_TYPE_LOCAL,
}

func (v RouteType) Validate() error {
	if _, ok := RouteTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid RouteType: %s", v)
	}
	return nil
}

// typedef for identity rpol:default-policy-type
type DefaultPolicyType string

const (
	DEFAULT_POLICY_TYPE_ACCEPT_ROUTE DefaultPolicyType = "accept-route"
	DEFAULT_POLICY_TYPE_REJECT_ROUTE DefaultPolicyType = "reject-route"
)

var DefaultPolicyTypeToIntMap = map[DefaultPolicyType]int{
	DEFAULT_POLICY_TYPE_ACCEPT_ROUTE: 0,
	DEFAULT_POLICY_TYPE_REJECT_ROUTE: 1,
}

func (v DefaultPolicyType) ToInt() int {
	i, ok := DefaultPolicyTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToDefaultPolicyTypeMap = map[int]DefaultPolicyType{
	0: DEFAULT_POLICY_TYPE_ACCEPT_ROUTE,
	1: DEFAULT_POLICY_TYPE_REJECT_ROUTE,
}

func (v DefaultPolicyType) Validate() error {
	if _, ok := DefaultPolicyTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid DefaultPolicyType: %s", v)
	}
	return nil
}

// typedef for identity bgp:session-state
type SessionState string

const (
	SESSION_STATE_IDLE        SessionState = "idle"
	SESSION_STATE_CONNECT     SessionState = "connect"
	SESSION_STATE_ACTIVE      SessionState = "active"
	SESSION_STATE_OPENSENT    SessionState = "opensent"
	SESSION_STATE_OPENCONFIRM SessionState = "openconfirm"
	SESSION_STATE_ESTABLISHED SessionState = "established"
)

var SessionStateToIntMap = map[SessionState]int{
	SESSION_STATE_IDLE:        0,
	SESSION_STATE_CONNECT:     1,
	SESSION_STATE_ACTIVE:      2,
	SESSION_STATE_OPENSENT:    3,
	SESSION_STATE_OPENCONFIRM: 4,
	SESSION_STATE_ESTABLISHED: 5,
}

func (v SessionState) ToInt() int {
	i, ok := SessionStateToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToSessionStateMap = map[int]SessionState{
	0: SESSION_STATE_IDLE,
	1: SESSION_STATE_CONNECT,
	2: SESSION_STATE_ACTIVE,
	3: SESSION_STATE_OPENSENT,
	4: SESSION_STATE_OPENCONFIRM,
	5: SESSION_STATE_ESTABLISHED,
}

func (v SessionState) Validate() error {
	if _, ok := SessionStateToIntMap[v]; !ok {
		return fmt.Errorf("invalid SessionState: %s", v)
	}
	return nil
}

// typedef for identity bgp:mode
type Mode string

const (
	MODE_HELPER_ONLY   Mode = "helper-only"
	MODE_BILATERAL     Mode = "bilateral"
	MODE_REMOTE_HELPER Mode = "remote-helper"
)

var ModeToIntMap = map[Mode]int{
	MODE_HELPER_ONLY:   0,
	MODE_BILATERAL:     1,
	MODE_REMOTE_HELPER: 2,
}

func (v Mode) ToInt() int {
	i, ok := ModeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToModeMap = map[int]Mode{
	0: MODE_HELPER_ONLY,
	1: MODE_BILATERAL,
	2: MODE_REMOTE_HELPER,
}

func (v Mode) Validate() error {
	if _, ok := ModeToIntMap[v]; !ok {
		return fmt.Errorf("invalid Mode: %s", v)
	}
	return nil
}

// typedef for typedef bgp-pol:bgp-next-hop-type
type BgpNextHopType string

// typedef for typedef bgp-pol:bgp-as-path-prepend-repeat
type BgpAsPathPrependRepeat uint8

// typedef for typedef bgp-pol:bgp-set-med-type
type BgpSetMedType string

// typedef for identity bgp-pol:bgp-set-community-option-type
type BgpSetCommunityOptionType string

const (
	BGP_SET_COMMUNITY_OPTION_TYPE_ADD     BgpSetCommunityOptionType = "add"
	BGP_SET_COMMUNITY_OPTION_TYPE_REMOVE  BgpSetCommunityOptionType = "remove"
	BGP_SET_COMMUNITY_OPTION_TYPE_REPLACE BgpSetCommunityOptionType = "replace"
)

var BgpSetCommunityOptionTypeToIntMap = map[BgpSetCommunityOptionType]int{
	BGP_SET_COMMUNITY_OPTION_TYPE_ADD:     0,
	BGP_SET_COMMUNITY_OPTION_TYPE_REMOVE:  1,
	BGP_SET_COMMUNITY_OPTION_TYPE_REPLACE: 2,
}

func (v BgpSetCommunityOptionType) ToInt() int {
	i, ok := BgpSetCommunityOptionTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToBgpSetCommunityOptionTypeMap = map[int]BgpSetCommunityOptionType{
	0: BGP_SET_COMMUNITY_OPTION_TYPE_ADD,
	1: BGP_SET_COMMUNITY_OPTION_TYPE_REMOVE,
	2: BGP_SET_COMMUNITY_OPTION_TYPE_REPLACE,
}

func (v BgpSetCommunityOptionType) Validate() error {
	if _, ok := BgpSetCommunityOptionTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid BgpSetCommunityOptionType: %s", v)
	}
	return nil
}

// typedef for identity gobgp:bmp-route-monitoring-policy-type
type BmpRouteMonitoringPolicyType string

const (
	BMP_ROUTE_MONITORING_POLICY_TYPE_PRE_POLICY  BmpRouteMonitoringPolicyType = "pre-policy"
	BMP_ROUTE_MONITORING_POLICY_TYPE_POST_POLICY BmpRouteMonitoringPolicyType = "post-policy"
	BMP_ROUTE_MONITORING_POLICY_TYPE_BOTH        BmpRouteMonitoringPolicyType = "both"
)

var BmpRouteMonitoringPolicyTypeToIntMap = map[BmpRouteMonitoringPolicyType]int{
	BMP_ROUTE_MONITORING_POLICY_TYPE_PRE_POLICY:  0,
	BMP_ROUTE_MONITORING_POLICY_TYPE_POST_POLICY: 1,
	BMP_ROUTE_MONITORING_POLICY_TYPE_BOTH:        2,
}

func (v BmpRouteMonitoringPolicyType) ToInt() int {
	i, ok := BmpRouteMonitoringPolicyTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToBmpRouteMonitoringPolicyTypeMap = map[int]BmpRouteMonitoringPolicyType{
	0: BMP_ROUTE_MONITORING_POLICY_TYPE_PRE_POLICY,
	1: BMP_ROUTE_MONITORING_POLICY_TYPE_POST_POLICY,
	2: BMP_ROUTE_MONITORING_POLICY_TYPE_BOTH,
}

func (v BmpRouteMonitoringPolicyType) Validate() error {
	if _, ok := BmpRouteMonitoringPolicyTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid BmpRouteMonitoringPolicyType: %s", v)
	}
	return nil
}

// typedef for identity gobgp:mrt-type
type MrtType string

const (
	MRT_TYPE_UPDATES MrtType = "updates"
	MRT_TYPE_TABLE   MrtType = "table"
)

var MrtTypeToIntMap = map[MrtType]int{
	MRT_TYPE_UPDATES: 0,
	MRT_TYPE_TABLE:   1,
}

func (v MrtType) ToInt() int {
	i, ok := MrtTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToMrtTypeMap = map[int]MrtType{
	0: MRT_TYPE_UPDATES,
	1: MRT_TYPE_TABLE,
}

func (v MrtType) Validate() error {
	if _, ok := MrtTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid MrtType: %s", v)
	}
	return nil
}

// typedef for identity gobgp:rpki-validation-result-type
type RpkiValidationResultType string

const (
	RPKI_VALIDATION_RESULT_TYPE_NONE      RpkiValidationResultType = "none"
	RPKI_VALIDATION_RESULT_TYPE_NOT_FOUND RpkiValidationResultType = "not-found"
	RPKI_VALIDATION_RESULT_TYPE_VALID     RpkiValidationResultType = "valid"
	RPKI_VALIDATION_RESULT_TYPE_INVALID   RpkiValidationResultType = "invalid"
)

var RpkiValidationResultTypeToIntMap = map[RpkiValidationResultType]int{
	RPKI_VALIDATION_RESULT_TYPE_NONE:      0,
	RPKI_VALIDATION_RESULT_TYPE_NOT_FOUND: 1,
	RPKI_VALIDATION_RESULT_TYPE_VALID:     2,
	RPKI_VALIDATION_RESULT_TYPE_INVALID:   3,
}

func (v RpkiValidationResultType) ToInt() int {
	i, ok := RpkiValidationResultTypeToIntMap[v]
	if !ok {
		return -1
	}
	return i
}

var IntToRpkiValidationResultTypeMap = map[int]RpkiValidationResultType{
	0: RPKI_VALIDATION_RESULT_TYPE_NONE,
	1: RPKI_VALIDATION_RESULT_TYPE_NOT_FOUND,
	2: RPKI_VALIDATION_RESULT_TYPE_VALID,
	3: RPKI_VALIDATION_RESULT_TYPE_INVALID,
}

func (v RpkiValidationResultType) Validate() error {
	if _, ok := RpkiValidationResultTypeToIntMap[v]; !ok {
		return fmt.Errorf("invalid RpkiValidationResultType: %s", v)
	}
	return nil
}

//struct for container gobgp:state
type CollectorState struct {
	// original -> gobgp:url
	Url string `mapstructure:"url"`
	// original -> gobgp:db-name
	DbName string `mapstructure:"db-name"`
	// original -> gobgp:table-dump-interval
	TableDumpInterval uint64 `mapstructure:"table-dump-interval"`
}

func (lhs *CollectorState) Equal(rhs *CollectorState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Url != rhs.Url {
		return false
	}
	if lhs.DbName != rhs.DbName {
		return false
	}
	if lhs.TableDumpInterval != rhs.TableDumpInterval {
		return false
	}
	return true
}

//struct for container gobgp:config
type CollectorConfig struct {
	// original -> gobgp:url
	Url string `mapstructure:"url"`
	// original -> gobgp:db-name
	DbName string `mapstructure:"db-name"`
	// original -> gobgp:table-dump-interval
	TableDumpInterval uint64 `mapstructure:"table-dump-interval"`
}

func (lhs *CollectorConfig) Equal(rhs *CollectorConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Url != rhs.Url {
		return false
	}
	if lhs.DbName != rhs.DbName {
		return false
	}
	if lhs.TableDumpInterval != rhs.TableDumpInterval {
		return false
	}
	return true
}

//struct for container gobgp:collector
type Collector struct {
	// original -> gobgp:collector-config
	Config CollectorConfig `mapstructure:"config"`
	// original -> gobgp:collector-state
	State CollectorState `mapstructure:"state"`
}

func (lhs *Collector) Equal(rhs *Collector) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container gobgp:state
type ZebraState struct {
	// original -> gobgp:enabled
	//gobgp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> gobgp:url
	Url string `mapstructure:"url"`
	// original -> gobgp:redistribute-route-type
	RedistributeRouteTypeList []InstallProtocolType `mapstructure:"redistribute-route-type-list"`
	// original -> gobgp:version
	Version uint8 `mapstructure:"version"`
}

func (lhs *ZebraState) Equal(rhs *ZebraState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.Url != rhs.Url {
		return false
	}
	if len(lhs.RedistributeRouteTypeList) != len(rhs.RedistributeRouteTypeList) {
		return false
	}
	for idx, l := range lhs.RedistributeRouteTypeList {
		if l != rhs.RedistributeRouteTypeList[idx] {
			return false
		}
	}
	if lhs.Version != rhs.Version {
		return false
	}
	return true
}

//struct for container gobgp:config
type ZebraConfig struct {
	// original -> gobgp:enabled
	//gobgp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> gobgp:url
	Url string `mapstructure:"url"`
	// original -> gobgp:redistribute-route-type
	RedistributeRouteTypeList []InstallProtocolType `mapstructure:"redistribute-route-type-list"`
	// original -> gobgp:version
	Version uint8 `mapstructure:"version"`
}

func (lhs *ZebraConfig) Equal(rhs *ZebraConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.Url != rhs.Url {
		return false
	}
	if len(lhs.RedistributeRouteTypeList) != len(rhs.RedistributeRouteTypeList) {
		return false
	}
	for idx, l := range lhs.RedistributeRouteTypeList {
		if l != rhs.RedistributeRouteTypeList[idx] {
			return false
		}
	}
	if lhs.Version != rhs.Version {
		return false
	}
	return true
}

//struct for container gobgp:zebra
type Zebra struct {
	// original -> gobgp:zebra-config
	Config ZebraConfig `mapstructure:"config"`
	// original -> gobgp:zebra-state
	State ZebraState `mapstructure:"state"`
}

func (lhs *Zebra) Equal(rhs *Zebra) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container gobgp:config
type MrtConfig struct {
	// original -> gobgp:dump-type
	DumpType MrtType `mapstructure:"dump-type"`
	// original -> gobgp:file-name
	FileName string `mapstructure:"file-name"`
	// original -> gobgp:table-name
	TableName string `mapstructure:"table-name"`
	// original -> gobgp:dump-interval
	DumpInterval uint64 `mapstructure:"dump-interval"`
	// original -> gobgp:rotation-interval
	RotationInterval uint64 `mapstructure:"rotation-interval"`
}

func (lhs *MrtConfig) Equal(rhs *MrtConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.DumpType != rhs.DumpType {
		return false
	}
	if lhs.FileName != rhs.FileName {
		return false
	}
	if lhs.TableName != rhs.TableName {
		return false
	}
	if lhs.DumpInterval != rhs.DumpInterval {
		return false
	}
	if lhs.RotationInterval != rhs.RotationInterval {
		return false
	}
	return true
}

//struct for container gobgp:mrt
type Mrt struct {
	// original -> gobgp:file-name
	// original -> gobgp:mrt-config
	Config MrtConfig `mapstructure:"config"`
}

func (lhs *Mrt) Equal(rhs *Mrt) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container gobgp:state
type BmpServerState struct {
}

func (lhs *BmpServerState) Equal(rhs *BmpServerState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	return true
}

//struct for container gobgp:config
type BmpServerConfig struct {
	// original -> gobgp:address
	//gobgp:address's original type is inet:ip-address
	Address string `mapstructure:"address"`
	// original -> gobgp:port
	Port uint32 `mapstructure:"port"`
	// original -> gobgp:route-monitoring-policy
	RouteMonitoringPolicy BmpRouteMonitoringPolicyType `mapstructure:"route-monitoring-policy"`
}

func (lhs *BmpServerConfig) Equal(rhs *BmpServerConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Address != rhs.Address {
		return false
	}
	if lhs.Port != rhs.Port {
		return false
	}
	if lhs.RouteMonitoringPolicy != rhs.RouteMonitoringPolicy {
		return false
	}
	return true
}

//struct for container gobgp:bmp-server
type BmpServer struct {
	// original -> gobgp:address
	// original -> gobgp:bmp-server-config
	Config BmpServerConfig `mapstructure:"config"`
	// original -> gobgp:bmp-server-state
	State BmpServerState `mapstructure:"state"`
}

func (lhs *BmpServer) Equal(rhs *BmpServer) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container gobgp:rpki-received
type RpkiReceived struct {
	// original -> gobgp:serial-notify
	SerialNotify int64 `mapstructure:"serial-notify"`
	// original -> gobgp:cache-reset
	CacheReset int64 `mapstructure:"cache-reset"`
	// original -> gobgp:cache-response
	CacheResponse int64 `mapstructure:"cache-response"`
	// original -> gobgp:ipv4-prefix
	Ipv4Prefix int64 `mapstructure:"ipv4-prefix"`
	// original -> gobgp:ipv6-prefix
	Ipv6Prefix int64 `mapstructure:"ipv6-prefix"`
	// original -> gobgp:end-of-data
	EndOfData int64 `mapstructure:"end-of-data"`
	// original -> gobgp:error
	Error int64 `mapstructure:"error"`
}

func (lhs *RpkiReceived) Equal(rhs *RpkiReceived) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SerialNotify != rhs.SerialNotify {
		return false
	}
	if lhs.CacheReset != rhs.CacheReset {
		return false
	}
	if lhs.CacheResponse != rhs.CacheResponse {
		return false
	}
	if lhs.Ipv4Prefix != rhs.Ipv4Prefix {
		return false
	}
	if lhs.Ipv6Prefix != rhs.Ipv6Prefix {
		return false
	}
	if lhs.EndOfData != rhs.EndOfData {
		return false
	}
	if lhs.Error != rhs.Error {
		return false
	}
	return true
}

//struct for container gobgp:rpki-sent
type RpkiSent struct {
	// original -> gobgp:serial-query
	SerialQuery int64 `mapstructure:"serial-query"`
	// original -> gobgp:reset-query
	ResetQuery int64 `mapstructure:"reset-query"`
	// original -> gobgp:error
	Error int64 `mapstructure:"error"`
}

func (lhs *RpkiSent) Equal(rhs *RpkiSent) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SerialQuery != rhs.SerialQuery {
		return false
	}
	if lhs.ResetQuery != rhs.ResetQuery {
		return false
	}
	if lhs.Error != rhs.Error {
		return false
	}
	return true
}

//struct for container gobgp:rpki-messages
type RpkiMessages struct {
	// original -> gobgp:rpki-sent
	RpkiSent RpkiSent `mapstructure:"rpki-sent"`
	// original -> gobgp:rpki-received
	RpkiReceived RpkiReceived `mapstructure:"rpki-received"`
}

func (lhs *RpkiMessages) Equal(rhs *RpkiMessages) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.RpkiSent.Equal(&(rhs.RpkiSent)) {
		return false
	}
	if !lhs.RpkiReceived.Equal(&(rhs.RpkiReceived)) {
		return false
	}
	return true
}

//struct for container gobgp:state
type RpkiServerState struct {
	// original -> gobgp:up
	//gobgp:up's original type is boolean
	Up bool `mapstructure:"up"`
	// original -> gobgp:serial-number
	SerialNumber uint32 `mapstructure:"serial-number"`
	// original -> gobgp:records-v4
	RecordsV4 uint32 `mapstructure:"records-v4"`
	// original -> gobgp:records-v6
	RecordsV6 uint32 `mapstructure:"records-v6"`
	// original -> gobgp:prefixes-v4
	PrefixesV4 uint32 `mapstructure:"prefixes-v4"`
	// original -> gobgp:prefixes-v6
	PrefixesV6 uint32 `mapstructure:"prefixes-v6"`
	// original -> gobgp:uptime
	Uptime int64 `mapstructure:"uptime"`
	// original -> gobgp:downtime
	Downtime int64 `mapstructure:"downtime"`
	// original -> gobgp:last-pdu-recv-time
	LastPduRecvTime int64 `mapstructure:"last-pdu-recv-time"`
	// original -> gobgp:rpki-messages
	RpkiMessages RpkiMessages `mapstructure:"rpki-messages"`
}

func (lhs *RpkiServerState) Equal(rhs *RpkiServerState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Up != rhs.Up {
		return false
	}
	if lhs.SerialNumber != rhs.SerialNumber {
		return false
	}
	if lhs.RecordsV4 != rhs.RecordsV4 {
		return false
	}
	if lhs.RecordsV6 != rhs.RecordsV6 {
		return false
	}
	if lhs.PrefixesV4 != rhs.PrefixesV4 {
		return false
	}
	if lhs.PrefixesV6 != rhs.PrefixesV6 {
		return false
	}
	if lhs.Uptime != rhs.Uptime {
		return false
	}
	if lhs.Downtime != rhs.Downtime {
		return false
	}
	if lhs.LastPduRecvTime != rhs.LastPduRecvTime {
		return false
	}
	if !lhs.RpkiMessages.Equal(&(rhs.RpkiMessages)) {
		return false
	}
	return true
}

//struct for container gobgp:config
type RpkiServerConfig struct {
	// original -> gobgp:address
	//gobgp:address's original type is inet:ip-address
	Address string `mapstructure:"address"`
	// original -> gobgp:port
	Port uint32 `mapstructure:"port"`
	// original -> gobgp:refresh-time
	RefreshTime int64 `mapstructure:"refresh-time"`
	// original -> gobgp:hold-time
	HoldTime int64 `mapstructure:"hold-time"`
	// original -> gobgp:record-lifetime
	RecordLifetime int64 `mapstructure:"record-lifetime"`
	// original -> gobgp:preference
	Preference uint8 `mapstructure:"preference"`
}

func (lhs *RpkiServerConfig) Equal(rhs *RpkiServerConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Address != rhs.Address {
		return false
	}
	if lhs.Port != rhs.Port {
		return false
	}
	if lhs.RefreshTime != rhs.RefreshTime {
		return false
	}
	if lhs.HoldTime != rhs.HoldTime {
		return false
	}
	if lhs.RecordLifetime != rhs.RecordLifetime {
		return false
	}
	if lhs.Preference != rhs.Preference {
		return false
	}
	return true
}

//struct for container gobgp:rpki-server
type RpkiServer struct {
	// original -> gobgp:address
	// original -> gobgp:rpki-server-config
	Config RpkiServerConfig `mapstructure:"config"`
	// original -> gobgp:rpki-server-state
	State RpkiServerState `mapstructure:"state"`
}

func (lhs *RpkiServer) Equal(rhs *RpkiServer) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type PeerGroupState struct {
	// original -> bgp:peer-as
	//bgp:peer-as's original type is inet:as-number
	PeerAs uint32 `mapstructure:"peer-as"`
	// original -> bgp:local-as
	//bgp:local-as's original type is inet:as-number
	LocalAs uint32 `mapstructure:"local-as"`
	// original -> bgp:peer-type
	PeerType PeerType `mapstructure:"peer-type"`
	// original -> bgp:auth-password
	AuthPassword string `mapstructure:"auth-password"`
	// original -> bgp:remove-private-as
	RemovePrivateAs RemovePrivateAsOption `mapstructure:"remove-private-as"`
	// original -> bgp:route-flap-damping
	//bgp:route-flap-damping's original type is boolean
	RouteFlapDamping bool `mapstructure:"route-flap-damping"`
	// original -> bgp:send-community
	SendCommunity CommunityType `mapstructure:"send-community"`
	// original -> bgp:description
	Description string `mapstructure:"description"`
	// original -> bgp:peer-group-name
	PeerGroupName string `mapstructure:"peer-group-name"`
	// original -> bgp-op:total-paths
	TotalPaths uint32 `mapstructure:"total-paths"`
	// original -> bgp-op:total-prefixes
	TotalPrefixes uint32 `mapstructure:"total-prefixes"`
}

func (lhs *PeerGroupState) Equal(rhs *PeerGroupState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PeerAs != rhs.PeerAs {
		return false
	}
	if lhs.LocalAs != rhs.LocalAs {
		return false
	}
	if lhs.PeerType != rhs.PeerType {
		return false
	}
	if lhs.AuthPassword != rhs.AuthPassword {
		return false
	}
	if lhs.RemovePrivateAs != rhs.RemovePrivateAs {
		return false
	}
	if lhs.RouteFlapDamping != rhs.RouteFlapDamping {
		return false
	}
	if lhs.SendCommunity != rhs.SendCommunity {
		return false
	}
	if lhs.Description != rhs.Description {
		return false
	}
	if lhs.PeerGroupName != rhs.PeerGroupName {
		return false
	}
	if lhs.TotalPaths != rhs.TotalPaths {
		return false
	}
	if lhs.TotalPrefixes != rhs.TotalPrefixes {
		return false
	}
	return true
}

//struct for container bgp:config
type PeerGroupConfig struct {
	// original -> bgp:peer-as
	//bgp:peer-as's original type is inet:as-number
	PeerAs uint32 `mapstructure:"peer-as"`
	// original -> bgp:local-as
	//bgp:local-as's original type is inet:as-number
	LocalAs uint32 `mapstructure:"local-as"`
	// original -> bgp:peer-type
	PeerType PeerType `mapstructure:"peer-type"`
	// original -> bgp:auth-password
	AuthPassword string `mapstructure:"auth-password"`
	// original -> bgp:remove-private-as
	RemovePrivateAs RemovePrivateAsOption `mapstructure:"remove-private-as"`
	// original -> bgp:route-flap-damping
	//bgp:route-flap-damping's original type is boolean
	RouteFlapDamping bool `mapstructure:"route-flap-damping"`
	// original -> bgp:send-community
	SendCommunity CommunityType `mapstructure:"send-community"`
	// original -> bgp:description
	Description string `mapstructure:"description"`
	// original -> bgp:peer-group-name
	PeerGroupName string `mapstructure:"peer-group-name"`
}

func (lhs *PeerGroupConfig) Equal(rhs *PeerGroupConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PeerAs != rhs.PeerAs {
		return false
	}
	if lhs.LocalAs != rhs.LocalAs {
		return false
	}
	if lhs.PeerType != rhs.PeerType {
		return false
	}
	if lhs.AuthPassword != rhs.AuthPassword {
		return false
	}
	if lhs.RemovePrivateAs != rhs.RemovePrivateAs {
		return false
	}
	if lhs.RouteFlapDamping != rhs.RouteFlapDamping {
		return false
	}
	if lhs.SendCommunity != rhs.SendCommunity {
		return false
	}
	if lhs.Description != rhs.Description {
		return false
	}
	if lhs.PeerGroupName != rhs.PeerGroupName {
		return false
	}
	return true
}

//struct for container bgp:peer-group
type PeerGroup struct {
	// original -> bgp:peer-group-name
	// original -> bgp:peer-group-config
	Config PeerGroupConfig `mapstructure:"config"`
	// original -> bgp:peer-group-state
	State PeerGroupState `mapstructure:"state"`
	// original -> bgp:timers
	Timers Timers `mapstructure:"timers"`
	// original -> bgp:transport
	Transport Transport `mapstructure:"transport"`
	// original -> bgp:error-handling
	ErrorHandling ErrorHandling `mapstructure:"error-handling"`
	// original -> bgp:logging-options
	LoggingOptions LoggingOptions `mapstructure:"logging-options"`
	// original -> bgp:ebgp-multihop
	EbgpMultihop EbgpMultihop `mapstructure:"ebgp-multihop"`
	// original -> bgp:route-reflector
	RouteReflector RouteReflector `mapstructure:"route-reflector"`
	// original -> bgp:as-path-options
	AsPathOptions AsPathOptions `mapstructure:"as-path-options"`
	// original -> bgp:add-paths
	AddPaths AddPaths `mapstructure:"add-paths"`
	// original -> bgp:afi-safis
	AfiSafis []AfiSafi `mapstructure:"afi-safis"`
	// original -> bgp:graceful-restart
	GracefulRestart GracefulRestart `mapstructure:"graceful-restart"`
	// original -> rpol:apply-policy
	ApplyPolicy ApplyPolicy `mapstructure:"apply-policy"`
	// original -> bgp-mp:use-multiple-paths
	UseMultiplePaths UseMultiplePaths `mapstructure:"use-multiple-paths"`
	// original -> gobgp:route-server
	RouteServer RouteServer `mapstructure:"route-server"`
}

func (lhs *PeerGroup) Equal(rhs *PeerGroup) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.Timers.Equal(&(rhs.Timers)) {
		return false
	}
	if !lhs.Transport.Equal(&(rhs.Transport)) {
		return false
	}
	if !lhs.ErrorHandling.Equal(&(rhs.ErrorHandling)) {
		return false
	}
	if !lhs.LoggingOptions.Equal(&(rhs.LoggingOptions)) {
		return false
	}
	if !lhs.EbgpMultihop.Equal(&(rhs.EbgpMultihop)) {
		return false
	}
	if !lhs.RouteReflector.Equal(&(rhs.RouteReflector)) {
		return false
	}
	if !lhs.AsPathOptions.Equal(&(rhs.AsPathOptions)) {
		return false
	}
	if !lhs.AddPaths.Equal(&(rhs.AddPaths)) {
		return false
	}
	if len(lhs.AfiSafis) != len(rhs.AfiSafis) {
		return false
	}
	{
		lmap := make(map[string]*AfiSafi)
		for i, l := range lhs.AfiSafis {
			lmap[mapkey(i, string(l.Config.AfiSafiName))] = &lhs.AfiSafis[i]
		}
		for i, r := range rhs.AfiSafis {
			if l, y := lmap[mapkey(i, string(r.Config.AfiSafiName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.GracefulRestart.Equal(&(rhs.GracefulRestart)) {
		return false
	}
	if !lhs.ApplyPolicy.Equal(&(rhs.ApplyPolicy)) {
		return false
	}
	if !lhs.UseMultiplePaths.Equal(&(rhs.UseMultiplePaths)) {
		return false
	}
	if !lhs.RouteServer.Equal(&(rhs.RouteServer)) {
		return false
	}
	return true
}

//struct for container gobgp:state
type RouteServerState struct {
	// original -> gobgp:route-server-client
	//gobgp:route-server-client's original type is boolean
	RouteServerClient bool `mapstructure:"route-server-client"`
}

func (lhs *RouteServerState) Equal(rhs *RouteServerState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RouteServerClient != rhs.RouteServerClient {
		return false
	}
	return true
}

//struct for container gobgp:config
type RouteServerConfig struct {
	// original -> gobgp:route-server-client
	//gobgp:route-server-client's original type is boolean
	RouteServerClient bool `mapstructure:"route-server-client"`
}

func (lhs *RouteServerConfig) Equal(rhs *RouteServerConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RouteServerClient != rhs.RouteServerClient {
		return false
	}
	return true
}

//struct for container gobgp:route-server
type RouteServer struct {
	// original -> gobgp:route-server-config
	Config RouteServerConfig `mapstructure:"config"`
	// original -> gobgp:route-server-state
	State RouteServerState `mapstructure:"state"`
}

func (lhs *RouteServer) Equal(rhs *RouteServer) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-op:prefixes
type Prefixes struct {
	// original -> bgp-op:received
	Received uint32 `mapstructure:"received"`
	// original -> bgp-op:sent
	Sent uint32 `mapstructure:"sent"`
	// original -> bgp-op:installed
	Installed uint32 `mapstructure:"installed"`
}

func (lhs *Prefixes) Equal(rhs *Prefixes) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Received != rhs.Received {
		return false
	}
	if lhs.Sent != rhs.Sent {
		return false
	}
	if lhs.Installed != rhs.Installed {
		return false
	}
	return true
}

//struct for container bgp:state
type AddPathsState struct {
	// original -> bgp:receive
	//bgp:receive's original type is boolean
	Receive bool `mapstructure:"receive"`
	// original -> bgp:send-max
	SendMax uint8 `mapstructure:"send-max"`
}

func (lhs *AddPathsState) Equal(rhs *AddPathsState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Receive != rhs.Receive {
		return false
	}
	if lhs.SendMax != rhs.SendMax {
		return false
	}
	return true
}

//struct for container bgp:config
type AddPathsConfig struct {
	// original -> bgp:receive
	//bgp:receive's original type is boolean
	Receive bool `mapstructure:"receive"`
	// original -> bgp:send-max
	SendMax uint8 `mapstructure:"send-max"`
}

func (lhs *AddPathsConfig) Equal(rhs *AddPathsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Receive != rhs.Receive {
		return false
	}
	if lhs.SendMax != rhs.SendMax {
		return false
	}
	return true
}

//struct for container bgp:add-paths
type AddPaths struct {
	// original -> bgp:add-paths-config
	Config AddPathsConfig `mapstructure:"config"`
	// original -> bgp:add-paths-state
	State AddPathsState `mapstructure:"state"`
}

func (lhs *AddPaths) Equal(rhs *AddPaths) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type AsPathOptionsState struct {
	// original -> bgp:allow-own-as
	AllowOwnAs uint8 `mapstructure:"allow-own-as"`
	// original -> bgp:replace-peer-as
	//bgp:replace-peer-as's original type is boolean
	ReplacePeerAs bool `mapstructure:"replace-peer-as"`
}

func (lhs *AsPathOptionsState) Equal(rhs *AsPathOptionsState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AllowOwnAs != rhs.AllowOwnAs {
		return false
	}
	if lhs.ReplacePeerAs != rhs.ReplacePeerAs {
		return false
	}
	return true
}

//struct for container bgp:config
type AsPathOptionsConfig struct {
	// original -> bgp:allow-own-as
	AllowOwnAs uint8 `mapstructure:"allow-own-as"`
	// original -> bgp:replace-peer-as
	//bgp:replace-peer-as's original type is boolean
	ReplacePeerAs bool `mapstructure:"replace-peer-as"`
}

func (lhs *AsPathOptionsConfig) Equal(rhs *AsPathOptionsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AllowOwnAs != rhs.AllowOwnAs {
		return false
	}
	if lhs.ReplacePeerAs != rhs.ReplacePeerAs {
		return false
	}
	return true
}

//struct for container bgp:as-path-options
type AsPathOptions struct {
	// original -> bgp:as-path-options-config
	Config AsPathOptionsConfig `mapstructure:"config"`
	// original -> bgp:as-path-options-state
	State AsPathOptionsState `mapstructure:"state"`
}

func (lhs *AsPathOptions) Equal(rhs *AsPathOptions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type RouteReflectorState struct {
	// original -> bgp:route-reflector-cluster-id
	RouteReflectorClusterId RrClusterIdType `mapstructure:"route-reflector-cluster-id"`
	// original -> bgp:route-reflector-client
	//bgp:route-reflector-client's original type is boolean
	RouteReflectorClient bool `mapstructure:"route-reflector-client"`
}

func (lhs *RouteReflectorState) Equal(rhs *RouteReflectorState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RouteReflectorClusterId != rhs.RouteReflectorClusterId {
		return false
	}
	if lhs.RouteReflectorClient != rhs.RouteReflectorClient {
		return false
	}
	return true
}

//struct for container bgp:config
type RouteReflectorConfig struct {
	// original -> bgp:route-reflector-cluster-id
	RouteReflectorClusterId RrClusterIdType `mapstructure:"route-reflector-cluster-id"`
	// original -> bgp:route-reflector-client
	//bgp:route-reflector-client's original type is boolean
	RouteReflectorClient bool `mapstructure:"route-reflector-client"`
}

func (lhs *RouteReflectorConfig) Equal(rhs *RouteReflectorConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RouteReflectorClusterId != rhs.RouteReflectorClusterId {
		return false
	}
	if lhs.RouteReflectorClient != rhs.RouteReflectorClient {
		return false
	}
	return true
}

//struct for container bgp:route-reflector
type RouteReflector struct {
	// original -> bgp:route-reflector-config
	Config RouteReflectorConfig `mapstructure:"config"`
	// original -> bgp:route-reflector-state
	State RouteReflectorState `mapstructure:"state"`
}

func (lhs *RouteReflector) Equal(rhs *RouteReflector) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type EbgpMultihopState struct {
	// original -> bgp:enabled
	//bgp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> bgp:multihop-ttl
	MultihopTtl uint8 `mapstructure:"multihop-ttl"`
}

func (lhs *EbgpMultihopState) Equal(rhs *EbgpMultihopState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.MultihopTtl != rhs.MultihopTtl {
		return false
	}
	return true
}

//struct for container bgp:config
type EbgpMultihopConfig struct {
	// original -> bgp:enabled
	//bgp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> bgp:multihop-ttl
	MultihopTtl uint8 `mapstructure:"multihop-ttl"`
}

func (lhs *EbgpMultihopConfig) Equal(rhs *EbgpMultihopConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.MultihopTtl != rhs.MultihopTtl {
		return false
	}
	return true
}

//struct for container bgp:ebgp-multihop
type EbgpMultihop struct {
	// original -> bgp:ebgp-multihop-config
	Config EbgpMultihopConfig `mapstructure:"config"`
	// original -> bgp:ebgp-multihop-state
	State EbgpMultihopState `mapstructure:"state"`
}

func (lhs *EbgpMultihop) Equal(rhs *EbgpMultihop) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type LoggingOptionsState struct {
	// original -> bgp:log-neighbor-state-changes
	//bgp:log-neighbor-state-changes's original type is boolean
	LogNeighborStateChanges bool `mapstructure:"log-neighbor-state-changes"`
}

func (lhs *LoggingOptionsState) Equal(rhs *LoggingOptionsState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.LogNeighborStateChanges != rhs.LogNeighborStateChanges {
		return false
	}
	return true
}

//struct for container bgp:config
type LoggingOptionsConfig struct {
	// original -> bgp:log-neighbor-state-changes
	//bgp:log-neighbor-state-changes's original type is boolean
	LogNeighborStateChanges bool `mapstructure:"log-neighbor-state-changes"`
}

func (lhs *LoggingOptionsConfig) Equal(rhs *LoggingOptionsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.LogNeighborStateChanges != rhs.LogNeighborStateChanges {
		return false
	}
	return true
}

//struct for container bgp:logging-options
type LoggingOptions struct {
	// original -> bgp:logging-options-config
	Config LoggingOptionsConfig `mapstructure:"config"`
	// original -> bgp:logging-options-state
	State LoggingOptionsState `mapstructure:"state"`
}

func (lhs *LoggingOptions) Equal(rhs *LoggingOptions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type ErrorHandlingState struct {
	// original -> bgp:treat-as-withdraw
	//bgp:treat-as-withdraw's original type is boolean
	TreatAsWithdraw bool `mapstructure:"treat-as-withdraw"`
	// original -> bgp-op:erroneous-update-messages
	ErroneousUpdateMessages uint32 `mapstructure:"erroneous-update-messages"`
}

func (lhs *ErrorHandlingState) Equal(rhs *ErrorHandlingState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TreatAsWithdraw != rhs.TreatAsWithdraw {
		return false
	}
	if lhs.ErroneousUpdateMessages != rhs.ErroneousUpdateMessages {
		return false
	}
	return true
}

//struct for container bgp:config
type ErrorHandlingConfig struct {
	// original -> bgp:treat-as-withdraw
	//bgp:treat-as-withdraw's original type is boolean
	TreatAsWithdraw bool `mapstructure:"treat-as-withdraw"`
}

func (lhs *ErrorHandlingConfig) Equal(rhs *ErrorHandlingConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TreatAsWithdraw != rhs.TreatAsWithdraw {
		return false
	}
	return true
}

//struct for container bgp:error-handling
type ErrorHandling struct {
	// original -> bgp:error-handling-config
	Config ErrorHandlingConfig `mapstructure:"config"`
	// original -> bgp:error-handling-state
	State ErrorHandlingState `mapstructure:"state"`
}

func (lhs *ErrorHandling) Equal(rhs *ErrorHandling) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type TransportState struct {
	// original -> bgp:tcp-mss
	TcpMss uint16 `mapstructure:"tcp-mss"`
	// original -> bgp:mtu-discovery
	//bgp:mtu-discovery's original type is boolean
	MtuDiscovery bool `mapstructure:"mtu-discovery"`
	// original -> bgp:passive-mode
	//bgp:passive-mode's original type is boolean
	PassiveMode bool `mapstructure:"passive-mode"`
	// original -> bgp:local-address
	//bgp:local-address's original type is union
	LocalAddress string `mapstructure:"local-address"`
	// original -> bgp-op:local-port
	//bgp-op:local-port's original type is inet:port-number
	LocalPort uint16 `mapstructure:"local-port"`
	// original -> bgp-op:remote-address
	//bgp-op:remote-address's original type is inet:ip-address
	RemoteAddress string `mapstructure:"remote-address"`
	// original -> bgp-op:remote-port
	//bgp-op:remote-port's original type is inet:port-number
	RemotePort uint16 `mapstructure:"remote-port"`
}

func (lhs *TransportState) Equal(rhs *TransportState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TcpMss != rhs.TcpMss {
		return false
	}
	if lhs.MtuDiscovery != rhs.MtuDiscovery {
		return false
	}
	if lhs.PassiveMode != rhs.PassiveMode {
		return false
	}
	if lhs.LocalAddress != rhs.LocalAddress {
		return false
	}
	if lhs.LocalPort != rhs.LocalPort {
		return false
	}
	if lhs.RemoteAddress != rhs.RemoteAddress {
		return false
	}
	if lhs.RemotePort != rhs.RemotePort {
		return false
	}
	return true
}

//struct for container bgp:config
type TransportConfig struct {
	// original -> bgp:tcp-mss
	TcpMss uint16 `mapstructure:"tcp-mss"`
	// original -> bgp:mtu-discovery
	//bgp:mtu-discovery's original type is boolean
	MtuDiscovery bool `mapstructure:"mtu-discovery"`
	// original -> bgp:passive-mode
	//bgp:passive-mode's original type is boolean
	PassiveMode bool `mapstructure:"passive-mode"`
	// original -> bgp:local-address
	//bgp:local-address's original type is union
	LocalAddress string `mapstructure:"local-address"`
	// original -> gobgp:remote-port
	//gobgp:remote-port's original type is inet:port-number
	RemotePort uint16 `mapstructure:"remote-port"`
}

func (lhs *TransportConfig) Equal(rhs *TransportConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TcpMss != rhs.TcpMss {
		return false
	}
	if lhs.MtuDiscovery != rhs.MtuDiscovery {
		return false
	}
	if lhs.PassiveMode != rhs.PassiveMode {
		return false
	}
	if lhs.LocalAddress != rhs.LocalAddress {
		return false
	}
	if lhs.RemotePort != rhs.RemotePort {
		return false
	}
	return true
}

//struct for container bgp:transport
type Transport struct {
	// original -> bgp:transport-config
	Config TransportConfig `mapstructure:"config"`
	// original -> bgp:transport-state
	State TransportState `mapstructure:"state"`
}

func (lhs *Transport) Equal(rhs *Transport) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type TimersState struct {
	// original -> bgp:connect-retry
	//bgp:connect-retry's original type is decimal64
	ConnectRetry float64 `mapstructure:"connect-retry"`
	// original -> bgp:hold-time
	//bgp:hold-time's original type is decimal64
	HoldTime float64 `mapstructure:"hold-time"`
	// original -> bgp:keepalive-interval
	//bgp:keepalive-interval's original type is decimal64
	KeepaliveInterval float64 `mapstructure:"keepalive-interval"`
	// original -> bgp:minimum-advertisement-interval
	//bgp:minimum-advertisement-interval's original type is decimal64
	MinimumAdvertisementInterval float64 `mapstructure:"minimum-advertisement-interval"`
	// original -> bgp-op:uptime
	//bgp-op:uptime's original type is yang:timeticks
	Uptime int64 `mapstructure:"uptime"`
	// original -> bgp-op:negotiated-hold-time
	//bgp-op:negotiated-hold-time's original type is decimal64
	NegotiatedHoldTime float64 `mapstructure:"negotiated-hold-time"`
	// original -> gobgp:idle-hold-time-after-reset
	//gobgp:idle-hold-time-after-reset's original type is decimal64
	IdleHoldTimeAfterReset float64 `mapstructure:"idle-hold-time-after-reset"`
	// original -> gobgp:downtime
	//gobgp:downtime's original type is yang:timeticks
	Downtime int64 `mapstructure:"downtime"`
	// original -> gobgp:update-recv-time
	UpdateRecvTime int64 `mapstructure:"update-recv-time"`
}

func (lhs *TimersState) Equal(rhs *TimersState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ConnectRetry != rhs.ConnectRetry {
		return false
	}
	if lhs.HoldTime != rhs.HoldTime {
		return false
	}
	if lhs.KeepaliveInterval != rhs.KeepaliveInterval {
		return false
	}
	if lhs.MinimumAdvertisementInterval != rhs.MinimumAdvertisementInterval {
		return false
	}
	if lhs.Uptime != rhs.Uptime {
		return false
	}
	if lhs.NegotiatedHoldTime != rhs.NegotiatedHoldTime {
		return false
	}
	if lhs.IdleHoldTimeAfterReset != rhs.IdleHoldTimeAfterReset {
		return false
	}
	if lhs.Downtime != rhs.Downtime {
		return false
	}
	if lhs.UpdateRecvTime != rhs.UpdateRecvTime {
		return false
	}
	return true
}

//struct for container bgp:config
type TimersConfig struct {
	// original -> bgp:connect-retry
	//bgp:connect-retry's original type is decimal64
	ConnectRetry float64 `mapstructure:"connect-retry"`
	// original -> bgp:hold-time
	//bgp:hold-time's original type is decimal64
	HoldTime float64 `mapstructure:"hold-time"`
	// original -> bgp:keepalive-interval
	//bgp:keepalive-interval's original type is decimal64
	KeepaliveInterval float64 `mapstructure:"keepalive-interval"`
	// original -> bgp:minimum-advertisement-interval
	//bgp:minimum-advertisement-interval's original type is decimal64
	MinimumAdvertisementInterval float64 `mapstructure:"minimum-advertisement-interval"`
	// original -> gobgp:idle-hold-time-after-reset
	//gobgp:idle-hold-time-after-reset's original type is decimal64
	IdleHoldTimeAfterReset float64 `mapstructure:"idle-hold-time-after-reset"`
}

func (lhs *TimersConfig) Equal(rhs *TimersConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ConnectRetry != rhs.ConnectRetry {
		return false
	}
	if lhs.HoldTime != rhs.HoldTime {
		return false
	}
	if lhs.KeepaliveInterval != rhs.KeepaliveInterval {
		return false
	}
	if lhs.MinimumAdvertisementInterval != rhs.MinimumAdvertisementInterval {
		return false
	}
	if lhs.IdleHoldTimeAfterReset != rhs.IdleHoldTimeAfterReset {
		return false
	}
	return true
}

//struct for container bgp:timers
type Timers struct {
	// original -> bgp:timers-config
	Config TimersConfig `mapstructure:"config"`
	// original -> bgp:timers-state
	State TimersState `mapstructure:"state"`
}

func (lhs *Timers) Equal(rhs *Timers) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container gobgp:Capabilities
type Capabilities struct {
	// original -> gobgp:remote
	// original type is list of binary
	RemoteList [][]byte `mapstructure:"remote-list"`
	// original -> gobgp:local
	// original type is list of binary
	LocalList [][]byte `mapstructure:"local-list"`
}

func (lhs *Capabilities) Equal(rhs *Capabilities) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.RemoteList) != len(rhs.RemoteList) {
		return false
	}
	for idx, l := range lhs.RemoteList {
		if bytes.Compare(l, rhs.RemoteList[idx]) != 0 {
			return false
		}
	}
	if len(lhs.LocalList) != len(rhs.LocalList) {
		return false
	}
	for idx, l := range lhs.LocalList {
		if bytes.Compare(l, rhs.LocalList[idx]) != 0 {
			return false
		}
	}
	return true
}

//struct for container gobgp:adj-table
type AdjTable struct {
	// original -> gobgp:ADVERTISED
	Advertised uint32 `mapstructure:"advertised"`
	// original -> gobgp:RECEIVED
	Received uint32 `mapstructure:"received"`
	// original -> gobgp:ACCEPTED
	Accepted uint32 `mapstructure:"accepted"`
}

func (lhs *AdjTable) Equal(rhs *AdjTable) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Advertised != rhs.Advertised {
		return false
	}
	if lhs.Received != rhs.Received {
		return false
	}
	if lhs.Accepted != rhs.Accepted {
		return false
	}
	return true
}

//struct for container bgp:queues
type Queues struct {
	// original -> bgp-op:input
	Input uint32 `mapstructure:"input"`
	// original -> bgp-op:output
	Output uint32 `mapstructure:"output"`
}

func (lhs *Queues) Equal(rhs *Queues) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Input != rhs.Input {
		return false
	}
	if lhs.Output != rhs.Output {
		return false
	}
	return true
}

//struct for container bgp:received
type Received struct {
	// original -> bgp-op:UPDATE
	Update uint64 `mapstructure:"update"`
	// original -> bgp-op:NOTIFICATION
	Notification uint64 `mapstructure:"notification"`
	// original -> gobgp:OPEN
	Open uint64 `mapstructure:"open"`
	// original -> gobgp:REFRESH
	Refresh uint64 `mapstructure:"refresh"`
	// original -> gobgp:KEEPALIVE
	Keepalive uint64 `mapstructure:"keepalive"`
	// original -> gobgp:DYNAMIC-CAP
	DynamicCap uint64 `mapstructure:"dynamic-cap"`
	// original -> gobgp:DISCARDED
	Discarded uint64 `mapstructure:"discarded"`
	// original -> gobgp:TOTAL
	Total uint64 `mapstructure:"total"`
}

func (lhs *Received) Equal(rhs *Received) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Update != rhs.Update {
		return false
	}
	if lhs.Notification != rhs.Notification {
		return false
	}
	if lhs.Open != rhs.Open {
		return false
	}
	if lhs.Refresh != rhs.Refresh {
		return false
	}
	if lhs.Keepalive != rhs.Keepalive {
		return false
	}
	if lhs.DynamicCap != rhs.DynamicCap {
		return false
	}
	if lhs.Discarded != rhs.Discarded {
		return false
	}
	if lhs.Total != rhs.Total {
		return false
	}
	return true
}

//struct for container bgp:sent
type Sent struct {
	// original -> bgp-op:UPDATE
	Update uint64 `mapstructure:"update"`
	// original -> bgp-op:NOTIFICATION
	Notification uint64 `mapstructure:"notification"`
	// original -> gobgp:OPEN
	Open uint64 `mapstructure:"open"`
	// original -> gobgp:REFRESH
	Refresh uint64 `mapstructure:"refresh"`
	// original -> gobgp:KEEPALIVE
	Keepalive uint64 `mapstructure:"keepalive"`
	// original -> gobgp:DYNAMIC-CAP
	DynamicCap uint64 `mapstructure:"dynamic-cap"`
	// original -> gobgp:DISCARDED
	Discarded uint64 `mapstructure:"discarded"`
	// original -> gobgp:TOTAL
	Total uint64 `mapstructure:"total"`
}

func (lhs *Sent) Equal(rhs *Sent) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Update != rhs.Update {
		return false
	}
	if lhs.Notification != rhs.Notification {
		return false
	}
	if lhs.Open != rhs.Open {
		return false
	}
	if lhs.Refresh != rhs.Refresh {
		return false
	}
	if lhs.Keepalive != rhs.Keepalive {
		return false
	}
	if lhs.DynamicCap != rhs.DynamicCap {
		return false
	}
	if lhs.Discarded != rhs.Discarded {
		return false
	}
	if lhs.Total != rhs.Total {
		return false
	}
	return true
}

//struct for container bgp:messages
type Messages struct {
	// original -> bgp:sent
	Sent Sent `mapstructure:"sent"`
	// original -> bgp:received
	Received Received `mapstructure:"received"`
}

func (lhs *Messages) Equal(rhs *Messages) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Sent.Equal(&(rhs.Sent)) {
		return false
	}
	if !lhs.Received.Equal(&(rhs.Received)) {
		return false
	}
	return true
}

//struct for container bgp:state
type NeighborState struct {
	// original -> bgp:peer-as
	//bgp:peer-as's original type is inet:as-number
	PeerAs uint32 `mapstructure:"peer-as"`
	// original -> bgp:local-as
	//bgp:local-as's original type is inet:as-number
	LocalAs uint32 `mapstructure:"local-as"`
	// original -> bgp:peer-type
	PeerType PeerType `mapstructure:"peer-type"`
	// original -> bgp:auth-password
	AuthPassword string `mapstructure:"auth-password"`
	// original -> bgp:remove-private-as
	RemovePrivateAs RemovePrivateAsOption `mapstructure:"remove-private-as"`
	// original -> bgp:route-flap-damping
	//bgp:route-flap-damping's original type is boolean
	RouteFlapDamping bool `mapstructure:"route-flap-damping"`
	// original -> bgp:send-community
	SendCommunity CommunityType `mapstructure:"send-community"`
	// original -> bgp:description
	Description string `mapstructure:"description"`
	// original -> bgp:peer-group
	PeerGroup string `mapstructure:"peer-group"`
	// original -> bgp:neighbor-address
	//bgp:neighbor-address's original type is inet:ip-address
	NeighborAddress string `mapstructure:"neighbor-address"`
	// original -> bgp-op:session-state
	SessionState SessionState `mapstructure:"session-state"`
	// original -> bgp-op:supported-capabilities
	SupportedCapabilitiesList []BgpCapability `mapstructure:"supported-capabilities-list"`
	// original -> bgp:messages
	Messages Messages `mapstructure:"messages"`
	// original -> bgp:queues
	Queues Queues `mapstructure:"queues"`
	// original -> gobgp:adj-table
	AdjTable AdjTable `mapstructure:"adj-table"`
	// original -> gobgp:Capabilities
	Capabilities Capabilities `mapstructure:"capabilities"`
	// original -> gobgp:received-open-message
	//gobgp:received-open-message's original type is binary
	ReceivedOpenMessage []byte `mapstructure:"received-open-message"`
	// original -> gobgp:admin-down
	//gobgp:admin-down's original type is boolean
	AdminDown bool `mapstructure:"admin-down"`
	// original -> gobgp:admin-state
	AdminState string `mapstructure:"admin-state"`
	// original -> gobgp:established-count
	EstablishedCount uint32 `mapstructure:"established-count"`
	// original -> gobgp:flops
	Flops uint32 `mapstructure:"flops"`
	// original -> gobgp:neighbor-interface
	NeighborInterface string `mapstructure:"neighbor-interface"`
	// original -> gobgp:remote-router-id
	RemoteRouterId string `mapstructure:"remote-router-id"`
}

func (lhs *NeighborState) Equal(rhs *NeighborState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PeerAs != rhs.PeerAs {
		return false
	}
	if lhs.LocalAs != rhs.LocalAs {
		return false
	}
	if lhs.PeerType != rhs.PeerType {
		return false
	}
	if lhs.AuthPassword != rhs.AuthPassword {
		return false
	}
	if lhs.RemovePrivateAs != rhs.RemovePrivateAs {
		return false
	}
	if lhs.RouteFlapDamping != rhs.RouteFlapDamping {
		return false
	}
	if lhs.SendCommunity != rhs.SendCommunity {
		return false
	}
	if lhs.Description != rhs.Description {
		return false
	}
	if lhs.PeerGroup != rhs.PeerGroup {
		return false
	}
	if lhs.NeighborAddress != rhs.NeighborAddress {
		return false
	}
	if lhs.SessionState != rhs.SessionState {
		return false
	}
	if len(lhs.SupportedCapabilitiesList) != len(rhs.SupportedCapabilitiesList) {
		return false
	}
	for idx, l := range lhs.SupportedCapabilitiesList {
		if l != rhs.SupportedCapabilitiesList[idx] {
			return false
		}
	}
	if !lhs.Messages.Equal(&(rhs.Messages)) {
		return false
	}
	if !lhs.Queues.Equal(&(rhs.Queues)) {
		return false
	}
	if !lhs.AdjTable.Equal(&(rhs.AdjTable)) {
		return false
	}
	if !lhs.Capabilities.Equal(&(rhs.Capabilities)) {
		return false
	}
	if bytes.Compare(lhs.ReceivedOpenMessage, rhs.ReceivedOpenMessage) != 0 {
		return false
	}
	if lhs.AdminDown != rhs.AdminDown {
		return false
	}
	if lhs.AdminState != rhs.AdminState {
		return false
	}
	if lhs.EstablishedCount != rhs.EstablishedCount {
		return false
	}
	if lhs.Flops != rhs.Flops {
		return false
	}
	if lhs.NeighborInterface != rhs.NeighborInterface {
		return false
	}
	if lhs.RemoteRouterId != rhs.RemoteRouterId {
		return false
	}
	return true
}

//struct for container bgp:config
type NeighborConfig struct {
	// original -> bgp:peer-as
	//bgp:peer-as's original type is inet:as-number
	PeerAs uint32 `mapstructure:"peer-as"`
	// original -> bgp:local-as
	//bgp:local-as's original type is inet:as-number
	LocalAs uint32 `mapstructure:"local-as"`
	// original -> bgp:peer-type
	PeerType PeerType `mapstructure:"peer-type"`
	// original -> bgp:auth-password
	AuthPassword string `mapstructure:"auth-password"`
	// original -> bgp:remove-private-as
	RemovePrivateAs RemovePrivateAsOption `mapstructure:"remove-private-as"`
	// original -> bgp:route-flap-damping
	//bgp:route-flap-damping's original type is boolean
	RouteFlapDamping bool `mapstructure:"route-flap-damping"`
	// original -> bgp:send-community
	SendCommunity CommunityType `mapstructure:"send-community"`
	// original -> bgp:description
	Description string `mapstructure:"description"`
	// original -> bgp:peer-group
	PeerGroup string `mapstructure:"peer-group"`
	// original -> bgp:neighbor-address
	//bgp:neighbor-address's original type is inet:ip-address
	NeighborAddress string `mapstructure:"neighbor-address"`
	// original -> gobgp:admin-down
	//gobgp:admin-down's original type is boolean
	AdminDown bool `mapstructure:"admin-down"`
	// original -> gobgp:neighbor-interface
	NeighborInterface string `mapstructure:"neighbor-interface"`
}

func (lhs *NeighborConfig) Equal(rhs *NeighborConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PeerAs != rhs.PeerAs {
		return false
	}
	if lhs.LocalAs != rhs.LocalAs {
		return false
	}
	if lhs.PeerType != rhs.PeerType {
		return false
	}
	if lhs.AuthPassword != rhs.AuthPassword {
		return false
	}
	if lhs.RemovePrivateAs != rhs.RemovePrivateAs {
		return false
	}
	if lhs.RouteFlapDamping != rhs.RouteFlapDamping {
		return false
	}
	if lhs.SendCommunity != rhs.SendCommunity {
		return false
	}
	if lhs.Description != rhs.Description {
		return false
	}
	if lhs.PeerGroup != rhs.PeerGroup {
		return false
	}
	if lhs.NeighborAddress != rhs.NeighborAddress {
		return false
	}
	if lhs.AdminDown != rhs.AdminDown {
		return false
	}
	if lhs.NeighborInterface != rhs.NeighborInterface {
		return false
	}
	return true
}

//struct for container bgp:neighbor
type Neighbor struct {
	// original -> bgp:neighbor-address
	// original -> bgp:neighbor-config
	Config NeighborConfig `mapstructure:"config"`
	// original -> bgp:neighbor-state
	State NeighborState `mapstructure:"state"`
	// original -> bgp:timers
	Timers Timers `mapstructure:"timers"`
	// original -> bgp:transport
	Transport Transport `mapstructure:"transport"`
	// original -> bgp:error-handling
	ErrorHandling ErrorHandling `mapstructure:"error-handling"`
	// original -> bgp:logging-options
	LoggingOptions LoggingOptions `mapstructure:"logging-options"`
	// original -> bgp:ebgp-multihop
	EbgpMultihop EbgpMultihop `mapstructure:"ebgp-multihop"`
	// original -> bgp:route-reflector
	RouteReflector RouteReflector `mapstructure:"route-reflector"`
	// original -> bgp:as-path-options
	AsPathOptions AsPathOptions `mapstructure:"as-path-options"`
	// original -> bgp:add-paths
	AddPaths AddPaths `mapstructure:"add-paths"`
	// original -> bgp:afi-safis
	AfiSafis []AfiSafi `mapstructure:"afi-safis"`
	// original -> bgp:graceful-restart
	GracefulRestart GracefulRestart `mapstructure:"graceful-restart"`
	// original -> rpol:apply-policy
	ApplyPolicy ApplyPolicy `mapstructure:"apply-policy"`
	// original -> bgp-mp:use-multiple-paths
	UseMultiplePaths UseMultiplePaths `mapstructure:"use-multiple-paths"`
	// original -> gobgp:route-server
	RouteServer RouteServer `mapstructure:"route-server"`
}

func (lhs *Neighbor) Equal(rhs *Neighbor) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.Timers.Equal(&(rhs.Timers)) {
		return false
	}
	if !lhs.Transport.Equal(&(rhs.Transport)) {
		return false
	}
	if !lhs.ErrorHandling.Equal(&(rhs.ErrorHandling)) {
		return false
	}
	if !lhs.LoggingOptions.Equal(&(rhs.LoggingOptions)) {
		return false
	}
	if !lhs.EbgpMultihop.Equal(&(rhs.EbgpMultihop)) {
		return false
	}
	if !lhs.RouteReflector.Equal(&(rhs.RouteReflector)) {
		return false
	}
	if !lhs.AsPathOptions.Equal(&(rhs.AsPathOptions)) {
		return false
	}
	if !lhs.AddPaths.Equal(&(rhs.AddPaths)) {
		return false
	}
	if len(lhs.AfiSafis) != len(rhs.AfiSafis) {
		return false
	}
	{
		lmap := make(map[string]*AfiSafi)
		for i, l := range lhs.AfiSafis {
			lmap[mapkey(i, string(l.Config.AfiSafiName))] = &lhs.AfiSafis[i]
		}
		for i, r := range rhs.AfiSafis {
			if l, y := lmap[mapkey(i, string(r.Config.AfiSafiName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.GracefulRestart.Equal(&(rhs.GracefulRestart)) {
		return false
	}
	if !lhs.ApplyPolicy.Equal(&(rhs.ApplyPolicy)) {
		return false
	}
	if !lhs.UseMultiplePaths.Equal(&(rhs.UseMultiplePaths)) {
		return false
	}
	if !lhs.RouteServer.Equal(&(rhs.RouteServer)) {
		return false
	}
	return true
}

//struct for container gobgp:mpls-label-range
type MplsLabelRange struct {
	// original -> gobgp:min-label
	MinLabel uint32 `mapstructure:"min-label"`
	// original -> gobgp:max-label
	MaxLabel uint32 `mapstructure:"max-label"`
}

func (lhs *MplsLabelRange) Equal(rhs *MplsLabelRange) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.MinLabel != rhs.MinLabel {
		return false
	}
	if lhs.MaxLabel != rhs.MaxLabel {
		return false
	}
	return true
}

//struct for container gobgp:state
type RouteTargetMembershipState struct {
	// original -> gobgp:deferral-time
	DeferralTime uint16 `mapstructure:"deferral-time"`
}

func (lhs *RouteTargetMembershipState) Equal(rhs *RouteTargetMembershipState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.DeferralTime != rhs.DeferralTime {
		return false
	}
	return true
}

//struct for container gobgp:config
type RouteTargetMembershipConfig struct {
	// original -> gobgp:deferral-time
	DeferralTime uint16 `mapstructure:"deferral-time"`
}

func (lhs *RouteTargetMembershipConfig) Equal(rhs *RouteTargetMembershipConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.DeferralTime != rhs.DeferralTime {
		return false
	}
	return true
}

//struct for container gobgp:route-target-membership
type RouteTargetMembership struct {
	// original -> gobgp:route-target-membership-config
	Config RouteTargetMembershipConfig `mapstructure:"config"`
	// original -> gobgp:route-target-membership-state
	State RouteTargetMembershipState `mapstructure:"state"`
}

func (lhs *RouteTargetMembership) Equal(rhs *RouteTargetMembership) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:l2vpn-evpn
type L2vpnEvpn struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
}

func (lhs *L2vpnEvpn) Equal(rhs *L2vpnEvpn) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

//struct for container bgp-mp:l2vpn-vpls
type L2vpnVpls struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
}

func (lhs *L2vpnVpls) Equal(rhs *L2vpnVpls) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

//struct for container bgp-mp:l3vpn-ipv6-multicast
type L3vpnIpv6Multicast struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
}

func (lhs *L3vpnIpv6Multicast) Equal(rhs *L3vpnIpv6Multicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

//struct for container bgp-mp:l3vpn-ipv4-multicast
type L3vpnIpv4Multicast struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
}

func (lhs *L3vpnIpv4Multicast) Equal(rhs *L3vpnIpv4Multicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

//struct for container bgp-mp:l3vpn-ipv6-unicast
type L3vpnIpv6Unicast struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
}

func (lhs *L3vpnIpv6Unicast) Equal(rhs *L3vpnIpv6Unicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

//struct for container bgp-mp:l3vpn-ipv4-unicast
type L3vpnIpv4Unicast struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
}

func (lhs *L3vpnIpv4Unicast) Equal(rhs *L3vpnIpv4Unicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

//struct for container bgp-mp:ipv6-labelled-unicast
type Ipv6LabelledUnicast struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
}

func (lhs *Ipv6LabelledUnicast) Equal(rhs *Ipv6LabelledUnicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

//struct for container bgp-mp:ipv4-labelled-unicast
type Ipv4LabelledUnicast struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
}

func (lhs *Ipv4LabelledUnicast) Equal(rhs *Ipv4LabelledUnicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type Ipv6UnicastState struct {
	// original -> bgp-mp:send-default-route
	//bgp-mp:send-default-route's original type is boolean
	SendDefaultRoute bool `mapstructure:"send-default-route"`
}

func (lhs *Ipv6UnicastState) Equal(rhs *Ipv6UnicastState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SendDefaultRoute != rhs.SendDefaultRoute {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type Ipv6UnicastConfig struct {
	// original -> bgp-mp:send-default-route
	//bgp-mp:send-default-route's original type is boolean
	SendDefaultRoute bool `mapstructure:"send-default-route"`
}

func (lhs *Ipv6UnicastConfig) Equal(rhs *Ipv6UnicastConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SendDefaultRoute != rhs.SendDefaultRoute {
		return false
	}
	return true
}

//struct for container bgp-mp:ipv6-unicast
type Ipv6Unicast struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
	// original -> bgp-mp:ipv6-unicast-config
	Config Ipv6UnicastConfig `mapstructure:"config"`
	// original -> bgp-mp:ipv6-unicast-state
	State Ipv6UnicastState `mapstructure:"state"`
}

func (lhs *Ipv6Unicast) Equal(rhs *Ipv6Unicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type Ipv4UnicastState struct {
	// original -> bgp-mp:send-default-route
	//bgp-mp:send-default-route's original type is boolean
	SendDefaultRoute bool `mapstructure:"send-default-route"`
}

func (lhs *Ipv4UnicastState) Equal(rhs *Ipv4UnicastState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SendDefaultRoute != rhs.SendDefaultRoute {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type Ipv4UnicastConfig struct {
	// original -> bgp-mp:send-default-route
	//bgp-mp:send-default-route's original type is boolean
	SendDefaultRoute bool `mapstructure:"send-default-route"`
}

func (lhs *Ipv4UnicastConfig) Equal(rhs *Ipv4UnicastConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SendDefaultRoute != rhs.SendDefaultRoute {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type PrefixLimitState struct {
	// original -> bgp-mp:max-prefixes
	MaxPrefixes uint32 `mapstructure:"max-prefixes"`
	// original -> bgp-mp:shutdown-threshold-pct
	ShutdownThresholdPct Percentage `mapstructure:"shutdown-threshold-pct"`
	// original -> bgp-mp:restart-timer
	//bgp-mp:restart-timer's original type is decimal64
	RestartTimer float64 `mapstructure:"restart-timer"`
}

func (lhs *PrefixLimitState) Equal(rhs *PrefixLimitState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.MaxPrefixes != rhs.MaxPrefixes {
		return false
	}
	if lhs.ShutdownThresholdPct != rhs.ShutdownThresholdPct {
		return false
	}
	if lhs.RestartTimer != rhs.RestartTimer {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type PrefixLimitConfig struct {
	// original -> bgp-mp:max-prefixes
	MaxPrefixes uint32 `mapstructure:"max-prefixes"`
	// original -> bgp-mp:shutdown-threshold-pct
	ShutdownThresholdPct Percentage `mapstructure:"shutdown-threshold-pct"`
	// original -> bgp-mp:restart-timer
	//bgp-mp:restart-timer's original type is decimal64
	RestartTimer float64 `mapstructure:"restart-timer"`
}

func (lhs *PrefixLimitConfig) Equal(rhs *PrefixLimitConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.MaxPrefixes != rhs.MaxPrefixes {
		return false
	}
	if lhs.ShutdownThresholdPct != rhs.ShutdownThresholdPct {
		return false
	}
	if lhs.RestartTimer != rhs.RestartTimer {
		return false
	}
	return true
}

//struct for container bgp-mp:prefix-limit
type PrefixLimit struct {
	// original -> bgp-mp:prefix-limit-config
	Config PrefixLimitConfig `mapstructure:"config"`
	// original -> bgp-mp:prefix-limit-state
	State PrefixLimitState `mapstructure:"state"`
}

func (lhs *PrefixLimit) Equal(rhs *PrefixLimit) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:ipv4-unicast
type Ipv4Unicast struct {
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
	// original -> bgp-mp:ipv4-unicast-config
	Config Ipv4UnicastConfig `mapstructure:"config"`
	// original -> bgp-mp:ipv4-unicast-state
	State Ipv4UnicastState `mapstructure:"state"`
}

func (lhs *Ipv4Unicast) Equal(rhs *Ipv4Unicast) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container rpol:state
type ApplyPolicyState struct {
	// original -> rpol:import-policy
	ImportPolicyList []string `mapstructure:"import-policy-list"`
	// original -> rpol:default-import-policy
	DefaultImportPolicy DefaultPolicyType `mapstructure:"default-import-policy"`
	// original -> rpol:export-policy
	ExportPolicyList []string `mapstructure:"export-policy-list"`
	// original -> rpol:default-export-policy
	DefaultExportPolicy DefaultPolicyType `mapstructure:"default-export-policy"`
	// original -> gobgp:in-policy
	InPolicyList []string `mapstructure:"in-policy-list"`
	// original -> gobgp:default-in-policy
	DefaultInPolicy DefaultPolicyType `mapstructure:"default-in-policy"`
}

func (lhs *ApplyPolicyState) Equal(rhs *ApplyPolicyState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.ImportPolicyList) != len(rhs.ImportPolicyList) {
		return false
	}
	for idx, l := range lhs.ImportPolicyList {
		if l != rhs.ImportPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultImportPolicy != rhs.DefaultImportPolicy {
		return false
	}
	if len(lhs.ExportPolicyList) != len(rhs.ExportPolicyList) {
		return false
	}
	for idx, l := range lhs.ExportPolicyList {
		if l != rhs.ExportPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultExportPolicy != rhs.DefaultExportPolicy {
		return false
	}
	if len(lhs.InPolicyList) != len(rhs.InPolicyList) {
		return false
	}
	for idx, l := range lhs.InPolicyList {
		if l != rhs.InPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultInPolicy != rhs.DefaultInPolicy {
		return false
	}
	return true
}

//struct for container rpol:config
type ApplyPolicyConfig struct {
	// original -> rpol:import-policy
	ImportPolicyList []string `mapstructure:"import-policy-list"`
	// original -> rpol:default-import-policy
	DefaultImportPolicy DefaultPolicyType `mapstructure:"default-import-policy"`
	// original -> rpol:export-policy
	ExportPolicyList []string `mapstructure:"export-policy-list"`
	// original -> rpol:default-export-policy
	DefaultExportPolicy DefaultPolicyType `mapstructure:"default-export-policy"`
	// original -> gobgp:in-policy
	InPolicyList []string `mapstructure:"in-policy-list"`
	// original -> gobgp:default-in-policy
	DefaultInPolicy DefaultPolicyType `mapstructure:"default-in-policy"`
}

func (lhs *ApplyPolicyConfig) Equal(rhs *ApplyPolicyConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.ImportPolicyList) != len(rhs.ImportPolicyList) {
		return false
	}
	for idx, l := range lhs.ImportPolicyList {
		if l != rhs.ImportPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultImportPolicy != rhs.DefaultImportPolicy {
		return false
	}
	if len(lhs.ExportPolicyList) != len(rhs.ExportPolicyList) {
		return false
	}
	for idx, l := range lhs.ExportPolicyList {
		if l != rhs.ExportPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultExportPolicy != rhs.DefaultExportPolicy {
		return false
	}
	if len(lhs.InPolicyList) != len(rhs.InPolicyList) {
		return false
	}
	for idx, l := range lhs.InPolicyList {
		if l != rhs.InPolicyList[idx] {
			return false
		}
	}
	if lhs.DefaultInPolicy != rhs.DefaultInPolicy {
		return false
	}
	return true
}

//struct for container rpol:apply-policy
type ApplyPolicy struct {
	// original -> rpol:apply-policy-config
	Config ApplyPolicyConfig `mapstructure:"config"`
	// original -> rpol:apply-policy-state
	State ApplyPolicyState `mapstructure:"state"`
}

func (lhs *ApplyPolicy) Equal(rhs *ApplyPolicy) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type AfiSafiState struct {
	// original -> bgp-mp:afi-safi-name
	AfiSafiName AfiSafiType `mapstructure:"afi-safi-name"`
	// original -> bgp-mp:enabled
	//bgp-mp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> bgp-op:total-paths
	TotalPaths uint32 `mapstructure:"total-paths"`
	// original -> bgp-op:total-prefixes
	TotalPrefixes uint32 `mapstructure:"total-prefixes"`
}

func (lhs *AfiSafiState) Equal(rhs *AfiSafiState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AfiSafiName != rhs.AfiSafiName {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.TotalPaths != rhs.TotalPaths {
		return false
	}
	if lhs.TotalPrefixes != rhs.TotalPrefixes {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type AfiSafiConfig struct {
	// original -> bgp-mp:afi-safi-name
	AfiSafiName AfiSafiType `mapstructure:"afi-safi-name"`
	// original -> bgp-mp:enabled
	//bgp-mp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
}

func (lhs *AfiSafiConfig) Equal(rhs *AfiSafiConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AfiSafiName != rhs.AfiSafiName {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type MpGracefulRestartState struct {
	// original -> bgp-mp:enabled
	//bgp-mp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> bgp-op:received
	//bgp-op:received's original type is boolean
	Received bool `mapstructure:"received"`
	// original -> bgp-op:advertised
	//bgp-op:advertised's original type is boolean
	Advertised bool `mapstructure:"advertised"`
	// original -> gobgp:end-of-rib-received
	//gobgp:end-of-rib-received's original type is boolean
	EndOfRibReceived bool `mapstructure:"end-of-rib-received"`
	// original -> gobgp:end-of-rib-sent
	//gobgp:end-of-rib-sent's original type is boolean
	EndOfRibSent bool `mapstructure:"end-of-rib-sent"`
}

func (lhs *MpGracefulRestartState) Equal(rhs *MpGracefulRestartState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.Received != rhs.Received {
		return false
	}
	if lhs.Advertised != rhs.Advertised {
		return false
	}
	if lhs.EndOfRibReceived != rhs.EndOfRibReceived {
		return false
	}
	if lhs.EndOfRibSent != rhs.EndOfRibSent {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type MpGracefulRestartConfig struct {
	// original -> bgp-mp:enabled
	//bgp-mp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
}

func (lhs *MpGracefulRestartConfig) Equal(rhs *MpGracefulRestartConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	return true
}

//struct for container bgp-mp:graceful-restart
type MpGracefulRestart struct {
	// original -> bgp-mp:mp-graceful-restart-config
	Config MpGracefulRestartConfig `mapstructure:"config"`
	// original -> bgp-mp:mp-graceful-restart-state
	State MpGracefulRestartState `mapstructure:"state"`
}

func (lhs *MpGracefulRestart) Equal(rhs *MpGracefulRestart) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:afi-safi
type AfiSafi struct {
	// original -> bgp-mp:afi-safi-name
	// original -> bgp-mp:mp-graceful-restart
	MpGracefulRestart MpGracefulRestart `mapstructure:"mp-graceful-restart"`
	// original -> bgp-mp:afi-safi-config
	Config AfiSafiConfig `mapstructure:"config"`
	// original -> bgp-mp:afi-safi-state
	State AfiSafiState `mapstructure:"state"`
	// original -> rpol:apply-policy
	ApplyPolicy ApplyPolicy `mapstructure:"apply-policy"`
	// original -> bgp-mp:ipv4-unicast
	Ipv4Unicast Ipv4Unicast `mapstructure:"ipv4-unicast"`
	// original -> bgp-mp:ipv6-unicast
	Ipv6Unicast Ipv6Unicast `mapstructure:"ipv6-unicast"`
	// original -> bgp-mp:ipv4-labelled-unicast
	Ipv4LabelledUnicast Ipv4LabelledUnicast `mapstructure:"ipv4-labelled-unicast"`
	// original -> bgp-mp:ipv6-labelled-unicast
	Ipv6LabelledUnicast Ipv6LabelledUnicast `mapstructure:"ipv6-labelled-unicast"`
	// original -> bgp-mp:l3vpn-ipv4-unicast
	L3vpnIpv4Unicast L3vpnIpv4Unicast `mapstructure:"l3vpn-ipv4-unicast"`
	// original -> bgp-mp:l3vpn-ipv6-unicast
	L3vpnIpv6Unicast L3vpnIpv6Unicast `mapstructure:"l3vpn-ipv6-unicast"`
	// original -> bgp-mp:l3vpn-ipv4-multicast
	L3vpnIpv4Multicast L3vpnIpv4Multicast `mapstructure:"l3vpn-ipv4-multicast"`
	// original -> bgp-mp:l3vpn-ipv6-multicast
	L3vpnIpv6Multicast L3vpnIpv6Multicast `mapstructure:"l3vpn-ipv6-multicast"`
	// original -> bgp-mp:l2vpn-vpls
	L2vpnVpls L2vpnVpls `mapstructure:"l2vpn-vpls"`
	// original -> bgp-mp:l2vpn-evpn
	L2vpnEvpn L2vpnEvpn `mapstructure:"l2vpn-evpn"`
	// original -> bgp-mp:route-selection-options
	RouteSelectionOptions RouteSelectionOptions `mapstructure:"route-selection-options"`
	// original -> bgp-mp:use-multiple-paths
	UseMultiplePaths UseMultiplePaths `mapstructure:"use-multiple-paths"`
	// original -> bgp-mp:prefix-limit
	PrefixLimit PrefixLimit `mapstructure:"prefix-limit"`
	// original -> gobgp:route-target-membership
	RouteTargetMembership RouteTargetMembership `mapstructure:"route-target-membership"`
}

func (lhs *AfiSafi) Equal(rhs *AfiSafi) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.MpGracefulRestart.Equal(&(rhs.MpGracefulRestart)) {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.ApplyPolicy.Equal(&(rhs.ApplyPolicy)) {
		return false
	}
	if !lhs.Ipv4Unicast.Equal(&(rhs.Ipv4Unicast)) {
		return false
	}
	if !lhs.Ipv6Unicast.Equal(&(rhs.Ipv6Unicast)) {
		return false
	}
	if !lhs.Ipv4LabelledUnicast.Equal(&(rhs.Ipv4LabelledUnicast)) {
		return false
	}
	if !lhs.Ipv6LabelledUnicast.Equal(&(rhs.Ipv6LabelledUnicast)) {
		return false
	}
	if !lhs.L3vpnIpv4Unicast.Equal(&(rhs.L3vpnIpv4Unicast)) {
		return false
	}
	if !lhs.L3vpnIpv6Unicast.Equal(&(rhs.L3vpnIpv6Unicast)) {
		return false
	}
	if !lhs.L3vpnIpv4Multicast.Equal(&(rhs.L3vpnIpv4Multicast)) {
		return false
	}
	if !lhs.L3vpnIpv6Multicast.Equal(&(rhs.L3vpnIpv6Multicast)) {
		return false
	}
	if !lhs.L2vpnVpls.Equal(&(rhs.L2vpnVpls)) {
		return false
	}
	if !lhs.L2vpnEvpn.Equal(&(rhs.L2vpnEvpn)) {
		return false
	}
	if !lhs.RouteSelectionOptions.Equal(&(rhs.RouteSelectionOptions)) {
		return false
	}
	if !lhs.UseMultiplePaths.Equal(&(rhs.UseMultiplePaths)) {
		return false
	}
	if !lhs.PrefixLimit.Equal(&(rhs.PrefixLimit)) {
		return false
	}
	if !lhs.RouteTargetMembership.Equal(&(rhs.RouteTargetMembership)) {
		return false
	}
	return true
}

//struct for container bgp:state
type GracefulRestartState struct {
	// original -> bgp:enabled
	//bgp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> bgp:restart-time
	RestartTime uint16 `mapstructure:"restart-time"`
	// original -> bgp:stale-routes-time
	//bgp:stale-routes-time's original type is decimal64
	StaleRoutesTime float64 `mapstructure:"stale-routes-time"`
	// original -> bgp:helper-only
	//bgp:helper-only's original type is boolean
	HelperOnly bool `mapstructure:"helper-only"`
	// original -> bgp-op:peer-restart-time
	PeerRestartTime uint16 `mapstructure:"peer-restart-time"`
	// original -> bgp-op:peer-restarting
	//bgp-op:peer-restarting's original type is boolean
	PeerRestarting bool `mapstructure:"peer-restarting"`
	// original -> bgp-op:local-restarting
	//bgp-op:local-restarting's original type is boolean
	LocalRestarting bool `mapstructure:"local-restarting"`
	// original -> bgp-op:mode
	Mode Mode `mapstructure:"mode"`
	// original -> gobgp:deferral-time
	DeferralTime uint16 `mapstructure:"deferral-time"`
}

func (lhs *GracefulRestartState) Equal(rhs *GracefulRestartState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.RestartTime != rhs.RestartTime {
		return false
	}
	if lhs.StaleRoutesTime != rhs.StaleRoutesTime {
		return false
	}
	if lhs.HelperOnly != rhs.HelperOnly {
		return false
	}
	if lhs.PeerRestartTime != rhs.PeerRestartTime {
		return false
	}
	if lhs.PeerRestarting != rhs.PeerRestarting {
		return false
	}
	if lhs.LocalRestarting != rhs.LocalRestarting {
		return false
	}
	if lhs.Mode != rhs.Mode {
		return false
	}
	if lhs.DeferralTime != rhs.DeferralTime {
		return false
	}
	return true
}

//struct for container bgp:config
type GracefulRestartConfig struct {
	// original -> bgp:enabled
	//bgp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> bgp:restart-time
	RestartTime uint16 `mapstructure:"restart-time"`
	// original -> bgp:stale-routes-time
	//bgp:stale-routes-time's original type is decimal64
	StaleRoutesTime float64 `mapstructure:"stale-routes-time"`
	// original -> bgp:helper-only
	//bgp:helper-only's original type is boolean
	HelperOnly bool `mapstructure:"helper-only"`
	// original -> gobgp:deferral-time
	DeferralTime uint16 `mapstructure:"deferral-time"`
}

func (lhs *GracefulRestartConfig) Equal(rhs *GracefulRestartConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.RestartTime != rhs.RestartTime {
		return false
	}
	if lhs.StaleRoutesTime != rhs.StaleRoutesTime {
		return false
	}
	if lhs.HelperOnly != rhs.HelperOnly {
		return false
	}
	if lhs.DeferralTime != rhs.DeferralTime {
		return false
	}
	return true
}

//struct for container bgp:graceful-restart
type GracefulRestart struct {
	// original -> bgp:graceful-restart-config
	Config GracefulRestartConfig `mapstructure:"config"`
	// original -> bgp:graceful-restart-state
	State GracefulRestartState `mapstructure:"state"`
}

func (lhs *GracefulRestart) Equal(rhs *GracefulRestart) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type IbgpState struct {
	// original -> bgp-mp:maximum-paths
	MaximumPaths uint32 `mapstructure:"maximum-paths"`
}

func (lhs *IbgpState) Equal(rhs *IbgpState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.MaximumPaths != rhs.MaximumPaths {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type IbgpConfig struct {
	// original -> bgp-mp:maximum-paths
	MaximumPaths uint32 `mapstructure:"maximum-paths"`
}

func (lhs *IbgpConfig) Equal(rhs *IbgpConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.MaximumPaths != rhs.MaximumPaths {
		return false
	}
	return true
}

//struct for container bgp-mp:ibgp
type Ibgp struct {
	// original -> bgp-mp:ibgp-config
	Config IbgpConfig `mapstructure:"config"`
	// original -> bgp-mp:ibgp-state
	State IbgpState `mapstructure:"state"`
}

func (lhs *Ibgp) Equal(rhs *Ibgp) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type EbgpState struct {
	// original -> bgp-mp:allow-multiple-as
	//bgp-mp:allow-multiple-as's original type is boolean
	AllowMultipleAs bool `mapstructure:"allow-multiple-as"`
	// original -> bgp-mp:maximum-paths
	MaximumPaths uint32 `mapstructure:"maximum-paths"`
}

func (lhs *EbgpState) Equal(rhs *EbgpState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AllowMultipleAs != rhs.AllowMultipleAs {
		return false
	}
	if lhs.MaximumPaths != rhs.MaximumPaths {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type EbgpConfig struct {
	// original -> bgp-mp:allow-multiple-as
	//bgp-mp:allow-multiple-as's original type is boolean
	AllowMultipleAs bool `mapstructure:"allow-multiple-as"`
	// original -> bgp-mp:maximum-paths
	MaximumPaths uint32 `mapstructure:"maximum-paths"`
}

func (lhs *EbgpConfig) Equal(rhs *EbgpConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AllowMultipleAs != rhs.AllowMultipleAs {
		return false
	}
	if lhs.MaximumPaths != rhs.MaximumPaths {
		return false
	}
	return true
}

//struct for container bgp-mp:ebgp
type Ebgp struct {
	// original -> bgp-mp:ebgp-config
	Config EbgpConfig `mapstructure:"config"`
	// original -> bgp-mp:ebgp-state
	State EbgpState `mapstructure:"state"`
}

func (lhs *Ebgp) Equal(rhs *Ebgp) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type UseMultiplePathsState struct {
	// original -> bgp-mp:enabled
	//bgp-mp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
}

func (lhs *UseMultiplePathsState) Equal(rhs *UseMultiplePathsState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type UseMultiplePathsConfig struct {
	// original -> bgp-mp:enabled
	//bgp-mp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
}

func (lhs *UseMultiplePathsConfig) Equal(rhs *UseMultiplePathsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	return true
}

//struct for container bgp-mp:use-multiple-paths
type UseMultiplePaths struct {
	// original -> bgp-mp:use-multiple-paths-config
	Config UseMultiplePathsConfig `mapstructure:"config"`
	// original -> bgp-mp:use-multiple-paths-state
	State UseMultiplePathsState `mapstructure:"state"`
	// original -> bgp-mp:ebgp
	Ebgp Ebgp `mapstructure:"ebgp"`
	// original -> bgp-mp:ibgp
	Ibgp Ibgp `mapstructure:"ibgp"`
}

func (lhs *UseMultiplePaths) Equal(rhs *UseMultiplePaths) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.Ebgp.Equal(&(rhs.Ebgp)) {
		return false
	}
	if !lhs.Ibgp.Equal(&(rhs.Ibgp)) {
		return false
	}
	return true
}

//struct for container bgp:state
type ConfederationState struct {
	// original -> bgp:enabled
	//bgp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> bgp:identifier
	//bgp:identifier's original type is inet:as-number
	Identifier uint32 `mapstructure:"identifier"`
	// original -> bgp:member-as
	// original type is list of inet:as-number
	MemberAsList []uint32 `mapstructure:"member-as-list"`
}

func (lhs *ConfederationState) Equal(rhs *ConfederationState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.Identifier != rhs.Identifier {
		return false
	}
	if len(lhs.MemberAsList) != len(rhs.MemberAsList) {
		return false
	}
	for idx, l := range lhs.MemberAsList {
		if l != rhs.MemberAsList[idx] {
			return false
		}
	}
	return true
}

//struct for container bgp:config
type ConfederationConfig struct {
	// original -> bgp:enabled
	//bgp:enabled's original type is boolean
	Enabled bool `mapstructure:"enabled"`
	// original -> bgp:identifier
	//bgp:identifier's original type is inet:as-number
	Identifier uint32 `mapstructure:"identifier"`
	// original -> bgp:member-as
	// original type is list of inet:as-number
	MemberAsList []uint32 `mapstructure:"member-as-list"`
}

func (lhs *ConfederationConfig) Equal(rhs *ConfederationConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Enabled != rhs.Enabled {
		return false
	}
	if lhs.Identifier != rhs.Identifier {
		return false
	}
	if len(lhs.MemberAsList) != len(rhs.MemberAsList) {
		return false
	}
	for idx, l := range lhs.MemberAsList {
		if l != rhs.MemberAsList[idx] {
			return false
		}
	}
	return true
}

//struct for container bgp:confederation
type Confederation struct {
	// original -> bgp:confederation-config
	Config ConfederationConfig `mapstructure:"config"`
	// original -> bgp:confederation-state
	State ConfederationState `mapstructure:"state"`
}

func (lhs *Confederation) Equal(rhs *Confederation) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type DefaultRouteDistanceState struct {
	// original -> bgp:external-route-distance
	ExternalRouteDistance uint8 `mapstructure:"external-route-distance"`
	// original -> bgp:internal-route-distance
	InternalRouteDistance uint8 `mapstructure:"internal-route-distance"`
}

func (lhs *DefaultRouteDistanceState) Equal(rhs *DefaultRouteDistanceState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ExternalRouteDistance != rhs.ExternalRouteDistance {
		return false
	}
	if lhs.InternalRouteDistance != rhs.InternalRouteDistance {
		return false
	}
	return true
}

//struct for container bgp:config
type DefaultRouteDistanceConfig struct {
	// original -> bgp:external-route-distance
	ExternalRouteDistance uint8 `mapstructure:"external-route-distance"`
	// original -> bgp:internal-route-distance
	InternalRouteDistance uint8 `mapstructure:"internal-route-distance"`
}

func (lhs *DefaultRouteDistanceConfig) Equal(rhs *DefaultRouteDistanceConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ExternalRouteDistance != rhs.ExternalRouteDistance {
		return false
	}
	if lhs.InternalRouteDistance != rhs.InternalRouteDistance {
		return false
	}
	return true
}

//struct for container bgp:default-route-distance
type DefaultRouteDistance struct {
	// original -> bgp:default-route-distance-config
	Config DefaultRouteDistanceConfig `mapstructure:"config"`
	// original -> bgp:default-route-distance-state
	State DefaultRouteDistanceState `mapstructure:"state"`
}

func (lhs *DefaultRouteDistance) Equal(rhs *DefaultRouteDistance) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp-mp:state
type RouteSelectionOptionsState struct {
	// original -> bgp-mp:always-compare-med
	//bgp-mp:always-compare-med's original type is boolean
	AlwaysCompareMed bool `mapstructure:"always-compare-med"`
	// original -> bgp-mp:ignore-as-path-length
	//bgp-mp:ignore-as-path-length's original type is boolean
	IgnoreAsPathLength bool `mapstructure:"ignore-as-path-length"`
	// original -> bgp-mp:external-compare-router-id
	//bgp-mp:external-compare-router-id's original type is boolean
	ExternalCompareRouterId bool `mapstructure:"external-compare-router-id"`
	// original -> bgp-mp:advertise-inactive-routes
	//bgp-mp:advertise-inactive-routes's original type is boolean
	AdvertiseInactiveRoutes bool `mapstructure:"advertise-inactive-routes"`
	// original -> bgp-mp:enable-aigp
	//bgp-mp:enable-aigp's original type is boolean
	EnableAigp bool `mapstructure:"enable-aigp"`
	// original -> bgp-mp:ignore-next-hop-igp-metric
	//bgp-mp:ignore-next-hop-igp-metric's original type is boolean
	IgnoreNextHopIgpMetric bool `mapstructure:"ignore-next-hop-igp-metric"`
}

func (lhs *RouteSelectionOptionsState) Equal(rhs *RouteSelectionOptionsState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AlwaysCompareMed != rhs.AlwaysCompareMed {
		return false
	}
	if lhs.IgnoreAsPathLength != rhs.IgnoreAsPathLength {
		return false
	}
	if lhs.ExternalCompareRouterId != rhs.ExternalCompareRouterId {
		return false
	}
	if lhs.AdvertiseInactiveRoutes != rhs.AdvertiseInactiveRoutes {
		return false
	}
	if lhs.EnableAigp != rhs.EnableAigp {
		return false
	}
	if lhs.IgnoreNextHopIgpMetric != rhs.IgnoreNextHopIgpMetric {
		return false
	}
	return true
}

//struct for container bgp-mp:config
type RouteSelectionOptionsConfig struct {
	// original -> bgp-mp:always-compare-med
	//bgp-mp:always-compare-med's original type is boolean
	AlwaysCompareMed bool `mapstructure:"always-compare-med"`
	// original -> bgp-mp:ignore-as-path-length
	//bgp-mp:ignore-as-path-length's original type is boolean
	IgnoreAsPathLength bool `mapstructure:"ignore-as-path-length"`
	// original -> bgp-mp:external-compare-router-id
	//bgp-mp:external-compare-router-id's original type is boolean
	ExternalCompareRouterId bool `mapstructure:"external-compare-router-id"`
	// original -> bgp-mp:advertise-inactive-routes
	//bgp-mp:advertise-inactive-routes's original type is boolean
	AdvertiseInactiveRoutes bool `mapstructure:"advertise-inactive-routes"`
	// original -> bgp-mp:enable-aigp
	//bgp-mp:enable-aigp's original type is boolean
	EnableAigp bool `mapstructure:"enable-aigp"`
	// original -> bgp-mp:ignore-next-hop-igp-metric
	//bgp-mp:ignore-next-hop-igp-metric's original type is boolean
	IgnoreNextHopIgpMetric bool `mapstructure:"ignore-next-hop-igp-metric"`
}

func (lhs *RouteSelectionOptionsConfig) Equal(rhs *RouteSelectionOptionsConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AlwaysCompareMed != rhs.AlwaysCompareMed {
		return false
	}
	if lhs.IgnoreAsPathLength != rhs.IgnoreAsPathLength {
		return false
	}
	if lhs.ExternalCompareRouterId != rhs.ExternalCompareRouterId {
		return false
	}
	if lhs.AdvertiseInactiveRoutes != rhs.AdvertiseInactiveRoutes {
		return false
	}
	if lhs.EnableAigp != rhs.EnableAigp {
		return false
	}
	if lhs.IgnoreNextHopIgpMetric != rhs.IgnoreNextHopIgpMetric {
		return false
	}
	return true
}

//struct for container bgp-mp:route-selection-options
type RouteSelectionOptions struct {
	// original -> bgp-mp:route-selection-options-config
	Config RouteSelectionOptionsConfig `mapstructure:"config"`
	// original -> bgp-mp:route-selection-options-state
	State RouteSelectionOptionsState `mapstructure:"state"`
}

func (lhs *RouteSelectionOptions) Equal(rhs *RouteSelectionOptions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	return true
}

//struct for container bgp:state
type GlobalState struct {
	// original -> bgp:as
	//bgp:as's original type is inet:as-number
	As uint32 `mapstructure:"as"`
	// original -> bgp:router-id
	//bgp:router-id's original type is inet:ipv4-address
	RouterId string `mapstructure:"router-id"`
	// original -> bgp-op:total-paths
	TotalPaths uint32 `mapstructure:"total-paths"`
	// original -> bgp-op:total-prefixes
	TotalPrefixes uint32 `mapstructure:"total-prefixes"`
	// original -> gobgp:port
	Port int32 `mapstructure:"port"`
	// original -> gobgp:local-address
	LocalAddressList []string `mapstructure:"local-address-list"`
}

func (lhs *GlobalState) Equal(rhs *GlobalState) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.As != rhs.As {
		return false
	}
	if lhs.RouterId != rhs.RouterId {
		return false
	}
	if lhs.TotalPaths != rhs.TotalPaths {
		return false
	}
	if lhs.TotalPrefixes != rhs.TotalPrefixes {
		return false
	}
	if lhs.Port != rhs.Port {
		return false
	}
	if len(lhs.LocalAddressList) != len(rhs.LocalAddressList) {
		return false
	}
	for idx, l := range lhs.LocalAddressList {
		if l != rhs.LocalAddressList[idx] {
			return false
		}
	}
	return true
}

//struct for container bgp:config
type GlobalConfig struct {
	// original -> bgp:as
	//bgp:as's original type is inet:as-number
	As uint32 `mapstructure:"as"`
	// original -> bgp:router-id
	//bgp:router-id's original type is inet:ipv4-address
	RouterId string `mapstructure:"router-id"`
	// original -> gobgp:port
	Port int32 `mapstructure:"port"`
	// original -> gobgp:local-address
	LocalAddressList []string `mapstructure:"local-address-list"`
}

func (lhs *GlobalConfig) Equal(rhs *GlobalConfig) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.As != rhs.As {
		return false
	}
	if lhs.RouterId != rhs.RouterId {
		return false
	}
	if lhs.Port != rhs.Port {
		return false
	}
	if len(lhs.LocalAddressList) != len(rhs.LocalAddressList) {
		return false
	}
	for idx, l := range lhs.LocalAddressList {
		if l != rhs.LocalAddressList[idx] {
			return false
		}
	}
	return true
}

//struct for container bgp:global
type Global struct {
	// original -> bgp:global-config
	Config GlobalConfig `mapstructure:"config"`
	// original -> bgp:global-state
	State GlobalState `mapstructure:"state"`
	// original -> bgp-mp:route-selection-options
	RouteSelectionOptions RouteSelectionOptions `mapstructure:"route-selection-options"`
	// original -> bgp:default-route-distance
	DefaultRouteDistance DefaultRouteDistance `mapstructure:"default-route-distance"`
	// original -> bgp:confederation
	Confederation Confederation `mapstructure:"confederation"`
	// original -> bgp-mp:use-multiple-paths
	UseMultiplePaths UseMultiplePaths `mapstructure:"use-multiple-paths"`
	// original -> bgp:graceful-restart
	GracefulRestart GracefulRestart `mapstructure:"graceful-restart"`
	// original -> bgp:afi-safis
	AfiSafis []AfiSafi `mapstructure:"afi-safis"`
	// original -> rpol:apply-policy
	ApplyPolicy ApplyPolicy `mapstructure:"apply-policy"`
	// original -> gobgp:mpls-label-range
	MplsLabelRange MplsLabelRange `mapstructure:"mpls-label-range"`
}

func (lhs *Global) Equal(rhs *Global) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Config.Equal(&(rhs.Config)) {
		return false
	}
	if !lhs.RouteSelectionOptions.Equal(&(rhs.RouteSelectionOptions)) {
		return false
	}
	if !lhs.DefaultRouteDistance.Equal(&(rhs.DefaultRouteDistance)) {
		return false
	}
	if !lhs.Confederation.Equal(&(rhs.Confederation)) {
		return false
	}
	if !lhs.UseMultiplePaths.Equal(&(rhs.UseMultiplePaths)) {
		return false
	}
	if !lhs.GracefulRestart.Equal(&(rhs.GracefulRestart)) {
		return false
	}
	if len(lhs.AfiSafis) != len(rhs.AfiSafis) {
		return false
	}
	{
		lmap := make(map[string]*AfiSafi)
		for i, l := range lhs.AfiSafis {
			lmap[mapkey(i, string(l.Config.AfiSafiName))] = &lhs.AfiSafis[i]
		}
		for i, r := range rhs.AfiSafis {
			if l, y := lmap[mapkey(i, string(r.Config.AfiSafiName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.ApplyPolicy.Equal(&(rhs.ApplyPolicy)) {
		return false
	}
	if !lhs.MplsLabelRange.Equal(&(rhs.MplsLabelRange)) {
		return false
	}
	return true
}

//struct for container bgp:bgp
type Bgp struct {
	// original -> bgp:global
	Global Global `mapstructure:"global"`
	// original -> bgp:neighbors
	Neighbors []Neighbor `mapstructure:"neighbors"`
	// original -> bgp:peer-groups
	PeerGroups []PeerGroup `mapstructure:"peer-groups"`
	// original -> gobgp:rpki-servers
	RpkiServers []RpkiServer `mapstructure:"rpki-servers"`
	// original -> gobgp:bmp-servers
	BmpServers []BmpServer `mapstructure:"bmp-servers"`
	// original -> gobgp:mrt-dump
	MrtDump []Mrt `mapstructure:"mrt-dump"`
	// original -> gobgp:zebra
	Zebra Zebra `mapstructure:"zebra"`
	// original -> gobgp:collector
	Collector Collector `mapstructure:"collector"`
}

func (lhs *Bgp) Equal(rhs *Bgp) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.Global.Equal(&(rhs.Global)) {
		return false
	}
	if len(lhs.Neighbors) != len(rhs.Neighbors) {
		return false
	}
	{
		lmap := make(map[string]*Neighbor)
		for i, l := range lhs.Neighbors {
			lmap[mapkey(i, string(l.Config.NeighborAddress))] = &lhs.Neighbors[i]
		}
		for i, r := range rhs.Neighbors {
			if l, y := lmap[mapkey(i, string(r.Config.NeighborAddress))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.PeerGroups) != len(rhs.PeerGroups) {
		return false
	}
	{
		lmap := make(map[string]*PeerGroup)
		for i, l := range lhs.PeerGroups {
			lmap[mapkey(i, string(l.Config.PeerGroupName))] = &lhs.PeerGroups[i]
		}
		for i, r := range rhs.PeerGroups {
			if l, y := lmap[mapkey(i, string(r.Config.PeerGroupName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.RpkiServers) != len(rhs.RpkiServers) {
		return false
	}
	{
		lmap := make(map[string]*RpkiServer)
		for i, l := range lhs.RpkiServers {
			lmap[mapkey(i, string(l.Config.Address))] = &lhs.RpkiServers[i]
		}
		for i, r := range rhs.RpkiServers {
			if l, y := lmap[mapkey(i, string(r.Config.Address))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.BmpServers) != len(rhs.BmpServers) {
		return false
	}
	{
		lmap := make(map[string]*BmpServer)
		for i, l := range lhs.BmpServers {
			lmap[mapkey(i, string(l.Config.Address))] = &lhs.BmpServers[i]
		}
		for i, r := range rhs.BmpServers {
			if l, y := lmap[mapkey(i, string(r.Config.Address))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.MrtDump) != len(rhs.MrtDump) {
		return false
	}
	{
		lmap := make(map[string]*Mrt)
		for i, l := range lhs.MrtDump {
			lmap[mapkey(i, string(l.Config.FileName))] = &lhs.MrtDump[i]
		}
		for i, r := range rhs.MrtDump {
			if l, y := lmap[mapkey(i, string(r.Config.FileName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.Zebra.Equal(&(rhs.Zebra)) {
		return false
	}
	if !lhs.Collector.Equal(&(rhs.Collector)) {
		return false
	}
	return true
}

//struct for container bgp-pol:set-ext-community-method
type SetExtCommunityMethod struct {
	// original -> bgp-pol:communities
	// original type is list of union
	CommunitiesList []string `mapstructure:"communities-list"`
	// original -> bgp-pol:ext-community-set-ref
	ExtCommunitySetRef string `mapstructure:"ext-community-set-ref"`
}

func (lhs *SetExtCommunityMethod) Equal(rhs *SetExtCommunityMethod) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.CommunitiesList) != len(rhs.CommunitiesList) {
		return false
	}
	for idx, l := range lhs.CommunitiesList {
		if l != rhs.CommunitiesList[idx] {
			return false
		}
	}
	if lhs.ExtCommunitySetRef != rhs.ExtCommunitySetRef {
		return false
	}
	return true
}

//struct for container bgp-pol:set-ext-community
type SetExtCommunity struct {
	// original -> bgp-pol:set-ext-community-method
	SetExtCommunityMethod SetExtCommunityMethod `mapstructure:"set-ext-community-method"`
	// original -> bgp-pol:options
	//bgp-pol:options's original type is bgp-set-community-option-type
	Options string `mapstructure:"options"`
}

func (lhs *SetExtCommunity) Equal(rhs *SetExtCommunity) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.SetExtCommunityMethod.Equal(&(rhs.SetExtCommunityMethod)) {
		return false
	}
	if lhs.Options != rhs.Options {
		return false
	}
	return true
}

//struct for container bgp-pol:set-community-method
type SetCommunityMethod struct {
	// original -> bgp-pol:communities
	// original type is list of union
	CommunitiesList []string `mapstructure:"communities-list"`
	// original -> bgp-pol:community-set-ref
	CommunitySetRef string `mapstructure:"community-set-ref"`
}

func (lhs *SetCommunityMethod) Equal(rhs *SetCommunityMethod) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.CommunitiesList) != len(rhs.CommunitiesList) {
		return false
	}
	for idx, l := range lhs.CommunitiesList {
		if l != rhs.CommunitiesList[idx] {
			return false
		}
	}
	if lhs.CommunitySetRef != rhs.CommunitySetRef {
		return false
	}
	return true
}

//struct for container bgp-pol:set-community
type SetCommunity struct {
	// original -> bgp-pol:set-community-method
	SetCommunityMethod SetCommunityMethod `mapstructure:"set-community-method"`
	// original -> bgp-pol:options
	//bgp-pol:options's original type is bgp-set-community-option-type
	Options string `mapstructure:"options"`
}

func (lhs *SetCommunity) Equal(rhs *SetCommunity) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.SetCommunityMethod.Equal(&(rhs.SetCommunityMethod)) {
		return false
	}
	if lhs.Options != rhs.Options {
		return false
	}
	return true
}

//struct for container bgp-pol:set-as-path-prepend
type SetAsPathPrepend struct {
	// original -> bgp-pol:repeat-n
	RepeatN uint8 `mapstructure:"repeat-n"`
	// original -> gobgp:as
	//gobgp:as's original type is union
	As string `mapstructure:"as"`
}

func (lhs *SetAsPathPrepend) Equal(rhs *SetAsPathPrepend) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.RepeatN != rhs.RepeatN {
		return false
	}
	if lhs.As != rhs.As {
		return false
	}
	return true
}

//struct for container bgp-pol:bgp-actions
type BgpActions struct {
	// original -> bgp-pol:set-as-path-prepend
	SetAsPathPrepend SetAsPathPrepend `mapstructure:"set-as-path-prepend"`
	// original -> bgp-pol:set-community
	SetCommunity SetCommunity `mapstructure:"set-community"`
	// original -> bgp-pol:set-ext-community
	SetExtCommunity SetExtCommunity `mapstructure:"set-ext-community"`
	// original -> bgp-pol:set-route-origin
	SetRouteOrigin BgpOriginAttrType `mapstructure:"set-route-origin"`
	// original -> bgp-pol:set-local-pref
	SetLocalPref uint32 `mapstructure:"set-local-pref"`
	// original -> bgp-pol:set-next-hop
	SetNextHop BgpNextHopType `mapstructure:"set-next-hop"`
	// original -> bgp-pol:set-med
	SetMed BgpSetMedType `mapstructure:"set-med"`
}

func (lhs *BgpActions) Equal(rhs *BgpActions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.SetAsPathPrepend.Equal(&(rhs.SetAsPathPrepend)) {
		return false
	}
	if !lhs.SetCommunity.Equal(&(rhs.SetCommunity)) {
		return false
	}
	if !lhs.SetExtCommunity.Equal(&(rhs.SetExtCommunity)) {
		return false
	}
	if lhs.SetRouteOrigin != rhs.SetRouteOrigin {
		return false
	}
	if lhs.SetLocalPref != rhs.SetLocalPref {
		return false
	}
	if lhs.SetNextHop != rhs.SetNextHop {
		return false
	}
	if lhs.SetMed != rhs.SetMed {
		return false
	}
	return true
}

//struct for container rpol:igp-actions
type IgpActions struct {
	// original -> rpol:set-tag
	SetTag TagType `mapstructure:"set-tag"`
}

func (lhs *IgpActions) Equal(rhs *IgpActions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.SetTag != rhs.SetTag {
		return false
	}
	return true
}

//struct for container rpol:route-disposition
type RouteDisposition struct {
	// original -> rpol:accept-route
	//rpol:accept-route's original type is empty
	AcceptRoute bool `mapstructure:"accept-route"`
	// original -> rpol:reject-route
	//rpol:reject-route's original type is empty
	RejectRoute bool `mapstructure:"reject-route"`
}

func (lhs *RouteDisposition) Equal(rhs *RouteDisposition) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AcceptRoute != rhs.AcceptRoute {
		return false
	}
	if lhs.RejectRoute != rhs.RejectRoute {
		return false
	}
	return true
}

//struct for container rpol:actions
type Actions struct {
	// original -> rpol:route-disposition
	RouteDisposition RouteDisposition `mapstructure:"route-disposition"`
	// original -> rpol:igp-actions
	IgpActions IgpActions `mapstructure:"igp-actions"`
	// original -> bgp-pol:bgp-actions
	BgpActions BgpActions `mapstructure:"bgp-actions"`
}

func (lhs *Actions) Equal(rhs *Actions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.RouteDisposition.Equal(&(rhs.RouteDisposition)) {
		return false
	}
	if !lhs.IgpActions.Equal(&(rhs.IgpActions)) {
		return false
	}
	if !lhs.BgpActions.Equal(&(rhs.BgpActions)) {
		return false
	}
	return true
}

//struct for container bgp-pol:as-path-length
type AsPathLength struct {
	// original -> ptypes:operator
	Operator AttributeComparison `mapstructure:"operator"`
	// original -> ptypes:value
	Value uint32 `mapstructure:"value"`
}

func (lhs *AsPathLength) Equal(rhs *AsPathLength) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Operator != rhs.Operator {
		return false
	}
	if lhs.Value != rhs.Value {
		return false
	}
	return true
}

//struct for container bgp-pol:community-count
type CommunityCount struct {
	// original -> ptypes:operator
	Operator AttributeComparison `mapstructure:"operator"`
	// original -> ptypes:value
	Value uint32 `mapstructure:"value"`
}

func (lhs *CommunityCount) Equal(rhs *CommunityCount) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Operator != rhs.Operator {
		return false
	}
	if lhs.Value != rhs.Value {
		return false
	}
	return true
}

//struct for container bgp-pol:match-as-path-set
type MatchAsPathSet struct {
	// original -> bgp-pol:as-path-set
	AsPathSet string `mapstructure:"as-path-set"`
	// original -> rpol:match-set-options
	MatchSetOptions MatchSetOptionsType `mapstructure:"match-set-options"`
}

func (lhs *MatchAsPathSet) Equal(rhs *MatchAsPathSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AsPathSet != rhs.AsPathSet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

//struct for container bgp-pol:match-ext-community-set
type MatchExtCommunitySet struct {
	// original -> bgp-pol:ext-community-set
	ExtCommunitySet string `mapstructure:"ext-community-set"`
	// original -> rpol:match-set-options
	MatchSetOptions MatchSetOptionsType `mapstructure:"match-set-options"`
}

func (lhs *MatchExtCommunitySet) Equal(rhs *MatchExtCommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ExtCommunitySet != rhs.ExtCommunitySet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

//struct for container bgp-pol:match-community-set
type MatchCommunitySet struct {
	// original -> bgp-pol:community-set
	CommunitySet string `mapstructure:"community-set"`
	// original -> rpol:match-set-options
	MatchSetOptions MatchSetOptionsType `mapstructure:"match-set-options"`
}

func (lhs *MatchCommunitySet) Equal(rhs *MatchCommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.CommunitySet != rhs.CommunitySet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

//struct for container bgp-pol:bgp-conditions
type BgpConditions struct {
	// original -> bgp-pol:match-community-set
	MatchCommunitySet MatchCommunitySet `mapstructure:"match-community-set"`
	// original -> bgp-pol:match-ext-community-set
	MatchExtCommunitySet MatchExtCommunitySet `mapstructure:"match-ext-community-set"`
	// original -> bgp-pol:match-as-path-set
	MatchAsPathSet MatchAsPathSet `mapstructure:"match-as-path-set"`
	// original -> bgp-pol:med-eq
	MedEq uint32 `mapstructure:"med-eq"`
	// original -> bgp-pol:origin-eq
	OriginEq BgpOriginAttrType `mapstructure:"origin-eq"`
	// original -> bgp-pol:next-hop-in
	// original type is list of inet:ip-address
	NextHopInList []string `mapstructure:"next-hop-in-list"`
	// original -> bgp-pol:afi-safi-in
	AfiSafiInList []AfiSafiType `mapstructure:"afi-safi-in-list"`
	// original -> bgp-pol:local-pref-eq
	LocalPrefEq uint32 `mapstructure:"local-pref-eq"`
	// original -> bgp-pol:community-count
	CommunityCount CommunityCount `mapstructure:"community-count"`
	// original -> bgp-pol:as-path-length
	AsPathLength AsPathLength `mapstructure:"as-path-length"`
	// original -> bgp-pol:route-type
	RouteType RouteType `mapstructure:"route-type"`
	// original -> gobgp:rpki-validation-result
	RpkiValidationResult RpkiValidationResultType `mapstructure:"rpki-validation-result"`
}

func (lhs *BgpConditions) Equal(rhs *BgpConditions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.MatchCommunitySet.Equal(&(rhs.MatchCommunitySet)) {
		return false
	}
	if !lhs.MatchExtCommunitySet.Equal(&(rhs.MatchExtCommunitySet)) {
		return false
	}
	if !lhs.MatchAsPathSet.Equal(&(rhs.MatchAsPathSet)) {
		return false
	}
	if lhs.MedEq != rhs.MedEq {
		return false
	}
	if lhs.OriginEq != rhs.OriginEq {
		return false
	}
	if len(lhs.NextHopInList) != len(rhs.NextHopInList) {
		return false
	}
	for idx, l := range lhs.NextHopInList {
		if l != rhs.NextHopInList[idx] {
			return false
		}
	}
	if len(lhs.AfiSafiInList) != len(rhs.AfiSafiInList) {
		return false
	}
	for idx, l := range lhs.AfiSafiInList {
		if l != rhs.AfiSafiInList[idx] {
			return false
		}
	}
	if lhs.LocalPrefEq != rhs.LocalPrefEq {
		return false
	}
	if !lhs.CommunityCount.Equal(&(rhs.CommunityCount)) {
		return false
	}
	if !lhs.AsPathLength.Equal(&(rhs.AsPathLength)) {
		return false
	}
	if lhs.RouteType != rhs.RouteType {
		return false
	}
	if lhs.RpkiValidationResult != rhs.RpkiValidationResult {
		return false
	}
	return true
}

//struct for container rpol:igp-conditions
type IgpConditions struct {
}

func (lhs *IgpConditions) Equal(rhs *IgpConditions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	return true
}

//struct for container rpol:match-tag-set
type MatchTagSet struct {
	// original -> rpol:tag-set
	TagSet string `mapstructure:"tag-set"`
	// original -> rpol:match-set-options
	MatchSetOptions MatchSetOptionsRestrictedType `mapstructure:"match-set-options"`
}

func (lhs *MatchTagSet) Equal(rhs *MatchTagSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TagSet != rhs.TagSet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

//struct for container rpol:match-neighbor-set
type MatchNeighborSet struct {
	// original -> rpol:neighbor-set
	NeighborSet string `mapstructure:"neighbor-set"`
	// original -> rpol:match-set-options
	MatchSetOptions MatchSetOptionsRestrictedType `mapstructure:"match-set-options"`
}

func (lhs *MatchNeighborSet) Equal(rhs *MatchNeighborSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.NeighborSet != rhs.NeighborSet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

//struct for container rpol:match-prefix-set
type MatchPrefixSet struct {
	// original -> rpol:prefix-set
	PrefixSet string `mapstructure:"prefix-set"`
	// original -> rpol:match-set-options
	MatchSetOptions MatchSetOptionsRestrictedType `mapstructure:"match-set-options"`
}

func (lhs *MatchPrefixSet) Equal(rhs *MatchPrefixSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PrefixSet != rhs.PrefixSet {
		return false
	}
	if lhs.MatchSetOptions != rhs.MatchSetOptions {
		return false
	}
	return true
}

//struct for container rpol:conditions
type Conditions struct {
	// original -> rpol:call-policy
	CallPolicy string `mapstructure:"call-policy"`
	// original -> rpol:match-prefix-set
	MatchPrefixSet MatchPrefixSet `mapstructure:"match-prefix-set"`
	// original -> rpol:match-neighbor-set
	MatchNeighborSet MatchNeighborSet `mapstructure:"match-neighbor-set"`
	// original -> rpol:match-tag-set
	MatchTagSet MatchTagSet `mapstructure:"match-tag-set"`
	// original -> rpol:install-protocol-eq
	InstallProtocolEq InstallProtocolType `mapstructure:"install-protocol-eq"`
	// original -> rpol:igp-conditions
	IgpConditions IgpConditions `mapstructure:"igp-conditions"`
	// original -> bgp-pol:bgp-conditions
	BgpConditions BgpConditions `mapstructure:"bgp-conditions"`
}

func (lhs *Conditions) Equal(rhs *Conditions) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.CallPolicy != rhs.CallPolicy {
		return false
	}
	if !lhs.MatchPrefixSet.Equal(&(rhs.MatchPrefixSet)) {
		return false
	}
	if !lhs.MatchNeighborSet.Equal(&(rhs.MatchNeighborSet)) {
		return false
	}
	if !lhs.MatchTagSet.Equal(&(rhs.MatchTagSet)) {
		return false
	}
	if lhs.InstallProtocolEq != rhs.InstallProtocolEq {
		return false
	}
	if !lhs.IgpConditions.Equal(&(rhs.IgpConditions)) {
		return false
	}
	if !lhs.BgpConditions.Equal(&(rhs.BgpConditions)) {
		return false
	}
	return true
}

//struct for container rpol:statement
type Statement struct {
	// original -> rpol:name
	Name string `mapstructure:"name"`
	// original -> rpol:conditions
	Conditions Conditions `mapstructure:"conditions"`
	// original -> rpol:actions
	Actions Actions `mapstructure:"actions"`
}

func (lhs *Statement) Equal(rhs *Statement) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Name != rhs.Name {
		return false
	}
	if !lhs.Conditions.Equal(&(rhs.Conditions)) {
		return false
	}
	if !lhs.Actions.Equal(&(rhs.Actions)) {
		return false
	}
	return true
}

//struct for container rpol:policy-definition
type PolicyDefinition struct {
	// original -> rpol:name
	Name string `mapstructure:"name"`
	// original -> rpol:statements
	Statements []Statement `mapstructure:"statements"`
}

func (lhs *PolicyDefinition) Equal(rhs *PolicyDefinition) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Name != rhs.Name {
		return false
	}
	if len(lhs.Statements) != len(rhs.Statements) {
		return false
	}
	{
		lmap := make(map[string]*Statement)
		for i, l := range lhs.Statements {
			lmap[mapkey(i, string(l.Name))] = &lhs.Statements[i]
		}
		for i, r := range rhs.Statements {
			if l, y := lmap[mapkey(i, string(r.Name))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

//struct for container bgp-pol:as-path-set
type AsPathSet struct {
	// original -> bgp-pol:as-path-set-name
	AsPathSetName string `mapstructure:"as-path-set-name"`
	// original -> gobgp:as-path
	AsPathList []string `mapstructure:"as-path-list"`
}

func (lhs *AsPathSet) Equal(rhs *AsPathSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.AsPathSetName != rhs.AsPathSetName {
		return false
	}
	if len(lhs.AsPathList) != len(rhs.AsPathList) {
		return false
	}
	for idx, l := range lhs.AsPathList {
		if l != rhs.AsPathList[idx] {
			return false
		}
	}
	return true
}

//struct for container bgp-pol:ext-community-set
type ExtCommunitySet struct {
	// original -> bgp-pol:ext-community-set-name
	ExtCommunitySetName string `mapstructure:"ext-community-set-name"`
	// original -> gobgp:ext-community
	ExtCommunityList []string `mapstructure:"ext-community-list"`
}

func (lhs *ExtCommunitySet) Equal(rhs *ExtCommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.ExtCommunitySetName != rhs.ExtCommunitySetName {
		return false
	}
	if len(lhs.ExtCommunityList) != len(rhs.ExtCommunityList) {
		return false
	}
	for idx, l := range lhs.ExtCommunityList {
		if l != rhs.ExtCommunityList[idx] {
			return false
		}
	}
	return true
}

//struct for container bgp-pol:community-set
type CommunitySet struct {
	// original -> bgp-pol:community-set-name
	CommunitySetName string `mapstructure:"community-set-name"`
	// original -> gobgp:community
	CommunityList []string `mapstructure:"community-list"`
}

func (lhs *CommunitySet) Equal(rhs *CommunitySet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.CommunitySetName != rhs.CommunitySetName {
		return false
	}
	if len(lhs.CommunityList) != len(rhs.CommunityList) {
		return false
	}
	for idx, l := range lhs.CommunityList {
		if l != rhs.CommunityList[idx] {
			return false
		}
	}
	return true
}

//struct for container bgp-pol:bgp-defined-sets
type BgpDefinedSets struct {
	// original -> bgp-pol:community-sets
	CommunitySets []CommunitySet `mapstructure:"community-sets"`
	// original -> bgp-pol:ext-community-sets
	ExtCommunitySets []ExtCommunitySet `mapstructure:"ext-community-sets"`
	// original -> bgp-pol:as-path-sets
	AsPathSets []AsPathSet `mapstructure:"as-path-sets"`
}

func (lhs *BgpDefinedSets) Equal(rhs *BgpDefinedSets) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.CommunitySets) != len(rhs.CommunitySets) {
		return false
	}
	{
		lmap := make(map[string]*CommunitySet)
		for i, l := range lhs.CommunitySets {
			lmap[mapkey(i, string(l.CommunitySetName))] = &lhs.CommunitySets[i]
		}
		for i, r := range rhs.CommunitySets {
			if l, y := lmap[mapkey(i, string(r.CommunitySetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.ExtCommunitySets) != len(rhs.ExtCommunitySets) {
		return false
	}
	{
		lmap := make(map[string]*ExtCommunitySet)
		for i, l := range lhs.ExtCommunitySets {
			lmap[mapkey(i, string(l.ExtCommunitySetName))] = &lhs.ExtCommunitySets[i]
		}
		for i, r := range rhs.ExtCommunitySets {
			if l, y := lmap[mapkey(i, string(r.ExtCommunitySetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.AsPathSets) != len(rhs.AsPathSets) {
		return false
	}
	{
		lmap := make(map[string]*AsPathSet)
		for i, l := range lhs.AsPathSets {
			lmap[mapkey(i, string(l.AsPathSetName))] = &lhs.AsPathSets[i]
		}
		for i, r := range rhs.AsPathSets {
			if l, y := lmap[mapkey(i, string(r.AsPathSetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

//struct for container rpol:tag
type Tag struct {
	// original -> rpol:value
	Value TagType `mapstructure:"value"`
}

func (lhs *Tag) Equal(rhs *Tag) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.Value != rhs.Value {
		return false
	}
	return true
}

//struct for container rpol:tag-set
type TagSet struct {
	// original -> rpol:tag-set-name
	TagSetName string `mapstructure:"tag-set-name"`
	// original -> rpol:tag
	TagList []Tag `mapstructure:"tag-list"`
}

func (lhs *TagSet) Equal(rhs *TagSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.TagSetName != rhs.TagSetName {
		return false
	}
	if len(lhs.TagList) != len(rhs.TagList) {
		return false
	}
	{
		lmap := make(map[string]*Tag)
		for i, l := range lhs.TagList {
			lmap[mapkey(i, string(l.Value))] = &lhs.TagList[i]
		}
		for i, r := range rhs.TagList {
			if l, y := lmap[mapkey(i, string(r.Value))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

//struct for container rpol:neighbor-set
type NeighborSet struct {
	// original -> rpol:neighbor-set-name
	NeighborSetName string `mapstructure:"neighbor-set-name"`
	// original -> gobgp:neighbor-info
	// original type is list of inet:ip-address
	NeighborInfoList []string `mapstructure:"neighbor-info-list"`
}

func (lhs *NeighborSet) Equal(rhs *NeighborSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.NeighborSetName != rhs.NeighborSetName {
		return false
	}
	if len(lhs.NeighborInfoList) != len(rhs.NeighborInfoList) {
		return false
	}
	for idx, l := range lhs.NeighborInfoList {
		if l != rhs.NeighborInfoList[idx] {
			return false
		}
	}
	return true
}

//struct for container rpol:prefix
type Prefix struct {
	// original -> rpol:ip-prefix
	//rpol:ip-prefix's original type is inet:ip-prefix
	IpPrefix string `mapstructure:"ip-prefix"`
	// original -> rpol:masklength-range
	MasklengthRange string `mapstructure:"masklength-range"`
}

func (lhs *Prefix) Equal(rhs *Prefix) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.IpPrefix != rhs.IpPrefix {
		return false
	}
	if lhs.MasklengthRange != rhs.MasklengthRange {
		return false
	}
	return true
}

//struct for container rpol:prefix-set
type PrefixSet struct {
	// original -> rpol:prefix-set-name
	PrefixSetName string `mapstructure:"prefix-set-name"`
	// original -> rpol:prefix
	PrefixList []Prefix `mapstructure:"prefix-list"`
}

func (lhs *PrefixSet) Equal(rhs *PrefixSet) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if lhs.PrefixSetName != rhs.PrefixSetName {
		return false
	}
	if len(lhs.PrefixList) != len(rhs.PrefixList) {
		return false
	}
	{
		lmap := make(map[string]*Prefix)
		for i, l := range lhs.PrefixList {
			lmap[mapkey(i, string(l.IpPrefix+l.MasklengthRange))] = &lhs.PrefixList[i]
		}
		for i, r := range rhs.PrefixList {
			if l, y := lmap[mapkey(i, string(r.IpPrefix+r.MasklengthRange))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}

//struct for container rpol:defined-sets
type DefinedSets struct {
	// original -> rpol:prefix-sets
	PrefixSets []PrefixSet `mapstructure:"prefix-sets"`
	// original -> rpol:neighbor-sets
	NeighborSets []NeighborSet `mapstructure:"neighbor-sets"`
	// original -> rpol:tag-sets
	TagSets []TagSet `mapstructure:"tag-sets"`
	// original -> bgp-pol:bgp-defined-sets
	BgpDefinedSets BgpDefinedSets `mapstructure:"bgp-defined-sets"`
}

func (lhs *DefinedSets) Equal(rhs *DefinedSets) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if len(lhs.PrefixSets) != len(rhs.PrefixSets) {
		return false
	}
	{
		lmap := make(map[string]*PrefixSet)
		for i, l := range lhs.PrefixSets {
			lmap[mapkey(i, string(l.PrefixSetName))] = &lhs.PrefixSets[i]
		}
		for i, r := range rhs.PrefixSets {
			if l, y := lmap[mapkey(i, string(r.PrefixSetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.NeighborSets) != len(rhs.NeighborSets) {
		return false
	}
	{
		lmap := make(map[string]*NeighborSet)
		for i, l := range lhs.NeighborSets {
			lmap[mapkey(i, string(l.NeighborSetName))] = &lhs.NeighborSets[i]
		}
		for i, r := range rhs.NeighborSets {
			if l, y := lmap[mapkey(i, string(r.NeighborSetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if len(lhs.TagSets) != len(rhs.TagSets) {
		return false
	}
	{
		lmap := make(map[string]*TagSet)
		for i, l := range lhs.TagSets {
			lmap[mapkey(i, string(l.TagSetName))] = &lhs.TagSets[i]
		}
		for i, r := range rhs.TagSets {
			if l, y := lmap[mapkey(i, string(r.TagSetName))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	if !lhs.BgpDefinedSets.Equal(&(rhs.BgpDefinedSets)) {
		return false
	}
	return true
}

//struct for container rpol:routing-policy
type RoutingPolicy struct {
	// original -> rpol:defined-sets
	DefinedSets DefinedSets `mapstructure:"defined-sets"`
	// original -> rpol:policy-definitions
	PolicyDefinitions []PolicyDefinition `mapstructure:"policy-definitions"`
}

func (lhs *RoutingPolicy) Equal(rhs *RoutingPolicy) bool {
	if lhs == nil || rhs == nil {
		return false
	}
	if !lhs.DefinedSets.Equal(&(rhs.DefinedSets)) {
		return false
	}
	if len(lhs.PolicyDefinitions) != len(rhs.PolicyDefinitions) {
		return false
	}
	{
		lmap := make(map[string]*PolicyDefinition)
		for i, l := range lhs.PolicyDefinitions {
			lmap[mapkey(i, string(l.Name))] = &lhs.PolicyDefinitions[i]
		}
		for i, r := range rhs.PolicyDefinitions {
			if l, y := lmap[mapkey(i, string(r.Name))]; !y {
				return false
			} else if !r.Equal(l) {
				return false
			}
		}
	}
	return true
}
