# Changelog

## [v0.6.0] 2023-07-02
### Added
- Add support for sending Out of Band Data (OOB).
- Add SCRAM-SHA-1, SCRAM-SHA-256 and SCRAM-SHA512 support (via go-xmpp commit bef3e54).
- Add support for messages of type headline.

### Changed
- Print `--help` output to stdout instead of stderr.
- Print sent stanzas when `--debug` is used (via go-xmpp commit 9129a110df1b).
- Allow JIDs without localpart.
- Use single quotes for attributes in stanzas created by github.com/beevik/etree (vial etree v1.1.4).
- Fix SRV lookup when the domain has a CNAME (via xmppsrv v0.2.5).
- Fall back to directTLS on port 5223 (instead of StartTLS on port 5222) if no SRV records are provided and `-t` is set.
- Remove trailing newlines in interactive mode.

## [v0.5.6] 2022-11-11
### Added
- Add short option `-h` for http-upload.
### Changed
- Fix Ox key generation.

## [v0.5.5] 2022-10-16
### Changed
- Improve interactive mode.

## [v0.5.4] 2022-09-30
### Changed
- Fix http-upload.

## [v0.5.3] 2022-09-29
### Changed
- Don't check for empty message when `--listen` is used.

## [v0.5.2] 2022-09-29
### Added
- Reply to `disco#info` queries.
- Send `service-unavailable` errors for all other IQs of type `get` and `set`.
- New config option and command line flag `alias` to uncouple MUC nickname/alias from resource.

### Changed
- Ox: Improve error messages for failed key requests.
- Ox: Do not encrypt empty messages.
- Check for empty messages.
- Always look up CNAME before doing SRV lookups (via xmppsrv v0.2.3).
- Detect CNAME loops (max. 5 CNAMEs) (via xmppsrv >= v0.2.4).
- Deprecate resource config option and command line flag.
- Improve error handling in XML parsing.
- Don't connect to the XMPP server if the message is empty.

## [v0.5.1] 2022-05-22
### Changed
- Improve listening mode for groupchats.
- Fix nickname in MUCs if not manually set.

## [v0.5.0] 2022-05-05
### Added
- Add possibility to delete existing OpenPGP for XMPP nodes.

### Changed
- Ox: Improve rpad generation.
- Rework receiving of stanzas.
- Ox: Improve private key import.

## [v0.4.0] 2022-04-30
### Added
- Experimental support for Ox (OpenPGP for XMPP) encryption.

### Changed
- Shorter random ID for resource.
- Changed to the more flexible "github.com/beevik/etree" instead of encoding/xml for creating and interpreting stanzas.
- Changed to use message stamp, if provided, for printing the time stamp of received messages.

## [v0.3.0] 2022-03-21
### Added
- Added support for joining password protected MUCs.

### Changed
- Removed invalid code points from input.
- Fixed crash when reading a config with wrong syntax.
- Fixed crash when a non-existing or non-readable config was supplied by `-f`.
- Changed config file location from `~/.config/go-sendxmpp/sendxmpprc` to `~/.config/go-sendxmpp/config`.
- Fixed blocking of go-sendxmpp if an IQ reply of type "error" is received (via go-xmpp v0.0.0-20220319135856-e773596ea0b0).

## [v0.2.0] 2022-02-12
### Added
- Added listening function.
- Added flag to configure connection timeout.
- Added flag to configure minimum TLS version.
- Added flag to show version.

### Removed
- Removed deprecated option `-x`.

## [v0.1.3] 2022-01-29
### Changed
- Rename files to use a limited character set (alpha numerical and some extra characters) file name before uploading. Workaround for https://github.com/mattn/go-xmpp/issues/132

## [v0.1.2] 2021-11-18
### Changed
- Use xml.Marshal to safely build HTTP Upload request.
- Use salsa.debian.org/mdosch/xmppsrv for SRV lookups.

## [v0.1.1] 2021-09-12
### Changed
- Xml-escape file name in http-upload.
- Xml-escape mimetype in http-upload.

## [v0.1.0] 2021-09-11
### Added
- Initial release
