/*  GNU Robbo
 *  Copyright (C) notes:
 *  An Idea and Atari version: LK Avalon, Janusz Pelc, 1989
 *                 Linux Code: Arkadiusz Lipiec, 2002-2009
 *                                 <arkadiusz.lipiec@gmail.com>
 *                             Thunor 2007-2009
 *                                 <thunorsif@hotmail.com>
 *
 *  GNU Robbo is free software - you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GNU Robbo is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the impled warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU CC; see the file COPYING. If not, write to the
 *  Free Software Foundation, 59 Temple Place - Suite 330,
 *  Boston, MA 02111-1307, USA.
 *
 */

/* Defines */
/* These dictate what gets redrawn */
#define REDRAW_INITIALISE 3
#define REDRAW_EVERYTHING 2
#define REDRAW_INTERMEDIATE 1
#define REDRAW_ANIMATED 0

/* Scoreline redraw bits */
#define SCORELINE_ICONS 1
#define SCORELINE_SCREWS 2
#define SCORELINE_KEYS 4
#define SCORELINE_BULLETS 8
#define SCORELINE_LEVEL 16
#define SCORELINE_PACK 32
#define SCORELINE_AUTHOR 64

/* Variables */
SDL_Surface *screen;

struct {
	int xoffset;
	int yoffset;
	int redraw;			/* An ORed combination of SCORELINE_* bits */
} scoreline;

struct {
	int xoffset;
	int yoffset;
} authorline;

struct {
	int xres;
	int yres;
	int field_size;
	int fullscreen;		/* 0 or SDL_FULLSCREEN */
} video;

/* Function prototypes */
void show_game_area(int redrawlevel);
void show_game_area_fade(int redrawlevel, int type);
SDL_Rect set_rect(int x, int y, int w, int h);
int set_video_mode(void);
void toggle_fullscreen(int *fullscreen);
void show_level_colour(int debug_colour_select_r, int debug_colour_select_g, int debug_colour_select_b, int debug_colour_select_component);
void inc_colour_component(int *colour_component);
void dec_colour_component(int *colour_component);
void show_introscreen(int redrawlevel);
void show_helpscreen(int redrawlevel);
void show_optionsscreen(int redrawlevel);
void show_message_box(int redrawlevel, char *name, int timeout, char *message, int dynamic, int width, int height);
void show_endscreen(void);




