/* -*- c++ -*- */
/*
 * Copyright 2003,2010,2012 Free Software Foundation, Inc.
 *
 * This file is part of GNU Radio
 *
 * GNU Radio is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3, or (at your option)
 * any later version.
 *
 * GNU Radio is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with GNU Radio; see the file COPYING.  If not, write to
 * the Free Software Foundation, Inc., 51 Franklin Street,
 * Boston, MA 02110-1301, USA.
 */

/*
 * WARNING: This file is automatically generated by cmake. 
 * Any changes made to this file will be overwritten.
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "@IMPL_NAME@.h"
#include <gnuradio/io_signature.h>
#include <volk/volk.h>

namespace gr {
  namespace filter {
    
    @BASE_NAME@::sptr
    @BASE_NAME@::make(int decimation,
		      const std::vector<@TAP_TYPE@> &taps,
		      double center_freq,
		      double sampling_freq)
    {
      return gnuradio::get_initial_sptr(new @IMPL_NAME@
					(decimation, taps,
					 center_freq,
					 sampling_freq));
    }

    @IMPL_NAME@::@IMPL_NAME@(int decimation,
			     const std::vector<@TAP_TYPE@> &taps,
			     double center_freq,
			     double sampling_freq)
    : sync_decimator("@BASE_NAME@",
			io_signature::make(1, 1, sizeof(@I_TYPE@)),
			io_signature::make(1, 1, sizeof(@O_TYPE@)),
			decimation),
      d_proto_taps(taps), d_center_freq(center_freq),
      d_sampling_freq(sampling_freq),
      d_updated(false)
    {
      std::vector<gr_complex> dummy_taps;
      d_composite_fir = new kernel::@CFIR_TYPE@(decimation, dummy_taps);

      set_history(d_proto_taps.size());
      build_composite_fir();
    }

    @IMPL_NAME@::~@IMPL_NAME@()
    {
      delete d_composite_fir;
    }

    void
    @IMPL_NAME@::build_composite_fir()
    {
      std::vector<gr_complex> ctaps(d_proto_taps.size());

      float fwT0 = -2 * M_PI * d_center_freq / d_sampling_freq;
      for(unsigned int i = 0; i < d_proto_taps.size(); i++) {
	ctaps[i] = d_proto_taps[i] * exp(gr_complex(0, i * fwT0));
      }

      std::reverse(ctaps.begin(), ctaps.end());
      d_composite_fir->set_taps(ctaps);
      d_r.set_phase_incr(exp(gr_complex(0, fwT0 * decimation())));
    }

    void
    @IMPL_NAME@::set_center_freq(double center_freq)
    {
      d_center_freq = center_freq;
      d_updated = true;
    }

    double
    @IMPL_NAME@::center_freq() const
    {
      return d_center_freq;
    }
    
    void
    @IMPL_NAME@::set_taps(const std::vector<@TAP_TYPE@> &taps)
    {
      d_proto_taps = taps;
      d_updated = true;
    }

    std::vector<@TAP_TYPE@>
    @IMPL_NAME@::taps() const
    {
      return d_proto_taps;
    }

    int
    @IMPL_NAME@::work(int noutput_items,
		      gr_vector_const_void_star &input_items,
		      gr_vector_void_star &output_items)
    {
      @I_TYPE@ *in  = (@I_TYPE@ *)input_items[0];
      @O_TYPE@ *out = (@O_TYPE@ *)output_items[0];

      // rebuild composite FIR if the center freq has changed
      if(d_updated) {
	set_history(d_proto_taps.size());
	build_composite_fir();
	d_updated = false;
	return 0;		     // history requirements may have changed.
      }

      unsigned j = 0;
      for (int i = 0; i < noutput_items; i++){
	out[i] = d_r.rotate(d_composite_fir->filter(&in[j]));
	j += decimation();
      }

      return noutput_items;
    }

  } /* namespace filter */
} /* namespace gr */

