#!/usr/bin/env python
#
# Copyright 2008,2010,2012 Free Software Foundation, Inc.
#
# This file is part of GNU Radio
#
# GNU Radio is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 3, or (at your option)
# any later version.
#
# GNU Radio is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License along
# with this program; if not, write to the Free Software Foundation, Inc.,
# 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301 USA.
#

from gnuradio import gr, gr_unittest
import filter_swig as filter

class test_filter(gr_unittest.TestCase):

    def setUp(self):
        self.tb = gr.top_block ()

    def tearDown(self):
        self.tb = None

    def test_fir_filter_fff_001(self):
        src_data = 40*[1, 2, 3, 4]
        expected_data = (0.5, 1.5, 3.0, 5.0, 5.5, 6.5, 8.0, 10.0,
                         10.5, 11.5, 13.0, 15.0, 15.5, 16.5, 18.0,
                         20.0, 20.5, 21.5, 23.0, 25.0, 25.5, 26.5,
                         28.0, 30.0, 30.5, 31.5, 33.0, 35.0, 35.5,
                         36.5, 38.0, 40.0, 40.5, 41.5, 43.0, 45.0,
                         45.5, 46.5, 48.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0)
        src = gr.vector_source_f(src_data)
        op  = filter.fir_filter_fff(1, 20*[0.5, 0.5])
        dst = gr.vector_sink_f()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertFloatTuplesAlmostEqual(expected_data, result_data, 5)

    def test_fir_filter_fff_002(self):
        src_data = 40*[1, 2, 3, 4]
        expected_data = (0.5, 5.5, 10.5, 15.5, 20.5, 25.5, 30.5, 35.5,
                         40.5, 45.5, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0,
                         50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0, 50.0)
        src = gr.vector_source_f(src_data)
        op  = filter.fir_filter_fff(4, 20*[0.5, 0.5])
        dst = gr.vector_sink_f()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertFloatTuplesAlmostEqual(expected_data, result_data, 5)

    def test_fir_filter_ccf_001(self):
        src_data = 40*[1+1j, 2+2j, 3+3j, 4+4j]
        expected_data = ((0.5+0.5j), (1.5+1.5j), (3+3j), (5+5j), (5.5+5.5j),
                         (6.5+6.5j), (8+8j), (10+10j), (10.5+10.5j), (11.5+11.5j),
                         (13+13j), (15+15j), (15.5+15.5j), (16.5+16.5j), (18+18j),
                         (20+20j), (20.5+20.5j), (21.5+21.5j), (23+23j), (25+25j),
                         (25.5+25.5j), (26.5+26.5j), (28+28j), (30+30j), (30.5+30.5j),
                         (31.5+31.5j), (33+33j), (35+35j), (35.5+35.5j), (36.5+36.5j),
                         (38+38j), (40+40j), (40.5+40.5j), (41.5+41.5j), (43+43j),
                         (45+45j), (45.5+45.5j), (46.5+46.5j), (48+48j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j))

        src = gr.vector_source_c(src_data)
        op  = filter.fir_filter_ccf(1, 20*[0.5, 0.5])
        dst = gr.vector_sink_c()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)

    def test_fir_filter_ccf_002(self):
        src_data = 40*[1+1j, 2+2j, 3+3j, 4+4j]
        expected_data = ((0.5+0.5j), (5.5+5.5j), (10.5+10.5j), (15.5+15.5j),
                         (20.5+20.5j), (25.5+25.5j), (30.5+30.5j), (35.5+35.5j),
                         (40.5+40.5j), (45.5+45.5j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j), (50+50j),
                         (50+50j), (50+50j), (50+50j), (50+50j))

        src = gr.vector_source_c(src_data)
        op  = filter.fir_filter_ccf(4, 20*[0.5, 0.5])
        dst = gr.vector_sink_c()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)

    def test_fir_filter_ccc_001(self):
        src_data = 40*[1+1j, 2+2j, 3+3j, 4+4j]
        expected_data = ((-0.5+1.5j), (-1.5+4.5j), (-3+9j), (-5+15j),
                         (-5.5+16.5j), (-6.5+19.5j), (-8+24j), (-10+30j),
                         (-10.5+31.5j), (-11.5+34.5j), (-13+39j), (-15+45j),
                         (-15.5+46.5j), (-16.5+49.5j), (-18+54j), (-20+60j),
                         (-20.5+61.5j), (-21.5+64.5j), (-23+69j), (-25+75j),
                         (-25.5+76.5j), (-26.5+79.5j), (-28+84j), (-30+90j),
                         (-30.5+91.5j), (-31.5+94.5j), (-33+99j), (-35+105j),
                         (-35.5+106.5j), (-36.5+109.5j), (-38+114j), (-40+120j),
                         (-40.5+121.5j), (-41.5+124.5j), (-43+129j), (-45+135j),
                         (-45.5+136.5j), (-46.5+139.5j), (-48+144j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j), (-50+150j))
        src = gr.vector_source_c(src_data)
        op  = filter.fir_filter_ccc(1, 20*[0.5+1j, 0.5+1j])
        dst = gr.vector_sink_c()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)


    def test_fir_filter_ccc_002(self):
        src_data = 10*[1+1j, 2+2j, 3+3j, 4+4j]
        
        # results derived from original gr.fir_filter_ccc
        expected_data = ((7.537424837948042e-20+7.537424837948042e-20j), (9.131923434324563e-05+9.131923434324563e-05j), (0.0003317668742965907+0.0003317668742965907j), (0.0007230418268591166+0.0007230418268591166j), (0.0012087896466255188+0.0012087896466255188j), (0.0013292605290189385+0.0013292605290189385j), (0.001120875240303576+0.001120875240303576j), (0.000744672492146492+0.000744672492146492j), (0.000429437990533188+0.000429437990533188j), (2.283908543176949e-05+2.283908543176949e-05j), (-0.0002245186478830874-0.0002245186478830874j), (-0.0001157080550910905-0.0001157080550910905j), (0.00041409023106098175+0.00041409023106098175j), (0.0009017843985930085+0.0009017843985930085j), (0.0012520025484263897+0.0012520025484263897j), (0.0014116164529696107+0.0014116164529696107j), (0.001393353333696723+0.001393353333696723j), (0.000912194955162704+0.000912194955162704j), (0.00022649182938039303+0.00022649182938039303j), (-0.00031363096786662936-0.00031363096786662936j), (-0.0003966730728279799-0.0003966730728279799j), (-0.00023757052258588374-0.00023757052258588374j), (0.00021952332463115454+0.00021952332463115454j), (0.0009092430118471384+0.0009092430118471384j), (0.001662317430600524+0.001662317430600524j), (0.0019024648936465383+0.0019024648936465383j), (0.0015955769922584295+0.0015955769922584295j), (0.0009144138311967254+0.0009144138311967254j), (0.0001872836146503687+0.0001872836146503687j), (-0.000581968342885375-0.000581968342885375j), (-0.0009886166080832481-0.0009886166080832481j), (-0.0007480768254026771-0.0007480768254026771j), (0.00018211957649327815+0.00018211957649327815j), (0.0012042406015098095+0.0012042406015098095j), (0.0020200139842927456+0.0020200139842927456j), (0.0023816542234271765+0.0023816542234271765j), (0.002195809967815876+0.002195809967815876j), (0.0012113333214074373+0.0012113333214074373j), (-0.00014088614261709154-0.00014088614261709154j), (-0.0012574587017297745-0.0012574587017297745j))

        taps = filter.firdes.low_pass(1, 1, 0.1, 0.01)
        src = gr.vector_source_c(src_data)
        op  = filter.fir_filter_ccc(1, taps)
        dst = gr.vector_sink_c()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)

    def test_fir_filter_ccc_003(self):
        src_data = 40*[1+1j, 2+2j, 3+3j, 4+4j]
        expected_data = ((-0.5+1.5j), (-5.5+16.5j), (-10.5+31.5j),
                         (-15.5+46.5j), (-20.5+61.5j), (-25.5+76.5j),
                         (-30.5+91.5j), (-35.5+106.5j), (-40.5+121.5j),
                         (-45.5+136.5j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j), (-50+150j),
                         (-50+150j), (-50+150j), (-50+150j))
        src = gr.vector_source_c(src_data)
        op  = filter.fir_filter_ccc(4, 20*[0.5+1j, 0.5+1j])
        dst = gr.vector_sink_c()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)


    def test_fir_filter_scc_001(self):
        src_data = 40*[1, 2, 3, 4]
        expected_data = ((0.5+1j), (1.5+3j), (3+6j), (5+10j), (5.5+11j),
                         (6.5+13j), (8+16j), (10+20j), (10.5+21j), (11.5+23j),
                         (13+26j), (15+30j), (15.5+31j), (16.5+33j), (18+36j),
                         (20+40j), (20.5+41j), (21.5+43j), (23+46j), (25+50j),
                         (25.5+51j), (26.5+53j), (28+56j), (30+60j), (30.5+61j),
                         (31.5+63j), (33+66j), (35+70j), (35.5+71j), (36.5+73j),
                         (38+76j), (40+80j), (40.5+81j), (41.5+83j), (43+86j),
                         (45+90j), (45.5+91j), (46.5+93j), (48+96j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j))
        src = gr.vector_source_s(src_data)
        op  = filter.fir_filter_scc(1, 20*[0.5+1j, 0.5+1j])
        dst = gr.vector_sink_c()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)


    def test_fir_filter_scc_002(self):
        src_data = 40*[1, 2, 3, 4]
        expected_data = ((0.5+1j), (5.5+11j), (10.5+21j), (15.5+31j), (20.5+41j),
                         (25.5+51j), (30.5+61j), (35.5+71j), (40.5+81j), (45.5+91j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j),
                         (50+100j), (50+100j), (50+100j), (50+100j), (50+100j))
        src = gr.vector_source_s(src_data)
        op  = filter.fir_filter_scc(4, 20*[0.5+1j, 0.5+1j])
        dst = gr.vector_sink_c()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)

    def test_fir_filter_fsf_001(self):
        src_data = 40*[1, 2, 3, 4]
        expected_data =(0, 1, 3, 5, 5, 6, 8, 10, 10, 11, 13, 15, 15, 16, 18, 20, 20,
                        21, 23, 25, 25, 26, 28, 30, 30, 31, 33, 35, 35, 36, 38, 40, 40,
                        41, 43, 45, 45, 46, 48, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
                        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
                        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
                        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
                        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
                        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
                        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
                        50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50)
        src = gr.vector_source_f(src_data)
        op  = filter.fir_filter_fsf(1, 20*[0.5, 0.5])
        dst = gr.vector_sink_s()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)


    def test_fir_filter_fsf_002(self):
        src_data = 40*[1, 2, 3, 4]
        expected_data = (0, 5, 10, 15, 20, 25, 30, 35, 40, 45, 50, 50, 50, 50, 50,
                         50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50, 50,
                         50, 50, 50, 50, 50, 50, 50, 50, 50, 50)
        src = gr.vector_source_f(src_data)
        op  = filter.fir_filter_fsf(4, 20*[0.5, 0.5])
        dst = gr.vector_sink_s()
        self.tb.connect(src, op, dst)
        self.tb.run()
        result_data = dst.data()
        self.assertComplexTuplesAlmostEqual(expected_data, result_data, 5)

if __name__ == '__main__':
    gr_unittest.run(test_filter, "test_filter.xml")

