#!/usr/bin/python3

import sys

import pyudev
import psutil

def enumerate_removable_partitions():
	removable_partitions = {}
	ctxt = pyudev.Context()
	removable_devices = [ dev for dev in ctxt.list_devices(subsystem='block', DEVTYPE='disk') if dev.attributes.get('removable') == b'1' ]
	all_mounted_partitions = { part.device: part for part in psutil.disk_partitions() }
	for device in removable_devices:
		partitions_on_removable_device = {
			part.device_node: {
				'device': part['DEVNAME'],
				'vendor': part['ID_VENDOR'],
				'model': part['ID_MODEL'],
				'fs_label': part['ID_FS_LABEL'],
				'is_mounted': False,
				'mountpoint': None,
				'fs_type': None,
			} for part in ctxt.list_devices(subsystem='block', DEVTYPE='partition', parent=device)
		}
		for part in partitions_on_removable_device:
			try:
				partitions_on_removable_device[part]['mountpoint'] = all_mounted_partitions[part].mountpoint
				partitions_on_removable_device[part]['is_mounted'] = True
				partitions_on_removable_device[part]['fs_type'] = all_mounted_partitions[part].fstype
			except KeyError:
				pass			# not mounted
		removable_partitions.update(partitions_on_removable_device)
	return removable_partitions

parts = enumerate_removable_partitions()
for part_name in parts:
	part = parts[part_name]
	if part['is_mounted']:
		print('mounted:', part)
