/*
**  Task.h
**
**  Copyright (c) 2002, 2003
**
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_Task
#define _GNUMail_H_Task

#include <Foundation/NSCalendarDate.h>
#include <Foundation/NSCoder.h>
#include <Foundation/NSObject.h>

#define SEND_SENDMAIL 1
#define SEND_SMTP     2
#define RECEIVE_IMAP  3
#define RECEIVE_POP3  4
#define RECEIVE_UNIX  5

#define ORIGIN_USER    1
#define ORIGIN_TIMER   2
#define ORIGIN_STARTUP 3

//
// IMAP subOp:s
//
#define IMAP_STATUS 1

@class Message;
@class NSMutableArray;
@class NSString;

@interface Task : NSObject <NSCoding,NSCopying>
{
  @public
    id message;      // The Message, if it exists (used when sending a mail).
                     // Could be as raw source (for bounce, for example) or an instance of Message
    id key;          // Account name.
    id sendingKey;   // The account name used to send the mail - we only use the SMTP or the 
                     // mailer informations from this account.

    int op;          // One of the SEND_{MTA,SMTP} or RECEIVE_{IMAP,POP3} value.
    int subOp;       // A sub-operation, generally an IMAP command.
    
    BOOL immediate;  // If YES, we run this task immediately when it has been
                     // added to our task's pool.
    
    NSDate *date;    // The date at which we will retry to do the op for this task.

    int origin;      // "Where" the task has been created. This could be by the user,
                     // the timer or when the application was started.

    BOOL running;    // YES if the task is running, NO otherwise.

    id owner;        // The object that owns this task. It could be a MailWindowController
                     // instance, for example.

    NSMutableArray *filteredMessagesFolders; // The names of the folders when messages where
                                             // transferred since matching filters were found 
                                             // during the reception of those messages.
    int filteredMessagesCount;               // The number of messages that have been filtered.

    int receivedMessagesCount;               // The number of messages we have received while
                                             // this task was running.
}

//
//
//
- (id) message;
- (void) setMessage: (id) theMessage;

- (id) key;
- (void) setKey: (id) theKey;

- (id) sendingKey;
- (void) setSendingKey: (id) theKey;

- (int) op;
- (void) setOp: (int) theOp;

- (int) subOp;
- (void) setSubOp: (int) theSubOp;

- (BOOL) immediate;
- (void) setImmediate: (BOOL) theBOOL;

- (NSDate *) date;
- (void) setDate: (NSDate *) theDate;

- (int) origin;
- (void) setOrigin: (int) theOrigin;

- (BOOL) running;
- (void) setRunning: (BOOL) theBOOL;

- (id) owner;
- (void) setOwner: (id) theOwner;

- (NSMutableArray *) filteredMessagesFolders;
- (void) setFilteredMessagesFolders: (NSMutableArray *) theMutableArray;

- (int) filteredMessagesCount;
- (void) setFilteredMessagesCount: (int) theCount;

- (int) receivedMessagesCount;
- (void) setReceivedMessagesCount: (int) theCount;

@end

#endif // _GNUMail_H_Task
