/*
**  Constants.h
**
**  Copyright (c) 2003
** 
**  Author: Ludovic Marcotte <ludovic@Sophos.ca>   
**
**  This program is free software; you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation; either version 2 of the License, or
**  (at your option) any later version.
**
**  This program is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program; if not, write to the Free Software
**  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _GNUMail_H_GNUMailConstants
#define _GNUMail_H_GNUMailConstants


//
// Useful macros
//
#ifdef MACOSX
#define RETAIN(object)          [object retain]
#define RELEASE(object)         [object release]
#define AUTORELEASE(object)     [object autorelease]
#define TEST_RELEASE(object)    ({ if (object) [object release]; })
#define ASSIGN(object,value)    ({\
id __value = (id)(value); \
id __object = (id)(object); \
if (__value != __object) \
  { \
    if (__value != nil) \
      { \
        [__value retain]; \
      } \
    object = __value; \
    if (__object != nil) \
      { \
        [__object release]; \
      } \
  } \
})

#define DESTROY(object) ({ \
  if (object) \
    { \
      id __o = object; \
      object = nil; \
      [__o release]; \
    } \
})

#define NSLocalizedString(key, comment) \
  [[NSBundle mainBundle] localizedStringForKey:(key) value:@"" table:nil]

#define _(X) NSLocalizedString (X, @"")

#ifdef DEBUG
#define NSDebugLog(format, args...) \
  do { NSLog(format, ##args); } while(0)
#else
#define NSDebugLog(format, args...)
#endif

#endif

#define IMAPSTORE_IS_DISCONNECTED(store) ({ \
  BOOL aBOOL; \
  \
  aBOOL = NO; \
  \
  if ( [(id<NSObject>)store isKindOfClass: [IMAPStore class]] && \
       ![(IMAPStore *)store isConnected] ) \
    { \
      aBOOL = YES; \
    } \
  \
  aBOOL; \
})


//
// Constants for the application
//
#define RETAIN_PERIOD 300

enum {
  MANUALLY = 0,
  AUTOMATICALLY = 1,
  NEVER = 2
};

enum {
  SHOW_ALL_HEADERS = 1,
  HIDE_ALL_HEADERS = 2
};

enum {
  DELETE_MESSAGE = 1,
  UNDELETE_MESSAGE = 2,
};

enum {
  MARK_AS_READ = 1,
  MARK_AS_UNREAD = 2
};

enum {
  SHOW_DELETED_MESSAGES = 1,
  HIDE_DELETED_MESSAGES = 2
};

enum {
  SHOW_READ_MESSAGES = 1,
  HIDE_READ_MESSAGES = 2
};

enum {
  THREAD_MESSAGES = 1,
  UNTHREAD_MESSAGES = 2
};

enum {
  OTHER = 0,
  POP3 = 1,
  IMAP = 2,
  UNIX = 3
};

enum {
  TRANSPORT_MAILER = 1,
  TRANSPORT_SMTP = 2
};

enum {
  SIGNATURE_BEGINNING = 0,
  SIGNATURE_END = 1,
  SIGNATURE_HIDDEN = 2
};

enum {
  MOVE_MESSAGES = 1,
  COPY_MESSAGES = 2
};

enum { 
  TYPE_TABLEVIEW = 1,
  TYPE_OUTLINEVIEW = 2
};

enum {
  MODE_STANDARD = 1,
  MODE_EXPERT = 2
};

enum {
  TYPE_PLAIN = 1,
  TYPE_HTML = 2
};

enum {
  IMAP_SHOW_ALL = 0,
  IMAP_SHOW_SUBSCRIBED_ONLY = 1
};


//
// Constants for the UI
//
enum {
  TextFieldHeight = 21,
  ButtonHeight = 25,
  FilterTextFieldTag = 1001
};


//
// Notifications used in GNUMail.app
//
extern NSString *AccountsHaveChanged;
extern NSString *FiltersHaveChanged;
extern NSString *FontValuesHaveChanged;
extern NSString *ReloadMessageList;
extern NSString *ReplyToMessageWasSuccessful;
extern NSString *SelectionOfMessageHasChanged;
extern NSString *TableColumnsHaveChanged;


//
// Pasteboard data types
//
extern NSString *MessagePboardType;
extern NSString *AddressPboardType;

#endif // _GNUMail_H_GNUMailConstants
