# gnulibvars.mk: useful debian/rules variables for gnulib related packages

# Copyright (C) 2024 Simon Josefsson <simon@josefsson.org>

# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program.  If not, see <https://www.gnu.org/licenses/>.

# A typical package that rely on gnulib's ./bootstrap infrastructure
# would want to add something like the following to debian/rules:
#
# include /usr/share/gnulib/gnulibvars.mk
# export GNULIB_URL = $(GNULIB_DEB_GIT_URL)
#
# override_dh_autoreconf:
#	dh_autoreconf ./bootstrap

_gnulib_share_path ?= /usr/share/gnulib

# Guaranteed to point to a directory with an unpackaged gnulib copy.
# The Debian package modify some paths compared to upstream, but if
# some package rely on the directory not containing such changes, the
# gnulib Debian package should probably be modified to not introduce it.
GNULIB_DEB_SRCDIR ?= $(_gnulib_share_path)

# Guaranteed to point to a git bundle provided by the Debian gnulib
# package, for as long as a git bundle is provided by the package.
GNULIB_DEB_GIT_BUNDLE ?= $(_gnulib_share_path)/gnulib.bundle

# Guaranteed to point to a URL that works with 'git clone' and where
# the content of that URL is provided by the Debian gnulib package.
# Should not require network access.  In practice this will probably
# always be a simple file path but could be changed to point to a git
# bundle or to a unpackad .git repository, or some other URL style
# accepted by 'git clone' in the future.
GNULIB_DEB_GIT_URL ?= $(GNULIB_DEB_GIT_BUNDLE)
