# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# $Id: UILoginHandler.py 7806 2005-08-09 17:21:10Z reinhard $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import os.path

from gnue.common.apps import GConfig
from gnue.common.datasources import GLoginHandler
from gnue.forms.uidrivers.win32 import dialogs


class UILoginHandler(GLoginHandler.LoginHandler):

  # ---------------------------------------------------------------------------
  # Create an instance of an InputDialog and return it's result
  # ---------------------------------------------------------------------------

  def _askLogin_ (self, title, fields):

    lfields = fields [:]
    if lfields [0][2] != 'image':
      imageFile = gConfigForms('loginBMP')
      if not os.path.exists (imageFile):
        imageFile = os.path.join (os.path.normpath ( \
            GConfig.getInstalledBase ('forms_images', 'common_images')),
            gConfigForms ('loginBMP'))

      if os.path.exists (imageFile):
        lfields.insert (0, ('', imageFile, 'image', None, None, []))

    dlg = dialogs.InputDialog (title, lfields)

    try:
      dlg.DoModal ()
      result = dlg.inputData
    finally:
      dlg.Destroy ()

    return result
