# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# $Id: GFwin32App.py 7657 2005-06-26 11:09:49Z btami $
#
# DESCRIPTION:
# A PyWin32 based user interface driver for GNUe forms.
#
# NOTES:
#

import win32gui

__win32App = None

def getWin32App():
    global __win32App
    if not __win32App:
        __win32App = GFwin32App()
    return __win32App


class GFwin32App:
  _mainLoop= None

  _HwndToTkObj = {}
  _MainWindowList = []
  
  def MainLoop (self):
        # just to launch one win32's mainloop
        # otherwise, the app does not finishes cleanly when several windows are open
        # 'cause the first mainloop gets all the events
        # and the others just sit and wait for something to happen
        if self._mainLoop==None:
            self._mainLoop= 1
            win32gui.PumpMessages()
            
