# GNU Enterprise Forms - GTK UI Driver - Toolbar widget
#
# Copyright 2001-2005 Free Software Foundation
#
# This file is part of GNU Enterprise
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# $Id: ToolBar.py 7960 2005-09-22 04:22:08Z johannes $

import gtk

from gnue.common.apps import i18n
from gnue.forms.uidrivers._commonGuiToolkit.ToolBar import ToolBar as Base
  
# =============================================================================
# This class implements the toolbar for GTK2
# =============================================================================

class ToolBar (Base):

  # ---------------------------------------------------------------------------
  # Create the toolbar
  # ---------------------------------------------------------------------------

  def init (self):
    handlebox    = gtk.HandleBox ()
    self.toolbar = gtk.Toolbar ()

    self.toolbar.set_orientation (gtk.ORIENTATION_HORIZONTAL)
    self.toolbar.set_style (gtk.TOOLBAR_ICONS)
    self.toolbar.set_tooltips (True)
    handlebox.add (self.toolbar)
    
    self.container.content_table.attach (handlebox,
                                        # X direction           Y direction
                                        0, 1,                      1, 2,
                                        gtk.EXPAND | gtk.FILL,     0,
                                        0,                         0)
    self.toolbar.show ()
    handlebox.show ()

    self.toolbar.set_show_arrow (False)
    self.tooltips = gtk.Tooltips ()

    return handlebox


  # ---------------------------------------------------------------------------
  # Add a menu item (action)
  # ---------------------------------------------------------------------------

  def addAction (self, name, userAction):

    assert gDebug (6, "TOOL: add action %s, %s" % \
        (repr (name), repr (userAction.description)))

    label   = name
    toolTip = userAction.description
    iconloc = userAction.getIconLocation (size = "24x24")

    # Set the action icon if available
    if not iconloc:
      assert gDebug (1, "Can't add '%s' to toolbar; no icon" % userAction.event)
      return

    icon = gtk.Image ()
    icon.set_from_file (iconloc)

    if userAction.canToggle:
      button = gtk.ToggleToolButton ()
      button._toggleHandler = button.connect ('toggled', self._toggleEvent,
            userAction)
    else:
      button = gtk.ToolButton ()
      button.connect ('clicked', self._buttonPress, userAction)
      button._toggleHandler = None

    button.set_icon_widget (icon)
    button.set_label (label)
    button.set_tooltip (self.tooltips, toolTip, None)

    self.toolbar.insert (button, -1)
        
    return button


  # ---------------------------------------------------------------------------
  # Event handler for toggle buttons
  # ---------------------------------------------------------------------------

  def _toggleEvent (self, button, userAction):

    if button.get_active ():
      event = 'request%s' % userAction.event
    else:
      event = 'request%s' % userAction.canToggle

    self.driver.dispatchEvent (event, _form = self.form)


  # ---------------------------------------------------------------------------
  # Event handler for toolbar buttons
  # ---------------------------------------------------------------------------

  def _buttonPress (self, button, userAction):

    event = 'request%s' % userAction.event
    self.driver.dispatchEvent (event, _form = self.form)


  # ---------------------------------------------------------------------------
  # Add a separator
  # ---------------------------------------------------------------------------

  def addSeparator (self):

    sep = gtk.SeparatorToolItem ()
    self.toolbar.insert (sep, -1)
    

  # ---------------------------------------------------------------------------
  # Enable a menu item
  # ---------------------------------------------------------------------------

  def enableItem (self, item):

    if item is not None:
      item.set_sensitive (1)
  

  # ---------------------------------------------------------------------------
  # Disable a menu item
  # ---------------------------------------------------------------------------

  def disableItem (self, item):

    if item is not None:
      item.set_sensitive (0)
  

  # ---------------------------------------------------------------------------
  # Set an item active
  # ---------------------------------------------------------------------------

  def startingItem (self, item):

    if item._toggleHandler:
      item.handler_block (item._toggleHandler)

    try:
      if item is not None:
        item.set_active (1)

    finally:
      if item._toggleHandler:
        item.handler_unblock (item._toggleHandler)

  # ---------------------------------------------------------------------------
  # Set an item inactive
  # ---------------------------------------------------------------------------

  def endingItem (self, item):

    if item._toggleHandler:
      item.handler_block (item._toggleHandler)

    try:
      if item is not None:
        item.set_active (0)

    finally:
      if item._toggleHandler:
        item.handler_unblock (item._toggleHandler)
