# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# GFDisplayHandler.py
#
# $Id$
"""
DisplayHandler classes for Forms input validation
"""
__revision__ = "$Id:$"

import sys, time, datetime

from gnue.forms.input.displayHandlers.Cursor import BaseCursor

class DateTime(BaseCursor):
  """
  Class to handle the display and entry of date based fields.
  """
  def __init__(self, entry, eventHandler, subEventHandler, displayMask,
               inputMask):
    BaseCursor.__init__(self, entry, eventHandler, subEventHandler)
    self.__displayMask = displayMask
    self.__inputMask = inputMask


  # TODO: Replace with format mask
  def _buildDisplayHelper(self, value, editing):
    if editing:
      if self.__inputMask:
        format = self.__inputMask
      else:
        format = "%m/%d/%Y"
    else:
      if self.__displayMask:
        format = self.__displayMask
      else:
        format = "%m/%d/%y"

##    print "format=%s, value=%s, type=%s" % (format, value, type(value))
    if value in (None, ""):
      return ""
    try:
      return value.strftime (str (format))
    except AttributeError:
      return str(value)


  def _buildValue(self):
    if not len(self.work):
      self.value = None
      return True

    # TODO: Replace with format mask
    if self.__inputMask:
      
      try:
        tempVal = time.strptime (self.work, self.__inputMask)
        self.value = datetime.datetime(*tempVal[0:6])
      except ValueError:
        assert gDebug(6,"Date format %s invalid for mask %s" % (self.work, self.__inputMask))
        return False
      return True
    
    # TODO: Candidate for maketrans?
    # TODO: This logic does not work for timestamps
    #       as it skips the hour,minute, second
    value = self.work.replace('.','/').replace('-','/')

    
    # Support for quick entry like '123102' for '12/31/02'
    if len(value) in (6, 8) and value.find('/') == -1:
      month = value[:2]
      day = value[2:4]
      year = value[4:]
    else:
      month, day, year = value.split('/')

    # TODO: Shouldn't the 50 be a config option
    year = int(year)
    if year < 100:
      if year > 50:
        year = year + 1900
      else:
        year = year + 2000

    self.value = datetime.datetime(year, int(month), int(day))
    return True
