
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# Checkbox.py
#
# $Id:$
"""
Display handler for entries of type checkbox
"""
__revision__ = "$Id$"

from gnue.forms.input.displayHandlers.Cursor import BaseCursor

#############################################################################
#
# Handler for Checkbox types
#
class Checkbox(BaseCursor):

  def __init__(self, entry, eventHandler, subEventHandler, displayMask,
               inputMask):

    self.trueValue = gConfigForms("checkboxTrue")
    self.falseValue = gConfigForms("checkboxFalse")

    self.trueValues =  ('Y', 'y', 'T', 't', '1', 'x', 'X', self.trueValue)
    self.falseValues = ('N', 'n', 'F', 'f', '0', '', ' ', self.falseValue)

    BaseCursor.__init__(self, entry, eventHandler, subEventHandler)

    # My events...
    self.subEventHandler.registerEventListeners( {
           'requestTOGGLECHKBOX' : self.handleToggleChkbox} )


  def setValue(self, value):
    # Force to 0 or 1
    self.value = self._sanitizeValue(value)

    self.modified = False
    self._buildDisplay()


  def _sanitizeValue(self, value):
    if ("%s" % value)[:1] in self.trueValues:
      return True
    elif ("%s" % value)[:1] in self.falseValues:
      return False
    else:
      return value and True or False

  def _buildValue(self):
    self.value = self.work
    return True


  # TODO: Replace with format mask
  def _buildDisplayHelper(self, value, editing):
    return self._sanitizeValue(value)


  # Helpers for user events:

  # Set checkbox to boolean value
  def __set (self, value):
    if value != self.work:
      self.work = value
      self.modified = True
      self._buildDisplay ()

  # Toggle value of checkbox
  def __toggle (self):
    self.work = not self.work
    self.modified = True
    self._buildDisplay ()


  # Handle requestTOGGLECHKBOX event
  def handleToggleChkbox (self, event):
    if not self.editing:
      return
    if event.data == None:
      self.__toggle ()
    else:
      self.__set (self._sanitizeValue (event.data [1]))
    event.refreshDisplay = True


  def _beginEdit(self, event):

    self.editing = self.field.isEditable(event._form.getCurrentMode())
    self.modified = False

    self.setValue(self.field.getValue())

    self.work = self.value

    self._buildDisplay()

    self._cursor = 0


  # Correctly handle requestKEYPRESS event
  def _addText(self, event):
    if event.text == ' ':
      self.__toggle ()
    elif event.text in ['0', '-']:      # TODO: add "Y" for current language
      self.__set (False)
    elif event.text in ['1', '+']:      # TODO: add "N" for current language
      self.__set (True)
    event.refreshDisplay = True
    return


  # Copy to the clipboard
  def _clipboardCopy(self, event):
    return self.work


  def _clipboardCut(self, event):
    return self.work


  def clipboardPaste(self, event):
    if not self.editing:
      return

    event.text = self.dispatchEvent(events.Event('getClipboard'))
    if event.text != None:
      self.work = self._sanitizeValue(event.data)
      self.modified = True
      self._buildDisplay()