
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# GFDisplayHandler.py
#
# $Id$
"""
DisplayHandler classes for Forms input validation
"""
__revision__ = "$Id$"

from gnue.common import events

class Base(events.EventAware):
  """
  The base display handler.
  
  This display handler is not to be used directly.  Other
  display handlers inherit from this one.  At this point
  Base is completely empty and all classes inherit from 
  BaseCursor.  Functions will be moved from BaseCursor to 
  Base at some point
  """

  # ===========================================================================
  # Cursor movement functions
  # ===========================================================================

  def _moveCursor(self, event, selecting=False):
    """
    Moves the cursor to the specified position optionally selecting the text.
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: _moveCursor not supported." % self.entry.name )
    return

  def _moveCursorLeft(self, event, selecting=False):
    """
    Moves the cursor to the left optionally selecting the text.
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: _moveCursorLeft not supported." % self.entry.name )
    return

  def _moveCursorRight(self, event, selecting=False):
    """
    Moves the cursor to the right optionally selecting the text.
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: _moveCursorRight not supported." % self.entry.name )
    return

  def _moveCursorToEnd(self, event, selecting=False):
    """
    Moves the cursor to the end optionally selecting the text.
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: _moveCursorToEnd not supported." % self.entry.name )
    return

  def _moveCursorToBegin(self, event, selecting=False):
    """
    Moves the cursor to the beginning optionally selecting the text.
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: _moveCursosToBegin not supported." % self.entry.name )
    return

  def backspace(self, event):
    """
    Delete backward one character
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: backspace not supported." % self.entry.name )
    return

  # Delete forward one character
  def delete(self, event):
    """
    Delete forward one character
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: delete not supported." % self.entry.name )
    return

  # ---------------------------------------------------------------------------
  # Selection Support
  # ---------------------------------------------------------------------------
  
  def setSelectionArea(self, cursor1, cursor2):
    """
    Set the selection area
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: setSelectionArea not supported." % self.entry.name )
    return


  def getSelectionArea(self):
    """
    Return the selected area as a tuple (or None if no selection)
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: getSelectionArea not supported." % self.entry.name )
    return


  def selectAll(self, event):
    """
    Select the entire text of the entry and move the cursor to the end
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: selectAll not supported." % self.entry.name )
    return

  def selectLeft(self, event):
    """
    Move the selection cursor to the left one unit
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: selectLeft not supported." % self.entry.name )
    return


  def selectRight(self, event):
    """
    Move the selection cursor to the right one unit
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: selectRight not supported." % self.entry.name )
    return


  def selectToBegin(self, event):
    """
    Select to the beginning of the entry
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: selectToBegin not supported." % self.entry.name )
    return


  def selectToEnd(self, event):
    """
    Select to the beginning of the entry
    
    Not supported by base.  Use BaseCursor.
    """
    assert gDebug (5, "Entry %s: selectToEnd not supported." % self.entry.name )
    return

