#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2000-2005 Free Software Foundation
#
# FILE:
# GFObjects.py
#
# DESCRIPTION:
"""
Base for all Form-related GObjects
"""
# NOTES:
#
# HISTORY:
#

from gnue.common.definitions.GObjects import GObj
from gnue.common.logic.GTrigger import GTriggerExtension

#
# Class GFObj
#
# Base internal object for GNUE Forms
#
class GFObj(GObj, GTriggerExtension):
  def __repr__(self):
    try:
      name = self.name
    except AttributeError:
      try: 
        name = self.id
      except AttributeError:
        return '<%s instance at %s>' % (self.__class__, id(self))
    return '<%s instance (%s) at %s>' % (self.__class__, self.name, id(self))
    
  def __init__(self, parent=None, type='GFObj'):
    GTriggerExtension.__init__(self)
    GObj.__init__(self, parent, type)
    self.hidden = False
    self.readonly = False
    self._visibleIndex = 0
    self.name = "__GF%s" % id(self)
    self._rows = 1
    self._gap = 0
    self._inits = []

    # The reference to the uiWidget will be set by the
    # uidrivers._base.UIdriver._buildUI () function
    self.uiWidget = None

  def isNavigable(self, mode='edit'):
    """
    Is the current object currently navigable?
    Mode can be 'edit', 'query', or 'new'
    """
    return False

  #
  # get an Option
  #
  def getOption(self, name):
    option = None
    for child in self._children:
      if child._type == "GFOptions":
        for o in child._children:
          if o._type == "GFOption":
            if o.name == name:
              option = o.value
    return option

  #
  # recalculateVisible
  #
  def recalculateVisible(self, adjustment, currentRecord, recordCount):
    if not self.hidden:
      index = self._visibleIndex + adjustment

      if index < 0 : index = 0

      # Don't let index pass the number of widgets on screen
      if index >= int(self._rows):
        index = int(self._rows)-1

      # Don't let the index past the number of records in the
      # system
      lowestVisible = currentRecord - index
      if lowestVisible < 0 : lowestVisible = 0
      if lowestVisible + index > recordCount:
        index = index -1

#      # If the current record has rolled around
#      # from the top to the bottom then reset
#      # the counter
      if currentRecord == 0:
        index = 0

      self._visibleIndex = index
      self.lowestVisible = lowestVisible

##  def processTrigger(self, *args, **parms):
##    try:
##      GTriggerExtension.processTrigger(self, *args, **parms)
##    except:
##      form = self.findParentOfType('GFForm')





