#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
        # License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# FilterSupport.py
#
# DESCRIPTION:
#
# NOTES:
#

from gnue.designer.reports.FilterSupport import FilterSupport as _BaseFilterSupport
from GroupEditor import GroupEditor
from Incubator import Incubator as _Incubator

class FilterSupport(_BaseFilterSupport):

  NAMESPACE = 'GNUe:Reports:Standard'
  INCUBATORCLASS = _Incubator

  def init(self):
    # EventAware provided by ToolBase
    self.instance.registerEventListeners({
                       'ObjectCreated'       : self.onCreateObject,
                       'ObjectModified'      : self.onModifyObject,
                       'ObjectDeleted'       : self.onDeleteObject,
                      })


  def initAsNew(self):
    _BaseFilterSupport.initAsNew(self)


  def addTools(self):
    self.instance.addToolSeparator()
    self.instance.addTool('groupEditor',   _('Group Editor'), GroupEditor, 'F5')


  def onCreateObject(self, event):
    pass


  def onModifyObject(self, event):
    pass


  def onDeleteObject(self, event):
    pass


