#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2002-2005 Free Software Foundation
#
# FILE:
# Project.py
#
# DESCRIPTION:
# Class that contains a sax based xml processor for GNUe project support
#
# NOTES:
#

from gnue.common.definitions import GParser

import copy, types
from gnue.common.formatting import GTypecast






########
########  Please keep this file neat !!!
########






#######################################################
# This method loads a form from an XML file and returns
# a GDProject object.  If initialize is 1 (default),
# then the process def is initialized and ready to go.
#######################################################

def loadProject(buffer, initialize=1):
  return GParser.loadXMLObject (buffer, xmlProcessHandler, 'GNProcesses', 'processes',
           initialize, attributes={})


xmlElements = None


def getXMLelements():

  global xmlElements

  if xmlElements == None:
    import Objects

    xmlElements = {
      'project': {
         'BaseClass': Objects.GPProject,
#         'Required': 1,
         'SingleInstance': 1,
         'Attributes': {
            'title': {
               'Typecast': GTypecast.text,
               'Default': 'Untitled Menu' } },
         'ParentTags': None },

      'files': {
         'BaseClass': Objects.GNProcess,
         'Attributes': {
            'id': {
#               'Required': 1,
               'Unique': 1,
               'Typecast': GTypecast.name },
            'title': {
               'Typecast': GTypecast.text } },
         'ParentTags': ('processes','process') },

      'file': {
         'BaseClass': Objects.GPFile,
         'Attributes': {
            'name': {
               'Unique': 1,
               'Typecast': GTypecast.name },
            'type': {
               'Required': 1,
               'ValueSet': {
                 'app': {},
                 'form': {},
                 'report': {} },
               'Typecast': GTypecast.name },
            'location': {
               'Typecast': GTypecast.text },
            'title': {
               'Typecast': GTypecast.text } },
         'ParentTags': ('process',) },

      'parameter': {
         'BaseClass': Objects.GNParameter,
         'Required': 1,
         'Attributes': {
            'name': {
               'Required': 1,
               'Typecast': GTypecast.name },
            'value': {
               'Unique': 1,
               'Typecast': GTypecast.text } },
         'ParentTags': ('parameter',) },

      'description': {
         'BaseClass': Objects.GNDescription,
         'Attributes': {},
         'MixedContent': 1,
         'KeepWhitespace': 1,
         'UsableBySiblings': 1,
         'SingleInstance': 1,
         'ParentTags': ('process') },

    }


  return xmlElements


#######################################################
#
# xmlFormsHandler
#
# This class is called by the XML parser to
# process the xml file.
#
#######################################################

class xmlProcessHandler (GParser.xmlHandler):
  def __init__(self):

    GParser.xmlHandler.__init__(self)

    self.xmlElements = getXMLelements()


