#
# This file is part of GNU Enterprise.
#
# GNU Enterprise is free software; you can redistribute it
# and/or modify it under the terms of the GNU General Public
# License as published by the Free Software Foundation; either
# version 2, or (at your option) any later version.
#
# GNU Enterprise is distributed in the hope that it will be
# useful, but WITHOUT ANY WARRANTY; without even the implied
# warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
# PURPOSE. See the GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public
# License along with program; see the file COPYING. If not,
# write to the Free Software Foundation, Inc., 59 Temple Place
# - Suite 330, Boston, MA 02111-1307, USA.
#
# Copyright 2001-2005 Free Software Foundation
#
# FILE:
# WidgetFocusTab.py
#
# DESCRIPTION:
#
# NOTES:
#

from wxPython.wx import *
import sys, string
from gnue.common.apps import GDebug

inactiveColor = wxBLUE
activeColor = wxBLACK
textColor = wxWHITE

#
#
#
class WidgetFocusTab:
  def __init__(self, instance, widget, container):
    self.instance = instance
    panel = self.instance.visualEditor.panel
    self.widget = widget
    self.container = container
    self.x, self.y = widget._widgetHandler.widget.GetPositionTuple()

#    self.label = wxStaticText(panel, -1, "0", pos=(self.x, self.y-10))
    self.label = wxButton(panel, -1, "00", pos=(self.x-5, self.y-8), style=wxBU_EXACTFIT)
    self.label.SetBackgroundColour(inactiveColor)
    self.label.SetForegroundColour(textColor)
    EVT_BUTTON(self.label, self.label.GetId(), self.buttonHandler)

  def setOrder(self, position):
    self.position = position
    self.label.SetLabel("%s" % (position))
    self.widget.focusorder = position

  def close(self):
    self.instance = None
    self.widget = None
    self.label.Destroy()

  def buttonHandler(self, event):
    if event.GetEventType() == wxEVT_COMMAND_BUTTON_CLICKED:
      object = event.GetEventObject()
      clicked = int(object.GetLabel())

      if self.container.click <= len(self.container.list):
        if clicked > self.container.click:
          for focustab in self.container.list:
            lb = int(focustab.label.GetLabel())
            if lb < clicked and lb >= self.container.click:
              focustab.setOrder(lb+1)

        self.setOrder(self.container.click)
        self.label.SetBackgroundColour(activeColor)

        self.container.click += 1
