/* -*- buffer-read-only: t -*- vi: set ro: */
/* ----------------------------------------------------------------------------
 * This file was automatically generated by SWIG (http://www.swig.org).
 * Version 1.3.31
 * 
 * This file is not intended to be easily readable and contains a number of 
 * coding conventions designed to improve portability and efficiency. Do not make
 * changes to this file unless you know what you are doing--modify the SWIG 
 * interface file instead. 
 * ----------------------------------------------------------------------------- */

/* Implementation : GUILE */

#define SWIG_GUILE_INIT_STATIC static
SWIG_GUILE_INIT_STATIC void
SWIG_init (void);
/* -----------------------------------------------------------------------------
 *  This section contains generic SWIG labels for method/variable
 *  declarations/attributes, and other compiler dependent labels.
 * ----------------------------------------------------------------------------- */

/* template workaround for compilers that cannot correctly implement the C++ standard */
#ifndef SWIGTEMPLATEDISAMBIGUATOR
# if defined(__SUNPRO_CC)
#   if (__SUNPRO_CC <= 0x560)
#     define SWIGTEMPLATEDISAMBIGUATOR template
#   else
#     define SWIGTEMPLATEDISAMBIGUATOR 
#   endif
# else
#   define SWIGTEMPLATEDISAMBIGUATOR 
# endif
#endif

/* inline attribute */
#ifndef SWIGINLINE
# if defined(__cplusplus) || (defined(__GNUC__) && !defined(__STRICT_ANSI__))
#   define SWIGINLINE inline
# else
#   define SWIGINLINE
# endif
#endif

/* attribute recognised by some compilers to avoid 'unused' warnings */
#ifndef SWIGUNUSED
# if defined(__GNUC__)
#   if !(defined(__cplusplus)) || (__GNUC__ > 3 || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4))
#     define SWIGUNUSED __attribute__ ((__unused__)) 
#   else
#     define SWIGUNUSED
#   endif
# elif defined(__ICC)
#   define SWIGUNUSED __attribute__ ((__unused__)) 
# else
#   define SWIGUNUSED 
# endif
#endif

#ifndef SWIGUNUSEDPARM
# ifdef __cplusplus
#   define SWIGUNUSEDPARM(p)
# else
#   define SWIGUNUSEDPARM(p) p SWIGUNUSED 
# endif
#endif

/* internal SWIG method */
#ifndef SWIGINTERN
# define SWIGINTERN static SWIGUNUSED
#endif

/* internal inline SWIG method */
#ifndef SWIGINTERNINLINE
# define SWIGINTERNINLINE SWIGINTERN SWIGINLINE
#endif

/* exporting methods */
#if (__GNUC__ >= 4) || (__GNUC__ == 3 && __GNUC_MINOR__ >= 4)
#  ifndef GCC_HASCLASSVISIBILITY
#    define GCC_HASCLASSVISIBILITY
#  endif
#endif

#ifndef SWIGEXPORT
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   if defined(STATIC_LINKED)
#     define SWIGEXPORT
#   else
#     define SWIGEXPORT __declspec(dllexport)
#   endif
# else
#   if defined(__GNUC__) && defined(GCC_HASCLASSVISIBILITY)
#     define SWIGEXPORT __attribute__ ((visibility("default")))
#   else
#     define SWIGEXPORT
#   endif
# endif
#endif

/* calling conventions for Windows */
#ifndef SWIGSTDCALL
# if defined(_WIN32) || defined(__WIN32__) || defined(__CYGWIN__)
#   define SWIGSTDCALL __stdcall
# else
#   define SWIGSTDCALL
# endif 
#endif

/* Deal with Microsoft's attempt at deprecating C standard runtime functions */
#if !defined(SWIG_NO_CRT_SECURE_NO_DEPRECATE) && defined(_MSC_VER) && !defined(_CRT_SECURE_NO_DEPRECATE)
# define _CRT_SECURE_NO_DEPRECATE
#endif

/* -----------------------------------------------------------------------------
 * swigrun.swg
 *
 * This file contains generic CAPI SWIG runtime support for pointer
 * type checking.
 * ----------------------------------------------------------------------------- */

/* This should only be incremented when either the layout of swig_type_info changes,
   or for whatever reason, the runtime changes incompatibly */
#define SWIG_RUNTIME_VERSION "3"

/* define SWIG_TYPE_TABLE_NAME as "SWIG_TYPE_TABLE" */
#ifdef SWIG_TYPE_TABLE
# define SWIG_QUOTE_STRING(x) #x
# define SWIG_EXPAND_AND_QUOTE_STRING(x) SWIG_QUOTE_STRING(x)
# define SWIG_TYPE_TABLE_NAME SWIG_EXPAND_AND_QUOTE_STRING(SWIG_TYPE_TABLE)
#else
# define SWIG_TYPE_TABLE_NAME
#endif

/*
  You can use the SWIGRUNTIME and SWIGRUNTIMEINLINE macros for
  creating a static or dynamic library from the swig runtime code.
  In 99.9% of the cases, swig just needs to declare them as 'static'.
  
  But only do this if is strictly necessary, ie, if you have problems
  with your compiler or so.
*/

#ifndef SWIGRUNTIME
# define SWIGRUNTIME SWIGINTERN
#endif

#ifndef SWIGRUNTIMEINLINE
# define SWIGRUNTIMEINLINE SWIGRUNTIME SWIGINLINE
#endif

/*  Generic buffer size */
#ifndef SWIG_BUFFER_SIZE
# define SWIG_BUFFER_SIZE 1024
#endif

/* Flags for pointer conversions */
#define SWIG_POINTER_DISOWN        0x1

/* Flags for new pointer objects */
#define SWIG_POINTER_OWN           0x1


/* 
   Flags/methods for returning states.
   
   The swig conversion methods, as ConvertPtr, return and integer 
   that tells if the conversion was successful or not. And if not,
   an error code can be returned (see swigerrors.swg for the codes).
   
   Use the following macros/flags to set or process the returning
   states.
   
   In old swig versions, you usually write code as:

     if (SWIG_ConvertPtr(obj,vptr,ty.flags) != -1) {
       // success code
     } else {
       //fail code
     }

   Now you can be more explicit as:

    int res = SWIG_ConvertPtr(obj,vptr,ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
    } else {
      // fail code
    }

   that seems to be the same, but now you can also do

    Type *ptr;
    int res = SWIG_ConvertPtr(obj,(void **)(&ptr),ty.flags);
    if (SWIG_IsOK(res)) {
      // success code
      if (SWIG_IsNewObj(res) {
        ...
	delete *ptr;
      } else {
        ...
      }
    } else {
      // fail code
    }
    
   I.e., now SWIG_ConvertPtr can return new objects and you can
   identify the case and take care of the deallocation. Of course that
   requires also to SWIG_ConvertPtr to return new result values, as

      int SWIG_ConvertPtr(obj, ptr,...) {         
        if (<obj is ok>) {			       
          if (<need new object>) {		       
            *ptr = <ptr to new allocated object>; 
            return SWIG_NEWOBJ;		       
          } else {				       
            *ptr = <ptr to old object>;	       
            return SWIG_OLDOBJ;		       
          } 				       
        } else {				       
          return SWIG_BADOBJ;		       
        }					       
      }

   Of course, returning the plain '0(success)/-1(fail)' still works, but you can be
   more explicit by returning SWIG_BADOBJ, SWIG_ERROR or any of the
   swig errors code.

   Finally, if the SWIG_CASTRANK_MODE is enabled, the result code
   allows to return the 'cast rank', for example, if you have this

       int food(double)
       int fooi(int);

   and you call
 
      food(1)   // cast rank '1'  (1 -> 1.0)
      fooi(1)   // cast rank '0'

   just use the SWIG_AddCast()/SWIG_CheckState()


 */
#define SWIG_OK                    (0) 
#define SWIG_ERROR                 (-1)
#define SWIG_IsOK(r)               (r >= 0)
#define SWIG_ArgError(r)           ((r != SWIG_ERROR) ? r : SWIG_TypeError)  

/* The CastRankLimit says how many bits are used for the cast rank */
#define SWIG_CASTRANKLIMIT         (1 << 8)
/* The NewMask denotes the object was created (using new/malloc) */
#define SWIG_NEWOBJMASK            (SWIG_CASTRANKLIMIT  << 1)
/* The TmpMask is for in/out typemaps that use temporal objects */
#define SWIG_TMPOBJMASK            (SWIG_NEWOBJMASK << 1)
/* Simple returning values */
#define SWIG_BADOBJ                (SWIG_ERROR)
#define SWIG_OLDOBJ                (SWIG_OK)
#define SWIG_NEWOBJ                (SWIG_OK | SWIG_NEWOBJMASK)
#define SWIG_TMPOBJ                (SWIG_OK | SWIG_TMPOBJMASK)
/* Check, add and del mask methods */
#define SWIG_AddNewMask(r)         (SWIG_IsOK(r) ? (r | SWIG_NEWOBJMASK) : r)
#define SWIG_DelNewMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_NEWOBJMASK) : r)
#define SWIG_IsNewObj(r)           (SWIG_IsOK(r) && (r & SWIG_NEWOBJMASK))
#define SWIG_AddTmpMask(r)         (SWIG_IsOK(r) ? (r | SWIG_TMPOBJMASK) : r)
#define SWIG_DelTmpMask(r)         (SWIG_IsOK(r) ? (r & ~SWIG_TMPOBJMASK) : r)
#define SWIG_IsTmpObj(r)           (SWIG_IsOK(r) && (r & SWIG_TMPOBJMASK))


/* Cast-Rank Mode */
#if defined(SWIG_CASTRANK_MODE)
#  ifndef SWIG_TypeRank
#    define SWIG_TypeRank             unsigned long
#  endif
#  ifndef SWIG_MAXCASTRANK            /* Default cast allowed */
#    define SWIG_MAXCASTRANK          (2)
#  endif
#  define SWIG_CASTRANKMASK          ((SWIG_CASTRANKLIMIT) -1)
#  define SWIG_CastRank(r)           (r & SWIG_CASTRANKMASK)
SWIGINTERNINLINE int SWIG_AddCast(int r) { 
  return SWIG_IsOK(r) ? ((SWIG_CastRank(r) < SWIG_MAXCASTRANK) ? (r + 1) : SWIG_ERROR) : r;
}
SWIGINTERNINLINE int SWIG_CheckState(int r) { 
  return SWIG_IsOK(r) ? SWIG_CastRank(r) + 1 : 0; 
}
#else /* no cast-rank mode */
#  define SWIG_AddCast
#  define SWIG_CheckState(r) (SWIG_IsOK(r) ? 1 : 0)
#endif




#include <string.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef void *(*swig_converter_func)(void *);
typedef struct swig_type_info *(*swig_dycast_func)(void **);

/* Structure to store inforomation on one type */
typedef struct swig_type_info {
  const char             *name;			/* mangled name of this type */
  const char             *str;			/* human readable name of this type */
  swig_dycast_func        dcast;		/* dynamic cast function down a hierarchy */
  struct swig_cast_info  *cast;			/* linked list of types that can cast into this type */
  void                   *clientdata;		/* language specific type data */
  int                    owndata;		/* flag if the structure owns the clientdata */
} swig_type_info;

/* Structure to store a type and conversion function used for casting */
typedef struct swig_cast_info {
  swig_type_info         *type;			/* pointer to type that is equivalent to this type */
  swig_converter_func     converter;		/* function to cast the void pointers */
  struct swig_cast_info  *next;			/* pointer to next cast in linked list */
  struct swig_cast_info  *prev;			/* pointer to the previous cast */
} swig_cast_info;

/* Structure used to store module information
 * Each module generates one structure like this, and the runtime collects
 * all of these structures and stores them in a circularly linked list.*/
typedef struct swig_module_info {
  swig_type_info         **types;		/* Array of pointers to swig_type_info structures that are in this module */
  size_t                 size;		        /* Number of types in this module */
  struct swig_module_info *next;		/* Pointer to next element in circularly linked list */
  swig_type_info         **type_initial;	/* Array of initially generated type structures */
  swig_cast_info         **cast_initial;	/* Array of initially generated casting structures */
  void                    *clientdata;		/* Language specific module data */
} swig_module_info;

/* 
  Compare two type names skipping the space characters, therefore
  "char*" == "char *" and "Class<int>" == "Class<int >", etc.

  Return 0 when the two name types are equivalent, as in
  strncmp, but skipping ' '.
*/
SWIGRUNTIME int
SWIG_TypeNameComp(const char *f1, const char *l1,
		  const char *f2, const char *l2) {
  for (;(f1 != l1) && (f2 != l2); ++f1, ++f2) {
    while ((*f1 == ' ') && (f1 != l1)) ++f1;
    while ((*f2 == ' ') && (f2 != l2)) ++f2;
    if (*f1 != *f2) return (*f1 > *f2) ? 1 : -1;
  }
  return (l1 - f1) - (l2 - f2);
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if not equal, 1 if equal
*/
SWIGRUNTIME int
SWIG_TypeEquiv(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}

/*
  Check type equivalence in a name list like <name1>|<name2>|...
  Return 0 if equal, -1 if nb < tb, 1 if nb > tb
*/
SWIGRUNTIME int
SWIG_TypeCompare(const char *nb, const char *tb) {
  int equiv = 0;
  const char* te = tb + strlen(tb);
  const char* ne = nb;
  while (!equiv && *ne) {
    for (nb = ne; *ne; ++ne) {
      if (*ne == '|') break;
    }
    equiv = (SWIG_TypeNameComp(nb, ne, tb, te) == 0) ? 1 : 0;
    if (*ne) ++ne;
  }
  return equiv;
}


/* think of this as a c++ template<> or a scheme macro */
#define SWIG_TypeCheck_Template(comparison, ty)         \
  if (ty) {                                             \
    swig_cast_info *iter = ty->cast;                    \
    while (iter) {                                      \
      if (comparison) {                                 \
        if (iter == ty->cast) return iter;              \
        /* Move iter to the top of the linked list */   \
        iter->prev->next = iter->next;                  \
        if (iter->next)                                 \
          iter->next->prev = iter->prev;                \
        iter->next = ty->cast;                          \
        iter->prev = 0;                                 \
        if (ty->cast) ty->cast->prev = iter;            \
        ty->cast = iter;                                \
        return iter;                                    \
      }                                                 \
      iter = iter->next;                                \
    }                                                   \
  }                                                     \
  return 0

/*
  Check the typename
*/
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheck(const char *c, swig_type_info *ty) {
  SWIG_TypeCheck_Template(strcmp(iter->type->name, c) == 0, ty);
}

/* Same as previous function, except strcmp is replaced with a pointer comparison */
SWIGRUNTIME swig_cast_info *
SWIG_TypeCheckStruct(swig_type_info *from, swig_type_info *into) {
  SWIG_TypeCheck_Template(iter->type == from, into);
}

/*
  Cast a pointer up an inheritance hierarchy
*/
SWIGRUNTIMEINLINE void *
SWIG_TypeCast(swig_cast_info *ty, void *ptr) {
  return ((!ty) || (!ty->converter)) ? ptr : (*ty->converter)(ptr);
}

/* 
   Dynamic pointer casting. Down an inheritance hierarchy
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeDynamicCast(swig_type_info *ty, void **ptr) {
  swig_type_info *lastty = ty;
  if (!ty || !ty->dcast) return ty;
  while (ty && (ty->dcast)) {
    ty = (*ty->dcast)(ptr);
    if (ty) lastty = ty;
  }
  return lastty;
}

/*
  Return the name associated with this type
*/
SWIGRUNTIMEINLINE const char *
SWIG_TypeName(const swig_type_info *ty) {
  return ty->name;
}

/*
  Return the pretty name associated with this type,
  that is an unmangled type name in a form presentable to the user.
*/
SWIGRUNTIME const char *
SWIG_TypePrettyName(const swig_type_info *type) {
  /* The "str" field contains the equivalent pretty names of the
     type, separated by vertical-bar characters.  We choose
     to print the last name, as it is often (?) the most
     specific. */
  if (!type) return NULL;
  if (type->str != NULL) {
    const char *last_name = type->str;
    const char *s;
    for (s = type->str; *s; s++)
      if (*s == '|') last_name = s+1;
    return last_name;
  }
  else
    return type->name;
}

/* 
   Set the clientdata field for a type
*/
SWIGRUNTIME void
SWIG_TypeClientData(swig_type_info *ti, void *clientdata) {
  swig_cast_info *cast = ti->cast;
  /* if (ti->clientdata == clientdata) return; */
  ti->clientdata = clientdata;
  
  while (cast) {
    if (!cast->converter) {
      swig_type_info *tc = cast->type;
      if (!tc->clientdata) {
	SWIG_TypeClientData(tc, clientdata);
      }
    }    
    cast = cast->next;
  }
}
SWIGRUNTIME void
SWIG_TypeNewClientData(swig_type_info *ti, void *clientdata) {
  SWIG_TypeClientData(ti, clientdata);
  ti->owndata = 1;
}
  
/*
  Search for a swig_type_info structure only by mangled name
  Search is a O(log #types)
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_MangledTypeQueryModule(swig_module_info *start, 
                            swig_module_info *end, 
		            const char *name) {
  swig_module_info *iter = start;
  do {
    if (iter->size) {
      register size_t l = 0;
      register size_t r = iter->size - 1;
      do {
	/* since l+r >= 0, we can (>> 1) instead (/ 2) */
	register size_t i = (l + r) >> 1; 
	const char *iname = iter->types[i]->name;
	if (iname) {
	  register int compare = strcmp(name, iname);
	  if (compare == 0) {	    
	    return iter->types[i];
	  } else if (compare < 0) {
	    if (i) {
	      r = i - 1;
	    } else {
	      break;
	    }
	  } else if (compare > 0) {
	    l = i + 1;
	  }
	} else {
	  break; /* should never happen */
	}
      } while (l <= r);
    }
    iter = iter->next;
  } while (iter != end);
  return 0;
}

/*
  Search for a swig_type_info structure for either a mangled name or a human readable name.
  It first searches the mangled names of the types, which is a O(log #types)
  If a type is not found it then searches the human readable names, which is O(#types).
  
  We start searching at module start, and finish searching when start == end.  
  Note: if start == end at the beginning of the function, we go all the way around
  the circular list.
*/
SWIGRUNTIME swig_type_info *
SWIG_TypeQueryModule(swig_module_info *start, 
                     swig_module_info *end, 
		     const char *name) {
  /* STEP 1: Search the name field using binary search */
  swig_type_info *ret = SWIG_MangledTypeQueryModule(start, end, name);
  if (ret) {
    return ret;
  } else {
    /* STEP 2: If the type hasn't been found, do a complete search
       of the str field (the human readable name) */
    swig_module_info *iter = start;
    do {
      register size_t i = 0;
      for (; i < iter->size; ++i) {
	if (iter->types[i]->str && (SWIG_TypeEquiv(iter->types[i]->str, name)))
	  return iter->types[i];
      }
      iter = iter->next;
    } while (iter != end);
  }
  
  /* neither found a match */
  return 0;
}

/* 
   Pack binary data into a string
*/
SWIGRUNTIME char *
SWIG_PackData(char *c, void *ptr, size_t sz) {
  static const char hex[17] = "0123456789abcdef";
  register const unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu =  u + sz;
  for (; u != eu; ++u) {
    register unsigned char uu = *u;
    *(c++) = hex[(uu & 0xf0) >> 4];
    *(c++) = hex[uu & 0xf];
  }
  return c;
}

/* 
   Unpack binary data from a string
*/
SWIGRUNTIME const char *
SWIG_UnpackData(const char *c, void *ptr, size_t sz) {
  register unsigned char *u = (unsigned char *) ptr;
  register const unsigned char *eu = u + sz;
  for (; u != eu; ++u) {
    register char d = *(c++);
    register unsigned char uu;
    if ((d >= '0') && (d <= '9'))
      uu = ((d - '0') << 4);
    else if ((d >= 'a') && (d <= 'f'))
      uu = ((d - ('a'-10)) << 4);
    else 
      return (char *) 0;
    d = *(c++);
    if ((d >= '0') && (d <= '9'))
      uu |= (d - '0');
    else if ((d >= 'a') && (d <= 'f'))
      uu |= (d - ('a'-10));
    else 
      return (char *) 0;
    *u = uu;
  }
  return c;
}

/* 
   Pack 'void *' into a string buffer.
*/
SWIGRUNTIME char *
SWIG_PackVoidPtr(char *buff, void *ptr, const char *name, size_t bsz) {
  char *r = buff;
  if ((2*sizeof(void *) + 2) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,&ptr,sizeof(void *));
  if (strlen(name) + 1 > (bsz - (r - buff))) return 0;
  strcpy(r,name);
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackVoidPtr(const char *c, void **ptr, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      *ptr = (void *) 0;
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sizeof(void *));
}

SWIGRUNTIME char *
SWIG_PackDataName(char *buff, void *ptr, size_t sz, const char *name, size_t bsz) {
  char *r = buff;
  size_t lname = (name ? strlen(name) : 0);
  if ((2*sz + 2 + lname) > bsz) return 0;
  *(r++) = '_';
  r = SWIG_PackData(r,ptr,sz);
  if (lname) {
    strncpy(r,name,lname+1);
  } else {
    *r = 0;
  }
  return buff;
}

SWIGRUNTIME const char *
SWIG_UnpackDataName(const char *c, void *ptr, size_t sz, const char *name) {
  if (*c != '_') {
    if (strcmp(c,"NULL") == 0) {
      memset(ptr,0,sz);
      return name;
    } else {
      return 0;
    }
  }
  return SWIG_UnpackData(++c,ptr,sz);
}

#ifdef __cplusplus
}
#endif

/* -----------------------------------------------------------------------------
 * See the LICENSE file for information on copyright, usage and redistribution
 * of SWIG, and the README file for authors - http://www.swig.org/release.html.
 *
 * guile_scm_run.swg
 * ----------------------------------------------------------------------------- */

#include <libguile.h>
#include <stdio.h>
#include <string.h>
#include <stdlib.h>

#ifdef __cplusplus
extern "C" {
#endif

typedef SCM (*swig_guile_proc)();
typedef SCM (*guile_destructor)(SCM);

typedef struct swig_guile_clientdata {
  guile_destructor destroy;
  SCM goops_class;
} swig_guile_clientdata;

#define SWIG_scm2str(s) \
  SWIG_Guile_scm2newstr(s, NULL)
#define SWIG_malloc(size) \
  SCM_MUST_MALLOC(size)
#define SWIG_free(mem) \
  scm_must_free(mem)
#define SWIG_ConvertPtr(s, result, type, flags) \
  SWIG_Guile_ConvertPtr(s, result, type, flags)
#define SWIG_MustGetPtr(s, type, argnum, flags) \
  SWIG_Guile_MustGetPtr(s, type, argnum, flags, FUNC_NAME)
#define SWIG_NewPointerObj(ptr, type, owner) \
  SWIG_Guile_NewPointerObj((void*)ptr, type, owner)
#define SWIG_PointerAddress(object) \
  SWIG_Guile_PointerAddress(object)
#define SWIG_PointerType(object) \
  SWIG_Guile_PointerType(object)
#define SWIG_IsPointerOfType(object, type) \
  SWIG_Guile_IsPointerOfType(object, type)
#define SWIG_IsPointer(object) \
  SWIG_Guile_IsPointer(object)
#define SWIG_contract_assert(expr, msg)				\
  if (!(expr))							\
    scm_error(scm_str2symbol("swig-contract-assertion-failed"),	\
	      (char *) FUNC_NAME, (char *) msg,			\
	      SCM_EOL, SCM_BOOL_F); else

/* for C++ member pointers, ie, member methods */
#define SWIG_ConvertMember(obj, ptr, sz, ty) \
  SWIG_Guile_ConvertMember(obj, ptr, sz, ty, FUNC_NAME)
#define SWIG_NewMemberObj(ptr, sz, type) \
  SWIG_Guile_NewMemberObj(ptr, sz, type, FUNC_NAME)
  
/* Runtime API */
static swig_module_info *SWIG_Guile_GetModule(void);
#define SWIG_GetModule(clientdata) SWIG_Guile_GetModule()
#define SWIG_SetModule(clientdata, pointer) SWIG_Guile_SetModule(pointer)
  
SWIGINTERN char *
SWIG_Guile_scm2newstr(SCM str, size_t *len) {
#define FUNC_NAME "SWIG_Guile_scm2newstr"
  char *ret;
  size_t l;

  SCM_ASSERT (SCM_STRINGP(str), str, 1, FUNC_NAME);
  
  l = SCM_STRING_LENGTH(str);
  ret = (char *) SWIG_malloc( (l + 1) * sizeof(char));
  if (!ret) return NULL;

  memcpy(ret, SCM_STRING_CHARS(str), l);
  ret[l] = '\0';
  if (len) *len = l;
  return ret;
#undef FUNC_NAME
}

static int swig_initialized = 0;
static scm_t_bits swig_tag = 0;
static scm_t_bits swig_collectable_tag = 0;
static scm_t_bits swig_destroyed_tag = 0;
static scm_t_bits swig_member_function_tag = 0;
static SCM swig_make_func = SCM_EOL;
static SCM swig_keyword = SCM_EOL;
static SCM swig_symbol = SCM_EOL;

#define SWIG_Guile_GetSmob(x) \
  ( SCM_NNULLP(x) && SCM_INSTANCEP(x) && SCM_NFALSEP(scm_slot_exists_p(x, swig_symbol)) \
      ? scm_slot_ref(x, swig_symbol) : (x) )

SWIGINTERN SCM
SWIG_Guile_NewPointerObj(void *ptr, swig_type_info *type, int owner)
{
  if (ptr == NULL)
    return SCM_EOL;
  else {
    SCM smob;
    swig_guile_clientdata *cdata = (swig_guile_clientdata *) type->clientdata;
    if (owner)
      SCM_NEWSMOB2(smob, swig_collectable_tag, ptr, (void *) type);
    else
      SCM_NEWSMOB2(smob, swig_tag, ptr, (void *) type);

    if (!cdata || SCM_NULLP(cdata->goops_class) || swig_make_func == SCM_EOL ) {
      return smob;
    } else {
      /* the scm_make() C function only handles the creation of gf,
	 methods and classes (no instances) the (make ...) function is
	 later redefined in goops.scm.  So we need to call that
	 Scheme function. */
      return scm_apply(swig_make_func,
		       scm_list_3(cdata->goops_class,
				  swig_keyword,
				  smob),
		       SCM_EOL);
    }
  }
}

SWIGINTERN unsigned long
SWIG_Guile_PointerAddress(SCM object)
{
  SCM smob = SWIG_Guile_GetSmob(object);
  if (SCM_NULLP(smob)) return 0;
  else if (SCM_SMOB_PREDICATE(swig_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_destroyed_tag, smob)) {
    return (unsigned long) (void *) SCM_CELL_WORD_1(smob);
  }
  else scm_wrong_type_arg("SWIG-Guile-PointerAddress", 1, object);
}

SWIGINTERN swig_type_info *
SWIG_Guile_PointerType(SCM object)
{
  SCM smob = SWIG_Guile_GetSmob(object);
  if (SCM_NULLP(smob)) return NULL;
  else if (SCM_SMOB_PREDICATE(swig_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)
	   || SCM_SMOB_PREDICATE(swig_destroyed_tag, smob)) {
    return (swig_type_info *) SCM_CELL_WORD_2(smob);
  }
  else scm_wrong_type_arg("SWIG-Guile-PointerType", 1, object);
}
  
SWIGINTERN int
SWIG_Guile_ConvertPtr(SCM s, void **result, swig_type_info *type, int flags)
{
  swig_cast_info *cast;
  swig_type_info *from;
  SCM smob = SWIG_Guile_GetSmob(s);

  if (SCM_NULLP(smob)) {
    *result = NULL;
    return SWIG_OK;
  } else if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
    /* we do not accept smobs representing destroyed pointers */
    from = (swig_type_info *) SCM_CELL_WORD_2(smob);
    if (!from) return SWIG_ERROR;
    if (type) {
      cast = SWIG_TypeCheckStruct(from, type);
      if (cast) {
        *result = SWIG_TypeCast(cast, (void *) SCM_CELL_WORD_1(smob));
        return SWIG_OK;
      } else {
        return SWIG_ERROR;
      }
    } else {
      *result = (void *) SCM_CELL_WORD_1(smob);
      return SWIG_OK;
    }
  }
  return SWIG_ERROR;
}

SWIGINTERNINLINE void *
SWIG_Guile_MustGetPtr (SCM s, swig_type_info *type,
		       int argnum, int flags, const char *func_name)
{
  void *result;
  int res = SWIG_Guile_ConvertPtr(s, &result, type, flags);
  if (!SWIG_IsOK(res)) {
    /* type mismatch */
    scm_wrong_type_arg((char *) func_name, argnum, s);
  }
  return result;
}

SWIGINTERNINLINE int
SWIG_Guile_IsPointerOfType (SCM s, swig_type_info *type)
{
  void *result;
  if (SWIG_Guile_ConvertPtr(s, &result, type, 0)) {
    /* type mismatch */
    return 0;
  }
  else return 1;
}

SWIGINTERNINLINE int
SWIG_Guile_IsPointer (SCM s)
{
  /* module might not be initialized yet, so initialize it */
  SWIG_Guile_GetModule();
  return SWIG_Guile_IsPointerOfType (s, NULL);
}

/* Mark a pointer object non-collectable */
SWIGINTERN void
SWIG_Guile_MarkPointerNoncollectable(SCM s)
{
  SCM smob = SWIG_Guile_GetSmob(s);
  if (!SCM_NULLP(smob)) {
    if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
      SCM_SET_CELL_TYPE(smob, swig_tag);
    }
    else scm_wrong_type_arg(NULL, 0, s);
  }
}

/* Mark a pointer object destroyed */
SWIGINTERN void
SWIG_Guile_MarkPointerDestroyed(SCM s)
{
  SCM smob = SWIG_Guile_GetSmob(s);
  if (!SCM_NULLP(smob)) {
    if (SCM_SMOB_PREDICATE(swig_tag, smob) || SCM_SMOB_PREDICATE(swig_collectable_tag, smob)) {
      SCM_SET_CELL_TYPE(smob, swig_destroyed_tag);
    }
    else scm_wrong_type_arg(NULL, 0, s);
  }
}

/* Member functions */

SWIGINTERN SCM
SWIG_Guile_NewMemberObj(void *ptr, size_t sz, swig_type_info *type,
			const char *func_name)
{
  SCM smob;
  void *copy = malloc(sz);
  memcpy(copy, ptr, sz);
  SCM_NEWSMOB2(smob, swig_member_function_tag, copy, (void *) type);
  return smob;
}

SWIGINTERN int
SWIG_Guile_ConvertMember(SCM smob, void *ptr, size_t sz, swig_type_info *type,
			 const char *func_name)
{
  swig_cast_info *cast;
  swig_type_info *from;

  if (SCM_SMOB_PREDICATE(swig_member_function_tag, smob)) {
    from = (swig_type_info *) SCM_CELL_WORD_2(smob);
    if (!from) return SWIG_ERROR;
    if (type) {
      cast = SWIG_TypeCheckStruct(from, type);
      if (!cast) return SWIG_ERROR;
    }
    memcpy(ptr, (void *) SCM_CELL_WORD_1(smob), sz);
    return SWIG_OK;
  }
  return SWIG_ERROR;
}
     

/* Init */

SWIGINTERN int
print_swig_aux (SCM swig_smob, SCM port, scm_print_state *pstate, 
                const char *attribute)
{
  swig_type_info *type;
  
  type = (swig_type_info *) SCM_CELL_WORD_2(swig_smob);
  if (type) {
    scm_puts((char *) "#<", port);
    scm_puts((char *) attribute, port);
    scm_puts((char *) "swig-pointer ", port);
    scm_puts((char *) SWIG_TypePrettyName(type), port);
    scm_puts((char *) " ", port);
    scm_intprint((long) SCM_CELL_WORD_1(swig_smob), 16, port);
    scm_puts((char *) ">", port);
    /* non-zero means success */
    return 1;
  } else {
    return 0;
  }
}

  
SWIGINTERN int
print_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "");
}

SWIGINTERN int
print_collectable_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "collectable-");
}

SWIGINTERN int
print_destroyed_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  return print_swig_aux(swig_smob, port, pstate, "destroyed-");
}

SWIGINTERN int
print_member_function_swig (SCM swig_smob, SCM port, scm_print_state *pstate)
{
  swig_type_info *type;
  type = (swig_type_info *) SCM_CELL_WORD_2(swig_smob);
  if (type) {
    scm_puts((char *) "#<", port);
    scm_puts((char *) "swig-member-function-pointer ", port);
    scm_puts((char *) SWIG_TypePrettyName(type), port);
    scm_puts((char *) " >", port);
    /* non-zero means success */
    return 1;
  } else {
    return 0;
  }
}

SWIGINTERN SCM
equalp_swig (SCM A, SCM B)
{
  if (SCM_CELL_WORD_0(A) == SCM_CELL_WORD_0(B) && SCM_CELL_WORD_1(A) == SCM_CELL_WORD_1(B) 
      && SCM_CELL_WORD_2(A) == SCM_CELL_WORD_2(B))
    return SCM_BOOL_T;
  else return SCM_BOOL_F;
}

SWIGINTERN size_t
free_swig(SCM A)
{
  swig_type_info *type = (swig_type_info *) SCM_CELL_WORD_2(A);
  if (type) {
    if (type->clientdata && ((swig_guile_clientdata *)type->clientdata)->destroy)
      ((swig_guile_clientdata *)type->clientdata)->destroy(A);
  } 
  return 0;
}

SWIGINTERN size_t
free_swig_member_function(SCM A)
{
  free((swig_type_info *) SCM_CELL_WORD_1(A));
  return 0;
}

SWIGINTERN int
ensure_smob_tag(SCM swig_module,
		scm_t_bits *tag_variable,
		const char *smob_name,
		const char *scheme_variable_name)
{
  SCM variable = scm_sym2var(scm_str2symbol(scheme_variable_name),
			     scm_module_lookup_closure(swig_module),
			     SCM_BOOL_T);
  if (SCM_UNBNDP(SCM_VARIABLE_REF(variable))) {
    *tag_variable = scm_make_smob_type((char*)scheme_variable_name, 0);
    SCM_VARIABLE_SET(variable,
		     scm_ulong2num(*tag_variable));
    return 1;
  }
  else {
    *tag_variable = scm_num2ulong(SCM_VARIABLE_REF(variable), 0,
				  "SWIG_Guile_Init");
    return 0;
  }
}

SWIGINTERN SCM
SWIG_Guile_Init ()
{
  static SCM swig_module;
  
  if (swig_initialized) return swig_module;
  swig_initialized = 1;

  swig_module = scm_c_resolve_module("Swig swigrun");
  if (ensure_smob_tag(swig_module, &swig_tag,
		      "swig-pointer", "swig-pointer-tag")) {
    scm_set_smob_print(swig_tag, print_swig);
    scm_set_smob_equalp(swig_tag, equalp_swig);
  }
  if (ensure_smob_tag(swig_module, &swig_collectable_tag,
		      "collectable-swig-pointer", "collectable-swig-pointer-tag")) {
    scm_set_smob_print(swig_collectable_tag, print_collectable_swig);
    scm_set_smob_equalp(swig_collectable_tag, equalp_swig);
    scm_set_smob_free(swig_collectable_tag, free_swig);
  }
  if (ensure_smob_tag(swig_module, &swig_destroyed_tag,
		      "destroyed-swig-pointer", "destroyed-swig-pointer-tag")) {
    scm_set_smob_print(swig_destroyed_tag, print_destroyed_swig);
    scm_set_smob_equalp(swig_destroyed_tag, equalp_swig);
  }
  if (ensure_smob_tag(swig_module, &swig_member_function_tag,
		      "swig-member-function-pointer", "swig-member-function-pointer-tag")) {
    scm_set_smob_print(swig_member_function_tag, print_member_function_swig);
    scm_set_smob_free(swig_member_function_tag, free_swig_member_function);
  }
  swig_make_func = scm_permanent_object(
  scm_variable_ref(scm_c_module_lookup(scm_c_resolve_module("oop goops"), "make")));
  swig_keyword = scm_permanent_object(scm_c_make_keyword((char*) "init-smob"));
  swig_symbol = scm_permanent_object(scm_str2symbol("swig-smob"));
#ifdef SWIG_INIT_RUNTIME_MODULE
  SWIG_INIT_RUNTIME_MODULE
#endif

  return swig_module;
}

SWIGINTERN swig_module_info *
SWIG_Guile_GetModule(void)
{
  SCM module;
  SCM variable;

  module = SWIG_Guile_Init();

  variable = scm_sym2var(scm_str2symbol("swig-type-list-address" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME),
			       scm_module_lookup_closure(module),
			       SCM_BOOL_T);
  if (SCM_UNBNDP(SCM_VARIABLE_REF(variable))) {
    return NULL;
  } else {
    return (swig_module_info *) scm_num2ulong(SCM_VARIABLE_REF(variable), 0, "SWIG_Guile_Init");
  }
}

SWIGINTERN void
SWIG_Guile_SetModule(swig_module_info *swig_module)
{
  SCM module;
  SCM variable;

  module = SWIG_Guile_Init();
    
  variable = scm_sym2var(scm_str2symbol("swig-type-list-address" SWIG_RUNTIME_VERSION SWIG_TYPE_TABLE_NAME),
			       scm_module_lookup_closure(module),
			       SCM_BOOL_T);

  SCM_VARIABLE_SET(variable, scm_ulong2num((unsigned long) swig_module));
}

SWIGINTERN int
SWIG_Guile_GetArgs (SCM *dest, SCM rest,
		    int reqargs, int optargs,
		    const char *procname)
{
  int i;
  int num_args_passed = 0;
  for (i = 0; i<reqargs; i++) {
    if (!SCM_CONSP(rest))
      scm_wrong_num_args(scm_makfrom0str((char *) procname));
    *dest++ = SCM_CAR(rest);
    rest = SCM_CDR(rest);
    num_args_passed++;
  }
  for (i = 0; i<optargs && SCM_CONSP(rest); i++) {
    *dest++ = SCM_CAR(rest);
    rest = SCM_CDR(rest);
    num_args_passed++;
  }
  for (; i<optargs; i++)
    *dest++ = SCM_UNDEFINED;
  if (!SCM_NULLP(rest))
    scm_wrong_num_args(scm_makfrom0str((char *) procname));
  return num_args_passed;
}

#ifdef __cplusplus
}
#endif



#define GUILE_MAYBE_VALUES \
      if (gswig_list_p) gswig_result = scm_values(gswig_result);

#define GUILE_MAYBE_VECTOR \
      if (gswig_list_p) gswig_result = scm_vector(gswig_result);

#define SWIG_APPEND_VALUE(object)						\
    if (gswig_result == SCM_UNSPECIFIED)						\
        gswig_result = object;							\
    else {									\
      if (!gswig_list_p) {							\
	      gswig_list_p = 1;							\
	      gswig_result = scm_listify(gswig_result, object, SCM_UNDEFINED);	\
      }									\
      else									\
            gswig_result = scm_append(scm_listify(gswig_result, scm_listify(object, SCM_UNDEFINED), SCM_UNDEFINED));		\
    }
    /* used by Lib/exception.i */
    #define gh_symbol2scm scm_str2symbol
    /* useb by Lib/cdata.i */
    #define gh_str2scm scm_mem2string


static swig_guile_clientdata _swig_guile_clientdata_gncAccountValue = { NULL, SCM_EOL };

/* -------- TYPES TABLE (BEGIN) -------- */

#define SWIGTYPE_p_Account swig_types[0]
#define SWIGTYPE_p_GList swig_types[1]
#define SWIGTYPE_p_GNCLot swig_types[2]
#define SWIGTYPE_p_GNCPrice swig_types[3]
#define SWIGTYPE_p_GType swig_types[4]
#define SWIGTYPE_p_GncAmountType swig_types[5]
#define SWIGTYPE_p_GncBillTermType swig_types[6]
#define SWIGTYPE_p_GncDiscountHow swig_types[7]
#define SWIGTYPE_p_GncEntryPaymentType swig_types[8]
#define SWIGTYPE_p_GncGUID swig_types[9]
#define SWIGTYPE_p_GncOwnerType swig_types[10]
#define SWIGTYPE_p_GncTaxIncluded swig_types[11]
#define SWIGTYPE_p_KvpFrame swig_types[12]
#define SWIGTYPE_p_QofBook swig_types[13]
#define SWIGTYPE_p_QofIdType swig_types[14]
#define SWIGTYPE_p_QofIdTypeConst swig_types[15]
#define SWIGTYPE_p_QofInstance swig_types[16]
#define SWIGTYPE_p_QofQueryOp swig_types[17]
#define SWIGTYPE_p_Timespec swig_types[18]
#define SWIGTYPE_p_Transaction swig_types[19]
#define SWIGTYPE_p__QofQuery swig_types[20]
#define SWIGTYPE_p__gncAccountValue swig_types[21]
#define SWIGTYPE_p__gncAddress swig_types[22]
#define SWIGTYPE_p__gncAddressClass swig_types[23]
#define SWIGTYPE_p__gncBillTerm swig_types[24]
#define SWIGTYPE_p__gncBillTermClass swig_types[25]
#define SWIGTYPE_p__gncCustomer swig_types[26]
#define SWIGTYPE_p__gncCustomerClass swig_types[27]
#define SWIGTYPE_p__gncEmployee swig_types[28]
#define SWIGTYPE_p__gncEmployeeClass swig_types[29]
#define SWIGTYPE_p__gncEntry swig_types[30]
#define SWIGTYPE_p__gncEntryClass swig_types[31]
#define SWIGTYPE_p__gncInvoice swig_types[32]
#define SWIGTYPE_p__gncInvoiceClass swig_types[33]
#define SWIGTYPE_p__gncJob swig_types[34]
#define SWIGTYPE_p__gncJobClass swig_types[35]
#define SWIGTYPE_p__gncOrder swig_types[36]
#define SWIGTYPE_p__gncOrderClass swig_types[37]
#define SWIGTYPE_p__gncOwner swig_types[38]
#define SWIGTYPE_p__gncTaxTable swig_types[39]
#define SWIGTYPE_p__gncTaxTableClass swig_types[40]
#define SWIGTYPE_p__gncTaxTableEntry swig_types[41]
#define SWIGTYPE_p__gncVendor swig_types[42]
#define SWIGTYPE_p__gncVendorClass swig_types[43]
#define SWIGTYPE_p_char swig_types[44]
#define SWIGTYPE_p_double swig_types[45]
#define SWIGTYPE_p_float swig_types[46]
#define SWIGTYPE_p_gboolean swig_types[47]
#define SWIGTYPE_p_gnc_commodity swig_types[48]
#define SWIGTYPE_p_gnc_numeric swig_types[49]
#define SWIGTYPE_p_int swig_types[50]
#define SWIGTYPE_p_p_GList swig_types[51]
#define SWIGTYPE_p_unsigned_int swig_types[52]
#define SWIGTYPE_p_unsigned_long swig_types[53]
#define SWIGTYPE_p_void swig_types[54]
static swig_type_info *swig_types[56];
static swig_module_info swig_module = {swig_types, 55, 0, 0, 0, 0};
#define SWIG_TypeQuery(name) SWIG_TypeQueryModule(&swig_module, &swig_module, name)
#define SWIG_MangledTypeQuery(name) SWIG_MangledTypeQueryModule(&swig_module, &swig_module, name)

/* -------- TYPES TABLE (END) -------- */


/* Includes the header in the wrapper code */
#include <config.h>
#include <gncAddress.h>
#include <gncBillTerm.h>
#include <gncCustomer.h>
#include <gncEmployee.h>
#include <gncEntry.h>
#include <gncInvoice.h>
#include <gncJob.h>
#include <gncOrder.h>
#include <gncOwner.h>
#include <gncTaxTable.h>
#include <gncVendor.h>


#include <guile-mappings.h>
#include <gncBusGuile.h>
#ifdef _MSC_VER
# define snprintf _snprintf
#endif
#include "engine-helpers.h"
#include "gncBusGuile.h"

/* Disable -Waddress.  GCC 4.2 warns (and fails to compile with -Werror) when
 * passing the address of a guid on the stack to QOF_BOOK_LOOKUP_ENTITY via
 * gncInvoiceLookup and friends.  When the macro gets inlined, the compiler
 * emits a warning that the guid null pointer test is always true.
 */
#if (__GNUC__ >= 4 && __GNUC_MINOR__ >= 2)
#    pragma GCC diagnostic warning "-Waddress"
#endif

SCM scm_init_sw_business_core_module (void);


static GncGUID gncTaxTableReturnGUID(GncTaxTable *x)
{ return (x ? *(qof_instance_get_guid(QOF_INSTANCE(x))) : *(guid_null())); }

static GncGUID gncInvoiceReturnGUID(GncInvoice *x)
{ return (x ? *(qof_instance_get_guid(QOF_INSTANCE(x))) : *(guid_null())); }

static GncGUID gncJobReturnGUID(GncJob *x)
{ return (x ? *(qof_instance_get_guid(QOF_INSTANCE(x))) : *(guid_null())); }

static GncGUID gncVendorReturnGUID(GncVendor *x)
{ return (x ? *(qof_instance_get_guid(QOF_INSTANCE(x))) : *(guid_null())); }

static GncGUID gncCustomerReturnGUID(GncCustomer *x)
{ return (x ? *(qof_instance_get_guid(QOF_INSTANCE(x))) : *(guid_null())); }

static GncGUID gncEmployeeReturnGUID(GncEmployee *x)
{ return (x ? *(qof_instance_get_guid(QOF_INSTANCE(x))) : *(guid_null())); }

static GncTaxTable * gncTaxTableLookupFlip(GncGUID g, QofBook *b)
{ return gncTaxTableLookup(b, &g); }

static GncInvoice * gncInvoiceLookupFlip(GncGUID g, QofBook *b)
{ return gncInvoiceLookup(b, &g); }

static GncJob * gncJobLookupFlip(GncGUID g, QofBook *b)
{ return gncJobLookup(b, &g); }

static GncVendor * gncVendorLookupFlip(GncGUID g, QofBook *b)
{ return gncVendorLookup(b, &g); }

static GncCustomer * gncCustomerLookupFlip(GncGUID g, QofBook *b)
{ return gncCustomerLookup(b, &g); }

static GncEmployee * gncEmployeeLookupFlip(GncGUID g, QofBook *b)
{ return gncEmployeeLookup(b, &g); }


static char *gswig_const_GNC_ADDRESS_MODULE_NAME = "gncAddress";
static char *gswig_const_GNC_ID_ADDRESS = "gncAddress";
static char *gswig_const_ADDRESS_NAME = "name";
static char *gswig_const_ADDRESS_ONE = "number";
static char *gswig_const_ADDRESS_TWO = "street";
static char *gswig_const_ADDRESS_THREE = "locality";
static char *gswig_const_ADDRESS_FOUR = "city";
static char *gswig_const_ADDRESS_PHONE = "phone";
static char *gswig_const_ADDRESS_FAX = "fax";
static char *gswig_const_ADDRESS_EMAIL = "email";
static char *gswig_const_ADDRESS_OWNER = "owner";
static char *gswig_const_GNC_ID_BILLTERM = "gncBillTerm";
static char *gswig_const_GNC_BILLTERM_NAME = "name";
static char *gswig_const_GNC_BILLTERM_DESC = "description";
static char *gswig_const_GNC_BILLTERM_DUEDAYS = "number of days due";
static char *gswig_const_GNC_BILLTERM_DISCDAYS = "number of discounted days";
static char *gswig_const_GNC_BILLTERM_CUTOFF = "cut off";
static char *gswig_const_GNC_BILLTERM_TYPE = "bill type";
static char *gswig_const_GNC_BILLTERM_DISCOUNT = "amount of discount";
static char *gswig_const_GNC_BILLTERM_REFCOUNT = "reference count";
static int gswig_const_GNC_TERM_TYPE_DAYS = GNC_TERM_TYPE_DAYS;
static int gswig_const_GNC_TERM_TYPE_PROXIMO = GNC_TERM_TYPE_PROXIMO;
static char *gswig_const_GNC_BILLTERM_MODULE_NAME = "gncBillTerm";
static char *gswig_const_GNC_ID_CUSTOMER = "gncCustomer";
static char *gswig_const_CUSTOMER_ID = "id";
static char *gswig_const_CUSTOMER_NAME = "name";
static char *gswig_const_CUSTOMER_ADDR = "addr";
static char *gswig_const_CUSTOMER_SHIPADDR = "shipaddr";
static char *gswig_const_CUSTOMER_NOTES = "notes";
static char *gswig_const_CUSTOMER_DISCOUNT = "amount of discount";
static char *gswig_const_CUSTOMER_CREDIT = "amount of credit";
static char *gswig_const_CUSTOMER_TT_OVER = "tax table override";
static char *gswig_const_CUSTOMER_TAX_INC = "customer_tax_included";
static char *gswig_const_CUSTOMER_TERMS = "customer_terms";
static char *gswig_const_CUSTOMER_ACTIVE = "customer_is_active";
static char *gswig_const_CUSTOMER_SLOTS = "customer_values";
static char *gswig_const_GNC_ID_EMPLOYEE = "gncEmployee";
static char *gswig_const_EMPLOYEE_ID = "id";
static char *gswig_const_EMPLOYEE_USERNAME = "username";
static char *gswig_const_EMPLOYEE_ADDR = "addr";
static char *gswig_const_EMPLOYEE_LANGUAGE = "native language";
static char *gswig_const_EMPLOYEE_ACL = "acl";
static char *gswig_const_EMPLOYEE_WORKDAY = "workday";
static char *gswig_const_EMPLOYEE_RATE = "rate";
static char *gswig_const_EMPLOYEE_CC = "credit_card_account";
static int gswig_const_GNC_PAYMENT_CASH = GNC_PAYMENT_CASH;
static int gswig_const_GNC_PAYMENT_CARD = GNC_PAYMENT_CARD;
static int gswig_const_GNC_DISC_PRETAX = GNC_DISC_PRETAX;
static int gswig_const_GNC_DISC_SAMETIME = GNC_DISC_SAMETIME;
static int gswig_const_GNC_DISC_POSTTAX = GNC_DISC_POSTTAX;
static char *gswig_const_GNC_ID_ENTRY = "gncEntry";
static char *gswig_const_ENTRY_DATE = "date";
static char *gswig_const_ENTRY_DATE_ENTERED = "date-entered";
static char *gswig_const_ENTRY_DESC = "desc";
static char *gswig_const_ENTRY_ACTION = "action";
static char *gswig_const_ENTRY_NOTES = "notes";
static char *gswig_const_ENTRY_QTY = "qty";
static char *gswig_const_ENTRY_IPRICE = "iprice";
static char *gswig_const_ENTRY_IACCT = "invoice-account";
static char *gswig_const_ENTRY_BACCT = "bill-account";
static char *gswig_const_ENTRY_BPRICE = "bprice";
static char *gswig_const_ENTRY_BILLABLE = "billable?";
static char *gswig_const_ENTRY_BILLTO = "bill-to";
static char *gswig_const_ENTRY_ORDER = "order";
static char *gswig_const_ENTRY_INVOICE = "invoice";
static char *gswig_const_ENTRY_BILL = "bill";
static char *gswig_const_ENTRY_INV_DISC_TYPE = "discount-type";
static char *gswig_const_ENTRY_INV_DISC_HOW = "discount-method";
static char *gswig_const_ENTRY_INV_TAXABLE = "invoice-taxable";
static char *gswig_const_ENTRY_BILL_TAXABLE = "bill-taxable";
static char *gswig_const_ENTRY_INV_TAX_INC = "invoice-tax-included";
static char *gswig_const_ENTRY_BILL_TAX_INC = "bill-tax-included";
static char *gswig_const_ENTRY_INV_DISCOUNT = "invoice-discount";
static char *gswig_const_ENTRY_BILL_PAY_TYPE = "bill-payment-type";
static char *gswig_const_GNC_ID_INVOICE = "gncInvoice";
static char *gswig_const_INVOICE_ID = "id";
static char *gswig_const_INVOICE_OWNER = "owner";
static char *gswig_const_INVOICE_OPENED = "date_opened";
static char *gswig_const_INVOICE_POSTED = "date_posted";
static char *gswig_const_INVOICE_DUE = "date_due";
static char *gswig_const_INVOICE_IS_POSTED = "is_posted?";
static char *gswig_const_INVOICE_IS_PAID = "is_paid?";
static char *gswig_const_INVOICE_TERMS = "terms";
static char *gswig_const_INVOICE_BILLINGID = "billing_id";
static char *gswig_const_INVOICE_NOTES = "notes";
static char *gswig_const_INVOICE_ACC = "account";
static char *gswig_const_INVOICE_POST_TXN = "posted_txn";
static char *gswig_const_INVOICE_POST_LOT = "posted_lot";
static char *gswig_const_INVOICE_TYPE = "type";
static char *gswig_const_INVOICE_BILLTO = "bill-to";
static char *gswig_const_INVOICE_ENTRIES = "list_of_entries";
static char *gswig_const_INVOICE_JOB = "invoice_job";
static char *gswig_const_INVOICE_FROM_LOT = "invoice-from-lot";
static char *gswig_const_INVOICE_FROM_TXN = "invoice-from-txn";
static char *gswig_const_GNC_ID_JOB = "gncJob";
static char *gswig_const_JOB_ID = "id";
static char *gswig_const_JOB_NAME = "name";
static char *gswig_const_JOB_REFERENCE = "reference";
static char *gswig_const_JOB_OWNER = "owner";
static char *gswig_const_Q_JOB_OWNER = "owner_collection";
static char *gswig_const_JOB_ACTIVE = "active";
static char *gswig_const_GNC_ID_ORDER = "gncOrder";
static char *gswig_const_ORDER_ID = "id";
static char *gswig_const_ORDER_REFERENCE = "reference";
static char *gswig_const_ORDER_OWNER = "owner";
static char *gswig_const_ORDER_OPENED = "date_opened";
static char *gswig_const_ORDER_CLOSED = "date_closed";
static char *gswig_const_ORDER_IS_CLOSED = "is_closed?";
static char *gswig_const_ORDER_NOTES = "notes";
static char *gswig_const_GNC_ID_OWNER = "gncOwner";
static int gswig_const_GNC_OWNER_NONE = GNC_OWNER_NONE;
static int gswig_const_GNC_OWNER_UNDEFINED = GNC_OWNER_UNDEFINED;
static int gswig_const_GNC_OWNER_CUSTOMER = GNC_OWNER_CUSTOMER;
static int gswig_const_GNC_OWNER_JOB = GNC_OWNER_JOB;
static int gswig_const_GNC_OWNER_VENDOR = GNC_OWNER_VENDOR;
static int gswig_const_GNC_OWNER_EMPLOYEE = GNC_OWNER_EMPLOYEE;
static char *gswig_const_OWNER_TYPE = "type";
static char *gswig_const_OWNER_TYPE_STRING = "type-string";
static char *gswig_const_OWNER_CUSTOMER = "customer";
static char *gswig_const_OWNER_JOB = "job";
static char *gswig_const_OWNER_VENDOR = "vendor";
static char *gswig_const_OWNER_EMPLOYEE = "employee";
static char *gswig_const_OWNER_PARENT = "parent";
static char *gswig_const_OWNER_PARENTG = "parent-guid";
static char *gswig_const_OWNER_NAME = "name";
static char *gswig_const_OWNER_FROM_LOT = "owner-from-lot";
static char *gswig_const_GNC_ID_TAXTABLE = "gncTaxTable";
static int gswig_const_GNC_AMT_TYPE_VALUE = GNC_AMT_TYPE_VALUE;
static int gswig_const_GNC_AMT_TYPE_PERCENT = GNC_AMT_TYPE_PERCENT;
static int gswig_const_GNC_TAXINCLUDED_YES = GNC_TAXINCLUDED_YES;
static int gswig_const_GNC_TAXINCLUDED_NO = GNC_TAXINCLUDED_NO;
static int gswig_const_GNC_TAXINCLUDED_USEGLOBAL = GNC_TAXINCLUDED_USEGLOBAL;
static char *gswig_const_GNC_TT_NAME = "tax table name";
static char *gswig_const_GNC_TT_REFCOUNT = "reference count";
static char *gswig_const_GNC_ID_VENDOR = "gncVendor";
static char *gswig_const_VENDOR_ID = "id";
static char *gswig_const_VENDOR_NAME = "name";
static char *gswig_const_VENDOR_ADDR = "addr";
static char *gswig_const_VENDOR_NOTES = "vendor_notes";
static char *gswig_const_VENDOR_TERMS = "vendor_terms";
static char *gswig_const_VENDOR_TAX_INC = "vendor_tax_included";
static char *gswig_const_VENDOR_ACTIVE = "vendor_is_active";
static char *gswig_const_VENDOR_TAX_OVERRIDE = "override_tax_table";
static char *gswig_const_VENDOR_TAX_TABLE = "vendor_tax_table";
static char *gswig_const_URL_TYPE_CUSTOMER = "gncCustomer";
static char *gswig_const_URL_TYPE_VENDOR = "gncVendor";
static char *gswig_const_URL_TYPE_EMPLOYEE = "gncEmployee";
static char *gswig_const_URL_TYPE_JOB = "gncJob";
static char *gswig_const_URL_TYPE_INVOICE = "gncInvoice";
static char *gswig_const_URL_TYPE_OWNERREPORT = "owner-report";

static QofQuery * qof_query_create_for_invoices(void) {
  return qof_query_create_for(GNC_ID_INVOICE);
}

static GncInvoiceList * qof_query_run_for_invoices(QofQuery *q) {
    return qof_query_run(q);
}

static SCM
_wrap_gncTaxTableReturnGUID (SCM s_0)
{
#define FUNC_NAME "gncTaxTableReturnGUID"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  GncGUID result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  result = gncTaxTableReturnGUID(arg1);
  gswig_result = gnc_guid2scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceReturnGUID (SCM s_0)
{
#define FUNC_NAME "gncInvoiceReturnGUID"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncGUID result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceReturnGUID(arg1);
  gswig_result = gnc_guid2scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobReturnGUID (SCM s_0)
{
#define FUNC_NAME "gncJobReturnGUID"
  GncJob *arg1 = (GncJob *) 0 ;
  GncGUID result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  result = gncJobReturnGUID(arg1);
  gswig_result = gnc_guid2scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorReturnGUID (SCM s_0)
{
#define FUNC_NAME "gncVendorReturnGUID"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncGUID result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = gncVendorReturnGUID(arg1);
  gswig_result = gnc_guid2scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerReturnGUID (SCM s_0)
{
#define FUNC_NAME "gncCustomerReturnGUID"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncGUID result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = gncCustomerReturnGUID(arg1);
  gswig_result = gnc_guid2scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeReturnGUID (SCM s_0)
{
#define FUNC_NAME "gncEmployeeReturnGUID"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  GncGUID result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = gncEmployeeReturnGUID(arg1);
  gswig_result = gnc_guid2scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableLookupFlip (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableLookupFlip"
  GncGUID arg1 ;
  QofBook *arg2 = (QofBook *) 0 ;
  GncTaxTable *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1 = gnc_scm2guid(s_0);
  {
    arg2 = (QofBook *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofBook, 2, 0);
  }
  result = (GncTaxTable *)gncTaxTableLookupFlip(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceLookupFlip (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceLookupFlip"
  GncGUID arg1 ;
  QofBook *arg2 = (QofBook *) 0 ;
  GncInvoice *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1 = gnc_scm2guid(s_0);
  {
    arg2 = (QofBook *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofBook, 2, 0);
  }
  result = (GncInvoice *)gncInvoiceLookupFlip(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncInvoice, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobLookupFlip (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobLookupFlip"
  GncGUID arg1 ;
  QofBook *arg2 = (QofBook *) 0 ;
  GncJob *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1 = gnc_scm2guid(s_0);
  {
    arg2 = (QofBook *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofBook, 2, 0);
  }
  result = (GncJob *)gncJobLookupFlip(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncJob, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorLookupFlip (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorLookupFlip"
  GncGUID arg1 ;
  QofBook *arg2 = (QofBook *) 0 ;
  GncVendor *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1 = gnc_scm2guid(s_0);
  {
    arg2 = (QofBook *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofBook, 2, 0);
  }
  result = (GncVendor *)gncVendorLookupFlip(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncVendor, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerLookupFlip (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerLookupFlip"
  GncGUID arg1 ;
  QofBook *arg2 = (QofBook *) 0 ;
  GncCustomer *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1 = gnc_scm2guid(s_0);
  {
    arg2 = (QofBook *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofBook, 2, 0);
  }
  result = (GncCustomer *)gncCustomerLookupFlip(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncCustomer, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeLookupFlip (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeLookupFlip"
  GncGUID arg1 ;
  QofBook *arg2 = (QofBook *) 0 ;
  GncEmployee *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1 = gnc_scm2guid(s_0);
  {
    arg2 = (QofBook *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofBook, 2, 0);
  }
  result = (GncEmployee *)gncEmployeeLookupFlip(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncEmployee, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ADDRESS_MODULE_NAME(SCM s_0)
{
#define FUNC_NAME "GNC-ADDRESS-MODULE-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ADDRESS_MODULE_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_ADDRESS(SCM s_0)
{
#define FUNC_NAME "GNC-ID-ADDRESS"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_ADDRESS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_address_get_type ()
{
#define FUNC_NAME "gnc-address-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_address_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressCreate (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  QofInstance *arg2 = (QofInstance *) 0 ;
  GncAddress *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  {
    arg2 = (QofInstance *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofInstance, 2, 0);
  }
  result = (GncAddress *)gncAddressCreate(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncAddress, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressDestroy (SCM s_0)
{
#define FUNC_NAME "gncAddressDestroy"
  GncAddress *arg1 = (GncAddress *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  gncAddressDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncAddressBeginEdit"
  GncAddress *arg1 = (GncAddress *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  gncAddressBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncAddressCommitEdit"
  GncAddress *arg1 = (GncAddress *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  gncAddressCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressSetName (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressSetName"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncAddressSetName(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressSetAddr1 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressSetAddr1"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncAddressSetAddr1(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressSetAddr2 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressSetAddr2"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncAddressSetAddr2(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressSetAddr3 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressSetAddr3"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncAddressSetAddr3(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressSetAddr4 (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressSetAddr4"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncAddressSetAddr4(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressSetPhone (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressSetPhone"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncAddressSetPhone(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressSetFax (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressSetFax"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncAddressSetFax(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressSetEmail (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressSetEmail"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncAddressSetEmail(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressClearDirty (SCM s_0)
{
#define FUNC_NAME "gncAddressClearDirty"
  GncAddress *arg1 = (GncAddress *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  gncAddressClearDirty(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressGetName (SCM s_0)
{
#define FUNC_NAME "gncAddressGetName"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = (char *)gncAddressGetName((struct _gncAddress const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressGetAddr1 (SCM s_0)
{
#define FUNC_NAME "gncAddressGetAddr1"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = (char *)gncAddressGetAddr1((struct _gncAddress const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressGetAddr2 (SCM s_0)
{
#define FUNC_NAME "gncAddressGetAddr2"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = (char *)gncAddressGetAddr2((struct _gncAddress const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressGetAddr3 (SCM s_0)
{
#define FUNC_NAME "gncAddressGetAddr3"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = (char *)gncAddressGetAddr3((struct _gncAddress const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressGetAddr4 (SCM s_0)
{
#define FUNC_NAME "gncAddressGetAddr4"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = (char *)gncAddressGetAddr4((struct _gncAddress const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressGetPhone (SCM s_0)
{
#define FUNC_NAME "gncAddressGetPhone"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = (char *)gncAddressGetPhone((struct _gncAddress const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressGetFax (SCM s_0)
{
#define FUNC_NAME "gncAddressGetFax"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = (char *)gncAddressGetFax((struct _gncAddress const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressGetEmail (SCM s_0)
{
#define FUNC_NAME "gncAddressGetEmail"
  GncAddress *arg1 = (GncAddress *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = (char *)gncAddressGetEmail((struct _gncAddress const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressIsDirty (SCM s_0)
{
#define FUNC_NAME "gncAddressIsDirty"
  GncAddress *arg1 = (GncAddress *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  result = gncAddressIsDirty((struct _gncAddress const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressCompare"
  GncAddress *arg1 = (GncAddress *) 0 ;
  GncAddress *arg2 = (GncAddress *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (GncAddress *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncAddress, 2, 0);
  }
  result = (int)gncAddressCompare((struct _gncAddress const *)arg1,(struct _gncAddress const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAddressEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAddressEqual"
  GncAddress *arg1 = (GncAddress *) 0 ;
  GncAddress *arg2 = (GncAddress *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAddress *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAddress, 1, 0);
  }
  {
    arg2 = (GncAddress *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncAddress, 2, 0);
  }
  result = gncAddressEqual((struct _gncAddress const *)arg1,(struct _gncAddress const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_NAME(SCM s_0)
{
#define FUNC_NAME "ADDRESS-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_ONE(SCM s_0)
{
#define FUNC_NAME "ADDRESS-ONE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_ONE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_TWO(SCM s_0)
{
#define FUNC_NAME "ADDRESS-TWO"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_TWO);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_THREE(SCM s_0)
{
#define FUNC_NAME "ADDRESS-THREE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_THREE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_FOUR(SCM s_0)
{
#define FUNC_NAME "ADDRESS-FOUR"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_FOUR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_PHONE(SCM s_0)
{
#define FUNC_NAME "ADDRESS-PHONE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_PHONE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_FAX(SCM s_0)
{
#define FUNC_NAME "ADDRESS-FAX"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_FAX);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_EMAIL(SCM s_0)
{
#define FUNC_NAME "ADDRESS-EMAIL"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_EMAIL);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ADDRESS_OWNER(SCM s_0)
{
#define FUNC_NAME "ADDRESS-OWNER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ADDRESS_OWNER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_BILLTERM(SCM s_0)
{
#define FUNC_NAME "GNC-ID-BILLTERM"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_BILLTERM);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_billterm_get_type ()
{
#define FUNC_NAME "gnc-billterm-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_billterm_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_NAME(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_DESC(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-DESC"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_DESC);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_DUEDAYS(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-DUEDAYS"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_DUEDAYS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_DISCDAYS(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-DISCDAYS"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_DISCDAYS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_CUTOFF(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-CUTOFF"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_CUTOFF);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_TYPE(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-TYPE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_TYPE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_DISCOUNT(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-DISCOUNT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_DISCOUNT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_REFCOUNT(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-REFCOUNT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_REFCOUNT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_TERM_TYPE_DAYS(SCM s_0)
{
#define FUNC_NAME "GNC-TERM-TYPE-DAYS"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_TERM_TYPE_DAYS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_TERM_TYPE_PROXIMO(SCM s_0)
{
#define FUNC_NAME "GNC-TERM-TYPE-PROXIMO"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_TERM_TYPE_PROXIMO);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermCreate (SCM s_0)
{
#define FUNC_NAME "gncBillTermCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncBillTerm *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncBillTerm *)gncBillTermCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncBillTerm, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermDestroy (SCM s_0)
{
#define FUNC_NAME "gncBillTermDestroy"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  gncBillTermDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermIncRef (SCM s_0)
{
#define FUNC_NAME "gncBillTermIncRef"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  gncBillTermIncRef(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermDecRef (SCM s_0)
{
#define FUNC_NAME "gncBillTermDecRef"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  gncBillTermDecRef(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermChanged (SCM s_0)
{
#define FUNC_NAME "gncBillTermChanged"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  gncBillTermChanged(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncBillTermBeginEdit"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  gncBillTermBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncBillTermCommitEdit"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  gncBillTermCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermSetName (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermSetName"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncBillTermSetName(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermSetDescription (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermSetDescription"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncBillTermSetDescription(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermSetType (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermSetType"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  GncBillTermType arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  {
    arg2 = (GncBillTermType) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  gncBillTermSetType(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermSetDueDays (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermSetDueDays"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gint arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  {
    arg2 = scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  gncBillTermSetDueDays(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermSetDiscountDays (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermSetDiscountDays"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gint arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  {
    arg2 = scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  gncBillTermSetDiscountDays(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermSetDiscount (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermSetDiscount"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncBillTermSetDiscount(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermSetCutoff (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermSetCutoff"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gint arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  {
    arg2 = scm_num2int(s_1, SCM_ARG1, FUNC_NAME);
  }
  gncBillTermSetCutoff(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncBillTerm *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncBillTerm *)gncBillTermLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncBillTerm, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermLookupByName (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermLookupByName"
  QofBook *arg1 = (QofBook *) 0 ;
  char *arg2 = (char *) 0 ;
  GncBillTerm *result = 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  result = (GncBillTerm *)gncBillTermLookupByName(arg1,(char const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncBillTerm, 0);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetTerms (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetTerms"
  QofBook *arg1 = (QofBook *) 0 ;
  GList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GList *)gncBillTermGetTerms(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetName (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetName"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = (char *)gncBillTermGetName((struct _gncBillTerm const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetDescription (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetDescription"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = (char *)gncBillTermGetDescription((struct _gncBillTerm const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetType (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetType"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  GncBillTermType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = (GncBillTermType)gncBillTermGetType((struct _gncBillTerm const *)arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetDueDays (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetDueDays"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gint result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = (gint)gncBillTermGetDueDays((struct _gncBillTerm const *)arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetDiscountDays (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetDiscountDays"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gint result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = (gint)gncBillTermGetDiscountDays((struct _gncBillTerm const *)arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetDiscount (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetDiscount"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = gncBillTermGetDiscount((struct _gncBillTerm const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetCutoff (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetCutoff"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gint result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = (gint)gncBillTermGetCutoff((struct _gncBillTerm const *)arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermIsDirty (SCM s_0)
{
#define FUNC_NAME "gncBillTermIsDirty"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = gncBillTermIsDirty((struct _gncBillTerm const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetParent (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetParent"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  GncBillTerm *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = (GncBillTerm *)gncBillTermGetParent((struct _gncBillTerm const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncBillTerm, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermReturnChild (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermReturnChild"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gboolean arg2 ;
  GncBillTerm *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = (GncBillTerm *)gncBillTermReturnChild(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncBillTerm, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermGetRefcount (SCM s_0)
{
#define FUNC_NAME "gncBillTermGetRefcount"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  gint64 result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  result = gncBillTermGetRefcount((struct _gncBillTerm const *)arg1);
  gswig_result = gnc_gint64_to_scm(result); 
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermCompare"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  GncBillTerm *arg2 = (GncBillTerm *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  {
    arg2 = (GncBillTerm *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncBillTerm, 2, 0);
  }
  result = (int)gncBillTermCompare((struct _gncBillTerm const *)arg1,(struct _gncBillTerm const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermEqual"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  GncBillTerm *arg2 = (GncBillTerm *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  {
    arg2 = (GncBillTerm *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncBillTerm, 2, 0);
  }
  result = gncBillTermEqual((struct _gncBillTerm const *)arg1,(struct _gncBillTerm const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermComputeDueDate (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermComputeDueDate"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  Timespec arg2 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  arg2 = gnc_timepair2timespec(s_1);
  result = gncBillTermComputeDueDate((struct _gncBillTerm const *)arg1,arg2);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillTermComputeDiscountDate (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillTermComputeDiscountDate"
  GncBillTerm *arg1 = (GncBillTerm *) 0 ;
  Timespec arg2 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncBillTerm *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncBillTerm, 1, 0);
  }
  arg2 = gnc_timepair2timespec(s_1);
  result = gncBillTermComputeDiscountDate((struct _gncBillTerm const *)arg1,arg2);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_BILLTERM_MODULE_NAME(SCM s_0)
{
#define FUNC_NAME "GNC-BILLTERM-MODULE-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_BILLTERM_MODULE_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBusinessGetList (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "gncBusinessGetList"
  QofBook *arg1 = (QofBook *) 0 ;
  QofIdTypeConst arg2 ;
  gboolean arg3 ;
  GList *result = 0 ;
  QofIdTypeConst *argp2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  {
    argp2 = (QofIdTypeConst *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofIdTypeConst, 2, 0);
    arg2 = *argp2;
  }
  arg3 = scm_is_true(s_2) ? TRUE : FALSE;
  result = (GList *)gncBusinessGetList(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBusinessGetOwnerList (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "gncBusinessGetOwnerList"
  QofBook *arg1 = (QofBook *) 0 ;
  QofIdTypeConst arg2 ;
  gboolean arg3 ;
  OwnerList *result = 0 ;
  QofIdTypeConst *argp2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  {
    argp2 = (QofIdTypeConst *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofIdTypeConst, 2, 0);
    arg2 = *argp2;
  }
  arg3 = scm_is_true(s_2) ? TRUE : FALSE;
  result = (OwnerList *)gncBusinessGetOwnerList(arg1,arg2,arg3);
  {
    SCM list = SCM_EOL;
    GList *node;
    
    for (node = result; node; node = node->next)
    list = scm_cons(SWIG_NewPointerObj(node->data,
        SWIGTYPE_p__gncOwner, 0), list);
    
    gswig_result = scm_reverse(list);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_CUSTOMER(SCM s_0)
{
#define FUNC_NAME "GNC-ID-CUSTOMER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_CUSTOMER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_customer_get_type ()
{
#define FUNC_NAME "gnc-customer-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_customer_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerCreate (SCM s_0)
{
#define FUNC_NAME "gncCustomerCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncCustomer *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncCustomer *)gncCustomerCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncCustomer, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerDestroy (SCM s_0)
{
#define FUNC_NAME "gncCustomerDestroy"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  gncCustomerDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncCustomerBeginEdit"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  gncCustomerBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncCustomerCommitEdit"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  gncCustomerCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetID (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetID"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncCustomerSetID(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetName (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetName"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncCustomerSetName(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetNotes (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetNotes"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncCustomerSetNotes(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetTerms (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetTerms"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncBillTerm *arg2 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (GncBillTerm *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncBillTerm, 2, 0);
  }
  gncCustomerSetTerms(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetTaxIncluded (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetTaxIncluded"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncTaxIncluded arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (GncTaxIncluded) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  gncCustomerSetTaxIncluded(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetActive (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetActive"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncCustomerSetActive(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetDiscount (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetDiscount"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncCustomerSetDiscount(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetCredit (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetCredit"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncCustomerSetCredit(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetCurrency (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetCurrency"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gnc_commodity *arg2 = (gnc_commodity *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (gnc_commodity *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_gnc_commodity, 2, 0);
  }
  gncCustomerSetCurrency(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetTaxTableOverride (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetTaxTableOverride"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncCustomerSetTaxTableOverride(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerSetTaxTable (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerSetTaxTable"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncTaxTable *arg2 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (GncTaxTable *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTable, 2, 0);
  }
  gncCustomerSetTaxTable(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerAddJob (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerAddJob"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncJob *arg2 = (GncJob *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (GncJob *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncJob, 2, 0);
  }
  gncCustomerAddJob(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerRemoveJob (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerRemoveJob"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncJob *arg2 = (GncJob *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (GncJob *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncJob, 2, 0);
  }
  gncCustomerRemoveJob(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncCustomer *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncCustomer *)gncCustomerLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncCustomer, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetID (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetID"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (char *)gncCustomerGetID((struct _gncCustomer const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetName (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetName"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (char *)gncCustomerGetName((struct _gncCustomer const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetAddr (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetAddr"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncAddress *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (GncAddress *)gncCustomerGetAddr((struct _gncCustomer const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncAddress, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetShipAddr (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetShipAddr"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncAddress *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (GncAddress *)gncCustomerGetShipAddr((struct _gncCustomer const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncAddress, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetNotes (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetNotes"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (char *)gncCustomerGetNotes((struct _gncCustomer const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetTerms (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetTerms"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncBillTerm *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (GncBillTerm *)gncCustomerGetTerms((struct _gncCustomer const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncBillTerm, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetTaxIncluded (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetTaxIncluded"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncTaxIncluded result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (GncTaxIncluded)gncCustomerGetTaxIncluded((struct _gncCustomer const *)arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetActive (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetActive"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = gncCustomerGetActive((struct _gncCustomer const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetDiscount (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetDiscount"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = gncCustomerGetDiscount((struct _gncCustomer const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetCredit (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetCredit"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = gncCustomerGetCredit((struct _gncCustomer const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetCurrency (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetCurrency"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gnc_commodity *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (gnc_commodity *)gncCustomerGetCurrency((struct _gncCustomer const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_gnc_commodity, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetTaxTableOverride (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetTaxTableOverride"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = gncCustomerGetTaxTableOverride((struct _gncCustomer const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetTaxTable (SCM s_0)
{
#define FUNC_NAME "gncCustomerGetTaxTable"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncTaxTable *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = (GncTaxTable *)gncCustomerGetTaxTable((struct _gncCustomer const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerGetJoblist (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerGetJoblist"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gboolean arg2 ;
  GList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = (GList *)gncCustomerGetJoblist((struct _gncCustomer const *)arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerIsDirty (SCM s_0)
{
#define FUNC_NAME "gncCustomerIsDirty"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  result = gncCustomerIsDirty(arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerCompare"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncCustomer *arg2 = (GncCustomer *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (GncCustomer *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncCustomer, 2, 0);
  }
  result = (int)gncCustomerCompare((struct _gncCustomer const *)arg1,(struct _gncCustomer const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncCustomerEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncCustomerEqual"
  GncCustomer *arg1 = (GncCustomer *) 0 ;
  GncCustomer *arg2 = (GncCustomer *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncCustomer *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncCustomer, 1, 0);
  }
  {
    arg2 = (GncCustomer *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncCustomer, 2, 0);
  }
  result = gncCustomerEqual((struct _gncCustomer const *)arg1,(struct _gncCustomer const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_ID(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-ID"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_ID);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_NAME(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_ADDR(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-ADDR"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_ADDR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_SHIPADDR(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-SHIPADDR"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_SHIPADDR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_NOTES(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-NOTES"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_NOTES);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_DISCOUNT(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-DISCOUNT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_DISCOUNT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_CREDIT(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-CREDIT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_CREDIT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_TT_OVER(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-TT-OVER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_TT_OVER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_TAX_INC(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-TAX-INC"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_TAX_INC);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_TERMS(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-TERMS"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_TERMS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_ACTIVE(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-ACTIVE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_ACTIVE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_CUSTOMER_SLOTS(SCM s_0)
{
#define FUNC_NAME "CUSTOMER-SLOTS"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_CUSTOMER_SLOTS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_EMPLOYEE(SCM s_0)
{
#define FUNC_NAME "GNC-ID-EMPLOYEE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_EMPLOYEE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_employee_get_type ()
{
#define FUNC_NAME "gnc-employee-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_employee_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeCreate (SCM s_0)
{
#define FUNC_NAME "gncEmployeeCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncEmployee *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncEmployee *)gncEmployeeCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncEmployee, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeDestroy (SCM s_0)
{
#define FUNC_NAME "gncEmployeeDestroy"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  gncEmployeeDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncEmployeeBeginEdit"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  gncEmployeeBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncEmployeeCommitEdit"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  gncEmployeeCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeCompare"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  GncEmployee *arg2 = (GncEmployee *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (GncEmployee *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEmployee, 2, 0);
  }
  result = (int)gncEmployeeCompare((struct _gncEmployee const *)arg1,(struct _gncEmployee const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetID (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetID"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncEmployeeSetID(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetUsername (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetUsername"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncEmployeeSetUsername(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetLanguage (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetLanguage"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncEmployeeSetLanguage(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetAcl (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetAcl"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncEmployeeSetAcl(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetWorkday (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetWorkday"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncEmployeeSetWorkday(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetRate (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetRate"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncEmployeeSetRate(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetCurrency (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetCurrency"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gnc_commodity *arg2 = (gnc_commodity *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (gnc_commodity *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_gnc_commodity, 2, 0);
  }
  gncEmployeeSetCurrency(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetActive (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetActive"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncEmployeeSetActive(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeSetCCard (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeSetCCard"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  Account *arg2 = (Account *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (Account *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Account, 2, 0);
  }
  gncEmployeeSetCCard(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qofEmployeeSetAddr (SCM s_0, SCM s_1)
{
#define FUNC_NAME "qofEmployeeSetAddr"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  QofInstance *arg2 = (QofInstance *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (QofInstance *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofInstance, 2, 0);
  }
  qofEmployeeSetAddr(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetBook (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetBook"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  QofBook *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = (QofBook *)gncEmployeeGetBook(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_QofBook, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetID (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetID"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = (char *)gncEmployeeGetID((struct _gncEmployee const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetUsername (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetUsername"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = (char *)gncEmployeeGetUsername((struct _gncEmployee const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetAddr (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetAddr"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  GncAddress *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = (GncAddress *)gncEmployeeGetAddr((struct _gncEmployee const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncAddress, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetLanguage (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetLanguage"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = (char *)gncEmployeeGetLanguage((struct _gncEmployee const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetAcl (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetAcl"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = (char *)gncEmployeeGetAcl((struct _gncEmployee const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetWorkday (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetWorkday"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = gncEmployeeGetWorkday((struct _gncEmployee const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetRate (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetRate"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = gncEmployeeGetRate((struct _gncEmployee const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetCurrency (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetCurrency"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gnc_commodity *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = (gnc_commodity *)gncEmployeeGetCurrency((struct _gncEmployee const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_gnc_commodity, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetActive (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetActive"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = gncEmployeeGetActive((struct _gncEmployee const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeGetCCard (SCM s_0)
{
#define FUNC_NAME "gncEmployeeGetCCard"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  Account *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = (Account *)gncEmployeeGetCCard((struct _gncEmployee const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Account, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncEmployee *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncEmployee *)gncEmployeeLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncEmployee, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeIsDirty (SCM s_0)
{
#define FUNC_NAME "gncEmployeeIsDirty"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  result = gncEmployeeIsDirty((struct _gncEmployee const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEmployeeEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEmployeeEqual"
  GncEmployee *arg1 = (GncEmployee *) 0 ;
  GncEmployee *arg2 = (GncEmployee *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEmployee *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEmployee, 1, 0);
  }
  {
    arg2 = (GncEmployee *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEmployee, 2, 0);
  }
  result = gncEmployeeEqual((struct _gncEmployee const *)arg1,(struct _gncEmployee const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_EMPLOYEE_ID(SCM s_0)
{
#define FUNC_NAME "EMPLOYEE-ID"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_EMPLOYEE_ID);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_EMPLOYEE_USERNAME(SCM s_0)
{
#define FUNC_NAME "EMPLOYEE-USERNAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_EMPLOYEE_USERNAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_EMPLOYEE_ADDR(SCM s_0)
{
#define FUNC_NAME "EMPLOYEE-ADDR"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_EMPLOYEE_ADDR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_EMPLOYEE_LANGUAGE(SCM s_0)
{
#define FUNC_NAME "EMPLOYEE-LANGUAGE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_EMPLOYEE_LANGUAGE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_EMPLOYEE_ACL(SCM s_0)
{
#define FUNC_NAME "EMPLOYEE-ACL"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_EMPLOYEE_ACL);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_EMPLOYEE_WORKDAY(SCM s_0)
{
#define FUNC_NAME "EMPLOYEE-WORKDAY"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_EMPLOYEE_WORKDAY);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_EMPLOYEE_RATE(SCM s_0)
{
#define FUNC_NAME "EMPLOYEE-RATE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_EMPLOYEE_RATE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_EMPLOYEE_CC(SCM s_0)
{
#define FUNC_NAME "EMPLOYEE-CC"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_EMPLOYEE_CC);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_PAYMENT_CASH(SCM s_0)
{
#define FUNC_NAME "GNC-PAYMENT-CASH"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_PAYMENT_CASH);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_PAYMENT_CARD(SCM s_0)
{
#define FUNC_NAME "GNC-PAYMENT-CARD"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_PAYMENT_CARD);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_DISC_PRETAX(SCM s_0)
{
#define FUNC_NAME "GNC-DISC-PRETAX"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_DISC_PRETAX);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_DISC_SAMETIME(SCM s_0)
{
#define FUNC_NAME "GNC-DISC-SAMETIME"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_DISC_SAMETIME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_DISC_POSTTAX(SCM s_0)
{
#define FUNC_NAME "GNC-DISC-POSTTAX"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_DISC_POSTTAX);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_ENTRY(SCM s_0)
{
#define FUNC_NAME "GNC-ID-ENTRY"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_ENTRY);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_entry_get_type ()
{
#define FUNC_NAME "gnc-entry-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_entry_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryDiscountHowToString (SCM s_0)
{
#define FUNC_NAME "gncEntryDiscountHowToString"
  GncDiscountHow arg1 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncDiscountHow) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)gncEntryDiscountHowToString(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryDiscountStringToHow (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryDiscountStringToHow"
  char *arg1 = (char *) 0 ;
  GncDiscountHow *arg2 = (GncDiscountHow *) 0 ;
  gboolean result;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (char *)SWIG_scm2str(s_0);
    must_free1 = 1;
  }
  {
    arg2 = (GncDiscountHow *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GncDiscountHow, 2, 0);
  }
  result = gncEntryDiscountStringToHow((char const *)arg1,arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  if (must_free1 && arg1) SWIG_free(arg1);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryPaymentTypeToString (SCM s_0)
{
#define FUNC_NAME "gncEntryPaymentTypeToString"
  GncEntryPaymentType arg1 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntryPaymentType) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)gncEntryPaymentTypeToString(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryPaymentStringToType (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryPaymentStringToType"
  char *arg1 = (char *) 0 ;
  GncEntryPaymentType *arg2 = (GncEntryPaymentType *) 0 ;
  gboolean result;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (char *)SWIG_scm2str(s_0);
    must_free1 = 1;
  }
  {
    arg2 = (GncEntryPaymentType *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GncEntryPaymentType, 2, 0);
  }
  result = gncEntryPaymentStringToType((char const *)arg1,arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  if (must_free1 && arg1) SWIG_free(arg1);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryCreate (SCM s_0)
{
#define FUNC_NAME "gncEntryCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncEntry *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncEntry *)gncEntryCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncEntry, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryDestroy (SCM s_0)
{
#define FUNC_NAME "gncEntryDestroy"
  GncEntry *arg1 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  gncEntryDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetDate (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetDate"
  GncEntry *arg1 = (GncEntry *) 0 ;
  Timespec arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = gnc_timepair2timespec(s_1);
  gncEntrySetDate(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetDateEntered (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetDateEntered"
  GncEntry *arg1 = (GncEntry *) 0 ;
  Timespec arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = gnc_timepair2timespec(s_1);
  gncEntrySetDateEntered(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetDescription (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetDescription"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncEntrySetDescription(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetAction (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetAction"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncEntrySetAction(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetNotes (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetNotes"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncEntrySetNotes(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetQuantity (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetQuantity"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncEntrySetQuantity(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetInvAccount (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetInvAccount"
  GncEntry *arg1 = (GncEntry *) 0 ;
  Account *arg2 = (Account *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (Account *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Account, 2, 0);
  }
  gncEntrySetInvAccount(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetInvPrice (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetInvPrice"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncEntrySetInvPrice(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetInvTaxable (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetInvTaxable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncEntrySetInvTaxable(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetInvTaxIncluded (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetInvTaxIncluded"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncEntrySetInvTaxIncluded(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetInvTaxTable (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetInvTaxTable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncTaxTable *arg2 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncTaxTable *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTable, 2, 0);
  }
  gncEntrySetInvTaxTable(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetInvDiscount (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetInvDiscount"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncEntrySetInvDiscount(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetInvDiscountType (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetInvDiscountType"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncAmountType arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncAmountType) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  gncEntrySetInvDiscountType(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetInvDiscountHow (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetInvDiscountHow"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncDiscountHow arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncDiscountHow) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  gncEntrySetInvDiscountHow(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qofEntrySetInvDiscType (SCM s_0, SCM s_1)
{
#define FUNC_NAME "qofEntrySetInvDiscType"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  qofEntrySetInvDiscType(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qofEntrySetInvDiscHow (SCM s_0, SCM s_1)
{
#define FUNC_NAME "qofEntrySetInvDiscHow"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  qofEntrySetInvDiscHow(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetBillAccount (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetBillAccount"
  GncEntry *arg1 = (GncEntry *) 0 ;
  Account *arg2 = (Account *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (Account *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Account, 2, 0);
  }
  gncEntrySetBillAccount(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetBillPrice (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetBillPrice"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncEntrySetBillPrice(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetBillTaxable (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetBillTaxable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncEntrySetBillTaxable(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetBillTaxIncluded (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetBillTaxIncluded"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncEntrySetBillTaxIncluded(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetBillTaxTable (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetBillTaxTable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncTaxTable *arg2 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncTaxTable *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTable, 2, 0);
  }
  gncEntrySetBillTaxTable(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetBillable (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetBillable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncEntrySetBillable(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetBillTo (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetBillTo"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  gncEntrySetBillTo(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntrySetBillPayment (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntrySetBillPayment"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncEntryPaymentType arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncEntryPaymentType) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  gncEntrySetBillPayment(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetDate (SCM s_0)
{
#define FUNC_NAME "gncEntryGetDate"
  GncEntry *arg1 = (GncEntry *) 0 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetDate((struct _gncEntry const *)arg1);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetDateEntered (SCM s_0)
{
#define FUNC_NAME "gncEntryGetDateEntered"
  GncEntry *arg1 = (GncEntry *) 0 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetDateEntered((struct _gncEntry const *)arg1);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetDescription (SCM s_0)
{
#define FUNC_NAME "gncEntryGetDescription"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (char *)gncEntryGetDescription((struct _gncEntry const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetAction (SCM s_0)
{
#define FUNC_NAME "gncEntryGetAction"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (char *)gncEntryGetAction((struct _gncEntry const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetNotes (SCM s_0)
{
#define FUNC_NAME "gncEntryGetNotes"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (char *)gncEntryGetNotes((struct _gncEntry const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetQuantity (SCM s_0)
{
#define FUNC_NAME "gncEntryGetQuantity"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetQuantity((struct _gncEntry const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvAccount (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvAccount"
  GncEntry *arg1 = (GncEntry *) 0 ;
  Account *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (Account *)gncEntryGetInvAccount((struct _gncEntry const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Account, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvPrice (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvPrice"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetInvPrice((struct _gncEntry const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvDiscount (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvDiscount"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetInvDiscount((struct _gncEntry const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvDiscountType (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvDiscountType"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncAmountType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncAmountType)gncEntryGetInvDiscountType((struct _gncEntry const *)arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvDiscountHow (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvDiscountHow"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncDiscountHow result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncDiscountHow)gncEntryGetInvDiscountHow((struct _gncEntry const *)arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qofEntryGetInvDiscType (SCM s_0)
{
#define FUNC_NAME "qofEntryGetInvDiscType"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (char *)qofEntryGetInvDiscType((struct _gncEntry const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qofEntryGetInvDiscHow (SCM s_0)
{
#define FUNC_NAME "qofEntryGetInvDiscHow"
  GncEntry *arg1 = (GncEntry *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (char *)qofEntryGetInvDiscHow((struct _gncEntry const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvTaxable (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvTaxable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetInvTaxable((struct _gncEntry const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvTaxIncluded (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvTaxIncluded"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetInvTaxIncluded((struct _gncEntry const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvTaxTable (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvTaxTable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncTaxTable *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncTaxTable *)gncEntryGetInvTaxTable((struct _gncEntry const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBillAccount (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBillAccount"
  GncEntry *arg1 = (GncEntry *) 0 ;
  Account *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (Account *)gncEntryGetBillAccount((struct _gncEntry const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Account, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBillPrice (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBillPrice"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetBillPrice((struct _gncEntry const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBillTaxable (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBillTaxable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetBillTaxable((struct _gncEntry const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBillTaxIncluded (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBillTaxIncluded"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetBillTaxIncluded((struct _gncEntry const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBillTaxTable (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBillTaxTable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncTaxTable *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncTaxTable *)gncEntryGetBillTaxTable((struct _gncEntry const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBillable (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBillable"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryGetBillable((struct _gncEntry const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBillTo (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBillTo"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncOwner *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncOwner *)gncEntryGetBillTo(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOwner, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBillPayment (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBillPayment"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncEntryPaymentType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncEntryPaymentType)gncEntryGetBillPayment((struct _gncEntry const *)arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryCopy (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryCopy"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  gncEntryCopy((struct _gncEntry const *)arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryReturnValue (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryReturnValue"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = gncEntryReturnValue(arg1,arg2);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryReturnDiscountValue (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryReturnDiscountValue"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = gncEntryReturnDiscountValue(arg1,arg2);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryReturnTaxValue (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryReturnTaxValue"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = gncEntryReturnTaxValue(arg1,arg2);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryReturnTaxValues (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryReturnTaxValues"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  AccountValueList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = (AccountValueList *)gncEntryReturnTaxValues(arg1,arg2);
  {
    SCM list = SCM_EOL;
    GList *node;
    
    for (node = result; node; node = node->next)
    list = scm_cons(gnc_account_value_ptr_to_scm(node->data), list);
    
    gswig_result = scm_reverse(list);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetValue (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5)
{
#define FUNC_NAME "gncEntryGetValue"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean arg2 ;
  gnc_numeric *arg3 = (gnc_numeric *) 0 ;
  gnc_numeric *arg4 = (gnc_numeric *) 0 ;
  gnc_numeric *arg5 = (gnc_numeric *) 0 ;
  GList **arg6 = (GList **) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  {
    arg3 = (gnc_numeric *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_gnc_numeric, 3, 0);
  }
  {
    arg4 = (gnc_numeric *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_gnc_numeric, 4, 0);
  }
  {
    arg5 = (gnc_numeric *)SWIG_MustGetPtr(s_4, SWIGTYPE_p_gnc_numeric, 5, 0);
  }
  {
    arg6 = (GList **)SWIG_MustGetPtr(s_5, SWIGTYPE_p_p_GList, 6, 0);
  }
  gncEntryGetValue(arg1,arg2,arg3,arg4,arg5,arg6);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryComputeValue (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5, SCM s_6, SCM s_7, SCM s_8, SCM s_9, SCM s_10)
{
#define FUNC_NAME "gncEntryComputeValue"
  gnc_numeric arg1 ;
  gnc_numeric arg2 ;
  GncTaxTable *arg3 = (GncTaxTable *) 0 ;
  gboolean arg4 ;
  gnc_numeric arg5 ;
  GncAmountType arg6 ;
  GncDiscountHow arg7 ;
  int arg8 ;
  gnc_numeric *arg9 = (gnc_numeric *) 0 ;
  gnc_numeric *arg10 = (gnc_numeric *) 0 ;
  GList **arg11 = (GList **) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1 = gnc_scm_to_numeric(s_0);
  arg2 = gnc_scm_to_numeric(s_1);
  {
    arg3 = (GncTaxTable *)SWIG_MustGetPtr(s_2, SWIGTYPE_p__gncTaxTable, 3, 0);
  }
  arg4 = scm_is_true(s_3) ? TRUE : FALSE;
  arg5 = gnc_scm_to_numeric(s_4);
  {
    arg6 = (GncAmountType) scm_num2int(s_5, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg7 = (GncDiscountHow) scm_num2int(s_6, SCM_ARG1, FUNC_NAME); 
  }
  {
    arg8 = scm_num2int(s_7, SCM_ARG1, FUNC_NAME);
  }
  {
    arg9 = (gnc_numeric *)SWIG_MustGetPtr(s_8, SWIGTYPE_p_gnc_numeric, 9, 0);
  }
  {
    arg10 = (gnc_numeric *)SWIG_MustGetPtr(s_9, SWIGTYPE_p_gnc_numeric, 10, 0);
  }
  {
    arg11 = (GList **)SWIG_MustGetPtr(s_10, SWIGTYPE_p_p_GList, 11, 0);
  }
  gncEntryComputeValue(arg1,arg2,(struct _gncTaxTable const *)arg3,arg4,arg5,arg6,arg7,arg8,arg9,arg10,arg11);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryComputeValue_rest (SCM rest)
{
SCM arg[11];
SWIG_Guile_GetArgs (arg, rest, 11, 0, "gncEntryComputeValue");
return _wrap_gncEntryComputeValue(arg[0], arg[1], arg[2], arg[3], arg[4], arg[5], arg[6], arg[7], arg[8], arg[9], arg[10]);
}
static SCM
_wrap_gncEntryGetOrder (SCM s_0)
{
#define FUNC_NAME "gncEntryGetOrder"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncOrder *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncOrder *)gncEntryGetOrder((struct _gncEntry const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOrder, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetInvoice (SCM s_0)
{
#define FUNC_NAME "gncEntryGetInvoice"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncInvoice *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncInvoice *)gncEntryGetInvoice((struct _gncEntry const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncInvoice, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryGetBill (SCM s_0)
{
#define FUNC_NAME "gncEntryGetBill"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncInvoice *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = (GncInvoice *)gncEntryGetBill((struct _gncEntry const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncInvoice, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncEntry *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncEntry *)gncEntryLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncEntry, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryIsOpen (SCM s_0)
{
#define FUNC_NAME "gncEntryIsOpen"
  GncEntry *arg1 = (GncEntry *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  result = gncEntryIsOpen((struct _gncEntry const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncEntryBeginEdit"
  GncEntry *arg1 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  gncEntryBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncEntryCommitEdit"
  GncEntry *arg1 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  gncEntryCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryCompare"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  result = (int)gncEntryCompare((struct _gncEntry const *)arg1,(struct _gncEntry const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncEntryEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncEntryEqual"
  GncEntry *arg1 = (GncEntry *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncEntry, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  result = gncEntryEqual((struct _gncEntry const *)arg1,(struct _gncEntry const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_DATE(SCM s_0)
{
#define FUNC_NAME "ENTRY-DATE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_DATE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_DATE_ENTERED(SCM s_0)
{
#define FUNC_NAME "ENTRY-DATE-ENTERED"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_DATE_ENTERED);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_DESC(SCM s_0)
{
#define FUNC_NAME "ENTRY-DESC"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_DESC);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_ACTION(SCM s_0)
{
#define FUNC_NAME "ENTRY-ACTION"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_ACTION);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_NOTES(SCM s_0)
{
#define FUNC_NAME "ENTRY-NOTES"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_NOTES);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_QTY(SCM s_0)
{
#define FUNC_NAME "ENTRY-QTY"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_QTY);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_IPRICE(SCM s_0)
{
#define FUNC_NAME "ENTRY-IPRICE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_IPRICE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_IACCT(SCM s_0)
{
#define FUNC_NAME "ENTRY-IACCT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_IACCT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_BACCT(SCM s_0)
{
#define FUNC_NAME "ENTRY-BACCT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_BACCT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_BPRICE(SCM s_0)
{
#define FUNC_NAME "ENTRY-BPRICE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_BPRICE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_BILLABLE(SCM s_0)
{
#define FUNC_NAME "ENTRY-BILLABLE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_BILLABLE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_BILLTO(SCM s_0)
{
#define FUNC_NAME "ENTRY-BILLTO"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_BILLTO);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_ORDER(SCM s_0)
{
#define FUNC_NAME "ENTRY-ORDER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_ORDER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_INVOICE(SCM s_0)
{
#define FUNC_NAME "ENTRY-INVOICE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_INVOICE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_BILL(SCM s_0)
{
#define FUNC_NAME "ENTRY-BILL"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_BILL);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_INV_DISC_TYPE(SCM s_0)
{
#define FUNC_NAME "ENTRY-INV-DISC-TYPE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_INV_DISC_TYPE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_INV_DISC_HOW(SCM s_0)
{
#define FUNC_NAME "ENTRY-INV-DISC-HOW"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_INV_DISC_HOW);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_INV_TAXABLE(SCM s_0)
{
#define FUNC_NAME "ENTRY-INV-TAXABLE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_INV_TAXABLE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_BILL_TAXABLE(SCM s_0)
{
#define FUNC_NAME "ENTRY-BILL-TAXABLE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_BILL_TAXABLE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_INV_TAX_INC(SCM s_0)
{
#define FUNC_NAME "ENTRY-INV-TAX-INC"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_INV_TAX_INC);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_BILL_TAX_INC(SCM s_0)
{
#define FUNC_NAME "ENTRY-BILL-TAX-INC"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_BILL_TAX_INC);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_INV_DISCOUNT(SCM s_0)
{
#define FUNC_NAME "ENTRY-INV-DISCOUNT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_INV_DISCOUNT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ENTRY_BILL_PAY_TYPE(SCM s_0)
{
#define FUNC_NAME "ENTRY-BILL-PAY-TYPE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ENTRY_BILL_PAY_TYPE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_INVOICE(SCM s_0)
{
#define FUNC_NAME "GNC-ID-INVOICE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_INVOICE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_invoice_get_type ()
{
#define FUNC_NAME "gnc-invoice-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_invoice_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceCreate (SCM s_0)
{
#define FUNC_NAME "gncInvoiceCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncInvoice *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncInvoice *)gncInvoiceCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncInvoice, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceDestroy (SCM s_0)
{
#define FUNC_NAME "gncInvoiceDestroy"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  gncInvoiceDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceCopy (SCM s_0)
{
#define FUNC_NAME "gncInvoiceCopy"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncInvoice *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (GncInvoice *)gncInvoiceCopy((struct _gncInvoice const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncInvoice, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetID (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetID"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncInvoiceSetID(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetOwner (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetOwner"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  gncInvoiceSetOwner(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetDateOpened (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetDateOpened"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  Timespec arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  arg2 = gnc_timepair2timespec(s_1);
  gncInvoiceSetDateOpened(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetDatePosted (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetDatePosted"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  Timespec arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  arg2 = gnc_timepair2timespec(s_1);
  gncInvoiceSetDatePosted(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetTerms (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetTerms"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncBillTerm *arg2 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncBillTerm *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncBillTerm, 2, 0);
  }
  gncInvoiceSetTerms(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetBillingID (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetBillingID"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncInvoiceSetBillingID(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetNotes (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetNotes"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncInvoiceSetNotes(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetCurrency (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetCurrency"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gnc_commodity *arg2 = (gnc_commodity *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (gnc_commodity *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_gnc_commodity, 2, 0);
  }
  gncInvoiceSetCurrency(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetActive (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetActive"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncInvoiceSetActive(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetBillTo (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetBillTo"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  gncInvoiceSetBillTo(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSetToChargeAmount (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceSetToChargeAmount"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncInvoiceSetToChargeAmount(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceAddEntry (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceAddEntry"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  gncInvoiceAddEntry(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceRemoveEntry (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceRemoveEntry"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  gncInvoiceRemoveEntry(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceAddPrice (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceAddPrice"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GNCPrice *arg2 = (GNCPrice *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GNCPrice *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GNCPrice, 2, 0);
  }
  gncInvoiceAddPrice(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceRemovePrice (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceRemovePrice"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GNCPrice *arg2 = (GNCPrice *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GNCPrice *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GNCPrice, 2, 0);
  }
  gncInvoiceRemovePrice(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillAddEntry (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillAddEntry"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  gncBillAddEntry(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillRemoveEntry (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillRemoveEntry"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  gncBillRemoveEntry(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillAddPrice (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillAddPrice"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GNCPrice *arg2 = (GNCPrice *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GNCPrice *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GNCPrice, 2, 0);
  }
  gncBillAddPrice(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncBillRemovePrice (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncBillRemovePrice"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GNCPrice *arg2 = (GNCPrice *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GNCPrice *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GNCPrice, 2, 0);
  }
  gncBillRemovePrice(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceSortEntries (SCM s_0)
{
#define FUNC_NAME "gncInvoiceSortEntries"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  gncInvoiceSortEntries(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetID (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetID"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (char *)gncInvoiceGetID((struct _gncInvoice const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetOwner (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetOwner"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncOwner *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (GncOwner *)gncInvoiceGetOwner(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOwner, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetDateOpened (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetDateOpened"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceGetDateOpened((struct _gncInvoice const *)arg1);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetDatePosted (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetDatePosted"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceGetDatePosted((struct _gncInvoice const *)arg1);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetDateDue (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetDateDue"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceGetDateDue((struct _gncInvoice const *)arg1);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetTerms (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetTerms"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncBillTerm *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (GncBillTerm *)gncInvoiceGetTerms((struct _gncInvoice const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncBillTerm, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetBillingID (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetBillingID"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (char *)gncInvoiceGetBillingID((struct _gncInvoice const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetNotes (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetNotes"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (char *)gncInvoiceGetNotes((struct _gncInvoice const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetOwnerType (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetOwnerType"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncOwnerType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (GncOwnerType)gncInvoiceGetOwnerType(arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetTypeFromOwnerType (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetTypeFromOwnerType"
  GncOwnerType arg1 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwnerType) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)gncInvoiceGetTypeFromOwnerType(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetType (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetType"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (char *)gncInvoiceGetType(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetCurrency (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetCurrency"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gnc_commodity *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (gnc_commodity *)gncInvoiceGetCurrency((struct _gncInvoice const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_gnc_commodity, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetBillTo (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetBillTo"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncOwner *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (GncOwner *)gncInvoiceGetBillTo(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOwner, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetToChargeAmount (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetToChargeAmount"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceGetToChargeAmount((struct _gncInvoice const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetActive (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetActive"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceGetActive((struct _gncInvoice const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetPostedLot (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetPostedLot"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GNCLot *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (GNCLot *)gncInvoiceGetPostedLot((struct _gncInvoice const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GNCLot, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetPostedTxn (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetPostedTxn"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  Transaction *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (Transaction *)gncInvoiceGetPostedTxn((struct _gncInvoice const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Transaction, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetPostedAcc (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetPostedAcc"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  Account *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (Account *)gncInvoiceGetPostedAcc((struct _gncInvoice const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Account, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetTotal (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetTotal"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceGetTotal(arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetTotalOf (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceGetTotalOf"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncEntryPaymentType arg2 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncEntryPaymentType) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  result = gncInvoiceGetTotalOf(arg1,arg2);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetTotalSubtotal (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetTotalSubtotal"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceGetTotalSubtotal(arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetTotalTax (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetTotalTax"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceGetTotalTax(arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetEntries (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetEntries"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  EntryList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (EntryList *)gncInvoiceGetEntries(arg1);
  {
    SCM list = SCM_EOL;
    GList *node;
    
    for (node = result; node; node = node->next)
    list = scm_cons(SWIG_NewPointerObj(node->data,
        SWIGTYPE_p__gncEntry, 0), list);
    
    gswig_result = scm_reverse(list);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetPrices (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetPrices"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (GList *)gncInvoiceGetPrices(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetPrice (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceGetPrice"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gnc_commodity *arg2 = (gnc_commodity *) 0 ;
  GNCPrice *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (gnc_commodity *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_gnc_commodity, 2, 0);
  }
  result = (GNCPrice *)gncInvoiceGetPrice(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GNCPrice, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoicePostToAccount (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5)
{
#define FUNC_NAME "gncInvoicePostToAccount"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  Account *arg2 = (Account *) 0 ;
  Timespec *arg3 = (Timespec *) 0 ;
  Timespec *arg4 = (Timespec *) 0 ;
  char *arg5 = (char *) 0 ;
  gboolean arg6 ;
  Transaction *result = 0 ;
  int must_free5 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (Account *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Account, 2, 0);
  }
  {
    arg3 = (Timespec *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_Timespec, 3, 0);
  }
  {
    arg4 = (Timespec *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_Timespec, 4, 0);
  }
  {
    arg5 = (char *)SWIG_scm2str(s_4);
    must_free5 = 1;
  }
  arg6 = scm_is_true(s_5) ? TRUE : FALSE;
  result = (Transaction *)gncInvoicePostToAccount(arg1,arg2,arg3,arg4,(char const *)arg5,arg6);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Transaction, 0);
  }
  
  
  
  
  if (must_free5 && arg5) SWIG_free(arg5);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceUnpost (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceUnpost"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gboolean arg2 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = gncInvoiceUnpost(arg1,arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerApplyPayment (SCM s_0, SCM s_1, SCM s_2, SCM s_3, SCM s_4, SCM s_5, SCM s_6, SCM s_7, SCM s_8)
{
#define FUNC_NAME "gncOwnerApplyPayment"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncInvoice *arg2 = (GncInvoice *) 0 ;
  Account *arg3 = (Account *) 0 ;
  Account *arg4 = (Account *) 0 ;
  gnc_numeric arg5 ;
  gnc_numeric arg6 ;
  Timespec arg7 ;
  char *arg8 = (char *) 0 ;
  char *arg9 = (char *) 0 ;
  Transaction *result = 0 ;
  int must_free8 = 0 ;
  int must_free9 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GncInvoice *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncInvoice, 2, 0);
  }
  {
    arg3 = (Account *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_Account, 3, 0);
  }
  {
    arg4 = (Account *)SWIG_MustGetPtr(s_3, SWIGTYPE_p_Account, 4, 0);
  }
  arg5 = gnc_scm_to_numeric(s_4);
  arg6 = gnc_scm_to_numeric(s_5);
  arg7 = gnc_timepair2timespec(s_6);
  {
    arg8 = (char *)SWIG_scm2str(s_7);
    must_free8 = 1;
  }
  {
    arg9 = (char *)SWIG_scm2str(s_8);
    must_free9 = 1;
  }
  result = (Transaction *)gncOwnerApplyPayment(arg1,arg2,arg3,arg4,arg5,arg6,arg7,(char const *)arg8,(char const *)arg9);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Transaction, 0);
  }
  
  
  
  
  if (must_free8 && arg8) SWIG_free(arg8);
  if (must_free9 && arg9) SWIG_free(arg9);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetInvoiceFromTxn (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetInvoiceFromTxn"
  Transaction *arg1 = (Transaction *) 0 ;
  GncInvoice *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (Transaction *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_Transaction, 1, 0);
  }
  result = (GncInvoice *)gncInvoiceGetInvoiceFromTxn((Transaction const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncInvoice, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetInvoiceFromLot (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetInvoiceFromLot"
  GNCLot *arg1 = (GNCLot *) 0 ;
  GncInvoice *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GNCLot *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_GNCLot, 1, 0);
  }
  result = (GncInvoice *)gncInvoiceGetInvoiceFromLot(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncInvoice, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncInvoice *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncInvoice *)gncInvoiceLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncInvoice, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncInvoiceBeginEdit"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  gncInvoiceBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncInvoiceCommitEdit"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  gncInvoiceCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceCompare"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncInvoice *arg2 = (GncInvoice *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncInvoice *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncInvoice, 2, 0);
  }
  result = (int)gncInvoiceCompare((struct _gncInvoice const *)arg1,(struct _gncInvoice const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncInvoiceEqual"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  GncInvoice *arg2 = (GncInvoice *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  {
    arg2 = (GncInvoice *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncInvoice, 2, 0);
  }
  result = gncInvoiceEqual((struct _gncInvoice const *)arg1,(struct _gncInvoice const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceIsPosted (SCM s_0)
{
#define FUNC_NAME "gncInvoiceIsPosted"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceIsPosted((struct _gncInvoice const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceIsPaid (SCM s_0)
{
#define FUNC_NAME "gncInvoiceIsPaid"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = gncInvoiceIsPaid((struct _gncInvoice const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_ID(SCM s_0)
{
#define FUNC_NAME "INVOICE-ID"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_ID);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_OWNER(SCM s_0)
{
#define FUNC_NAME "INVOICE-OWNER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_OWNER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_OPENED(SCM s_0)
{
#define FUNC_NAME "INVOICE-OPENED"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_OPENED);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_POSTED(SCM s_0)
{
#define FUNC_NAME "INVOICE-POSTED"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_POSTED);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_DUE(SCM s_0)
{
#define FUNC_NAME "INVOICE-DUE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_DUE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_IS_POSTED(SCM s_0)
{
#define FUNC_NAME "INVOICE-IS-POSTED"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_IS_POSTED);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_IS_PAID(SCM s_0)
{
#define FUNC_NAME "INVOICE-IS-PAID"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_IS_PAID);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_TERMS(SCM s_0)
{
#define FUNC_NAME "INVOICE-TERMS"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_TERMS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_BILLINGID(SCM s_0)
{
#define FUNC_NAME "INVOICE-BILLINGID"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_BILLINGID);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_NOTES(SCM s_0)
{
#define FUNC_NAME "INVOICE-NOTES"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_NOTES);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_ACC(SCM s_0)
{
#define FUNC_NAME "INVOICE-ACC"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_ACC);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_POST_TXN(SCM s_0)
{
#define FUNC_NAME "INVOICE-POST-TXN"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_POST_TXN);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_POST_LOT(SCM s_0)
{
#define FUNC_NAME "INVOICE-POST-LOT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_POST_LOT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_TYPE(SCM s_0)
{
#define FUNC_NAME "INVOICE-TYPE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_TYPE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_BILLTO(SCM s_0)
{
#define FUNC_NAME "INVOICE-BILLTO"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_BILLTO);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_ENTRIES(SCM s_0)
{
#define FUNC_NAME "INVOICE-ENTRIES"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_ENTRIES);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_JOB(SCM s_0)
{
#define FUNC_NAME "INVOICE-JOB"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_JOB);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_FROM_LOT(SCM s_0)
{
#define FUNC_NAME "INVOICE-FROM-LOT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_FROM_LOT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_INVOICE_FROM_TXN(SCM s_0)
{
#define FUNC_NAME "INVOICE-FROM-TXN"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_INVOICE_FROM_TXN);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncInvoiceGetBook (SCM s_0)
{
#define FUNC_NAME "gncInvoiceGetBook"
  GncInvoice *arg1 = (GncInvoice *) 0 ;
  QofBook *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncInvoice *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncInvoice, 1, 0);
  }
  result = (QofBook *)gncInvoiceGetBook(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_QofBook, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_JOB(SCM s_0)
{
#define FUNC_NAME "GNC-ID-JOB"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_JOB);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_job_get_type ()
{
#define FUNC_NAME "gnc-job-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_job_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobCreate (SCM s_0)
{
#define FUNC_NAME "gncJobCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncJob *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncJob *)gncJobCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncJob, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobDestroy (SCM s_0)
{
#define FUNC_NAME "gncJobDestroy"
  GncJob *arg1 = (GncJob *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  gncJobDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobSetID (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobSetID"
  GncJob *arg1 = (GncJob *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncJobSetID(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobSetName (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobSetName"
  GncJob *arg1 = (GncJob *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncJobSetName(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobSetReference (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobSetReference"
  GncJob *arg1 = (GncJob *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncJobSetReference(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobSetOwner (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobSetOwner"
  GncJob *arg1 = (GncJob *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  gncJobSetOwner(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobSetActive (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobSetActive"
  GncJob *arg1 = (GncJob *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncJobSetActive(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncJobBeginEdit"
  GncJob *arg1 = (GncJob *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  gncJobBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncJobCommitEdit"
  GncJob *arg1 = (GncJob *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  gncJobCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobGetID (SCM s_0)
{
#define FUNC_NAME "gncJobGetID"
  GncJob *arg1 = (GncJob *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  result = (char *)gncJobGetID((struct _gncJob const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobGetName (SCM s_0)
{
#define FUNC_NAME "gncJobGetName"
  GncJob *arg1 = (GncJob *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  result = (char *)gncJobGetName((struct _gncJob const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobGetReference (SCM s_0)
{
#define FUNC_NAME "gncJobGetReference"
  GncJob *arg1 = (GncJob *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  result = (char *)gncJobGetReference((struct _gncJob const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobGetOwner (SCM s_0)
{
#define FUNC_NAME "gncJobGetOwner"
  GncJob *arg1 = (GncJob *) 0 ;
  GncOwner *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  result = (GncOwner *)gncJobGetOwner(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOwner, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobGetActive (SCM s_0)
{
#define FUNC_NAME "gncJobGetActive"
  GncJob *arg1 = (GncJob *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  result = gncJobGetActive((struct _gncJob const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncJob *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncJob *)gncJobLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncJob, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobCompare"
  GncJob *arg1 = (GncJob *) 0 ;
  GncJob *arg2 = (GncJob *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  {
    arg2 = (GncJob *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncJob, 2, 0);
  }
  result = (int)gncJobCompare((struct _gncJob const *)arg1,(struct _gncJob const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncJobEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncJobEqual"
  GncJob *arg1 = (GncJob *) 0 ;
  GncJob *arg2 = (GncJob *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncJob *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncJob, 1, 0);
  }
  {
    arg2 = (GncJob *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncJob, 2, 0);
  }
  result = gncJobEqual((struct _gncJob const *)arg1,(struct _gncJob const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_JOB_ID(SCM s_0)
{
#define FUNC_NAME "JOB-ID"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_JOB_ID);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_JOB_NAME(SCM s_0)
{
#define FUNC_NAME "JOB-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_JOB_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_JOB_REFERENCE(SCM s_0)
{
#define FUNC_NAME "JOB-REFERENCE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_JOB_REFERENCE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_JOB_OWNER(SCM s_0)
{
#define FUNC_NAME "JOB-OWNER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_JOB_OWNER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_Q_JOB_OWNER(SCM s_0)
{
#define FUNC_NAME "Q-JOB-OWNER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_Q_JOB_OWNER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_JOB_ACTIVE(SCM s_0)
{
#define FUNC_NAME "JOB-ACTIVE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_JOB_ACTIVE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_ORDER(SCM s_0)
{
#define FUNC_NAME "GNC-ID-ORDER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_ORDER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_order_get_type ()
{
#define FUNC_NAME "gnc-order-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_order_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderCreate (SCM s_0)
{
#define FUNC_NAME "gncOrderCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncOrder *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncOrder *)gncOrderCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOrder, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderDestroy (SCM s_0)
{
#define FUNC_NAME "gncOrderDestroy"
  GncOrder *arg1 = (GncOrder *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  gncOrderDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderSetID (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderSetID"
  GncOrder *arg1 = (GncOrder *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncOrderSetID(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderSetOwner (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderSetOwner"
  GncOrder *arg1 = (GncOrder *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  gncOrderSetOwner(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderSetDateOpened (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderSetDateOpened"
  GncOrder *arg1 = (GncOrder *) 0 ;
  Timespec arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  arg2 = gnc_timepair2timespec(s_1);
  gncOrderSetDateOpened(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderSetDateClosed (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderSetDateClosed"
  GncOrder *arg1 = (GncOrder *) 0 ;
  Timespec arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  arg2 = gnc_timepair2timespec(s_1);
  gncOrderSetDateClosed(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderSetNotes (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderSetNotes"
  GncOrder *arg1 = (GncOrder *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncOrderSetNotes(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderSetReference (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderSetReference"
  GncOrder *arg1 = (GncOrder *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncOrderSetReference(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderSetActive (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderSetActive"
  GncOrder *arg1 = (GncOrder *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncOrderSetActive(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderAddEntry (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderAddEntry"
  GncOrder *arg1 = (GncOrder *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  gncOrderAddEntry(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderRemoveEntry (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderRemoveEntry"
  GncOrder *arg1 = (GncOrder *) 0 ;
  GncEntry *arg2 = (GncEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  {
    arg2 = (GncEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEntry, 2, 0);
  }
  gncOrderRemoveEntry(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderGetID (SCM s_0)
{
#define FUNC_NAME "gncOrderGetID"
  GncOrder *arg1 = (GncOrder *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = (char *)gncOrderGetID((struct _gncOrder const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderGetOwner (SCM s_0)
{
#define FUNC_NAME "gncOrderGetOwner"
  GncOrder *arg1 = (GncOrder *) 0 ;
  GncOwner *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = (GncOwner *)gncOrderGetOwner(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOwner, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderGetDateOpened (SCM s_0)
{
#define FUNC_NAME "gncOrderGetDateOpened"
  GncOrder *arg1 = (GncOrder *) 0 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = gncOrderGetDateOpened((struct _gncOrder const *)arg1);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderGetDateClosed (SCM s_0)
{
#define FUNC_NAME "gncOrderGetDateClosed"
  GncOrder *arg1 = (GncOrder *) 0 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = gncOrderGetDateClosed((struct _gncOrder const *)arg1);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderGetNotes (SCM s_0)
{
#define FUNC_NAME "gncOrderGetNotes"
  GncOrder *arg1 = (GncOrder *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = (char *)gncOrderGetNotes((struct _gncOrder const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderGetReference (SCM s_0)
{
#define FUNC_NAME "gncOrderGetReference"
  GncOrder *arg1 = (GncOrder *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = (char *)gncOrderGetReference((struct _gncOrder const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderGetActive (SCM s_0)
{
#define FUNC_NAME "gncOrderGetActive"
  GncOrder *arg1 = (GncOrder *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = gncOrderGetActive((struct _gncOrder const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderGetEntries (SCM s_0)
{
#define FUNC_NAME "gncOrderGetEntries"
  GncOrder *arg1 = (GncOrder *) 0 ;
  GList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = (GList *)gncOrderGetEntries(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncOrderBeginEdit"
  GncOrder *arg1 = (GncOrder *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  gncOrderBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncOrderCommitEdit"
  GncOrder *arg1 = (GncOrder *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  gncOrderCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderCompare"
  GncOrder *arg1 = (GncOrder *) 0 ;
  GncOrder *arg2 = (GncOrder *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  {
    arg2 = (GncOrder *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOrder, 2, 0);
  }
  result = (int)gncOrderCompare((struct _gncOrder const *)arg1,(struct _gncOrder const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderEqual"
  GncOrder *arg1 = (GncOrder *) 0 ;
  GncOrder *arg2 = (GncOrder *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  {
    arg2 = (GncOrder *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOrder, 2, 0);
  }
  result = gncOrderEqual((struct _gncOrder const *)arg1,(struct _gncOrder const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderIsClosed (SCM s_0)
{
#define FUNC_NAME "gncOrderIsClosed"
  GncOrder *arg1 = (GncOrder *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOrder *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOrder, 1, 0);
  }
  result = gncOrderIsClosed((struct _gncOrder const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOrderLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOrderLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncOrder *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncOrder *)gncOrderLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOrder, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ORDER_ID(SCM s_0)
{
#define FUNC_NAME "ORDER-ID"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ORDER_ID);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ORDER_REFERENCE(SCM s_0)
{
#define FUNC_NAME "ORDER-REFERENCE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ORDER_REFERENCE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ORDER_OWNER(SCM s_0)
{
#define FUNC_NAME "ORDER-OWNER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ORDER_OWNER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ORDER_OPENED(SCM s_0)
{
#define FUNC_NAME "ORDER-OPENED"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ORDER_OPENED);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ORDER_CLOSED(SCM s_0)
{
#define FUNC_NAME "ORDER-CLOSED"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ORDER_CLOSED);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ORDER_IS_CLOSED(SCM s_0)
{
#define FUNC_NAME "ORDER-IS-CLOSED"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ORDER_IS_CLOSED);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_ORDER_NOTES(SCM s_0)
{
#define FUNC_NAME "ORDER-NOTES"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_ORDER_NOTES);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_OWNER(SCM s_0)
{
#define FUNC_NAME "GNC-ID-OWNER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_OWNER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_OWNER_NONE(SCM s_0)
{
#define FUNC_NAME "GNC-OWNER-NONE"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_OWNER_NONE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_OWNER_UNDEFINED(SCM s_0)
{
#define FUNC_NAME "GNC-OWNER-UNDEFINED"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_OWNER_UNDEFINED);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_OWNER_CUSTOMER(SCM s_0)
{
#define FUNC_NAME "GNC-OWNER-CUSTOMER"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_OWNER_CUSTOMER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_OWNER_JOB(SCM s_0)
{
#define FUNC_NAME "GNC-OWNER-JOB"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_OWNER_JOB);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_OWNER_VENDOR(SCM s_0)
{
#define FUNC_NAME "GNC-OWNER-VENDOR"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_OWNER_VENDOR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_OWNER_EMPLOYEE(SCM s_0)
{
#define FUNC_NAME "GNC-OWNER-EMPLOYEE"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_OWNER_EMPLOYEE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qofOwnerGetType (SCM s_0)
{
#define FUNC_NAME "qofOwnerGetType"
  GncOwner *arg1 = (GncOwner *) 0 ;
  QofIdTypeConst result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = qofOwnerGetType((struct _gncOwner const *)arg1);
  {
    QofIdTypeConst * resultptr;
    resultptr = (QofIdTypeConst *) malloc(sizeof(QofIdTypeConst));
    memmove(resultptr, &result, sizeof(QofIdTypeConst));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_QofIdTypeConst, 1);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qofOwnerGetOwner (SCM s_0)
{
#define FUNC_NAME "qofOwnerGetOwner"
  GncOwner *arg1 = (GncOwner *) 0 ;
  QofInstance *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (QofInstance *)qofOwnerGetOwner((struct _gncOwner const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_QofInstance, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qofOwnerSetEntity (SCM s_0, SCM s_1)
{
#define FUNC_NAME "qofOwnerSetEntity"
  GncOwner *arg1 = (GncOwner *) 0 ;
  QofInstance *arg2 = (QofInstance *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (QofInstance *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_QofInstance, 2, 0);
  }
  qofOwnerSetEntity(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerTypeToQofIdType (SCM s_0)
{
#define FUNC_NAME "gncOwnerTypeToQofIdType"
  GncOwnerType arg1 ;
  QofIdTypeConst result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwnerType) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = gncOwnerTypeToQofIdType(arg1);
  {
    QofIdTypeConst * resultptr;
    resultptr = (QofIdTypeConst *) malloc(sizeof(QofIdTypeConst));
    memmove(resultptr, &result, sizeof(QofIdTypeConst));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_QofIdTypeConst, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerRegister ()
{
#define FUNC_NAME "gncOwnerRegister"
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gncOwnerRegister();
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerInitUndefined (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerInitUndefined"
  GncOwner *arg1 = (GncOwner *) 0 ;
  gpointer arg2 = (gpointer) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (gpointer)SWIG_MustGetPtr(s_1, NULL, 2, 0);
  }
  gncOwnerInitUndefined(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerInitCustomer (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerInitCustomer"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncCustomer *arg2 = (GncCustomer *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GncCustomer *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncCustomer, 2, 0);
  }
  gncOwnerInitCustomer(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerInitJob (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerInitJob"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncJob *arg2 = (GncJob *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GncJob *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncJob, 2, 0);
  }
  gncOwnerInitJob(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerInitVendor (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerInitVendor"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncVendor *arg2 = (GncVendor *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GncVendor *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncVendor, 2, 0);
  }
  gncOwnerInitVendor(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerInitEmployee (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerInitEmployee"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncEmployee *arg2 = (GncEmployee *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GncEmployee *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncEmployee, 2, 0);
  }
  gncOwnerInitEmployee(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetType (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetType"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncOwnerType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncOwnerType)gncOwnerGetType((struct _gncOwner const *)arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetUndefined (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetUndefined"
  GncOwner *arg1 = (GncOwner *) 0 ;
  gpointer result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (gpointer)gncOwnerGetUndefined((struct _gncOwner const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_void, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetCustomer (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetCustomer"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncCustomer *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncCustomer *)gncOwnerGetCustomer((struct _gncOwner const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncCustomer, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetJob (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetJob"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncJob *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncJob *)gncOwnerGetJob((struct _gncOwner const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncJob, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetVendor (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetVendor"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncVendor *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncVendor *)gncOwnerGetVendor((struct _gncOwner const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncVendor, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetEmployee (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetEmployee"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncEmployee *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncEmployee *)gncOwnerGetEmployee((struct _gncOwner const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncEmployee, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerCopy (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerCopy"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  gncOwnerCopy((struct _gncOwner const *)arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerEqual"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  result = gncOwnerEqual((struct _gncOwner const *)arg1,(struct _gncOwner const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerCompare"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  result = (int)gncOwnerCompare((struct _gncOwner const *)arg1,(struct _gncOwner const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetID (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetID"
  GncOwner *arg1 = (GncOwner *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (char *)gncOwnerGetID((struct _gncOwner const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetName (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetName"
  GncOwner *arg1 = (GncOwner *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (char *)gncOwnerGetName((struct _gncOwner const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetAddr (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetAddr"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncAddress *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncAddress *)gncOwnerGetAddr((struct _gncOwner const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncAddress, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetActive (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetActive"
  GncOwner *arg1 = (GncOwner *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = gncOwnerGetActive((struct _gncOwner const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetCurrency (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetCurrency"
  GncOwner *arg1 = (GncOwner *) 0 ;
  gnc_commodity *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (gnc_commodity *)gncOwnerGetCurrency((struct _gncOwner const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_gnc_commodity, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetGUID (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetGUID"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncGUID *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncGUID *)gncOwnerGetGUID((struct _gncOwner const *)arg1);
  gswig_result = (result) ? gnc_guid2scm(*(result)): SCM_BOOL_F; 
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerReturnGUID (SCM s_0)
{
#define FUNC_NAME "gncOwnerReturnGUID"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncGUID result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = gncOwnerRetGUID(arg1);
  gswig_result = gnc_guid2scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerIsValid (SCM s_0)
{
#define FUNC_NAME "gncOwnerIsValid"
  GncOwner *arg1 = (GncOwner *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = gncOwnerIsValid((struct _gncOwner const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetEndOwner (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetEndOwner"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncOwner *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncOwner *)gncOwnerGetEndOwner(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOwner, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetEndGUID (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetEndGUID"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GncGUID *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (GncGUID *)gncOwnerGetEndGUID(arg1);
  gswig_result = (result) ? gnc_guid2scm(*(result)): SCM_BOOL_F; 
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerAttachToLot (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerAttachToLot"
  GncOwner *arg1 = (GncOwner *) 0 ;
  GNCLot *arg2 = (GNCLot *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  {
    arg2 = (GNCLot *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GNCLot, 2, 0);
  }
  gncOwnerAttachToLot((struct _gncOwner const *)arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetOwnerFromLot (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncOwnerGetOwnerFromLot"
  GNCLot *arg1 = (GNCLot *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GNCLot *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_GNCLot, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  result = gncOwnerGetOwnerFromLot(arg1,arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetOwnerFromTypeGuid (SCM s_0, SCM s_1, SCM s_2, SCM s_3)
{
#define FUNC_NAME "gncOwnerGetOwnerFromTypeGuid"
  QofBook *arg1 = (QofBook *) 0 ;
  GncOwner *arg2 = (GncOwner *) 0 ;
  QofIdType arg3 ;
  GncGUID *arg4 = (GncGUID *) 0 ;
  gboolean result;
  QofIdType *argp3 ;
  GncGUID g4 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  {
    arg2 = (GncOwner *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncOwner, 2, 0);
  }
  {
    argp3 = (QofIdType *)SWIG_MustGetPtr(s_2, SWIGTYPE_p_QofIdType, 3, 0);
    arg3 = *argp3;
  }
  g4 = gnc_scm2guid(s_3); arg4 = &g4; 
  result = gncOwnerGetOwnerFromTypeGuid(arg1,arg2,arg3,arg4);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerGetSlots (SCM s_0)
{
#define FUNC_NAME "gncOwnerGetSlots"
  GncOwner *arg1 = (GncOwner *) 0 ;
  KvpFrame *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  result = (KvpFrame *)gncOwnerGetSlots(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_KvpFrame, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_TYPE(SCM s_0)
{
#define FUNC_NAME "OWNER-TYPE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_TYPE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_TYPE_STRING(SCM s_0)
{
#define FUNC_NAME "OWNER-TYPE-STRING"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_TYPE_STRING);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_CUSTOMER(SCM s_0)
{
#define FUNC_NAME "OWNER-CUSTOMER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_CUSTOMER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_JOB(SCM s_0)
{
#define FUNC_NAME "OWNER-JOB"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_JOB);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_VENDOR(SCM s_0)
{
#define FUNC_NAME "OWNER-VENDOR"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_VENDOR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_EMPLOYEE(SCM s_0)
{
#define FUNC_NAME "OWNER-EMPLOYEE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_EMPLOYEE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_PARENT(SCM s_0)
{
#define FUNC_NAME "OWNER-PARENT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_PARENT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_PARENTG(SCM s_0)
{
#define FUNC_NAME "OWNER-PARENTG"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_PARENTG);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_NAME(SCM s_0)
{
#define FUNC_NAME "OWNER-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_OWNER_FROM_LOT(SCM s_0)
{
#define FUNC_NAME "OWNER-FROM-LOT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_OWNER_FROM_LOT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerCreate ()
{
#define FUNC_NAME "gncOwnerCreate"
  GncOwner *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = (GncOwner *)gncOwnerCreate();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncOwner, 0);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncOwnerDestroy (SCM s_0)
{
#define FUNC_NAME "gncOwnerDestroy"
  GncOwner *arg1 = (GncOwner *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncOwner *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncOwner, 1, 0);
  }
  gncOwnerDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_TAXTABLE(SCM s_0)
{
#define FUNC_NAME "GNC-ID-TAXTABLE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_TAXTABLE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_taxtable_get_type ()
{
#define FUNC_NAME "gnc-taxtable-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_taxtable_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_AMT_TYPE_VALUE(SCM s_0)
{
#define FUNC_NAME "GNC-AMT-TYPE-VALUE"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_AMT_TYPE_VALUE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_AMT_TYPE_PERCENT(SCM s_0)
{
#define FUNC_NAME "GNC-AMT-TYPE-PERCENT"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_AMT_TYPE_PERCENT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_TAXINCLUDED_YES(SCM s_0)
{
#define FUNC_NAME "GNC-TAXINCLUDED-YES"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_TAXINCLUDED_YES);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_TAXINCLUDED_NO(SCM s_0)
{
#define FUNC_NAME "GNC-TAXINCLUDED-NO"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_TAXINCLUDED_NO);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_TAXINCLUDED_USEGLOBAL(SCM s_0)
{
#define FUNC_NAME "GNC-TAXINCLUDED-USEGLOBAL"
  SCM gswig_result;
  
  {
    gswig_result = scm_long2num(gswig_const_GNC_TAXINCLUDED_USEGLOBAL);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAmountTypeToString (SCM s_0)
{
#define FUNC_NAME "gncAmountTypeToString"
  GncAmountType arg1 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncAmountType) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)gncAmountTypeToString(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAmountStringToType (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAmountStringToType"
  char *arg1 = (char *) 0 ;
  GncAmountType *arg2 = (GncAmountType *) 0 ;
  gboolean result;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (char *)SWIG_scm2str(s_0);
    must_free1 = 1;
  }
  {
    arg2 = (GncAmountType *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GncAmountType, 2, 0);
  }
  result = gncAmountStringToType((char const *)arg1,arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  if (must_free1 && arg1) SWIG_free(arg1);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxIncludedTypeToString (SCM s_0)
{
#define FUNC_NAME "gncTaxIncludedTypeToString"
  GncTaxIncluded arg1 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxIncluded) scm_num2int(s_0, SCM_ARG1, FUNC_NAME); 
  }
  result = (char *)gncTaxIncludedTypeToString(arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxIncludedStringToType (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxIncludedStringToType"
  char *arg1 = (char *) 0 ;
  GncTaxIncluded *arg2 = (GncTaxIncluded *) 0 ;
  gboolean result;
  int must_free1 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (char *)SWIG_scm2str(s_0);
    must_free1 = 1;
  }
  {
    arg2 = (GncTaxIncluded *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GncTaxIncluded, 2, 0);
  }
  result = gncTaxIncludedStringToType((char const *)arg1,arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  if (must_free1 && arg1) SWIG_free(arg1);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableCreate (SCM s_0)
{
#define FUNC_NAME "gncTaxTableCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncTaxTable *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncTaxTable *)gncTaxTableCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableDestroy (SCM s_0)
{
#define FUNC_NAME "gncTaxTableDestroy"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  gncTaxTableDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntryCreate ()
{
#define FUNC_NAME "gncTaxTableEntryCreate"
  GncTaxTableEntry *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = (GncTaxTableEntry *)gncTaxTableEntryCreate();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTableEntry, 0);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntryDestroy (SCM s_0)
{
#define FUNC_NAME "gncTaxTableEntryDestroy"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  gncTaxTableEntryDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableSetName (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableSetName"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncTaxTableSetName(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableIncRef (SCM s_0)
{
#define FUNC_NAME "gncTaxTableIncRef"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  gncTaxTableIncRef(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableDecRef (SCM s_0)
{
#define FUNC_NAME "gncTaxTableDecRef"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  gncTaxTableDecRef(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntrySetAccount (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableEntrySetAccount"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  Account *arg2 = (Account *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  {
    arg2 = (Account *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Account, 2, 0);
  }
  gncTaxTableEntrySetAccount(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntrySetType (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableEntrySetType"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  GncAmountType arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  {
    arg2 = (GncAmountType) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  gncTaxTableEntrySetType(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntrySetAmount (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableEntrySetAmount"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  gncTaxTableEntrySetAmount(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableAddEntry (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableAddEntry"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  GncTaxTableEntry *arg2 = (GncTaxTableEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  {
    arg2 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTableEntry, 2, 0);
  }
  gncTaxTableAddEntry(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableRemoveEntry (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableRemoveEntry"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  GncTaxTableEntry *arg2 = (GncTaxTableEntry *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  {
    arg2 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTableEntry, 2, 0);
  }
  gncTaxTableRemoveEntry(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableChanged (SCM s_0)
{
#define FUNC_NAME "gncTaxTableChanged"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  gncTaxTableChanged(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncTaxTableBeginEdit"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  gncTaxTableBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncTaxTableCommitEdit"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  gncTaxTableCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableEqual"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  GncTaxTable *arg2 = (GncTaxTable *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  {
    arg2 = (GncTaxTable *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTable, 2, 0);
  }
  result = gncTaxTableEqual((struct _gncTaxTable const *)arg1,(struct _gncTaxTable const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncTaxTable *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncTaxTable *)gncTaxTableLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableLookupByName (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableLookupByName"
  QofBook *arg1 = (QofBook *) 0 ;
  char *arg2 = (char *) 0 ;
  GncTaxTable *result = 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  result = (GncTaxTable *)gncTaxTableLookupByName(arg1,(char const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableGetTables (SCM s_0)
{
#define FUNC_NAME "gncTaxTableGetTables"
  QofBook *arg1 = (QofBook *) 0 ;
  GList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GList *)gncTaxTableGetTables(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableGetName (SCM s_0)
{
#define FUNC_NAME "gncTaxTableGetName"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  result = (char *)gncTaxTableGetName((struct _gncTaxTable const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableGetParent (SCM s_0)
{
#define FUNC_NAME "gncTaxTableGetParent"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  GncTaxTable *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  result = (GncTaxTable *)gncTaxTableGetParent((struct _gncTaxTable const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableReturnChild (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableReturnChild"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  gboolean arg2 ;
  GncTaxTable *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = (GncTaxTable *)gncTaxTableReturnChild(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableGetEntries (SCM s_0)
{
#define FUNC_NAME "gncTaxTableGetEntries"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  GncTaxTableEntryList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  result = (GncTaxTableEntryList *)gncTaxTableGetEntries((struct _gncTaxTable const *)arg1);
  {
    SCM list = SCM_EOL;
    GList *node;
    
    for (node = result; node; node = node->next)
    list = scm_cons(SWIG_NewPointerObj(node->data,
        SWIGTYPE_p__gncTaxTableEntry, 0), list);
    
    gswig_result = scm_reverse(list);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableGetRefcount (SCM s_0)
{
#define FUNC_NAME "gncTaxTableGetRefcount"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  gint64 result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  result = gncTaxTableGetRefcount((struct _gncTaxTable const *)arg1);
  gswig_result = gnc_gint64_to_scm(result); 
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableLastModified (SCM s_0)
{
#define FUNC_NAME "gncTaxTableLastModified"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  Timespec result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  result = gncTaxTableLastModified((struct _gncTaxTable const *)arg1);
  gswig_result = gnc_timespec2timepair(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntryGetAccount (SCM s_0)
{
#define FUNC_NAME "gncTaxTableEntryGetAccount"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  Account *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  result = (Account *)gncTaxTableEntryGetAccount((struct _gncTaxTableEntry const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Account, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntryGetType (SCM s_0)
{
#define FUNC_NAME "gncTaxTableEntryGetType"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  GncAmountType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  result = (GncAmountType)gncTaxTableEntryGetType((struct _gncTaxTableEntry const *)arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntryGetAmount (SCM s_0)
{
#define FUNC_NAME "gncTaxTableEntryGetAmount"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  result = gncTaxTableEntryGetAmount((struct _gncTaxTableEntry const *)arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableCompare"
  GncTaxTable *arg1 = (GncTaxTable *) 0 ;
  GncTaxTable *arg2 = (GncTaxTable *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTable *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTable, 1, 0);
  }
  {
    arg2 = (GncTaxTable *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTable, 2, 0);
  }
  result = (int)gncTaxTableCompare((struct _gncTaxTable const *)arg1,(struct _gncTaxTable const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntryCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableEntryCompare"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  GncTaxTableEntry *arg2 = (GncTaxTableEntry *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  {
    arg2 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTableEntry, 2, 0);
  }
  result = (int)gncTaxTableEntryCompare((struct _gncTaxTableEntry const *)arg1,(struct _gncTaxTableEntry const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncTaxTableEntryEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncTaxTableEntryEqual"
  GncTaxTableEntry *arg1 = (GncTaxTableEntry *) 0 ;
  GncTaxTableEntry *arg2 = (GncTaxTableEntry *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncTaxTableEntry, 1, 0);
  }
  {
    arg2 = (GncTaxTableEntry *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTableEntry, 2, 0);
  }
  result = gncTaxTableEntryEqual((struct _gncTaxTableEntry const *)arg1,(struct _gncTaxTableEntry const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap__gncAccountValue_account_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "-gncAccountValue-account-set"
  struct _gncAccountValue *arg1 = (struct _gncAccountValue *) 0 ;
  Account *arg2 = (Account *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (struct _gncAccountValue *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAccountValue, 1, 0);
  }
  {
    arg2 = (Account *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Account, 2, 0);
  }
  if (arg1) (arg1)->account = arg2;
  
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap__gncAccountValue_account_get (SCM s_0)
{
#define FUNC_NAME "-gncAccountValue-account-get"
  struct _gncAccountValue *arg1 = (struct _gncAccountValue *) 0 ;
  Account *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (struct _gncAccountValue *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAccountValue, 1, 0);
  }
  result = (Account *) ((arg1)->account);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_Account, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap__gncAccountValue_value_set (SCM s_0, SCM s_1)
{
#define FUNC_NAME "-gncAccountValue-value-set"
  struct _gncAccountValue *arg1 = (struct _gncAccountValue *) 0 ;
  gnc_numeric arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (struct _gncAccountValue *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAccountValue, 1, 0);
  }
  arg2 = gnc_scm_to_numeric(s_1);
  if (arg1) (arg1)->value = arg2;
  
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap__gncAccountValue_value_get (SCM s_0)
{
#define FUNC_NAME "-gncAccountValue-value-get"
  struct _gncAccountValue *arg1 = (struct _gncAccountValue *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (struct _gncAccountValue *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAccountValue, 1, 0);
  }
  result =  ((arg1)->value);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_new__gncAccountValue ()
{
#define FUNC_NAME "new--gncAccountValue"
  struct _gncAccountValue *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = (struct _gncAccountValue *)(struct _gncAccountValue *) calloc(1, sizeof(struct _gncAccountValue));
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncAccountValue, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_delete__gncAccountValue (SCM s_0)
{
#define FUNC_NAME "delete--gncAccountValue"
  struct _gncAccountValue *arg1 = (struct _gncAccountValue *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (struct _gncAccountValue *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncAccountValue, 1, 0);
  }
  free((char *) arg1);
  
  gswig_result = SCM_UNSPECIFIED;
  
  SWIG_Guile_MarkPointerDestroyed(s_0);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAccountValueAdd (SCM s_0, SCM s_1, SCM s_2)
{
#define FUNC_NAME "gncAccountValueAdd"
  GList *arg1 = (GList *) 0 ;
  Account *arg2 = (Account *) 0 ;
  gnc_numeric arg3 ;
  GList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GList *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_GList, 1, 0);
  }
  {
    arg2 = (Account *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_Account, 2, 0);
  }
  arg3 = gnc_scm_to_numeric(s_2);
  result = (GList *)gncAccountValueAdd(arg1,arg2,arg3);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAccountValueAddList (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncAccountValueAddList"
  GList *arg1 = (GList *) 0 ;
  GList *arg2 = (GList *) 0 ;
  GList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GList *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_GList, 1, 0);
  }
  {
    arg2 = (GList *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_GList, 2, 0);
  }
  result = (GList *)gncAccountValueAddList(arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAccountValueTotal (SCM s_0)
{
#define FUNC_NAME "gncAccountValueTotal"
  GList *arg1 = (GList *) 0 ;
  gnc_numeric result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GList *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_GList, 1, 0);
  }
  result = gncAccountValueTotal(arg1);
  gswig_result = gnc_numeric_to_scm(result);
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncAccountValueDestroy (SCM s_0)
{
#define FUNC_NAME "gncAccountValueDestroy"
  GList *arg1 = (GList *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GList *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_GList, 1, 0);
  }
  gncAccountValueDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_TT_NAME(SCM s_0)
{
#define FUNC_NAME "GNC-TT-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_TT_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_TT_REFCOUNT(SCM s_0)
{
#define FUNC_NAME "GNC-TT-REFCOUNT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_TT_REFCOUNT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_GNC_ID_VENDOR(SCM s_0)
{
#define FUNC_NAME "GNC-ID-VENDOR"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_GNC_ID_VENDOR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_vendor_get_type ()
{
#define FUNC_NAME "gnc-vendor-get-type"
  GType result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = gnc_vendor_get_type();
  {
    GType * resultptr;
    resultptr = (GType *) malloc(sizeof(GType));
    memmove(resultptr, &result, sizeof(GType));
    gswig_result = SWIG_NewPointerObj(resultptr, SWIGTYPE_p_GType, 1);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorCreate (SCM s_0)
{
#define FUNC_NAME "gncVendorCreate"
  QofBook *arg1 = (QofBook *) 0 ;
  GncVendor *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  result = (GncVendor *)gncVendorCreate(arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncVendor, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorDestroy (SCM s_0)
{
#define FUNC_NAME "gncVendorDestroy"
  GncVendor *arg1 = (GncVendor *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  gncVendorDestroy(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetID (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetID"
  GncVendor *arg1 = (GncVendor *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncVendorSetID(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetName (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetName"
  GncVendor *arg1 = (GncVendor *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncVendorSetName(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetNotes (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetNotes"
  GncVendor *arg1 = (GncVendor *) 0 ;
  char *arg2 = (char *) 0 ;
  int must_free2 = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (char *)SWIG_scm2str(s_1);
    must_free2 = 1;
  }
  gncVendorSetNotes(arg1,(char const *)arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  if (must_free2 && arg2) SWIG_free(arg2);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetTerms (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetTerms"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncBillTerm *arg2 = (GncBillTerm *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (GncBillTerm *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncBillTerm, 2, 0);
  }
  gncVendorSetTerms(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetTaxIncluded (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetTaxIncluded"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncTaxIncluded arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (GncTaxIncluded) scm_num2int(s_1, SCM_ARG1, FUNC_NAME); 
  }
  gncVendorSetTaxIncluded(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetCurrency (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetCurrency"
  GncVendor *arg1 = (GncVendor *) 0 ;
  gnc_commodity *arg2 = (gnc_commodity *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (gnc_commodity *)SWIG_MustGetPtr(s_1, SWIGTYPE_p_gnc_commodity, 2, 0);
  }
  gncVendorSetCurrency(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetActive (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetActive"
  GncVendor *arg1 = (GncVendor *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncVendorSetActive(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetTaxTableOverride (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetTaxTableOverride"
  GncVendor *arg1 = (GncVendor *) 0 ;
  gboolean arg2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  gncVendorSetTaxTableOverride(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorSetTaxTable (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorSetTaxTable"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncTaxTable *arg2 = (GncTaxTable *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (GncTaxTable *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncTaxTable, 2, 0);
  }
  gncVendorSetTaxTable(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorAddJob (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorAddJob"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncJob *arg2 = (GncJob *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (GncJob *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncJob, 2, 0);
  }
  gncVendorAddJob(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorRemoveJob (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorRemoveJob"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncJob *arg2 = (GncJob *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (GncJob *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncJob, 2, 0);
  }
  gncVendorRemoveJob(arg1,arg2);
  gswig_result = SCM_UNSPECIFIED;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorBeginEdit (SCM s_0)
{
#define FUNC_NAME "gncVendorBeginEdit"
  GncVendor *arg1 = (GncVendor *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  gncVendorBeginEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorCommitEdit (SCM s_0)
{
#define FUNC_NAME "gncVendorCommitEdit"
  GncVendor *arg1 = (GncVendor *) 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  gncVendorCommitEdit(arg1);
  gswig_result = SCM_UNSPECIFIED;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetID (SCM s_0)
{
#define FUNC_NAME "gncVendorGetID"
  GncVendor *arg1 = (GncVendor *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = (char *)gncVendorGetID((struct _gncVendor const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetName (SCM s_0)
{
#define FUNC_NAME "gncVendorGetName"
  GncVendor *arg1 = (GncVendor *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = (char *)gncVendorGetName((struct _gncVendor const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetAddr (SCM s_0)
{
#define FUNC_NAME "gncVendorGetAddr"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncAddress *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = (GncAddress *)gncVendorGetAddr((struct _gncVendor const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncAddress, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetNotes (SCM s_0)
{
#define FUNC_NAME "gncVendorGetNotes"
  GncVendor *arg1 = (GncVendor *) 0 ;
  char *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = (char *)gncVendorGetNotes((struct _gncVendor const *)arg1);
  {
    gswig_result = scm_makfrom0str((const char *)result);
    if (!scm_is_true(gswig_result)) {
      gswig_result = scm_makstr(0, 0);
    }
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetTerms (SCM s_0)
{
#define FUNC_NAME "gncVendorGetTerms"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncBillTerm *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = (GncBillTerm *)gncVendorGetTerms((struct _gncVendor const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncBillTerm, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetTaxIncluded (SCM s_0)
{
#define FUNC_NAME "gncVendorGetTaxIncluded"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncTaxIncluded result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = (GncTaxIncluded)gncVendorGetTaxIncluded((struct _gncVendor const *)arg1);
  {
    gswig_result = scm_long2num(result); 
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetCurrency (SCM s_0)
{
#define FUNC_NAME "gncVendorGetCurrency"
  GncVendor *arg1 = (GncVendor *) 0 ;
  gnc_commodity *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = (gnc_commodity *)gncVendorGetCurrency((struct _gncVendor const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_gnc_commodity, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetActive (SCM s_0)
{
#define FUNC_NAME "gncVendorGetActive"
  GncVendor *arg1 = (GncVendor *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = gncVendorGetActive((struct _gncVendor const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetTaxTableOverride (SCM s_0)
{
#define FUNC_NAME "gncVendorGetTaxTableOverride"
  GncVendor *arg1 = (GncVendor *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = gncVendorGetTaxTableOverride((struct _gncVendor const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetTaxTable (SCM s_0)
{
#define FUNC_NAME "gncVendorGetTaxTable"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncTaxTable *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = (GncTaxTable *)gncVendorGetTaxTable((struct _gncVendor const *)arg1);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncTaxTable, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorGetJoblist (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorGetJoblist"
  GncVendor *arg1 = (GncVendor *) 0 ;
  gboolean arg2 ;
  GList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  arg2 = scm_is_true(s_1) ? TRUE : FALSE;
  result = (GList *)gncVendorGetJoblist((struct _gncVendor const *)arg1,arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p_GList, 0);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorIsDirty (SCM s_0)
{
#define FUNC_NAME "gncVendorIsDirty"
  GncVendor *arg1 = (GncVendor *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  result = gncVendorIsDirty((struct _gncVendor const *)arg1);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorCompare (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorCompare"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncVendor *arg2 = (GncVendor *) 0 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (GncVendor *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncVendor, 2, 0);
  }
  result = (int)gncVendorCompare((struct _gncVendor const *)arg1,(struct _gncVendor const *)arg2);
  {
    gswig_result = scm_long2num(result);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorEqual (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorEqual"
  GncVendor *arg1 = (GncVendor *) 0 ;
  GncVendor *arg2 = (GncVendor *) 0 ;
  gboolean result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (GncVendor *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__gncVendor, 1, 0);
  }
  {
    arg2 = (GncVendor *)SWIG_MustGetPtr(s_1, SWIGTYPE_p__gncVendor, 2, 0);
  }
  result = gncVendorEqual((struct _gncVendor const *)arg1,(struct _gncVendor const *)arg2);
  gswig_result = result ? SCM_BOOL_T : SCM_BOOL_F;
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gncVendorLookup (SCM s_0, SCM s_1)
{
#define FUNC_NAME "gncVendorLookup"
  QofBook *arg1 = (QofBook *) 0 ;
  GncGUID *arg2 = (GncGUID *) 0 ;
  GncVendor *result = 0 ;
  GncGUID g2 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofBook *)SWIG_MustGetPtr(s_0, SWIGTYPE_p_QofBook, 1, 0);
  }
  g2 = gnc_scm2guid(s_1); arg2 = &g2; 
  result = (GncVendor *)gncVendorLookup((QofBook const *)arg1,(GncGUID const *)arg2);
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__gncVendor, 0);
  }
  
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_ID(SCM s_0)
{
#define FUNC_NAME "VENDOR-ID"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_ID);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_NAME(SCM s_0)
{
#define FUNC_NAME "VENDOR-NAME"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_NAME);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_ADDR(SCM s_0)
{
#define FUNC_NAME "VENDOR-ADDR"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_ADDR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_NOTES(SCM s_0)
{
#define FUNC_NAME "VENDOR-NOTES"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_NOTES);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_TERMS(SCM s_0)
{
#define FUNC_NAME "VENDOR-TERMS"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_TERMS);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_TAX_INC(SCM s_0)
{
#define FUNC_NAME "VENDOR-TAX-INC"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_TAX_INC);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_ACTIVE(SCM s_0)
{
#define FUNC_NAME "VENDOR-ACTIVE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_ACTIVE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_TAX_OVERRIDE(SCM s_0)
{
#define FUNC_NAME "VENDOR-TAX-OVERRIDE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_TAX_OVERRIDE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_VENDOR_TAX_TABLE(SCM s_0)
{
#define FUNC_NAME "VENDOR-TAX-TABLE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_VENDOR_TAX_TABLE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_account_value_pointer_p (SCM s_0)
{
#define FUNC_NAME "gnc-account-value-pointer-p"
  SCM arg1 ;
  int result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1=s_0;
  result = (int)gnc_account_value_pointer_p(arg1);
  {
    gswig_result = scm_long2num(result);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_scm_to_account_value_ptr (SCM s_0)
{
#define FUNC_NAME "gnc-scm-to-account-value-ptr"
  SCM arg1 ;
  GncAccountValue *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1=s_0;
  result = (GncAccountValue *)gnc_scm_to_account_value_ptr(arg1);
  gswig_result = gnc_account_value_ptr_to_scm(result);
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_gnc_account_value_ptr_to_scm (SCM s_0)
{
#define FUNC_NAME "gnc-account-value-ptr-to-scm"
  GncAccountValue *arg1 = (GncAccountValue *) 0 ;
  SCM result;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  arg1 = gnc_scm_to_account_value_ptr(s_0);
  result = (SCM)gnc_account_value_ptr_to_scm(arg1);
  gswig_result=result;
  
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_URL_TYPE_CUSTOMER(SCM s_0)
{
#define FUNC_NAME "URL-TYPE-CUSTOMER"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_URL_TYPE_CUSTOMER);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_URL_TYPE_VENDOR(SCM s_0)
{
#define FUNC_NAME "URL-TYPE-VENDOR"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_URL_TYPE_VENDOR);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_URL_TYPE_EMPLOYEE(SCM s_0)
{
#define FUNC_NAME "URL-TYPE-EMPLOYEE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_URL_TYPE_EMPLOYEE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_URL_TYPE_JOB(SCM s_0)
{
#define FUNC_NAME "URL-TYPE-JOB"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_URL_TYPE_JOB);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_URL_TYPE_INVOICE(SCM s_0)
{
#define FUNC_NAME "URL-TYPE-INVOICE"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_URL_TYPE_INVOICE);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_URL_TYPE_OWNERREPORT(SCM s_0)
{
#define FUNC_NAME "URL-TYPE-OWNERREPORT"
  SCM gswig_result;
  
  {
    gswig_result = scm_makfrom0str(gswig_const_URL_TYPE_OWNERREPORT);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qof_query_create_for_invoices ()
{
#define FUNC_NAME "qof-query-create-for-invoices"
  QofQuery *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  result = (QofQuery *)qof_query_create_for_invoices();
  {
    gswig_result = SWIG_NewPointerObj (result, SWIGTYPE_p__QofQuery, 0);
  }
  
  return gswig_result;
#undef FUNC_NAME
}


static SCM
_wrap_qof_query_run_for_invoices (SCM s_0)
{
#define FUNC_NAME "qof-query-run-for-invoices"
  QofQuery *arg1 = (QofQuery *) 0 ;
  GncInvoiceList *result = 0 ;
  SCM gswig_result;
  SWIGUNUSED int gswig_list_p = 0;
  
  {
    arg1 = (QofQuery *)SWIG_MustGetPtr(s_0, SWIGTYPE_p__QofQuery, 1, 0);
  }
  result = (GncInvoiceList *)qof_query_run_for_invoices(arg1);
  {
    SCM list = SCM_EOL;
    GList *node;
    
    for (node = result; node; node = node->next)
    list = scm_cons(SWIG_NewPointerObj(node->data,
        SWIGTYPE_p__gncInvoice, 0), list);
    
    gswig_result = scm_reverse(list);
  }
  
  
  return gswig_result;
#undef FUNC_NAME
}


#ifdef __cplusplus
extern "C" {
#endif

/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (BEGIN) -------- */

static swig_type_info _swigt__p_Account = {"_p_Account", "Account *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GList = {"_p_GList", "GList *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GNCLot = {"_p_GNCLot", "GNCLot *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GNCPrice = {"_p_GNCPrice", "GNCPrice *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GType = {"_p_GType", "GType *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GncAmountType = {"_p_GncAmountType", "enum GncAmountType *|GncAmountType *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GncBillTermType = {"_p_GncBillTermType", "enum GncBillTermType *|GncBillTermType *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GncDiscountHow = {"_p_GncDiscountHow", "enum GncDiscountHow *|GncDiscountHow *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GncEntryPaymentType = {"_p_GncEntryPaymentType", "enum GncEntryPaymentType *|GncEntryPaymentType *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GncGUID = {"_p_GncGUID", "GncGUID *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GncOwnerType = {"_p_GncOwnerType", "enum GncOwnerType *|GncOwnerType *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_GncTaxIncluded = {"_p_GncTaxIncluded", "enum GncTaxIncluded *|GncTaxIncluded *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_KvpFrame = {"_p_KvpFrame", "KvpFrame *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_QofBook = {"_p_QofBook", "QofBook *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_QofIdType = {"_p_QofIdType", "QofIdType *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_QofIdTypeConst = {"_p_QofIdTypeConst", "QofIdTypeConst *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_QofInstance = {"_p_QofInstance", "QofInstance *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_QofQueryOp = {"_p_QofQueryOp", "enum QofQueryOp *|QofQueryOp *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_Timespec = {"_p_Timespec", "Timespec *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_Transaction = {"_p_Transaction", "Transaction *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__QofQuery = {"_p__QofQuery", "struct _QofQuery *|QofQuery *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncAccountValue = {"_p__gncAccountValue", "struct _gncAccountValue *|GncAccountValue *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncAddress = {"_p__gncAddress", "struct _gncAddress *|GncAddress *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncAddressClass = {"_p__gncAddressClass", "struct _gncAddressClass *|GncAddressClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncBillTerm = {"_p__gncBillTerm", "struct _gncBillTerm *|GncBillTerm *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncBillTermClass = {"_p__gncBillTermClass", "struct _gncBillTermClass *|GncBillTermClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncCustomer = {"_p__gncCustomer", "struct _gncCustomer *|GncCustomer *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncCustomerClass = {"_p__gncCustomerClass", "struct _gncCustomerClass *|GncCustomerClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncEmployee = {"_p__gncEmployee", "struct _gncEmployee *|GncEmployee *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncEmployeeClass = {"_p__gncEmployeeClass", "struct _gncEmployeeClass *|GncEmployeeClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncEntry = {"_p__gncEntry", "struct _gncEntry *|GncEntry *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncEntryClass = {"_p__gncEntryClass", "struct _gncEntryClass *|GncEntryClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncInvoice = {"_p__gncInvoice", "struct _gncInvoice *|GncInvoice *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncInvoiceClass = {"_p__gncInvoiceClass", "struct _gncInvoiceClass *|GncInvoiceClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncJob = {"_p__gncJob", "struct _gncJob *|GncJob *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncJobClass = {"_p__gncJobClass", "struct _gncJobClass *|GncJobClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncOrder = {"_p__gncOrder", "struct _gncOrder *|GncOrder *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncOrderClass = {"_p__gncOrderClass", "struct _gncOrderClass *|GncOrderClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncOwner = {"_p__gncOwner", "struct _gncOwner *|GncOwner *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncTaxTable = {"_p__gncTaxTable", "struct _gncTaxTable *|GncTaxTable *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncTaxTableClass = {"_p__gncTaxTableClass", "struct _gncTaxTableClass *|GncTaxTableClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncTaxTableEntry = {"_p__gncTaxTableEntry", "struct _gncTaxTableEntry *|GncTaxTableEntry *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncVendor = {"_p__gncVendor", "struct _gncVendor *|GncVendor *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p__gncVendorClass = {"_p__gncVendorClass", "struct _gncVendorClass *|GncVendorClass *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_char = {"_p_char", "char *|gchar *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_double = {"_p_double", "double *|gdouble *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_float = {"_p_float", "float *|gfloat *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_gboolean = {"_p_gboolean", "gboolean *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_gnc_commodity = {"_p_gnc_commodity", "gnc_commodity *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_gnc_numeric = {"_p_gnc_numeric", "gnc_numeric *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_int = {"_p_int", "int *|time_t *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_p_GList = {"_p_p_GList", "GList **", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_unsigned_int = {"_p_unsigned_int", "unsigned int *|guint *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_unsigned_long = {"_p_unsigned_long", "unsigned long *|SCM *", 0, 0, (void*)0, 0};
static swig_type_info _swigt__p_void = {"_p_void", "void *|gpointer", 0, 0, (void*)0, 0};

static swig_type_info *swig_type_initial[] = {
  &_swigt__p_Account,
  &_swigt__p_GList,
  &_swigt__p_GNCLot,
  &_swigt__p_GNCPrice,
  &_swigt__p_GType,
  &_swigt__p_GncAmountType,
  &_swigt__p_GncBillTermType,
  &_swigt__p_GncDiscountHow,
  &_swigt__p_GncEntryPaymentType,
  &_swigt__p_GncGUID,
  &_swigt__p_GncOwnerType,
  &_swigt__p_GncTaxIncluded,
  &_swigt__p_KvpFrame,
  &_swigt__p_QofBook,
  &_swigt__p_QofIdType,
  &_swigt__p_QofIdTypeConst,
  &_swigt__p_QofInstance,
  &_swigt__p_QofQueryOp,
  &_swigt__p_Timespec,
  &_swigt__p_Transaction,
  &_swigt__p__QofQuery,
  &_swigt__p__gncAccountValue,
  &_swigt__p__gncAddress,
  &_swigt__p__gncAddressClass,
  &_swigt__p__gncBillTerm,
  &_swigt__p__gncBillTermClass,
  &_swigt__p__gncCustomer,
  &_swigt__p__gncCustomerClass,
  &_swigt__p__gncEmployee,
  &_swigt__p__gncEmployeeClass,
  &_swigt__p__gncEntry,
  &_swigt__p__gncEntryClass,
  &_swigt__p__gncInvoice,
  &_swigt__p__gncInvoiceClass,
  &_swigt__p__gncJob,
  &_swigt__p__gncJobClass,
  &_swigt__p__gncOrder,
  &_swigt__p__gncOrderClass,
  &_swigt__p__gncOwner,
  &_swigt__p__gncTaxTable,
  &_swigt__p__gncTaxTableClass,
  &_swigt__p__gncTaxTableEntry,
  &_swigt__p__gncVendor,
  &_swigt__p__gncVendorClass,
  &_swigt__p_char,
  &_swigt__p_double,
  &_swigt__p_float,
  &_swigt__p_gboolean,
  &_swigt__p_gnc_commodity,
  &_swigt__p_gnc_numeric,
  &_swigt__p_int,
  &_swigt__p_p_GList,
  &_swigt__p_unsigned_int,
  &_swigt__p_unsigned_long,
  &_swigt__p_void,
};

static swig_cast_info _swigc__p_Account[] = {  {&_swigt__p_Account, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GList[] = {  {&_swigt__p_GList, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GNCLot[] = {  {&_swigt__p_GNCLot, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GNCPrice[] = {  {&_swigt__p_GNCPrice, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GType[] = {  {&_swigt__p_GType, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GncAmountType[] = {  {&_swigt__p_GncAmountType, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GncBillTermType[] = {  {&_swigt__p_GncBillTermType, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GncDiscountHow[] = {  {&_swigt__p_GncDiscountHow, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GncEntryPaymentType[] = {  {&_swigt__p_GncEntryPaymentType, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GncGUID[] = {  {&_swigt__p_GncGUID, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GncOwnerType[] = {  {&_swigt__p_GncOwnerType, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_GncTaxIncluded[] = {  {&_swigt__p_GncTaxIncluded, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_KvpFrame[] = {  {&_swigt__p_KvpFrame, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_QofBook[] = {  {&_swigt__p_QofBook, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_QofIdType[] = {  {&_swigt__p_QofIdType, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_QofIdTypeConst[] = {  {&_swigt__p_QofIdTypeConst, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_QofInstance[] = {  {&_swigt__p_QofInstance, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_QofQueryOp[] = {  {&_swigt__p_QofQueryOp, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Timespec[] = {  {&_swigt__p_Timespec, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_Transaction[] = {  {&_swigt__p_Transaction, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__QofQuery[] = {  {&_swigt__p__QofQuery, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncAccountValue[] = {  {&_swigt__p__gncAccountValue, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncAddress[] = {  {&_swigt__p__gncAddress, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncAddressClass[] = {  {&_swigt__p__gncAddressClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncBillTerm[] = {  {&_swigt__p__gncBillTerm, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncBillTermClass[] = {  {&_swigt__p__gncBillTermClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncCustomer[] = {  {&_swigt__p__gncCustomer, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncCustomerClass[] = {  {&_swigt__p__gncCustomerClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncEmployee[] = {  {&_swigt__p__gncEmployee, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncEmployeeClass[] = {  {&_swigt__p__gncEmployeeClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncEntry[] = {  {&_swigt__p__gncEntry, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncEntryClass[] = {  {&_swigt__p__gncEntryClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncInvoice[] = {  {&_swigt__p__gncInvoice, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncInvoiceClass[] = {  {&_swigt__p__gncInvoiceClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncJob[] = {  {&_swigt__p__gncJob, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncJobClass[] = {  {&_swigt__p__gncJobClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncOrder[] = {  {&_swigt__p__gncOrder, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncOrderClass[] = {  {&_swigt__p__gncOrderClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncOwner[] = {  {&_swigt__p__gncOwner, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncTaxTable[] = {  {&_swigt__p__gncTaxTable, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncTaxTableClass[] = {  {&_swigt__p__gncTaxTableClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncTaxTableEntry[] = {  {&_swigt__p__gncTaxTableEntry, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncVendor[] = {  {&_swigt__p__gncVendor, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p__gncVendorClass[] = {  {&_swigt__p__gncVendorClass, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_char[] = {  {&_swigt__p_char, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_double[] = {  {&_swigt__p_double, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_float[] = {  {&_swigt__p_float, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_gboolean[] = {  {&_swigt__p_gboolean, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_gnc_commodity[] = {  {&_swigt__p_gnc_commodity, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_gnc_numeric[] = {  {&_swigt__p_gnc_numeric, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_int[] = {  {&_swigt__p_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_p_GList[] = {  {&_swigt__p_p_GList, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_unsigned_int[] = {  {&_swigt__p_unsigned_int, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_unsigned_long[] = {  {&_swigt__p_unsigned_long, 0, 0, 0},{0, 0, 0, 0}};
static swig_cast_info _swigc__p_void[] = {  {&_swigt__p_void, 0, 0, 0},{0, 0, 0, 0}};

static swig_cast_info *swig_cast_initial[] = {
  _swigc__p_Account,
  _swigc__p_GList,
  _swigc__p_GNCLot,
  _swigc__p_GNCPrice,
  _swigc__p_GType,
  _swigc__p_GncAmountType,
  _swigc__p_GncBillTermType,
  _swigc__p_GncDiscountHow,
  _swigc__p_GncEntryPaymentType,
  _swigc__p_GncGUID,
  _swigc__p_GncOwnerType,
  _swigc__p_GncTaxIncluded,
  _swigc__p_KvpFrame,
  _swigc__p_QofBook,
  _swigc__p_QofIdType,
  _swigc__p_QofIdTypeConst,
  _swigc__p_QofInstance,
  _swigc__p_QofQueryOp,
  _swigc__p_Timespec,
  _swigc__p_Transaction,
  _swigc__p__QofQuery,
  _swigc__p__gncAccountValue,
  _swigc__p__gncAddress,
  _swigc__p__gncAddressClass,
  _swigc__p__gncBillTerm,
  _swigc__p__gncBillTermClass,
  _swigc__p__gncCustomer,
  _swigc__p__gncCustomerClass,
  _swigc__p__gncEmployee,
  _swigc__p__gncEmployeeClass,
  _swigc__p__gncEntry,
  _swigc__p__gncEntryClass,
  _swigc__p__gncInvoice,
  _swigc__p__gncInvoiceClass,
  _swigc__p__gncJob,
  _swigc__p__gncJobClass,
  _swigc__p__gncOrder,
  _swigc__p__gncOrderClass,
  _swigc__p__gncOwner,
  _swigc__p__gncTaxTable,
  _swigc__p__gncTaxTableClass,
  _swigc__p__gncTaxTableEntry,
  _swigc__p__gncVendor,
  _swigc__p__gncVendorClass,
  _swigc__p_char,
  _swigc__p_double,
  _swigc__p_float,
  _swigc__p_gboolean,
  _swigc__p_gnc_commodity,
  _swigc__p_gnc_numeric,
  _swigc__p_int,
  _swigc__p_p_GList,
  _swigc__p_unsigned_int,
  _swigc__p_unsigned_long,
  _swigc__p_void,
};


/* -------- TYPE CONVERSION AND EQUIVALENCE RULES (END) -------- */

/* -----------------------------------------------------------------------------
 * Type initialization:
 * This problem is tough by the requirement that no dynamic 
 * memory is used. Also, since swig_type_info structures store pointers to 
 * swig_cast_info structures and swig_cast_info structures store pointers back
 * to swig_type_info structures, we need some lookup code at initialization. 
 * The idea is that swig generates all the structures that are needed. 
 * The runtime then collects these partially filled structures. 
 * The SWIG_InitializeModule function takes these initial arrays out of 
 * swig_module, and does all the lookup, filling in the swig_module.types
 * array with the correct data and linking the correct swig_cast_info
 * structures together.
 *
 * The generated swig_type_info structures are assigned staticly to an initial 
 * array. We just loop through that array, and handle each type individually.
 * First we lookup if this type has been already loaded, and if so, use the
 * loaded structure instead of the generated one. Then we have to fill in the
 * cast linked list. The cast data is initially stored in something like a
 * two-dimensional array. Each row corresponds to a type (there are the same
 * number of rows as there are in the swig_type_initial array). Each entry in
 * a column is one of the swig_cast_info structures for that type.
 * The cast_initial array is actually an array of arrays, because each row has
 * a variable number of columns. So to actually build the cast linked list,
 * we find the array of casts associated with the type, and loop through it 
 * adding the casts to the list. The one last trick we need to do is making
 * sure the type pointer in the swig_cast_info struct is correct.
 *
 * First off, we lookup the cast->type name to see if it is already loaded. 
 * There are three cases to handle:
 *  1) If the cast->type has already been loaded AND the type we are adding
 *     casting info to has not been loaded (it is in this module), THEN we
 *     replace the cast->type pointer with the type pointer that has already
 *     been loaded.
 *  2) If BOTH types (the one we are adding casting info to, and the 
 *     cast->type) are loaded, THEN the cast info has already been loaded by
 *     the previous module so we just ignore it.
 *  3) Finally, if cast->type has not already been loaded, then we add that
 *     swig_cast_info to the linked list (because the cast->type) pointer will
 *     be correct.
 * ----------------------------------------------------------------------------- */

#ifdef __cplusplus
extern "C" {
#if 0
} /* c-mode */
#endif
#endif

#if 0
#define SWIGRUNTIME_DEBUG
#endif


SWIGRUNTIME void
SWIG_InitializeModule(void *clientdata) {
  size_t i;
  swig_module_info *module_head, *iter;
  int found;
  
  clientdata = clientdata;
  
  /* check to see if the circular list has been setup, if not, set it up */
  if (swig_module.next==0) {
    /* Initialize the swig_module */
    swig_module.type_initial = swig_type_initial;
    swig_module.cast_initial = swig_cast_initial;
    swig_module.next = &swig_module;
  }
  
  /* Try and load any already created modules */
  module_head = SWIG_GetModule(clientdata);
  if (!module_head) {
    /* This is the first module loaded for this interpreter */
    /* so set the swig module into the interpreter */
    SWIG_SetModule(clientdata, &swig_module);
    module_head = &swig_module;
  } else {
    /* the interpreter has loaded a SWIG module, but has it loaded this one? */
    found=0;
    iter=module_head;
    do {
      if (iter==&swig_module) {
        found=1;
        break;
      }
      iter=iter->next;
    } while (iter!= module_head);
    
    /* if the is found in the list, then all is done and we may leave */
    if (found) return;
    /* otherwise we must add out module into the list */
    swig_module.next = module_head->next;
    module_head->next = &swig_module;
  }
  
  /* Now work on filling in swig_module.types */
#ifdef SWIGRUNTIME_DEBUG
  printf("SWIG_InitializeModule: size %d\n", swig_module.size);
#endif
  for (i = 0; i < swig_module.size; ++i) {
    swig_type_info *type = 0;
    swig_type_info *ret;
    swig_cast_info *cast;
    
#ifdef SWIGRUNTIME_DEBUG
    printf("SWIG_InitializeModule: type %d %s\n", i, swig_module.type_initial[i]->name);
#endif
    
    /* if there is another module already loaded */
    if (swig_module.next != &swig_module) {
      type = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, swig_module.type_initial[i]->name);
    }
    if (type) {
      /* Overwrite clientdata field */
#ifdef SWIGRUNTIME_DEBUG
      printf("SWIG_InitializeModule: found type %s\n", type->name);
#endif
      if (swig_module.type_initial[i]->clientdata) {
        type->clientdata = swig_module.type_initial[i]->clientdata;
#ifdef SWIGRUNTIME_DEBUG
        printf("SWIG_InitializeModule: found and overwrite type %s \n", type->name);
#endif
      }
    } else {
      type = swig_module.type_initial[i];
    }
    
    /* Insert casting types */
    cast = swig_module.cast_initial[i];
    while (cast->type) {
      /* Don't need to add information already in the list */
      ret = 0;
#ifdef SWIGRUNTIME_DEBUG
      printf("SWIG_InitializeModule: look cast %s\n", cast->type->name);
#endif
      if (swig_module.next != &swig_module) {
        ret = SWIG_MangledTypeQueryModule(swig_module.next, &swig_module, cast->type->name);
#ifdef SWIGRUNTIME_DEBUG
        if (ret) printf("SWIG_InitializeModule: found cast %s\n", ret->name);
#endif
      }
      if (ret) {
        if (type == swig_module.type_initial[i]) {
#ifdef SWIGRUNTIME_DEBUG
          printf("SWIG_InitializeModule: skip old type %s\n", ret->name);
#endif
          cast->type = ret;
          ret = 0;
        } else {
          /* Check for casting already in the list */
          swig_cast_info *ocast = SWIG_TypeCheck(ret->name, type);
#ifdef SWIGRUNTIME_DEBUG
          if (ocast) printf("SWIG_InitializeModule: skip old cast %s\n", ret->name);
#endif
          if (!ocast) ret = 0;
        }
      }
      
      if (!ret) {
#ifdef SWIGRUNTIME_DEBUG
        printf("SWIG_InitializeModule: adding cast %s\n", cast->type->name);
#endif
        if (type->cast) {
          type->cast->prev = cast;
          cast->next = type->cast;
        }
        type->cast = cast;
      }
      cast++;
    }
    /* Set entry in modules->types array equal to the type */
    swig_module.types[i] = type;
  }
  swig_module.types[i] = 0;
  
#ifdef SWIGRUNTIME_DEBUG
  printf("**** SWIG_InitializeModule: Cast List ******\n");
  for (i = 0; i < swig_module.size; ++i) {
    int j = 0;
    swig_cast_info *cast = swig_module.cast_initial[i];
    printf("SWIG_InitializeModule: type %d %s\n", i, swig_module.type_initial[i]->name);
    while (cast->type) {
      printf("SWIG_InitializeModule: cast type %s\n", cast->type->name);
      cast++;
      ++j;
    }
    printf("---- Total casts: %d\n",j);
  }
  printf("**** SWIG_InitializeModule: Cast List ******\n");
#endif
}

/* This function will propagate the clientdata field of type to
* any new swig_type_info structures that have been added into the list
* of equivalent types.  It is like calling
* SWIG_TypeClientData(type, clientdata) a second time.
*/
SWIGRUNTIME void
SWIG_PropagateClientData(void) {
  size_t i;
  swig_cast_info *equiv;
  static int init_run = 0;
  
  if (init_run) return;
  init_run = 1;
  
  for (i = 0; i < swig_module.size; i++) {
    if (swig_module.types[i]->clientdata) {
      equiv = swig_module.types[i]->cast;
      while (equiv) {
        if (!equiv->converter) {
          if (equiv->type && !equiv->type->clientdata)
          SWIG_TypeClientData(equiv->type, swig_module.types[i]->clientdata);
        }
        equiv = equiv->next;
      }
    }
  }
}

#ifdef __cplusplus
#if 0
{
  /* c-mode */
#endif
}
#endif


SWIG_GUILE_INIT_STATIC void
SWIG_init(void)
{
  SWIG_InitializeModule(0);
  SWIG_PropagateClientData();
  
  scm_c_define_gsubr("gncTaxTableReturnGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableReturnGUID);
  scm_c_define_gsubr("gncInvoiceReturnGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceReturnGUID);
  scm_c_define_gsubr("gncJobReturnGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncJobReturnGUID);
  scm_c_define_gsubr("gncVendorReturnGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorReturnGUID);
  scm_c_define_gsubr("gncCustomerReturnGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerReturnGUID);
  scm_c_define_gsubr("gncEmployeeReturnGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeReturnGUID);
  scm_c_define_gsubr("gncTaxTableLookupFlip", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableLookupFlip);
  scm_c_define_gsubr("gncInvoiceLookupFlip", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceLookupFlip);
  scm_c_define_gsubr("gncJobLookupFlip", 2, 0, 0, (swig_guile_proc) _wrap_gncJobLookupFlip);
  scm_c_define_gsubr("gncVendorLookupFlip", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorLookupFlip);
  scm_c_define_gsubr("gncCustomerLookupFlip", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerLookupFlip);
  scm_c_define_gsubr("gncEmployeeLookupFlip", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeLookupFlip);
  scm_c_define_gsubr("GNC-ADDRESS-MODULE-NAME", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ADDRESS_MODULE_NAME);
  scm_c_define_gsubr("GNC-ID-ADDRESS", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_ADDRESS);
  scm_c_define_gsubr("gnc-address-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_address_get_type);
  scm_c_define_gsubr("gncAddressCreate", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressCreate);
  scm_c_define_gsubr("gncAddressDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressDestroy);
  scm_c_define_gsubr("gncAddressBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressBeginEdit);
  scm_c_define_gsubr("gncAddressCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressCommitEdit);
  scm_c_define_gsubr("gncAddressSetName", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressSetName);
  scm_c_define_gsubr("gncAddressSetAddr1", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressSetAddr1);
  scm_c_define_gsubr("gncAddressSetAddr2", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressSetAddr2);
  scm_c_define_gsubr("gncAddressSetAddr3", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressSetAddr3);
  scm_c_define_gsubr("gncAddressSetAddr4", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressSetAddr4);
  scm_c_define_gsubr("gncAddressSetPhone", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressSetPhone);
  scm_c_define_gsubr("gncAddressSetFax", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressSetFax);
  scm_c_define_gsubr("gncAddressSetEmail", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressSetEmail);
  scm_c_define_gsubr("gncAddressClearDirty", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressClearDirty);
  scm_c_define_gsubr("gncAddressGetName", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressGetName);
  scm_c_define_gsubr("gncAddressGetAddr1", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressGetAddr1);
  scm_c_define_gsubr("gncAddressGetAddr2", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressGetAddr2);
  scm_c_define_gsubr("gncAddressGetAddr3", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressGetAddr3);
  scm_c_define_gsubr("gncAddressGetAddr4", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressGetAddr4);
  scm_c_define_gsubr("gncAddressGetPhone", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressGetPhone);
  scm_c_define_gsubr("gncAddressGetFax", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressGetFax);
  scm_c_define_gsubr("gncAddressGetEmail", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressGetEmail);
  scm_c_define_gsubr("gncAddressIsDirty", 1, 0, 0, (swig_guile_proc) _wrap_gncAddressIsDirty);
  scm_c_define_gsubr("gncAddressCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressCompare);
  scm_c_define_gsubr("gncAddressEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncAddressEqual);
  scm_c_define_gsubr("ADDRESS-NAME", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_NAME);
  scm_c_define_gsubr("ADDRESS-ONE", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_ONE);
  scm_c_define_gsubr("ADDRESS-TWO", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_TWO);
  scm_c_define_gsubr("ADDRESS-THREE", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_THREE);
  scm_c_define_gsubr("ADDRESS-FOUR", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_FOUR);
  scm_c_define_gsubr("ADDRESS-PHONE", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_PHONE);
  scm_c_define_gsubr("ADDRESS-FAX", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_FAX);
  scm_c_define_gsubr("ADDRESS-EMAIL", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_EMAIL);
  scm_c_define_gsubr("ADDRESS-OWNER", 0, 0, 0, (swig_guile_proc) _wrap_ADDRESS_OWNER);
  scm_c_define_gsubr("GNC-ID-BILLTERM", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_BILLTERM);
  scm_c_define_gsubr("gnc-billterm-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_billterm_get_type);
  scm_c_define_gsubr("GNC-BILLTERM-NAME", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_NAME);
  scm_c_define_gsubr("GNC-BILLTERM-DESC", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_DESC);
  scm_c_define_gsubr("GNC-BILLTERM-DUEDAYS", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_DUEDAYS);
  scm_c_define_gsubr("GNC-BILLTERM-DISCDAYS", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_DISCDAYS);
  scm_c_define_gsubr("GNC-BILLTERM-CUTOFF", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_CUTOFF);
  scm_c_define_gsubr("GNC-BILLTERM-TYPE", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_TYPE);
  scm_c_define_gsubr("GNC-BILLTERM-DISCOUNT", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_DISCOUNT);
  scm_c_define_gsubr("GNC-BILLTERM-REFCOUNT", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_REFCOUNT);
  scm_c_define_gsubr("GNC-TERM-TYPE-DAYS", 0, 0, 0, (swig_guile_proc) _wrap_GNC_TERM_TYPE_DAYS);
  scm_c_define_gsubr("GNC-TERM-TYPE-PROXIMO", 0, 0, 0, (swig_guile_proc) _wrap_GNC_TERM_TYPE_PROXIMO);
  scm_c_define_gsubr("gncBillTermCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermCreate);
  scm_c_define_gsubr("gncBillTermDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermDestroy);
  scm_c_define_gsubr("gncBillTermIncRef", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermIncRef);
  scm_c_define_gsubr("gncBillTermDecRef", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermDecRef);
  scm_c_define_gsubr("gncBillTermChanged", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermChanged);
  scm_c_define_gsubr("gncBillTermBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermBeginEdit);
  scm_c_define_gsubr("gncBillTermCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermCommitEdit);
  scm_c_define_gsubr("gncBillTermSetName", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermSetName);
  scm_c_define_gsubr("gncBillTermSetDescription", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermSetDescription);
  scm_c_define_gsubr("gncBillTermSetType", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermSetType);
  scm_c_define_gsubr("gncBillTermSetDueDays", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermSetDueDays);
  scm_c_define_gsubr("gncBillTermSetDiscountDays", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermSetDiscountDays);
  scm_c_define_gsubr("gncBillTermSetDiscount", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermSetDiscount);
  scm_c_define_gsubr("gncBillTermSetCutoff", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermSetCutoff);
  scm_c_define_gsubr("gncBillTermLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermLookup);
  scm_c_define_gsubr("gncBillTermLookupByName", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermLookupByName);
  scm_c_define_gsubr("gncBillTermGetTerms", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetTerms);
  scm_c_define_gsubr("gncBillTermGetName", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetName);
  scm_c_define_gsubr("gncBillTermGetDescription", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetDescription);
  scm_c_define_gsubr("gncBillTermGetType", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetType);
  scm_c_define_gsubr("gncBillTermGetDueDays", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetDueDays);
  scm_c_define_gsubr("gncBillTermGetDiscountDays", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetDiscountDays);
  scm_c_define_gsubr("gncBillTermGetDiscount", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetDiscount);
  scm_c_define_gsubr("gncBillTermGetCutoff", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetCutoff);
  scm_c_define_gsubr("gncBillTermIsDirty", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermIsDirty);
  scm_c_define_gsubr("gncBillTermGetParent", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetParent);
  scm_c_define_gsubr("gncBillTermReturnChild", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermReturnChild);
  scm_c_define_gsubr("gncBillTermGetRefcount", 1, 0, 0, (swig_guile_proc) _wrap_gncBillTermGetRefcount);
  scm_c_define_gsubr("gncBillTermCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermCompare);
  scm_c_define_gsubr("gncBillTermEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermEqual);
  scm_c_define_gsubr("gncBillTermComputeDueDate", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermComputeDueDate);
  scm_c_define_gsubr("gncBillTermComputeDiscountDate", 2, 0, 0, (swig_guile_proc) _wrap_gncBillTermComputeDiscountDate);
  scm_c_define_gsubr("GNC-BILLTERM-MODULE-NAME", 0, 0, 0, (swig_guile_proc) _wrap_GNC_BILLTERM_MODULE_NAME);
  scm_c_define_gsubr("gncBusinessGetList", 3, 0, 0, (swig_guile_proc) _wrap_gncBusinessGetList);
  scm_c_define_gsubr("gncBusinessGetOwnerList", 3, 0, 0, (swig_guile_proc) _wrap_gncBusinessGetOwnerList);
  scm_c_define_gsubr("GNC-ID-CUSTOMER", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_CUSTOMER);
  scm_c_define_gsubr("gnc-customer-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_customer_get_type);
  scm_c_define_gsubr("gncCustomerCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerCreate);
  scm_c_define_gsubr("gncCustomerDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerDestroy);
  scm_c_define_gsubr("gncCustomerBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerBeginEdit);
  scm_c_define_gsubr("gncCustomerCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerCommitEdit);
  scm_c_define_gsubr("gncCustomerSetID", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetID);
  scm_c_define_gsubr("gncCustomerSetName", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetName);
  scm_c_define_gsubr("gncCustomerSetNotes", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetNotes);
  scm_c_define_gsubr("gncCustomerSetTerms", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetTerms);
  scm_c_define_gsubr("gncCustomerSetTaxIncluded", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetTaxIncluded);
  scm_c_define_gsubr("gncCustomerSetActive", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetActive);
  scm_c_define_gsubr("gncCustomerSetDiscount", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetDiscount);
  scm_c_define_gsubr("gncCustomerSetCredit", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetCredit);
  scm_c_define_gsubr("gncCustomerSetCurrency", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetCurrency);
  scm_c_define_gsubr("gncCustomerSetTaxTableOverride", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetTaxTableOverride);
  scm_c_define_gsubr("gncCustomerSetTaxTable", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerSetTaxTable);
  scm_c_define_gsubr("gncCustomerAddJob", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerAddJob);
  scm_c_define_gsubr("gncCustomerRemoveJob", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerRemoveJob);
  scm_c_define_gsubr("gncCustomerLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerLookup);
  scm_c_define_gsubr("gncCustomerGetID", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetID);
  scm_c_define_gsubr("gncCustomerGetName", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetName);
  scm_c_define_gsubr("gncCustomerGetAddr", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetAddr);
  scm_c_define_gsubr("gncCustomerGetShipAddr", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetShipAddr);
  scm_c_define_gsubr("gncCustomerGetNotes", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetNotes);
  scm_c_define_gsubr("gncCustomerGetTerms", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetTerms);
  scm_c_define_gsubr("gncCustomerGetTaxIncluded", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetTaxIncluded);
  scm_c_define_gsubr("gncCustomerGetActive", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetActive);
  scm_c_define_gsubr("gncCustomerGetDiscount", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetDiscount);
  scm_c_define_gsubr("gncCustomerGetCredit", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetCredit);
  scm_c_define_gsubr("gncCustomerGetCurrency", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetCurrency);
  scm_c_define_gsubr("gncCustomerGetTaxTableOverride", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetTaxTableOverride);
  scm_c_define_gsubr("gncCustomerGetTaxTable", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetTaxTable);
  scm_c_define_gsubr("gncCustomerGetJoblist", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerGetJoblist);
  scm_c_define_gsubr("gncCustomerIsDirty", 1, 0, 0, (swig_guile_proc) _wrap_gncCustomerIsDirty);
  scm_c_define_gsubr("gncCustomerCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerCompare);
  scm_c_define_gsubr("gncCustomerEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncCustomerEqual);
  scm_c_define_gsubr("CUSTOMER-ID", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_ID);
  scm_c_define_gsubr("CUSTOMER-NAME", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_NAME);
  scm_c_define_gsubr("CUSTOMER-ADDR", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_ADDR);
  scm_c_define_gsubr("CUSTOMER-SHIPADDR", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_SHIPADDR);
  scm_c_define_gsubr("CUSTOMER-NOTES", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_NOTES);
  scm_c_define_gsubr("CUSTOMER-DISCOUNT", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_DISCOUNT);
  scm_c_define_gsubr("CUSTOMER-CREDIT", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_CREDIT);
  scm_c_define_gsubr("CUSTOMER-TT-OVER", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_TT_OVER);
  scm_c_define_gsubr("CUSTOMER-TAX-INC", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_TAX_INC);
  scm_c_define_gsubr("CUSTOMER-TERMS", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_TERMS);
  scm_c_define_gsubr("CUSTOMER-ACTIVE", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_ACTIVE);
  scm_c_define_gsubr("CUSTOMER-SLOTS", 0, 0, 0, (swig_guile_proc) _wrap_CUSTOMER_SLOTS);
  scm_c_define_gsubr("GNC-ID-EMPLOYEE", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_EMPLOYEE);
  scm_c_define_gsubr("gnc-employee-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_employee_get_type);
  scm_c_define_gsubr("gncEmployeeCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeCreate);
  scm_c_define_gsubr("gncEmployeeDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeDestroy);
  scm_c_define_gsubr("gncEmployeeBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeBeginEdit);
  scm_c_define_gsubr("gncEmployeeCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeCommitEdit);
  scm_c_define_gsubr("gncEmployeeCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeCompare);
  scm_c_define_gsubr("gncEmployeeSetID", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetID);
  scm_c_define_gsubr("gncEmployeeSetUsername", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetUsername);
  scm_c_define_gsubr("gncEmployeeSetLanguage", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetLanguage);
  scm_c_define_gsubr("gncEmployeeSetAcl", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetAcl);
  scm_c_define_gsubr("gncEmployeeSetWorkday", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetWorkday);
  scm_c_define_gsubr("gncEmployeeSetRate", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetRate);
  scm_c_define_gsubr("gncEmployeeSetCurrency", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetCurrency);
  scm_c_define_gsubr("gncEmployeeSetActive", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetActive);
  scm_c_define_gsubr("gncEmployeeSetCCard", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeSetCCard);
  scm_c_define_gsubr("qofEmployeeSetAddr", 2, 0, 0, (swig_guile_proc) _wrap_qofEmployeeSetAddr);
  scm_c_define_gsubr("gncEmployeeGetBook", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetBook);
  scm_c_define_gsubr("gncEmployeeGetID", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetID);
  scm_c_define_gsubr("gncEmployeeGetUsername", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetUsername);
  scm_c_define_gsubr("gncEmployeeGetAddr", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetAddr);
  scm_c_define_gsubr("gncEmployeeGetLanguage", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetLanguage);
  scm_c_define_gsubr("gncEmployeeGetAcl", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetAcl);
  scm_c_define_gsubr("gncEmployeeGetWorkday", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetWorkday);
  scm_c_define_gsubr("gncEmployeeGetRate", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetRate);
  scm_c_define_gsubr("gncEmployeeGetCurrency", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetCurrency);
  scm_c_define_gsubr("gncEmployeeGetActive", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetActive);
  scm_c_define_gsubr("gncEmployeeGetCCard", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeGetCCard);
  scm_c_define_gsubr("gncEmployeeLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeLookup);
  scm_c_define_gsubr("gncEmployeeIsDirty", 1, 0, 0, (swig_guile_proc) _wrap_gncEmployeeIsDirty);
  scm_c_define_gsubr("gncEmployeeEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncEmployeeEqual);
  scm_c_define_gsubr("EMPLOYEE-ID", 0, 0, 0, (swig_guile_proc) _wrap_EMPLOYEE_ID);
  scm_c_define_gsubr("EMPLOYEE-USERNAME", 0, 0, 0, (swig_guile_proc) _wrap_EMPLOYEE_USERNAME);
  scm_c_define_gsubr("EMPLOYEE-ADDR", 0, 0, 0, (swig_guile_proc) _wrap_EMPLOYEE_ADDR);
  scm_c_define_gsubr("EMPLOYEE-LANGUAGE", 0, 0, 0, (swig_guile_proc) _wrap_EMPLOYEE_LANGUAGE);
  scm_c_define_gsubr("EMPLOYEE-ACL", 0, 0, 0, (swig_guile_proc) _wrap_EMPLOYEE_ACL);
  scm_c_define_gsubr("EMPLOYEE-WORKDAY", 0, 0, 0, (swig_guile_proc) _wrap_EMPLOYEE_WORKDAY);
  scm_c_define_gsubr("EMPLOYEE-RATE", 0, 0, 0, (swig_guile_proc) _wrap_EMPLOYEE_RATE);
  scm_c_define_gsubr("EMPLOYEE-CC", 0, 0, 0, (swig_guile_proc) _wrap_EMPLOYEE_CC);
  scm_c_define_gsubr("GNC-PAYMENT-CASH", 0, 0, 0, (swig_guile_proc) _wrap_GNC_PAYMENT_CASH);
  scm_c_define_gsubr("GNC-PAYMENT-CARD", 0, 0, 0, (swig_guile_proc) _wrap_GNC_PAYMENT_CARD);
  scm_c_define_gsubr("GNC-DISC-PRETAX", 0, 0, 0, (swig_guile_proc) _wrap_GNC_DISC_PRETAX);
  scm_c_define_gsubr("GNC-DISC-SAMETIME", 0, 0, 0, (swig_guile_proc) _wrap_GNC_DISC_SAMETIME);
  scm_c_define_gsubr("GNC-DISC-POSTTAX", 0, 0, 0, (swig_guile_proc) _wrap_GNC_DISC_POSTTAX);
  scm_c_define_gsubr("GNC-ID-ENTRY", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_ENTRY);
  scm_c_define_gsubr("gnc-entry-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_entry_get_type);
  scm_c_define_gsubr("gncEntryDiscountHowToString", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryDiscountHowToString);
  scm_c_define_gsubr("gncEntryDiscountStringToHow", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryDiscountStringToHow);
  scm_c_define_gsubr("gncEntryPaymentTypeToString", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryPaymentTypeToString);
  scm_c_define_gsubr("gncEntryPaymentStringToType", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryPaymentStringToType);
  scm_c_define_gsubr("gncEntryCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryCreate);
  scm_c_define_gsubr("gncEntryDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryDestroy);
  scm_c_define_gsubr("gncEntrySetDate", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetDate);
  scm_c_define_gsubr("gncEntrySetDateEntered", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetDateEntered);
  scm_c_define_gsubr("gncEntrySetDescription", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetDescription);
  scm_c_define_gsubr("gncEntrySetAction", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetAction);
  scm_c_define_gsubr("gncEntrySetNotes", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetNotes);
  scm_c_define_gsubr("gncEntrySetQuantity", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetQuantity);
  scm_c_define_gsubr("gncEntrySetInvAccount", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetInvAccount);
  scm_c_define_gsubr("gncEntrySetInvPrice", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetInvPrice);
  scm_c_define_gsubr("gncEntrySetInvTaxable", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetInvTaxable);
  scm_c_define_gsubr("gncEntrySetInvTaxIncluded", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetInvTaxIncluded);
  scm_c_define_gsubr("gncEntrySetInvTaxTable", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetInvTaxTable);
  scm_c_define_gsubr("gncEntrySetInvDiscount", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetInvDiscount);
  scm_c_define_gsubr("gncEntrySetInvDiscountType", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetInvDiscountType);
  scm_c_define_gsubr("gncEntrySetInvDiscountHow", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetInvDiscountHow);
  scm_c_define_gsubr("qofEntrySetInvDiscType", 2, 0, 0, (swig_guile_proc) _wrap_qofEntrySetInvDiscType);
  scm_c_define_gsubr("qofEntrySetInvDiscHow", 2, 0, 0, (swig_guile_proc) _wrap_qofEntrySetInvDiscHow);
  scm_c_define_gsubr("gncEntrySetBillAccount", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetBillAccount);
  scm_c_define_gsubr("gncEntrySetBillPrice", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetBillPrice);
  scm_c_define_gsubr("gncEntrySetBillTaxable", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetBillTaxable);
  scm_c_define_gsubr("gncEntrySetBillTaxIncluded", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetBillTaxIncluded);
  scm_c_define_gsubr("gncEntrySetBillTaxTable", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetBillTaxTable);
  scm_c_define_gsubr("gncEntrySetBillable", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetBillable);
  scm_c_define_gsubr("gncEntrySetBillTo", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetBillTo);
  scm_c_define_gsubr("gncEntrySetBillPayment", 2, 0, 0, (swig_guile_proc) _wrap_gncEntrySetBillPayment);
  scm_c_define_gsubr("gncEntryGetDate", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetDate);
  scm_c_define_gsubr("gncEntryGetDateEntered", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetDateEntered);
  scm_c_define_gsubr("gncEntryGetDescription", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetDescription);
  scm_c_define_gsubr("gncEntryGetAction", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetAction);
  scm_c_define_gsubr("gncEntryGetNotes", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetNotes);
  scm_c_define_gsubr("gncEntryGetQuantity", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetQuantity);
  scm_c_define_gsubr("gncEntryGetInvAccount", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvAccount);
  scm_c_define_gsubr("gncEntryGetInvPrice", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvPrice);
  scm_c_define_gsubr("gncEntryGetInvDiscount", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvDiscount);
  scm_c_define_gsubr("gncEntryGetInvDiscountType", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvDiscountType);
  scm_c_define_gsubr("gncEntryGetInvDiscountHow", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvDiscountHow);
  scm_c_define_gsubr("qofEntryGetInvDiscType", 1, 0, 0, (swig_guile_proc) _wrap_qofEntryGetInvDiscType);
  scm_c_define_gsubr("qofEntryGetInvDiscHow", 1, 0, 0, (swig_guile_proc) _wrap_qofEntryGetInvDiscHow);
  scm_c_define_gsubr("gncEntryGetInvTaxable", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvTaxable);
  scm_c_define_gsubr("gncEntryGetInvTaxIncluded", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvTaxIncluded);
  scm_c_define_gsubr("gncEntryGetInvTaxTable", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvTaxTable);
  scm_c_define_gsubr("gncEntryGetBillAccount", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBillAccount);
  scm_c_define_gsubr("gncEntryGetBillPrice", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBillPrice);
  scm_c_define_gsubr("gncEntryGetBillTaxable", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBillTaxable);
  scm_c_define_gsubr("gncEntryGetBillTaxIncluded", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBillTaxIncluded);
  scm_c_define_gsubr("gncEntryGetBillTaxTable", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBillTaxTable);
  scm_c_define_gsubr("gncEntryGetBillable", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBillable);
  scm_c_define_gsubr("gncEntryGetBillTo", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBillTo);
  scm_c_define_gsubr("gncEntryGetBillPayment", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBillPayment);
  scm_c_define_gsubr("gncEntryCopy", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryCopy);
  scm_c_define_gsubr("gncEntryReturnValue", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryReturnValue);
  scm_c_define_gsubr("gncEntryReturnDiscountValue", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryReturnDiscountValue);
  scm_c_define_gsubr("gncEntryReturnTaxValue", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryReturnTaxValue);
  scm_c_define_gsubr("gncEntryReturnTaxValues", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryReturnTaxValues);
  scm_c_define_gsubr("gncEntryGetValue", 6, 0, 0, (swig_guile_proc) _wrap_gncEntryGetValue);
  scm_c_define_gsubr("gncEntryComputeValue", 0, 0, 1, (swig_guile_proc) _wrap_gncEntryComputeValue_rest);
  scm_c_define_gsubr("gncEntryGetOrder", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetOrder);
  scm_c_define_gsubr("gncEntryGetInvoice", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetInvoice);
  scm_c_define_gsubr("gncEntryGetBill", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryGetBill);
  scm_c_define_gsubr("gncEntryLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryLookup);
  scm_c_define_gsubr("gncEntryIsOpen", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryIsOpen);
  scm_c_define_gsubr("gncEntryBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryBeginEdit);
  scm_c_define_gsubr("gncEntryCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncEntryCommitEdit);
  scm_c_define_gsubr("gncEntryCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryCompare);
  scm_c_define_gsubr("gncEntryEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncEntryEqual);
  scm_c_define_gsubr("ENTRY-DATE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_DATE);
  scm_c_define_gsubr("ENTRY-DATE-ENTERED", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_DATE_ENTERED);
  scm_c_define_gsubr("ENTRY-DESC", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_DESC);
  scm_c_define_gsubr("ENTRY-ACTION", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_ACTION);
  scm_c_define_gsubr("ENTRY-NOTES", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_NOTES);
  scm_c_define_gsubr("ENTRY-QTY", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_QTY);
  scm_c_define_gsubr("ENTRY-IPRICE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_IPRICE);
  scm_c_define_gsubr("ENTRY-IACCT", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_IACCT);
  scm_c_define_gsubr("ENTRY-BACCT", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_BACCT);
  scm_c_define_gsubr("ENTRY-BPRICE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_BPRICE);
  scm_c_define_gsubr("ENTRY-BILLABLE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_BILLABLE);
  scm_c_define_gsubr("ENTRY-BILLTO", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_BILLTO);
  scm_c_define_gsubr("ENTRY-ORDER", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_ORDER);
  scm_c_define_gsubr("ENTRY-INVOICE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_INVOICE);
  scm_c_define_gsubr("ENTRY-BILL", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_BILL);
  scm_c_define_gsubr("ENTRY-INV-DISC-TYPE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_INV_DISC_TYPE);
  scm_c_define_gsubr("ENTRY-INV-DISC-HOW", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_INV_DISC_HOW);
  scm_c_define_gsubr("ENTRY-INV-TAXABLE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_INV_TAXABLE);
  scm_c_define_gsubr("ENTRY-BILL-TAXABLE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_BILL_TAXABLE);
  scm_c_define_gsubr("ENTRY-INV-TAX-INC", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_INV_TAX_INC);
  scm_c_define_gsubr("ENTRY-BILL-TAX-INC", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_BILL_TAX_INC);
  scm_c_define_gsubr("ENTRY-INV-DISCOUNT", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_INV_DISCOUNT);
  scm_c_define_gsubr("ENTRY-BILL-PAY-TYPE", 0, 0, 0, (swig_guile_proc) _wrap_ENTRY_BILL_PAY_TYPE);
  scm_c_define_gsubr("GNC-ID-INVOICE", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_INVOICE);
  scm_c_define_gsubr("gnc-invoice-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_invoice_get_type);
  scm_c_define_gsubr("gncInvoiceCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceCreate);
  scm_c_define_gsubr("gncInvoiceDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceDestroy);
  scm_c_define_gsubr("gncInvoiceCopy", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceCopy);
  scm_c_define_gsubr("gncInvoiceSetID", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetID);
  scm_c_define_gsubr("gncInvoiceSetOwner", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetOwner);
  scm_c_define_gsubr("gncInvoiceSetDateOpened", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetDateOpened);
  scm_c_define_gsubr("gncInvoiceSetDatePosted", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetDatePosted);
  scm_c_define_gsubr("gncInvoiceSetTerms", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetTerms);
  scm_c_define_gsubr("gncInvoiceSetBillingID", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetBillingID);
  scm_c_define_gsubr("gncInvoiceSetNotes", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetNotes);
  scm_c_define_gsubr("gncInvoiceSetCurrency", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetCurrency);
  scm_c_define_gsubr("gncInvoiceSetActive", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetActive);
  scm_c_define_gsubr("gncInvoiceSetBillTo", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetBillTo);
  scm_c_define_gsubr("gncInvoiceSetToChargeAmount", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSetToChargeAmount);
  scm_c_define_gsubr("gncInvoiceAddEntry", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceAddEntry);
  scm_c_define_gsubr("gncInvoiceRemoveEntry", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceRemoveEntry);
  scm_c_define_gsubr("gncInvoiceAddPrice", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceAddPrice);
  scm_c_define_gsubr("gncInvoiceRemovePrice", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceRemovePrice);
  scm_c_define_gsubr("gncBillAddEntry", 2, 0, 0, (swig_guile_proc) _wrap_gncBillAddEntry);
  scm_c_define_gsubr("gncBillRemoveEntry", 2, 0, 0, (swig_guile_proc) _wrap_gncBillRemoveEntry);
  scm_c_define_gsubr("gncBillAddPrice", 2, 0, 0, (swig_guile_proc) _wrap_gncBillAddPrice);
  scm_c_define_gsubr("gncBillRemovePrice", 2, 0, 0, (swig_guile_proc) _wrap_gncBillRemovePrice);
  scm_c_define_gsubr("gncInvoiceSortEntries", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceSortEntries);
  scm_c_define_gsubr("gncInvoiceGetID", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetID);
  scm_c_define_gsubr("gncInvoiceGetOwner", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetOwner);
  scm_c_define_gsubr("gncInvoiceGetDateOpened", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetDateOpened);
  scm_c_define_gsubr("gncInvoiceGetDatePosted", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetDatePosted);
  scm_c_define_gsubr("gncInvoiceGetDateDue", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetDateDue);
  scm_c_define_gsubr("gncInvoiceGetTerms", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetTerms);
  scm_c_define_gsubr("gncInvoiceGetBillingID", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetBillingID);
  scm_c_define_gsubr("gncInvoiceGetNotes", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetNotes);
  scm_c_define_gsubr("gncInvoiceGetOwnerType", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetOwnerType);
  scm_c_define_gsubr("gncInvoiceGetTypeFromOwnerType", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetTypeFromOwnerType);
  scm_c_define_gsubr("gncInvoiceGetType", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetType);
  scm_c_define_gsubr("gncInvoiceGetCurrency", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetCurrency);
  scm_c_define_gsubr("gncInvoiceGetBillTo", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetBillTo);
  scm_c_define_gsubr("gncInvoiceGetToChargeAmount", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetToChargeAmount);
  scm_c_define_gsubr("gncInvoiceGetActive", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetActive);
  scm_c_define_gsubr("gncInvoiceGetPostedLot", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetPostedLot);
  scm_c_define_gsubr("gncInvoiceGetPostedTxn", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetPostedTxn);
  scm_c_define_gsubr("gncInvoiceGetPostedAcc", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetPostedAcc);
  scm_c_define_gsubr("gncInvoiceGetTotal", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetTotal);
  scm_c_define_gsubr("gncInvoiceGetTotalOf", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetTotalOf);
  scm_c_define_gsubr("gncInvoiceGetTotalSubtotal", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetTotalSubtotal);
  scm_c_define_gsubr("gncInvoiceGetTotalTax", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetTotalTax);
  scm_c_define_gsubr("gncInvoiceGetEntries", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetEntries);
  scm_c_define_gsubr("gncInvoiceGetPrices", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetPrices);
  scm_c_define_gsubr("gncInvoiceGetPrice", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetPrice);
  scm_c_define_gsubr("gncInvoicePostToAccount", 6, 0, 0, (swig_guile_proc) _wrap_gncInvoicePostToAccount);
  scm_c_define_gsubr("gncInvoiceUnpost", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceUnpost);
  scm_c_define_gsubr("gncOwnerApplyPayment", 9, 0, 0, (swig_guile_proc) _wrap_gncOwnerApplyPayment);
  scm_c_define_gsubr("gncInvoiceGetInvoiceFromTxn", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetInvoiceFromTxn);
  scm_c_define_gsubr("gncInvoiceGetInvoiceFromLot", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetInvoiceFromLot);
  scm_c_define_gsubr("gncInvoiceLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceLookup);
  scm_c_define_gsubr("gncInvoiceBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceBeginEdit);
  scm_c_define_gsubr("gncInvoiceCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceCommitEdit);
  scm_c_define_gsubr("gncInvoiceCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceCompare);
  scm_c_define_gsubr("gncInvoiceEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncInvoiceEqual);
  scm_c_define_gsubr("gncInvoiceIsPosted", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceIsPosted);
  scm_c_define_gsubr("gncInvoiceIsPaid", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceIsPaid);
  scm_c_define_gsubr("INVOICE-ID", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_ID);
  scm_c_define_gsubr("INVOICE-OWNER", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_OWNER);
  scm_c_define_gsubr("INVOICE-OPENED", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_OPENED);
  scm_c_define_gsubr("INVOICE-POSTED", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_POSTED);
  scm_c_define_gsubr("INVOICE-DUE", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_DUE);
  scm_c_define_gsubr("INVOICE-IS-POSTED", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_IS_POSTED);
  scm_c_define_gsubr("INVOICE-IS-PAID", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_IS_PAID);
  scm_c_define_gsubr("INVOICE-TERMS", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_TERMS);
  scm_c_define_gsubr("INVOICE-BILLINGID", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_BILLINGID);
  scm_c_define_gsubr("INVOICE-NOTES", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_NOTES);
  scm_c_define_gsubr("INVOICE-ACC", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_ACC);
  scm_c_define_gsubr("INVOICE-POST-TXN", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_POST_TXN);
  scm_c_define_gsubr("INVOICE-POST-LOT", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_POST_LOT);
  scm_c_define_gsubr("INVOICE-TYPE", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_TYPE);
  scm_c_define_gsubr("INVOICE-BILLTO", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_BILLTO);
  scm_c_define_gsubr("INVOICE-ENTRIES", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_ENTRIES);
  scm_c_define_gsubr("INVOICE-JOB", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_JOB);
  scm_c_define_gsubr("INVOICE-FROM-LOT", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_FROM_LOT);
  scm_c_define_gsubr("INVOICE-FROM-TXN", 0, 0, 0, (swig_guile_proc) _wrap_INVOICE_FROM_TXN);
  scm_c_define_gsubr("gncInvoiceGetBook", 1, 0, 0, (swig_guile_proc) _wrap_gncInvoiceGetBook);
  scm_c_define_gsubr("GNC-ID-JOB", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_JOB);
  scm_c_define_gsubr("gnc-job-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_job_get_type);
  scm_c_define_gsubr("gncJobCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncJobCreate);
  scm_c_define_gsubr("gncJobDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncJobDestroy);
  scm_c_define_gsubr("gncJobSetID", 2, 0, 0, (swig_guile_proc) _wrap_gncJobSetID);
  scm_c_define_gsubr("gncJobSetName", 2, 0, 0, (swig_guile_proc) _wrap_gncJobSetName);
  scm_c_define_gsubr("gncJobSetReference", 2, 0, 0, (swig_guile_proc) _wrap_gncJobSetReference);
  scm_c_define_gsubr("gncJobSetOwner", 2, 0, 0, (swig_guile_proc) _wrap_gncJobSetOwner);
  scm_c_define_gsubr("gncJobSetActive", 2, 0, 0, (swig_guile_proc) _wrap_gncJobSetActive);
  scm_c_define_gsubr("gncJobBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncJobBeginEdit);
  scm_c_define_gsubr("gncJobCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncJobCommitEdit);
  scm_c_define_gsubr("gncJobGetID", 1, 0, 0, (swig_guile_proc) _wrap_gncJobGetID);
  scm_c_define_gsubr("gncJobGetName", 1, 0, 0, (swig_guile_proc) _wrap_gncJobGetName);
  scm_c_define_gsubr("gncJobGetReference", 1, 0, 0, (swig_guile_proc) _wrap_gncJobGetReference);
  scm_c_define_gsubr("gncJobGetOwner", 1, 0, 0, (swig_guile_proc) _wrap_gncJobGetOwner);
  scm_c_define_gsubr("gncJobGetActive", 1, 0, 0, (swig_guile_proc) _wrap_gncJobGetActive);
  scm_c_define_gsubr("gncJobLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncJobLookup);
  scm_c_define_gsubr("gncJobCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncJobCompare);
  scm_c_define_gsubr("gncJobEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncJobEqual);
  scm_c_define_gsubr("JOB-ID", 0, 0, 0, (swig_guile_proc) _wrap_JOB_ID);
  scm_c_define_gsubr("JOB-NAME", 0, 0, 0, (swig_guile_proc) _wrap_JOB_NAME);
  scm_c_define_gsubr("JOB-REFERENCE", 0, 0, 0, (swig_guile_proc) _wrap_JOB_REFERENCE);
  scm_c_define_gsubr("JOB-OWNER", 0, 0, 0, (swig_guile_proc) _wrap_JOB_OWNER);
  scm_c_define_gsubr("Q-JOB-OWNER", 0, 0, 0, (swig_guile_proc) _wrap_Q_JOB_OWNER);
  scm_c_define_gsubr("JOB-ACTIVE", 0, 0, 0, (swig_guile_proc) _wrap_JOB_ACTIVE);
  scm_c_define_gsubr("GNC-ID-ORDER", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_ORDER);
  scm_c_define_gsubr("gnc-order-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_order_get_type);
  scm_c_define_gsubr("gncOrderCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderCreate);
  scm_c_define_gsubr("gncOrderDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderDestroy);
  scm_c_define_gsubr("gncOrderSetID", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderSetID);
  scm_c_define_gsubr("gncOrderSetOwner", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderSetOwner);
  scm_c_define_gsubr("gncOrderSetDateOpened", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderSetDateOpened);
  scm_c_define_gsubr("gncOrderSetDateClosed", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderSetDateClosed);
  scm_c_define_gsubr("gncOrderSetNotes", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderSetNotes);
  scm_c_define_gsubr("gncOrderSetReference", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderSetReference);
  scm_c_define_gsubr("gncOrderSetActive", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderSetActive);
  scm_c_define_gsubr("gncOrderAddEntry", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderAddEntry);
  scm_c_define_gsubr("gncOrderRemoveEntry", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderRemoveEntry);
  scm_c_define_gsubr("gncOrderGetID", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderGetID);
  scm_c_define_gsubr("gncOrderGetOwner", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderGetOwner);
  scm_c_define_gsubr("gncOrderGetDateOpened", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderGetDateOpened);
  scm_c_define_gsubr("gncOrderGetDateClosed", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderGetDateClosed);
  scm_c_define_gsubr("gncOrderGetNotes", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderGetNotes);
  scm_c_define_gsubr("gncOrderGetReference", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderGetReference);
  scm_c_define_gsubr("gncOrderGetActive", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderGetActive);
  scm_c_define_gsubr("gncOrderGetEntries", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderGetEntries);
  scm_c_define_gsubr("gncOrderBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderBeginEdit);
  scm_c_define_gsubr("gncOrderCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderCommitEdit);
  scm_c_define_gsubr("gncOrderCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderCompare);
  scm_c_define_gsubr("gncOrderEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderEqual);
  scm_c_define_gsubr("gncOrderIsClosed", 1, 0, 0, (swig_guile_proc) _wrap_gncOrderIsClosed);
  scm_c_define_gsubr("gncOrderLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncOrderLookup);
  scm_c_define_gsubr("ORDER-ID", 0, 0, 0, (swig_guile_proc) _wrap_ORDER_ID);
  scm_c_define_gsubr("ORDER-REFERENCE", 0, 0, 0, (swig_guile_proc) _wrap_ORDER_REFERENCE);
  scm_c_define_gsubr("ORDER-OWNER", 0, 0, 0, (swig_guile_proc) _wrap_ORDER_OWNER);
  scm_c_define_gsubr("ORDER-OPENED", 0, 0, 0, (swig_guile_proc) _wrap_ORDER_OPENED);
  scm_c_define_gsubr("ORDER-CLOSED", 0, 0, 0, (swig_guile_proc) _wrap_ORDER_CLOSED);
  scm_c_define_gsubr("ORDER-IS-CLOSED", 0, 0, 0, (swig_guile_proc) _wrap_ORDER_IS_CLOSED);
  scm_c_define_gsubr("ORDER-NOTES", 0, 0, 0, (swig_guile_proc) _wrap_ORDER_NOTES);
  scm_c_define_gsubr("GNC-ID-OWNER", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_OWNER);
  scm_c_define_gsubr("GNC-OWNER-NONE", 0, 0, 0, (swig_guile_proc) _wrap_GNC_OWNER_NONE);
  scm_c_define_gsubr("GNC-OWNER-UNDEFINED", 0, 0, 0, (swig_guile_proc) _wrap_GNC_OWNER_UNDEFINED);
  scm_c_define_gsubr("GNC-OWNER-CUSTOMER", 0, 0, 0, (swig_guile_proc) _wrap_GNC_OWNER_CUSTOMER);
  scm_c_define_gsubr("GNC-OWNER-JOB", 0, 0, 0, (swig_guile_proc) _wrap_GNC_OWNER_JOB);
  scm_c_define_gsubr("GNC-OWNER-VENDOR", 0, 0, 0, (swig_guile_proc) _wrap_GNC_OWNER_VENDOR);
  scm_c_define_gsubr("GNC-OWNER-EMPLOYEE", 0, 0, 0, (swig_guile_proc) _wrap_GNC_OWNER_EMPLOYEE);
  scm_c_define_gsubr("qofOwnerGetType", 1, 0, 0, (swig_guile_proc) _wrap_qofOwnerGetType);
  scm_c_define_gsubr("qofOwnerGetOwner", 1, 0, 0, (swig_guile_proc) _wrap_qofOwnerGetOwner);
  scm_c_define_gsubr("qofOwnerSetEntity", 2, 0, 0, (swig_guile_proc) _wrap_qofOwnerSetEntity);
  scm_c_define_gsubr("gncOwnerTypeToQofIdType", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerTypeToQofIdType);
  scm_c_define_gsubr("gncOwnerRegister", 0, 0, 0, (swig_guile_proc) _wrap_gncOwnerRegister);
  scm_c_define_gsubr("gncOwnerInitUndefined", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerInitUndefined);
  scm_c_define_gsubr("gncOwnerInitCustomer", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerInitCustomer);
  scm_c_define_gsubr("gncOwnerInitJob", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerInitJob);
  scm_c_define_gsubr("gncOwnerInitVendor", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerInitVendor);
  scm_c_define_gsubr("gncOwnerInitEmployee", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerInitEmployee);
  scm_c_define_gsubr("gncOwnerGetType", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetType);
  scm_c_define_gsubr("gncOwnerGetUndefined", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetUndefined);
  scm_c_define_gsubr("gncOwnerGetCustomer", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetCustomer);
  scm_c_define_gsubr("gncOwnerGetJob", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetJob);
  scm_c_define_gsubr("gncOwnerGetVendor", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetVendor);
  scm_c_define_gsubr("gncOwnerGetEmployee", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetEmployee);
  scm_c_define_gsubr("gncOwnerCopy", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerCopy);
  scm_c_define_gsubr("gncOwnerEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerEqual);
  scm_c_define_gsubr("gncOwnerCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerCompare);
  scm_c_define_gsubr("gncOwnerGetID", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetID);
  scm_c_define_gsubr("gncOwnerGetName", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetName);
  scm_c_define_gsubr("gncOwnerGetAddr", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetAddr);
  scm_c_define_gsubr("gncOwnerGetActive", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetActive);
  scm_c_define_gsubr("gncOwnerGetCurrency", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetCurrency);
  scm_c_define_gsubr("gncOwnerGetGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetGUID);
  scm_c_define_gsubr("gncOwnerReturnGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerReturnGUID);
  scm_c_define_gsubr("gncOwnerIsValid", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerIsValid);
  scm_c_define_gsubr("gncOwnerGetEndOwner", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetEndOwner);
  scm_c_define_gsubr("gncOwnerGetEndGUID", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetEndGUID);
  scm_c_define_gsubr("gncOwnerAttachToLot", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerAttachToLot);
  scm_c_define_gsubr("gncOwnerGetOwnerFromLot", 2, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetOwnerFromLot);
  scm_c_define_gsubr("gncOwnerGetOwnerFromTypeGuid", 4, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetOwnerFromTypeGuid);
  scm_c_define_gsubr("gncOwnerGetSlots", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerGetSlots);
  scm_c_define_gsubr("OWNER-TYPE", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_TYPE);
  scm_c_define_gsubr("OWNER-TYPE-STRING", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_TYPE_STRING);
  scm_c_define_gsubr("OWNER-CUSTOMER", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_CUSTOMER);
  scm_c_define_gsubr("OWNER-JOB", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_JOB);
  scm_c_define_gsubr("OWNER-VENDOR", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_VENDOR);
  scm_c_define_gsubr("OWNER-EMPLOYEE", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_EMPLOYEE);
  scm_c_define_gsubr("OWNER-PARENT", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_PARENT);
  scm_c_define_gsubr("OWNER-PARENTG", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_PARENTG);
  scm_c_define_gsubr("OWNER-NAME", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_NAME);
  scm_c_define_gsubr("OWNER-FROM-LOT", 0, 0, 0, (swig_guile_proc) _wrap_OWNER_FROM_LOT);
  scm_c_define_gsubr("gncOwnerCreate", 0, 0, 0, (swig_guile_proc) _wrap_gncOwnerCreate);
  scm_c_define_gsubr("gncOwnerDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncOwnerDestroy);
  scm_c_define_gsubr("GNC-ID-TAXTABLE", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_TAXTABLE);
  scm_c_define_gsubr("gnc-taxtable-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_taxtable_get_type);
  scm_c_define_gsubr("GNC-AMT-TYPE-VALUE", 0, 0, 0, (swig_guile_proc) _wrap_GNC_AMT_TYPE_VALUE);
  scm_c_define_gsubr("GNC-AMT-TYPE-PERCENT", 0, 0, 0, (swig_guile_proc) _wrap_GNC_AMT_TYPE_PERCENT);
  scm_c_define_gsubr("GNC-TAXINCLUDED-YES", 0, 0, 0, (swig_guile_proc) _wrap_GNC_TAXINCLUDED_YES);
  scm_c_define_gsubr("GNC-TAXINCLUDED-NO", 0, 0, 0, (swig_guile_proc) _wrap_GNC_TAXINCLUDED_NO);
  scm_c_define_gsubr("GNC-TAXINCLUDED-USEGLOBAL", 0, 0, 0, (swig_guile_proc) _wrap_GNC_TAXINCLUDED_USEGLOBAL);
  scm_c_define_gsubr("gncAmountTypeToString", 1, 0, 0, (swig_guile_proc) _wrap_gncAmountTypeToString);
  scm_c_define_gsubr("gncAmountStringToType", 2, 0, 0, (swig_guile_proc) _wrap_gncAmountStringToType);
  scm_c_define_gsubr("gncTaxIncludedTypeToString", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxIncludedTypeToString);
  scm_c_define_gsubr("gncTaxIncludedStringToType", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxIncludedStringToType);
  scm_c_define_gsubr("gncTaxTableCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableCreate);
  scm_c_define_gsubr("gncTaxTableDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableDestroy);
  scm_c_define_gsubr("gncTaxTableEntryCreate", 0, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntryCreate);
  scm_c_define_gsubr("gncTaxTableEntryDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntryDestroy);
  scm_c_define_gsubr("gncTaxTableSetName", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableSetName);
  scm_c_define_gsubr("gncTaxTableIncRef", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableIncRef);
  scm_c_define_gsubr("gncTaxTableDecRef", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableDecRef);
  scm_c_define_gsubr("gncTaxTableEntrySetAccount", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntrySetAccount);
  scm_c_define_gsubr("gncTaxTableEntrySetType", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntrySetType);
  scm_c_define_gsubr("gncTaxTableEntrySetAmount", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntrySetAmount);
  scm_c_define_gsubr("gncTaxTableAddEntry", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableAddEntry);
  scm_c_define_gsubr("gncTaxTableRemoveEntry", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableRemoveEntry);
  scm_c_define_gsubr("gncTaxTableChanged", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableChanged);
  scm_c_define_gsubr("gncTaxTableBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableBeginEdit);
  scm_c_define_gsubr("gncTaxTableCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableCommitEdit);
  scm_c_define_gsubr("gncTaxTableEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEqual);
  scm_c_define_gsubr("gncTaxTableLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableLookup);
  scm_c_define_gsubr("gncTaxTableLookupByName", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableLookupByName);
  scm_c_define_gsubr("gncTaxTableGetTables", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableGetTables);
  scm_c_define_gsubr("gncTaxTableGetName", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableGetName);
  scm_c_define_gsubr("gncTaxTableGetParent", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableGetParent);
  scm_c_define_gsubr("gncTaxTableReturnChild", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableReturnChild);
  scm_c_define_gsubr("gncTaxTableGetEntries", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableGetEntries);
  scm_c_define_gsubr("gncTaxTableGetRefcount", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableGetRefcount);
  scm_c_define_gsubr("gncTaxTableLastModified", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableLastModified);
  scm_c_define_gsubr("gncTaxTableEntryGetAccount", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntryGetAccount);
  scm_c_define_gsubr("gncTaxTableEntryGetType", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntryGetType);
  scm_c_define_gsubr("gncTaxTableEntryGetAmount", 1, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntryGetAmount);
  scm_c_define_gsubr("gncTaxTableCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableCompare);
  scm_c_define_gsubr("gncTaxTableEntryCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntryCompare);
  scm_c_define_gsubr("gncTaxTableEntryEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncTaxTableEntryEqual);
  SWIG_TypeClientData(SWIGTYPE_p__gncAccountValue, (void *) &_swig_guile_clientdata_gncAccountValue);
  scm_c_define_gsubr("-gncAccountValue-account-set", 2, 0, 0, (swig_guile_proc) _wrap__gncAccountValue_account_set);
  scm_c_define_gsubr("-gncAccountValue-account-get", 1, 0, 0, (swig_guile_proc) _wrap__gncAccountValue_account_get);
  scm_c_define_gsubr("-gncAccountValue-value-set", 2, 0, 0, (swig_guile_proc) _wrap__gncAccountValue_value_set);
  scm_c_define_gsubr("-gncAccountValue-value-get", 1, 0, 0, (swig_guile_proc) _wrap__gncAccountValue_value_get);
  scm_c_define_gsubr("new--gncAccountValue", 0, 0, 0, (swig_guile_proc) _wrap_new__gncAccountValue);
  ((swig_guile_clientdata *)(SWIGTYPE_p__gncAccountValue->clientdata))->destroy = (guile_destructor) _wrap_delete__gncAccountValue;
  scm_c_define_gsubr("delete--gncAccountValue", 1, 0, 0, (swig_guile_proc) _wrap_delete__gncAccountValue);
  scm_c_define_gsubr("gncAccountValueAdd", 3, 0, 0, (swig_guile_proc) _wrap_gncAccountValueAdd);
  scm_c_define_gsubr("gncAccountValueAddList", 2, 0, 0, (swig_guile_proc) _wrap_gncAccountValueAddList);
  scm_c_define_gsubr("gncAccountValueTotal", 1, 0, 0, (swig_guile_proc) _wrap_gncAccountValueTotal);
  scm_c_define_gsubr("gncAccountValueDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncAccountValueDestroy);
  scm_c_define_gsubr("GNC-TT-NAME", 0, 0, 0, (swig_guile_proc) _wrap_GNC_TT_NAME);
  scm_c_define_gsubr("GNC-TT-REFCOUNT", 0, 0, 0, (swig_guile_proc) _wrap_GNC_TT_REFCOUNT);
  scm_c_define_gsubr("GNC-ID-VENDOR", 0, 0, 0, (swig_guile_proc) _wrap_GNC_ID_VENDOR);
  scm_c_define_gsubr("gnc-vendor-get-type", 0, 0, 0, (swig_guile_proc) _wrap_gnc_vendor_get_type);
  scm_c_define_gsubr("gncVendorCreate", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorCreate);
  scm_c_define_gsubr("gncVendorDestroy", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorDestroy);
  scm_c_define_gsubr("gncVendorSetID", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetID);
  scm_c_define_gsubr("gncVendorSetName", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetName);
  scm_c_define_gsubr("gncVendorSetNotes", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetNotes);
  scm_c_define_gsubr("gncVendorSetTerms", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetTerms);
  scm_c_define_gsubr("gncVendorSetTaxIncluded", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetTaxIncluded);
  scm_c_define_gsubr("gncVendorSetCurrency", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetCurrency);
  scm_c_define_gsubr("gncVendorSetActive", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetActive);
  scm_c_define_gsubr("gncVendorSetTaxTableOverride", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetTaxTableOverride);
  scm_c_define_gsubr("gncVendorSetTaxTable", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorSetTaxTable);
  scm_c_define_gsubr("gncVendorAddJob", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorAddJob);
  scm_c_define_gsubr("gncVendorRemoveJob", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorRemoveJob);
  scm_c_define_gsubr("gncVendorBeginEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorBeginEdit);
  scm_c_define_gsubr("gncVendorCommitEdit", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorCommitEdit);
  scm_c_define_gsubr("gncVendorGetID", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetID);
  scm_c_define_gsubr("gncVendorGetName", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetName);
  scm_c_define_gsubr("gncVendorGetAddr", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetAddr);
  scm_c_define_gsubr("gncVendorGetNotes", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetNotes);
  scm_c_define_gsubr("gncVendorGetTerms", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetTerms);
  scm_c_define_gsubr("gncVendorGetTaxIncluded", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetTaxIncluded);
  scm_c_define_gsubr("gncVendorGetCurrency", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetCurrency);
  scm_c_define_gsubr("gncVendorGetActive", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetActive);
  scm_c_define_gsubr("gncVendorGetTaxTableOverride", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetTaxTableOverride);
  scm_c_define_gsubr("gncVendorGetTaxTable", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorGetTaxTable);
  scm_c_define_gsubr("gncVendorGetJoblist", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorGetJoblist);
  scm_c_define_gsubr("gncVendorIsDirty", 1, 0, 0, (swig_guile_proc) _wrap_gncVendorIsDirty);
  scm_c_define_gsubr("gncVendorCompare", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorCompare);
  scm_c_define_gsubr("gncVendorEqual", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorEqual);
  scm_c_define_gsubr("gncVendorLookup", 2, 0, 0, (swig_guile_proc) _wrap_gncVendorLookup);
  scm_c_define_gsubr("VENDOR-ID", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_ID);
  scm_c_define_gsubr("VENDOR-NAME", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_NAME);
  scm_c_define_gsubr("VENDOR-ADDR", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_ADDR);
  scm_c_define_gsubr("VENDOR-NOTES", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_NOTES);
  scm_c_define_gsubr("VENDOR-TERMS", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_TERMS);
  scm_c_define_gsubr("VENDOR-TAX-INC", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_TAX_INC);
  scm_c_define_gsubr("VENDOR-ACTIVE", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_ACTIVE);
  scm_c_define_gsubr("VENDOR-TAX-OVERRIDE", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_TAX_OVERRIDE);
  scm_c_define_gsubr("VENDOR-TAX-TABLE", 0, 0, 0, (swig_guile_proc) _wrap_VENDOR_TAX_TABLE);
  scm_c_define_gsubr("gnc-account-value-pointer-p", 1, 0, 0, (swig_guile_proc) _wrap_gnc_account_value_pointer_p);
  scm_c_define_gsubr("gnc-scm-to-account-value-ptr", 1, 0, 0, (swig_guile_proc) _wrap_gnc_scm_to_account_value_ptr);
  scm_c_define_gsubr("gnc-account-value-ptr-to-scm", 1, 0, 0, (swig_guile_proc) _wrap_gnc_account_value_ptr_to_scm);
  scm_c_define_gsubr("URL-TYPE-CUSTOMER", 0, 0, 0, (swig_guile_proc) _wrap_URL_TYPE_CUSTOMER);
  scm_c_define_gsubr("URL-TYPE-VENDOR", 0, 0, 0, (swig_guile_proc) _wrap_URL_TYPE_VENDOR);
  scm_c_define_gsubr("URL-TYPE-EMPLOYEE", 0, 0, 0, (swig_guile_proc) _wrap_URL_TYPE_EMPLOYEE);
  scm_c_define_gsubr("URL-TYPE-JOB", 0, 0, 0, (swig_guile_proc) _wrap_URL_TYPE_JOB);
  scm_c_define_gsubr("URL-TYPE-INVOICE", 0, 0, 0, (swig_guile_proc) _wrap_URL_TYPE_INVOICE);
  scm_c_define_gsubr("URL-TYPE-OWNERREPORT", 0, 0, 0, (swig_guile_proc) _wrap_URL_TYPE_OWNERREPORT);
  scm_c_define_gsubr("qof-query-create-for-invoices", 0, 0, 0, (swig_guile_proc) _wrap_qof_query_create_for_invoices);
  scm_c_define_gsubr("qof-query-run-for-invoices", 1, 0, 0, (swig_guile_proc) _wrap_qof_query_run_for_invoices);
  
  {
    char tmp[100];
    
    
    
    
    snprintf(tmp, 100, "(set! %s (%s))", ("GNC-OWNER-CUSTOMER"), ("GNC-OWNER-CUSTOMER"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("GNC-OWNER-VENDOR"), ("GNC-OWNER-VENDOR"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("GNC-OWNER-EMPLOYEE"), ("GNC-OWNER-EMPLOYEE"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("GNC-OWNER-JOB"), ("GNC-OWNER-JOB"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("GNC-AMT-TYPE-VALUE"), ("GNC-AMT-TYPE-VALUE"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("GNC-AMT-TYPE-PERCENT"), ("GNC-AMT-TYPE-PERCENT"));       scm_c_eval_string(tmp);;
    
    snprintf(tmp, 100, "(set! %s (%s))", ("URL-TYPE-CUSTOMER"), ("URL-TYPE-CUSTOMER"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("URL-TYPE-VENDOR"), ("URL-TYPE-VENDOR"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("URL-TYPE-EMPLOYEE"), ("URL-TYPE-EMPLOYEE"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("URL-TYPE-JOB"), ("URL-TYPE-JOB"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("URL-TYPE-INVOICE"), ("URL-TYPE-INVOICE"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("URL-TYPE-OWNERREPORT"), ("URL-TYPE-OWNERREPORT"));       scm_c_eval_string(tmp);;
    
    snprintf(tmp, 100, "(set! %s (%s))", ("INVOICE-FROM-TXN"), ("INVOICE-FROM-TXN"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("INVOICE-FROM-LOT"), ("INVOICE-FROM-LOT"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("INVOICE-OWNER"), ("INVOICE-OWNER"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("INVOICE-BILLTO"), ("INVOICE-BILLTO"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("OWNER-PARENTG"), ("OWNER-PARENTG"));       scm_c_eval_string(tmp);;
    snprintf(tmp, 100, "(set! %s (%s))", ("OWNER-FROM-LOT"), ("OWNER-FROM-LOT"));       scm_c_eval_string(tmp);;
    
    
    
  }
  
  
}

#ifdef __cplusplus
}
#endif

/* Linkage: module */
static void SWIG_init_helper(void *data)
{
SWIG_init();
scm_c_export("gncTaxTableReturnGUID", "gncInvoiceReturnGUID", "gncJobReturnGUID", "gncVendorReturnGUID", "gncCustomerReturnGUID", "gncEmployeeReturnGUID", "gncTaxTableLookupFlip", "gncInvoiceLookupFlip", "gncJobLookupFlip", "gncVendorLookupFlip", "gncCustomerLookupFlip", "gncEmployeeLookupFlip", "GNC-ADDRESS-MODULE-NAME", "GNC-ID-ADDRESS", "gnc-address-get-type", "gncAddressCreate", "gncAddressDestroy", "gncAddressBeginEdit", "gncAddressCommitEdit", "gncAddressSetName", "gncAddressSetAddr1", "gncAddressSetAddr2", "gncAddressSetAddr3", "gncAddressSetAddr4", "gncAddressSetPhone", "gncAddressSetFax", "gncAddressSetEmail", "gncAddressClearDirty", "gncAddressGetName", "gncAddressGetAddr1", "gncAddressGetAddr2", "gncAddressGetAddr3", "gncAddressGetAddr4", "gncAddressGetPhone", "gncAddressGetFax", "gncAddressGetEmail", "gncAddressIsDirty", "gncAddressCompare", "gncAddressEqual", "ADDRESS-NAME", "ADDRESS-ONE", "ADDRESS-TWO", "ADDRESS-THREE", "ADDRESS-FOUR", "ADDRESS-PHONE", "ADDRESS-FAX", "ADDRESS-EMAIL", "ADDRESS-OWNER", "GNC-ID-BILLTERM", "gnc-billterm-get-type", "GNC-BILLTERM-NAME", "GNC-BILLTERM-DESC", "GNC-BILLTERM-DUEDAYS", "GNC-BILLTERM-DISCDAYS", "GNC-BILLTERM-CUTOFF", "GNC-BILLTERM-TYPE", "GNC-BILLTERM-DISCOUNT", "GNC-BILLTERM-REFCOUNT", "GNC-TERM-TYPE-DAYS", "GNC-TERM-TYPE-PROXIMO", "gncBillTermCreate", "gncBillTermDestroy", "gncBillTermIncRef", "gncBillTermDecRef", "gncBillTermChanged", "gncBillTermBeginEdit", "gncBillTermCommitEdit", "gncBillTermSetName", "gncBillTermSetDescription", "gncBillTermSetType", "gncBillTermSetDueDays", "gncBillTermSetDiscountDays", "gncBillTermSetDiscount", "gncBillTermSetCutoff", "gncBillTermLookup", "gncBillTermLookupByName", "gncBillTermGetTerms", "gncBillTermGetName", "gncBillTermGetDescription", "gncBillTermGetType", "gncBillTermGetDueDays", "gncBillTermGetDiscountDays", "gncBillTermGetDiscount", "gncBillTermGetCutoff", "gncBillTermIsDirty", "gncBillTermGetParent", "gncBillTermReturnChild", "gncBillTermGetRefcount", "gncBillTermCompare", "gncBillTermEqual", "gncBillTermComputeDueDate", "gncBillTermComputeDiscountDate", "GNC-BILLTERM-MODULE-NAME", "gncBusinessGetList", "gncBusinessGetOwnerList", "GNC-ID-CUSTOMER", "gnc-customer-get-type", "gncCustomerCreate", "gncCustomerDestroy", "gncCustomerBeginEdit", "gncCustomerCommitEdit", "gncCustomerSetID", "gncCustomerSetName", "gncCustomerSetNotes", "gncCustomerSetTerms", "gncCustomerSetTaxIncluded", "gncCustomerSetActive", "gncCustomerSetDiscount", "gncCustomerSetCredit", "gncCustomerSetCurrency", "gncCustomerSetTaxTableOverride", "gncCustomerSetTaxTable", "gncCustomerAddJob", "gncCustomerRemoveJob", "gncCustomerLookup", "gncCustomerGetID", "gncCustomerGetName", "gncCustomerGetAddr", "gncCustomerGetShipAddr", "gncCustomerGetNotes", "gncCustomerGetTerms", "gncCustomerGetTaxIncluded", "gncCustomerGetActive", "gncCustomerGetDiscount", "gncCustomerGetCredit", "gncCustomerGetCurrency", "gncCustomerGetTaxTableOverride", "gncCustomerGetTaxTable", "gncCustomerGetJoblist", "gncCustomerIsDirty", "gncCustomerCompare", "gncCustomerEqual", "CUSTOMER-ID", "CUSTOMER-NAME", "CUSTOMER-ADDR", "CUSTOMER-SHIPADDR", "CUSTOMER-NOTES", "CUSTOMER-DISCOUNT", "CUSTOMER-CREDIT", "CUSTOMER-TT-OVER", "CUSTOMER-TAX-INC", "CUSTOMER-TERMS", "CUSTOMER-ACTIVE", "CUSTOMER-SLOTS", "GNC-ID-EMPLOYEE", "gnc-employee-get-type", "gncEmployeeCreate", "gncEmployeeDestroy", "gncEmployeeBeginEdit", "gncEmployeeCommitEdit", "gncEmployeeCompare", "gncEmployeeSetID", "gncEmployeeSetUsername", "gncEmployeeSetLanguage", "gncEmployeeSetAcl", "gncEmployeeSetWorkday", "gncEmployeeSetRate", "gncEmployeeSetCurrency", "gncEmployeeSetActive", "gncEmployeeSetCCard", "qofEmployeeSetAddr", "gncEmployeeGetBook", "gncEmployeeGetID", "gncEmployeeGetUsername", "gncEmployeeGetAddr", "gncEmployeeGetLanguage", "gncEmployeeGetAcl", "gncEmployeeGetWorkday", "gncEmployeeGetRate", "gncEmployeeGetCurrency", "gncEmployeeGetActive", "gncEmployeeGetCCard", "gncEmployeeLookup", "gncEmployeeIsDirty", "gncEmployeeEqual", "EMPLOYEE-ID", "EMPLOYEE-USERNAME", "EMPLOYEE-ADDR", "EMPLOYEE-LANGUAGE", "EMPLOYEE-ACL", "EMPLOYEE-WORKDAY", "EMPLOYEE-RATE", "EMPLOYEE-CC", "GNC-PAYMENT-CASH", "GNC-PAYMENT-CARD", "GNC-DISC-PRETAX", "GNC-DISC-SAMETIME", "GNC-DISC-POSTTAX", "GNC-ID-ENTRY", "gnc-entry-get-type", "gncEntryDiscountHowToString", "gncEntryDiscountStringToHow", "gncEntryPaymentTypeToString", "gncEntryPaymentStringToType", "gncEntryCreate", "gncEntryDestroy", "gncEntrySetDate", "gncEntrySetDateEntered", "gncEntrySetDescription", "gncEntrySetAction", "gncEntrySetNotes", "gncEntrySetQuantity", "gncEntrySetInvAccount", "gncEntrySetInvPrice", "gncEntrySetInvTaxable", "gncEntrySetInvTaxIncluded", "gncEntrySetInvTaxTable", "gncEntrySetInvDiscount", "gncEntrySetInvDiscountType", "gncEntrySetInvDiscountHow", "qofEntrySetInvDiscType", "qofEntrySetInvDiscHow", "gncEntrySetBillAccount", "gncEntrySetBillPrice", "gncEntrySetBillTaxable", "gncEntrySetBillTaxIncluded", "gncEntrySetBillTaxTable", "gncEntrySetBillable", "gncEntrySetBillTo", "gncEntrySetBillPayment", "gncEntryGetDate", "gncEntryGetDateEntered", "gncEntryGetDescription", "gncEntryGetAction", "gncEntryGetNotes", "gncEntryGetQuantity", "gncEntryGetInvAccount", "gncEntryGetInvPrice", "gncEntryGetInvDiscount", "gncEntryGetInvDiscountType", "gncEntryGetInvDiscountHow", "qofEntryGetInvDiscType", "qofEntryGetInvDiscHow", "gncEntryGetInvTaxable", "gncEntryGetInvTaxIncluded", "gncEntryGetInvTaxTable", "gncEntryGetBillAccount", "gncEntryGetBillPrice", "gncEntryGetBillTaxable", "gncEntryGetBillTaxIncluded", "gncEntryGetBillTaxTable", "gncEntryGetBillable", "gncEntryGetBillTo", "gncEntryGetBillPayment", "gncEntryCopy", "gncEntryReturnValue", "gncEntryReturnDiscountValue", "gncEntryReturnTaxValue", "gncEntryReturnTaxValues", "gncEntryGetValue", "gncEntryComputeValue", "gncEntryGetOrder", "gncEntryGetInvoice", "gncEntryGetBill", "gncEntryLookup", "gncEntryIsOpen", "gncEntryBeginEdit", "gncEntryCommitEdit", "gncEntryCompare", "gncEntryEqual", "ENTRY-DATE", "ENTRY-DATE-ENTERED", "ENTRY-DESC", "ENTRY-ACTION", "ENTRY-NOTES", "ENTRY-QTY", "ENTRY-IPRICE", "ENTRY-IACCT", "ENTRY-BACCT", "ENTRY-BPRICE", "ENTRY-BILLABLE", "ENTRY-BILLTO", "ENTRY-ORDER", "ENTRY-INVOICE", "ENTRY-BILL", "ENTRY-INV-DISC-TYPE", "ENTRY-INV-DISC-HOW", "ENTRY-INV-TAXABLE", "ENTRY-BILL-TAXABLE", "ENTRY-INV-TAX-INC", "ENTRY-BILL-TAX-INC", "ENTRY-INV-DISCOUNT", "ENTRY-BILL-PAY-TYPE", "GNC-ID-INVOICE", "gnc-invoice-get-type", "gncInvoiceCreate", "gncInvoiceDestroy", "gncInvoiceCopy", "gncInvoiceSetID", "gncInvoiceSetOwner", "gncInvoiceSetDateOpened", "gncInvoiceSetDatePosted", "gncInvoiceSetTerms", "gncInvoiceSetBillingID", "gncInvoiceSetNotes", "gncInvoiceSetCurrency", "gncInvoiceSetActive", "gncInvoiceSetBillTo", "gncInvoiceSetToChargeAmount", "gncInvoiceAddEntry", "gncInvoiceRemoveEntry", "gncInvoiceAddPrice", "gncInvoiceRemovePrice", "gncBillAddEntry", "gncBillRemoveEntry", "gncBillAddPrice", "gncBillRemovePrice", "gncInvoiceSortEntries", "gncInvoiceGetID", "gncInvoiceGetOwner", "gncInvoiceGetDateOpened", "gncInvoiceGetDatePosted", "gncInvoiceGetDateDue", "gncInvoiceGetTerms", "gncInvoiceGetBillingID", "gncInvoiceGetNotes", "gncInvoiceGetOwnerType", "gncInvoiceGetTypeFromOwnerType", "gncInvoiceGetType", "gncInvoiceGetCurrency", "gncInvoiceGetBillTo", "gncInvoiceGetToChargeAmount", "gncInvoiceGetActive", "gncInvoiceGetPostedLot", "gncInvoiceGetPostedTxn", "gncInvoiceGetPostedAcc", "gncInvoiceGetTotal", "gncInvoiceGetTotalOf", "gncInvoiceGetTotalSubtotal", "gncInvoiceGetTotalTax", "gncInvoiceGetEntries", "gncInvoiceGetPrices", "gncInvoiceGetPrice", "gncInvoicePostToAccount", "gncInvoiceUnpost", "gncOwnerApplyPayment", "gncInvoiceGetInvoiceFromTxn", "gncInvoiceGetInvoiceFromLot", "gncInvoiceLookup", "gncInvoiceBeginEdit", "gncInvoiceCommitEdit", "gncInvoiceCompare", "gncInvoiceEqual", "gncInvoiceIsPosted", "gncInvoiceIsPaid", "INVOICE-ID", "INVOICE-OWNER", "INVOICE-OPENED", "INVOICE-POSTED", "INVOICE-DUE", "INVOICE-IS-POSTED", "INVOICE-IS-PAID", "INVOICE-TERMS", "INVOICE-BILLINGID", "INVOICE-NOTES", "INVOICE-ACC", "INVOICE-POST-TXN", "INVOICE-POST-LOT", "INVOICE-TYPE", "INVOICE-BILLTO", "INVOICE-ENTRIES", "INVOICE-JOB", "INVOICE-FROM-LOT", "INVOICE-FROM-TXN", "gncInvoiceGetBook", "GNC-ID-JOB", "gnc-job-get-type", "gncJobCreate", "gncJobDestroy", "gncJobSetID", "gncJobSetName", "gncJobSetReference", "gncJobSetOwner", "gncJobSetActive", "gncJobBeginEdit", "gncJobCommitEdit", "gncJobGetID", "gncJobGetName", "gncJobGetReference", "gncJobGetOwner", "gncJobGetActive", "gncJobLookup", "gncJobCompare", "gncJobEqual", "JOB-ID", "JOB-NAME", "JOB-REFERENCE", "JOB-OWNER", "Q-JOB-OWNER", "JOB-ACTIVE", "GNC-ID-ORDER", "gnc-order-get-type", "gncOrderCreate", "gncOrderDestroy", "gncOrderSetID", "gncOrderSetOwner", "gncOrderSetDateOpened", "gncOrderSetDateClosed", "gncOrderSetNotes", "gncOrderSetReference", "gncOrderSetActive", "gncOrderAddEntry", "gncOrderRemoveEntry", "gncOrderGetID", "gncOrderGetOwner", "gncOrderGetDateOpened", "gncOrderGetDateClosed", "gncOrderGetNotes", "gncOrderGetReference", "gncOrderGetActive", "gncOrderGetEntries", "gncOrderBeginEdit", "gncOrderCommitEdit", "gncOrderCompare", "gncOrderEqual", "gncOrderIsClosed", "gncOrderLookup", "ORDER-ID", "ORDER-REFERENCE", "ORDER-OWNER", "ORDER-OPENED", "ORDER-CLOSED", "ORDER-IS-CLOSED", "ORDER-NOTES", "GNC-ID-OWNER", "GNC-OWNER-NONE", "GNC-OWNER-UNDEFINED", "GNC-OWNER-CUSTOMER", "GNC-OWNER-JOB", "GNC-OWNER-VENDOR", "GNC-OWNER-EMPLOYEE", "qofOwnerGetType", "qofOwnerGetOwner", "qofOwnerSetEntity", "gncOwnerTypeToQofIdType", "gncOwnerRegister", "gncOwnerInitUndefined", "gncOwnerInitCustomer", "gncOwnerInitJob", "gncOwnerInitVendor", "gncOwnerInitEmployee", "gncOwnerGetType", "gncOwnerGetUndefined", "gncOwnerGetCustomer", "gncOwnerGetJob", "gncOwnerGetVendor", "gncOwnerGetEmployee", "gncOwnerCopy", "gncOwnerEqual", "gncOwnerCompare", "gncOwnerGetID", "gncOwnerGetName", "gncOwnerGetAddr", "gncOwnerGetActive", "gncOwnerGetCurrency", "gncOwnerGetGUID", "gncOwnerReturnGUID", "gncOwnerIsValid", "gncOwnerGetEndOwner", "gncOwnerGetEndGUID", "gncOwnerAttachToLot", "gncOwnerGetOwnerFromLot", "gncOwnerGetOwnerFromTypeGuid", "gncOwnerGetSlots", "OWNER-TYPE", "OWNER-TYPE-STRING", "OWNER-CUSTOMER", "OWNER-JOB", "OWNER-VENDOR", "OWNER-EMPLOYEE", "OWNER-PARENT", "OWNER-PARENTG", "OWNER-NAME", "OWNER-FROM-LOT", "gncOwnerCreate", "gncOwnerDestroy", "GNC-ID-TAXTABLE", "gnc-taxtable-get-type", "GNC-AMT-TYPE-VALUE", "GNC-AMT-TYPE-PERCENT", "GNC-TAXINCLUDED-YES", "GNC-TAXINCLUDED-NO", "GNC-TAXINCLUDED-USEGLOBAL", "gncAmountTypeToString", "gncAmountStringToType", "gncTaxIncludedTypeToString", "gncTaxIncludedStringToType", "gncTaxTableCreate", "gncTaxTableDestroy", "gncTaxTableEntryCreate", "gncTaxTableEntryDestroy", "gncTaxTableSetName", "gncTaxTableIncRef", "gncTaxTableDecRef", "gncTaxTableEntrySetAccount", "gncTaxTableEntrySetType", "gncTaxTableEntrySetAmount", "gncTaxTableAddEntry", "gncTaxTableRemoveEntry", "gncTaxTableChanged", "gncTaxTableBeginEdit", "gncTaxTableCommitEdit", "gncTaxTableEqual", "gncTaxTableLookup", "gncTaxTableLookupByName", "gncTaxTableGetTables", "gncTaxTableGetName", "gncTaxTableGetParent", "gncTaxTableReturnChild", "gncTaxTableGetEntries", "gncTaxTableGetRefcount", "gncTaxTableLastModified", "gncTaxTableEntryGetAccount", "gncTaxTableEntryGetType", "gncTaxTableEntryGetAmount", "gncTaxTableCompare", "gncTaxTableEntryCompare", "gncTaxTableEntryEqual", "-gncAccountValue-account-set", "-gncAccountValue-account-get", "-gncAccountValue-value-set", "-gncAccountValue-value-get", "new--gncAccountValue", "delete--gncAccountValue", "gncAccountValueAdd", "gncAccountValueAddList", "gncAccountValueTotal", "gncAccountValueDestroy", "GNC-TT-NAME", "GNC-TT-REFCOUNT", "GNC-ID-VENDOR", "gnc-vendor-get-type", "gncVendorCreate", "gncVendorDestroy", "gncVendorSetID", "gncVendorSetName", "gncVendorSetNotes", "gncVendorSetTerms", "gncVendorSetTaxIncluded", "gncVendorSetCurrency", "gncVendorSetActive", "gncVendorSetTaxTableOverride", "gncVendorSetTaxTable", "gncVendorAddJob", "gncVendorRemoveJob", "gncVendorBeginEdit", "gncVendorCommitEdit", "gncVendorGetID", "gncVendorGetName", "gncVendorGetAddr", "gncVendorGetNotes", "gncVendorGetTerms", "gncVendorGetTaxIncluded", "gncVendorGetCurrency", "gncVendorGetActive", "gncVendorGetTaxTableOverride", "gncVendorGetTaxTable", "gncVendorGetJoblist", "gncVendorIsDirty", "gncVendorCompare", "gncVendorEqual", "gncVendorLookup", "VENDOR-ID", "VENDOR-NAME", "VENDOR-ADDR", "VENDOR-NOTES", "VENDOR-TERMS", "VENDOR-TAX-INC", "VENDOR-ACTIVE", "VENDOR-TAX-OVERRIDE", "VENDOR-TAX-TABLE", "gnc-account-value-pointer-p", "gnc-scm-to-account-value-ptr", "gnc-account-value-ptr-to-scm", "URL-TYPE-CUSTOMER", "URL-TYPE-VENDOR", "URL-TYPE-EMPLOYEE", "URL-TYPE-JOB", "URL-TYPE-INVOICE", "URL-TYPE-OWNERREPORT", "qof-query-create-for-invoices", "qof-query-run-for-invoices", NULL);
}

SCM
scm_init_sw_business_core_module (void)
{
scm_c_define_module("sw_business_core",
  SWIG_init_helper, NULL);
return SCM_UNSPECIFIED;
}

