/* Flegita - Gnome Sane Frontend
 *
 * test.c
 *
 * Copyright © 2006 Étienne Bersac
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <gtk/gtk.h>
#include <gnomescan.h>


void
received (GnomeScanContext *context,
	  GnomeScanResult *result)
{
  gdk_pixbuf_save (result->image, g_strdup_printf ("test-output-%s.png", result->preview ? "preview" : "final"), "png", NULL, NULL);
  if (!result->preview) {
    gnome_scan_context_stop_acquisition (context);
  }
}

gint
main (int argc, gchar **argv)
{
  GnomeScanContext *context;
  GnomeScanArea *area;
  GSList *scanners;
  gint nth = argc == 2 ? (gint) g_strtod (argv[1], NULL) : 0;

  bindtextdomain (GETTEXT_PACKAGE, LOCALEDIR);  
  bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
  textdomain (GETTEXT_PACKAGE);

  /* INIT */
/*   program = gnome_program_init ("gnomescan-test", VERSION, LIBGNOMEUI_MODULE, argc, argv, NULL); */
  gtk_init (&argc, &argv);

  context = gnome_scan_context_new ();
  g_signal_connect (context, "preview-received", (GCallback) received, NULL);
  g_signal_connect (context, "image-received", (GCallback) received, NULL);
  gnome_scan_context_probe_scanners (context);
  scanners = gnome_scan_context_get_scanners (context);
  gnome_scan_context_select_scanner (context, g_slist_nth_data (scanners, nth));
  gnome_scan_context_set_resolution (context, 96.);
  area = g_new0 (GnomeScanArea, 1);
  area->width	= 200.;
  area->height	= 200.;
  gnome_scan_context_set_area (context, area);
  gnome_scan_context_set_colorspace (context, GNOME_SCAN_COLORSPACE_RGB);
  gnome_scan_context_acquire_preview (context);
  gnome_scan_context_start_acquisition (context);
  gnome_scan_context_destroy (context);

  return (0);
}
