/* -*- Mode: C; indent-tabs-mode: t; c-basic-offset: 4; tab-width: 4 -*- */
/*
 * gnome-scan
 * Copyright (C) Étienne Bersac 2007 <bersace03@laposte.net>
 * 
 * gnome-scan is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * gnome-scan is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with gnome-scan.  If not, write to:
 * 	The Free Software Foundation, Inc.,
 * 	51 Franklin Street, Fifth Floor
 * 	Boston, MA  02110-1301, USA.
 */

#include <glib/gi18n.h>
#include "gnome-scan-number-widget.h"
#include "gnome-scan-param-specs.h"

#define GET_PRIVATE(o)  (G_TYPE_INSTANCE_GET_PRIVATE ((o), GNOME_TYPE_SCAN_NUMBER_WIDGET, GnomeScanNumberWidgetPrivate))


typedef struct _GnomeScanNumberWidgetPrivate GnomeScanNumberWidgetPrivate;
struct _GnomeScanNumberWidgetPrivate
{
	GtkWidget *spin;
	GtkObject *adj;
};

static void gsnw_value_changed (GtkAdjustment *adjustment,
								GnomeScanNumberWidget *gsnw);

GS_DEFINE_PARAM_WIDGET (GnomeScanNumberWidget, gnome_scan_number_widget);

static void
gnome_scan_number_widget_init (GnomeScanNumberWidget *object)
{
	/* TODO: Add initialization code here */
}

static void
gnome_scan_number_widget_finalize (GObject *object)
{
	/* TODO: Add deinitalization code here */

	G_OBJECT_CLASS (gnome_scan_number_widget_parent_class)->finalize (object);
}

static void
gnome_scan_number_widget_build (GnomeScanParamWidget *gspw)
{
	GnomeScanNumberWidgetPrivate *priv = GET_PRIVATE (gspw);
	guint digits = 0;
	
	switch (G_PARAM_SPEC_VALUE_TYPE (gspw->pspec)) {
		case G_TYPE_INT:
			priv->adj = gtk_adjustment_new (0.,
											(gdouble) G_MININT, (gdouble) G_MAXINT,
											1., 1., 0.);
		digits = 0;
		break;
		case G_TYPE_DOUBLE:
			priv->adj = gtk_adjustment_new (0.,
											G_MINDOUBLE, G_MAXDOUBLE,
											.1, .1, 0.);
		digits = 2;
		break;
	}
	priv->spin = gtk_spin_button_new (GTK_ADJUSTMENT (priv->adj),
										 1., digits);
	gtk_box_pack_start (GTK_BOX (gspw), priv->spin , FALSE, FALSE, 0);
	
	g_signal_connect (priv->adj, "value-changed",
					  (GCallback) gsnw_value_changed,
					  GNOME_SCAN_NUMBER_WIDGET (gspw));
}

static void
gnome_scan_number_widget_show (GnomeScanParamWidget *gspw)
{
}

static void
gnome_scan_number_widget_set (GnomeScanParamWidget *gspw, GValue *value)
{
	GValue *vdouble = g_new0 (GValue, 1);
	g_value_init (vdouble, G_TYPE_DOUBLE);
	g_value_transform (value, vdouble);
	gtk_adjustment_set_value (GTK_ADJUSTMENT (GET_PRIVATE (gspw)->adj),
							  g_value_get_double (vdouble));
	g_value_unset (vdouble);
	g_free (vdouble);
}


static void
gsnw_value_changed (GtkAdjustment *adjustment, GnomeScanNumberWidget *gsnw)
{
	GnomeScanParamWidget *gspw = GNOME_SCAN_PARAM_WIDGET (gsnw);
	GValue *vdouble = g_new0 (GValue, 1);
	g_value_init (vdouble, G_TYPE_DOUBLE);
	g_value_set_double (vdouble, gtk_adjustment_get_value (adjustment));
	g_value_transform (vdouble, gspw->value);
	g_value_unset (vdouble);
	g_free (vdouble);
	gnome_scan_param_widget_changed (gspw);
}
