/* gnome-rdp
 * Copyright (C) 2005-2006 Balazs Varkonyi
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */
 
using System;
using Gtk;
using Glade;
using System.Diagnostics;
using System.Data;
using Mono.Data.SqliteClient;
using System.Threading;
using Mono.Unix;

namespace GnomeRDP 
{
	public class Sqlite
	{
		private string ConnectionString;
		private IDbConnection dbcon;
		private IDbCommand dbcmd;	
		private IDataReader reader;
		private Window PWnd;
		
		public Sqlite(Window wnd)
		{
			this.PWnd = wnd;
		}
		
		public IDbConnection Connect(string connstr)
		{
			try
			{
				this.ConnectionString = "URI=file:" + connstr + ",version=2,encoding=UTF-8";
				this.dbcon = new SqliteConnection(this.ConnectionString);
				this.dbcon.Open();
			}
			catch
			{
				MessageDialog md = new MessageDialog(this.PWnd, DialogFlags.Modal, MessageType.Error, ButtonsType.Ok, Catalog.GetString("Error during the connection to database."));
				md.Run();
				md.Destroy();
			}
			this.dbcmd = this.dbcon.CreateCommand();
			return this.dbcon;
		}
		
		public bool Query(string query)
		{
			this.dbcmd.CommandText = query;
			try
			{
				this.reader = this.dbcmd.ExecuteReader();
				return true;
			}
			catch (System.Exception e)
			{
				MessageDialog md = new MessageDialog(this.PWnd, DialogFlags.Modal, MessageType.Error, ButtonsType.Ok, Catalog.GetString("Error in query:") + "\n" + query + "\n" + Catalog.GetString("Error:") + e.Message);
				md.Run();
				md.Destroy();
				return false;
			}
		}
		
		public bool FetchRow(out IDataReader result)
		{
			bool retval = false;
			
			try
			{
				if (reader.Read())
				{
					result = reader;
					retval = true;
				} 
				else 
				{
					result = null;
					retval = false;	
				}
			}
			catch
			{
				result = null;
				MessageDialog md = new MessageDialog(this.PWnd, DialogFlags.Modal, MessageType.Error, ButtonsType.Ok, Catalog.GetString("There was an error during reading of record."));
				md.Run();
				md.Destroy();				
			}
			return retval;
		} 
		
		public void FreeResult()
		{
			this.reader.Close();
		}
		
		public void Close()
		{
			try
			{
				this.reader.Close();
			}
			catch {}
			this.dbcmd.Dispose();
			this.dbcon.Close();
		}
	}
}