
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <stdarg.h>
#include <stdio.h>
#include "channel.h"
#include "servent.h"
#include "servmgr.h"
#include "unix/usys.h"
#include <sys/types.h>
#include <unistd.h>
#include <signal.h>
#include <stdlib.h>
#include "peercast.h"

#include <gnome.h>
#include <glade/glade.h>
#include <gconf/gconf-client.h>

#include "utils.h"
#include "channel-list.h"
#include "connection-list.h"
#include "callbacks.h"
#include "logview.h"
#include "gnome-peercast.h"

// ----------------------------------
String iniFileName;
bool quit=false;

//--------------------------------------------
class MyPeercastInst : public PeercastInstance
{
public:
	virtual Sys * APICALL createSys()
	{
		return new USys();
	}
};

// ----------------------------------
void setSettingsUI(){}
// ----------------------------------
void showConnections(){}
// ----------------------------------
void PRINTLOG(LogBuffer::TYPE type, const char *fmt,va_list ap)
{
}

// ----------------------------------
void sigProc(int sig)
{
	switch (sig)
	{
	case 2:
		if (!quit)
			LOG_DEBUG("Received QUIT signal");
		quit=true;
		break;
	}
}

static void
client_die_cb(GnomeClient *client, gpointer data)
{
	g_print("program dead\n");
}

static gboolean
handle_cmdline_args (const gchar **sarray)
{
	for (gint i = 0; sarray && sarray[i]; i++)
		parse_peercast_url(sarray[i], false);
	return FALSE;
}

// ----------------------------------
int
main (gint argc, gchar* argv[])
{
	GnomeProgram *program;
	GError *error = NULL;
	GnomeClient *client;
	GnomePeercastApp *myapp;
	gboolean no_gui = FALSE;
	const gchar **sarray = NULL;
	GOptionContext *ctx;
	GOptionEntry entries[] = {
		{ "no-gui", 0, 0, G_OPTION_ARG_NONE, &no_gui, N_("run without GUI"), NULL },
		{ "url", 'u', 0, G_OPTION_ARG_STRING_ARRAY, &sarray, N_("peercast:// URL"), "URL" },
		{ NULL }
	};

#ifdef ENABLE_NLS
	bindtextdomain (GETTEXT_PACKAGE, GNOME_LOCALEDIR);
	bind_textdomain_codeset (GETTEXT_PACKAGE, "UTF-8");
	textdomain (GETTEXT_PACKAGE);
#endif

	ctx = g_option_context_new ("- GNOME Peercast front end");
	g_option_context_set_help_enabled (ctx, FALSE);
	g_option_context_set_ignore_unknown_options (ctx, TRUE);
	g_option_context_add_main_entries (ctx, entries, GETTEXT_PACKAGE);
	g_option_context_add_group (ctx, gtk_get_option_group (TRUE));
	g_assert (g_option_context_parse (ctx, &argc, &argv, &error) != FALSE);

	if (no_gui)
		g_warning ("NO GUI MODE");

	if (g_file_test ("peercast.ini", G_FILE_TEST_EXISTS))
		iniFileName.set("peercast.ini");
	else {
		gchar p[4096];
		g_snprintf(p, sizeof(p), "%s/.peercast.ini", g_get_home_dir());
		iniFileName.set(p);
	}

	peercastInst = new MyPeercastInst();
	if (! no_gui) {
		program = gnome_program_init (PACKAGE,
					      "0.1212g0.1",
					      LIBGNOMEUI_MODULE,
					      argc, argv,
					      GNOME_PARAM_HUMAN_READABLE_NAME, _("GNOME PeerCast"),
					      NULL);
	
		gnome_window_icon_set_default_from_file (ICON_DIR"/peercast.png");
		client = gnome_master_client ();
		g_signal_connect (client, "die", G_CALLBACK (client_die_cb), NULL);
	}

	myapp = new GnomePeercastApp();
	if (! no_gui)
		myapp->guiInit ();

	if (gconf_init (argc, argv, &error) == FALSE) {
			g_assert (error != NULL);
			g_message ("GConf init failed: %s", error->message);
			g_error_free (error);
			exit (EXIT_FAILURE);
	}
	
	peercastApp = (PeercastApplication *)myapp;
	peercastInst->init();

	myapp->gconfInit ();
	myapp->infoInit ();

	handle_cmdline_args (sarray);

	gtk_main();

	peercastInst->saveSettings ();
	peercastInst->quit ();

	return 0;
}
