
#ifndef __CHANINFO_DIALOG_H__
#define __CHANINFO_DIALOG_H__

#include <gtk/gtktooltips.h>

class ChaninfoDialog
{
public:
    ChaninfoDialog (Channel *ch, GtkWindow *window);

    GtkWidget * getWidget (const gchar *);
    void signalConnect (const gchar *handler,
                        GCallback callback, gpointer data) {
        glade_xml_signal_connect_data (xml, handler, callback, data);
    };
    void applyMetaInfo (void);
    void setInfo (void);
    void setHitList (void);
    void removeUpdate (void);
    
private:
    GtkWindow *parent;
    void disableApply (void);

    gint timeout_source;
    gint hit_list_timeout_source;

    GtkTreeView *treeview;
    
    GtkTooltips *tips;
    Channel *channel;
    GladeXML *xml;
};

#endif
