/* retro-runner.c generated by valac 0.38.0, the Vala compiler
 * generated from retro-runner.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <retro-gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <glib/gstdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define GAMES_TYPE_RUNNER (games_runner_get_type ())
#define GAMES_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RUNNER, GamesRunner))
#define GAMES_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RUNNER))
#define GAMES_RUNNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_RUNNER, GamesRunnerIface))

typedef struct _GamesRunner GamesRunner;
typedef struct _GamesRunnerIface GamesRunnerIface;

#define GAMES_TYPE_MEDIA_SET (games_media_set_get_type ())
#define GAMES_MEDIA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEDIA_SET, GamesMediaSet))
#define GAMES_MEDIA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEDIA_SET, GamesMediaSetClass))
#define GAMES_IS_MEDIA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEDIA_SET))
#define GAMES_IS_MEDIA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEDIA_SET))
#define GAMES_MEDIA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEDIA_SET, GamesMediaSetClass))

typedef struct _GamesMediaSet GamesMediaSet;
typedef struct _GamesMediaSetClass GamesMediaSetClass;

#define GAMES_TYPE_RETRO_RUNNER (games_retro_runner_get_type ())
#define GAMES_RETRO_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner))
#define GAMES_RETRO_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_RUNNER, GamesRetroRunnerClass))
#define GAMES_IS_RETRO_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_RUNNER))
#define GAMES_IS_RETRO_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_RUNNER))
#define GAMES_RETRO_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_RUNNER, GamesRetroRunnerClass))

typedef struct _GamesRetroRunner GamesRetroRunner;
typedef struct _GamesRetroRunnerClass GamesRetroRunnerClass;
typedef struct _GamesRetroRunnerPrivate GamesRetroRunnerPrivate;

#define GAMES_TYPE_RETRO_INPUT_MANAGER (games_retro_input_manager_get_type ())
#define GAMES_RETRO_INPUT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManager))
#define GAMES_RETRO_INPUT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManagerClass))
#define GAMES_IS_RETRO_INPUT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER))
#define GAMES_IS_RETRO_INPUT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_INPUT_MANAGER))
#define GAMES_RETRO_INPUT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManagerClass))

typedef struct _GamesRetroInputManager GamesRetroInputManager;
typedef struct _GamesRetroInputManagerClass GamesRetroInputManagerClass;

#define GAMES_TYPE_RETRO_CORE_SOURCE (games_retro_core_source_get_type ())
#define GAMES_RETRO_CORE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSource))
#define GAMES_RETRO_CORE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSourceClass))
#define GAMES_IS_RETRO_CORE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_CORE_SOURCE))
#define GAMES_IS_RETRO_CORE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_CORE_SOURCE))
#define GAMES_RETRO_CORE_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSourceClass))

typedef struct _GamesRetroCoreSource GamesRetroCoreSource;
typedef struct _GamesRetroCoreSourceClass GamesRetroCoreSourceClass;

#define GAMES_TYPE_UID (games_uid_get_type ())
#define GAMES_UID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_UID, GamesUid))
#define GAMES_IS_UID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_UID))
#define GAMES_UID_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_UID, GamesUidIface))

typedef struct _GamesUid GamesUid;
typedef struct _GamesUidIface GamesUidIface;

#define GAMES_TYPE_INPUT_CAPABILITIES (games_input_capabilities_get_type ())
#define GAMES_INPUT_CAPABILITIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_INPUT_CAPABILITIES, GamesInputCapabilities))
#define GAMES_IS_INPUT_CAPABILITIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_INPUT_CAPABILITIES))
#define GAMES_INPUT_CAPABILITIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_INPUT_CAPABILITIES, GamesInputCapabilitiesIface))

typedef struct _GamesInputCapabilities GamesInputCapabilities;
typedef struct _GamesInputCapabilitiesIface GamesInputCapabilitiesIface;

#define GAMES_TYPE_TITLE (games_title_get_type ())
#define GAMES_TITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_TITLE, GamesTitle))
#define GAMES_IS_TITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_TITLE))
#define GAMES_TITLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_TITLE, GamesTitleIface))

typedef struct _GamesTitle GamesTitle;
typedef struct _GamesTitleIface GamesTitleIface;
enum  {
	GAMES_RETRO_RUNNER_DUMMY_PROPERTY,
	GAMES_RETRO_RUNNER_CAN_FULLSCREEN,
	GAMES_RETRO_RUNNER_CAN_QUIT_SAFELY,
	GAMES_RETRO_RUNNER_CAN_RESUME,
	GAMES_RETRO_RUNNER_MEDIA_SET,
	GAMES_RETRO_RUNNER_LAST_PROPERTY
};
static GParamSpec* games_retro_runner_properties[GAMES_RETRO_RUNNER_LAST_PROPERTY];
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_URI (games_uri_get_type ())
#define GAMES_URI(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_URI, GamesUri))
#define GAMES_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_URI, GamesUriClass))
#define GAMES_IS_URI(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_URI))
#define GAMES_IS_URI_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_URI))
#define GAMES_URI_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_URI, GamesUriClass))

typedef struct _GamesUri GamesUri;
typedef struct _GamesUriClass GamesUriClass;

#define GAMES_TYPE_MEDIA (games_media_get_type ())
#define GAMES_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEDIA, GamesMedia))
#define GAMES_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEDIA, GamesMediaClass))
#define GAMES_IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEDIA))
#define GAMES_IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEDIA))
#define GAMES_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEDIA, GamesMediaClass))

typedef struct _GamesMedia GamesMedia;
typedef struct _GamesMediaClass GamesMediaClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block5Data Block5Data;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GamesRunnerIface {
	GTypeInterface parent_iface;
	gboolean (*check_is_valid) (GamesRunner* self, gchar* * error_message, GError** error);
	GtkWidget* (*get_display) (GamesRunner* self);
	void (*start) (GamesRunner* self, GError** error);
	void (*resume) (GamesRunner* self, GError** error);
	void (*pause) (GamesRunner* self);
	void (*stop) (GamesRunner* self);
	gboolean (*get_can_fullscreen) (GamesRunner* self);
	gboolean (*get_can_quit_safely) (GamesRunner* self);
	gboolean (*get_can_resume) (GamesRunner* self);
	GamesMediaSet* (*get_media_set) (GamesRunner* self);
};

struct _GamesRetroRunner {
	GObject parent_instance;
	GamesRetroRunnerPrivate * priv;
};

struct _GamesRetroRunnerClass {
	GObjectClass parent_class;
};

struct _GamesUidIface {
	GTypeInterface parent_iface;
	gchar* (*get_uid) (GamesUid* self, GError** error);
};

struct _GamesInputCapabilitiesIface {
	GTypeInterface parent_iface;
	gboolean (*get_allow_classic_gamepads) (GamesInputCapabilities* self, GError** error);
	gboolean (*get_allow_analog_gamepads) (GamesInputCapabilities* self, GError** error);
};

struct _GamesTitleIface {
	GTypeInterface parent_iface;
	gchar* (*get_title) (GamesTitle* self, GError** error);
};

struct _GamesRetroRunnerPrivate {
	GamesMediaSet* _media_set;
	RetroCore* core;
	RetroCoreView* view;
	RetroCairoDisplay* video;
	RetroPaPlayer* audio;
	GamesRetroInputManager* input_manager;
	RetroMainLoop* loop;
	gchar* save_directory_path;
	gchar* save_path;
	gchar* snapshot_path;
	gchar* screenshot_path;
	RetroCoreDescriptor* core_descriptor;
	GamesRetroCoreSource* core_source;
	GamesUid* uid;
	GamesInputCapabilities* input_capabilities;
	GSettings* settings;
	GamesTitle* game_title;
	gboolean _running;
	gboolean is_initialized;
	gboolean is_ready;
	gboolean should_save;
};

typedef enum  {
	GAMES_RETRO_ERROR_MODULE_NOT_FOUND,
	GAMES_RETRO_ERROR_INVALID_GAME_FILE,
	GAMES_RETRO_ERROR_COULDNT_WRITE_SNAPSHOT,
	GAMES_RETRO_ERROR_COULDNT_LOAD_SNAPSHOT,
	GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND
} GamesRetroError;
#define GAMES_RETRO_ERROR games_retro_error_quark ()
struct _Block5Data {
	int _ref_count_;
	GamesRetroRunner* self;
	gchar** medias_uris;
	gint medias_uris_length1;
	gint _medias_uris_size_;
};

typedef void (*GamesMediaSetMediaCallback) (GamesMedia* media, void* user_data);

static gpointer games_retro_runner_parent_class = NULL;
static GamesRunnerIface * games_retro_runner_games_runner_parent_iface = NULL;

GType games_media_set_get_type (void) G_GNUC_CONST;
GType games_runner_get_type (void) G_GNUC_CONST;
GType games_retro_runner_get_type (void) G_GNUC_CONST;
GType games_retro_input_manager_get_type (void) G_GNUC_CONST;
GType games_retro_core_source_get_type (void) G_GNUC_CONST;
GType games_uid_get_type (void) G_GNUC_CONST;
GType games_input_capabilities_get_type (void) G_GNUC_CONST;
GType games_title_get_type (void) G_GNUC_CONST;
#define GAMES_RETRO_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_RETRO_RUNNER, GamesRetroRunnerPrivate))
void games_runner_pause (GamesRunner* self);
static void games_retro_runner_deinit (GamesRetroRunner* self);
gpointer games_uri_ref (gpointer instance);
void games_uri_unref (gpointer instance);
GParamSpec* games_param_spec_uri (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void games_value_set_uri (GValue* value, gpointer v_object);
void games_value_take_uri (GValue* value, gpointer v_object);
gpointer games_value_get_uri (const GValue* value);
GType games_uri_get_type (void) G_GNUC_CONST;
GamesRetroRunner* games_retro_runner_new (GamesRetroCoreSource* core_source, GamesUri* uri, GamesUid* uid, GamesTitle* game_title);
GamesRetroRunner* games_retro_runner_construct (GType object_type, GamesRetroCoreSource* core_source, GamesUri* uri, GamesUid* uid, GamesTitle* game_title);
GType games_media_get_type (void) G_GNUC_CONST;
GamesMedia* games_media_new (GamesTitle* title);
GamesMedia* games_media_construct (GType object_type, GamesTitle* title);
void games_media_add_uri (GamesMedia* self, GamesUri* uri);
GamesMediaSet* games_media_set_new (void);
GamesMediaSet* games_media_set_construct (GType object_type);
void games_media_set_add_media (GamesMediaSet* self, GamesMedia* media);
GamesRetroRunner* games_retro_runner_new_for_media_set_and_input_capabilities (GamesRetroCoreSource* core_source, GamesMediaSet* media_set, GamesUid* uid, GamesInputCapabilities* input_capabilities, GamesTitle* game_title);
GamesRetroRunner* games_retro_runner_construct_for_media_set_and_input_capabilities (GType object_type, GamesRetroCoreSource* core_source, GamesMediaSet* media_set, GamesUid* uid, GamesInputCapabilities* input_capabilities, GamesTitle* game_title);
static void games_retro_runner_on_media_number_changed (GamesRetroRunner* self);
static void _games_retro_runner_on_media_number_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GamesRetroRunner* games_retro_runner_new_for_core_descriptor (RetroCoreDescriptor* core_descriptor, GamesUid* uid, GamesTitle* game_title);
GamesRetroRunner* games_retro_runner_construct_for_core_descriptor (GType object_type, RetroCoreDescriptor* core_descriptor, GamesUid* uid, GamesTitle* game_title);
static gboolean games_retro_runner_real_check_is_valid (GamesRunner* base, gchar* * error_message, GError** error);
static void games_retro_runner_load_media_data (GamesRetroRunner* self, GError** error);
static void games_retro_runner_init (GamesRetroRunner* self, GError** error);
GQuark games_retro_error_quark (void);
static gchar* games_retro_runner_get_unsupported_system_message (GamesRetroRunner* self);
static GtkWidget* games_retro_runner_real_get_display (GamesRunner* base);
static void games_retro_runner_real_start (GamesRunner* base, GError** error);
static void games_retro_runner_load_ram (GamesRetroRunner* self, GError** error);
static void games_retro_runner_set_running (GamesRetroRunner* self, gboolean value);
static void games_retro_runner_real_resume (GamesRunner* base, GError** error);
static void games_retro_runner_load_snapshot (GamesRetroRunner* self, GError** error);
static void games_retro_runner_on_video_filter_changed (GamesRetroRunner* self);
static void _games_retro_runner_on_video_filter_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
gboolean games_input_capabilities_get_allow_analog_gamepads (GamesInputCapabilities* self, GError** error);
GamesRetroInputManager* games_retro_input_manager_new (RetroCoreView* view, gboolean present_analog_sticks);
GamesRetroInputManager* games_retro_input_manager_construct (GType object_type, RetroCoreView* view, gboolean present_analog_sticks);
static void games_retro_runner_prepare_core (GamesRetroRunner* self, GError** error);
static gboolean games_retro_runner_on_shutdown (GamesRetroRunner* self);
static gboolean _games_retro_runner_on_shutdown_retro_core_shutdown (RetroCore* _sender, gpointer self);
static void games_retro_runner_load_screenshot (GamesRetroRunner* self, GError** error);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
gchar* games_retro_core_source_get_module_path (GamesRetroCoreSource* self, GError** error);
gchar* games_application_get_platforms_dir (void);
gchar* games_retro_core_source_get_platform (GamesRetroCoreSource* self);
static gchar* games_retro_runner_get_save_directory_path (GamesRetroRunner* self, GError** error);
static void games_retro_runner_try_make_dir (const gchar* path);
static void _retro_g_log_retro_core_log (RetroCore* _sender, const gchar* log_domain, GLogLevelFlags log_level, const gchar* message, gpointer self);
GamesMediaSet* games_runner_get_media_set (GamesRunner* self);
void games_media_set_foreach_media (GamesMediaSet* self, GamesMediaSetMediaCallback media_callback, void* media_callback_target);
static void __lambda24_ (Block5Data* _data5_, GamesMedia* media);
GamesUri** games_media_get_uris (GamesMedia* self, int* result_length1);
gchar* games_uri_to_string (GamesUri* self);
static void _vala_array_add15 (gchar** * array, int* length, int* size, gchar* value);
static void ___lambda24__games_media_set_media_callback (GamesMedia* media, gpointer self);
gint games_media_set_get_selected_media_number (GamesMediaSet* self);
static void games_retro_runner_real_pause (GamesRunner* base);
static void games_retro_runner_save (GamesRetroRunner* self, GError** error);
static void games_retro_runner_real_stop (GamesRunner* base);
GamesMedia* games_media_set_get_selected_media (GamesMediaSet* self, guint index, GError** error);
static void games_retro_runner_save_media_data (GamesRetroRunner* self, GError** error);
static void games_retro_runner_save_ram (GamesRetroRunner* self, GError** error);
gint games_media_set_get_size (GamesMediaSet* self);
static void games_retro_runner_save_snapshot (GamesRetroRunner* self, GError** error);
static void games_retro_runner_save_screenshot (GamesRetroRunner* self, GError** error);
gchar* games_application_get_saves_dir (void);
gchar* games_uid_get_uid (GamesUid* self, GError** error);
static gchar* games_retro_runner_get_save_path (GamesRetroRunner* self, GError** error);
static gchar* games_retro_runner_get_snapshot_path (GamesRetroRunner* self, GError** error);
gchar* games_application_get_snapshots_dir (void);
gchar* games_application_get_medias_dir (void);
static gchar* games_retro_runner_get_medias_path (GamesRetroRunner* self, GError** error);
void games_media_set_set_selected_media_number (GamesMediaSet* self, gint value);
static gchar* games_retro_runner_get_screenshot_path (GamesRetroRunner* self, GError** error);
gchar* games_retro_platform_get_platform_name (const gchar* platform);
gchar* games_title_get_title (GamesTitle* self, GError** error);
void games_runner_stop (GamesRunner* self);
static gboolean games_retro_runner_get_running (GamesRetroRunner* self);
static GObject * games_retro_runner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void games_retro_runner_finalize (GObject * obj);
gboolean games_runner_get_can_fullscreen (GamesRunner* self);
gboolean games_runner_get_can_quit_safely (GamesRunner* self);
gboolean games_runner_get_can_resume (GamesRunner* self);
static void _vala_games_retro_runner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_games_retro_runner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesRetroRunner* games_retro_runner_construct (GType object_type, GamesRetroCoreSource* core_source, GamesUri* uri, GamesUid* uid, GamesTitle* game_title) {
	GamesRetroRunner * self = NULL;
	GamesMedia* game_media = NULL;
	GamesMedia* _tmp0_;
	GamesUri* _tmp1_;
	GamesMediaSet* _tmp2_;
	GamesMediaSet* _tmp3_;
	GamesUid* _tmp4_;
	GamesUid* _tmp5_;
	GamesRetroCoreSource* _tmp6_;
	GamesRetroCoreSource* _tmp7_;
	GamesTitle* _tmp8_;
	GamesTitle* _tmp9_;
	g_return_val_if_fail (core_source != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (game_title != NULL, NULL);
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	self->priv->is_initialized = FALSE;
	self->priv->is_ready = FALSE;
	self->priv->should_save = FALSE;
	_g_object_unref0 (self->priv->core_descriptor);
	self->priv->core_descriptor = NULL;
	_tmp0_ = games_media_new (NULL);
	game_media = _tmp0_;
	_tmp1_ = uri;
	games_media_add_uri (game_media, _tmp1_);
	_tmp2_ = games_media_set_new ();
	_g_object_unref0 (self->priv->_media_set);
	self->priv->_media_set = _tmp2_;
	_tmp3_ = self->priv->_media_set;
	games_media_set_add_media (_tmp3_, game_media);
	_tmp4_ = uid;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->uid);
	self->priv->uid = _tmp5_;
	_tmp6_ = core_source;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->core_source);
	self->priv->core_source = _tmp7_;
	_g_object_unref0 (self->priv->input_capabilities);
	self->priv->input_capabilities = NULL;
	_tmp8_ = game_title;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->game_title);
	self->priv->game_title = _tmp9_;
	_g_object_unref0 (game_media);
	return self;
}


GamesRetroRunner* games_retro_runner_new (GamesRetroCoreSource* core_source, GamesUri* uri, GamesUid* uid, GamesTitle* game_title) {
	return games_retro_runner_construct (GAMES_TYPE_RETRO_RUNNER, core_source, uri, uid, game_title);
}


static void _games_retro_runner_on_media_number_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	games_retro_runner_on_media_number_changed ((GamesRetroRunner*) self);
}


GamesRetroRunner* games_retro_runner_construct_for_media_set_and_input_capabilities (GType object_type, GamesRetroCoreSource* core_source, GamesMediaSet* media_set, GamesUid* uid, GamesInputCapabilities* input_capabilities, GamesTitle* game_title) {
	GamesRetroRunner * self = NULL;
	GamesRetroCoreSource* _tmp0_;
	GamesRetroCoreSource* _tmp1_;
	GamesMediaSet* _tmp2_;
	GamesMediaSet* _tmp3_;
	GamesUid* _tmp4_;
	GamesUid* _tmp5_;
	GamesInputCapabilities* _tmp6_;
	GamesInputCapabilities* _tmp7_;
	GamesTitle* _tmp8_;
	GamesTitle* _tmp9_;
	GamesMediaSet* _tmp10_;
	g_return_val_if_fail (core_source != NULL, NULL);
	g_return_val_if_fail (media_set != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (input_capabilities != NULL, NULL);
	g_return_val_if_fail (game_title != NULL, NULL);
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	self->priv->is_initialized = FALSE;
	self->priv->is_ready = FALSE;
	self->priv->should_save = FALSE;
	_g_object_unref0 (self->priv->core_descriptor);
	self->priv->core_descriptor = NULL;
	_tmp0_ = core_source;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->core_source);
	self->priv->core_source = _tmp1_;
	_tmp2_ = media_set;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_media_set);
	self->priv->_media_set = _tmp3_;
	_tmp4_ = uid;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->uid);
	self->priv->uid = _tmp5_;
	_tmp6_ = input_capabilities;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->input_capabilities);
	self->priv->input_capabilities = _tmp7_;
	_tmp8_ = game_title;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->game_title);
	self->priv->game_title = _tmp9_;
	_tmp10_ = self->priv->_media_set;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::selected-media-number", (GCallback) _games_retro_runner_on_media_number_changed_g_object_notify, self, 0);
	return self;
}


GamesRetroRunner* games_retro_runner_new_for_media_set_and_input_capabilities (GamesRetroCoreSource* core_source, GamesMediaSet* media_set, GamesUid* uid, GamesInputCapabilities* input_capabilities, GamesTitle* game_title) {
	return games_retro_runner_construct_for_media_set_and_input_capabilities (GAMES_TYPE_RETRO_RUNNER, core_source, media_set, uid, input_capabilities, game_title);
}


GamesRetroRunner* games_retro_runner_construct_for_core_descriptor (GType object_type, RetroCoreDescriptor* core_descriptor, GamesUid* uid, GamesTitle* game_title) {
	GamesRetroRunner * self = NULL;
	RetroCoreDescriptor* _tmp0_;
	RetroCoreDescriptor* _tmp1_;
	GamesMediaSet* _tmp2_;
	GamesUid* _tmp3_;
	GamesUid* _tmp4_;
	GamesTitle* _tmp5_;
	GamesTitle* _tmp6_;
	g_return_val_if_fail (core_descriptor != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (game_title != NULL, NULL);
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	self->priv->is_initialized = FALSE;
	self->priv->is_ready = FALSE;
	self->priv->should_save = FALSE;
	_tmp0_ = core_descriptor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->core_descriptor);
	self->priv->core_descriptor = _tmp1_;
	_g_object_unref0 (self->priv->core_source);
	self->priv->core_source = NULL;
	_tmp2_ = games_media_set_new ();
	_g_object_unref0 (self->priv->_media_set);
	self->priv->_media_set = _tmp2_;
	_tmp3_ = uid;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (self->priv->uid);
	self->priv->uid = _tmp4_;
	_g_object_unref0 (self->priv->input_capabilities);
	self->priv->input_capabilities = NULL;
	_tmp5_ = game_title;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->game_title);
	self->priv->game_title = _tmp6_;
	return self;
}


GamesRetroRunner* games_retro_runner_new_for_core_descriptor (RetroCoreDescriptor* core_descriptor, GamesUid* uid, GamesTitle* game_title) {
	return games_retro_runner_construct_for_core_descriptor (GAMES_TYPE_RETRO_RUNNER, core_descriptor, uid, game_title);
}


static gboolean games_retro_runner_real_check_is_valid (GamesRunner* base, gchar* * error_message, GError** error) {
	GamesRetroRunner * self;
	gchar* _vala_error_message = NULL;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	{
		games_retro_runner_load_media_data (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch14_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch14_games_retro_error_firmware_not_found;
			}
			goto __finally14;
		}
		games_retro_runner_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch14_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch14_games_retro_error_firmware_not_found;
			}
			goto __finally14;
		}
	}
	goto __finally14;
	__catch14_games_retro_error_module_not_found:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_debug ("retro-runner.vala:133: %s", _tmp1_);
		_tmp2_ = games_retro_runner_get_unsupported_system_message (self);
		_g_free0 (_vala_error_message);
		_vala_error_message = _tmp2_;
		result = FALSE;
		_g_error_free0 (e);
		if (error_message) {
			*error_message = _vala_error_message;
		} else {
			_g_free0 (_vala_error_message);
		}
		return result;
	}
	goto __finally14;
	__catch14_games_retro_error_firmware_not_found:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("retro-runner.vala:139: %s", _tmp4_);
		_tmp5_ = games_retro_runner_get_unsupported_system_message (self);
		_g_free0 (_vala_error_message);
		_vala_error_message = _tmp5_;
		result = FALSE;
		_g_error_free0 (e);
		if (error_message) {
			*error_message = _vala_error_message;
		} else {
			_g_free0 (_vala_error_message);
		}
		return result;
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp6_;
	}
	result = TRUE;
	if (error_message) {
		*error_message = _vala_error_message;
	} else {
		_g_free0 (_vala_error_message);
	}
	return result;
}


static GtkWidget* games_retro_runner_real_get_display (GamesRunner* base) {
	GamesRetroRunner * self;
	GtkWidget* result = NULL;
	RetroCoreView* _tmp0_;
	GtkWidget* _tmp1_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->view;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


static void games_retro_runner_real_start (GamesRunner* base, GError** error) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	RetroMainLoop* _tmp1_;
	gboolean _tmp2_;
	RetroCore* _tmp3_;
	RetroMainLoop* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	games_retro_runner_load_media_data (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		games_retro_runner_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp1_ = self->priv->loop;
	retro_main_loop_stop (_tmp1_);
	_tmp2_ = self->priv->is_ready;
	if (!_tmp2_) {
		games_retro_runner_load_ram (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		self->priv->is_ready = TRUE;
	}
	_tmp3_ = self->priv->core;
	retro_core_reset (_tmp3_);
	_tmp4_ = self->priv->loop;
	retro_main_loop_start (_tmp4_);
	games_retro_runner_set_running (self, TRUE);
}


static void games_retro_runner_real_resume (GamesRunner* base, GError** error) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	RetroMainLoop* _tmp1_;
	gboolean _tmp2_;
	RetroMainLoop* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		games_retro_runner_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp1_ = self->priv->loop;
	retro_main_loop_stop (_tmp1_);
	_tmp2_ = self->priv->is_ready;
	if (!_tmp2_) {
		RetroCore* _tmp3_;
		games_retro_runner_load_ram (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp3_ = self->priv->core;
		retro_core_reset (_tmp3_);
		games_retro_runner_load_snapshot (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		self->priv->is_ready = TRUE;
	}
	_tmp4_ = self->priv->loop;
	retro_main_loop_start (_tmp4_);
	games_retro_runner_set_running (self, TRUE);
}


static void _games_retro_runner_on_video_filter_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	games_retro_runner_on_video_filter_changed ((GamesRetroRunner*) self);
}


static gboolean _games_retro_runner_on_shutdown_retro_core_shutdown (RetroCore* _sender, gpointer self) {
	gboolean result;
	result = games_retro_runner_on_shutdown ((GamesRetroRunner*) self);
	return result;
}


static void games_retro_runner_init (GamesRetroRunner* self, GError** error) {
	gboolean _tmp0_;
	RetroCoreView* _tmp1_;
	RetroCoreView* _tmp2_;
	RetroCairoDisplay* _tmp3_;
	GSettings* _tmp4_;
	RetroCairoDisplay* _tmp5_;
	gboolean _tmp6_ = FALSE;
	GamesInputCapabilities* _tmp7_;
	gboolean present_analog_sticks = FALSE;
	RetroCoreView* _tmp11_;
	gboolean _tmp12_;
	GamesRetroInputManager* _tmp13_;
	RetroCore* _tmp14_;
	RetroCore* _tmp15_;
	RetroCore* _tmp16_;
	RetroMainLoop* _tmp17_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_initialized;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = retro_core_view_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->view);
	self->priv->view = _tmp1_;
	_tmp2_ = self->priv->view;
	_tmp3_ = retro_core_view_get_display (_tmp2_);
	_g_object_unref0 (self->priv->video);
	self->priv->video = _tmp3_;
	_tmp4_ = self->priv->settings;
	g_signal_connect_object (_tmp4_, "changed::video-filter", (GCallback) _games_retro_runner_on_video_filter_changed_g_settings_changed, self, 0);
	games_retro_runner_on_video_filter_changed (self);
	_tmp5_ = self->priv->video;
	gtk_widget_set_visible ((GtkWidget*) _tmp5_, TRUE);
	_tmp7_ = self->priv->input_capabilities;
	if (_tmp7_ == NULL) {
		_tmp6_ = TRUE;
	} else {
		gboolean _tmp8_ = FALSE;
		GamesInputCapabilities* _tmp9_;
		gboolean _tmp10_;
		_tmp9_ = self->priv->input_capabilities;
		_tmp10_ = games_input_capabilities_get_allow_analog_gamepads (_tmp9_, &_inner_error_);
		_tmp8_ = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp6_ = _tmp8_;
	}
	present_analog_sticks = _tmp6_;
	_tmp11_ = self->priv->view;
	_tmp12_ = present_analog_sticks;
	_tmp13_ = games_retro_input_manager_new (_tmp11_, _tmp12_);
	_g_object_unref0 (self->priv->input_manager);
	self->priv->input_manager = _tmp13_;
	games_retro_runner_prepare_core (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp14_ = self->priv->core;
	g_signal_connect_object (_tmp14_, "shutdown", (GCallback) _games_retro_runner_on_shutdown_retro_core_shutdown, self, 0);
	_tmp15_ = self->priv->core;
	retro_core_run (_tmp15_);
	_tmp16_ = self->priv->core;
	_tmp17_ = retro_main_loop_new (_tmp16_);
	_g_object_unref0 (self->priv->loop);
	self->priv->loop = _tmp17_;
	games_retro_runner_set_running (self, FALSE);
	games_retro_runner_load_screenshot (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	self->priv->is_initialized = TRUE;
}


static void games_retro_runner_deinit (GamesRetroRunner* self) {
	gboolean _tmp0_;
	GSettings* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	RetroCoreView* _tmp4_;
	RetroPaPlayer* _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->settings;
	g_signal_parse_name ("changed::video-filter", g_settings_get_type (), &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _games_retro_runner_on_video_filter_changed_g_settings_changed, self);
	_g_object_unref0 (self->priv->core);
	self->priv->core = NULL;
	_tmp4_ = self->priv->view;
	retro_core_view_set_core (_tmp4_, NULL);
	_g_object_unref0 (self->priv->view);
	self->priv->view = NULL;
	_g_object_unref0 (self->priv->video);
	self->priv->video = NULL;
	_tmp5_ = self->priv->audio;
	retro_pa_player_set_core (_tmp5_, NULL);
	_g_object_unref0 (self->priv->audio);
	self->priv->audio = NULL;
	_g_object_unref0 (self->priv->input_manager);
	self->priv->input_manager = NULL;
	_g_object_unref0 (self->priv->loop);
	self->priv->loop = NULL;
	self->priv->_running = FALSE;
	self->priv->is_initialized = FALSE;
	self->priv->is_ready = FALSE;
	self->priv->should_save = FALSE;
}


static void games_retro_runner_on_video_filter_changed (GamesRetroRunner* self) {
	gchar* filter_name = NULL;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	RetroVideoFilter filter = 0;
	RetroVideoFilter _tmp2_;
	RetroCairoDisplay* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "video-filter");
	filter_name = _tmp1_;
	_tmp2_ = retro_video_filter_from_string (filter_name);
	filter = _tmp2_;
	_tmp3_ = self->priv->video;
	retro_cairo_display_set_filter (_tmp3_, filter);
	_g_free0 (filter_name);
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		GamesRetroRunner* self;
		self = _data5_->self;
		_data5_->medias_uris = (_vala_array_free (_data5_->medias_uris, _data5_->medias_uris_length1, (GDestroyNotify) g_free), NULL);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void _retro_g_log_retro_core_log (RetroCore* _sender, const gchar* log_domain, GLogLevelFlags log_level, const gchar* message, gpointer self) {
	retro_g_log (_sender, log_domain, log_level, message);
}


static void _vala_array_add15 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void __lambda24_ (Block5Data* _data5_, GamesMedia* media) {
	GamesRetroRunner* self;
	GamesUri** uris = NULL;
	GamesMedia* _tmp0_;
	gint _tmp1_;
	GamesUri** _tmp2_;
	gint uris_length1;
	gint _uris_size_;
	gchar* _tmp3_ = NULL;
	GamesUri** _tmp4_;
	gint _tmp4__length1;
	gchar** _tmp9_;
	gint _tmp9__length1;
	gchar* _tmp10_;
	self = _data5_->self;
	g_return_if_fail (media != NULL);
	_tmp0_ = media;
	_tmp2_ = games_media_get_uris (_tmp0_, &_tmp1_);
	uris = _tmp2_;
	uris_length1 = _tmp1_;
	_uris_size_ = uris_length1;
	_tmp4_ = uris;
	_tmp4__length1 = uris_length1;
	if (_tmp4__length1 == 0) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup ("");
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp5_;
	} else {
		GamesUri** _tmp6_;
		gint _tmp6__length1;
		GamesUri* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = uris;
		_tmp6__length1 = uris_length1;
		_tmp7_ = _tmp6_[0];
		_tmp8_ = games_uri_to_string (_tmp7_);
		_g_free0 (_tmp3_);
		_tmp3_ = _tmp8_;
	}
	_tmp9_ = _data5_->medias_uris;
	_tmp9__length1 = _data5_->medias_uris_length1;
	_tmp10_ = g_strdup (_tmp3_);
	_vala_array_add15 (&_data5_->medias_uris, &_data5_->medias_uris_length1, &_data5_->_medias_uris_size_, _tmp10_);
	_g_free0 (_tmp3_);
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
}


static void ___lambda24__games_media_set_media_callback (GamesMedia* media, gpointer self) {
	__lambda24_ (self, media);
}


static void games_retro_runner_prepare_core (GamesRetroRunner* self, GError** error) {
	Block5Data* _data5_;
	gchar* module_path = NULL;
	RetroCoreDescriptor* _tmp0_;
	const gchar* _tmp14_;
	RetroCore* _tmp15_;
	RetroPaPlayer* _tmp16_;
	GamesRetroCoreSource* _tmp17_;
	RetroCore* _tmp32_;
	RetroCoreView* _tmp33_;
	RetroCore* _tmp34_;
	RetroPaPlayer* _tmp35_;
	RetroCore* _tmp36_;
	RetroCore* _tmp37_;
	GamesRetroInputManager* _tmp38_;
	RetroCore* _tmp39_;
	GamesRetroInputManager* _tmp40_;
	gchar** _tmp41_;
	GamesMediaSet* _tmp42_;
	GamesMediaSet* _tmp43_;
	RetroCore* _tmp44_;
	gchar** _tmp45_;
	gint _tmp45__length1;
	RetroCore* _tmp46_;
	RetroCore* _tmp47_;
	GamesMediaSet* _tmp48_;
	GamesMediaSet* _tmp49_;
	gint _tmp50_;
	gint _tmp51_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_data5_->self = g_object_ref (self);
	_tmp0_ = self->priv->core_descriptor;
	if (_tmp0_ != NULL) {
		GFile* module_file = NULL;
		RetroCoreDescriptor* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		GFile* _tmp8_;
		gchar* _tmp9_;
		_tmp1_ = self->priv->core_descriptor;
		_tmp2_ = retro_core_descriptor_get_module_file (_tmp1_, &_inner_error_);
		module_file = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (module_path);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return;
		}
		_tmp3_ = module_file;
		if (_tmp3_ == NULL) {
			gchar* _tmp4_ = NULL;
			RetroCoreDescriptor* _tmp5_;
			gchar* _tmp6_;
			GError* _tmp7_;
			_tmp5_ = self->priv->core_descriptor;
			_tmp6_ = retro_core_descriptor_get_name (_tmp5_, &_inner_error_);
			_tmp4_ = _tmp6_;
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				g_propagate_error (error, _inner_error_);
				_g_object_unref0 (module_file);
				_g_free0 (module_path);
				block5_data_unref (_data5_);
				_data5_ = NULL;
				return;
			}
			_tmp7_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND, _ ("No module found for “%s”."), _tmp4_);
			_inner_error_ = _tmp7_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (_tmp4_);
			_g_object_unref0 (module_file);
			_g_free0 (module_path);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return;
		}
		_tmp8_ = module_file;
		_tmp9_ = g_file_get_path (_tmp8_);
		_g_free0 (module_path);
		module_path = _tmp9_;
		_g_object_unref0 (module_file);
	} else {
		gchar* _tmp10_ = NULL;
		GamesRetroCoreSource* _tmp11_;
		gchar* _tmp12_;
		gchar* _tmp13_;
		_tmp11_ = self->priv->core_source;
		_tmp12_ = games_retro_core_source_get_module_path (_tmp11_, &_inner_error_);
		_tmp10_ = _tmp12_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (module_path);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return;
		}
		_tmp13_ = _tmp10_;
		_tmp10_ = NULL;
		_g_free0 (module_path);
		module_path = _tmp13_;
		_g_free0 (_tmp10_);
	}
	_tmp14_ = module_path;
	_tmp15_ = retro_core_new (_tmp14_);
	_g_object_unref0 (self->priv->core);
	self->priv->core = _tmp15_;
	_tmp16_ = retro_pa_player_new ();
	_g_object_unref0 (self->priv->audio);
	self->priv->audio = _tmp16_;
	_tmp17_ = self->priv->core_source;
	if (_tmp17_ != NULL) {
		gchar* platforms_dir = NULL;
		gchar* _tmp18_;
		gchar* platform = NULL;
		GamesRetroCoreSource* _tmp19_;
		gchar* _tmp20_;
		RetroCore* _tmp21_;
		const gchar* _tmp22_;
		const gchar* _tmp23_;
		const gchar* _tmp24_;
		const gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* save_directory = NULL;
		gchar* _tmp28_;
		const gchar* _tmp29_;
		RetroCore* _tmp30_;
		const gchar* _tmp31_;
		_tmp18_ = games_application_get_platforms_dir ();
		platforms_dir = _tmp18_;
		_tmp19_ = self->priv->core_source;
		_tmp20_ = games_retro_core_source_get_platform (_tmp19_);
		platform = _tmp20_;
		_tmp21_ = self->priv->core;
		_tmp22_ = platforms_dir;
		_tmp23_ = string_to_string (_tmp22_);
		_tmp24_ = platform;
		_tmp25_ = string_to_string (_tmp24_);
		_tmp26_ = g_strconcat (_tmp23_, "/", _tmp25_, "/system", NULL);
		_tmp27_ = _tmp26_;
		retro_core_set_system_directory (_tmp21_, _tmp27_);
		_g_free0 (_tmp27_);
		_tmp28_ = games_retro_runner_get_save_directory_path (self, &_inner_error_);
		save_directory = _tmp28_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (platform);
			_g_free0 (platforms_dir);
			_g_free0 (module_path);
			block5_data_unref (_data5_);
			_data5_ = NULL;
			return;
		}
		_tmp29_ = save_directory;
		games_retro_runner_try_make_dir (_tmp29_);
		_tmp30_ = self->priv->core;
		_tmp31_ = save_directory;
		retro_core_set_save_directory (_tmp30_, _tmp31_);
		_g_free0 (save_directory);
		_g_free0 (platform);
		_g_free0 (platforms_dir);
	}
	_tmp32_ = self->priv->core;
	g_signal_connect (_tmp32_, "log", (GCallback) _retro_g_log_retro_core_log, NULL);
	_tmp33_ = self->priv->view;
	_tmp34_ = self->priv->core;
	retro_core_view_set_core (_tmp33_, _tmp34_);
	_tmp35_ = self->priv->audio;
	_tmp36_ = self->priv->core;
	retro_pa_player_set_core (_tmp35_, _tmp36_);
	_tmp37_ = self->priv->core;
	_tmp38_ = self->priv->input_manager;
	retro_core_set_input_interface (_tmp37_, (RetroInput*) _tmp38_);
	_tmp39_ = self->priv->core;
	_tmp40_ = self->priv->input_manager;
	retro_core_set_rumble_interface (_tmp39_, (RetroRumble*) _tmp40_);
	_tmp41_ = g_new0 (gchar*, 0 + 1);
	_data5_->medias_uris = _tmp41_;
	_data5_->medias_uris_length1 = 0;
	_data5_->_medias_uris_size_ = _data5_->medias_uris_length1;
	_tmp42_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp43_ = _tmp42_;
	games_media_set_foreach_media (_tmp43_, ___lambda24__games_media_set_media_callback, _data5_);
	_tmp44_ = self->priv->core;
	_tmp45_ = _data5_->medias_uris;
	_tmp45__length1 = _data5_->medias_uris_length1;
	retro_core_set_medias (_tmp44_, _tmp45_);
	_tmp46_ = self->priv->core;
	retro_core_init (_tmp46_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (module_path);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_tmp47_ = self->priv->core;
	_tmp48_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp49_ = _tmp48_;
	_tmp50_ = games_media_set_get_selected_media_number (_tmp49_);
	_tmp51_ = _tmp50_;
	retro_core_set_current_media (_tmp47_, (guint) _tmp51_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (module_path);
		block5_data_unref (_data5_);
		_data5_ = NULL;
		return;
	}
	_g_free0 (module_path);
	block5_data_unref (_data5_);
	_data5_ = NULL;
}


static void games_retro_runner_real_pause (GamesRunner* base) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	RetroMainLoop* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->loop;
	retro_main_loop_stop (_tmp1_);
	games_retro_runner_set_running (self, FALSE);
	{
		games_retro_runner_save (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("retro-runner.vala:296: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void games_retro_runner_real_stop (GamesRunner* base) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		return;
	}
	games_runner_pause ((GamesRunner*) self);
	games_retro_runner_deinit (self);
	g_signal_emit_by_name ((GamesRunner*) self, "stopped");
}


static void games_retro_runner_on_media_number_changed (GamesRetroRunner* self) {
	gboolean _tmp0_;
	gint media_number = 0;
	GamesMediaSet* _tmp8_;
	GamesMediaSet* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	GamesMedia* media = NULL;
	GamesUri** uris = NULL;
	GamesMedia* _tmp20_;
	gint _tmp21_;
	GamesUri** _tmp22_;
	gint uris_length1;
	gint _uris_size_;
	GamesUri** _tmp23_;
	gint _tmp23__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		return;
	}
	{
		RetroCore* _tmp1_;
		GamesMediaSet* _tmp2_;
		GamesMediaSet* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
		_tmp1_ = self->priv->core;
		_tmp2_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = games_media_set_get_selected_media_number (_tmp3_);
		_tmp5_ = _tmp4_;
		retro_core_set_current_media (_tmp1_, (guint) _tmp5_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch16_g_error;
		}
	}
	goto __finally16;
	__catch16_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_;
		const gchar* _tmp7_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_debug ("retro-runner.vala:318: %s", _tmp7_);
		_g_error_free0 (e);
		return;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp9_ = _tmp8_;
	_tmp10_ = games_media_set_get_selected_media_number (_tmp9_);
	_tmp11_ = _tmp10_;
	media_number = _tmp11_;
	media = NULL;
	{
		GamesMedia* _tmp12_ = NULL;
		GamesMediaSet* _tmp13_;
		GamesMediaSet* _tmp14_;
		gint _tmp15_;
		GamesMedia* _tmp16_;
		GamesMedia* _tmp17_;
		_tmp13_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp14_ = _tmp13_;
		_tmp15_ = media_number;
		_tmp16_ = games_media_set_get_selected_media (_tmp14_, (guint) _tmp15_, &_inner_error_);
		_tmp12_ = _tmp16_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch17_g_error;
		}
		_tmp17_ = _tmp12_;
		_tmp12_ = NULL;
		_g_object_unref0 (media);
		media = _tmp17_;
		_g_object_unref0 (_tmp12_);
	}
	goto __finally17;
	__catch17_g_error:
	{
		GError* e = NULL;
		GError* _tmp18_;
		const gchar* _tmp19_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("retro-runner.vala:330: %s", _tmp19_);
		_g_error_free0 (e);
		_g_object_unref0 (media);
		return;
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp20_ = media;
	_tmp22_ = games_media_get_uris (_tmp20_, &_tmp21_);
	uris = _tmp22_;
	uris_length1 = _tmp21_;
	_uris_size_ = uris_length1;
	_tmp23_ = uris;
	_tmp23__length1 = uris_length1;
	if (_tmp23__length1 == 0) {
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		_g_object_unref0 (media);
		return;
	}
	{
		RetroCore* _tmp24_;
		GamesMediaSet* _tmp25_;
		GamesMediaSet* _tmp26_;
		gint _tmp27_;
		gint _tmp28_;
		_tmp24_ = self->priv->core;
		_tmp25_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp26_ = _tmp25_;
		_tmp27_ = games_media_set_get_selected_media_number (_tmp26_);
		_tmp28_ = _tmp27_;
		retro_core_set_current_media (_tmp24_, (guint) _tmp28_, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp29_;
		const gchar* _tmp30_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp29_ = e;
		_tmp30_ = _tmp29_->message;
		g_debug ("retro-runner.vala:343: %s", _tmp30_);
		_g_error_free0 (e);
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		_g_object_unref0 (media);
		return;
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	{
		games_retro_runner_save_media_data (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch19_g_error;
		}
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp31_;
		const gchar* _tmp32_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp31_ = e;
		_tmp32_ = _tmp31_->message;
		g_warning ("retro-runner.vala:352: %s", _tmp32_);
		_g_error_free0 (e);
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	uris = (_vala_array_free (uris, uris_length1, (GDestroyNotify) games_uri_unref), NULL);
	_g_object_unref0 (media);
}


static void games_retro_runner_save (GamesRetroRunner* self, GError** error) {
	gboolean _tmp0_;
	GamesMediaSet* _tmp1_;
	GamesMediaSet* _tmp2_;
	gint _tmp3_;
	RetroCore* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->should_save;
	if (!_tmp0_) {
		return;
	}
	games_retro_runner_save_ram (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_media_set_get_size (_tmp2_);
	if (_tmp3_ > 1) {
		games_retro_runner_save_media_data (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp4_ = self->priv->core;
	_tmp5_ = retro_core_supports_serialization (_tmp4_);
	if (!_tmp5_) {
		return;
	}
	games_retro_runner_save_snapshot (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	games_retro_runner_save_screenshot (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	self->priv->should_save = FALSE;
}


static gchar* games_retro_runner_get_save_directory_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* dir = NULL;
	gchar* _tmp3_;
	gchar* uid = NULL;
	GamesUid* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->save_directory_path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->save_directory_path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = games_application_get_saves_dir ();
	dir = _tmp3_;
	_tmp4_ = self->priv->uid;
	_tmp5_ = games_uid_get_uid (_tmp4_, &_inner_error_);
	uid = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp6_ = dir;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = uid;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp7_, "/", _tmp9_, NULL);
	_g_free0 (self->priv->save_directory_path);
	self->priv->save_directory_path = _tmp10_;
	_tmp11_ = self->priv->save_directory_path;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static gchar* games_retro_runner_get_save_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* dir = NULL;
	gchar* _tmp3_;
	gchar* uid = NULL;
	GamesUid* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->save_path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->save_path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = games_application_get_saves_dir ();
	dir = _tmp3_;
	_tmp4_ = self->priv->uid;
	_tmp5_ = games_uid_get_uid (_tmp4_, &_inner_error_);
	uid = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp6_ = dir;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = uid;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp7_, "/", _tmp9_, ".save", NULL);
	_g_free0 (self->priv->save_path);
	self->priv->save_path = _tmp10_;
	_tmp11_ = self->priv->save_path;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static void games_retro_runner_save_ram (GamesRetroRunner* self, GError** error) {
	guint8* save = NULL;
	RetroCore* _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint save_length1;
	gint _save_size_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* dir = NULL;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* save_path = NULL;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp2_ = retro_core_get_memory (_tmp0_, RETRO_MEMORY_TYPE_SAVE_RAM, &_tmp1_);
	save = _tmp2_;
	save_length1 = _tmp1_;
	_save_size_ = save_length1;
	_tmp3_ = save;
	_tmp3__length1 = save_length1;
	if (_tmp3__length1 == 0) {
		save = (g_free (save), NULL);
		return;
	}
	_tmp4_ = games_application_get_saves_dir ();
	dir = _tmp4_;
	_tmp5_ = dir;
	games_retro_runner_try_make_dir (_tmp5_);
	_tmp6_ = games_retro_runner_get_save_path (self, &_inner_error_);
	save_path = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		save = (g_free (save), NULL);
		return;
	}
	_tmp7_ = save_path;
	_tmp8_ = save;
	_tmp8__length1 = save_length1;
	g_file_set_contents (_tmp7_, (const char*) _tmp8_, (size_t) _tmp8__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (save_path);
		_g_free0 (dir);
		save = (g_free (save), NULL);
		return;
	}
	_g_free0 (save_path);
	_g_free0 (dir);
	save = (g_free (save), NULL);
}


static void games_retro_runner_load_ram (GamesRetroRunner* self, GError** error) {
	gchar* save_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	guint8* data = NULL;
	gint data_length1;
	gint _data_size_;
	const gchar* _tmp3_;
	guint8* _tmp4_ = NULL;
	size_t _tmp5_;
	gsize expected_size = 0UL;
	RetroCore* _tmp6_;
	gsize _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gsize _tmp9_;
	RetroCore* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_retro_runner_get_save_path (self, &_inner_error_);
	save_path = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = save_path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	if (!_tmp2_) {
		_g_free0 (save_path);
		return;
	}
	data = NULL;
	data_length1 = 0;
	_data_size_ = data_length1;
	_tmp3_ = save_path;
	g_file_get_contents (_tmp3_, (gchar**) (&_tmp4_), &_tmp5_, &_inner_error_);
	data = (g_free (data), NULL);
	data = _tmp4_;
	data_length1 = _tmp5_;
	_data_size_ = data_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		data = (g_free (data), NULL);
		_g_free0 (save_path);
		return;
	}
	_tmp6_ = self->priv->core;
	_tmp7_ = retro_core_get_memory_size (_tmp6_, RETRO_MEMORY_TYPE_SAVE_RAM);
	expected_size = _tmp7_;
	_tmp8_ = data;
	_tmp8__length1 = data_length1;
	_tmp9_ = expected_size;
	if (((gsize) _tmp8__length1) != _tmp9_) {
		guint8* _tmp10_;
		gint _tmp10__length1;
		gsize _tmp11_;
		_tmp10_ = data;
		_tmp10__length1 = data_length1;
		_tmp11_ = expected_size;
		g_warning ("retro-runner.vala:420: Unexpected RAM data size: got %lu, expected %lu" \
"\n", (gulong) _tmp10__length1, (gulong) _tmp11_);
	}
	_tmp12_ = self->priv->core;
	_tmp13_ = data;
	_tmp13__length1 = data_length1;
	retro_core_set_memory (_tmp12_, RETRO_MEMORY_TYPE_SAVE_RAM, _tmp13_, _tmp13__length1);
	data = (g_free (data), NULL);
	_g_free0 (save_path);
}


static gchar* games_retro_runner_get_snapshot_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* dir = NULL;
	gchar* _tmp3_;
	gchar* uid = NULL;
	GamesUid* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->snapshot_path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->snapshot_path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = games_application_get_snapshots_dir ();
	dir = _tmp3_;
	_tmp4_ = self->priv->uid;
	_tmp5_ = games_uid_get_uid (_tmp4_, &_inner_error_);
	uid = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp6_ = dir;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = uid;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp7_, "/", _tmp9_, ".snapshot", NULL);
	_g_free0 (self->priv->snapshot_path);
	self->priv->snapshot_path = _tmp10_;
	_tmp11_ = self->priv->snapshot_path;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static void games_retro_runner_save_snapshot (GamesRetroRunner* self, GError** error) {
	RetroCore* _tmp0_;
	gboolean _tmp1_;
	guint8* buffer = NULL;
	RetroCore* _tmp2_;
	gsize _tmp3_;
	guint8* _tmp4_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* dir = NULL;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* snapshot_path = NULL;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = retro_core_supports_serialization (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->core;
	_tmp4_ = retro_core_serialize_state (_tmp2_, &_tmp3_, &_inner_error_);
	buffer = _tmp4_;
	buffer_length1 = _tmp3_;
	_buffer_size_ = buffer_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = games_application_get_snapshots_dir ();
	dir = _tmp5_;
	_tmp6_ = dir;
	games_retro_runner_try_make_dir (_tmp6_);
	_tmp7_ = games_retro_runner_get_snapshot_path (self, &_inner_error_);
	snapshot_path = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		buffer = (g_free (buffer), NULL);
		return;
	}
	_tmp8_ = snapshot_path;
	_tmp9_ = buffer;
	_tmp9__length1 = buffer_length1;
	g_file_set_contents (_tmp8_, (const char*) _tmp9_, (size_t) _tmp9__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (snapshot_path);
		_g_free0 (dir);
		buffer = (g_free (buffer), NULL);
		return;
	}
	_g_free0 (snapshot_path);
	_g_free0 (dir);
	buffer = (g_free (buffer), NULL);
}


static void games_retro_runner_load_snapshot (GamesRetroRunner* self, GError** error) {
	RetroCore* _tmp0_;
	gboolean _tmp1_;
	gchar* snapshot_path = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	guint8* data = NULL;
	gint data_length1;
	gint _data_size_;
	const gchar* _tmp5_;
	guint8* _tmp6_ = NULL;
	size_t _tmp7_;
	RetroCore* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = retro_core_supports_serialization (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = games_retro_runner_get_snapshot_path (self, &_inner_error_);
	snapshot_path = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = snapshot_path;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	if (!_tmp4_) {
		_g_free0 (snapshot_path);
		return;
	}
	data = NULL;
	data_length1 = 0;
	_data_size_ = data_length1;
	_tmp5_ = snapshot_path;
	g_file_get_contents (_tmp5_, (gchar**) (&_tmp6_), &_tmp7_, &_inner_error_);
	data = (g_free (data), NULL);
	data = _tmp6_;
	data_length1 = _tmp7_;
	_data_size_ = data_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		data = (g_free (data), NULL);
		_g_free0 (snapshot_path);
		return;
	}
	_tmp8_ = self->priv->core;
	_tmp9_ = data;
	_tmp9__length1 = data_length1;
	retro_core_deserialize_state (_tmp8_, _tmp9_, (gsize) _tmp9__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		data = (g_free (data), NULL);
		_g_free0 (snapshot_path);
		return;
	}
	data = (g_free (data), NULL);
	_g_free0 (snapshot_path);
}


static void games_retro_runner_save_media_data (GamesRetroRunner* self, GError** error) {
	gchar* dir = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* medias_path = NULL;
	gchar* _tmp2_;
	gchar* contents = NULL;
	GamesMediaSet* _tmp3_;
	GamesMediaSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_application_get_medias_dir ();
	dir = _tmp0_;
	_tmp1_ = dir;
	games_retro_runner_try_make_dir (_tmp1_);
	_tmp2_ = games_retro_runner_get_medias_path (self, &_inner_error_);
	medias_path = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return;
	}
	_tmp3_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = games_media_set_get_selected_media_number (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	contents = _tmp7_;
	_tmp8_ = medias_path;
	_tmp9_ = contents;
	_tmp10_ = contents;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	g_file_set_contents (_tmp8_, _tmp9_, (gssize) _tmp12_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_free0 (medias_path);
		_g_free0 (dir);
		return;
	}
	_g_free0 (contents);
	_g_free0 (medias_path);
	_g_free0 (dir);
}


static void games_retro_runner_load_media_data (GamesRetroRunner* self, GError** error) {
	gchar* medias_path = NULL;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* contents = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gint disc_num = 0;
	const gchar* _tmp5_;
	gint _tmp6_;
	GamesMediaSet* _tmp7_;
	GamesMediaSet* _tmp8_;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_retro_runner_get_medias_path (self, &_inner_error_);
	medias_path = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = medias_path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	if (!_tmp2_) {
		_g_free0 (medias_path);
		return;
	}
	_tmp3_ = medias_path;
	g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_free0 (medias_path);
		return;
	}
	_tmp5_ = contents;
	_tmp6_ = atoi (_tmp5_);
	disc_num = _tmp6_;
	_tmp7_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = disc_num;
	games_media_set_set_selected_media_number (_tmp8_, _tmp9_);
	_g_free0 (contents);
	_g_free0 (medias_path);
}


static gchar* games_retro_runner_get_medias_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	gchar* dir = NULL;
	gchar* _tmp0_;
	gchar* uid = NULL;
	GamesUid* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_application_get_medias_dir ();
	dir = _tmp0_;
	_tmp1_ = self->priv->uid;
	_tmp2_ = games_uid_get_uid (_tmp1_, &_inner_error_);
	uid = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp3_ = string_to_string (dir);
	_tmp4_ = string_to_string (uid);
	_tmp5_ = g_strconcat (_tmp3_, "/", _tmp4_, ".media", NULL);
	result = _tmp5_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static gchar* games_retro_runner_get_screenshot_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* dir = NULL;
	gchar* _tmp3_;
	gchar* uid = NULL;
	GamesUid* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->screenshot_path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->screenshot_path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = games_application_get_snapshots_dir ();
	dir = _tmp3_;
	_tmp4_ = self->priv->uid;
	_tmp5_ = games_uid_get_uid (_tmp4_, &_inner_error_);
	uid = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp6_ = dir;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = uid;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp7_, "/", _tmp9_, ".png", NULL);
	_g_free0 (self->priv->screenshot_path);
	self->priv->screenshot_path = _tmp10_;
	_tmp11_ = self->priv->screenshot_path;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static void games_retro_runner_save_screenshot (GamesRetroRunner* self, GError** error) {
	RetroCore* _tmp0_;
	gboolean _tmp1_;
	GdkPixbuf* pixbuf = NULL;
	RetroCairoDisplay* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	gchar* screenshot_path = NULL;
	gchar* _tmp7_;
	GDateTime* now = NULL;
	GDateTime* _tmp8_;
	gchar* creation_time = NULL;
	GDateTime* _tmp9_;
	gchar* _tmp10_;
	gchar* platform = NULL;
	GamesRetroCoreSource* _tmp11_;
	gchar* _tmp12_;
	gchar* platform_name = NULL;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* title = NULL;
	GamesTitle* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_ = NULL;
	GdkPixbuf* _tmp18_;
	const gchar* _tmp19_;
	gchar* x_dpi = NULL;
	gchar* _tmp20_;
	const gchar* _tmp21_ = NULL;
	GdkPixbuf* _tmp22_;
	const gchar* _tmp23_;
	gchar* y_dpi = NULL;
	gchar* _tmp24_;
	GdkPixbuf* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = retro_core_supports_serialization (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->video;
	_tmp3_ = retro_cairo_display_get_pixbuf (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	pixbuf = _tmp5_;
	_tmp6_ = pixbuf;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp7_ = games_retro_runner_get_screenshot_path (self, &_inner_error_);
	screenshot_path = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp8_ = g_date_time_new_now_local ();
	now = _tmp8_;
	_tmp9_ = now;
	_tmp10_ = g_date_time_to_string (_tmp9_);
	creation_time = _tmp10_;
	_tmp11_ = self->priv->core_source;
	_tmp12_ = games_retro_core_source_get_platform (_tmp11_);
	platform = _tmp12_;
	_tmp13_ = platform;
	_tmp14_ = games_retro_platform_get_platform_name (_tmp13_);
	platform_name = _tmp14_;
	_tmp15_ = self->priv->game_title;
	_tmp16_ = games_title_get_title (_tmp15_, &_inner_error_);
	title = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (platform_name);
		_g_free0 (platform);
		_g_free0 (creation_time);
		_g_date_time_unref0 (now);
		_g_free0 (screenshot_path);
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp18_ = pixbuf;
	_tmp19_ = gdk_pixbuf_get_option (_tmp18_, "x-dpi");
	_tmp17_ = _tmp19_;
	if (_tmp17_ == NULL) {
		_tmp17_ = "";
	}
	_tmp20_ = g_strdup (_tmp17_);
	x_dpi = _tmp20_;
	_tmp22_ = pixbuf;
	_tmp23_ = gdk_pixbuf_get_option (_tmp22_, "y-dpi");
	_tmp21_ = _tmp23_;
	if (_tmp21_ == NULL) {
		_tmp21_ = "";
	}
	_tmp24_ = g_strdup (_tmp21_);
	y_dpi = _tmp24_;
	_tmp25_ = pixbuf;
	_tmp26_ = screenshot_path;
	_tmp27_ = title;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = platform_name;
	_tmp30_ = string_to_string (_tmp29_);
	_tmp31_ = g_strconcat ("Screenshot of ", _tmp28_, " on ", _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = creation_time;
	_tmp34_ = string_to_string (_tmp33_);
	_tmp35_ = title;
	_tmp36_ = platform_name;
	_tmp37_ = x_dpi;
	_tmp38_ = y_dpi;
	gdk_pixbuf_save (_tmp25_, _tmp26_, "png", &_inner_error_, "tEXt::Software", "GNOME Games", "tEXt::Title", _tmp32_, "tEXt::Creation Time", _tmp34_, "tEXt::Game Title", _tmp35_, "tEXt::Platform", _tmp36_, "x-dpi", _tmp37_, "y-dpi", _tmp38_, NULL, NULL);
	_g_free0 (_tmp32_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (y_dpi);
		_g_free0 (x_dpi);
		_g_free0 (title);
		_g_free0 (platform_name);
		_g_free0 (platform);
		_g_free0 (creation_time);
		_g_date_time_unref0 (now);
		_g_free0 (screenshot_path);
		_g_object_unref0 (pixbuf);
		return;
	}
	_g_free0 (y_dpi);
	_g_free0 (x_dpi);
	_g_free0 (title);
	_g_free0 (platform_name);
	_g_free0 (platform);
	_g_free0 (creation_time);
	_g_date_time_unref0 (now);
	_g_free0 (screenshot_path);
	_g_object_unref0 (pixbuf);
}


static void games_retro_runner_load_screenshot (GamesRetroRunner* self, GError** error) {
	RetroCore* _tmp0_;
	gboolean _tmp1_;
	gchar* screenshot_path = NULL;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	GdkPixbuf* pixbuf = NULL;
	const gchar* _tmp5_;
	GdkPixbuf* _tmp6_;
	RetroCairoDisplay* _tmp7_;
	GdkPixbuf* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = retro_core_supports_serialization (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = games_retro_runner_get_screenshot_path (self, &_inner_error_);
	screenshot_path = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = screenshot_path;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	if (!_tmp4_) {
		_g_free0 (screenshot_path);
		return;
	}
	_tmp5_ = screenshot_path;
	_tmp6_ = gdk_pixbuf_new_from_file (_tmp5_, &_inner_error_);
	pixbuf = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (screenshot_path);
		return;
	}
	_tmp7_ = self->priv->video;
	_tmp8_ = pixbuf;
	retro_cairo_display_set_pixbuf (_tmp7_, _tmp8_);
	_g_object_unref0 (pixbuf);
	_g_free0 (screenshot_path);
}


static gboolean games_retro_runner_on_shutdown (GamesRetroRunner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	games_runner_stop ((GamesRunner*) self);
	result = TRUE;
	return result;
}


static void games_retro_runner_try_make_dir (const gchar* path) {
	GFile* file = NULL;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	{
		GFile* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = file;
		_tmp3_ = g_file_query_exists (_tmp2_, NULL);
		if (!_tmp3_) {
			GFile* _tmp4_;
			_tmp4_ = file;
			g_file_make_directory_with_parents (_tmp4_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch20_g_error;
			}
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		g_warning ("retro-runner.vala:566: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		return;
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


static gchar* games_retro_runner_get_unsupported_system_message (GamesRetroRunner* self) {
	gchar* result = NULL;
	GamesRetroCoreSource* _tmp0_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->core_source;
	if (_tmp0_ != NULL) {
		gchar* platform = NULL;
		GamesRetroCoreSource* _tmp1_;
		gchar* _tmp2_;
		gchar* platform_name = NULL;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->core_source;
		_tmp2_ = games_retro_core_source_get_platform (_tmp1_);
		platform = _tmp2_;
		_tmp3_ = platform;
		_tmp4_ = games_retro_platform_get_platform_name (_tmp3_);
		platform_name = _tmp4_;
		_tmp5_ = platform_name;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = platform_name;
			_tmp7_ = g_strdup_printf (_ ("The system “%s” isn’t supported yet, but full support is planned."), _tmp6_);
			result = _tmp7_;
			_g_free0 (platform_name);
			_g_free0 (platform);
			return result;
		}
		_g_free0 (platform_name);
		_g_free0 (platform);
	}
	_tmp8_ = g_strdup (_ ("The system isn’t supported yet, but full support is planned."));
	result = _tmp8_;
	return result;
}


static gboolean games_retro_runner_real_get_can_fullscreen (GamesRunner* base) {
	gboolean result;
	GamesRetroRunner* self;
	self = (GamesRetroRunner*) base;
	result = TRUE;
	return result;
}


static gboolean games_retro_runner_real_get_can_quit_safely (GamesRunner* base) {
	gboolean result;
	GamesRetroRunner* self;
	gboolean _tmp0_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->should_save;
	result = !_tmp0_;
	return result;
}


static gboolean games_retro_runner_real_get_can_resume (GamesRunner* base) {
	gboolean result;
	GamesRetroRunner* self;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	{
		RetroCore* _tmp0_;
		gboolean _tmp1_;
		gchar* snapshot_path = NULL;
		gchar* _tmp2_;
		GFile* file = NULL;
		const gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gboolean _tmp6_;
		games_retro_runner_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
		_tmp0_ = self->priv->core;
		_tmp1_ = retro_core_supports_serialization (_tmp0_);
		if (!_tmp1_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = games_retro_runner_get_snapshot_path (self, &_inner_error_);
		snapshot_path = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch21_g_error;
		}
		_tmp3_ = snapshot_path;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		file = _tmp4_;
		_tmp5_ = file;
		_tmp6_ = g_file_query_exists (_tmp5_, NULL);
		result = _tmp6_;
		_g_object_unref0 (file);
		_g_free0 (snapshot_path);
		return result;
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("retro-runner.vala:25: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp9_;
	}
	result = FALSE;
	return result;
}


static GamesMediaSet* games_retro_runner_real_get_media_set (GamesRunner* base) {
	GamesMediaSet* result;
	GamesRetroRunner* self;
	GamesMediaSet* _tmp0_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->_media_set;
	result = _tmp0_;
	return result;
}


static gboolean games_retro_runner_get_running (GamesRetroRunner* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_running;
	result = _tmp0_;
	return result;
}


static void games_retro_runner_set_running (GamesRetroRunner* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	RetroCairoDisplay* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_running = _tmp0_;
	_tmp1_ = games_retro_runner_get_running (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		self->priv->should_save = TRUE;
	}
	_tmp3_ = self->priv->video;
	_tmp4_ = games_retro_runner_get_running (self);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_);
}


static GObject * games_retro_runner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GamesRetroRunner * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (games_retro_runner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	_tmp0_ = g_settings_new ("org.gnome.Games");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	return obj;
}


static void games_retro_runner_class_init (GamesRetroRunnerClass * klass) {
	games_retro_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesRetroRunnerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_retro_runner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_retro_runner_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_retro_runner_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_retro_runner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_CAN_FULLSCREEN, games_retro_runner_properties[GAMES_RETRO_RUNNER_CAN_FULLSCREEN] = g_param_spec_boolean ("can-fullscreen", "can-fullscreen", "can-fullscreen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_CAN_QUIT_SAFELY, games_retro_runner_properties[GAMES_RETRO_RUNNER_CAN_QUIT_SAFELY] = g_param_spec_boolean ("can-quit-safely", "can-quit-safely", "can-quit-safely", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_CAN_RESUME, games_retro_runner_properties[GAMES_RETRO_RUNNER_CAN_RESUME] = g_param_spec_boolean ("can-resume", "can-resume", "can-resume", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_MEDIA_SET, games_retro_runner_properties[GAMES_RETRO_RUNNER_MEDIA_SET] = g_param_spec_object ("media-set", "media-set", "media-set", GAMES_TYPE_MEDIA_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_retro_runner_games_runner_interface_init (GamesRunnerIface * iface) {
	games_retro_runner_games_runner_parent_iface = g_type_interface_peek_parent (iface);
	iface->check_is_valid = (gboolean (*) (GamesRunner *, gchar* *, GError**)) games_retro_runner_real_check_is_valid;
	iface->get_display = (GtkWidget* (*) (GamesRunner *)) games_retro_runner_real_get_display;
	iface->start = (void (*) (GamesRunner *, GError**)) games_retro_runner_real_start;
	iface->resume = (void (*) (GamesRunner *, GError**)) games_retro_runner_real_resume;
	iface->pause = (void (*) (GamesRunner *)) games_retro_runner_real_pause;
	iface->stop = (void (*) (GamesRunner *)) games_retro_runner_real_stop;
	iface->get_can_fullscreen = games_retro_runner_real_get_can_fullscreen;
	iface->get_can_quit_safely = games_retro_runner_real_get_can_quit_safely;
	iface->get_can_resume = games_retro_runner_real_get_can_resume;
	iface->get_media_set = games_retro_runner_real_get_media_set;
}


static void games_retro_runner_instance_init (GamesRetroRunner * self) {
	self->priv = GAMES_RETRO_RUNNER_GET_PRIVATE (self);
}


static void games_retro_runner_finalize (GObject * obj) {
	GamesRetroRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	games_runner_pause ((GamesRunner*) self);
	games_retro_runner_deinit (self);
	_g_object_unref0 (self->priv->_media_set);
	_g_object_unref0 (self->priv->core);
	_g_object_unref0 (self->priv->view);
	_g_object_unref0 (self->priv->video);
	_g_object_unref0 (self->priv->audio);
	_g_object_unref0 (self->priv->input_manager);
	_g_object_unref0 (self->priv->loop);
	_g_free0 (self->priv->save_directory_path);
	_g_free0 (self->priv->save_path);
	_g_free0 (self->priv->snapshot_path);
	_g_free0 (self->priv->screenshot_path);
	_g_object_unref0 (self->priv->core_descriptor);
	_g_object_unref0 (self->priv->core_source);
	_g_object_unref0 (self->priv->uid);
	_g_object_unref0 (self->priv->input_capabilities);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game_title);
	G_OBJECT_CLASS (games_retro_runner_parent_class)->finalize (obj);
}


GType games_retro_runner_get_type (void) {
	static volatile gsize games_retro_runner_type_id__volatile = 0;
	if (g_once_init_enter (&games_retro_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesRetroRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroRunner), 0, (GInstanceInitFunc) games_retro_runner_instance_init, NULL };
		static const GInterfaceInfo games_runner_info = { (GInterfaceInitFunc) games_retro_runner_games_runner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType games_retro_runner_type_id;
		games_retro_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroRunner", &g_define_type_info, 0);
		g_type_add_interface_static (games_retro_runner_type_id, GAMES_TYPE_RUNNER, &games_runner_info);
		g_once_init_leave (&games_retro_runner_type_id__volatile, games_retro_runner_type_id);
	}
	return games_retro_runner_type_id__volatile;
}


static void _vala_games_retro_runner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesRetroRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	switch (property_id) {
		case GAMES_RETRO_RUNNER_CAN_FULLSCREEN:
		g_value_set_boolean (value, games_runner_get_can_fullscreen ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_CAN_QUIT_SAFELY:
		g_value_set_boolean (value, games_runner_get_can_quit_safely ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_CAN_RESUME:
		g_value_set_boolean (value, games_runner_get_can_resume ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_MEDIA_SET:
		g_value_set_object (value, games_runner_get_media_set ((GamesRunner*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_games_retro_runner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GamesRetroRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



