/* playstation-game-factory.c generated by valac 0.38.0, the Vala compiler
 * generated from playstation-game-factory.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>


#define GAMES_TYPE_PLAY_STATION_GAME_FACTORY (games_play_station_game_factory_get_type ())
#define GAMES_PLAY_STATION_GAME_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactory))
#define GAMES_PLAY_STATION_GAME_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactoryClass))
#define GAMES_IS_PLAY_STATION_GAME_FACTORY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_GAME_FACTORY))
#define GAMES_IS_PLAY_STATION_GAME_FACTORY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_GAME_FACTORY))
#define GAMES_PLAY_STATION_GAME_FACTORY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactoryClass))

typedef struct _GamesPlayStationGameFactory GamesPlayStationGameFactory;
typedef struct _GamesPlayStationGameFactoryClass GamesPlayStationGameFactoryClass;
typedef struct _GamesPlayStationGameFactoryPrivate GamesPlayStationGameFactoryPrivate;
enum  {
	GAMES_PLAY_STATION_GAME_FACTORY_DUMMY_PROPERTY,
	GAMES_PLAY_STATION_GAME_FACTORY_LAST_PROPERTY
};
static GParamSpec* games_play_station_game_factory_properties[GAMES_PLAY_STATION_GAME_FACTORY_LAST_PROPERTY];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _games_uri_unref0(var) ((var == NULL) ? NULL : (var = (games_uri_unref (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _GamesPlayStationGameFactoryQueryGameForUriData GamesPlayStationGameFactoryQueryGameForUriData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesPlayStationGameFactoryAddUriData GamesPlayStationGameFactoryAddUriData;
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_PLAY_STATION_HEADER (games_play_station_header_get_type ())
#define GAMES_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader))
#define GAMES_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))
#define GAMES_IS_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_IS_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_PLAY_STATION_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))

typedef struct _GamesPlayStationHeader GamesPlayStationHeader;
typedef struct _GamesPlayStationHeaderClass GamesPlayStationHeaderClass;
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _GamesPlayStationGameFactoryForeachGameData GamesPlayStationGameFactoryForeachGameData;

#define GAMES_TYPE_PLAY_STATION_UID (games_play_station_uid_get_type ())
#define GAMES_PLAY_STATION_UID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_UID, GamesPlayStationUid))
#define GAMES_PLAY_STATION_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_UID, GamesPlayStationUidClass))
#define GAMES_IS_PLAY_STATION_UID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_UID))
#define GAMES_IS_PLAY_STATION_UID_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_UID))
#define GAMES_PLAY_STATION_UID_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_UID, GamesPlayStationUidClass))

typedef struct _GamesPlayStationUid GamesPlayStationUid;
typedef struct _GamesPlayStationUidClass GamesPlayStationUidClass;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _GamesPlayStationGameFactory {
	GObject parent_instance;
	GamesPlayStationGameFactoryPrivate * priv;
};

struct _GamesPlayStationGameFactoryClass {
	GObjectClass parent_class;
};

struct _GamesPlayStationGameFactoryPrivate {
	GHashTable* media_for_disc_id;
	GHashTable* game_for_uri;
	GHashTable* game_for_disc_set_id;
	GHashTable* games;
};

struct _GamesPlayStationGameFactoryQueryGameForUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesPlayStationGameFactory* self;
	GamesUri* uri;
	GamesGame* result;
	GHashTable* _tmp0_;
	GamesUri* _tmp1_;
	gboolean _tmp2_;
	GHashTable* _tmp3_;
	GamesUri* _tmp4_;
	gconstpointer _tmp5_;
	GamesGame* _tmp6_;
};

struct _GamesPlayStationGameFactoryAddUriData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesPlayStationGameFactory* self;
	GamesUri* uri;
	GamesUri* _tmp0_;
	GError* e;
	GError* _tmp1_;
	const gchar* _tmp2_;
	GError * _inner_error_;
};

struct _Block1Data {
	int _ref_count_;
	GamesPlayStationGameFactory* self;
	GamesGameCallback game_callback;
	gpointer game_callback_target;
	gpointer _async_data_;
};

struct _Block2Data {
	int _ref_count_;
	GHashTable* self;
	GFunc func;
	gpointer func_target;
};

struct _GamesPlayStationGameFactoryForeachGameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GAsyncReadyCallback _callback_;
	gboolean _task_complete_;
	GamesPlayStationGameFactory* self;
	GamesGameCallback game_callback;
	gpointer game_callback_target;
	Block1Data* _data1_;
	GamesGameCallback _tmp0_;
	void* _tmp0__target;
	GHashTable* _tmp1_;
};


static gpointer games_play_station_game_factory_parent_class = NULL;
static GamesGameinfoDoc* games_play_station_game_factory_gameinfo;
static GamesGameinfoDoc* games_play_station_game_factory_gameinfo = NULL;
static GamesUriGameFactoryIface * games_play_station_game_factory_games_uri_game_factory_parent_iface = NULL;
static GType games_play_station_game_factory_type_id = 0;

GType games_play_station_game_factory_get_type (void) G_GNUC_CONST;
#define GAMES_PLAY_STATION_GAME_FACTORY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactoryPrivate))
#define GAMES_PLAY_STATION_GAME_FACTORY_CUE_MIME_TYPE "application/x-cue"
#define GAMES_PLAY_STATION_GAME_FACTORY_PHONY_MIME_TYPE "application/x-playstation-rom"
#define GAMES_PLAY_STATION_GAME_FACTORY_PLATFORM "PlayStation"
#define GAMES_PLAY_STATION_GAME_FACTORY_ICON_NAME "media-optical-symbolic"
#define GAMES_PLAY_STATION_GAME_FACTORY_GAMEINFO "resource:///org/gnome/Games/plugin/playstation/playstation.gameinfo.xm" \
"l"
GamesPlayStationGameFactory* games_play_station_game_factory_new (void);
GamesPlayStationGameFactory* games_play_station_game_factory_construct (GType object_type);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
static guint _games_uri_hash_ghash_func (gconstpointer key);
static gboolean _games_uri_equal_gequal_func (gconstpointer a, gconstpointer b);
static void _games_uri_unref0_ (gpointer var);
static gchar** games_play_station_game_factory_real_get_mime_types (GamesUriGameFactory* base, int* result_length1);
static void games_play_station_game_factory_real_query_game_for_uri_data_free (gpointer _data);
static void games_play_station_game_factory_real_query_game_for_uri_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void games_play_station_game_factory_real_query_game_for_uri (GamesUriGameFactory* base, GamesUri* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean games_play_station_game_factory_real_query_game_for_uri_co (GamesPlayStationGameFactoryQueryGameForUriData* _data_);
static gboolean _games_play_station_game_factory_real_query_game_for_uri_co_gsource_func (gpointer self);
static void games_play_station_game_factory_real_add_uri_data_free (gpointer _data);
static void games_play_station_game_factory_real_add_uri_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void games_play_station_game_factory_real_add_uri (GamesUriGameFactory* base, GamesUri* uri, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean games_play_station_game_factory_real_add_uri_co (GamesPlayStationGameFactoryAddUriData* _data_);
static void games_play_station_game_factory_add_uri_with_error (GamesPlayStationGameFactory* self, GamesUri* uri, GError** error);
GType games_play_station_header_get_type (void) G_GNUC_CONST;
GamesPlayStationHeader* games_play_station_header_new (GFile* file);
GamesPlayStationHeader* games_play_station_header_construct (GType object_type, GFile* file);
void games_play_station_header_check_validity (GamesPlayStationHeader* self, GError** error);
const gchar* games_play_station_header_get_disc_id (GamesPlayStationHeader* self);
static GamesGameinfoDoc* games_play_station_game_factory_get_gameinfo (GError** error);
static void _vala_array_add1 (GamesMedia** * array, int* length, int* size, GamesMedia* value);
static GamesGame* games_play_station_game_factory_create_game (GamesPlayStationGameFactory* self, GamesMediaSet* media_set, const gchar* disc_set_id, GamesUri* uri, GError** error);
static void games_play_station_game_factory_real_foreach_game_data_free (gpointer _data);
static void games_play_station_game_factory_real_foreach_game_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data);
static void games_play_station_game_factory_real_foreach_game (GamesUriGameFactory* base, GamesGameCallback game_callback, void* game_callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean games_play_station_game_factory_real_foreach_game_co (GamesPlayStationGameFactoryForeachGameData* _data_);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static void ___lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self);
static void __lambda4_ (Block1Data* _data1_, GamesGame* game);
static void ___lambda4__gfunc (gconstpointer data, gpointer self);
GType games_play_station_uid_get_type (void) G_GNUC_CONST;
GamesPlayStationUid* games_play_station_uid_new (const gchar* disc_set_id);
GamesPlayStationUid* games_play_station_uid_construct (GType object_type, const gchar* disc_set_id);
static void games_play_station_game_factory_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static guint _games_uri_hash_ghash_func (gconstpointer key) {
	guint result;
	result = games_uri_hash ((GamesUri*) key);
	return result;
}


static gboolean _games_uri_equal_gequal_func (gconstpointer a, gconstpointer b) {
	gboolean result;
	result = games_uri_equal ((GamesUri*) a, (GamesUri*) b);
	return result;
}


static void _games_uri_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (games_uri_unref (var), NULL));
}


GamesPlayStationGameFactory* games_play_station_game_factory_construct (GType object_type) {
	GamesPlayStationGameFactory * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	GHashTable* _tmp3_;
	GHashFunc _tmp4_;
	GEqualFunc _tmp5_;
	GHashTable* _tmp6_;
	GHashFunc _tmp7_;
	GEqualFunc _tmp8_;
	GHashTable* _tmp9_;
	self = (GamesPlayStationGameFactory*) g_object_new (object_type, NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->media_for_disc_id);
	self->priv->media_for_disc_id = _tmp2_;
	_tmp3_ = g_hash_table_new_full (_games_uri_hash_ghash_func, _games_uri_equal_gequal_func, _games_uri_unref0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->game_for_uri);
	self->priv->game_for_uri = _tmp3_;
	_tmp4_ = g_str_hash;
	_tmp5_ = g_str_equal;
	_tmp6_ = g_hash_table_new_full (_tmp4_, _tmp5_, _g_free0_, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->game_for_disc_set_id);
	self->priv->game_for_disc_set_id = _tmp6_;
	_tmp7_ = g_direct_hash;
	_tmp8_ = g_direct_equal;
	_tmp9_ = g_hash_table_new_full (_tmp7_, _tmp8_, NULL, _g_object_unref0_);
	_g_hash_table_unref0 (self->priv->games);
	self->priv->games = _tmp9_;
	return self;
}


GamesPlayStationGameFactory* games_play_station_game_factory_new (void) {
	return games_play_station_game_factory_construct (GAMES_TYPE_PLAY_STATION_GAME_FACTORY);
}


static gchar** games_play_station_game_factory_real_get_mime_types (GamesUriGameFactory* base, int* result_length1) {
	GamesPlayStationGameFactory * self;
	gchar** result = NULL;
	gchar* _tmp0_;
	gchar** _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	self = (GamesPlayStationGameFactory*) base;
	_tmp0_ = g_strdup (GAMES_PLAY_STATION_GAME_FACTORY_CUE_MIME_TYPE);
	_tmp1_ = g_new0 (gchar*, 1 + 1);
	_tmp1_[0] = _tmp0_;
	_tmp2_ = _tmp1_;
	_tmp2__length1 = 1;
	if (result_length1) {
		*result_length1 = _tmp2__length1;
	}
	result = _tmp2_;
	return result;
}


static void games_play_station_game_factory_real_query_game_for_uri_data_free (gpointer _data) {
	GamesPlayStationGameFactoryQueryGameForUriData* _data_;
	_data_ = _data;
	_games_uri_unref0 (_data_->uri);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesPlayStationGameFactoryQueryGameForUriData, _data_);
}


static void games_play_station_game_factory_real_query_game_for_uri_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	GamesPlayStationGameFactoryQueryGameForUriData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gpointer _games_uri_ref0 (gpointer self) {
	return self ? games_uri_ref (self) : NULL;
}


static void games_play_station_game_factory_real_query_game_for_uri (GamesUriGameFactory* base, GamesUri* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesPlayStationGameFactory * self;
	GamesPlayStationGameFactoryQueryGameForUriData* _data_;
	GamesPlayStationGameFactory* _tmp0_;
	GamesUri* _tmp1_;
	GamesUri* _tmp2_;
	self = (GamesPlayStationGameFactory*) base;
	_data_ = g_slice_new0 (GamesPlayStationGameFactoryQueryGameForUriData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, games_play_station_game_factory_real_query_game_for_uri_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_play_station_game_factory_real_query_game_for_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = _games_uri_ref0 (_tmp1_);
	_games_uri_unref0 (_data_->uri);
	_data_->uri = _tmp2_;
	games_play_station_game_factory_real_query_game_for_uri_co (_data_);
}


static GamesGame* games_play_station_game_factory_real_query_game_for_uri_finish (GamesUriGameFactory* base, GAsyncResult* _res_) {
	GamesGame* result;
	GamesPlayStationGameFactoryQueryGameForUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static gboolean _games_play_station_game_factory_real_query_game_for_uri_co_gsource_func (gpointer self) {
	gboolean result;
	result = games_play_station_game_factory_real_query_game_for_uri_co (self);
	return result;
}


static gboolean games_play_station_game_factory_real_query_game_for_uri_co (GamesPlayStationGameFactoryQueryGameForUriData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _games_play_station_game_factory_real_query_game_for_uri_co_gsource_func, _data_, NULL);
	_data_->_state_ = 1;
	return FALSE;
	_state_1:
	;
	_data_->_tmp0_ = _data_->self->priv->game_for_uri;
	_data_->_tmp1_ = _data_->uri;
	_data_->_tmp2_ = g_hash_table_contains (_data_->_tmp0_, _data_->_tmp1_);
	if (_data_->_tmp2_) {
		_data_->_tmp3_ = _data_->self->priv->game_for_uri;
		_data_->_tmp4_ = _data_->uri;
		_data_->_tmp5_ = g_hash_table_lookup (_data_->_tmp3_, _data_->_tmp4_);
		_data_->_tmp6_ = _g_object_ref0 ((GamesGame*) _data_->_tmp5_);
		_data_->result = _data_->_tmp6_;
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
		if (_data_->_state_ != 0) {
			while (_data_->_task_complete_ != TRUE) {
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
			}
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void games_play_station_game_factory_real_add_uri_data_free (gpointer _data) {
	GamesPlayStationGameFactoryAddUriData* _data_;
	_data_ = _data;
	_games_uri_unref0 (_data_->uri);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesPlayStationGameFactoryAddUriData, _data_);
}


static void games_play_station_game_factory_real_add_uri_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	GamesPlayStationGameFactoryAddUriData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void games_play_station_game_factory_real_add_uri (GamesUriGameFactory* base, GamesUri* uri, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesPlayStationGameFactory * self;
	GamesPlayStationGameFactoryAddUriData* _data_;
	GamesPlayStationGameFactory* _tmp0_;
	GamesUri* _tmp1_;
	GamesUri* _tmp2_;
	self = (GamesPlayStationGameFactory*) base;
	_data_ = g_slice_new0 (GamesPlayStationGameFactoryAddUriData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, games_play_station_game_factory_real_add_uri_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_play_station_game_factory_real_add_uri_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = uri;
	_tmp2_ = _games_uri_ref0 (_tmp1_);
	_games_uri_unref0 (_data_->uri);
	_data_->uri = _tmp2_;
	games_play_station_game_factory_real_add_uri_co (_data_);
}


static void games_play_station_game_factory_real_add_uri_finish (GamesUriGameFactory* base, GAsyncResult* _res_) {
	GamesPlayStationGameFactoryAddUriData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static gboolean games_play_station_game_factory_real_add_uri_co (GamesPlayStationGameFactoryAddUriData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->uri;
		games_play_station_game_factory_add_uri_with_error (_data_->self, _data_->_tmp0_, &_data_->_inner_error_);
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp1_ = _data_->e;
		_data_->_tmp2_ = _data_->_tmp1_->message;
		g_debug ("playstation-game-factory.vala:44: %s", _data_->_tmp2_);
		_g_error_free0 (_data_->e);
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void _vala_array_add1 (GamesMedia** * array, int* length, int* size, GamesMedia* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (GamesMedia*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void games_play_station_game_factory_add_uri_with_error (GamesPlayStationGameFactory* self, GamesUri* uri, GError** error) {
	GHashTable* _tmp0_;
	GamesUri* _tmp1_;
	gboolean _tmp2_;
	GFile* file = NULL;
	GamesUri* _tmp3_;
	GFile* _tmp4_;
	GFileInfo* file_info = NULL;
	GFile* _tmp5_;
	GFileInfo* _tmp6_;
	gchar* mime_type = NULL;
	GFileInfo* _tmp7_;
	const gchar* _tmp8_;
	gchar* _tmp9_;
	GFile* bin_file = NULL;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	GQuark _tmp13_ = 0U;
	GamesPlayStationHeader* header = NULL;
	GFile* _tmp34_;
	GamesPlayStationHeader* _tmp35_;
	GamesPlayStationHeader* _tmp36_;
	gchar* disc_id = NULL;
	GamesPlayStationHeader* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	gchar* _tmp40_;
	GamesGameinfoDoc* gameinfo = NULL;
	GamesGameinfoDoc* _tmp41_;
	gchar* disc_set_id = NULL;
	GamesGameinfoDoc* _tmp42_;
	const gchar* _tmp43_;
	gchar* _tmp44_;
	GHashTable* _tmp45_;
	const gchar* _tmp46_;
	gboolean _tmp47_;
	GHashTable* _tmp48_;
	const gchar* _tmp49_;
	gboolean _tmp50_;
	GHashTable* _tmp51_;
	const gchar* _tmp52_;
	gboolean _tmp53_;
	GHashTable* new_medias = NULL;
	GHashFunc _tmp67_;
	GEqualFunc _tmp68_;
	GHashTable* _tmp69_;
	GamesMedia** new_medias_array = NULL;
	GamesMedia** _tmp70_;
	gint new_medias_array_length1;
	gint _new_medias_array_size_;
	gchar** new_disc_ids = NULL;
	GamesGameinfoDoc* _tmp71_;
	const gchar* _tmp72_;
	gint _tmp73_;
	gchar** _tmp74_;
	gint new_disc_ids_length1;
	gint _new_disc_ids_size_;
	gchar** _tmp75_;
	gint _tmp75__length1;
	GamesMedia* media = NULL;
	GHashTable* _tmp93_;
	const gchar* _tmp94_;
	gconstpointer _tmp95_;
	GamesMedia* _tmp96_;
	GamesMedia* _tmp97_;
	GamesUri* _tmp98_;
	GamesMediaSet* media_set = NULL;
	GamesMediaSet* _tmp99_;
	GamesMedia** _tmp100_;
	gint _tmp100__length1;
	GIcon* _tmp104_ = NULL;
	GIcon* _tmp105_;
	GamesMediaSet* _tmp106_;
	GamesGame* game = NULL;
	GamesMediaSet* _tmp107_;
	const gchar* _tmp108_;
	GamesUri* _tmp109_;
	GamesGame* _tmp110_;
	GHashTable* _tmp111_;
	GList* _tmp112_;
	GHashTable* _tmp120_;
	GamesUri* _tmp121_;
	GamesUri* _tmp122_;
	GamesGame* _tmp123_;
	GamesGame* _tmp124_;
	GHashTable* _tmp125_;
	const gchar* _tmp126_;
	gchar* _tmp127_;
	GamesGame* _tmp128_;
	GamesGame* _tmp129_;
	GHashTable* _tmp130_;
	GamesGame* _tmp131_;
	GamesGame* _tmp132_;
	GamesGame* _tmp133_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (uri != NULL);
	_tmp0_ = self->priv->game_for_uri;
	_tmp1_ = uri;
	_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
	if (_tmp2_) {
		return;
	}
	_tmp3_ = uri;
	_tmp4_ = games_uri_to_file (_tmp3_);
	file = _tmp4_;
	_tmp5_ = file;
	_tmp6_ = g_file_query_info (_tmp5_, G_FILE_ATTRIBUTE_STANDARD_CONTENT_TYPE, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
	file_info = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return;
	}
	_tmp7_ = file_info;
	_tmp8_ = g_file_info_get_content_type (_tmp7_);
	_tmp9_ = g_strdup (_tmp8_);
	mime_type = _tmp9_;
	_tmp10_ = mime_type;
	_tmp11_ = _tmp10_;
	_tmp13_ = (NULL == _tmp11_) ? 0 : g_quark_from_string (_tmp11_);
	if (_tmp13_ == g_quark_from_string (GAMES_PLAY_STATION_GAME_FACTORY_CUE_MIME_TYPE)) {
		switch (0) {
			default:
			{
				GamesCueSheet* cue = NULL;
				GFile* _tmp14_;
				GamesCueSheet* _tmp15_;
				GamesCueSheet* _tmp16_;
				guint _tmp17_;
				guint _tmp18_;
				GamesCueSheetTrackNode* track = NULL;
				GamesCueSheet* _tmp19_;
				GamesCueSheetTrackNode* _tmp20_;
				gboolean _tmp21_ = FALSE;
				GamesCueSheetTrackNode* _tmp22_;
				GamesCueSheetTrackMode _tmp23_;
				GamesCueSheetTrackMode _tmp24_;
				GamesCueSheetTrackNode* _tmp28_;
				GamesCueSheetFileNode* _tmp29_;
				GamesCueSheetFileNode* _tmp30_;
				GFile* _tmp31_;
				GFile* _tmp32_;
				GFile* _tmp33_;
				_tmp14_ = file;
				_tmp15_ = games_cue_sheet_new (_tmp14_, &_inner_error_);
				cue = _tmp15_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return;
				}
				_tmp16_ = cue;
				_tmp17_ = games_cue_sheet_get_tracks_number (_tmp16_);
				_tmp18_ = _tmp17_;
				if (_tmp18_ == ((guint) 0)) {
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return;
				}
				_tmp19_ = cue;
				_tmp20_ = games_cue_sheet_get_track (_tmp19_, (guint) 0, &_inner_error_);
				track = _tmp20_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return;
				}
				_tmp22_ = track;
				_tmp23_ = games_cue_sheet_track_node_get_track_mode (_tmp22_);
				_tmp24_ = _tmp23_;
				if (_tmp24_ != GAMES_CUE_SHEET_TRACK_MODE_MODE1_2352) {
					GamesCueSheetTrackNode* _tmp25_;
					GamesCueSheetTrackMode _tmp26_;
					GamesCueSheetTrackMode _tmp27_;
					_tmp25_ = track;
					_tmp26_ = games_cue_sheet_track_node_get_track_mode (_tmp25_);
					_tmp27_ = _tmp26_;
					_tmp21_ = _tmp27_ != GAMES_CUE_SHEET_TRACK_MODE_MODE2_2352;
				} else {
					_tmp21_ = FALSE;
				}
				if (_tmp21_) {
					_g_object_unref0 (track);
					_g_object_unref0 (cue);
					_g_object_unref0 (bin_file);
					_g_free0 (mime_type);
					_g_object_unref0 (file_info);
					_g_object_unref0 (file);
					return;
				}
				_tmp28_ = track;
				_tmp29_ = games_cue_sheet_track_node_get_file (_tmp28_);
				_tmp30_ = _tmp29_;
				_tmp31_ = games_cue_sheet_file_node_get_file (_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp33_ = _g_object_ref0 (_tmp32_);
				_g_object_unref0 (bin_file);
				bin_file = _tmp33_;
				_g_object_unref0 (track);
				_g_object_unref0 (cue);
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				_g_object_unref0 (bin_file);
				_g_free0 (mime_type);
				_g_object_unref0 (file_info);
				_g_object_unref0 (file);
				return;
			}
		}
	}
	_tmp34_ = bin_file;
	_tmp35_ = games_play_station_header_new (_tmp34_);
	header = _tmp35_;
	_tmp36_ = header;
	games_play_station_header_check_validity (_tmp36_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp37_ = header;
	_tmp38_ = games_play_station_header_get_disc_id (_tmp37_);
	_tmp39_ = _tmp38_;
	_tmp40_ = g_strdup (_tmp39_);
	disc_id = _tmp40_;
	_tmp41_ = games_play_station_game_factory_get_gameinfo (&_inner_error_);
	gameinfo = _tmp41_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp42_ = gameinfo;
	_tmp43_ = disc_id;
	_tmp44_ = games_gameinfo_doc_get_disc_set_id_for_disc_id (_tmp42_, _tmp43_, &_inner_error_);
	disc_set_id = _tmp44_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp45_ = self->priv->media_for_disc_id;
	_tmp46_ = disc_id;
	_tmp47_ = g_hash_table_contains (_tmp45_, _tmp46_);
	_tmp48_ = self->priv->game_for_disc_set_id;
	_tmp49_ = disc_set_id;
	_tmp50_ = g_hash_table_contains (_tmp48_, _tmp49_);
	g_return_if_fail (_tmp47_ == _tmp50_);
	_tmp51_ = self->priv->media_for_disc_id;
	_tmp52_ = disc_id;
	_tmp53_ = g_hash_table_contains (_tmp51_, _tmp52_);
	if (_tmp53_) {
		GamesMedia* media = NULL;
		GHashTable* _tmp54_;
		const gchar* _tmp55_;
		gconstpointer _tmp56_;
		GamesMedia* _tmp57_;
		GamesMedia* _tmp58_;
		GamesUri* _tmp59_;
		GHashTable* _tmp60_;
		GamesUri* _tmp61_;
		GamesUri* _tmp62_;
		GHashTable* _tmp63_;
		const gchar* _tmp64_;
		gconstpointer _tmp65_;
		GamesGame* _tmp66_;
		_tmp54_ = self->priv->media_for_disc_id;
		_tmp55_ = disc_id;
		_tmp56_ = g_hash_table_lookup (_tmp54_, _tmp55_);
		_tmp57_ = _g_object_ref0 ((GamesMedia*) _tmp56_);
		media = _tmp57_;
		_tmp58_ = media;
		_tmp59_ = uri;
		games_media_add_uri (_tmp58_, _tmp59_);
		_tmp60_ = self->priv->game_for_uri;
		_tmp61_ = uri;
		_tmp62_ = _games_uri_ref0 (_tmp61_);
		_tmp63_ = self->priv->game_for_disc_set_id;
		_tmp64_ = disc_set_id;
		_tmp65_ = g_hash_table_lookup (_tmp63_, _tmp64_);
		_tmp66_ = _g_object_ref0 ((GamesGame*) _tmp65_);
		g_hash_table_insert (_tmp60_, _tmp62_, _tmp66_);
		_g_object_unref0 (media);
		_g_free0 (disc_set_id);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp67_ = g_str_hash;
	_tmp68_ = g_str_equal;
	_tmp69_ = g_hash_table_new_full (_tmp67_, _tmp68_, _g_free0_, _g_object_unref0_);
	new_medias = _tmp69_;
	_tmp70_ = g_new0 (GamesMedia*, 0 + 1);
	new_medias_array = _tmp70_;
	new_medias_array_length1 = 0;
	_new_medias_array_size_ = new_medias_array_length1;
	_tmp71_ = gameinfo;
	_tmp72_ = disc_id;
	_tmp74_ = games_gameinfo_doc_get_disc_set_ids_for_disc_id (_tmp71_, _tmp72_, &_tmp73_, &_inner_error_);
	new_disc_ids = _tmp74_;
	new_disc_ids_length1 = _tmp73_;
	_new_disc_ids_size_ = new_disc_ids_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		new_medias_array = (_vala_array_free (new_medias_array, new_medias_array_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_hash_table_unref0 (new_medias);
		_g_free0 (disc_set_id);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp75_ = new_disc_ids;
	_tmp75__length1 = new_disc_ids_length1;
	{
		gchar** new_disc_id_collection = NULL;
		gint new_disc_id_collection_length1 = 0;
		gint _new_disc_id_collection_size_ = 0;
		gint new_disc_id_it = 0;
		new_disc_id_collection = _tmp75_;
		new_disc_id_collection_length1 = _tmp75__length1;
		for (new_disc_id_it = 0; new_disc_id_it < _tmp75__length1; new_disc_id_it = new_disc_id_it + 1) {
			gchar* _tmp76_;
			gchar* new_disc_id = NULL;
			_tmp76_ = g_strdup (new_disc_id_collection[new_disc_id_it]);
			new_disc_id = _tmp76_;
			{
				GHashTable* _tmp77_;
				const gchar* _tmp78_;
				gboolean _tmp79_;
				GamesGameinfoDiscIdDiscTitle* title = NULL;
				GamesGameinfoDoc* _tmp80_;
				const gchar* _tmp81_;
				GamesGameinfoDiscIdDiscTitle* _tmp82_;
				GamesMedia* media = NULL;
				GamesGameinfoDiscIdDiscTitle* _tmp83_;
				GamesMedia* _tmp84_;
				GamesMedia** _tmp85_;
				gint _tmp85__length1;
				GamesMedia* _tmp86_;
				GamesMedia* _tmp87_;
				GHashTable* _tmp88_;
				const gchar* _tmp89_;
				gchar* _tmp90_;
				GamesMedia* _tmp91_;
				GamesMedia* _tmp92_;
				_tmp77_ = self->priv->media_for_disc_id;
				_tmp78_ = new_disc_id;
				_tmp79_ = g_hash_table_contains (_tmp77_, _tmp78_);
				_vala_assert (!_tmp79_, "!media_for_disc_id.contains (new_disc_id)");
				_tmp80_ = gameinfo;
				_tmp81_ = new_disc_id;
				_tmp82_ = games_gameinfo_disc_id_disc_title_new (_tmp80_, _tmp81_, NULL);
				title = _tmp82_;
				_tmp83_ = title;
				_tmp84_ = games_media_new ((GamesTitle*) _tmp83_);
				media = _tmp84_;
				_tmp85_ = new_medias_array;
				_tmp85__length1 = new_medias_array_length1;
				_tmp86_ = media;
				_tmp87_ = _g_object_ref0 (_tmp86_);
				_vala_array_add1 (&new_medias_array, &new_medias_array_length1, &_new_medias_array_size_, _tmp87_);
				_tmp88_ = new_medias;
				_tmp89_ = new_disc_id;
				_tmp90_ = g_strdup (_tmp89_);
				_tmp91_ = media;
				_tmp92_ = _g_object_ref0 (_tmp91_);
				g_hash_table_insert (_tmp88_, _tmp90_, _tmp92_);
				_g_object_unref0 (media);
				_g_object_unref0 (title);
				_g_free0 (new_disc_id);
			}
		}
	}
	_tmp93_ = new_medias;
	_tmp94_ = disc_id;
	_tmp95_ = g_hash_table_lookup (_tmp93_, _tmp94_);
	_tmp96_ = _g_object_ref0 ((GamesMedia*) _tmp95_);
	media = _tmp96_;
	_tmp97_ = media;
	_tmp98_ = uri;
	games_media_add_uri (_tmp97_, _tmp98_);
	_tmp99_ = games_media_set_new ();
	media_set = _tmp99_;
	_tmp100_ = new_medias_array;
	_tmp100__length1 = new_medias_array_length1;
	{
		GamesMedia** game_media_collection = NULL;
		gint game_media_collection_length1 = 0;
		gint _game_media_collection_size_ = 0;
		gint game_media_it = 0;
		game_media_collection = _tmp100_;
		game_media_collection_length1 = _tmp100__length1;
		for (game_media_it = 0; game_media_it < _tmp100__length1; game_media_it = game_media_it + 1) {
			GamesMedia* _tmp101_;
			GamesMedia* game_media = NULL;
			_tmp101_ = _g_object_ref0 (game_media_collection[game_media_it]);
			game_media = _tmp101_;
			{
				GamesMediaSet* _tmp102_;
				GamesMedia* _tmp103_;
				_tmp102_ = media_set;
				_tmp103_ = game_media;
				games_media_set_add_media (_tmp102_, _tmp103_);
				_g_object_unref0 (game_media);
			}
		}
	}
	_tmp105_ = g_icon_new_for_string (GAMES_PLAY_STATION_GAME_FACTORY_ICON_NAME, &_inner_error_);
	_tmp104_ = _tmp105_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (media_set);
		_g_object_unref0 (media);
		new_disc_ids = (_vala_array_free (new_disc_ids, new_disc_ids_length1, (GDestroyNotify) g_free), NULL);
		new_medias_array = (_vala_array_free (new_medias_array, new_medias_array_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_hash_table_unref0 (new_medias);
		_g_free0 (disc_set_id);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp106_ = media_set;
	games_media_set_set_icon (_tmp106_, _tmp104_);
	_tmp107_ = media_set;
	_tmp108_ = disc_set_id;
	_tmp109_ = uri;
	_tmp110_ = games_play_station_game_factory_create_game (self, _tmp107_, _tmp108_, _tmp109_, &_inner_error_);
	game = _tmp110_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (_tmp104_);
		_g_object_unref0 (media_set);
		_g_object_unref0 (media);
		new_disc_ids = (_vala_array_free (new_disc_ids, new_disc_ids_length1, (GDestroyNotify) g_free), NULL);
		new_medias_array = (_vala_array_free (new_medias_array, new_medias_array_length1, (GDestroyNotify) g_object_unref), NULL);
		_g_hash_table_unref0 (new_medias);
		_g_free0 (disc_set_id);
		_g_object_unref0 (gameinfo);
		_g_free0 (disc_id);
		_g_object_unref0 (header);
		_g_object_unref0 (bin_file);
		_g_free0 (mime_type);
		_g_object_unref0 (file_info);
		_g_object_unref0 (file);
		return;
	}
	_tmp111_ = new_medias;
	_tmp112_ = g_hash_table_get_keys (_tmp111_);
	{
		GList* new_disc_id_collection = NULL;
		GList* new_disc_id_it = NULL;
		new_disc_id_collection = _tmp112_;
		for (new_disc_id_it = new_disc_id_collection; new_disc_id_it != NULL; new_disc_id_it = new_disc_id_it->next) {
			const gchar* new_disc_id = NULL;
			new_disc_id = (const gchar*) new_disc_id_it->data;
			{
				GHashTable* _tmp113_;
				const gchar* _tmp114_;
				gchar* _tmp115_;
				GHashTable* _tmp116_;
				const gchar* _tmp117_;
				gconstpointer _tmp118_;
				GamesMedia* _tmp119_;
				_tmp113_ = self->priv->media_for_disc_id;
				_tmp114_ = new_disc_id;
				_tmp115_ = g_strdup (_tmp114_);
				_tmp116_ = new_medias;
				_tmp117_ = new_disc_id;
				_tmp118_ = g_hash_table_lookup (_tmp116_, _tmp117_);
				_tmp119_ = _g_object_ref0 ((GamesMedia*) _tmp118_);
				g_hash_table_insert (_tmp113_, _tmp115_, _tmp119_);
			}
		}
		_g_list_free0 (new_disc_id_collection);
	}
	_tmp120_ = self->priv->game_for_uri;
	_tmp121_ = uri;
	_tmp122_ = _games_uri_ref0 (_tmp121_);
	_tmp123_ = game;
	_tmp124_ = _g_object_ref0 (_tmp123_);
	g_hash_table_insert (_tmp120_, _tmp122_, _tmp124_);
	_tmp125_ = self->priv->game_for_disc_set_id;
	_tmp126_ = disc_set_id;
	_tmp127_ = g_strdup (_tmp126_);
	_tmp128_ = game;
	_tmp129_ = _g_object_ref0 (_tmp128_);
	g_hash_table_insert (_tmp125_, _tmp127_, _tmp129_);
	_tmp130_ = self->priv->games;
	_tmp131_ = game;
	_tmp132_ = _g_object_ref0 (_tmp131_);
	g_hash_table_add (_tmp130_, _tmp132_);
	_tmp133_ = game;
	g_signal_emit_by_name ((GamesUriGameFactory*) self, "game-added", _tmp133_);
	_g_object_unref0 (game);
	_g_object_unref0 (_tmp104_);
	_g_object_unref0 (media_set);
	_g_object_unref0 (media);
	new_disc_ids = (_vala_array_free (new_disc_ids, new_disc_ids_length1, (GDestroyNotify) g_free), NULL);
	new_medias_array = (_vala_array_free (new_medias_array, new_medias_array_length1, (GDestroyNotify) g_object_unref), NULL);
	_g_hash_table_unref0 (new_medias);
	_g_free0 (disc_set_id);
	_g_object_unref0 (gameinfo);
	_g_free0 (disc_id);
	_g_object_unref0 (header);
	_g_object_unref0 (bin_file);
	_g_free0 (mime_type);
	_g_object_unref0 (file_info);
	_g_object_unref0 (file);
}


static void games_play_station_game_factory_real_foreach_game_data_free (gpointer _data) {
	GamesPlayStationGameFactoryForeachGameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesPlayStationGameFactoryForeachGameData, _data_);
}


static void games_play_station_game_factory_real_foreach_game_async_ready_wrapper (GObject *source_object, GAsyncResult *res, void *user_data) {
	GamesPlayStationGameFactoryForeachGameData* _task_data_;
	_task_data_ = g_task_get_task_data (G_TASK (res));
	if (_task_data_->_callback_ != NULL) {
		_task_data_->_callback_ (source_object, res, user_data);
	}
	_task_data_->_task_complete_ = TRUE;
}


static void games_play_station_game_factory_real_foreach_game (GamesUriGameFactory* base, GamesGameCallback game_callback, void* game_callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesPlayStationGameFactory * self;
	GamesPlayStationGameFactoryForeachGameData* _data_;
	GamesPlayStationGameFactory* _tmp0_;
	GamesGameCallback _tmp1_;
	void* _tmp1__target;
	self = (GamesPlayStationGameFactory*) base;
	_data_ = g_slice_new0 (GamesPlayStationGameFactoryForeachGameData);
	_data_->_callback_ = _callback_;
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, games_play_station_game_factory_real_foreach_game_async_ready_wrapper, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_play_station_game_factory_real_foreach_game_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = game_callback;
	_tmp1__target = game_callback_target;
	_data_->game_callback = _tmp1_;
	_data_->game_callback_target = _tmp1__target;
	games_play_station_game_factory_real_foreach_game_co (_data_);
}


static void games_play_station_game_factory_real_foreach_game_finish (GamesUriGameFactory* base, GAsyncResult* _res_) {
	GamesPlayStationGameFactoryForeachGameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
	g_atomic_int_inc (&_data1_->_ref_count_);
	return _data1_;
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
		GamesPlayStationGameFactory* self;
		self = _data1_->self;
		_g_object_unref0 (self);
		g_slice_free (Block1Data, _data1_);
	}
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
	g_atomic_int_inc (&_data2_->_ref_count_);
	return _data2_;
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
		GHashTable* self;
		self = _data2_->self;
		_g_hash_table_unref0 (self);
		g_slice_free (Block2Data, _data2_);
	}
}


static void __lambda0_ (Block2Data* _data2_, gconstpointer k, gconstpointer v) {
	GHashTable* self;
	GFunc _tmp0_;
	void* _tmp0__target;
	gconstpointer _tmp1_;
	self = _data2_->self;
	_tmp0_ = _data2_->func;
	_tmp0__target = _data2_->func_target;
	_tmp1_ = v;
	_tmp0_ (_tmp1_, _tmp0__target);
}


static void ___lambda0__gh_func (gconstpointer key, gconstpointer value, gpointer self) {
	__lambda0_ (self, key, value);
}


static void _vala_g_hash_set_foreach (GHashTable* self, GFunc func, void* func_target) {
	Block2Data* _data2_;
	GFunc _tmp0_;
	void* _tmp0__target;
	g_return_if_fail (self != NULL);
	_data2_ = g_slice_new0 (Block2Data);
	_data2_->_ref_count_ = 1;
	_data2_->self = g_hash_table_ref (self);
	_tmp0_ = func;
	_tmp0__target = func_target;
	_data2_->func = _tmp0_;
	_data2_->func_target = _tmp0__target;
	g_hash_table_foreach ((GHashTable*) self, ___lambda0__gh_func, _data2_);
	block2_data_unref (_data2_);
	_data2_ = NULL;
}


static void __lambda4_ (Block1Data* _data1_, GamesGame* game) {
	GamesPlayStationGameFactory* self;
	GamesGameCallback _tmp0_;
	void* _tmp0__target;
	GamesGame* _tmp1_;
	self = _data1_->self;
	g_return_if_fail (game != NULL);
	_tmp0_ = _data1_->game_callback;
	_tmp0__target = _data1_->game_callback_target;
	_tmp1_ = game;
	_tmp0_ (_tmp1_, _tmp0__target);
}


static void ___lambda4__gfunc (gconstpointer data, gpointer self) {
	__lambda4_ (self, (GamesGame*) data);
}


static gboolean games_play_station_game_factory_real_foreach_game_co (GamesPlayStationGameFactoryForeachGameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_data1_ = g_slice_new0 (Block1Data);
	_data_->_data1_->_ref_count_ = 1;
	_data_->_data1_->self = g_object_ref (_data_->self);
	_data_->_tmp0_ = _data_->game_callback;
	_data_->_tmp0__target = _data_->game_callback_target;
	_data_->_data1_->game_callback = _data_->_tmp0_;
	_data_->_data1_->game_callback_target = _data_->_tmp0__target;
	_data_->_data1_->_async_data_ = _data_;
	_data_->_tmp1_ = _data_->self->priv->games;
	_vala_g_hash_set_foreach (_data_->_tmp1_, ___lambda4__gfunc, _data_->_data1_);
	block1_data_unref (_data_->_data1_);
	_data_->_data1_ = NULL;
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static GamesGame* games_play_station_game_factory_create_game (GamesPlayStationGameFactory* self, GamesMediaSet* media_set, const gchar* disc_set_id, GamesUri* uri, GError** error) {
	GamesGame* result = NULL;
	GamesGameinfoDoc* gameinfo = NULL;
	GamesGameinfoDoc* _tmp0_;
	GamesPlayStationUid* uid = NULL;
	const gchar* _tmp1_;
	GamesPlayStationUid* _tmp2_;
	GamesCompositeTitle* title = NULL;
	const gchar* _tmp3_;
	GamesGameinfoDiscIdGameTitle* _tmp4_;
	GamesUri* _tmp5_;
	GamesFilenameTitle* _tmp6_;
	GamesTitle** _tmp7_;
	GamesTitle** _tmp8_;
	gint _tmp8__length1;
	GamesCompositeTitle* _tmp9_;
	GamesCompositeTitle* _tmp10_;
	GamesDummyIcon* icon = NULL;
	GamesDummyIcon* _tmp11_;
	GamesGriloMedia* media = NULL;
	GamesCompositeTitle* _tmp12_;
	GamesGriloMedia* _tmp13_;
	GamesCompositeCover* cover = NULL;
	GamesUri* _tmp14_;
	GamesLocalCover* _tmp15_;
	GamesGriloMedia* _tmp16_;
	GamesPlayStationUid* _tmp17_;
	GamesGriloCover* _tmp18_;
	GamesCover** _tmp19_;
	GamesCover** _tmp20_;
	gint _tmp20__length1;
	GamesCompositeCover* _tmp21_;
	GamesCompositeCover* _tmp22_;
	GamesGameinfoDiscIdInputCapabilities* input_capabilities = NULL;
	const gchar* _tmp23_;
	GamesGameinfoDiscIdInputCapabilities* _tmp24_;
	GamesRetroCoreSource* core_source = NULL;
	gchar* _tmp25_;
	gchar* _tmp26_;
	gchar** _tmp27_;
	gchar** _tmp28_;
	gint _tmp28__length1;
	GamesRetroCoreSource* _tmp29_;
	GamesRetroCoreSource* _tmp30_;
	GamesRetroRunner* runner = NULL;
	GamesRetroCoreSource* _tmp31_;
	GamesMediaSet* _tmp32_;
	GamesPlayStationUid* _tmp33_;
	GamesGameinfoDiscIdInputCapabilities* _tmp34_;
	GamesCompositeTitle* _tmp35_;
	GamesRetroRunner* _tmp36_;
	GamesCompositeTitle* _tmp37_;
	GamesDummyIcon* _tmp38_;
	GamesCompositeCover* _tmp39_;
	GamesRetroRunner* _tmp40_;
	GamesGenericGame* _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (media_set != NULL, NULL);
	g_return_val_if_fail (disc_set_id != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	_tmp0_ = games_play_station_game_factory_get_gameinfo (&_inner_error_);
	gameinfo = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = disc_set_id;
	_tmp2_ = games_play_station_uid_new (_tmp1_);
	uid = _tmp2_;
	_tmp3_ = disc_set_id;
	_tmp4_ = games_gameinfo_disc_id_game_title_new (gameinfo, _tmp3_, NULL);
	_tmp5_ = uri;
	_tmp6_ = games_filename_title_new (_tmp5_);
	_tmp7_ = g_new0 (GamesTitle*, 2 + 1);
	_tmp7_[0] = (GamesTitle*) _tmp4_;
	_tmp7_[1] = (GamesTitle*) _tmp6_;
	_tmp8_ = _tmp7_;
	_tmp8__length1 = 2;
	_tmp9_ = games_composite_title_new (_tmp8_, 2);
	_tmp10_ = _tmp9_;
	_tmp8_ = (_vala_array_free (_tmp8_, _tmp8__length1, (GDestroyNotify) g_object_unref), NULL);
	title = _tmp10_;
	_tmp11_ = games_dummy_icon_new ();
	icon = _tmp11_;
	_tmp12_ = title;
	_tmp13_ = games_grilo_media_new ((GamesTitle*) _tmp12_, GAMES_PLAY_STATION_GAME_FACTORY_PHONY_MIME_TYPE);
	media = _tmp13_;
	_tmp14_ = uri;
	_tmp15_ = games_local_cover_new (_tmp14_);
	_tmp16_ = media;
	_tmp17_ = uid;
	_tmp18_ = games_grilo_cover_new (_tmp16_, (GamesUid*) _tmp17_);
	_tmp19_ = g_new0 (GamesCover*, 2 + 1);
	_tmp19_[0] = (GamesCover*) _tmp15_;
	_tmp19_[1] = (GamesCover*) _tmp18_;
	_tmp20_ = _tmp19_;
	_tmp20__length1 = 2;
	_tmp21_ = games_composite_cover_new (_tmp20_, 2);
	_tmp22_ = _tmp21_;
	_tmp20_ = (_vala_array_free (_tmp20_, _tmp20__length1, (GDestroyNotify) g_object_unref), NULL);
	cover = _tmp22_;
	_tmp23_ = disc_set_id;
	_tmp24_ = games_gameinfo_disc_id_input_capabilities_new (gameinfo, _tmp23_);
	input_capabilities = _tmp24_;
	_tmp25_ = g_strdup (GAMES_PLAY_STATION_GAME_FACTORY_CUE_MIME_TYPE);
	_tmp26_ = g_strdup (GAMES_PLAY_STATION_GAME_FACTORY_PHONY_MIME_TYPE);
	_tmp27_ = g_new0 (gchar*, 2 + 1);
	_tmp27_[0] = _tmp25_;
	_tmp27_[1] = _tmp26_;
	_tmp28_ = _tmp27_;
	_tmp28__length1 = 2;
	_tmp29_ = games_retro_core_source_new (GAMES_PLAY_STATION_GAME_FACTORY_PLATFORM, _tmp28_, 2);
	_tmp30_ = _tmp29_;
	_tmp28_ = (_vala_array_free (_tmp28_, _tmp28__length1, (GDestroyNotify) g_free), NULL);
	core_source = _tmp30_;
	_tmp31_ = core_source;
	_tmp32_ = media_set;
	_tmp33_ = uid;
	_tmp34_ = input_capabilities;
	_tmp35_ = title;
	_tmp36_ = games_retro_runner_new_for_media_set_and_input_capabilities (_tmp31_, _tmp32_, (GamesUid*) _tmp33_, (GamesInputCapabilities*) _tmp34_, (GamesTitle*) _tmp35_);
	runner = _tmp36_;
	_tmp37_ = title;
	_tmp38_ = icon;
	_tmp39_ = cover;
	_tmp40_ = runner;
	_tmp41_ = games_generic_game_new ((GamesTitle*) _tmp37_, (GamesIcon*) _tmp38_, (GamesCover*) _tmp39_, (GamesRunner*) _tmp40_);
	result = (GamesGame*) _tmp41_;
	_g_object_unref0 (runner);
	_g_object_unref0 (core_source);
	_g_object_unref0 (input_capabilities);
	_g_object_unref0 (cover);
	_g_object_unref0 (media);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_object_unref0 (uid);
	_g_object_unref0 (gameinfo);
	return result;
}


static GamesGameinfoDoc* games_play_station_game_factory_get_gameinfo (GError** error) {
	GamesGameinfoDoc* result = NULL;
	GamesGameinfoDoc* _tmp0_;
	GFile* file = NULL;
	GFile* _tmp3_;
	GFileInputStream* input_stream = NULL;
	GFile* _tmp4_;
	GFileInputStream* _tmp5_;
	GFileInputStream* _tmp6_;
	gint64 length = 0LL;
	GFileInputStream* _tmp7_;
	gint64 _tmp8_;
	GFileInputStream* _tmp9_;
	guint8* buffer = NULL;
	gint64 _tmp10_;
	guint8* _tmp11_;
	gint buffer_length1;
	gint _buffer_size_;
	gsize size = 0UL;
	GFileInputStream* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	gsize _tmp14_ = 0UL;
	GamesGameinfoDoc* _tmp15_ = NULL;
	guint8* _tmp16_;
	gint _tmp16__length1;
	GamesGameinfoDoc* _tmp17_;
	GamesGameinfoDoc* _tmp18_;
	GamesGameinfoDoc* _tmp19_;
	GamesGameinfoDoc* _tmp20_;
	GError * _inner_error_ = NULL;
	_tmp0_ = games_play_station_game_factory_gameinfo;
	if (_tmp0_ != NULL) {
		GamesGameinfoDoc* _tmp1_;
		GamesGameinfoDoc* _tmp2_;
		_tmp1_ = games_play_station_game_factory_gameinfo;
		_tmp2_ = _g_object_ref0 (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = g_file_new_for_uri (GAMES_PLAY_STATION_GAME_FACTORY_GAMEINFO);
	file = _tmp3_;
	_tmp4_ = file;
	_tmp5_ = g_file_read (_tmp4_, NULL, &_inner_error_);
	input_stream = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp6_ = input_stream;
	G_FILE_INPUT_STREAM_GET_CLASS (_tmp6_)->seek (_tmp6_, (gint64) 0, G_SEEK_END, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp7_ = input_stream;
	_tmp8_ = G_FILE_INPUT_STREAM_GET_CLASS (_tmp7_)->tell (_tmp7_);
	length = _tmp8_;
	_tmp9_ = input_stream;
	G_FILE_INPUT_STREAM_GET_CLASS (_tmp9_)->seek (_tmp9_, (gint64) 0, G_SEEK_SET, NULL, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp10_ = length;
	_tmp11_ = g_new0 (guint8, _tmp10_);
	buffer = _tmp11_;
	buffer_length1 = _tmp10_;
	_buffer_size_ = buffer_length1;
	size = (gsize) 0;
	_tmp12_ = input_stream;
	_tmp13_ = buffer;
	_tmp13__length1 = buffer_length1;
	g_input_stream_read_all ((GInputStream*) _tmp12_, _tmp13_, (gsize) _tmp13__length1, &_tmp14_, NULL, &_inner_error_);
	size = _tmp14_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp16_ = buffer;
	_tmp16__length1 = buffer_length1;
	_tmp17_ = games_gameinfo_doc_new_from_data (_tmp16_, _tmp16__length1, &_inner_error_);
	_tmp15_ = _tmp17_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		buffer = (g_free (buffer), NULL);
		_g_object_unref0 (input_stream);
		_g_object_unref0 (file);
		return NULL;
	}
	_tmp18_ = _tmp15_;
	_tmp15_ = NULL;
	_g_object_unref0 (games_play_station_game_factory_gameinfo);
	games_play_station_game_factory_gameinfo = _tmp18_;
	_tmp19_ = games_play_station_game_factory_gameinfo;
	_tmp20_ = _g_object_ref0 (_tmp19_);
	result = _tmp20_;
	_g_object_unref0 (_tmp15_);
	buffer = (g_free (buffer), NULL);
	_g_object_unref0 (input_stream);
	_g_object_unref0 (file);
	return result;
}


static void games_play_station_game_factory_class_init (GamesPlayStationGameFactoryClass * klass) {
	games_play_station_game_factory_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesPlayStationGameFactoryPrivate));
	G_OBJECT_CLASS (klass)->finalize = games_play_station_game_factory_finalize;
}


static void games_play_station_game_factory_games_uri_game_factory_interface_init (GamesUriGameFactoryIface * iface) {
	games_play_station_game_factory_games_uri_game_factory_parent_iface = g_type_interface_peek_parent (iface);
	iface->get_mime_types = (gchar** (*) (GamesUriGameFactory *, int*)) games_play_station_game_factory_real_get_mime_types;
	iface->query_game_for_uri = (void (*) (GamesUriGameFactory *, GamesUri*, GAsyncReadyCallback, gpointer)) games_play_station_game_factory_real_query_game_for_uri;
	iface->query_game_for_uri_finish = (GamesGame* (*) (GamesUriGameFactory *, GAsyncResult*)) games_play_station_game_factory_real_query_game_for_uri_finish;
	iface->add_uri = (void (*) (GamesUriGameFactory *, GamesUri*, GAsyncReadyCallback, gpointer)) games_play_station_game_factory_real_add_uri;
	iface->add_uri_finish = (void (*) (GamesUriGameFactory *, GAsyncResult*)) games_play_station_game_factory_real_add_uri_finish;
	iface->foreach_game = (void (*) (GamesUriGameFactory *, GamesGameCallback, void*, GAsyncReadyCallback, gpointer)) games_play_station_game_factory_real_foreach_game;
	iface->foreach_game_finish = (void (*) (GamesUriGameFactory *, GAsyncResult*)) games_play_station_game_factory_real_foreach_game_finish;
}


static void games_play_station_game_factory_instance_init (GamesPlayStationGameFactory * self) {
	self->priv = GAMES_PLAY_STATION_GAME_FACTORY_GET_PRIVATE (self);
}


static void games_play_station_game_factory_finalize (GObject * obj) {
	GamesPlayStationGameFactory * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_PLAY_STATION_GAME_FACTORY, GamesPlayStationGameFactory);
	_g_hash_table_unref0 (self->priv->media_for_disc_id);
	_g_hash_table_unref0 (self->priv->game_for_uri);
	_g_hash_table_unref0 (self->priv->game_for_disc_set_id);
	_g_hash_table_unref0 (self->priv->games);
	G_OBJECT_CLASS (games_play_station_game_factory_parent_class)->finalize (obj);
}


GType games_play_station_game_factory_get_type (void) {
	return games_play_station_game_factory_type_id;
}


GType games_play_station_game_factory_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesPlayStationGameFactoryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_play_station_game_factory_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesPlayStationGameFactory), 0, (GInstanceInitFunc) games_play_station_game_factory_instance_init, NULL };
	static const GInterfaceInfo games_uri_game_factory_info = { (GInterfaceInitFunc) games_play_station_game_factory_games_uri_game_factory_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_play_station_game_factory_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesPlayStationGameFactory", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_play_station_game_factory_type_id, GAMES_TYPE_URI_GAME_FACTORY, &games_uri_game_factory_info);
	return games_play_station_game_factory_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



