/* retro-runner.c generated by valac 0.35.5.22-e5360, the Vala compiler
 * generated from retro-runner.vala, do not modify */

/* This file is part of GNOME Games. License: GPL-3.0+.*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <retro-gtk.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <stdio.h>
#include <glib/gstdio.h>
#include <gdk-pixbuf/gdk-pixbuf.h>


#define GAMES_TYPE_RUNNER (games_runner_get_type ())
#define GAMES_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RUNNER, GamesRunner))
#define GAMES_IS_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RUNNER))
#define GAMES_RUNNER_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_RUNNER, GamesRunnerIface))

typedef struct _GamesRunner GamesRunner;
typedef struct _GamesRunnerIface GamesRunnerIface;

#define GAMES_TYPE_MEDIA_SET (games_media_set_get_type ())
#define GAMES_MEDIA_SET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEDIA_SET, GamesMediaSet))
#define GAMES_MEDIA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEDIA_SET, GamesMediaSetClass))
#define GAMES_IS_MEDIA_SET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEDIA_SET))
#define GAMES_IS_MEDIA_SET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEDIA_SET))
#define GAMES_MEDIA_SET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEDIA_SET, GamesMediaSetClass))

typedef struct _GamesMediaSet GamesMediaSet;
typedef struct _GamesMediaSetClass GamesMediaSetClass;

#define GAMES_TYPE_RETRO_RUNNER (games_retro_runner_get_type ())
#define GAMES_RETRO_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner))
#define GAMES_RETRO_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_RUNNER, GamesRetroRunnerClass))
#define GAMES_IS_RETRO_RUNNER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_RUNNER))
#define GAMES_IS_RETRO_RUNNER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_RUNNER))
#define GAMES_RETRO_RUNNER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_RUNNER, GamesRetroRunnerClass))

typedef struct _GamesRetroRunner GamesRetroRunner;
typedef struct _GamesRetroRunnerClass GamesRetroRunnerClass;
typedef struct _GamesRetroRunnerPrivate GamesRetroRunnerPrivate;

#define GAMES_TYPE_RETRO_INPUT_MANAGER (games_retro_input_manager_get_type ())
#define GAMES_RETRO_INPUT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManager))
#define GAMES_RETRO_INPUT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManagerClass))
#define GAMES_IS_RETRO_INPUT_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER))
#define GAMES_IS_RETRO_INPUT_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_INPUT_MANAGER))
#define GAMES_RETRO_INPUT_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_INPUT_MANAGER, GamesRetroInputManagerClass))

typedef struct _GamesRetroInputManager GamesRetroInputManager;
typedef struct _GamesRetroInputManagerClass GamesRetroInputManagerClass;

#define GAMES_TYPE_RETRO_CORE_SOURCE (games_retro_core_source_get_type ())
#define GAMES_RETRO_CORE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSource))
#define GAMES_RETRO_CORE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSourceClass))
#define GAMES_IS_RETRO_CORE_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_RETRO_CORE_SOURCE))
#define GAMES_IS_RETRO_CORE_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_RETRO_CORE_SOURCE))
#define GAMES_RETRO_CORE_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_RETRO_CORE_SOURCE, GamesRetroCoreSourceClass))

typedef struct _GamesRetroCoreSource GamesRetroCoreSource;
typedef struct _GamesRetroCoreSourceClass GamesRetroCoreSourceClass;

#define GAMES_TYPE_UID (games_uid_get_type ())
#define GAMES_UID(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_UID, GamesUid))
#define GAMES_IS_UID(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_UID))
#define GAMES_UID_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_UID, GamesUidIface))

typedef struct _GamesUid GamesUid;
typedef struct _GamesUidIface GamesUidIface;

#define GAMES_TYPE_INPUT_CAPABILITIES (games_input_capabilities_get_type ())
#define GAMES_INPUT_CAPABILITIES(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_INPUT_CAPABILITIES, GamesInputCapabilities))
#define GAMES_IS_INPUT_CAPABILITIES(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_INPUT_CAPABILITIES))
#define GAMES_INPUT_CAPABILITIES_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_INPUT_CAPABILITIES, GamesInputCapabilitiesIface))

typedef struct _GamesInputCapabilities GamesInputCapabilities;
typedef struct _GamesInputCapabilitiesIface GamesInputCapabilitiesIface;

#define GAMES_TYPE_TITLE (games_title_get_type ())
#define GAMES_TITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_TITLE, GamesTitle))
#define GAMES_IS_TITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_TITLE))
#define GAMES_TITLE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), GAMES_TYPE_TITLE, GamesTitleIface))

typedef struct _GamesTitle GamesTitle;
typedef struct _GamesTitleIface GamesTitleIface;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define GAMES_TYPE_MEDIA (games_media_get_type ())
#define GAMES_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_MEDIA, GamesMedia))
#define GAMES_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_MEDIA, GamesMediaClass))
#define GAMES_IS_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_MEDIA))
#define GAMES_IS_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_MEDIA))
#define GAMES_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_MEDIA, GamesMediaClass))

typedef struct _GamesMedia GamesMedia;
typedef struct _GamesMediaClass GamesMediaClass;
#define _g_date_time_unref0(var) ((var == NULL) ? NULL : (var = (g_date_time_unref (var), NULL)))

struct _GamesRunnerIface {
	GTypeInterface parent_iface;
	gboolean (*check_is_valid) (GamesRunner* self, gchar* * error_message, GError** error);
	GtkWidget* (*get_display) (GamesRunner* self);
	void (*start) (GamesRunner* self, GError** error);
	void (*resume) (GamesRunner* self, GError** error);
	void (*pause) (GamesRunner* self);
	void (*stop) (GamesRunner* self);
	gboolean (*get_can_fullscreen) (GamesRunner* self);
	gboolean (*get_can_quit_safely) (GamesRunner* self);
	gboolean (*get_can_resume) (GamesRunner* self);
	GamesMediaSet* (*get_media_set) (GamesRunner* self);
};

struct _GamesRetroRunner {
	GObject parent_instance;
	GamesRetroRunnerPrivate * priv;
};

struct _GamesRetroRunnerClass {
	GObjectClass parent_class;
};

struct _GamesUidIface {
	GTypeInterface parent_iface;
	gchar* (*get_uid) (GamesUid* self, GError** error);
};

struct _GamesInputCapabilitiesIface {
	GTypeInterface parent_iface;
	gboolean (*get_allow_classic_gamepads) (GamesInputCapabilities* self, GError** error);
	gboolean (*get_allow_analog_gamepads) (GamesInputCapabilities* self, GError** error);
};

struct _GamesTitleIface {
	GTypeInterface parent_iface;
	gchar* (*get_title) (GamesTitle* self, GError** error);
};

struct _GamesRetroRunnerPrivate {
	GamesMediaSet* _media_set;
	RetroCore* core;
	RetroCairoDisplay* video;
	RetroPaPlayer* audio;
	GamesRetroInputManager* input_manager;
	RetroMainLoop* loop;
	GtkEventBox* widget;
	gchar* save_path;
	gchar* snapshot_path;
	gchar* screenshot_path;
	RetroCoreDescriptor* core_descriptor;
	GamesRetroCoreSource* core_source;
	GamesUid* uid;
	GamesInputCapabilities* input_capabilities;
	GSettings* settings;
	GamesTitle* game_title;
	gboolean _running;
	gboolean is_initialized;
	gboolean is_ready;
	gboolean should_save;
};

typedef enum  {
	GAMES_RETRO_ERROR_MODULE_NOT_FOUND,
	GAMES_RETRO_ERROR_INVALID_GAME_FILE,
	GAMES_RETRO_ERROR_COULDNT_WRITE_SNAPSHOT,
	GAMES_RETRO_ERROR_COULDNT_LOAD_SNAPSHOT,
	GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND
} GamesRetroError;
#define GAMES_RETRO_ERROR games_retro_error_quark ()

static gpointer games_retro_runner_parent_class = NULL;
static GamesRunnerIface * games_retro_runner_games_runner_parent_iface = NULL;

GType games_media_set_get_type (void) G_GNUC_CONST;
GType games_runner_get_type (void) G_GNUC_CONST;
GType games_retro_runner_get_type (void) G_GNUC_CONST;
GType games_retro_input_manager_get_type (void) G_GNUC_CONST;
GType games_retro_core_source_get_type (void) G_GNUC_CONST;
GType games_uid_get_type (void) G_GNUC_CONST;
GType games_input_capabilities_get_type (void) G_GNUC_CONST;
GType games_title_get_type (void) G_GNUC_CONST;
#define GAMES_RETRO_RUNNER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_RETRO_RUNNER, GamesRetroRunnerPrivate))
enum  {
	GAMES_RETRO_RUNNER_DUMMY_PROPERTY,
	GAMES_RETRO_RUNNER_CAN_FULLSCREEN,
	GAMES_RETRO_RUNNER_CAN_QUIT_SAFELY,
	GAMES_RETRO_RUNNER_CAN_RESUME,
	GAMES_RETRO_RUNNER_MEDIA_SET
};
static void games_retro_runner_set_running (GamesRetroRunner* self, gboolean value);
static void games_retro_runner_save (GamesRetroRunner* self, GError** error);
GamesRetroRunner* games_retro_runner_new (GamesRetroCoreSource* core_source, const gchar* uri, GamesUid* uid, GamesTitle* game_title);
GamesRetroRunner* games_retro_runner_construct (GType object_type, GamesRetroCoreSource* core_source, const gchar* uri, GamesUid* uid, GamesTitle* game_title);
GType games_media_get_type (void) G_GNUC_CONST;
GamesMedia* games_media_new (const gchar* uri, GamesTitle* title);
GamesMedia* games_media_construct (GType object_type, const gchar* uri, GamesTitle* title);
GamesMediaSet* games_media_set_new (GamesMedia** medias, int medias_length1, GIcon* icon);
GamesMediaSet* games_media_set_construct (GType object_type, GamesMedia** medias, int medias_length1, GIcon* icon);
GamesRetroRunner* games_retro_runner_new_for_media_set_and_input_capabilities (GamesRetroCoreSource* core_source, GamesMediaSet* media_set, GamesUid* uid, GamesInputCapabilities* input_capabilities, GamesTitle* game_title);
GamesRetroRunner* games_retro_runner_construct_for_media_set_and_input_capabilities (GType object_type, GamesRetroCoreSource* core_source, GamesMediaSet* media_set, GamesUid* uid, GamesInputCapabilities* input_capabilities, GamesTitle* game_title);
static void games_retro_runner_on_media_number_changed (GamesRetroRunner* self);
static void _games_retro_runner_on_media_number_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
GamesRetroRunner* games_retro_runner_new_for_core_descriptor (RetroCoreDescriptor* core_descriptor, GamesUid* uid, GamesTitle* game_title);
GamesRetroRunner* games_retro_runner_construct_for_core_descriptor (GType object_type, RetroCoreDescriptor* core_descriptor, GamesUid* uid, GamesTitle* game_title);
static gboolean games_retro_runner_real_check_is_valid (GamesRunner* base, gchar* * error_message, GError** error);
static void games_retro_runner_load_media_data (GamesRetroRunner* self, GError** error);
static void games_retro_runner_init (GamesRetroRunner* self, GError** error);
GQuark games_retro_error_quark (void);
static gchar* games_retro_runner_get_unsupported_system_message (GamesRetroRunner* self);
static GtkWidget* games_retro_runner_real_get_display (GamesRunner* base);
static void games_retro_runner_real_start (GamesRunner* base, GError** error);
static void games_retro_runner_load_ram (GamesRetroRunner* self, GError** error);
static void games_retro_runner_real_resume (GamesRunner* base, GError** error);
static void games_retro_runner_load_snapshot (GamesRetroRunner* self, GError** error);
static void games_retro_runner_on_video_filter_changed (GamesRetroRunner* self);
static void _games_retro_runner_on_video_filter_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
gboolean games_input_capabilities_get_allow_analog_gamepads (GamesInputCapabilities* self, GError** error);
GamesRetroInputManager* games_retro_input_manager_new (GtkWidget* widget, gboolean present_analog_sticks);
GamesRetroInputManager* games_retro_input_manager_construct (GType object_type, GtkWidget* widget, gboolean present_analog_sticks);
static void games_retro_runner_prepare_core (GamesRetroRunner* self, GError** error);
GamesMediaSet* games_runner_get_media_set (GamesRunner* self);
gint games_media_set_get_size (GamesMediaSet* self);
gint games_media_set_get_selected_media_number (GamesMediaSet* self);
GamesMedia* games_media_set_get_selected_media (GamesMediaSet* self, guint index, GError** error);
const gchar* games_media_get_uri (GamesMedia* self);
static gboolean games_retro_runner_try_load_game (GamesRetroRunner* self, RetroCore* core, const gchar* uri);
static gboolean games_retro_runner_on_shutdown (GamesRetroRunner* self);
static gboolean _games_retro_runner_on_shutdown_retro_core_shutdown (RetroCore* _sender, gpointer self);
static void games_retro_runner_load_screenshot (GamesRetroRunner* self, GError** error);
static void games_retro_runner_deinit (GamesRetroRunner* self);
gchar* games_retro_core_source_get_module_path (GamesRetroCoreSource* self, GError** error);
gchar* games_application_get_platforms_dir (void);
gchar* games_retro_core_source_get_platform (GamesRetroCoreSource* self);
static void games_retro_runner_real_pause (GamesRunner* base);
static void games_retro_runner_real_stop (GamesRunner* base);
void games_runner_pause (GamesRunner* self);
static void games_retro_runner_save_media_data (GamesRetroRunner* self, GError** error);
static void games_retro_runner_save_ram (GamesRetroRunner* self, GError** error);
static void games_retro_runner_save_snapshot (GamesRetroRunner* self, GError** error);
static void games_retro_runner_save_screenshot (GamesRetroRunner* self, GError** error);
static gchar* games_retro_runner_get_save_path (GamesRetroRunner* self, GError** error);
gchar* games_application_get_saves_dir (void);
gchar* games_uid_get_uid (GamesUid* self, GError** error);
static void games_retro_runner_try_make_dir (const gchar* path);
static gchar* games_retro_runner_get_snapshot_path (GamesRetroRunner* self, GError** error);
gchar* games_application_get_snapshots_dir (void);
gchar* games_application_get_medias_dir (void);
static gchar* games_retro_runner_get_medias_path (GamesRetroRunner* self, GError** error);
void games_media_set_set_selected_media_number (GamesMediaSet* self, gint value);
static gchar* games_retro_runner_get_screenshot_path (GamesRetroRunner* self, GError** error);
gchar* games_retro_platform_get_platform_name (const gchar* platform);
gchar* games_title_get_title (GamesTitle* self, GError** error);
void games_runner_stop (GamesRunner* self);
static gboolean games_retro_runner_get_running (GamesRetroRunner* self);
static GObject * games_retro_runner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static void games_retro_runner_finalize (GObject * obj);
gboolean games_runner_get_can_fullscreen (GamesRunner* self);
gboolean games_runner_get_can_quit_safely (GamesRunner* self);
gboolean games_runner_get_can_resume (GamesRunner* self);
static void _vala_games_retro_runner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_games_retro_runner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesRetroRunner* games_retro_runner_construct (GType object_type, GamesRetroCoreSource* core_source, const gchar* uri, GamesUid* uid, GamesTitle* game_title) {
	GamesRetroRunner * self = NULL;
	GamesMedia* game_media;
	const gchar* _tmp0_;
	GamesMedia* _tmp1_;
	GamesMedia* _tmp2_;
	GamesMedia** _tmp3_;
	GamesMedia** _tmp4_;
	gint _tmp4__length1;
	GamesMediaSet* _tmp5_;
	GamesUid* _tmp6_;
	GamesUid* _tmp7_;
	GamesRetroCoreSource* _tmp8_;
	GamesRetroCoreSource* _tmp9_;
	GamesTitle* _tmp10_;
	GamesTitle* _tmp11_;
	g_return_val_if_fail (core_source != NULL, NULL);
	g_return_val_if_fail (uri != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (game_title != NULL, NULL);
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	self->priv->is_initialized = FALSE;
	self->priv->is_ready = FALSE;
	self->priv->should_save = FALSE;
	_g_object_unref0 (self->priv->core_descriptor);
	self->priv->core_descriptor = NULL;
	_tmp0_ = uri;
	_tmp1_ = games_media_new (_tmp0_, NULL);
	game_media = _tmp1_;
	_tmp2_ = _g_object_ref0 (game_media);
	_tmp3_ = g_new0 (GamesMedia*, 1 + 1);
	_tmp3_[0] = _tmp2_;
	_tmp4_ = _tmp3_;
	_tmp4__length1 = 1;
	_tmp5_ = games_media_set_new (_tmp4_, 1, NULL);
	_g_object_unref0 (self->priv->_media_set);
	self->priv->_media_set = _tmp5_;
	_tmp4_ = (_vala_array_free (_tmp4_, _tmp4__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp6_ = uid;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->uid);
	self->priv->uid = _tmp7_;
	_tmp8_ = core_source;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->core_source);
	self->priv->core_source = _tmp9_;
	_g_object_unref0 (self->priv->input_capabilities);
	self->priv->input_capabilities = NULL;
	_tmp10_ = game_title;
	_tmp11_ = _g_object_ref0 (_tmp10_);
	_g_object_unref0 (self->priv->game_title);
	self->priv->game_title = _tmp11_;
	_g_object_unref0 (game_media);
	return self;
}


GamesRetroRunner* games_retro_runner_new (GamesRetroCoreSource* core_source, const gchar* uri, GamesUid* uid, GamesTitle* game_title) {
	return games_retro_runner_construct (GAMES_TYPE_RETRO_RUNNER, core_source, uri, uid, game_title);
}


static void _games_retro_runner_on_media_number_changed_g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	games_retro_runner_on_media_number_changed ((GamesRetroRunner*) self);
}


GamesRetroRunner* games_retro_runner_construct_for_media_set_and_input_capabilities (GType object_type, GamesRetroCoreSource* core_source, GamesMediaSet* media_set, GamesUid* uid, GamesInputCapabilities* input_capabilities, GamesTitle* game_title) {
	GamesRetroRunner * self = NULL;
	GamesRetroCoreSource* _tmp0_;
	GamesRetroCoreSource* _tmp1_;
	GamesMediaSet* _tmp2_;
	GamesMediaSet* _tmp3_;
	GamesUid* _tmp4_;
	GamesUid* _tmp5_;
	GamesInputCapabilities* _tmp6_;
	GamesInputCapabilities* _tmp7_;
	GamesTitle* _tmp8_;
	GamesTitle* _tmp9_;
	GamesMediaSet* _tmp10_;
	g_return_val_if_fail (core_source != NULL, NULL);
	g_return_val_if_fail (media_set != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (input_capabilities != NULL, NULL);
	g_return_val_if_fail (game_title != NULL, NULL);
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	self->priv->is_initialized = FALSE;
	self->priv->is_ready = FALSE;
	self->priv->should_save = FALSE;
	_g_object_unref0 (self->priv->core_descriptor);
	self->priv->core_descriptor = NULL;
	_tmp0_ = core_source;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->core_source);
	self->priv->core_source = _tmp1_;
	_tmp2_ = media_set;
	_tmp3_ = _g_object_ref0 (_tmp2_);
	_g_object_unref0 (self->priv->_media_set);
	self->priv->_media_set = _tmp3_;
	_tmp4_ = uid;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (self->priv->uid);
	self->priv->uid = _tmp5_;
	_tmp6_ = input_capabilities;
	_tmp7_ = _g_object_ref0 (_tmp6_);
	_g_object_unref0 (self->priv->input_capabilities);
	self->priv->input_capabilities = _tmp7_;
	_tmp8_ = game_title;
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (self->priv->game_title);
	self->priv->game_title = _tmp9_;
	_tmp10_ = self->priv->_media_set;
	g_signal_connect_object ((GObject*) _tmp10_, "notify::selected-media-number", (GCallback) _games_retro_runner_on_media_number_changed_g_object_notify, self, 0);
	return self;
}


GamesRetroRunner* games_retro_runner_new_for_media_set_and_input_capabilities (GamesRetroCoreSource* core_source, GamesMediaSet* media_set, GamesUid* uid, GamesInputCapabilities* input_capabilities, GamesTitle* game_title) {
	return games_retro_runner_construct_for_media_set_and_input_capabilities (GAMES_TYPE_RETRO_RUNNER, core_source, media_set, uid, input_capabilities, game_title);
}


GamesRetroRunner* games_retro_runner_construct_for_core_descriptor (GType object_type, RetroCoreDescriptor* core_descriptor, GamesUid* uid, GamesTitle* game_title) {
	GamesRetroRunner * self = NULL;
	RetroCoreDescriptor* _tmp0_;
	RetroCoreDescriptor* _tmp1_;
	GamesMedia** _tmp2_;
	GamesMedia** _tmp3_;
	gint _tmp3__length1;
	GamesMediaSet* _tmp4_;
	GamesUid* _tmp5_;
	GamesUid* _tmp6_;
	GamesTitle* _tmp7_;
	GamesTitle* _tmp8_;
	g_return_val_if_fail (core_descriptor != NULL, NULL);
	g_return_val_if_fail (uid != NULL, NULL);
	g_return_val_if_fail (game_title != NULL, NULL);
	self = (GamesRetroRunner*) g_object_new (object_type, NULL);
	self->priv->is_initialized = FALSE;
	self->priv->is_ready = FALSE;
	self->priv->should_save = FALSE;
	_tmp0_ = core_descriptor;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->core_descriptor);
	self->priv->core_descriptor = _tmp1_;
	_g_object_unref0 (self->priv->core_source);
	self->priv->core_source = NULL;
	_tmp2_ = g_new0 (GamesMedia*, 0 + 1);
	_tmp3_ = _tmp2_;
	_tmp3__length1 = 0;
	_tmp4_ = games_media_set_new (_tmp3_, 0, NULL);
	_g_object_unref0 (self->priv->_media_set);
	self->priv->_media_set = _tmp4_;
	_tmp3_ = (_vala_array_free (_tmp3_, _tmp3__length1, (GDestroyNotify) g_object_unref), NULL);
	_tmp5_ = uid;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->uid);
	self->priv->uid = _tmp6_;
	_g_object_unref0 (self->priv->input_capabilities);
	self->priv->input_capabilities = NULL;
	_tmp7_ = game_title;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->priv->game_title);
	self->priv->game_title = _tmp8_;
	return self;
}


GamesRetroRunner* games_retro_runner_new_for_core_descriptor (RetroCoreDescriptor* core_descriptor, GamesUid* uid, GamesTitle* game_title) {
	return games_retro_runner_construct_for_core_descriptor (GAMES_TYPE_RETRO_RUNNER, core_descriptor, uid, game_title);
}


static gboolean games_retro_runner_real_check_is_valid (GamesRunner* base, gchar* * error_message, GError** error) {
	GamesRetroRunner * self;
	gchar* _vala_error_message = NULL;
	gboolean result = FALSE;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	{
		games_retro_runner_load_media_data (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch16_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch16_games_retro_error_firmware_not_found;
			}
			goto __finally16;
		}
		games_retro_runner_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (g_error_matches (_inner_error_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_MODULE_NOT_FOUND)) {
				goto __catch16_games_retro_error_module_not_found;
			}
			if (g_error_matches (_inner_error_, GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_FIRMWARE_NOT_FOUND)) {
				goto __catch16_games_retro_error_firmware_not_found;
			}
			goto __finally16;
		}
	}
	goto __finally16;
	__catch16_games_retro_error_module_not_found:
	{
		GError* e = NULL;
		GError* _tmp0_;
		const gchar* _tmp1_;
		gchar* _tmp2_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp0_ = e;
		_tmp1_ = _tmp0_->message;
		g_debug ("retro-runner.vala:141: %s", _tmp1_);
		_tmp2_ = games_retro_runner_get_unsupported_system_message (self);
		_g_free0 (_vala_error_message);
		_vala_error_message = _tmp2_;
		result = FALSE;
		_g_error_free0 (e);
		if (error_message) {
			*error_message = _vala_error_message;
		} else {
			_g_free0 (_vala_error_message);
		}
		return result;
	}
	goto __finally16;
	__catch16_games_retro_error_firmware_not_found:
	{
		GError* e = NULL;
		GError* _tmp3_;
		const gchar* _tmp4_;
		gchar* _tmp5_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_debug ("retro-runner.vala:147: %s", _tmp4_);
		_tmp5_ = games_retro_runner_get_unsupported_system_message (self);
		_g_free0 (_vala_error_message);
		_vala_error_message = _tmp5_;
		result = FALSE;
		_g_error_free0 (e);
		if (error_message) {
			*error_message = _vala_error_message;
		} else {
			_g_free0 (_vala_error_message);
		}
		return result;
	}
	__finally16:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp6_ = FALSE;
		g_propagate_error (error, _inner_error_);
		return _tmp6_;
	}
	result = TRUE;
	if (error_message) {
		*error_message = _vala_error_message;
	} else {
		_g_free0 (_vala_error_message);
	}
	return result;
}


static GtkWidget* games_retro_runner_real_get_display (GamesRunner* base) {
	GamesRetroRunner * self;
	GtkWidget* result = NULL;
	GtkEventBox* _tmp0_;
	GtkWidget* _tmp1_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->widget;
	_tmp1_ = _g_object_ref0 ((GtkWidget*) _tmp0_);
	result = _tmp1_;
	return result;
}


static void games_retro_runner_real_start (GamesRunner* base, GError** error) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	RetroMainLoop* _tmp1_;
	gboolean _tmp2_;
	RetroCore* _tmp3_;
	RetroMainLoop* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	games_retro_runner_load_media_data (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		games_retro_runner_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp1_ = self->priv->loop;
	retro_main_loop_stop (_tmp1_);
	_tmp2_ = self->priv->is_ready;
	if (!_tmp2_) {
		games_retro_runner_load_ram (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		self->priv->is_ready = TRUE;
	}
	_tmp3_ = self->priv->core;
	retro_core_reset (_tmp3_);
	_tmp4_ = self->priv->loop;
	retro_main_loop_start (_tmp4_);
	games_retro_runner_set_running (self, TRUE);
}


static void games_retro_runner_real_resume (GamesRunner* base, GError** error) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	RetroMainLoop* _tmp1_;
	gboolean _tmp2_;
	RetroMainLoop* _tmp4_;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		games_retro_runner_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp1_ = self->priv->loop;
	retro_main_loop_stop (_tmp1_);
	_tmp2_ = self->priv->is_ready;
	if (!_tmp2_) {
		RetroCore* _tmp3_;
		games_retro_runner_load_ram (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp3_ = self->priv->core;
		retro_core_reset (_tmp3_);
		games_retro_runner_load_snapshot (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		self->priv->is_ready = TRUE;
	}
	_tmp4_ = self->priv->loop;
	retro_main_loop_start (_tmp4_);
	games_retro_runner_set_running (self, TRUE);
}


static void _games_retro_runner_on_video_filter_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	games_retro_runner_on_video_filter_changed ((GamesRetroRunner*) self);
}


static gboolean _games_retro_runner_on_shutdown_retro_core_shutdown (RetroCore* _sender, gpointer self) {
	gboolean result;
	result = games_retro_runner_on_shutdown ((GamesRetroRunner*) self);
	return result;
}


static void games_retro_runner_init (GamesRetroRunner* self, GError** error) {
	gboolean _tmp0_;
	RetroCairoDisplay* _tmp1_;
	GSettings* _tmp2_;
	GtkEventBox* _tmp3_;
	GtkEventBox* _tmp4_;
	RetroCairoDisplay* _tmp5_;
	RetroCairoDisplay* _tmp6_;
	gboolean _tmp7_ = FALSE;
	GamesInputCapabilities* _tmp8_;
	gboolean present_analog_sticks;
	GtkEventBox* _tmp12_;
	gboolean _tmp13_;
	GamesRetroInputManager* _tmp14_;
	GamesMediaSet* _tmp15_;
	GamesMediaSet* _tmp16_;
	gint _tmp17_;
	RetroCore* _tmp36_;
	RetroCore* _tmp37_;
	RetroCore* _tmp38_;
	RetroMainLoop* _tmp39_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_initialized;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = retro_cairo_display_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->priv->video);
	self->priv->video = _tmp1_;
	_tmp2_ = self->priv->settings;
	g_signal_connect_object (_tmp2_, "changed::video-filter", (GCallback) _games_retro_runner_on_video_filter_changed_g_settings_changed, self, 0);
	games_retro_runner_on_video_filter_changed (self);
	_tmp3_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp3_);
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = _tmp3_;
	_tmp4_ = self->priv->widget;
	_tmp5_ = self->priv->video;
	gtk_container_add ((GtkContainer*) _tmp4_, (GtkWidget*) _tmp5_);
	_tmp6_ = self->priv->video;
	gtk_widget_set_visible ((GtkWidget*) _tmp6_, TRUE);
	_tmp8_ = self->priv->input_capabilities;
	if (_tmp8_ == NULL) {
		_tmp7_ = TRUE;
	} else {
		gboolean _tmp9_;
		GamesInputCapabilities* _tmp10_;
		gboolean _tmp11_;
		_tmp10_ = self->priv->input_capabilities;
		_tmp11_ = games_input_capabilities_get_allow_analog_gamepads (_tmp10_, &_inner_error_);
		_tmp9_ = _tmp11_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp7_ = _tmp9_;
	}
	present_analog_sticks = _tmp7_;
	_tmp12_ = self->priv->widget;
	_tmp13_ = present_analog_sticks;
	_tmp14_ = games_retro_input_manager_new ((GtkWidget*) _tmp12_, _tmp13_);
	_g_object_unref0 (self->priv->input_manager);
	self->priv->input_manager = _tmp14_;
	games_retro_runner_prepare_core (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp15_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp16_ = _tmp15_;
	_tmp17_ = games_media_set_get_size (_tmp16_);
	if (_tmp17_ == 0) {
		RetroCore* _tmp18_;
		_tmp18_ = self->priv->core;
		retro_core_prepare (_tmp18_);
	} else {
		gint media_number;
		GamesMediaSet* _tmp19_;
		GamesMediaSet* _tmp20_;
		gint _tmp21_;
		gint _tmp22_;
		GamesMedia* media;
		GamesMediaSet* _tmp23_;
		GamesMediaSet* _tmp24_;
		gint _tmp25_;
		GamesMedia* _tmp26_;
		gchar* uri;
		GamesMedia* _tmp27_;
		const gchar* _tmp28_;
		const gchar* _tmp29_;
		gchar* _tmp30_;
		RetroCore* _tmp31_;
		const gchar* _tmp32_;
		gboolean _tmp33_;
		_tmp19_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp20_ = _tmp19_;
		_tmp21_ = games_media_set_get_selected_media_number (_tmp20_);
		_tmp22_ = _tmp21_;
		media_number = _tmp22_;
		_tmp23_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp24_ = _tmp23_;
		_tmp25_ = media_number;
		_tmp26_ = games_media_set_get_selected_media (_tmp24_, (guint) _tmp25_, &_inner_error_);
		media = _tmp26_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_tmp27_ = media;
		_tmp28_ = games_media_get_uri (_tmp27_);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_strdup (_tmp29_);
		uri = _tmp30_;
		_tmp31_ = self->priv->core;
		_tmp32_ = uri;
		_tmp33_ = games_retro_runner_try_load_game (self, _tmp31_, _tmp32_);
		if (!_tmp33_) {
			const gchar* _tmp34_;
			GError* _tmp35_;
			_tmp34_ = uri;
			_tmp35_ = g_error_new (GAMES_RETRO_ERROR, GAMES_RETRO_ERROR_INVALID_GAME_FILE, _ ("Invalid game file: “%s”."), _tmp34_);
			_inner_error_ = _tmp35_;
			g_propagate_error (error, _inner_error_);
			_g_free0 (uri);
			_g_object_unref0 (media);
			return;
		}
		_g_free0 (uri);
		_g_object_unref0 (media);
	}
	_tmp36_ = self->priv->core;
	g_signal_connect_object (_tmp36_, "shutdown", (GCallback) _games_retro_runner_on_shutdown_retro_core_shutdown, self, 0);
	_tmp37_ = self->priv->core;
	retro_core_run (_tmp37_);
	_tmp38_ = self->priv->core;
	_tmp39_ = retro_main_loop_new (_tmp38_);
	_g_object_unref0 (self->priv->loop);
	self->priv->loop = _tmp39_;
	games_retro_runner_set_running (self, FALSE);
	games_retro_runner_load_screenshot (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	self->priv->is_initialized = TRUE;
}


static void games_retro_runner_deinit (GamesRetroRunner* self) {
	gboolean _tmp0_;
	GSettings* _tmp1_;
	guint _tmp2_;
	GQuark _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->settings;
	g_signal_parse_name ("changed::video-filter", g_settings_get_type (), &_tmp2_, &_tmp3_, TRUE);
	g_signal_handlers_disconnect_matched (_tmp1_, G_SIGNAL_MATCH_ID | G_SIGNAL_MATCH_DETAIL | G_SIGNAL_MATCH_FUNC | G_SIGNAL_MATCH_DATA, _tmp2_, _tmp3_, NULL, (GCallback) _games_retro_runner_on_video_filter_changed_g_settings_changed, self);
	_g_object_unref0 (self->priv->core);
	self->priv->core = NULL;
	_g_object_unref0 (self->priv->video);
	self->priv->video = NULL;
	_g_object_unref0 (self->priv->audio);
	self->priv->audio = NULL;
	_g_object_unref0 (self->priv->widget);
	self->priv->widget = NULL;
	_g_object_unref0 (self->priv->input_manager);
	self->priv->input_manager = NULL;
	_g_object_unref0 (self->priv->loop);
	self->priv->loop = NULL;
	self->priv->_running = FALSE;
	self->priv->is_initialized = FALSE;
	self->priv->is_ready = FALSE;
	self->priv->should_save = FALSE;
}


static void games_retro_runner_on_video_filter_changed (GamesRetroRunner* self) {
	gchar* filter_name;
	GSettings* _tmp0_;
	gchar* _tmp1_;
	RetroVideoFilter filter;
	RetroVideoFilter _tmp2_;
	RetroCairoDisplay* _tmp3_;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_string (_tmp0_, "video-filter");
	filter_name = _tmp1_;
	_tmp2_ = retro_video_filter_from_string (filter_name);
	filter = _tmp2_;
	_tmp3_ = self->priv->video;
	retro_cairo_display_set_filter (_tmp3_, filter);
	_g_free0 (filter_name);
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static void games_retro_runner_prepare_core (GamesRetroRunner* self, GError** error) {
	gchar* module_path = NULL;
	RetroCoreDescriptor* _tmp0_;
	const gchar* _tmp9_;
	RetroCore* _tmp10_;
	RetroPaPlayer* _tmp11_;
	GamesRetroCoreSource* _tmp12_;
	RetroCairoDisplay* _tmp23_;
	RetroCore* _tmp24_;
	RetroPaPlayer* _tmp25_;
	RetroCore* _tmp26_;
	RetroCore* _tmp27_;
	GamesRetroInputManager* _tmp28_;
	RetroCore* _tmp29_;
	GamesRetroInputManager* _tmp30_;
	RetroCore* _tmp31_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core_descriptor;
	if (_tmp0_ != NULL) {
		GFile* module_file;
		RetroCoreDescriptor* _tmp1_;
		GFile* _tmp2_;
		GFile* _tmp3_;
		gchar* _tmp4_;
		_tmp1_ = self->priv->core_descriptor;
		_tmp2_ = retro_core_descriptor_get_module_file (_tmp1_, &_inner_error_);
		module_file = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (module_path);
			return;
		}
		_tmp3_ = module_file;
		_tmp4_ = g_file_get_path (_tmp3_);
		_g_free0 (module_path);
		module_path = _tmp4_;
		_g_object_unref0 (module_file);
	} else {
		gchar* _tmp5_;
		GamesRetroCoreSource* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		_tmp6_ = self->priv->core_source;
		_tmp7_ = games_retro_core_source_get_module_path (_tmp6_, &_inner_error_);
		_tmp5_ = _tmp7_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (module_path);
			return;
		}
		_tmp8_ = _tmp5_;
		_tmp5_ = NULL;
		_g_free0 (module_path);
		module_path = _tmp8_;
		_g_free0 (_tmp5_);
	}
	_tmp9_ = module_path;
	_tmp10_ = retro_core_new (_tmp9_);
	_g_object_unref0 (self->priv->core);
	self->priv->core = _tmp10_;
	_tmp11_ = retro_pa_player_new ();
	_g_object_unref0 (self->priv->audio);
	self->priv->audio = _tmp11_;
	_tmp12_ = self->priv->core_source;
	if (_tmp12_ != NULL) {
		gchar* platforms_dir;
		gchar* _tmp13_;
		gchar* platform;
		GamesRetroCoreSource* _tmp14_;
		gchar* _tmp15_;
		RetroCore* _tmp16_;
		const gchar* _tmp17_;
		const gchar* _tmp18_;
		const gchar* _tmp19_;
		const gchar* _tmp20_;
		gchar* _tmp21_;
		gchar* _tmp22_;
		_tmp13_ = games_application_get_platforms_dir ();
		platforms_dir = _tmp13_;
		_tmp14_ = self->priv->core_source;
		_tmp15_ = games_retro_core_source_get_platform (_tmp14_);
		platform = _tmp15_;
		_tmp16_ = self->priv->core;
		_tmp17_ = platforms_dir;
		_tmp18_ = string_to_string (_tmp17_);
		_tmp19_ = platform;
		_tmp20_ = string_to_string (_tmp19_);
		_tmp21_ = g_strconcat (_tmp18_, "/", _tmp20_, "/system", NULL);
		_tmp22_ = _tmp21_;
		retro_core_set_system_directory (_tmp16_, _tmp22_);
		_g_free0 (_tmp22_);
		_g_free0 (platform);
		_g_free0 (platforms_dir);
	}
	_tmp23_ = self->priv->video;
	_tmp24_ = self->priv->core;
	retro_cairo_display_set_core (_tmp23_, _tmp24_);
	_tmp25_ = self->priv->audio;
	_tmp26_ = self->priv->core;
	retro_pa_player_set_core (_tmp25_, _tmp26_);
	_tmp27_ = self->priv->core;
	_tmp28_ = self->priv->input_manager;
	retro_core_set_input_interface (_tmp27_, (RetroInput*) _tmp28_);
	_tmp29_ = self->priv->core;
	_tmp30_ = self->priv->input_manager;
	retro_core_set_rumble_interface (_tmp29_, (RetroRumble*) _tmp30_);
	_tmp31_ = self->priv->core;
	g_signal_emit_by_name (_tmp31_, "init");
	_g_free0 (module_path);
}


static gboolean games_retro_runner_try_load_game (GamesRetroRunner* self, RetroCore* core, const gchar* uri) {
	gboolean result = FALSE;
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	gchar* path;
	GFile* _tmp2_;
	gchar* _tmp3_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (core != NULL, FALSE);
	g_return_val_if_fail (uri != NULL, FALSE);
	_tmp0_ = uri;
	_tmp1_ = g_file_new_for_uri (_tmp0_);
	file = _tmp1_;
	_tmp2_ = file;
	_tmp3_ = g_file_get_path (_tmp2_);
	path = _tmp3_;
	{
		gboolean fullpath;
		RetroCore* _tmp4_;
		RetroSystemInfo _tmp5_ = {0};
		RetroSystemInfo _tmp6_;
		gboolean _tmp7_;
		RetroGameInfo _tmp8_ = {0};
		gboolean _tmp9_;
		RetroCore* _tmp13_;
		gboolean _tmp14_;
		_tmp4_ = core;
		retro_core_get_system_info (_tmp4_, &_tmp5_);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_.need_fullpath;
		fullpath = _tmp7_;
		_tmp9_ = fullpath;
		if (_tmp9_) {
			const gchar* _tmp10_;
			_tmp10_ = path;
			retro_game_info_destroy (&_tmp8_);
			retro_game_info_init (&_tmp8_, _tmp10_);
		} else {
			const gchar* _tmp11_;
			_tmp11_ = path;
			retro_game_info_destroy (&_tmp8_);
			retro_game_info_init_with_data (&_tmp8_, _tmp11_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				gboolean _tmp12_ = FALSE;
				retro_game_info_destroy (&_tmp8_);
				if (_inner_error_->domain == G_FILE_ERROR) {
					goto __catch17_g_file_error;
				}
				if (_inner_error_->domain == RETRO_CB_ERROR) {
					goto __catch17_retro_cb_error;
				}
				retro_game_info_destroy (&_tmp8_);
				_g_free0 (path);
				_g_object_unref0 (file);
				g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
				g_clear_error (&_inner_error_);
				return _tmp12_;
			}
		}
		_tmp13_ = core;
		_tmp14_ = retro_core_load_game (_tmp13_, &_tmp8_);
		if (_tmp14_) {
			RetroCore* _tmp15_;
			RetroDiskControl* _tmp16_;
			RetroDiskControl* _tmp17_;
			_tmp15_ = core;
			_tmp16_ = retro_core_get_disk_control_interface (_tmp15_);
			_tmp17_ = _tmp16_;
			if (_tmp17_ != NULL) {
				RetroDiskControl* disk;
				RetroCore* _tmp18_;
				RetroDiskControl* _tmp19_;
				RetroDiskControl* _tmp20_;
				RetroDiskControl* _tmp21_;
				RetroDiskControl* _tmp22_;
				guint _tmp30_;
				RetroDiskControl* _tmp31_;
				guint _tmp32_;
				guint index;
				RetroGameInfo _tmp34_ = {0};
				gboolean _tmp35_;
				RetroDiskControl* _tmp39_;
				guint _tmp40_;
				RetroDiskControl* _tmp42_;
				_tmp18_ = core;
				_tmp19_ = retro_core_get_disk_control_interface (_tmp18_);
				_tmp20_ = _tmp19_;
				_tmp21_ = _g_object_ref0 (_tmp20_);
				disk = _tmp21_;
				_tmp22_ = disk;
				retro_disk_control_set_eject_state (_tmp22_, TRUE, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp23_ = FALSE;
					_g_object_unref0 (disk);
					retro_game_info_destroy (&_tmp8_);
					if (_inner_error_->domain == G_FILE_ERROR) {
						goto __catch17_g_file_error;
					}
					if (_inner_error_->domain == RETRO_CB_ERROR) {
						goto __catch17_retro_cb_error;
					}
					_g_object_unref0 (disk);
					retro_game_info_destroy (&_tmp8_);
					_g_free0 (path);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp23_;
				}
				while (TRUE) {
					guint _tmp24_;
					RetroDiskControl* _tmp25_;
					guint _tmp26_;
					RetroDiskControl* _tmp28_;
					_tmp25_ = disk;
					_tmp26_ = retro_disk_control_get_num_images (_tmp25_, &_inner_error_);
					_tmp24_ = _tmp26_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gboolean _tmp27_ = FALSE;
						_g_object_unref0 (disk);
						retro_game_info_destroy (&_tmp8_);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch17_g_file_error;
						}
						if (_inner_error_->domain == RETRO_CB_ERROR) {
							goto __catch17_retro_cb_error;
						}
						_g_object_unref0 (disk);
						retro_game_info_destroy (&_tmp8_);
						_g_free0 (path);
						_g_object_unref0 (file);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp27_;
					}
					if (!(_tmp24_ < ((guint) 1))) {
						break;
					}
					_tmp28_ = disk;
					retro_disk_control_add_image_index (_tmp28_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gboolean _tmp29_ = FALSE;
						_g_object_unref0 (disk);
						retro_game_info_destroy (&_tmp8_);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch17_g_file_error;
						}
						if (_inner_error_->domain == RETRO_CB_ERROR) {
							goto __catch17_retro_cb_error;
						}
						_g_object_unref0 (disk);
						retro_game_info_destroy (&_tmp8_);
						_g_free0 (path);
						_g_object_unref0 (file);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp29_;
					}
				}
				_tmp31_ = disk;
				_tmp32_ = retro_disk_control_get_num_images (_tmp31_, &_inner_error_);
				_tmp30_ = _tmp32_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp33_ = FALSE;
					_g_object_unref0 (disk);
					retro_game_info_destroy (&_tmp8_);
					if (_inner_error_->domain == G_FILE_ERROR) {
						goto __catch17_g_file_error;
					}
					if (_inner_error_->domain == RETRO_CB_ERROR) {
						goto __catch17_retro_cb_error;
					}
					_g_object_unref0 (disk);
					retro_game_info_destroy (&_tmp8_);
					_g_free0 (path);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp33_;
				}
				index = _tmp30_ - 1;
				_tmp35_ = fullpath;
				if (_tmp35_) {
					const gchar* _tmp36_;
					_tmp36_ = path;
					retro_game_info_destroy (&_tmp34_);
					retro_game_info_init (&_tmp34_, _tmp36_);
				} else {
					const gchar* _tmp37_;
					_tmp37_ = path;
					retro_game_info_destroy (&_tmp34_);
					retro_game_info_init_with_data (&_tmp34_, _tmp37_, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						gboolean _tmp38_ = FALSE;
						retro_game_info_destroy (&_tmp34_);
						_g_object_unref0 (disk);
						retro_game_info_destroy (&_tmp8_);
						if (_inner_error_->domain == G_FILE_ERROR) {
							goto __catch17_g_file_error;
						}
						if (_inner_error_->domain == RETRO_CB_ERROR) {
							goto __catch17_retro_cb_error;
						}
						retro_game_info_destroy (&_tmp34_);
						_g_object_unref0 (disk);
						retro_game_info_destroy (&_tmp8_);
						_g_free0 (path);
						_g_object_unref0 (file);
						g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return _tmp38_;
					}
				}
				_tmp39_ = disk;
				_tmp40_ = index;
				retro_disk_control_replace_image_index (_tmp39_, _tmp40_, &_tmp34_, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp41_ = FALSE;
					retro_game_info_destroy (&_tmp34_);
					_g_object_unref0 (disk);
					retro_game_info_destroy (&_tmp8_);
					if (_inner_error_->domain == G_FILE_ERROR) {
						goto __catch17_g_file_error;
					}
					if (_inner_error_->domain == RETRO_CB_ERROR) {
						goto __catch17_retro_cb_error;
					}
					retro_game_info_destroy (&_tmp34_);
					_g_object_unref0 (disk);
					retro_game_info_destroy (&_tmp8_);
					_g_free0 (path);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp41_;
				}
				_tmp42_ = disk;
				retro_disk_control_set_eject_state (_tmp42_, FALSE, &_inner_error_);
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					gboolean _tmp43_ = FALSE;
					retro_game_info_destroy (&_tmp34_);
					_g_object_unref0 (disk);
					retro_game_info_destroy (&_tmp8_);
					if (_inner_error_->domain == G_FILE_ERROR) {
						goto __catch17_g_file_error;
					}
					if (_inner_error_->domain == RETRO_CB_ERROR) {
						goto __catch17_retro_cb_error;
					}
					retro_game_info_destroy (&_tmp34_);
					_g_object_unref0 (disk);
					retro_game_info_destroy (&_tmp8_);
					_g_free0 (path);
					_g_object_unref0 (file);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return _tmp43_;
				}
				retro_game_info_destroy (&_tmp34_);
				_g_object_unref0 (disk);
			}
			result = TRUE;
			retro_game_info_destroy (&_tmp8_);
			_g_free0 (path);
			_g_object_unref0 (file);
			return result;
		}
		retro_game_info_destroy (&_tmp8_);
	}
	goto __finally17;
	__catch17_g_file_error:
	{
		GError* e = NULL;
		FILE* _tmp44_;
		GError* _tmp45_;
		const gchar* _tmp46_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp44_ = stderr;
		_tmp45_ = e;
		_tmp46_ = _tmp45_->message;
		fprintf (_tmp44_, "Error: %s\n", _tmp46_);
		_g_error_free0 (e);
	}
	goto __finally17;
	__catch17_retro_cb_error:
	{
		GError* e = NULL;
		FILE* _tmp47_;
		GError* _tmp48_;
		const gchar* _tmp49_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp47_ = stderr;
		_tmp48_ = e;
		_tmp49_ = _tmp48_->message;
		fprintf (_tmp47_, "Error: %s\n", _tmp49_);
		_g_error_free0 (e);
	}
	__finally17:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp50_ = FALSE;
		_g_free0 (path);
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp50_;
	}
	result = FALSE;
	_g_free0 (path);
	_g_object_unref0 (file);
	return result;
}


static void games_retro_runner_real_pause (GamesRunner* base) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	RetroMainLoop* _tmp1_;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->loop;
	retro_main_loop_stop (_tmp1_);
	games_retro_runner_set_running (self, FALSE);
	{
		games_retro_runner_save (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch18_g_error;
		}
	}
	goto __finally18;
	__catch18_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("retro-runner.vala:329: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally18:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void games_retro_runner_real_stop (GamesRunner* base) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		return;
	}
	games_runner_pause ((GamesRunner*) self);
	games_retro_runner_deinit (self);
	g_signal_emit_by_name ((GamesRunner*) self, "stopped");
}


static void games_retro_runner_on_media_number_changed (GamesRetroRunner* self) {
	gboolean _tmp0_;
	gint media_number;
	GamesMediaSet* _tmp1_;
	GamesMediaSet* _tmp2_;
	gint _tmp3_;
	gint _tmp4_;
	GamesMedia* media;
	gchar* uri;
	GamesMedia* _tmp13_;
	const gchar* _tmp14_;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	RetroCore* _tmp17_;
	const gchar* _tmp18_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_media_set_get_selected_media_number (_tmp2_);
	_tmp4_ = _tmp3_;
	media_number = _tmp4_;
	media = NULL;
	{
		GamesMedia* _tmp5_;
		GamesMediaSet* _tmp6_;
		GamesMediaSet* _tmp7_;
		gint _tmp8_;
		GamesMedia* _tmp9_;
		GamesMedia* _tmp10_;
		_tmp6_ = games_runner_get_media_set ((GamesRunner*) self);
		_tmp7_ = _tmp6_;
		_tmp8_ = media_number;
		_tmp9_ = games_media_set_get_selected_media (_tmp7_, (guint) _tmp8_, &_inner_error_);
		_tmp5_ = _tmp9_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch19_g_error;
		}
		_tmp10_ = _tmp5_;
		_tmp5_ = NULL;
		_g_object_unref0 (media);
		media = _tmp10_;
		_g_object_unref0 (_tmp5_);
	}
	goto __finally19;
	__catch19_g_error:
	{
		GError* e = NULL;
		GError* _tmp11_;
		const gchar* _tmp12_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp11_ = e;
		_tmp12_ = _tmp11_->message;
		g_warning ("retro-runner.vala:354: %s", _tmp12_);
		_g_error_free0 (e);
		_g_object_unref0 (media);
		return;
	}
	__finally19:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = media;
	_tmp14_ = games_media_get_uri (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup (_tmp15_);
	uri = _tmp16_;
	_tmp17_ = self->priv->core;
	_tmp18_ = uri;
	games_retro_runner_try_load_game (self, _tmp17_, _tmp18_);
	{
		games_retro_runner_save_media_data (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch20_g_error;
		}
	}
	goto __finally20;
	__catch20_g_error:
	{
		GError* e = NULL;
		GError* _tmp19_;
		const gchar* _tmp20_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp19_ = e;
		_tmp20_ = _tmp19_->message;
		g_warning ("retro-runner.vala:367: %s", _tmp20_);
		_g_error_free0 (e);
	}
	__finally20:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_free0 (uri);
		_g_object_unref0 (media);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_free0 (uri);
	_g_object_unref0 (media);
}


static void games_retro_runner_save (GamesRetroRunner* self, GError** error) {
	gboolean _tmp0_;
	GamesMediaSet* _tmp1_;
	GamesMediaSet* _tmp2_;
	gint _tmp3_;
	RetroCore* _tmp4_;
	gboolean _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->should_save;
	if (!_tmp0_) {
		return;
	}
	games_retro_runner_save_ram (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp2_ = _tmp1_;
	_tmp3_ = games_media_set_get_size (_tmp2_);
	if (_tmp3_ > 1) {
		games_retro_runner_save_media_data (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_propagate_error (error, _inner_error_);
			return;
		}
	}
	_tmp4_ = self->priv->core;
	_tmp5_ = retro_core_supports_serialization (_tmp4_);
	if (!_tmp5_) {
		return;
	}
	games_retro_runner_save_snapshot (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	games_retro_runner_save_screenshot (self, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	self->priv->should_save = FALSE;
}


static gchar* games_retro_runner_get_save_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* dir;
	gchar* _tmp3_;
	gchar* uid;
	GamesUid* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->save_path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->save_path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = games_application_get_saves_dir ();
	dir = _tmp3_;
	_tmp4_ = self->priv->uid;
	_tmp5_ = games_uid_get_uid (_tmp4_, &_inner_error_);
	uid = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp6_ = dir;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = uid;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp7_, "/", _tmp9_, ".save", NULL);
	_g_free0 (self->priv->save_path);
	self->priv->save_path = _tmp10_;
	_tmp11_ = self->priv->save_path;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static void games_retro_runner_save_ram (GamesRetroRunner* self, GError** error) {
	guint8* save;
	RetroCore* _tmp0_;
	gint _tmp1_;
	guint8* _tmp2_;
	gint save_length1;
	gint _save_size_;
	guint8* _tmp3_;
	gint _tmp3__length1;
	gchar* dir;
	gchar* _tmp4_;
	const gchar* _tmp5_;
	gchar* save_path;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp2_ = retro_core_get_memory (_tmp0_, RETRO_MEMORY_TYPE_SAVE_RAM, &_tmp1_);
	save = _tmp2_;
	save_length1 = _tmp1_;
	_save_size_ = save_length1;
	_tmp3_ = save;
	_tmp3__length1 = save_length1;
	if (_tmp3__length1 == 0) {
		save = (g_free (save), NULL);
		return;
	}
	_tmp4_ = games_application_get_saves_dir ();
	dir = _tmp4_;
	_tmp5_ = dir;
	games_retro_runner_try_make_dir (_tmp5_);
	_tmp6_ = games_retro_runner_get_save_path (self, &_inner_error_);
	save_path = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		save = (g_free (save), NULL);
		return;
	}
	_tmp7_ = save_path;
	_tmp8_ = save;
	_tmp8__length1 = save_length1;
	g_file_set_contents (_tmp7_, (const char*) _tmp8_, (size_t) _tmp8__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (save_path);
		_g_free0 (dir);
		save = (g_free (save), NULL);
		return;
	}
	_g_free0 (save_path);
	_g_free0 (dir);
	save = (g_free (save), NULL);
}


static void games_retro_runner_load_ram (GamesRetroRunner* self, GError** error) {
	gchar* save_path;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	const gchar* _tmp3_;
	guint8* _tmp4_ = NULL;
	size_t _tmp5_;
	gsize expected_size;
	RetroCore* _tmp6_;
	gsize _tmp7_;
	guint8* _tmp8_;
	gint _tmp8__length1;
	gsize _tmp9_;
	RetroCore* _tmp12_;
	guint8* _tmp13_;
	gint _tmp13__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_retro_runner_get_save_path (self, &_inner_error_);
	save_path = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = save_path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	if (!_tmp2_) {
		_g_free0 (save_path);
		return;
	}
	data = NULL;
	data_length1 = 0;
	_data_size_ = data_length1;
	_tmp3_ = save_path;
	g_file_get_contents (_tmp3_, (gchar**) (&_tmp4_), &_tmp5_, &_inner_error_);
	data = (g_free (data), NULL);
	data = _tmp4_;
	data_length1 = _tmp5_;
	_data_size_ = data_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		data = (g_free (data), NULL);
		_g_free0 (save_path);
		return;
	}
	_tmp6_ = self->priv->core;
	_tmp7_ = retro_core_get_memory_size (_tmp6_, RETRO_MEMORY_TYPE_SAVE_RAM);
	expected_size = _tmp7_;
	_tmp8_ = data;
	_tmp8__length1 = data_length1;
	_tmp9_ = expected_size;
	if (((gsize) _tmp8__length1) != _tmp9_) {
		guint8* _tmp10_;
		gint _tmp10__length1;
		gsize _tmp11_;
		_tmp10_ = data;
		_tmp10__length1 = data_length1;
		_tmp11_ = expected_size;
		g_warning ("retro-runner.vala:424: Unexpected RAM data size: got %lu, expected %lu" \
"\n", (gulong) _tmp10__length1, (gulong) _tmp11_);
	}
	_tmp12_ = self->priv->core;
	_tmp13_ = data;
	_tmp13__length1 = data_length1;
	retro_core_set_memory (_tmp12_, RETRO_MEMORY_TYPE_SAVE_RAM, _tmp13_, _tmp13__length1);
	data = (g_free (data), NULL);
	_g_free0 (save_path);
}


static gchar* games_retro_runner_get_snapshot_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* dir;
	gchar* _tmp3_;
	gchar* uid;
	GamesUid* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->snapshot_path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->snapshot_path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = games_application_get_snapshots_dir ();
	dir = _tmp3_;
	_tmp4_ = self->priv->uid;
	_tmp5_ = games_uid_get_uid (_tmp4_, &_inner_error_);
	uid = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp6_ = dir;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = uid;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp7_, "/", _tmp9_, ".snapshot", NULL);
	_g_free0 (self->priv->snapshot_path);
	self->priv->snapshot_path = _tmp10_;
	_tmp11_ = self->priv->snapshot_path;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static void games_retro_runner_save_snapshot (GamesRetroRunner* self, GError** error) {
	RetroCore* _tmp0_;
	gboolean _tmp1_;
	guint8* buffer;
	RetroCore* _tmp2_;
	gsize _tmp3_;
	guint8* _tmp4_;
	gint buffer_length1;
	gint _buffer_size_;
	gchar* dir;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	gchar* snapshot_path;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = retro_core_supports_serialization (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->core;
	_tmp4_ = retro_core_serialize_state (_tmp2_, &_tmp3_, &_inner_error_);
	buffer = _tmp4_;
	buffer_length1 = _tmp3_;
	_buffer_size_ = buffer_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp5_ = games_application_get_snapshots_dir ();
	dir = _tmp5_;
	_tmp6_ = dir;
	games_retro_runner_try_make_dir (_tmp6_);
	_tmp7_ = games_retro_runner_get_snapshot_path (self, &_inner_error_);
	snapshot_path = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		buffer = (g_free (buffer), NULL);
		return;
	}
	_tmp8_ = snapshot_path;
	_tmp9_ = buffer;
	_tmp9__length1 = buffer_length1;
	g_file_set_contents (_tmp8_, (const char*) _tmp9_, (size_t) _tmp9__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (snapshot_path);
		_g_free0 (dir);
		buffer = (g_free (buffer), NULL);
		return;
	}
	_g_free0 (snapshot_path);
	_g_free0 (dir);
	buffer = (g_free (buffer), NULL);
}


static void games_retro_runner_load_snapshot (GamesRetroRunner* self, GError** error) {
	RetroCore* _tmp0_;
	gboolean _tmp1_;
	gchar* snapshot_path;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	guint8* data;
	gint data_length1;
	gint _data_size_;
	const gchar* _tmp5_;
	guint8* _tmp6_ = NULL;
	size_t _tmp7_;
	RetroCore* _tmp8_;
	guint8* _tmp9_;
	gint _tmp9__length1;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = retro_core_supports_serialization (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = games_retro_runner_get_snapshot_path (self, &_inner_error_);
	snapshot_path = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = snapshot_path;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	if (!_tmp4_) {
		_g_free0 (snapshot_path);
		return;
	}
	data = NULL;
	data_length1 = 0;
	_data_size_ = data_length1;
	_tmp5_ = snapshot_path;
	g_file_get_contents (_tmp5_, (gchar**) (&_tmp6_), &_tmp7_, &_inner_error_);
	data = (g_free (data), NULL);
	data = _tmp6_;
	data_length1 = _tmp7_;
	_data_size_ = data_length1;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		data = (g_free (data), NULL);
		_g_free0 (snapshot_path);
		return;
	}
	_tmp8_ = self->priv->core;
	_tmp9_ = data;
	_tmp9__length1 = data_length1;
	retro_core_deserialize_state (_tmp8_, _tmp9_, (gsize) _tmp9__length1, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		data = (g_free (data), NULL);
		_g_free0 (snapshot_path);
		return;
	}
	data = (g_free (data), NULL);
	_g_free0 (snapshot_path);
}


static void games_retro_runner_save_media_data (GamesRetroRunner* self, GError** error) {
	gchar* dir;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* medias_path;
	gchar* _tmp2_;
	gchar* contents;
	GamesMediaSet* _tmp3_;
	GamesMediaSet* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_application_get_medias_dir ();
	dir = _tmp0_;
	_tmp1_ = dir;
	games_retro_runner_try_make_dir (_tmp1_);
	_tmp2_ = games_retro_runner_get_medias_path (self, &_inner_error_);
	medias_path = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return;
	}
	_tmp3_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp4_ = _tmp3_;
	_tmp5_ = games_media_set_get_selected_media_number (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = g_strdup_printf ("%i", _tmp6_);
	contents = _tmp7_;
	_tmp8_ = medias_path;
	_tmp9_ = contents;
	_tmp10_ = contents;
	_tmp11_ = strlen (_tmp10_);
	_tmp12_ = _tmp11_;
	g_file_set_contents (_tmp8_, _tmp9_, (gssize) _tmp12_, &_inner_error_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_free0 (medias_path);
		_g_free0 (dir);
		return;
	}
	_g_free0 (contents);
	_g_free0 (medias_path);
	_g_free0 (dir);
}


static void games_retro_runner_load_media_data (GamesRetroRunner* self, GError** error) {
	gchar* medias_path;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	gboolean _tmp2_;
	gchar* contents = NULL;
	const gchar* _tmp3_;
	gchar* _tmp4_ = NULL;
	gint disc_num;
	const gchar* _tmp5_;
	gint _tmp6_;
	GamesMediaSet* _tmp7_;
	GamesMediaSet* _tmp8_;
	gint _tmp9_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = games_retro_runner_get_medias_path (self, &_inner_error_);
	medias_path = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp1_ = medias_path;
	_tmp2_ = g_file_test (_tmp1_, G_FILE_TEST_EXISTS);
	if (!_tmp2_) {
		_g_free0 (medias_path);
		return;
	}
	_tmp3_ = medias_path;
	g_file_get_contents (_tmp3_, &_tmp4_, NULL, &_inner_error_);
	_g_free0 (contents);
	contents = _tmp4_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (contents);
		_g_free0 (medias_path);
		return;
	}
	_tmp5_ = contents;
	_tmp6_ = atoi (_tmp5_);
	disc_num = _tmp6_;
	_tmp7_ = games_runner_get_media_set ((GamesRunner*) self);
	_tmp8_ = _tmp7_;
	_tmp9_ = disc_num;
	games_media_set_set_selected_media_number (_tmp8_, _tmp9_);
	_g_free0 (contents);
	_g_free0 (medias_path);
}


static gchar* games_retro_runner_get_medias_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	gchar* dir;
	gchar* _tmp0_;
	gchar* uid;
	GamesUid* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_application_get_medias_dir ();
	dir = _tmp0_;
	_tmp1_ = self->priv->uid;
	_tmp2_ = games_uid_get_uid (_tmp1_, &_inner_error_);
	uid = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp3_ = string_to_string (dir);
	_tmp4_ = string_to_string (uid);
	_tmp5_ = g_strconcat (_tmp3_, "/", _tmp4_, ".media", NULL);
	result = _tmp5_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static gchar* games_retro_runner_get_screenshot_path (GamesRetroRunner* self, GError** error) {
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* dir;
	gchar* _tmp3_;
	gchar* uid;
	GamesUid* _tmp4_;
	gchar* _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->screenshot_path;
	if (_tmp0_ != NULL) {
		const gchar* _tmp1_;
		gchar* _tmp2_;
		_tmp1_ = self->priv->screenshot_path;
		_tmp2_ = g_strdup (_tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = games_application_get_snapshots_dir ();
	dir = _tmp3_;
	_tmp4_ = self->priv->uid;
	_tmp5_ = games_uid_get_uid (_tmp4_, &_inner_error_);
	uid = _tmp5_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (dir);
		return NULL;
	}
	_tmp6_ = dir;
	_tmp7_ = string_to_string (_tmp6_);
	_tmp8_ = uid;
	_tmp9_ = string_to_string (_tmp8_);
	_tmp10_ = g_strconcat (_tmp7_, "/", _tmp9_, ".png", NULL);
	_g_free0 (self->priv->screenshot_path);
	self->priv->screenshot_path = _tmp10_;
	_tmp11_ = self->priv->screenshot_path;
	_tmp12_ = g_strdup (_tmp11_);
	result = _tmp12_;
	_g_free0 (uid);
	_g_free0 (dir);
	return result;
}


static gchar* g_date_time_to_string (GDateTime* self) {
	gchar* result = NULL;
	gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_date_time_format (self, "%FT%H:%M:%S%z");
	result = _tmp0_;
	return result;
}


static void games_retro_runner_save_screenshot (GamesRetroRunner* self, GError** error) {
	RetroCore* _tmp0_;
	gboolean _tmp1_;
	GdkPixbuf* pixbuf;
	RetroCairoDisplay* _tmp2_;
	GdkPixbuf* _tmp3_;
	GdkPixbuf* _tmp4_;
	GdkPixbuf* _tmp5_;
	GdkPixbuf* _tmp6_;
	gchar* screenshot_path;
	gchar* _tmp7_;
	GDateTime* now;
	GDateTime* _tmp8_;
	gchar* creation_time;
	GDateTime* _tmp9_;
	gchar* _tmp10_;
	gchar* platform;
	GamesRetroCoreSource* _tmp11_;
	gchar* _tmp12_;
	gchar* platform_name;
	const gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* title;
	GamesTitle* _tmp15_;
	gchar* _tmp16_;
	const gchar* _tmp17_;
	GdkPixbuf* _tmp18_;
	const gchar* _tmp19_;
	gchar* x_dpi;
	gchar* _tmp20_;
	const gchar* _tmp21_;
	GdkPixbuf* _tmp22_;
	const gchar* _tmp23_;
	gchar* y_dpi;
	gchar* _tmp24_;
	GdkPixbuf* _tmp25_;
	const gchar* _tmp26_;
	const gchar* _tmp27_;
	const gchar* _tmp28_;
	const gchar* _tmp29_;
	const gchar* _tmp30_;
	gchar* _tmp31_;
	gchar* _tmp32_;
	const gchar* _tmp33_;
	const gchar* _tmp34_;
	const gchar* _tmp35_;
	const gchar* _tmp36_;
	const gchar* _tmp37_;
	const gchar* _tmp38_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = retro_core_supports_serialization (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = self->priv->video;
	_tmp3_ = retro_cairo_display_get_pixbuf (_tmp2_);
	_tmp4_ = _tmp3_;
	_tmp5_ = _g_object_ref0 (_tmp4_);
	pixbuf = _tmp5_;
	_tmp6_ = pixbuf;
	if (_tmp6_ == NULL) {
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp7_ = games_retro_runner_get_screenshot_path (self, &_inner_error_);
	screenshot_path = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp8_ = g_date_time_new_now_local ();
	now = _tmp8_;
	_tmp9_ = now;
	_tmp10_ = g_date_time_to_string (_tmp9_);
	creation_time = _tmp10_;
	_tmp11_ = self->priv->core_source;
	_tmp12_ = games_retro_core_source_get_platform (_tmp11_);
	platform = _tmp12_;
	_tmp13_ = platform;
	_tmp14_ = games_retro_platform_get_platform_name (_tmp13_);
	platform_name = _tmp14_;
	_tmp15_ = self->priv->game_title;
	_tmp16_ = games_title_get_title (_tmp15_, &_inner_error_);
	title = _tmp16_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (platform_name);
		_g_free0 (platform);
		_g_free0 (creation_time);
		_g_date_time_unref0 (now);
		_g_free0 (screenshot_path);
		_g_object_unref0 (pixbuf);
		return;
	}
	_tmp18_ = pixbuf;
	_tmp19_ = gdk_pixbuf_get_option (_tmp18_, "x-dpi");
	_tmp17_ = _tmp19_;
	if (_tmp17_ == NULL) {
		_tmp17_ = "";
	}
	_tmp20_ = g_strdup (_tmp17_);
	x_dpi = _tmp20_;
	_tmp22_ = pixbuf;
	_tmp23_ = gdk_pixbuf_get_option (_tmp22_, "y-dpi");
	_tmp21_ = _tmp23_;
	if (_tmp21_ == NULL) {
		_tmp21_ = "";
	}
	_tmp24_ = g_strdup (_tmp21_);
	y_dpi = _tmp24_;
	_tmp25_ = pixbuf;
	_tmp26_ = screenshot_path;
	_tmp27_ = title;
	_tmp28_ = string_to_string (_tmp27_);
	_tmp29_ = platform_name;
	_tmp30_ = string_to_string (_tmp29_);
	_tmp31_ = g_strconcat ("Screenshot of ", _tmp28_, " on ", _tmp30_, NULL);
	_tmp32_ = _tmp31_;
	_tmp33_ = creation_time;
	_tmp34_ = string_to_string (_tmp33_);
	_tmp35_ = title;
	_tmp36_ = platform_name;
	_tmp37_ = x_dpi;
	_tmp38_ = y_dpi;
	gdk_pixbuf_save (_tmp25_, _tmp26_, "png", &_inner_error_, "tEXt::Software", "GNOME Games", "tEXt::Title", _tmp32_, "tEXt::Creation Time", _tmp34_, "tEXt::Game Title", _tmp35_, "tEXt::Platform", _tmp36_, "x-dpi", _tmp37_, "y-dpi", _tmp38_, NULL, NULL);
	_g_free0 (_tmp32_);
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (y_dpi);
		_g_free0 (x_dpi);
		_g_free0 (title);
		_g_free0 (platform_name);
		_g_free0 (platform);
		_g_free0 (creation_time);
		_g_date_time_unref0 (now);
		_g_free0 (screenshot_path);
		_g_object_unref0 (pixbuf);
		return;
	}
	_g_free0 (y_dpi);
	_g_free0 (x_dpi);
	_g_free0 (title);
	_g_free0 (platform_name);
	_g_free0 (platform);
	_g_free0 (creation_time);
	_g_date_time_unref0 (now);
	_g_free0 (screenshot_path);
	_g_object_unref0 (pixbuf);
}


static void games_retro_runner_load_screenshot (GamesRetroRunner* self, GError** error) {
	RetroCore* _tmp0_;
	gboolean _tmp1_;
	gchar* screenshot_path;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	GdkPixbuf* pixbuf;
	const gchar* _tmp5_;
	GdkPixbuf* _tmp6_;
	RetroCairoDisplay* _tmp7_;
	GdkPixbuf* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->core;
	_tmp1_ = retro_core_supports_serialization (_tmp0_);
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = games_retro_runner_get_screenshot_path (self, &_inner_error_);
	screenshot_path = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = screenshot_path;
	_tmp4_ = g_file_test (_tmp3_, G_FILE_TEST_EXISTS);
	if (!_tmp4_) {
		_g_free0 (screenshot_path);
		return;
	}
	_tmp5_ = screenshot_path;
	_tmp6_ = gdk_pixbuf_new_from_file (_tmp5_, &_inner_error_);
	pixbuf = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (screenshot_path);
		return;
	}
	_tmp7_ = self->priv->video;
	_tmp8_ = pixbuf;
	retro_cairo_display_set_pixbuf (_tmp7_, _tmp8_);
	_g_object_unref0 (pixbuf);
	_g_free0 (screenshot_path);
}


static gboolean games_retro_runner_on_shutdown (GamesRetroRunner* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	games_runner_stop ((GamesRunner*) self);
	result = TRUE;
	return result;
}


static void games_retro_runner_try_make_dir (const gchar* path) {
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (path != NULL);
	_tmp0_ = path;
	_tmp1_ = g_file_new_for_path (_tmp0_);
	file = _tmp1_;
	{
		GFile* _tmp2_;
		gboolean _tmp3_;
		_tmp2_ = file;
		_tmp3_ = g_file_query_exists (_tmp2_, NULL);
		if (!_tmp3_) {
			GFile* _tmp4_;
			_tmp4_ = file;
			g_file_make_directory_with_parents (_tmp4_, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch21_g_error;
			}
		}
	}
	goto __finally21;
	__catch21_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_;
		const gchar* _tmp6_;
		const gchar* _tmp7_;
		gchar* _tmp8_;
		gchar* _tmp9_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		_tmp7_ = string_to_string (_tmp6_);
		_tmp8_ = g_strconcat (_tmp7_, "\n", NULL);
		_tmp9_ = _tmp8_;
		g_warning ("retro-runner.vala:570: %s", _tmp9_);
		_g_free0 (_tmp9_);
		_g_error_free0 (e);
		_g_object_unref0 (file);
		return;
	}
	__finally21:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (file);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (file);
}


static gchar* games_retro_runner_get_unsupported_system_message (GamesRetroRunner* self) {
	gchar* result = NULL;
	GamesRetroCoreSource* _tmp0_;
	gchar* _tmp8_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->core_source;
	if (_tmp0_ != NULL) {
		gchar* platform;
		GamesRetroCoreSource* _tmp1_;
		gchar* _tmp2_;
		gchar* platform_name;
		const gchar* _tmp3_;
		gchar* _tmp4_;
		const gchar* _tmp5_;
		_tmp1_ = self->priv->core_source;
		_tmp2_ = games_retro_core_source_get_platform (_tmp1_);
		platform = _tmp2_;
		_tmp3_ = platform;
		_tmp4_ = games_retro_platform_get_platform_name (_tmp3_);
		platform_name = _tmp4_;
		_tmp5_ = platform_name;
		if (_tmp5_ != NULL) {
			const gchar* _tmp6_;
			gchar* _tmp7_;
			_tmp6_ = platform_name;
			_tmp7_ = g_strdup_printf (_ ("The system “%s” isn’t supported yet, but full support is planned."), _tmp6_);
			result = _tmp7_;
			_g_free0 (platform_name);
			_g_free0 (platform);
			return result;
		}
		_g_free0 (platform_name);
		_g_free0 (platform);
	}
	_tmp8_ = g_strdup (_ ("The system isn’t supported yet, but full support is planned."));
	result = _tmp8_;
	return result;
}


static gboolean games_retro_runner_real_get_can_fullscreen (GamesRunner* base) {
	gboolean result;
	GamesRetroRunner* self;
	self = (GamesRetroRunner*) base;
	result = TRUE;
	return result;
}


static gboolean games_retro_runner_real_get_can_quit_safely (GamesRunner* base) {
	gboolean result;
	GamesRetroRunner* self;
	gboolean _tmp0_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->should_save;
	result = !_tmp0_;
	return result;
}


static gboolean games_retro_runner_real_get_can_resume (GamesRunner* base) {
	gboolean result;
	GamesRetroRunner* self;
	GError * _inner_error_ = NULL;
	self = (GamesRetroRunner*) base;
	{
		RetroCore* _tmp0_;
		gboolean _tmp1_;
		gchar* snapshot_path;
		gchar* _tmp2_;
		GFile* file;
		const gchar* _tmp3_;
		GFile* _tmp4_;
		GFile* _tmp5_;
		gboolean _tmp6_;
		games_retro_runner_init (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
		_tmp0_ = self->priv->core;
		_tmp1_ = retro_core_supports_serialization (_tmp0_);
		if (!_tmp1_) {
			result = FALSE;
			return result;
		}
		_tmp2_ = games_retro_runner_get_snapshot_path (self, &_inner_error_);
		snapshot_path = _tmp2_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch22_g_error;
		}
		_tmp3_ = snapshot_path;
		_tmp4_ = g_file_new_for_path (_tmp3_);
		file = _tmp4_;
		_tmp5_ = file;
		_tmp6_ = g_file_query_exists (_tmp5_, NULL);
		result = _tmp6_;
		_g_object_unref0 (file);
		_g_free0 (snapshot_path);
		return result;
	}
	goto __finally22;
	__catch22_g_error:
	{
		GError* e = NULL;
		GError* _tmp7_;
		const gchar* _tmp8_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp7_ = e;
		_tmp8_ = _tmp7_->message;
		g_warning ("retro-runner.vala:25: %s", _tmp8_);
		_g_error_free0 (e);
	}
	__finally22:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		gboolean _tmp9_ = FALSE;
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return _tmp9_;
	}
	result = FALSE;
	return result;
}


static GamesMediaSet* games_retro_runner_real_get_media_set (GamesRunner* base) {
	GamesMediaSet* result;
	GamesRetroRunner* self;
	GamesMediaSet* _tmp0_;
	self = (GamesRetroRunner*) base;
	_tmp0_ = self->priv->_media_set;
	result = _tmp0_;
	return result;
}


static gboolean games_retro_runner_get_running (GamesRetroRunner* self) {
	gboolean result;
	gboolean _tmp0_;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_running;
	result = _tmp0_;
	return result;
}


static void games_retro_runner_set_running (GamesRetroRunner* self, gboolean value) {
	gboolean _tmp0_;
	gboolean _tmp1_;
	gboolean _tmp2_;
	RetroCairoDisplay* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_running = _tmp0_;
	_tmp1_ = games_retro_runner_get_running (self);
	_tmp2_ = _tmp1_;
	if (_tmp2_) {
		self->priv->should_save = TRUE;
	}
	_tmp3_ = self->priv->video;
	_tmp4_ = games_retro_runner_get_running (self);
	_tmp5_ = _tmp4_;
	gtk_widget_set_sensitive ((GtkWidget*) _tmp3_, _tmp5_);
}


static GObject * games_retro_runner_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GamesRetroRunner * self;
	GSettings* _tmp0_;
	parent_class = G_OBJECT_CLASS (games_retro_runner_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	_tmp0_ = g_settings_new ("org.gnome.Games");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	return obj;
}


static void games_retro_runner_class_init (GamesRetroRunnerClass * klass) {
	games_retro_runner_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesRetroRunnerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_retro_runner_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_games_retro_runner_set_property;
	G_OBJECT_CLASS (klass)->constructor = games_retro_runner_constructor;
	G_OBJECT_CLASS (klass)->finalize = games_retro_runner_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_CAN_FULLSCREEN, g_param_spec_boolean ("can-fullscreen", "can-fullscreen", "can-fullscreen", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_CAN_QUIT_SAFELY, g_param_spec_boolean ("can-quit-safely", "can-quit-safely", "can-quit-safely", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_CAN_RESUME, g_param_spec_boolean ("can-resume", "can-resume", "can-resume", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_RETRO_RUNNER_MEDIA_SET, g_param_spec_object ("media-set", "media-set", "media-set", GAMES_TYPE_MEDIA_SET, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_retro_runner_games_runner_interface_init (GamesRunnerIface * iface) {
	games_retro_runner_games_runner_parent_iface = g_type_interface_peek_parent (iface);
	iface->check_is_valid = (gboolean (*) (GamesRunner *, gchar* *, GError**)) games_retro_runner_real_check_is_valid;
	iface->get_display = (GtkWidget* (*) (GamesRunner *)) games_retro_runner_real_get_display;
	iface->start = (void (*) (GamesRunner *, GError**)) games_retro_runner_real_start;
	iface->resume = (void (*) (GamesRunner *, GError**)) games_retro_runner_real_resume;
	iface->pause = (void (*) (GamesRunner *)) games_retro_runner_real_pause;
	iface->stop = (void (*) (GamesRunner *)) games_retro_runner_real_stop;
	iface->get_can_fullscreen = games_retro_runner_real_get_can_fullscreen;
	iface->get_can_quit_safely = games_retro_runner_real_get_can_quit_safely;
	iface->get_can_resume = games_retro_runner_real_get_can_resume;
	iface->get_media_set = games_retro_runner_real_get_media_set;
}


static void games_retro_runner_instance_init (GamesRetroRunner * self) {
	self->priv = GAMES_RETRO_RUNNER_GET_PRIVATE (self);
}


static void games_retro_runner_finalize (GObject * obj) {
	GamesRetroRunner * self;
	gboolean _tmp0_;
	RetroMainLoop* _tmp1_;
	GError * _inner_error_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	_tmp0_ = self->priv->is_initialized;
	if (!_tmp0_) {
		goto _return;
	}
	_tmp1_ = self->priv->loop;
	retro_main_loop_stop (_tmp1_);
	games_retro_runner_set_running (self, FALSE);
	{
		games_retro_runner_save (self, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GError* _tmp2_;
		const gchar* _tmp3_;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp2_ = e;
		_tmp3_ = _tmp2_->message;
		g_warning ("retro-runner.vala:131: %s", _tmp3_);
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
	_return:
	_g_object_unref0 (self->priv->_media_set);
	_g_object_unref0 (self->priv->core);
	_g_object_unref0 (self->priv->video);
	_g_object_unref0 (self->priv->audio);
	_g_object_unref0 (self->priv->input_manager);
	_g_object_unref0 (self->priv->loop);
	_g_object_unref0 (self->priv->widget);
	_g_free0 (self->priv->save_path);
	_g_free0 (self->priv->snapshot_path);
	_g_free0 (self->priv->screenshot_path);
	_g_object_unref0 (self->priv->core_descriptor);
	_g_object_unref0 (self->priv->core_source);
	_g_object_unref0 (self->priv->uid);
	_g_object_unref0 (self->priv->input_capabilities);
	_g_object_unref0 (self->priv->settings);
	_g_object_unref0 (self->priv->game_title);
	G_OBJECT_CLASS (games_retro_runner_parent_class)->finalize (obj);
}


GType games_retro_runner_get_type (void) {
	static volatile gsize games_retro_runner_type_id__volatile = 0;
	if (g_once_init_enter (&games_retro_runner_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GamesRetroRunnerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_retro_runner_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesRetroRunner), 0, (GInstanceInitFunc) games_retro_runner_instance_init, NULL };
		static const GInterfaceInfo games_runner_info = { (GInterfaceInitFunc) games_retro_runner_games_runner_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
		GType games_retro_runner_type_id;
		games_retro_runner_type_id = g_type_register_static (G_TYPE_OBJECT, "GamesRetroRunner", &g_define_type_info, 0);
		g_type_add_interface_static (games_retro_runner_type_id, GAMES_TYPE_RUNNER, &games_runner_info);
		g_once_init_leave (&games_retro_runner_type_id__volatile, games_retro_runner_type_id);
	}
	return games_retro_runner_type_id__volatile;
}


static void _vala_games_retro_runner_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesRetroRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	switch (property_id) {
		case GAMES_RETRO_RUNNER_CAN_FULLSCREEN:
		g_value_set_boolean (value, games_runner_get_can_fullscreen ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_CAN_QUIT_SAFELY:
		g_value_set_boolean (value, games_runner_get_can_quit_safely ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_CAN_RESUME:
		g_value_set_boolean (value, games_runner_get_can_resume ((GamesRunner*) self));
		break;
		case GAMES_RETRO_RUNNER_MEDIA_SET:
		g_value_set_object (value, games_runner_get_media_set ((GamesRunner*) self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_games_retro_runner_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GamesRetroRunner * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_RETRO_RUNNER, GamesRetroRunner);
	switch (property_id) {
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



