/* steam-game-source.c generated by valac 0.35.5, the Vala compiler
 * generated from steam-game-source.vala, do not modify */

/* This file is part of GNOME Games. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <libgnome-games.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>


#define GAMES_TYPE_STEAM_GAME_SOURCE (games_steam_game_source_get_type ())
#define GAMES_STEAM_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_GAME_SOURCE, GamesSteamGameSource))
#define GAMES_STEAM_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_GAME_SOURCE, GamesSteamGameSourceClass))
#define GAMES_IS_STEAM_GAME_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_GAME_SOURCE))
#define GAMES_IS_STEAM_GAME_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_GAME_SOURCE))
#define GAMES_STEAM_GAME_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_GAME_SOURCE, GamesSteamGameSourceClass))

typedef struct _GamesSteamGameSource GamesSteamGameSource;
typedef struct _GamesSteamGameSourceClass GamesSteamGameSourceClass;
typedef struct _GamesSteamGameSourcePrivate GamesSteamGameSourcePrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define GAMES_TYPE_STEAM_REGISTRY (games_steam_registry_get_type ())
#define GAMES_STEAM_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_REGISTRY, GamesSteamRegistry))
#define GAMES_STEAM_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_REGISTRY, GamesSteamRegistryClass))
#define GAMES_IS_STEAM_REGISTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_REGISTRY))
#define GAMES_IS_STEAM_REGISTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_REGISTRY))
#define GAMES_STEAM_REGISTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_REGISTRY, GamesSteamRegistryClass))

typedef struct _GamesSteamRegistry GamesSteamRegistry;
typedef struct _GamesSteamRegistryClass GamesSteamRegistryClass;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _games_steam_registry_unref0(var) ((var == NULL) ? NULL : (var = (games_steam_registry_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
typedef struct _GamesSteamGameSourceEachGameData GamesSteamGameSourceEachGameData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _GamesSteamGameSourceEachGameInSteamappsDirData GamesSteamGameSourceEachGameInSteamappsDirData;
typedef struct _GamesSteamGameSourceGameForFileInfoData GamesSteamGameSourceGameForFileInfoData;

#define GAMES_TYPE_STEAM_TITLE (games_steam_title_get_type ())
#define GAMES_STEAM_TITLE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_TITLE, GamesSteamTitle))
#define GAMES_STEAM_TITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_TITLE, GamesSteamTitleClass))
#define GAMES_IS_STEAM_TITLE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_TITLE))
#define GAMES_IS_STEAM_TITLE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_TITLE))
#define GAMES_STEAM_TITLE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_TITLE, GamesSteamTitleClass))

typedef struct _GamesSteamTitle GamesSteamTitle;
typedef struct _GamesSteamTitleClass GamesSteamTitleClass;

#define GAMES_TYPE_STEAM_ICON (games_steam_icon_get_type ())
#define GAMES_STEAM_ICON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_ICON, GamesSteamIcon))
#define GAMES_STEAM_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_ICON, GamesSteamIconClass))
#define GAMES_IS_STEAM_ICON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_ICON))
#define GAMES_IS_STEAM_ICON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_ICON))
#define GAMES_STEAM_ICON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_ICON, GamesSteamIconClass))

typedef struct _GamesSteamIcon GamesSteamIcon;
typedef struct _GamesSteamIconClass GamesSteamIconClass;

#define GAMES_TYPE_STEAM_COVER (games_steam_cover_get_type ())
#define GAMES_STEAM_COVER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_STEAM_COVER, GamesSteamCover))
#define GAMES_STEAM_COVER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_STEAM_COVER, GamesSteamCoverClass))
#define GAMES_IS_STEAM_COVER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_STEAM_COVER))
#define GAMES_IS_STEAM_COVER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_STEAM_COVER))
#define GAMES_STEAM_COVER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_STEAM_COVER, GamesSteamCoverClass))

typedef struct _GamesSteamCover GamesSteamCover;
typedef struct _GamesSteamCoverClass GamesSteamCoverClass;

struct _GamesSteamGameSource {
	GObject parent_instance;
	GamesSteamGameSourcePrivate * priv;
};

struct _GamesSteamGameSourceClass {
	GObjectClass parent_class;
};

struct _GamesSteamGameSourcePrivate {
	gchar** libraries;
	gint libraries_length1;
	gint _libraries_size_;
	GHashTable* games;
};

struct _GamesSteamGameSourceEachGameData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _task_complete_;
	GamesSteamGameSource* self;
	GamesGameCallback game_callback;
	gpointer game_callback_target;
	GHashTable* _tmp0_;
	GHashFunc _tmp1_;
	GEqualFunc _tmp2_;
	GHashTable* _tmp3_;
	gchar** _tmp4_;
	gint _tmp4__length1;
	gchar** library_collection;
	gint library_collection_length1;
	gint _library_collection_size_;
	gint library_it;
	gchar* _tmp5_;
	gchar* library;
	const gchar** steamapps_dir_collection;
	gint steamapps_dir_collection_length1;
	gint _steamapps_dir_collection_size_;
	gint steamapps_dir_it;
	const gchar* steamapps_dir;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	GHashTable* _tmp10_;
	GList* _tmp11_;
	GList* game_collection;
	GList* game_it;
	GamesGame* game;
	GamesGameCallback _tmp12_;
	void* _tmp12__target;
	GamesGame* _tmp13_;
};

struct _GamesSteamGameSourceEachGameInSteamappsDirData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _task_complete_;
	GamesSteamGameSource* self;
	gchar* directory;
	GFile* file;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFileEnumerator* enumerator;
	GFile* _tmp2_;
	GFileEnumerator* _tmp3_;
	GFileInfo* info;
	GFileInfo* _tmp4_;
	GFileEnumerator* _tmp5_;
	GFileInfo* _tmp6_;
	GFileInfo* _tmp7_;
	GFileInfo* _tmp8_;
	const gchar* _tmp9_;
	GFileInfo* _tmp10_;
	GError* e;
	GError * _inner_error_;
};

struct _GamesSteamGameSourceGameForFileInfoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gboolean _task_complete_;
	GamesSteamGameSource* self;
	gchar* directory;
	GFileInfo* info;
	gchar* name;
	GFileInfo* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GRegex* _tmp3_;
	const gchar* _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* e;
	GError* _tmp12_;
	const gchar* _tmp13_;
	GError * _inner_error_;
};

typedef enum  {
	GAMES_STEAM_ERROR_NO_APPID,
	GAMES_STEAM_ERROR_NO_NAME
} GamesSteamError;
#define GAMES_STEAM_ERROR games_steam_error_quark ()

static gpointer games_steam_game_source_parent_class = NULL;
static GRegex* games_steam_game_source_appmanifest_regex;
static GRegex* games_steam_game_source_appmanifest_regex = NULL;
static GamesGameSourceIface * games_steam_game_source_games_game_source_parent_iface = NULL;
static GType games_steam_game_source_type_id = 0;

GType games_steam_game_source_get_type (void) G_GNUC_CONST;
#define GAMES_STEAM_GAME_SOURCE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_STEAM_GAME_SOURCE, GamesSteamGameSourcePrivate))
enum  {
	GAMES_STEAM_GAME_SOURCE_DUMMY_PROPERTY
};
#define GAMES_STEAM_GAME_SOURCE_REGISTRY_PATH "/.steam/registry.vdf"
#define GAMES_STEAM_GAME_SOURCE_DEFAULT_INSTALL_DIR_SYMLINK "/.steam/steam"
#define GAMES_STEAM_GAME_SOURCE_LIBRARY_DIRS_REG "/libraryfolders.vdf"
GamesSteamGameSource* games_steam_game_source_new (GError** error);
GamesSteamGameSource* games_steam_game_source_construct (GType object_type, GError** error);
gpointer games_steam_registry_ref (gpointer instance);
void games_steam_registry_unref (gpointer instance);
GParamSpec* games_param_spec_steam_registry (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void games_value_set_steam_registry (GValue* value, gpointer v_object);
void games_value_take_steam_registry (GValue* value, gpointer v_object);
gpointer games_value_get_steam_registry (const GValue* value);
GType games_steam_registry_get_type (void) G_GNUC_CONST;
GamesSteamRegistry* games_steam_registry_new (const gchar* appmanifest_path, GError** error);
GamesSteamRegistry* games_steam_registry_construct (GType object_type, const gchar* appmanifest_path, GError** error);
gchar* games_steam_registry_get_data (GamesSteamRegistry* self, gchar** path, int path_length1);
gchar** games_steam_registry_get_children (GamesSteamRegistry* self, gchar** path, int path_length1, int* result_length1);
static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value);
static void games_steam_game_source_real_each_game_data_free (gpointer _data);
static void games_steam_game_source_real_each_game (GamesGameSource* base, GamesGameCallback game_callback, void* game_callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean games_steam_game_source_real_each_game_co (GamesSteamGameSourceEachGameData* _data_);
static void _g_free0_ (gpointer var);
static void _g_object_unref0_ (gpointer var);
void games_steam_game_source_each_game_in_steamapps_dir (GamesSteamGameSource* self, const gchar* directory, GAsyncReadyCallback _callback_, gpointer _user_data_);
void games_steam_game_source_each_game_in_steamapps_dir_finish (GamesSteamGameSource* self, GAsyncResult* _res_);
static void games_steam_game_source_each_game_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void games_steam_game_source_each_game_in_steamapps_dir_data_free (gpointer _data);
static gboolean games_steam_game_source_each_game_in_steamapps_dir_co (GamesSteamGameSourceEachGameInSteamappsDirData* _data_);
static void games_steam_game_source_each_game_in_steamapps_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
void games_steam_game_source_game_for_file_info (GamesSteamGameSource* self, const gchar* directory, GFileInfo* info, GAsyncReadyCallback _callback_, gpointer _user_data_);
void games_steam_game_source_game_for_file_info_finish (GamesSteamGameSource* self, GAsyncResult* _res_);
static void games_steam_game_source_game_for_file_info_data_free (gpointer _data);
static gboolean games_steam_game_source_game_for_file_info_co (GamesSteamGameSourceGameForFileInfoData* _data_);
static void games_steam_game_source_game_for_appmanifest_path (GamesSteamGameSource* self, const gchar* appmanifest_path, GError** error);
static gboolean _games_steam_game_source_game_for_file_info_co_gsource_func (gpointer self);
GQuark games_steam_error_quark (void);
GType games_steam_title_get_type (void) G_GNUC_CONST;
GamesSteamTitle* games_steam_title_new (GamesSteamRegistry* registry);
GamesSteamTitle* games_steam_title_construct (GType object_type, GamesSteamRegistry* registry);
GType games_steam_icon_get_type (void) G_GNUC_CONST;
GamesSteamIcon* games_steam_icon_new (const gchar* game_id);
GamesSteamIcon* games_steam_icon_construct (GType object_type, const gchar* game_id);
GType games_steam_cover_get_type (void) G_GNUC_CONST;
GamesSteamCover* games_steam_cover_new (const gchar* game_id);
GamesSteamCover* games_steam_cover_construct (GType object_type, const gchar* game_id);
static void games_steam_game_source_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const gchar* GAMES_STEAM_GAME_SOURCE_STEAMAPPS_DIRS[2] = {"/SteamApps", "/steamapps"};
static const gchar* GAMES_STEAM_GAME_SOURCE_INSTALL_PATH_REGISTRY_PATH[6] = {"Registry", "HKLM", "Software", "Valve", "Steam", "InstallPath"};
static GRegex* _tmp_regex_0 = NULL;
static GRegex* _tmp_regex_1 = NULL;

static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static void _vala_array_add1 (gchar** * array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


GamesSteamGameSource* games_steam_game_source_construct (GType object_type, GError** error) {
	GamesSteamGameSource * self = NULL;
	GRegex* _tmp0_;
	gchar* home;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* registry_path;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	GamesSteamRegistry* registry;
	const gchar* _tmp6_;
	GamesSteamRegistry* _tmp7_;
	gchar* install_path;
	GamesSteamRegistry* _tmp8_;
	gchar* _tmp9_;
	const gchar* _tmp10_;
	gchar* _tmp11_;
	const gchar* _tmp12_;
	gchar* _tmp13_;
	gchar** _tmp14_;
	GError * _inner_error_ = NULL;
	self = (GamesSteamGameSource*) g_object_new (object_type, NULL);
	_tmp0_ = games_steam_game_source_appmanifest_regex;
	if (_tmp0_ == NULL) {
		GRegex* _tmp1_;
		_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "appmanifest_\\d+\\.acf", 0));
		_g_regex_unref0 (games_steam_game_source_appmanifest_regex);
		games_steam_game_source_appmanifest_regex = _tmp1_;
	}
	_tmp2_ = g_get_home_dir ();
	_tmp3_ = g_strdup (_tmp2_);
	home = _tmp3_;
	_tmp4_ = home;
	_tmp5_ = g_strconcat (_tmp4_, GAMES_STEAM_GAME_SOURCE_REGISTRY_PATH, NULL);
	registry_path = _tmp5_;
	_tmp6_ = registry_path;
	_tmp7_ = games_steam_registry_new (_tmp6_, &_inner_error_);
	registry = _tmp7_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (registry_path);
		_g_free0 (home);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp8_ = registry;
	_tmp9_ = games_steam_registry_get_data (_tmp8_, GAMES_STEAM_GAME_SOURCE_INSTALL_PATH_REGISTRY_PATH, G_N_ELEMENTS (GAMES_STEAM_GAME_SOURCE_INSTALL_PATH_REGISTRY_PATH));
	install_path = _tmp9_;
	_tmp10_ = home;
	_tmp11_ = g_strconcat (_tmp10_, GAMES_STEAM_GAME_SOURCE_DEFAULT_INSTALL_DIR_SYMLINK, NULL);
	_tmp12_ = install_path;
	_tmp13_ = g_strdup (_tmp12_);
	_tmp14_ = g_new0 (gchar*, 2 + 1);
	_tmp14_[0] = _tmp11_;
	_tmp14_[1] = _tmp13_;
	self->priv->libraries = (_vala_array_free (self->priv->libraries, self->priv->libraries_length1, (GDestroyNotify) g_free), NULL);
	self->priv->libraries = _tmp14_;
	self->priv->libraries_length1 = 2;
	self->priv->_libraries_size_ = self->priv->libraries_length1;
	{
		const gchar** steamapps_dir_collection = NULL;
		gint steamapps_dir_collection_length1 = 0;
		gint _steamapps_dir_collection_size_ = 0;
		gint steamapps_dir_it = 0;
		steamapps_dir_collection = GAMES_STEAM_GAME_SOURCE_STEAMAPPS_DIRS;
		steamapps_dir_collection_length1 = G_N_ELEMENTS (GAMES_STEAM_GAME_SOURCE_STEAMAPPS_DIRS);
		for (steamapps_dir_it = 0; steamapps_dir_it < G_N_ELEMENTS (GAMES_STEAM_GAME_SOURCE_STEAMAPPS_DIRS); steamapps_dir_it = steamapps_dir_it + 1) {
			const gchar* steamapps_dir = NULL;
			steamapps_dir = steamapps_dir_collection[steamapps_dir_it];
			{
				gchar* install_steamapps_dir;
				const gchar* _tmp15_;
				const gchar* _tmp16_;
				gchar* _tmp17_;
				GFile* file;
				const gchar* _tmp18_;
				GFile* _tmp19_;
				GFile* _tmp20_;
				gboolean _tmp21_;
				gchar* library_reg_path;
				const gchar* _tmp22_;
				gchar* _tmp23_;
				GamesSteamRegistry* library_reg;
				const gchar* _tmp24_;
				GamesSteamRegistry* _tmp25_;
				GamesSteamRegistry* _tmp26_;
				gchar* _tmp27_;
				gchar** _tmp28_;
				gchar** _tmp29_;
				gint _tmp29__length1;
				gint _tmp30_;
				gchar** _tmp31_;
				gchar** _tmp32_;
				gint _tmp32__length1;
				_tmp15_ = install_path;
				_tmp16_ = steamapps_dir;
				_tmp17_ = g_strconcat (_tmp15_, _tmp16_, NULL);
				install_steamapps_dir = _tmp17_;
				_tmp18_ = install_steamapps_dir;
				_tmp19_ = g_file_new_for_path (_tmp18_);
				file = _tmp19_;
				_tmp20_ = file;
				_tmp21_ = g_file_query_exists (_tmp20_, NULL);
				if (!_tmp21_) {
					_g_object_unref0 (file);
					_g_free0 (install_steamapps_dir);
					continue;
				}
				_tmp22_ = install_steamapps_dir;
				_tmp23_ = g_strconcat (_tmp22_, GAMES_STEAM_GAME_SOURCE_LIBRARY_DIRS_REG, NULL);
				library_reg_path = _tmp23_;
				_tmp24_ = library_reg_path;
				_tmp25_ = games_steam_registry_new (_tmp24_, &_inner_error_);
				library_reg = _tmp25_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_free0 (library_reg_path);
					_g_object_unref0 (file);
					_g_free0 (install_steamapps_dir);
					_g_free0 (install_path);
					_games_steam_registry_unref0 (registry);
					_g_free0 (registry_path);
					_g_free0 (home);
					_g_object_unref0 (self);
					return NULL;
				}
				_tmp26_ = library_reg;
				_tmp27_ = g_strdup ("LibraryFolders");
				_tmp28_ = g_new0 (gchar*, 1 + 1);
				_tmp28_[0] = _tmp27_;
				_tmp29_ = _tmp28_;
				_tmp29__length1 = 1;
				_tmp31_ = games_steam_registry_get_children (_tmp26_, _tmp29_, 1, &_tmp30_);
				_tmp32_ = _tmp31_;
				_tmp32__length1 = _tmp30_;
				_tmp29_ = (_vala_array_free (_tmp29_, _tmp29__length1, (GDestroyNotify) g_free), NULL);
				{
					gchar** child_collection = NULL;
					gint child_collection_length1 = 0;
					gint _child_collection_size_ = 0;
					gint child_it = 0;
					child_collection = _tmp32_;
					child_collection_length1 = _tmp32__length1;
					for (child_it = 0; child_it < _tmp32__length1; child_it = child_it + 1) {
						gchar* _tmp33_;
						gchar* child = NULL;
						_tmp33_ = g_strdup (child_collection[child_it]);
						child = _tmp33_;
						{
							const gchar* _tmp34_;
							gboolean _tmp35_;
							_tmp34_ = child;
							_tmp35_ = g_regex_match (_thread_safe_regex_init (&_tmp_regex_1, "^\\d+$", 0), _tmp34_, 0, NULL);
							if (_tmp35_) {
								gchar** _tmp36_;
								gint _tmp36__length1;
								GamesSteamRegistry* _tmp37_;
								gchar* _tmp38_;
								const gchar* _tmp39_;
								gchar* _tmp40_;
								gchar** _tmp41_;
								gchar** _tmp42_;
								gint _tmp42__length1;
								gchar* _tmp43_;
								_tmp36_ = self->priv->libraries;
								_tmp36__length1 = self->priv->libraries_length1;
								_tmp37_ = library_reg;
								_tmp38_ = g_strdup ("LibraryFolders");
								_tmp39_ = child;
								_tmp40_ = g_strdup (_tmp39_);
								_tmp41_ = g_new0 (gchar*, 2 + 1);
								_tmp41_[0] = _tmp38_;
								_tmp41_[1] = _tmp40_;
								_tmp42_ = _tmp41_;
								_tmp42__length1 = 2;
								_tmp43_ = games_steam_registry_get_data (_tmp37_, _tmp42_, 2);
								_vala_array_add1 (&self->priv->libraries, &self->priv->libraries_length1, &self->priv->_libraries_size_, _tmp43_);
								_tmp42_ = (_vala_array_free (_tmp42_, _tmp42__length1, (GDestroyNotify) g_free), NULL);
							}
							_g_free0 (child);
						}
					}
					child_collection = (_vala_array_free (child_collection, child_collection_length1, (GDestroyNotify) g_free), NULL);
				}
				_games_steam_registry_unref0 (library_reg);
				_g_free0 (library_reg_path);
				_g_object_unref0 (file);
				_g_free0 (install_steamapps_dir);
			}
		}
	}
	_g_free0 (install_path);
	_games_steam_registry_unref0 (registry);
	_g_free0 (registry_path);
	_g_free0 (home);
	return self;
}


GamesSteamGameSource* games_steam_game_source_new (GError** error) {
	return games_steam_game_source_construct (GAMES_TYPE_STEAM_GAME_SOURCE, error);
}


static void games_steam_game_source_real_each_game_data_free (gpointer _data) {
	GamesSteamGameSourceEachGameData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSteamGameSourceEachGameData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void games_steam_game_source_real_each_game (GamesGameSource* base, GamesGameCallback game_callback, void* game_callback_target, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesSteamGameSource * self;
	GamesSteamGameSourceEachGameData* _data_;
	GamesSteamGameSource* _tmp0_;
	GamesGameCallback _tmp1_;
	void* _tmp1__target;
	self = (GamesSteamGameSource*) base;
	_data_ = g_slice_new0 (GamesSteamGameSourceEachGameData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_steam_game_source_real_each_game_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = game_callback;
	_tmp1__target = game_callback_target;
	_data_->game_callback = _tmp1_;
	_data_->game_callback_target = _tmp1__target;
	games_steam_game_source_real_each_game_co (_data_);
}


static void games_steam_game_source_real_each_game_finish (GamesGameSource* base, GAsyncResult* _res_) {
	GamesSteamGameSourceEachGameData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_data_->_task_complete_ = TRUE;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_object_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
}


static void games_steam_game_source_each_game_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GamesSteamGameSourceEachGameData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	games_steam_game_source_real_each_game_co (_data_);
}


static gboolean games_steam_game_source_real_each_game_co (GamesSteamGameSourceEachGameData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->self->priv->games;
	if (_data_->_tmp0_ == NULL) {
		_data_->_tmp1_ = g_str_hash;
		_data_->_tmp2_ = g_str_equal;
		_data_->_tmp3_ = g_hash_table_new_full (_data_->_tmp1_, _data_->_tmp2_, _g_free0_, _g_object_unref0_);
		_g_hash_table_unref0 (_data_->self->priv->games);
		_data_->self->priv->games = _data_->_tmp3_;
	}
	_data_->_tmp4_ = _data_->self->priv->libraries;
	_data_->_tmp4__length1 = _data_->self->priv->libraries_length1;
	{
		_data_->library_collection_length1 = 0;
		_data_->_library_collection_size_ = 0;
		_data_->library_collection = _data_->_tmp4_;
		_data_->library_collection_length1 = _data_->_tmp4__length1;
		for (_data_->library_it = 0; _data_->library_it < _data_->_tmp4__length1; _data_->library_it = _data_->library_it + 1) {
			_data_->_tmp5_ = g_strdup (_data_->library_collection[_data_->library_it]);
			_data_->library = _data_->_tmp5_;
			{
				{
					_data_->steamapps_dir_collection_length1 = 0;
					_data_->_steamapps_dir_collection_size_ = 0;
					_data_->steamapps_dir_collection = GAMES_STEAM_GAME_SOURCE_STEAMAPPS_DIRS;
					_data_->steamapps_dir_collection_length1 = G_N_ELEMENTS (GAMES_STEAM_GAME_SOURCE_STEAMAPPS_DIRS);
					for (_data_->steamapps_dir_it = 0; _data_->steamapps_dir_it < G_N_ELEMENTS (GAMES_STEAM_GAME_SOURCE_STEAMAPPS_DIRS); _data_->steamapps_dir_it = _data_->steamapps_dir_it + 1) {
						_data_->steamapps_dir = _data_->steamapps_dir_collection[_data_->steamapps_dir_it];
						{
							_data_->_tmp6_ = _data_->library;
							_data_->_tmp7_ = _data_->steamapps_dir;
							_data_->_tmp8_ = g_strconcat (_data_->_tmp6_, _data_->_tmp7_, NULL);
							_data_->_tmp9_ = _data_->_tmp8_;
							_data_->_state_ = 1;
							games_steam_game_source_each_game_in_steamapps_dir (_data_->self, _data_->_tmp9_, games_steam_game_source_each_game_ready, _data_);
							return FALSE;
							_state_1:
							games_steam_game_source_each_game_in_steamapps_dir_finish (_data_->self, _data_->_res_);
							_g_free0 (_data_->_tmp9_);
						}
					}
				}
				_g_free0 (_data_->library);
			}
		}
	}
	_data_->_tmp10_ = _data_->self->priv->games;
	_data_->_tmp11_ = g_hash_table_get_values (_data_->_tmp10_);
	{
		_data_->game_collection = _data_->_tmp11_;
		for (_data_->game_it = _data_->game_collection; _data_->game_it != NULL; _data_->game_it = _data_->game_it->next) {
			_data_->game = (GamesGame*) _data_->game_it->data;
			{
				_data_->_tmp12_ = _data_->game_callback;
				_data_->_tmp12__target = _data_->game_callback_target;
				_data_->_tmp13_ = _data_->game;
				_data_->_tmp12_ (_data_->_tmp13_, _data_->_tmp12__target);
			}
		}
		_g_list_free0 (_data_->game_collection);
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void games_steam_game_source_each_game_in_steamapps_dir_data_free (gpointer _data) {
	GamesSteamGameSourceEachGameInSteamappsDirData* _data_;
	_data_ = _data;
	_g_free0 (_data_->directory);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSteamGameSourceEachGameInSteamappsDirData, _data_);
}


void games_steam_game_source_each_game_in_steamapps_dir (GamesSteamGameSource* self, const gchar* directory, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesSteamGameSourceEachGameInSteamappsDirData* _data_;
	GamesSteamGameSource* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	_data_ = g_slice_new0 (GamesSteamGameSourceEachGameInSteamappsDirData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_steam_game_source_each_game_in_steamapps_dir_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = directory;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->directory);
	_data_->directory = _tmp2_;
	games_steam_game_source_each_game_in_steamapps_dir_co (_data_);
}


void games_steam_game_source_each_game_in_steamapps_dir_finish (GamesSteamGameSource* self, GAsyncResult* _res_) {
	GamesSteamGameSourceEachGameInSteamappsDirData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_data_->_task_complete_ = TRUE;
}


static void games_steam_game_source_each_game_in_steamapps_dir_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	GamesSteamGameSourceEachGameInSteamappsDirData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	_data_->_task_complete_ = TRUE;
	games_steam_game_source_each_game_in_steamapps_dir_co (_data_);
}


static gboolean games_steam_game_source_each_game_in_steamapps_dir_co (GamesSteamGameSourceEachGameInSteamappsDirData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_tmp0_ = _data_->directory;
		_data_->_tmp1_ = g_file_new_for_path (_data_->_tmp0_);
		_data_->file = _data_->_tmp1_;
		_data_->_tmp2_ = _data_->file;
		_data_->_state_ = 1;
		g_file_enumerate_children_async (_data_->_tmp2_, G_FILE_ATTRIBUTE_STANDARD_NAME, 0, G_PRIORITY_DEFAULT, NULL, games_steam_game_source_each_game_in_steamapps_dir_ready, _data_);
		return FALSE;
		_state_1:
		_data_->_tmp3_ = g_file_enumerate_children_finish (_data_->_tmp2_, _data_->_res_, &_data_->_inner_error_);
		_data_->enumerator = _data_->_tmp3_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_object_unref0 (_data_->file);
			goto __catch1_g_error;
		}
		while (TRUE) {
			_data_->_tmp5_ = _data_->enumerator;
			_data_->_tmp6_ = g_file_enumerator_next_file (_data_->_tmp5_, NULL, &_data_->_inner_error_);
			_data_->_tmp4_ = _data_->_tmp6_;
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				_g_object_unref0 (_data_->info);
				_g_object_unref0 (_data_->enumerator);
				_g_object_unref0 (_data_->file);
				goto __catch1_g_error;
			}
			_data_->_tmp7_ = _data_->_tmp4_;
			_data_->_tmp4_ = NULL;
			_g_object_unref0 (_data_->info);
			_data_->info = _data_->_tmp7_;
			_data_->_tmp8_ = _data_->info;
			if (!(_data_->_tmp8_ != NULL)) {
				_g_object_unref0 (_data_->_tmp4_);
				break;
			}
			_data_->_tmp9_ = _data_->directory;
			_data_->_tmp10_ = _data_->info;
			_data_->_state_ = 2;
			games_steam_game_source_game_for_file_info (_data_->self, _data_->_tmp9_, _data_->_tmp10_, games_steam_game_source_each_game_in_steamapps_dir_ready, _data_);
			return FALSE;
			_state_2:
			games_steam_game_source_game_for_file_info_finish (_data_->self, _data_->_res_);
			_g_object_unref0 (_data_->_tmp4_);
		}
		_g_object_unref0 (_data_->info);
		_g_object_unref0 (_data_->enumerator);
		_g_object_unref0 (_data_->file);
	}
	goto __finally1;
	__catch1_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->e);
	}
	__finally1:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void games_steam_game_source_game_for_file_info_data_free (gpointer _data) {
	GamesSteamGameSourceGameForFileInfoData* _data_;
	_data_ = _data;
	_g_free0 (_data_->directory);
	_g_object_unref0 (_data_->info);
	_g_object_unref0 (_data_->self);
	g_slice_free (GamesSteamGameSourceGameForFileInfoData, _data_);
}


void games_steam_game_source_game_for_file_info (GamesSteamGameSource* self, const gchar* directory, GFileInfo* info, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GamesSteamGameSourceGameForFileInfoData* _data_;
	GamesSteamGameSource* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GFileInfo* _tmp3_;
	GFileInfo* _tmp4_;
	_data_ = g_slice_new0 (GamesSteamGameSourceGameForFileInfoData);
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
	if (_callback_ == NULL) {
		_data_->_task_complete_ = TRUE;
	}
	g_task_set_task_data (_data_->_async_result, _data_, games_steam_game_source_game_for_file_info_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = directory;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->directory);
	_data_->directory = _tmp2_;
	_tmp3_ = info;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->info);
	_data_->info = _tmp4_;
	games_steam_game_source_game_for_file_info_co (_data_);
}


void games_steam_game_source_game_for_file_info_finish (GamesSteamGameSource* self, GAsyncResult* _res_) {
	GamesSteamGameSourceGameForFileInfoData* _data_;
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
	_data_->_task_complete_ = TRUE;
}


static const gchar* string_to_string (const gchar* self) {
	const gchar* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


static gboolean _games_steam_game_source_game_for_file_info_co_gsource_func (gpointer self) {
	gboolean result;
	result = games_steam_game_source_game_for_file_info_co (self);
	return result;
}


static gboolean games_steam_game_source_game_for_file_info_co (GamesSteamGameSourceGameForFileInfoData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->info;
	_data_->_tmp1_ = g_file_info_get_name (_data_->_tmp0_);
	_data_->_tmp2_ = g_strdup (_data_->_tmp1_);
	_data_->name = _data_->_tmp2_;
	_data_->_tmp3_ = games_steam_game_source_appmanifest_regex;
	_data_->_tmp4_ = _data_->name;
	_data_->_tmp5_ = g_regex_match (_data_->_tmp3_, _data_->_tmp4_, 0, NULL);
	if (_data_->_tmp5_) {
		{
			_data_->_tmp6_ = _data_->directory;
			_data_->_tmp7_ = string_to_string (_data_->_tmp6_);
			_data_->_tmp8_ = _data_->name;
			_data_->_tmp9_ = string_to_string (_data_->_tmp8_);
			_data_->_tmp10_ = g_strconcat (_data_->_tmp7_, "/", _data_->_tmp9_, NULL);
			_data_->_tmp11_ = _data_->_tmp10_;
			games_steam_game_source_game_for_appmanifest_path (_data_->self, _data_->_tmp11_, &_data_->_inner_error_);
			_g_free0 (_data_->_tmp11_);
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
			g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, _games_steam_game_source_game_for_file_info_co_gsource_func, _data_, NULL);
			_data_->_state_ = 1;
			return FALSE;
			_state_1:
			;
		}
		goto __finally2;
		__catch2_g_error:
		{
			_data_->e = _data_->_inner_error_;
			_data_->_inner_error_ = NULL;
			_data_->_tmp12_ = _data_->e;
			_data_->_tmp13_ = _data_->_tmp12_->message;
			g_warning ("steam-game-source.vala:85: %s\n", _data_->_tmp13_);
			_g_error_free0 (_data_->e);
		}
		__finally2:
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			_g_free0 (_data_->name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
			g_clear_error (&_data_->_inner_error_);
			return FALSE;
		}
	}
	_g_free0 (_data_->name);
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
	if (_data_->_state_ != 0) {
		while (_data_->_task_complete_ != TRUE) {
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
		}
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void games_steam_game_source_game_for_appmanifest_path (GamesSteamGameSource* self, const gchar* appmanifest_path, GError** error) {
	GamesSteamRegistry* registry;
	const gchar* _tmp0_;
	GamesSteamRegistry* _tmp1_;
	gchar* game_id;
	GamesSteamRegistry* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar** _tmp5_;
	gchar** _tmp6_;
	gint _tmp6__length1;
	gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	const gchar* _tmp16_;
	GHashTable* _tmp19_;
	const gchar* _tmp20_;
	gboolean _tmp21_;
	GamesSteamTitle* title;
	GamesSteamRegistry* _tmp22_;
	GamesSteamTitle* _tmp23_;
	GamesSteamIcon* icon;
	const gchar* _tmp24_;
	GamesSteamIcon* _tmp25_;
	GamesSteamCover* cover;
	const gchar* _tmp26_;
	GamesSteamCover* _tmp27_;
	gchar** args;
	gchar* _tmp28_;
	const gchar* _tmp29_;
	gchar* _tmp30_;
	gchar** _tmp31_;
	gint args_length1;
	gint _args_size_;
	GamesCommandRunner* runner;
	gchar** _tmp32_;
	gint _tmp32__length1;
	GamesCommandRunner* _tmp33_;
	GHashTable* _tmp34_;
	const gchar* _tmp35_;
	gchar* _tmp36_;
	GamesSteamTitle* _tmp37_;
	GamesSteamIcon* _tmp38_;
	GamesSteamCover* _tmp39_;
	GamesCommandRunner* _tmp40_;
	GamesGenericGame* _tmp41_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (appmanifest_path != NULL);
	_tmp0_ = appmanifest_path;
	_tmp1_ = games_steam_registry_new (_tmp0_, &_inner_error_);
	registry = _tmp1_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp2_ = registry;
	_tmp3_ = g_strdup ("AppState");
	_tmp4_ = g_strdup ("appid");
	_tmp5_ = g_new0 (gchar*, 2 + 1);
	_tmp5_[0] = _tmp3_;
	_tmp5_[1] = _tmp4_;
	_tmp6_ = _tmp5_;
	_tmp6__length1 = 2;
	_tmp7_ = games_steam_registry_get_data (_tmp2_, _tmp6_, 2);
	_tmp8_ = _tmp7_;
	_tmp6_ = (_vala_array_free (_tmp6_, _tmp6__length1, (GDestroyNotify) g_free), NULL);
	game_id = _tmp8_;
	_tmp9_ = game_id;
	if (_tmp9_ == NULL) {
		GamesSteamRegistry* _tmp10_;
		gchar* _tmp11_;
		gchar* _tmp12_;
		gchar** _tmp13_;
		gchar** _tmp14_;
		gint _tmp14__length1;
		gchar* _tmp15_;
		_tmp10_ = registry;
		_tmp11_ = g_strdup ("AppState");
		_tmp12_ = g_strdup ("appID");
		_tmp13_ = g_new0 (gchar*, 2 + 1);
		_tmp13_[0] = _tmp11_;
		_tmp13_[1] = _tmp12_;
		_tmp14_ = _tmp13_;
		_tmp14__length1 = 2;
		_tmp15_ = games_steam_registry_get_data (_tmp10_, _tmp14_, 2);
		_g_free0 (game_id);
		game_id = _tmp15_;
		_tmp14_ = (_vala_array_free (_tmp14_, _tmp14__length1, (GDestroyNotify) g_free), NULL);
	}
	_tmp16_ = game_id;
	if (_tmp16_ == NULL) {
		const gchar* _tmp17_;
		GError* _tmp18_;
		_tmp17_ = appmanifest_path;
		_tmp18_ = g_error_new (GAMES_STEAM_ERROR, GAMES_STEAM_ERROR_NO_APPID, _ ("Couldn’t get Steam appid from manifest “%s”."), _tmp17_);
		_inner_error_ = _tmp18_;
		g_propagate_error (error, _inner_error_);
		_g_free0 (game_id);
		_games_steam_registry_unref0 (registry);
		return;
	}
	_tmp19_ = self->priv->games;
	_tmp20_ = game_id;
	_tmp21_ = g_hash_table_contains (_tmp19_, _tmp20_);
	if (_tmp21_) {
		_g_free0 (game_id);
		_games_steam_registry_unref0 (registry);
		return;
	}
	_tmp22_ = registry;
	_tmp23_ = games_steam_title_new (_tmp22_);
	title = _tmp23_;
	_tmp24_ = game_id;
	_tmp25_ = games_steam_icon_new (_tmp24_);
	icon = _tmp25_;
	_tmp26_ = game_id;
	_tmp27_ = games_steam_cover_new (_tmp26_);
	cover = _tmp27_;
	_tmp28_ = g_strdup ("steam");
	_tmp29_ = game_id;
	_tmp30_ = g_strconcat ("steam://rungameid/", _tmp29_, NULL);
	_tmp31_ = g_new0 (gchar*, 2 + 1);
	_tmp31_[0] = _tmp28_;
	_tmp31_[1] = _tmp30_;
	args = _tmp31_;
	args_length1 = 2;
	_args_size_ = args_length1;
	_tmp32_ = args;
	_tmp32__length1 = args_length1;
	_tmp33_ = games_command_runner_new (_tmp32_, _tmp32__length1, FALSE);
	runner = _tmp33_;
	_tmp34_ = self->priv->games;
	_tmp35_ = game_id;
	_tmp36_ = g_strdup (_tmp35_);
	_tmp37_ = title;
	_tmp38_ = icon;
	_tmp39_ = cover;
	_tmp40_ = runner;
	_tmp41_ = games_generic_game_new ((GamesTitle*) _tmp37_, (GamesIcon*) _tmp38_, (GamesCover*) _tmp39_, (GamesRunner*) _tmp40_);
	g_hash_table_insert (_tmp34_, _tmp36_, (GamesGame*) _tmp41_);
	_g_object_unref0 (runner);
	args = (_vala_array_free (args, args_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (cover);
	_g_object_unref0 (icon);
	_g_object_unref0 (title);
	_g_free0 (game_id);
	_games_steam_registry_unref0 (registry);
}


static void games_steam_game_source_class_init (GamesSteamGameSourceClass * klass) {
	games_steam_game_source_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesSteamGameSourcePrivate));
	G_OBJECT_CLASS (klass)->finalize = games_steam_game_source_finalize;
}


static void games_steam_game_source_games_game_source_interface_init (GamesGameSourceIface * iface) {
	games_steam_game_source_games_game_source_parent_iface = g_type_interface_peek_parent (iface);
	iface->each_game = (void (*) (GamesGameSource *, GamesGameCallback, void*)) games_steam_game_source_real_each_game;
	iface->each_game_finish = games_steam_game_source_real_each_game_finish;
}


static void games_steam_game_source_instance_init (GamesSteamGameSource * self) {
	self->priv = GAMES_STEAM_GAME_SOURCE_GET_PRIVATE (self);
}


static void games_steam_game_source_finalize (GObject * obj) {
	GamesSteamGameSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_STEAM_GAME_SOURCE, GamesSteamGameSource);
	self->priv->libraries = (_vala_array_free (self->priv->libraries, self->priv->libraries_length1, (GDestroyNotify) g_free), NULL);
	_g_hash_table_unref0 (self->priv->games);
	G_OBJECT_CLASS (games_steam_game_source_parent_class)->finalize (obj);
}


GType games_steam_game_source_get_type (void) {
	return games_steam_game_source_type_id;
}


GType games_steam_game_source_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesSteamGameSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_steam_game_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesSteamGameSource), 0, (GInstanceInitFunc) games_steam_game_source_instance_init, NULL };
	static const GInterfaceInfo games_game_source_info = { (GInterfaceInitFunc) games_steam_game_source_games_game_source_interface_init, (GInterfaceFinalizeFunc) NULL, NULL};
	games_steam_game_source_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesSteamGameSource", &g_define_type_info, 0);
	g_type_module_add_interface (module, games_steam_game_source_type_id, GAMES_TYPE_GAME_SOURCE, &games_game_source_info);
	return games_steam_game_source_type_id;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



