/* playstation-header.c generated by valac 0.35.5, the Vala compiler
 * generated from playstation-header.vala, do not modify */

/* This file is part of GNOME Games. License: GPLv3*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <libgnome-games.h>


#define GAMES_TYPE_PLAY_STATION_HEADER (games_play_station_header_get_type ())
#define GAMES_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader))
#define GAMES_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))
#define GAMES_IS_PLAY_STATION_HEADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_IS_PLAY_STATION_HEADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), GAMES_TYPE_PLAY_STATION_HEADER))
#define GAMES_PLAY_STATION_HEADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderClass))

typedef struct _GamesPlayStationHeader GamesPlayStationHeader;
typedef struct _GamesPlayStationHeaderClass GamesPlayStationHeaderClass;
typedef struct _GamesPlayStationHeaderPrivate GamesPlayStationHeaderPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _GamesPlayStationHeader {
	GObject parent_instance;
	GamesPlayStationHeaderPrivate * priv;
};

struct _GamesPlayStationHeaderClass {
	GObjectClass parent_class;
};

struct _GamesPlayStationHeaderPrivate {
	gchar* _disc_id;
	GFile* file;
};

typedef enum  {
	GAMES_PLAY_STATION_ERROR_INVALID_HEADER
} GamesPlayStationError;
#define GAMES_PLAY_STATION_ERROR games_play_station_error_quark ()

static gpointer games_play_station_header_parent_class = NULL;
static GRegex* games_play_station_header_disc_id_regex;
static GRegex* games_play_station_header_disc_id_regex = NULL;
static GType games_play_station_header_type_id = 0;

GType games_play_station_header_get_type (void) G_GNUC_CONST;
#define GAMES_PLAY_STATION_HEADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeaderPrivate))
enum  {
	GAMES_PLAY_STATION_HEADER_DUMMY_PROPERTY,
	GAMES_PLAY_STATION_HEADER_DISC_ID
};
#define GAMES_PLAY_STATION_HEADER_HEADER_TITLE_OFFSET ((gsize) 0x20)
#define GAMES_PLAY_STATION_HEADER_HEADER_MAGIC_VALUE "PLAYSTATION"
#define GAMES_PLAY_STATION_HEADER_BOOT_MAGIC_VALUE "BOOT"
#define GAMES_PLAY_STATION_HEADER_DISC_ID_SIZE ((gsize) 10)
GamesPlayStationHeader* games_play_station_header_new (GFile* file);
GamesPlayStationHeader* games_play_station_header_construct (GType object_type, GFile* file);
void games_play_station_header_check_validity (GamesPlayStationHeader* self, GError** error);
static gchar* games_play_station_header_get_id_from_boot (GamesPlayStationHeader* self, GError** error);
static gchar* games_play_station_header_search_id_in_header (GamesPlayStationHeader* self, GError** error);
GQuark games_play_station_error_quark (void);
static gsize* games_play_station_header_get_header_offset (GamesPlayStationHeader* self, GError** error);
static gboolean games_play_station_header_is_a_disc_id (const gchar* disc_id);
static gsize* _size_t_dup (gsize* self);
static gsize* games_play_station_header_get_boot_offset (GamesPlayStationHeader* self, GError** error);
const gchar* games_play_station_header_get_disc_id (GamesPlayStationHeader* self);
static void games_play_station_header_finalize (GObject * obj);
static void _vala_games_play_station_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const gsize GAMES_PLAY_STATION_HEADER_HEADER_OFFSETS[3] = {(gsize) 0x85D2, (gsize) 0x9320, (gsize) 0x9360};
static const gsize GAMES_PLAY_STATION_HEADER_BOOT_OFFSETS[4] = {(gsize) 0xBE64, (gsize) 0xD368, (gsize) 0xD3A8, (gsize) 0xA9F98};
static const gchar* GAMES_PLAY_STATION_HEADER_IDS[7] = {"SLUS", "SCUS", "SLES", "SCES", "SLPS", "SLPM", "SCPS"};
static GRegex* _tmp_regex_0 = NULL;

static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


GamesPlayStationHeader* games_play_station_header_construct (GType object_type, GFile* file) {
	GamesPlayStationHeader * self = NULL;
	GFile* _tmp0_;
	GFile* _tmp1_;
	g_return_val_if_fail (file != NULL, NULL);
	self = (GamesPlayStationHeader*) g_object_new (object_type, NULL);
	_tmp0_ = file;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->priv->file);
	self->priv->file = _tmp1_;
	return self;
}


GamesPlayStationHeader* games_play_station_header_new (GFile* file) {
	return games_play_station_header_construct (GAMES_TYPE_PLAY_STATION_HEADER, file);
}


void games_play_station_header_check_validity (GamesPlayStationHeader* self, GError** error) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	const gchar* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _tmp12_;
	GError* _tmp13_;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_disc_id;
	if (_tmp0_ != NULL) {
		return;
	}
	_tmp2_ = games_play_station_header_get_id_from_boot (self, &_inner_error_);
	_tmp1_ = _tmp2_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp3_ = _tmp1_;
	_tmp1_ = NULL;
	_g_free0 (self->priv->_disc_id);
	self->priv->_disc_id = _tmp3_;
	_tmp4_ = self->priv->_disc_id;
	if (_tmp4_ != NULL) {
		_g_free0 (_tmp1_);
		return;
	}
	_tmp6_ = games_play_station_header_search_id_in_header (self, &_inner_error_);
	_tmp5_ = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (_tmp1_);
		return;
	}
	_tmp7_ = _tmp5_;
	_tmp5_ = NULL;
	_g_free0 (self->priv->_disc_id);
	self->priv->_disc_id = _tmp7_;
	_tmp8_ = self->priv->_disc_id;
	if (_tmp8_ != NULL) {
		_g_free0 (_tmp5_);
		_g_free0 (_tmp1_);
		return;
	}
	_tmp9_ = self->priv->file;
	_tmp10_ = g_file_get_uri (_tmp9_);
	_tmp11_ = _tmp10_;
	_tmp12_ = g_error_new (GAMES_PLAY_STATION_ERROR, GAMES_PLAY_STATION_ERROR_INVALID_HEADER, _ ("Invalid PlayStation header: disc ID not found in “%s”."), _tmp11_);
	_tmp13_ = _tmp12_;
	_g_free0 (_tmp11_);
	_inner_error_ = _tmp13_;
	g_propagate_error (error, _inner_error_);
	_g_free0 (_tmp5_);
	_g_free0 (_tmp1_);
	return;
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	if ((*((gchar*) self)) == '\0') {
		_tmp1_ = TRUE;
	} else {
		const gchar* _tmp2_;
		_tmp2_ = old;
		_tmp1_ = (*((gchar*) _tmp2_)) == '\0';
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		const gchar* _tmp3_;
		const gchar* _tmp4_;
		_tmp3_ = old;
		_tmp4_ = replacement;
		_tmp0_ = g_strcmp0 (_tmp3_, _tmp4_) == 0;
	}
	if (_tmp0_) {
		gchar* _tmp5_;
		_tmp5_ = g_strdup (self);
		result = _tmp5_;
		return result;
	}
	{
		GRegex* regex;
		const gchar* _tmp6_;
		gchar* _tmp7_;
		gchar* _tmp8_;
		GRegex* _tmp9_;
		GRegex* _tmp10_;
		gchar* _tmp11_;
		GRegex* _tmp12_;
		const gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		_tmp6_ = old;
		_tmp7_ = g_regex_escape_string (_tmp6_, -1);
		_tmp8_ = _tmp7_;
		_tmp9_ = g_regex_new (_tmp8_, 0, 0, &_inner_error_);
		_tmp10_ = _tmp9_;
		_g_free0 (_tmp8_);
		regex = _tmp10_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp12_ = regex;
		_tmp13_ = replacement;
		_tmp14_ = g_regex_replace_literal (_tmp12_, self, (gssize) -1, 0, _tmp13_, 0, &_inner_error_);
		_tmp11_ = _tmp14_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch5_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp15_ = _tmp11_;
		_tmp11_ = NULL;
		result = _tmp15_;
		_g_free0 (_tmp11_);
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally5;
	__catch5_g_regex_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static gchar* games_play_station_header_search_id_in_header (GamesPlayStationHeader* self, GError** error) {
	gchar* result = NULL;
	gsize* offset;
	gsize* _tmp0_;
	gsize* _tmp1_;
	GamesStringInputStream* stream;
	GFile* _tmp2_;
	GamesStringInputStream* _tmp3_;
	gchar* header;
	GamesStringInputStream* _tmp4_;
	gsize* _tmp5_;
	gchar* _tmp6_;
	gchar* raw_id;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	const gchar* _tmp9_;
	gchar* _tmp10_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_play_station_header_get_header_offset (self, &_inner_error_);
	offset = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = offset;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (offset);
		return result;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = games_string_input_stream_new (_tmp2_);
	stream = _tmp3_;
	_tmp4_ = stream;
	_tmp5_ = offset;
	_tmp6_ = games_string_input_stream_read_string_for_size (_tmp4_, (*_tmp5_) + GAMES_PLAY_STATION_HEADER_HEADER_TITLE_OFFSET, GAMES_PLAY_STATION_HEADER_DISC_ID_SIZE, &_inner_error_);
	header = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		_g_free0 (offset);
		return NULL;
	}
	_tmp7_ = header;
	_tmp8_ = g_utf8_strup (_tmp7_, (gssize) -1);
	raw_id = _tmp8_;
	_tmp9_ = raw_id;
	_tmp10_ = string_replace (_tmp9_, "_", "-");
	_g_free0 (raw_id);
	raw_id = _tmp10_;
	{
		const gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = GAMES_PLAY_STATION_HEADER_IDS;
		id_collection_length1 = G_N_ELEMENTS (GAMES_PLAY_STATION_HEADER_IDS);
		for (id_it = 0; id_it < G_N_ELEMENTS (GAMES_PLAY_STATION_HEADER_IDS); id_it = id_it + 1) {
			const gchar* id = NULL;
			id = id_collection[id_it];
			{
				const gchar* _tmp11_;
				const gchar* _tmp12_;
				gboolean _tmp13_;
				const gchar* _tmp14_;
				gboolean _tmp15_;
				_tmp11_ = header;
				_tmp12_ = id;
				_tmp13_ = string_contains (_tmp11_, _tmp12_);
				if (!_tmp13_) {
					continue;
				}
				_tmp14_ = raw_id;
				_tmp15_ = games_play_station_header_is_a_disc_id (_tmp14_);
				if (_tmp15_) {
					result = raw_id;
					_g_free0 (header);
					_g_object_unref0 (stream);
					_g_free0 (offset);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_free0 (raw_id);
	_g_free0 (header);
	_g_object_unref0 (stream);
	_g_free0 (offset);
	return result;
}


static gsize* _size_t_dup (gsize* self) {
	gsize* dup;
	dup = g_new0 (gsize, 1);
	memcpy (dup, self, sizeof (gsize));
	return dup;
}


static gpointer __size_t_dup0 (gpointer self) {
	return self ? _size_t_dup (self) : NULL;
}


static gsize* games_play_station_header_get_header_offset (GamesPlayStationHeader* self, GError** error) {
	gsize* result = NULL;
	GamesStringInputStream* stream;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	{
		gsize* offset_collection = NULL;
		gint offset_collection_length1 = 0;
		gint _offset_collection_size_ = 0;
		gint offset_it = 0;
		offset_collection = GAMES_PLAY_STATION_HEADER_HEADER_OFFSETS;
		offset_collection_length1 = G_N_ELEMENTS (GAMES_PLAY_STATION_HEADER_HEADER_OFFSETS);
		for (offset_it = 0; offset_it < G_N_ELEMENTS (GAMES_PLAY_STATION_HEADER_HEADER_OFFSETS); offset_it = offset_it + 1) {
			gsize offset = 0UL;
			offset = offset_collection[offset_it];
			{
				gboolean _tmp2_;
				GamesStringInputStream* _tmp3_;
				gsize _tmp4_;
				gboolean _tmp5_;
				_tmp3_ = stream;
				_tmp4_ = offset;
				_tmp5_ = games_string_input_stream_has_string (_tmp3_, _tmp4_, GAMES_PLAY_STATION_HEADER_HEADER_MAGIC_VALUE, &_inner_error_);
				_tmp2_ = _tmp5_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (stream);
					return NULL;
				}
				if (_tmp2_) {
					gsize _tmp6_;
					gsize* _tmp7_;
					_tmp6_ = offset;
					_tmp7_ = __size_t_dup0 (&_tmp6_);
					result = _tmp7_;
					_g_object_unref0 (stream);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (stream);
	return result;
}


static gchar* games_play_station_header_get_id_from_boot (GamesPlayStationHeader* self, GError** error) {
	gchar* result = NULL;
	gsize* offset;
	gsize* _tmp0_;
	gsize* _tmp1_;
	GamesStringInputStream* stream;
	GFile* _tmp2_;
	GamesStringInputStream* _tmp3_;
	gchar* header;
	GamesStringInputStream* _tmp4_;
	gsize* _tmp5_;
	gchar* _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = games_play_station_header_get_boot_offset (self, &_inner_error_);
	offset = _tmp0_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		return NULL;
	}
	_tmp1_ = offset;
	if (_tmp1_ == NULL) {
		result = NULL;
		_g_free0 (offset);
		return result;
	}
	_tmp2_ = self->priv->file;
	_tmp3_ = games_string_input_stream_new (_tmp2_);
	stream = _tmp3_;
	_tmp4_ = stream;
	_tmp5_ = offset;
	_tmp6_ = games_string_input_stream_read_string (_tmp4_, *_tmp5_, &_inner_error_);
	header = _tmp6_;
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_propagate_error (error, _inner_error_);
		_g_object_unref0 (stream);
		_g_free0 (offset);
		return NULL;
	}
	_tmp7_ = header;
	_tmp8_ = g_utf8_strup (_tmp7_, (gssize) -1);
	_g_free0 (header);
	header = _tmp8_;
	{
		const gchar** id_collection = NULL;
		gint id_collection_length1 = 0;
		gint _id_collection_size_ = 0;
		gint id_it = 0;
		id_collection = GAMES_PLAY_STATION_HEADER_IDS;
		id_collection_length1 = G_N_ELEMENTS (GAMES_PLAY_STATION_HEADER_IDS);
		for (id_it = 0; id_it < G_N_ELEMENTS (GAMES_PLAY_STATION_HEADER_IDS); id_it = id_it + 1) {
			const gchar* id = NULL;
			id = id_collection[id_it];
			{
				const gchar* _tmp9_;
				const gchar* _tmp10_;
				gboolean _tmp11_;
				gchar* raw_id;
				const gchar* _tmp12_;
				const gchar* _tmp13_;
				gchar** _tmp14_;
				gchar** _tmp15_;
				gchar** _tmp16_;
				gint _tmp16__length1;
				const gchar* _tmp17_;
				gchar* _tmp18_;
				gchar* _tmp19_;
				const gchar* _tmp20_;
				gchar** _tmp21_;
				gchar** _tmp22_;
				gchar** _tmp23_;
				gint _tmp23__length1;
				const gchar* _tmp24_;
				gchar* _tmp25_;
				const gchar* _tmp26_;
				gchar* _tmp27_;
				const gchar* _tmp28_;
				gchar* _tmp29_;
				const gchar* _tmp30_;
				const gchar* _tmp31_;
				gchar* _tmp32_;
				gchar* _tmp33_;
				gchar* _tmp34_;
				const gchar* _tmp35_;
				gboolean _tmp36_;
				_tmp9_ = header;
				_tmp10_ = id;
				_tmp11_ = string_contains (_tmp9_, _tmp10_);
				if (!_tmp11_) {
					continue;
				}
				_tmp12_ = header;
				_tmp13_ = id;
				_tmp15_ = _tmp14_ = g_strsplit (_tmp12_, _tmp13_, 0);
				_tmp16_ = _tmp15_;
				_tmp16__length1 = _vala_array_length (_tmp14_);
				_tmp17_ = _tmp16_[1];
				_tmp18_ = g_strdup (_tmp17_);
				_tmp19_ = _tmp18_;
				_tmp16_ = (_vala_array_free (_tmp16_, _tmp16__length1, (GDestroyNotify) g_free), NULL);
				raw_id = _tmp19_;
				_tmp20_ = raw_id;
				_tmp22_ = _tmp21_ = g_strsplit (_tmp20_, ";", 0);
				_tmp23_ = _tmp22_;
				_tmp23__length1 = _vala_array_length (_tmp21_);
				_tmp24_ = _tmp23_[0];
				_tmp25_ = g_strdup (_tmp24_);
				_g_free0 (raw_id);
				raw_id = _tmp25_;
				_tmp23_ = (_vala_array_free (_tmp23_, _tmp23__length1, (GDestroyNotify) g_free), NULL);
				_tmp26_ = raw_id;
				_tmp27_ = string_replace (_tmp26_, "_", "-");
				_g_free0 (raw_id);
				raw_id = _tmp27_;
				_tmp28_ = raw_id;
				_tmp29_ = string_replace (_tmp28_, ".", "");
				_g_free0 (raw_id);
				raw_id = _tmp29_;
				_tmp30_ = id;
				_tmp31_ = raw_id;
				_tmp32_ = g_strconcat (_tmp30_, _tmp31_, NULL);
				_tmp33_ = _tmp32_;
				_tmp34_ = g_utf8_strup (_tmp33_, (gssize) -1);
				_g_free0 (raw_id);
				raw_id = _tmp34_;
				_g_free0 (_tmp33_);
				_tmp35_ = raw_id;
				_tmp36_ = games_play_station_header_is_a_disc_id (_tmp35_);
				if (_tmp36_) {
					result = raw_id;
					_g_free0 (header);
					_g_object_unref0 (stream);
					_g_free0 (offset);
					return result;
				}
				_g_free0 (raw_id);
			}
		}
	}
	result = NULL;
	_g_free0 (header);
	_g_object_unref0 (stream);
	_g_free0 (offset);
	return result;
}


static gsize* games_play_station_header_get_boot_offset (GamesPlayStationHeader* self, GError** error) {
	gsize* result = NULL;
	GamesStringInputStream* stream;
	GFile* _tmp0_;
	GamesStringInputStream* _tmp1_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->file;
	_tmp1_ = games_string_input_stream_new (_tmp0_);
	stream = _tmp1_;
	{
		gsize* offset_collection = NULL;
		gint offset_collection_length1 = 0;
		gint _offset_collection_size_ = 0;
		gint offset_it = 0;
		offset_collection = GAMES_PLAY_STATION_HEADER_BOOT_OFFSETS;
		offset_collection_length1 = G_N_ELEMENTS (GAMES_PLAY_STATION_HEADER_BOOT_OFFSETS);
		for (offset_it = 0; offset_it < G_N_ELEMENTS (GAMES_PLAY_STATION_HEADER_BOOT_OFFSETS); offset_it = offset_it + 1) {
			gsize offset = 0UL;
			offset = offset_collection[offset_it];
			{
				gboolean _tmp2_;
				GamesStringInputStream* _tmp3_;
				gsize _tmp4_;
				gboolean _tmp5_;
				_tmp3_ = stream;
				_tmp4_ = offset;
				_tmp5_ = games_string_input_stream_has_string (_tmp3_, _tmp4_, GAMES_PLAY_STATION_HEADER_BOOT_MAGIC_VALUE, &_inner_error_);
				_tmp2_ = _tmp5_;
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					g_propagate_error (error, _inner_error_);
					_g_object_unref0 (stream);
					return NULL;
				}
				if (_tmp2_) {
					gsize _tmp6_;
					gsize* _tmp7_;
					_tmp6_ = offset;
					_tmp7_ = __size_t_dup0 (&_tmp6_);
					result = _tmp7_;
					_g_object_unref0 (stream);
					return result;
				}
			}
		}
	}
	result = NULL;
	_g_object_unref0 (stream);
	return result;
}


static inline GRegex* _thread_safe_regex_init (GRegex** re, const gchar * pattern, GRegexMatchFlags match_options) {
	if (g_once_init_enter ((volatile gsize*) re)) {
		GRegex* val = g_regex_new (pattern, match_options, 0, NULL);
		g_once_init_leave ((volatile gsize*) re, (gsize) val);
	}
	return *re;
}


static gpointer _g_regex_ref0 (gpointer self) {
	return self ? g_regex_ref (self) : NULL;
}


static gboolean games_play_station_header_is_a_disc_id (const gchar* disc_id) {
	gboolean result = FALSE;
	GRegex* _tmp0_;
	GRegex* _tmp2_;
	const gchar* _tmp3_;
	gboolean _tmp4_;
	g_return_val_if_fail (disc_id != NULL, FALSE);
	_tmp0_ = games_play_station_header_disc_id_regex;
	if (_tmp0_ == NULL) {
		GRegex* _tmp1_;
		_tmp1_ = _g_regex_ref0 (_thread_safe_regex_init (&_tmp_regex_0, "[A-Z]{4}-\\d{5}", 0));
		_g_regex_unref0 (games_play_station_header_disc_id_regex);
		games_play_station_header_disc_id_regex = _tmp1_;
	}
	_tmp2_ = games_play_station_header_disc_id_regex;
	_tmp3_ = disc_id;
	_tmp4_ = g_regex_match (_tmp2_, _tmp3_, 0, NULL);
	result = _tmp4_;
	return result;
}


const gchar* games_play_station_header_get_disc_id (GamesPlayStationHeader* self) {
	const gchar* result;
	const gchar* _tmp0_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_disc_id;
	result = _tmp0_;
	return result;
}


static void games_play_station_header_class_init (GamesPlayStationHeaderClass * klass) {
	games_play_station_header_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GamesPlayStationHeaderPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_games_play_station_header_get_property;
	G_OBJECT_CLASS (klass)->finalize = games_play_station_header_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GAMES_PLAY_STATION_HEADER_DISC_ID, g_param_spec_string ("disc-id", "disc-id", "disc-id", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
}


static void games_play_station_header_instance_init (GamesPlayStationHeader * self) {
	self->priv = GAMES_PLAY_STATION_HEADER_GET_PRIVATE (self);
}


static void games_play_station_header_finalize (GObject * obj) {
	GamesPlayStationHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader);
	_g_free0 (self->priv->_disc_id);
	_g_object_unref0 (self->priv->file);
	G_OBJECT_CLASS (games_play_station_header_parent_class)->finalize (obj);
}


GType games_play_station_header_get_type (void) {
	return games_play_station_header_type_id;
}


GType games_play_station_header_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (GamesPlayStationHeaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) games_play_station_header_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GamesPlayStationHeader), 0, (GInstanceInitFunc) games_play_station_header_instance_init, NULL };
	games_play_station_header_type_id = g_type_module_register_type (module, G_TYPE_OBJECT, "GamesPlayStationHeader", &g_define_type_info, 0);
	return games_play_station_header_type_id;
}


static void _vala_games_play_station_header_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GamesPlayStationHeader * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, GAMES_TYPE_PLAY_STATION_HEADER, GamesPlayStationHeader);
	switch (property_id) {
		case GAMES_PLAY_STATION_HEADER_DISC_ID:
		g_value_set_string (value, games_play_station_header_get_disc_id (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



