//  
//  Copyright (C) 2009 GNOME Do
// 
//  This program is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 3 of the License, or
//  (at your option) any later version.
// 
//  This program is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
//  GNU General Public License for more details.
// 
//  You should have received a copy of the GNU General Public License
//  along with this program.  If not, see <http://www.gnu.org/licenses/>.
// 

using System;
using Mono.Unix;

namespace WeatherDocklet
{
	/// <summary>
	/// Stores information about one day's weather forecast.
	/// </summary>
	public struct WeatherForecast
	{
		/// <summary>
		/// The high value for the forecast day.
		/// </summary>
		public int high;
		
		/// <summary>
		/// The low value for the forecast day.
		/// </summary>
		public int low;
		
		/// <summary>
		/// The day of the week (3 char string, ex: Mon, Tue, etc).
		/// </summary>
		public string dow;
		
		/// <summary>
		/// The condition for the forecast day.
		/// </summary>
		public string condition;
		
		/// <summary>
		/// An icon name representing the condition for the forecast day.
		/// </summary>
		public string image;
		
		/// <summary>
		/// Takes a short name for a day and returns the full name.
		/// </summary>
		/// <param name="reloadImmediately">
		/// A <see cref="System.string"/> indicating the short name for the day.
		/// </param>
		/// <returns>
		/// A <see cref="System.string"/> of the day's full name.
		/// </returns>
		public static string DayName (string dow)
		{
			if (dow.Equals ("Mon"))
				return Catalog.GetString ("Monday");
			if (dow.Equals ("Tue"))
				return Catalog.GetString ("Tuesday");
			if (dow.Equals ("Wed"))
				return Catalog.GetString ("Wednesday");
			if (dow.Equals ("Thu"))
				return Catalog.GetString ("Thursday");
			if (dow.Equals ("Fri"))
				return Catalog.GetString ("Friday");
			if (dow.Equals ("Sat"))
				return Catalog.GetString ("Saturday");
			if (dow.Equals ("Sun"))
				return Catalog.GetString ("Sunday");
			return Catalog.GetString ("Unknown");
		}
	}
}
