/* chess-game.c generated by valac 0.35.7.12-e874b, the Vala compiler
 * generated from chess-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2014 Robert Ancell
 * Copyright (C) 2015-2016 Sahil Sareen
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 3 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <glib/gi18n-lib.h>


#define TYPE_CHESS_RESULT (chess_result_get_type ())

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
#define __g_list_free__g_object_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_object_unref0_ (var), NULL)))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessStatePrivate ChessStatePrivate;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_COLOR (color_get_type ())
enum  {
	CHESS_GAME_TURN_STARTED_SIGNAL,
	CHESS_GAME_MOVED_SIGNAL,
	CHESS_GAME_PAUSED_SIGNAL,
	CHESS_GAME_UNPAUSED_SIGNAL,
	CHESS_GAME_UNDO_SIGNAL,
	CHESS_GAME_ENDED_SIGNAL,
	CHESS_GAME_LAST_SIGNAL
};
static guint chess_game_signals[CHESS_GAME_LAST_SIGNAL] = {0};

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

typedef enum  {
	CHESS_RULE_UNKNOWN,
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_SEVENTY_FIVE_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_FIVE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

struct _ChessGame {
	GObject parent_instance;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GObjectClass parent_class;
};

struct _ChessGamePrivate {
	gint hold_count;
	gboolean _is_paused;
	gboolean _should_show_paused_overlay;
	ChessClock* _clock;
};

typedef enum  {
	PGN_ERROR_LOAD_ERROR
} PGNError;
#define PGN_ERROR pgn_error_quark ()
typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessState {
	GObject parent_instance;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GObjectClass parent_class;
};

struct _ChessMove {
	GObject parent_instance;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GObjectClass parent_class;
};

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};


static gpointer chess_game_parent_class = NULL;

GType chess_result_get_type (void) G_GNUC_CONST;
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_game_get_type (void) G_GNUC_CONST;
GType chess_state_get_type (void) G_GNUC_CONST;
GType chess_clock_get_type (void) G_GNUC_CONST;
#define CHESS_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_GAME, ChessGamePrivate))
enum  {
	CHESS_GAME_DUMMY_PROPERTY,
	CHESS_GAME_IS_PAUSED,
	CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY,
	CHESS_GAME_CURRENT_STATE,
	CHESS_GAME_WHITE,
	CHESS_GAME_BLACK,
	CHESS_GAME_CURRENT_PLAYER,
	CHESS_GAME_OPPONENT,
	CHESS_GAME_CLOCK,
	CHESS_GAME_N_MOVES
};
void chess_clock_stop (ChessClock* self);
static void _g_object_unref0_ (gpointer var);
static void _g_list_free__g_object_unref0_ (GList* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
GQuark pgn_error_quark (void);
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1, GError** error);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1, GError** error);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
GType chess_player_get_type (void) G_GNUC_CONST;
static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self);
static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player);
static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self);
static void chess_game_claim_draw_cb (ChessGame* self);
static void _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self);
ChessPlayer* chess_game_get_black (ChessGame* self);
ChessState* chess_game_get_current_state (ChessGame* self);
ChessState* chess_state_copy (ChessState* self);
GType check_state_get_type (void) G_GNUC_CONST;
GType chess_piece_get_type (void) G_GNUC_CONST;
GType chess_move_get_type (void) G_GNUC_CONST;
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static void chess_game_complete_move (ChessGame* self);
void chess_game_add_hold (ChessGame* self);
void chess_game_remove_hold (ChessGame* self);
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
gboolean chess_game_is_five_fold_repeat (ChessGame* self);
gboolean chess_game_is_seventy_five_move_rule_fulfilled (ChessGame* self);
GType color_get_type (void) G_GNUC_CONST;
void chess_clock_set_active_color (ChessClock* self, Color value);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1);
gboolean chess_state_equals (ChessState* self, ChessState* state);
static gboolean chess_game_is_n_fold_repeat (ChessGame* self, gint n);
gboolean chess_game_is_three_fold_repeat (ChessGame* self);
gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self);
gboolean chess_game_can_claim_draw (ChessGame* self);
void chess_game_start (ChessGame* self);
static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock);
static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
void chess_game_pause (ChessGame* self, gboolean show_overlay);
ChessClock* chess_game_get_clock (ChessGame* self);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_clock_pause (ChessClock* self);
static void chess_game_set_is_paused (ChessGame* self, gboolean value);
static void chess_game_set_should_show_paused_overlay (ChessGame* self, gboolean value);
void chess_game_unpause (ChessGame* self);
void chess_clock_unpause (ChessClock* self);
gboolean chess_game_get_should_show_paused_overlay (ChessGame* self);
ChessPlayer* chess_state_get_opponent (ChessState* self);
void chess_game_set_clock (ChessGame* self, ChessClock* value);
guint chess_game_get_n_moves (ChessGame* self);
static void chess_game_finalize (GObject * obj);
static void _vala_chess_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GType chess_result_get_type (void) {
	static volatile gsize chess_result_type_id__volatile = 0;
	if (g_once_init_enter (&chess_result_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RESULT_IN_PROGRESS, "CHESS_RESULT_IN_PROGRESS", "in-progress"}, {CHESS_RESULT_WHITE_WON, "CHESS_RESULT_WHITE_WON", "white-won"}, {CHESS_RESULT_BLACK_WON, "CHESS_RESULT_BLACK_WON", "black-won"}, {CHESS_RESULT_DRAW, "CHESS_RESULT_DRAW", "draw"}, {CHESS_RESULT_BUG, "CHESS_RESULT_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_result_type_id;
		chess_result_type_id = g_enum_register_static ("ChessResult", values);
		g_once_init_leave (&chess_result_type_id__volatile, chess_result_type_id);
	}
	return chess_result_type_id__volatile;
}


GType chess_rule_get_type (void) {
	static volatile gsize chess_rule_type_id__volatile = 0;
	if (g_once_init_enter (&chess_rule_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RULE_UNKNOWN, "CHESS_RULE_UNKNOWN", "unknown"}, {CHESS_RULE_CHECKMATE, "CHESS_RULE_CHECKMATE", "checkmate"}, {CHESS_RULE_STALEMATE, "CHESS_RULE_STALEMATE", "stalemate"}, {CHESS_RULE_FIFTY_MOVES, "CHESS_RULE_FIFTY_MOVES", "fifty-moves"}, {CHESS_RULE_SEVENTY_FIVE_MOVES, "CHESS_RULE_SEVENTY_FIVE_MOVES", "seventy-five-moves"}, {CHESS_RULE_TIMEOUT, "CHESS_RULE_TIMEOUT", "timeout"}, {CHESS_RULE_THREE_FOLD_REPETITION, "CHESS_RULE_THREE_FOLD_REPETITION", "three-fold-repetition"}, {CHESS_RULE_FIVE_FOLD_REPETITION, "CHESS_RULE_FIVE_FOLD_REPETITION", "five-fold-repetition"}, {CHESS_RULE_INSUFFICIENT_MATERIAL, "CHESS_RULE_INSUFFICIENT_MATERIAL", "insufficient-material"}, {CHESS_RULE_RESIGN, "CHESS_RULE_RESIGN", "resign"}, {CHESS_RULE_ABANDONMENT, "CHESS_RULE_ABANDONMENT", "abandonment"}, {CHESS_RULE_DEATH, "CHESS_RULE_DEATH", "death"}, {CHESS_RULE_BUG, "CHESS_RULE_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_rule_type_id;
		chess_rule_type_id = g_enum_register_static ("ChessRule", values);
		g_once_init_leave (&chess_rule_type_id__volatile, chess_rule_type_id);
	}
	return chess_rule_type_id__volatile;
}


static void _g_object_unref0_ (gpointer var) {
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	(var == NULL) ? NULL : (var = (g_object_unref (var), NULL));
#line 331 "chess-game.c"
}


static void _g_list_free__g_object_unref0_ (GList* self) {
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_list_foreach (self, (GFunc) _g_object_unref0_, NULL);
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_list_free (self);
#line 340 "chess-game.c"
}


static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self) {
	gboolean result;
	result = chess_game_move_cb ((ChessGame*) self, _sender, move, apply);
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 349 "chess-game.c"
}


static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self) {
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_undo_cb ((ChessGame*) self, _sender);
#line 356 "chess-game.c"
}


static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_resign_cb ((ChessGame*) self, _sender);
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 365 "chess-game.c"
}


static void _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self) {
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_claim_draw_cb ((ChessGame*) self);
#line 372 "chess-game.c"
}


ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1, GError** error) {
	ChessGame * self = NULL;
	const gchar* _tmp0_;
	ChessState* _tmp1_;
	gchar** _tmp2_;
	gint _tmp2__length1;
	ChessPlayer* _tmp17_;
	ChessPlayer* _tmp18_;
	ChessPlayer* _tmp19_;
	ChessPlayer* _tmp20_;
	ChessPlayer* _tmp21_;
	ChessPlayer* _tmp22_;
	ChessPlayer* _tmp23_;
	ChessPlayer* _tmp24_;
	ChessPlayer* _tmp25_;
	ChessPlayer* _tmp26_;
	ChessPlayer* _tmp27_;
	ChessPlayer* _tmp28_;
	ChessPlayer* _tmp29_;
	ChessPlayer* _tmp30_;
	ChessPlayer* _tmp31_;
	ChessPlayer* _tmp32_;
	GError * _inner_error_ = NULL;
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (fen != NULL, NULL);
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self = (ChessGame*) g_object_new (object_type, NULL);
#line 95 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->is_started = FALSE;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = fen;
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = chess_state_new (_tmp0_);
#line 96 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->move_stack = g_list_prepend (self->move_stack, _tmp1_);
#line 97 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->result = CHESS_RESULT_IN_PROGRESS;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = moves;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2__length1 = moves_length1;
#line 99 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ != NULL) {
#line 419 "chess-game.c"
		{
			gint i;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
			i = 0;
#line 424 "chess-game.c"
			{
				gboolean _tmp3_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				_tmp3_ = TRUE;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				while (TRUE) {
#line 431 "chess-game.c"
					gint _tmp5_;
					gchar** _tmp6_;
					gint _tmp6__length1;
					ChessPlayer* _tmp7_;
					ChessPlayer* _tmp8_;
					gchar** _tmp9_;
					gint _tmp9__length1;
					gint _tmp10_;
					const gchar* _tmp11_;
					gboolean _tmp12_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					if (!_tmp3_) {
#line 444 "chess-game.c"
						gint _tmp4_;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						_tmp4_ = i;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						i = _tmp4_ + 1;
#line 450 "chess-game.c"
					}
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp3_ = FALSE;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp5_ = i;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp6_ = moves;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp6__length1 = moves_length1;
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					if (!(_tmp5_ < _tmp6__length1)) {
#line 101 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						break;
#line 464 "chess-game.c"
					}
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp7_ = chess_game_get_current_player (self);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp8_ = _tmp7_;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp9_ = moves;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp9__length1 = moves_length1;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp10_ = i;
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp11_ = _tmp9_[_tmp10_];
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp12_ = chess_game_do_move (self, _tmp8_, _tmp11_, TRUE);
#line 103 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					if (!_tmp12_) {
#line 482 "chess-game.c"
						gchar** _tmp13_;
						gint _tmp13__length1;
						gint _tmp14_;
						const gchar* _tmp15_;
						GError* _tmp16_;
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						_tmp13_ = moves;
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						_tmp13__length1 = moves_length1;
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						_tmp14_ = i;
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						_tmp15_ = _tmp13_[_tmp14_];
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						_tmp16_ = g_error_new (PGN_ERROR, PGN_ERROR_LOAD_ERROR, _ ("Failed to load PGN: move %s is invalid."), _tmp15_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						_inner_error_ = _tmp16_;
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
						if (_inner_error_->domain == PGN_ERROR) {
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
							g_propagate_error (error, _inner_error_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
							_g_object_unref0 (self);
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
							return NULL;
#line 508 "chess-game.c"
						} else {
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
							g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
							g_clear_error (&_inner_error_);
#line 106 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
							return NULL;
#line 516 "chess-game.c"
						}
					}
				}
			}
		}
	}
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp17_ = chess_game_get_white (self);
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp18_ = _tmp17_;
#line 111 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp18_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self, 0);
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp19_ = chess_game_get_white (self);
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp20_ = _tmp19_;
#line 112 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp20_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self, 0);
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp21_ = chess_game_get_white (self);
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp22_ = _tmp21_;
#line 113 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp22_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self, 0);
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp23_ = chess_game_get_white (self);
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp24_ = _tmp23_;
#line 114 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp24_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self, 0);
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp25_ = chess_game_get_black (self);
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp26_ = _tmp25_;
#line 115 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp26_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self, 0);
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp27_ = chess_game_get_black (self);
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp28_ = _tmp27_;
#line 116 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp28_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self, 0);
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp29_ = chess_game_get_black (self);
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp30_ = _tmp29_;
#line 117 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp30_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self, 0);
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp31_ = chess_game_get_black (self);
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp32_ = _tmp31_;
#line 118 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_connect_object (_tmp32_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self, 0);
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return self;
#line 573 "chess-game.c"
}


ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1, GError** error) {
#line 93 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return chess_game_construct (TYPE_CHESS_GAME, fen, moves, moves_length1, error);
#line 580 "chess-game.c"
}


static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	ChessPlayer* _tmp1_;
	const gchar* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 127 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (move != NULL, FALSE);
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->is_started;
#line 129 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (!_tmp0_) {
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		result = FALSE;
#line 130 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return result;
#line 605 "chess-game.c"
	}
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = player;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = move;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp3_ = apply;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp4_ = chess_game_do_move (self, _tmp1_, _tmp2_, _tmp3_);
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp4_;
#line 132 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 619 "chess-game.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return self ? g_object_ref (self) : NULL;
#line 626 "chess-game.c"
}


static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessState* state;
	ChessState* _tmp3_;
	ChessState* _tmp4_;
	ChessState* _tmp5_;
	ChessState* _tmp6_;
	gint _tmp7_;
	ChessState* _tmp8_;
	const gchar* _tmp9_;
	gboolean _tmp10_;
	gboolean _tmp11_;
	gboolean _tmp12_;
	ChessState* _tmp13_;
	ChessState* _tmp14_;
	ChessState* _tmp15_;
	ChessMove* _tmp16_;
	ChessPiece* _tmp17_;
	ChessState* _tmp21_;
	ChessMove* _tmp22_;
	ChessPiece* _tmp23_;
	ChessState* _tmp24_;
	ChessMove* _tmp25_;
	ChessPiece* _tmp26_;
	ChessState* _tmp30_;
	ChessMove* _tmp31_;
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 135 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = player;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = chess_game_get_current_player (self);
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 137 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ != _tmp2_) {
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		result = FALSE;
#line 138 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return result;
#line 675 "chess-game.c"
	}
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp3_ = chess_game_get_current_state (self);
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp4_ = _tmp3_;
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp5_ = chess_state_copy (_tmp4_);
#line 140 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	state = _tmp5_;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp6_ = state;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp7_ = _tmp6_->number;
#line 141 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp6_->number = _tmp7_ + 1;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp8_ = state;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp9_ = move;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp10_ = apply;
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp11_ = chess_state_move (_tmp8_, _tmp9_, _tmp10_);
#line 142 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (!_tmp11_) {
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		result = FALSE;
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_g_object_unref0 (state);
#line 143 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return result;
#line 707 "chess-game.c"
	}
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp12_ = apply;
#line 145 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (!_tmp12_) {
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		result = TRUE;
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_g_object_unref0 (state);
#line 146 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return result;
#line 719 "chess-game.c"
	}
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp13_ = state;
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 148 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->move_stack = g_list_prepend (self->move_stack, _tmp14_);
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp15_ = state;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp16_ = _tmp15_->last_move;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp17_ = _tmp16_->victim;
#line 149 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp17_ != NULL) {
#line 735 "chess-game.c"
		ChessState* _tmp18_;
		ChessMove* _tmp19_;
		ChessPiece* _tmp20_;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp18_ = state;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp19_ = _tmp18_->last_move;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp20_ = _tmp19_->victim;
#line 150 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_signal_emit_by_name (_tmp20_, "died");
#line 747 "chess-game.c"
	}
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp21_ = state;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp22_ = _tmp21_->last_move;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp23_ = _tmp22_->piece;
#line 151 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_emit_by_name (_tmp23_, "moved");
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp24_ = state;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp25_ = _tmp24_->last_move;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp26_ = _tmp25_->moved_rook;
#line 152 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp26_ != NULL) {
#line 765 "chess-game.c"
		ChessState* _tmp27_;
		ChessMove* _tmp28_;
		ChessPiece* _tmp29_;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp27_ = state;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp28_ = _tmp27_->last_move;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp29_ = _tmp28_->moved_rook;
#line 153 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_signal_emit_by_name (_tmp29_, "moved");
#line 777 "chess-game.c"
	}
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp30_ = state;
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp31_ = _tmp30_->last_move;
#line 154 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_emit (self, chess_game_signals[CHESS_GAME_MOVED_SIGNAL], 0, _tmp31_);
#line 155 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_complete_move (self);
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = TRUE;
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_g_object_unref0 (state);
#line 157 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 793 "chess-game.c"
}


void chess_game_add_hold (ChessGame* self) {
	gint _tmp0_;
#line 160 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 162 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->priv->hold_count = _tmp0_ + 1;
#line 805 "chess-game.c"
}


void chess_game_remove_hold (ChessGame* self) {
	gint _tmp0_;
	gint _tmp1_;
	gint _tmp2_;
#line 165 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 167 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (_tmp0_ > 0);
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = self->priv->hold_count;
#line 169 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->priv->hold_count = _tmp1_ - 1;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = self->priv->hold_count;
#line 170 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ == 0) {
#line 171 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_complete_move (self);
#line 829 "chess-game.c"
	}
}


static void chess_game_complete_move (ChessGame* self) {
	gint _tmp0_;
	gboolean _tmp1_;
	ChessRule rule = 0;
	ChessResult _result_;
	ChessState* _tmp2_;
	ChessState* _tmp3_;
	ChessRule _tmp4_ = 0;
	ChessResult _tmp5_;
	ChessResult _tmp6_;
	gboolean _tmp9_;
	gboolean _tmp10_;
	ChessClock* _tmp11_;
	ChessPlayer* _tmp16_;
	ChessPlayer* _tmp17_;
#line 174 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->hold_count;
#line 177 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ > 0) {
#line 178 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 857 "chess-game.c"
	}
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = self->is_started;
#line 180 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (!_tmp1_) {
#line 181 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 865 "chess-game.c"
	}
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = chess_game_get_current_state (self);
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp5_ = chess_state_get_result (_tmp3_, &_tmp4_);
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	rule = _tmp4_;
#line 184 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_result_ = _tmp5_;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp6_ = _result_;
#line 185 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp6_ != CHESS_RESULT_IN_PROGRESS) {
#line 881 "chess-game.c"
		ChessResult _tmp7_;
		ChessRule _tmp8_;
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp7_ = _result_;
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp8_ = rule;
#line 187 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, _tmp7_, _tmp8_);
#line 188 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 892 "chess-game.c"
	}
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp9_ = chess_game_is_five_fold_repeat (self);
#line 191 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp9_) {
#line 193 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIVE_FOLD_REPETITION);
#line 194 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 902 "chess-game.c"
	}
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp10_ = chess_game_is_seventy_five_move_rule_fulfilled (self);
#line 198 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp10_) {
#line 200 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_SEVENTY_FIVE_MOVES);
#line 201 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 912 "chess-game.c"
	}
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp11_ = self->priv->_clock;
#line 204 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp11_ != NULL) {
#line 918 "chess-game.c"
		ChessClock* _tmp12_;
		ChessPlayer* _tmp13_;
		ChessPlayer* _tmp14_;
		Color _tmp15_;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp12_ = self->priv->_clock;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp13_ = chess_game_get_current_player (self);
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp14_ = _tmp13_;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp15_ = _tmp14_->color;
#line 205 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_clock_set_active_color (_tmp12_, _tmp15_);
#line 933 "chess-game.c"
	}
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp16_ = chess_game_get_current_player (self);
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp17_ = _tmp16_;
#line 206 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_emit (self, chess_game_signals[CHESS_GAME_TURN_STARTED_SIGNAL], 0, _tmp17_);
#line 941 "chess-game.c"
}


static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player) {
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	ChessPlayer* _tmp2_;
	GList* _tmp5_;
	GList* _tmp6_;
	GList* _tmp7_;
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 209 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (player != NULL);
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = player;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = chess_game_get_current_player (self);
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_;
#line 212 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ == _tmp2_) {
#line 964 "chess-game.c"
		ChessPlayer* _tmp3_;
		ChessPlayer* _tmp4_;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp3_ = chess_game_get_opponent (self);
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp4_ = _tmp3_;
#line 213 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_undo_cb (self, _tmp4_);
#line 973 "chess-game.c"
	}
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp5_ = self->move_stack;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp6_ = _tmp5_->next;
#line 216 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp6_ == NULL) {
#line 217 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 983 "chess-game.c"
	}
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp7_ = self->move_stack;
#line 220 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->move_stack = g_list_remove_link (self->move_stack, _tmp7_);
#line 221 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_emit (self, chess_game_signals[CHESS_GAME_UNDO_SIGNAL], 0);
#line 991 "chess-game.c"
}


static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 224 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (player != NULL, FALSE);
#line 226 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->is_started;
#line 226 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (!_tmp0_) {
#line 227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		result = FALSE;
#line 227 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return result;
#line 1012 "chess-game.c"
	}
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = player;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 229 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 230 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_RESIGN);
#line 1022 "chess-game.c"
	} else {
#line 232 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_RESIGN);
#line 1026 "chess-game.c"
	}
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = TRUE;
#line 234 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1032 "chess-game.c"
}


static gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1) {
	gint result = 0;
	gint count;
	GList* _tmp0_;
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0);
#line 237 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (s1 != NULL, 0);
#line 239 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	count = 1;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 1048 "chess-game.c"
	{
		GList* s2_collection = NULL;
		GList* s2_it = NULL;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		s2_collection = _tmp0_;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		for (s2_it = s2_collection; s2_it != NULL; s2_it = s2_it->next) {
#line 1056 "chess-game.c"
			ChessState* _tmp1_;
			ChessState* s2 = NULL;
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
			_tmp1_ = _g_object_ref0 ((ChessState*) s2_it->data);
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
			s2 = _tmp1_;
#line 1063 "chess-game.c"
			{
				gboolean _tmp2_ = FALSE;
				ChessState* _tmp3_;
				ChessState* _tmp4_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				_tmp3_ = s1;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				_tmp4_ = s2;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				if (_tmp3_ != _tmp4_) {
#line 1074 "chess-game.c"
					ChessState* _tmp5_;
					ChessState* _tmp6_;
					gboolean _tmp7_;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp5_ = s1;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp6_ = s2;
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp7_ = chess_state_equals (_tmp5_, _tmp6_);
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp2_ = _tmp7_;
#line 1086 "chess-game.c"
				} else {
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp2_ = FALSE;
#line 1090 "chess-game.c"
				}
#line 243 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				if (_tmp2_) {
#line 1094 "chess-game.c"
					gint _tmp8_;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_tmp8_ = count;
#line 244 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					count = _tmp8_ + 1;
#line 1100 "chess-game.c"
				}
#line 241 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				_g_object_unref0 (s2);
#line 1104 "chess-game.c"
			}
		}
	}
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = count;
#line 247 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1112 "chess-game.c"
}


static gboolean chess_game_is_n_fold_repeat (ChessGame* self, gint n) {
	gboolean result = FALSE;
	GList* _tmp0_;
#line 250 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 1123 "chess-game.c"
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		state_collection = _tmp0_;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
#line 1131 "chess-game.c"
			ChessState* _tmp1_;
			ChessState* state = NULL;
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
			_tmp1_ = _g_object_ref0 ((ChessState*) state_it->data);
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
			state = _tmp1_;
#line 1138 "chess-game.c"
			{
				ChessState* _tmp2_;
				gint _tmp3_;
				gint _tmp4_;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				_tmp2_ = state;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				_tmp3_ = chess_game_state_repeated_times (self, _tmp2_);
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				_tmp4_ = n;
#line 254 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				if (_tmp3_ >= _tmp4_) {
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					result = TRUE;
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					_g_object_unref0 (state);
#line 255 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
					return result;
#line 1157 "chess-game.c"
				}
#line 252 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
				_g_object_unref0 (state);
#line 1161 "chess-game.c"
			}
		}
	}
#line 258 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = FALSE;
#line 258 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1169 "chess-game.c"
}


gboolean chess_game_is_three_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 261 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_is_n_fold_repeat (self, 3);
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 263 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1184 "chess-game.c"
}


gboolean chess_game_is_five_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	gboolean _tmp0_;
#line 266 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_is_n_fold_repeat (self, 5);
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 268 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1199 "chess-game.c"
}


gboolean chess_game_is_fifty_move_rule_fulfilled (ChessGame* self) {
	gboolean result = FALSE;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	gint _tmp2_;
#line 271 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 274 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 274 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 274 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->halfmove_clock;
#line 274 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp2_ >= 100;
#line 274 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1220 "chess-game.c"
}


gboolean chess_game_is_seventy_five_move_rule_fulfilled (ChessGame* self) {
	gboolean result = FALSE;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	gint _tmp2_;
#line 277 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->halfmove_clock;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp2_ >= 150;
#line 280 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1241 "chess-game.c"
}


gboolean chess_game_can_claim_draw (ChessGame* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_;
#line 283 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = chess_game_is_fifty_move_rule_fulfilled (self);
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp1_) {
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = TRUE;
#line 1257 "chess-game.c"
	} else {
		gboolean _tmp2_;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp2_ = chess_game_is_three_fold_repeat (self);
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = _tmp2_;
#line 1264 "chess-game.c"
	}
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 285 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1270 "chess-game.c"
}


static void chess_game_claim_draw_cb (ChessGame* self) {
	gboolean _tmp0_;
#line 288 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_is_fifty_move_rule_fulfilled (self);
#line 290 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_) {
#line 291 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIFTY_MOVES);
#line 1284 "chess-game.c"
	} else {
		gboolean _tmp1_;
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp1_ = chess_game_is_three_fold_repeat (self);
#line 292 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		if (_tmp1_) {
#line 293 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
			chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_THREE_FOLD_REPETITION);
#line 1293 "chess-game.c"
		}
	}
}


static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self) {
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_clock_expired_cb ((ChessGame*) self, _sender);
#line 1302 "chess-game.c"
}


void chess_game_start (ChessGame* self) {
	ChessResult _tmp0_;
	gboolean _tmp1_;
	ChessClock* _tmp2_;
	ChessPlayer* _tmp8_;
	ChessPlayer* _tmp9_;
#line 296 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 298 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->result;
#line 298 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ != CHESS_RESULT_IN_PROGRESS) {
#line 299 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 1320 "chess-game.c"
	}
#line 301 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = self->is_started;
#line 301 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp1_) {
#line 302 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 1328 "chess-game.c"
	}
#line 303 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->is_started = TRUE;
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = self->priv->_clock;
#line 305 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ != NULL) {
#line 1336 "chess-game.c"
		ChessClock* _tmp3_;
		ChessClock* _tmp4_;
		ChessPlayer* _tmp5_;
		ChessPlayer* _tmp6_;
		Color _tmp7_;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp3_ = self->priv->_clock;
#line 307 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_signal_connect_object (_tmp3_, "expired", (GCallback) _chess_game_clock_expired_cb_chess_clock_expired, self, 0);
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp4_ = self->priv->_clock;
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp5_ = chess_game_get_current_player (self);
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp6_ = _tmp5_;
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp7_ = _tmp6_->color;
#line 308 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_clock_set_active_color (_tmp4_, _tmp7_);
#line 1356 "chess-game.c"
	}
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp8_ = chess_game_get_current_player (self);
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp9_ = _tmp8_;
#line 311 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_emit (self, chess_game_signals[CHESS_GAME_TURN_STARTED_SIGNAL], 0, _tmp9_);
#line 1364 "chess-game.c"
}


static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock) {
	ChessPlayer* _tmp0_;
	ChessPlayer* _tmp1_;
	Color _tmp2_;
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 314 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (clock != NULL);
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_player (self);
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->color;
#line 316 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp2_ == COLOR_WHITE) {
#line 317 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_TIMEOUT);
#line 1386 "chess-game.c"
	} else {
#line 319 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_TIMEOUT);
#line 1390 "chess-game.c"
	}
}


ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number) {
	ChessPiece* result = NULL;
	gint _tmp0_;
	ChessState* state;
	GList* _tmp4_;
	GList* _tmp5_;
	guint _tmp6_;
	gint _tmp7_;
	gconstpointer _tmp8_;
	ChessState* _tmp9_;
	gint _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	ChessPiece* _tmp13_;
	ChessPiece* _tmp14_;
#line 322 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 324 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = move_number;
#line 324 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ < 0) {
#line 1416 "chess-game.c"
		gint _tmp1_;
		GList* _tmp2_;
		guint _tmp3_;
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp1_ = move_number;
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp2_ = self->move_stack;
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp3_ = g_list_length (_tmp2_);
#line 325 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		move_number = _tmp1_ + ((gint) _tmp3_);
#line 1428 "chess-game.c"
	}
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp4_ = self->move_stack;
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp5_ = self->move_stack;
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp6_ = g_list_length (_tmp5_);
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp7_ = move_number;
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp8_ = g_list_nth_data (_tmp4_, (_tmp6_ - _tmp7_) - 1);
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp9_ = _g_object_ref0 ((ChessState*) _tmp8_);
#line 327 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	state = _tmp9_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp10_ = rank;
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp11_ = file;
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp12_ = chess_state_get_index (state, _tmp10_, _tmp11_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp13_ = state->board[_tmp12_];
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp14_ = _g_object_ref0 (_tmp13_);
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp14_;
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_g_object_unref0 (state);
#line 329 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1460 "chess-game.c"
}


void chess_game_pause (ChessGame* self, gboolean show_overlay) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_;
	ChessClock* _tmp3_;
#line 337 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = chess_game_get_clock (self);
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 1477 "chess-game.c"
		ChessResult _tmp4_;
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp4_ = self->result;
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
#line 1483 "chess-game.c"
	} else {
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp1_ = FALSE;
#line 1487 "chess-game.c"
	}
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp1_) {
#line 1491 "chess-game.c"
		gboolean _tmp5_;
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp5_ = self->priv->_is_paused;
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = !_tmp5_;
#line 1497 "chess-game.c"
	} else {
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = FALSE;
#line 1501 "chess-game.c"
	}
#line 339 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_) {
#line 1505 "chess-game.c"
		ChessClock* _tmp6_;
		ChessClock* _tmp7_;
		gboolean _tmp8_;
#line 341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp6_ = chess_game_get_clock (self);
#line 341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp7_ = _tmp6_;
#line 341 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_clock_pause (_tmp7_);
#line 342 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_set_is_paused (self, TRUE);
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp8_ = show_overlay;
#line 343 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_set_should_show_paused_overlay (self, _tmp8_);
#line 344 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_signal_emit (self, chess_game_signals[CHESS_GAME_PAUSED_SIGNAL], 0);
#line 1523 "chess-game.c"
	}
}


void chess_game_unpause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_;
	ChessClock* _tmp3_;
#line 348 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = chess_game_get_clock (self);
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 1541 "chess-game.c"
		ChessResult _tmp4_;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp4_ = self->result;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
#line 1547 "chess-game.c"
	} else {
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp1_ = FALSE;
#line 1551 "chess-game.c"
	}
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp1_) {
#line 1555 "chess-game.c"
		gboolean _tmp5_;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp5_ = self->priv->_is_paused;
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = _tmp5_;
#line 1561 "chess-game.c"
	} else {
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = FALSE;
#line 1565 "chess-game.c"
	}
#line 350 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_) {
#line 1569 "chess-game.c"
		ChessClock* _tmp6_;
		ChessClock* _tmp7_;
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp6_ = chess_game_get_clock (self);
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp7_ = _tmp6_;
#line 352 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_clock_unpause (_tmp7_);
#line 353 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_set_is_paused (self, FALSE);
#line 354 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_set_should_show_paused_overlay (self, FALSE);
#line 355 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_signal_emit (self, chess_game_signals[CHESS_GAME_UNPAUSED_SIGNAL], 0);
#line 1584 "chess-game.c"
	}
}


void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule) {
	gboolean _tmp0_;
	ChessResult _tmp1_;
	ChessRule _tmp2_;
	ChessClock* _tmp3_;
#line 359 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 361 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->is_started;
#line 361 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (!_tmp0_) {
#line 362 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		return;
#line 1602 "chess-game.c"
	}
#line 363 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _result_;
#line 363 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->result = _tmp1_;
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = rule;
#line 364 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->rule = _tmp2_;
#line 365 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->is_started = FALSE;
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp3_ = self->priv->_clock;
#line 366 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp3_ != NULL) {
#line 1618 "chess-game.c"
		ChessClock* _tmp4_;
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp4_ = self->priv->_clock;
#line 367 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_clock_stop (_tmp4_);
#line 1624 "chess-game.c"
	}
#line 368 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_signal_emit (self, chess_game_signals[CHESS_GAME_ENDED_SIGNAL], 0);
#line 1628 "chess-game.c"
}


gboolean chess_game_get_is_paused (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->_is_paused;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1643 "chess-game.c"
}


static void chess_game_set_is_paused (ChessGame* self, gboolean value) {
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (chess_game_get_is_paused (self) != value) {
#line 1652 "chess-game.c"
		gboolean _tmp0_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = value;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		self->priv->_is_paused = _tmp0_;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_object_notify ((GObject *) self, "is-paused");
#line 1660 "chess-game.c"
	}
}


gboolean chess_game_get_should_show_paused_overlay (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, FALSE);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->_should_show_paused_overlay;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1676 "chess-game.c"
}


static void chess_game_set_should_show_paused_overlay (ChessGame* self, gboolean value) {
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (chess_game_get_should_show_paused_overlay (self) != value) {
#line 1685 "chess-game.c"
		gboolean _tmp0_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = value;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		self->priv->_should_show_paused_overlay = _tmp0_;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_object_notify ((GObject *) self, "should-show-paused-overlay");
#line 1693 "chess-game.c"
	}
}


ChessState* chess_game_get_current_state (ChessGame* self) {
	ChessState* result;
	GList* _tmp0_;
	gconstpointer _tmp1_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_->data;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = (ChessState*) _tmp1_;
#line 62 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1712 "chess-game.c"
}


ChessPlayer* chess_game_get_white (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->players[COLOR_WHITE];
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp2_;
#line 67 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1733 "chess-game.c"
}


ChessPlayer* chess_game_get_black (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->players[COLOR_BLACK];
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp2_;
#line 71 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1754 "chess-game.c"
}


ChessPlayer* chess_game_get_current_player (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = _tmp1_->current_player;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp2_;
#line 75 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1775 "chess-game.c"
}


ChessPlayer* chess_game_get_opponent (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_;
	ChessState* _tmp1_;
	ChessPlayer* _tmp2_;
	ChessPlayer* _tmp3_;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = chess_game_get_current_state (self);
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = _tmp0_;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp2_ = chess_state_get_opponent (_tmp1_);
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp3_ = _tmp2_;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp3_;
#line 79 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1799 "chess-game.c"
}


ChessClock* chess_game_get_clock (ChessGame* self) {
	ChessClock* result;
	ChessClock* _tmp0_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->_clock;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp0_;
#line 84 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1814 "chess-game.c"
}


void chess_game_set_clock (ChessGame* self, ChessClock* value) {
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_if_fail (self != NULL);
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (chess_game_get_clock (self) != value) {
#line 1823 "chess-game.c"
		gboolean _tmp0_;
		ChessClock* _tmp1_;
		ChessClock* _tmp2_;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp0_ = self->is_started;
#line 87 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		if (_tmp0_) {
#line 88 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
			return;
#line 1833 "chess-game.c"
		}
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp1_ = value;
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp2_ = _g_object_ref0 (_tmp1_);
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_g_object_unref0 (self->priv->_clock);
#line 89 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		self->priv->_clock = _tmp2_;
#line 85 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_object_notify ((GObject *) self, "clock");
#line 1845 "chess-game.c"
	}
}


guint chess_game_get_n_moves (ChessGame* self) {
	guint result;
	GList* _tmp0_;
	guint _tmp1_;
#line 334 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_return_val_if_fail (self != NULL, 0U);
#line 334 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->move_stack;
#line 334 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp1_ = g_list_length (_tmp0_);
#line 334 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	result = _tmp1_ - 1;
#line 334 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	return result;
#line 1864 "chess-game.c"
}


static void chess_game_class_init (ChessGameClass * klass) {
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_parent_class = g_type_class_peek_parent (klass);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_type_class_add_private (klass, sizeof (ChessGamePrivate));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_game_get_property;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_game_set_property;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	G_OBJECT_CLASS (klass)->finalize = chess_game_finalize;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_IS_PAUSED, g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY, g_param_spec_boolean ("should-show-paused-overlay", "should-show-paused-overlay", "should-show-paused-overlay", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CURRENT_STATE, g_param_spec_object ("current-state", "current-state", "current-state", TYPE_CHESS_STATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_WHITE, g_param_spec_object ("white", "white", "white", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_BLACK, g_param_spec_object ("black", "black", "black", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CURRENT_PLAYER, g_param_spec_object ("current-player", "current-player", "current-player", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_OPPONENT, g_param_spec_object ("opponent", "opponent", "opponent", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CLOCK, g_param_spec_object ("clock", "clock", "clock", TYPE_CHESS_CLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_N_MOVES, g_param_spec_uint ("n-moves", "n-moves", "n-moves", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_signals[CHESS_GAME_TURN_STARTED_SIGNAL] = g_signal_new ("turn_started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_PLAYER);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_signals[CHESS_GAME_MOVED_SIGNAL] = g_signal_new ("moved", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_MOVE);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_signals[CHESS_GAME_PAUSED_SIGNAL] = g_signal_new ("paused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_signals[CHESS_GAME_UNPAUSED_SIGNAL] = g_signal_new ("unpaused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_signals[CHESS_GAME_UNDO_SIGNAL] = g_signal_new ("undo", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	chess_game_signals[CHESS_GAME_ENDED_SIGNAL] = g_signal_new ("ended", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
#line 1909 "chess-game.c"
}


static void chess_game_instance_init (ChessGame * self) {
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->priv = CHESS_GAME_GET_PRIVATE (self);
#line 46 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->priv->hold_count = 0;
#line 57 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->priv->_is_paused = FALSE;
#line 58 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self->priv->_should_show_paused_overlay = FALSE;
#line 1922 "chess-game.c"
}


static void chess_game_finalize (GObject * obj) {
	ChessGame * self;
	ChessClock* _tmp0_;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_GAME, ChessGame);
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_tmp0_ = self->priv->_clock;
#line 123 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	if (_tmp0_ != NULL) {
#line 1935 "chess-game.c"
		ChessClock* _tmp1_;
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		_tmp1_ = self->priv->_clock;
#line 124 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_clock_stop (_tmp1_);
#line 1941 "chess-game.c"
	}
#line 44 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	__g_list_free__g_object_unref0_0 (self->move_stack);
#line 81 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	_g_object_unref0 (self->priv->_clock);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	G_OBJECT_CLASS (chess_game_parent_class)->finalize (obj);
#line 1949 "chess-game.c"
}


GType chess_game_get_type (void) {
	static volatile gsize chess_game_type_id__volatile = 0;
	if (g_once_init_enter (&chess_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessGame), 0, (GInstanceInitFunc) chess_game_instance_init, NULL };
		GType chess_game_type_id;
		chess_game_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessGame", &g_define_type_info, 0);
		g_once_init_leave (&chess_game_type_id__volatile, chess_game_type_id);
	}
	return chess_game_type_id__volatile;
}


static void _vala_chess_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_GAME, ChessGame);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	switch (property_id) {
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_IS_PAUSED:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_boolean (value, chess_game_get_is_paused (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_boolean (value, chess_game_get_should_show_paused_overlay (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_CURRENT_STATE:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_current_state (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_WHITE:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_white (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_BLACK:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_black (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_CURRENT_PLAYER:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_current_player (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_OPPONENT:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_opponent (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_CLOCK:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_object (value, chess_game_get_clock (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_N_MOVES:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		g_value_set_uint (value, chess_game_get_n_moves (self));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 2024 "chess-game.c"
		default:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 2030 "chess-game.c"
	}
}


static void _vala_chess_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_GAME, ChessGame);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
	switch (property_id) {
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_IS_PAUSED:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_set_is_paused (self, g_value_get_boolean (value));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_SHOULD_SHOW_PAUSED_OVERLAY:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_set_should_show_paused_overlay (self, g_value_get_boolean (value));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		case CHESS_GAME_CLOCK:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		chess_game_set_clock (self, g_value_get_object (value));
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 2058 "chess-game.c"
		default:
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
#line 39 "/home/mcatanzaro/Projects/GNOME/gnome-chess/lib/chess-game.vala"
		break;
#line 2064 "chess-game.c"
	}
}



