/* chess-game.c generated by valac 0.24.0.112-bbf5, the Vala compiler
 * generated from chess-game.vala, do not modify */

/* -*- Mode: vala; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*-
 *
 * Copyright (C) 2010-2013 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define TYPE_COLOR (color_get_type ())

#define TYPE_CHESS_PLAYER (chess_player_get_type ())
#define CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PLAYER, ChessPlayer))
#define CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PLAYER, ChessPlayerClass))
#define IS_CHESS_PLAYER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PLAYER))
#define IS_CHESS_PLAYER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PLAYER))
#define CHESS_PLAYER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PLAYER, ChessPlayerClass))

typedef struct _ChessPlayer ChessPlayer;
typedef struct _ChessPlayerClass ChessPlayerClass;
typedef struct _ChessPlayerPrivate ChessPlayerPrivate;

#define TYPE_PIECE_TYPE (piece_type_get_type ())
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_CHESS_PIECE (chess_piece_get_type ())
#define CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_PIECE, ChessPiece))
#define CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_PIECE, ChessPieceClass))
#define IS_CHESS_PIECE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_PIECE))
#define IS_CHESS_PIECE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_PIECE))
#define CHESS_PIECE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_PIECE, ChessPieceClass))

typedef struct _ChessPiece ChessPiece;
typedef struct _ChessPieceClass ChessPieceClass;
typedef struct _ChessPiecePrivate ChessPiecePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _ParamSpecChessPiece ParamSpecChessPiece;

#define TYPE_CHECK_STATE (check_state_get_type ())

#define TYPE_CHESS_MOVE (chess_move_get_type ())
#define CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_MOVE, ChessMove))
#define CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_MOVE, ChessMoveClass))
#define IS_CHESS_MOVE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_MOVE))
#define IS_CHESS_MOVE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_MOVE))
#define CHESS_MOVE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_MOVE, ChessMoveClass))

typedef struct _ChessMove ChessMove;
typedef struct _ChessMoveClass ChessMoveClass;
typedef struct _ChessMovePrivate ChessMovePrivate;
#define _chess_piece_unref0(var) ((var == NULL) ? NULL : (var = (chess_piece_unref (var), NULL)))
#define _g_string_free0(var) ((var == NULL) ? NULL : (var = (g_string_free (var, TRUE), NULL)))
#define _chess_move_unref0(var) ((var == NULL) ? NULL : (var = (chess_move_unref (var), NULL)))
typedef struct _ParamSpecChessMove ParamSpecChessMove;

#define TYPE_CHESS_STATE (chess_state_get_type ())
#define CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_STATE, ChessState))
#define CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_STATE, ChessStateClass))
#define IS_CHESS_STATE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_STATE))
#define IS_CHESS_STATE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_STATE))
#define CHESS_STATE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_STATE, ChessStateClass))

typedef struct _ChessState ChessState;
typedef struct _ChessStateClass ChessStateClass;
typedef struct _ChessStatePrivate ChessStatePrivate;
#define _chess_state_unref0(var) ((var == NULL) ? NULL : (var = (chess_state_unref (var), NULL)))

#define TYPE_CHESS_RULE (chess_rule_get_type ())

#define TYPE_CHESS_RESULT (chess_result_get_type ())
typedef struct _ParamSpecChessState ParamSpecChessState;

#define TYPE_CHESS_GAME (chess_game_get_type ())
#define CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_GAME, ChessGame))
#define CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_GAME, ChessGameClass))
#define IS_CHESS_GAME(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_GAME))
#define IS_CHESS_GAME_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_GAME))
#define CHESS_GAME_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_GAME, ChessGameClass))

typedef struct _ChessGame ChessGame;
typedef struct _ChessGameClass ChessGameClass;
typedef struct _ChessGamePrivate ChessGamePrivate;

#define TYPE_CHESS_CLOCK (chess_clock_get_type ())
#define CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_CHESS_CLOCK, ChessClock))
#define CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_CHESS_CLOCK, ChessClockClass))
#define IS_CHESS_CLOCK(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_CHESS_CLOCK))
#define IS_CHESS_CLOCK_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_CHESS_CLOCK))
#define CHESS_CLOCK_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_CHESS_CLOCK, ChessClockClass))

typedef struct _ChessClock ChessClock;
typedef struct _ChessClockClass ChessClockClass;
#define __g_list_free__chess_state_unref0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__chess_state_unref0_ (var), NULL)))

typedef enum  {
	COLOR_WHITE,
	COLOR_BLACK
} Color;

struct _ChessPlayer {
	GObject parent_instance;
	ChessPlayerPrivate * priv;
	Color color;
};

struct _ChessPlayerClass {
	GObjectClass parent_class;
};

struct _ChessPlayerPrivate {
	gboolean _local_human;
};

typedef enum  {
	PIECE_TYPE_PAWN,
	PIECE_TYPE_ROOK,
	PIECE_TYPE_KNIGHT,
	PIECE_TYPE_BISHOP,
	PIECE_TYPE_QUEEN,
	PIECE_TYPE_KING
} PieceType;

struct _ChessPiece {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessPiecePrivate * priv;
	ChessPlayer* player;
	PieceType type;
};

struct _ChessPieceClass {
	GTypeClass parent_class;
	void (*finalize) (ChessPiece *self);
};

struct _ParamSpecChessPiece {
	GParamSpec parent_instance;
};

typedef enum  {
	CHECK_STATE_NONE,
	CHECK_STATE_CHECK,
	CHECK_STATE_CHECKMATE
} CheckState;

struct _ChessMove {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessMovePrivate * priv;
	gint number;
	ChessPiece* piece;
	ChessPiece* promotion_piece;
	ChessPiece* moved_rook;
	ChessPiece* victim;
	gint r0;
	gint f0;
	gint r1;
	gint f1;
	gboolean ambiguous_rank;
	gboolean ambiguous_file;
	CheckState check_state;
};

struct _ChessMoveClass {
	GTypeClass parent_class;
	void (*finalize) (ChessMove *self);
};

struct _ParamSpecChessMove {
	GParamSpec parent_instance;
};

struct _ChessState {
	GTypeInstance parent_instance;
	volatile int ref_count;
	ChessStatePrivate * priv;
	gint number;
	ChessPlayer* players[2];
	ChessPlayer* current_player;
	gboolean can_castle_kingside[2];
	gboolean can_castle_queenside[2];
	gint en_passant_index;
	CheckState check_state;
	gint halfmove_clock;
	ChessPiece* board[64];
	ChessMove* last_move;
};

struct _ChessStateClass {
	GTypeClass parent_class;
	void (*finalize) (ChessState *self);
};

struct _ChessStatePrivate {
	gint64 piece_masks[2];
};

typedef enum  {
	CHESS_RULE_CHECKMATE,
	CHESS_RULE_STALEMATE,
	CHESS_RULE_FIFTY_MOVES,
	CHESS_RULE_TIMEOUT,
	CHESS_RULE_THREE_FOLD_REPETITION,
	CHESS_RULE_INSUFFICIENT_MATERIAL,
	CHESS_RULE_RESIGN,
	CHESS_RULE_ABANDONMENT,
	CHESS_RULE_DEATH,
	CHESS_RULE_BUG
} ChessRule;

typedef enum  {
	CHESS_RESULT_IN_PROGRESS,
	CHESS_RESULT_WHITE_WON,
	CHESS_RESULT_BLACK_WON,
	CHESS_RESULT_DRAW,
	CHESS_RESULT_BUG
} ChessResult;

struct _ParamSpecChessState {
	GParamSpec parent_instance;
};

struct _ChessGame {
	GObject parent_instance;
	ChessGamePrivate * priv;
	gboolean is_started;
	ChessResult result;
	ChessRule rule;
	GList* move_stack;
};

struct _ChessGameClass {
	GObjectClass parent_class;
};

struct _ChessGamePrivate {
	gint hold_count;
	gboolean _is_paused;
	ChessClock* _clock;
};


static gpointer chess_player_parent_class = NULL;
static gpointer chess_piece_parent_class = NULL;
static gpointer chess_move_parent_class = NULL;
static gpointer chess_state_parent_class = NULL;
static gpointer chess_game_parent_class = NULL;

GType color_get_type (void) G_GNUC_CONST;
GType chess_player_get_type (void) G_GNUC_CONST;
#define CHESS_PLAYER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_PLAYER, ChessPlayerPrivate))
enum  {
	CHESS_PLAYER_DUMMY_PROPERTY,
	CHESS_PLAYER_LOCAL_HUMAN
};
ChessPlayer* chess_player_new (Color color);
ChessPlayer* chess_player_construct (GType object_type, Color color);
gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply);
GType piece_type_get_type (void) G_GNUC_CONST;
gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type);
void chess_player_undo (ChessPlayer* self);
gboolean chess_player_resign (ChessPlayer* self);
gboolean chess_player_claim_draw (ChessPlayer* self);
gboolean chess_player_get_local_human (ChessPlayer* self);
void chess_player_set_local_human (ChessPlayer* self, gboolean value);
static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_player_finalize (GObject* obj);
static void _vala_chess_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
gpointer chess_piece_ref (gpointer instance);
void chess_piece_unref (gpointer instance);
GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_piece (GValue* value, gpointer v_object);
void value_take_chess_piece (GValue* value, gpointer v_object);
gpointer value_get_chess_piece (const GValue* value);
GType chess_piece_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_PIECE_DUMMY_PROPERTY
};
ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type);
ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type);
Color chess_piece_get_color (ChessPiece* self);
gunichar chess_piece_get_symbol (ChessPiece* self);
static void chess_piece_finalize (ChessPiece* obj);
GType check_state_get_type (void) G_GNUC_CONST;
gpointer chess_move_ref (gpointer instance);
void chess_move_unref (gpointer instance);
GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_move (GValue* value, gpointer v_object);
void value_take_chess_move (GValue* value, gpointer v_object);
gpointer value_get_chess_move (const GValue* value);
GType chess_move_get_type (void) G_GNUC_CONST;
enum  {
	CHESS_MOVE_DUMMY_PROPERTY
};
gchar* chess_move_get_lan (ChessMove* self);
gchar* chess_move_get_san (ChessMove* self);
static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1);
gchar* chess_move_get_fan (ChessMove* self);
gchar* chess_move_get_engine (ChessMove* self);
ChessMove* chess_move_copy (ChessMove* self);
ChessMove* chess_move_new (void);
ChessMove* chess_move_construct (GType object_type);
static void chess_move_finalize (ChessMove* obj);
gpointer chess_state_ref (gpointer instance);
void chess_state_unref (gpointer instance);
GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_chess_state (GValue* value, gpointer v_object);
void value_take_chess_state (GValue* value, gpointer v_object);
gpointer value_get_chess_state (const GValue* value);
GType chess_state_get_type (void) G_GNUC_CONST;
#define CHESS_STATE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_STATE, ChessStatePrivate))
enum  {
	CHESS_STATE_DUMMY_PROPERTY
};
static ChessState* chess_state_new_empty (void);
static ChessState* chess_state_construct_empty (GType object_type);
ChessState* chess_state_new (const gchar* fen);
ChessState* chess_state_construct (GType object_type, const gchar* fen);
static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type);
gint chess_state_get_index (ChessState* self, gint rank, gint file);
static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player);
ChessState* chess_state_copy (ChessState* self);
gboolean chess_state_equals (ChessState* self, ChessState* state);
gchar* chess_state_get_fen (ChessState* self);
gint chess_state_get_file (ChessState* self, gint index);
gint chess_state_get_rank (ChessState* self, gint index);
gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply);
static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type);
gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check);
gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player);
GType chess_rule_get_type (void) G_GNUC_CONST;
GType chess_result_get_type (void) G_GNUC_CONST;
ChessResult chess_state_get_result (ChessState* self, ChessRule* rule);
static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player);
gboolean chess_state_have_sufficient_material (ChessState* self);
static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player);
ChessPlayer* chess_state_get_opponent (ChessState* self);
static void chess_state_finalize (ChessState* obj);
GType chess_game_get_type (void) G_GNUC_CONST;
GType chess_clock_get_type (void) G_GNUC_CONST;
#define CHESS_GAME_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_CHESS_GAME, ChessGamePrivate))
enum  {
	CHESS_GAME_DUMMY_PROPERTY,
	CHESS_GAME_IS_PAUSED,
	CHESS_GAME_CURRENT_STATE,
	CHESS_GAME_WHITE,
	CHESS_GAME_BLACK,
	CHESS_GAME_CURRENT_PLAYER,
	CHESS_GAME_OPPONENT,
	CHESS_GAME_CLOCK,
	CHESS_GAME_N_MOVES
};
void chess_clock_stop (ChessClock* self);
static void _chess_state_unref0_ (gpointer var);
static void _g_list_free__chess_state_unref0_ (GList* self);
#define CHESS_GAME_STANDARD_SETUP "rnbqkbnr/pppppppp/8/8/8/8/PPPPPPPP/RNBQKBNR w KQkq - 0 1"
ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1);
ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1);
static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
ChessPlayer* chess_game_get_current_player (ChessGame* self);
ChessPlayer* chess_game_get_white (ChessGame* self);
static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply);
static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self);
static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player);
static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self);
static gboolean chess_game_claim_draw_cb (ChessGame* self, ChessPlayer* player);
static gboolean _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self);
ChessPlayer* chess_game_get_black (ChessGame* self);
ChessState* chess_game_get_current_state (ChessGame* self);
static void chess_game_complete_move (ChessGame* self);
void chess_game_add_hold (ChessGame* self);
void chess_game_remove_hold (ChessGame* self);
void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule);
void chess_clock_set_active_color (ChessClock* self, Color value);
ChessPlayer* chess_game_get_opponent (ChessGame* self);
static gboolean chess_game_is_three_fold_repeat (ChessGame* self);
void chess_game_start (ChessGame* self);
static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock);
static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self);
ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number);
void chess_game_pause (ChessGame* self);
ChessClock* chess_game_get_clock (ChessGame* self);
gboolean chess_game_get_is_paused (ChessGame* self);
void chess_clock_pause (ChessClock* self);
static void chess_game_set_is_paused (ChessGame* self, gboolean value);
void chess_game_unpause (ChessGame* self);
void chess_clock_unpause (ChessClock* self);
gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1);
void chess_game_set_clock (ChessGame* self, ChessClock* value);
guint chess_game_get_n_moves (ChessGame* self);
static void g_cclosure_user_marshal_VOID__CHESS_MOVE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void chess_game_finalize (GObject* obj);
static void _vala_chess_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_chess_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

extern const gint64 BIT_BOARD_set_location_masks[64];
extern const gint64 BIT_BOARD_move_masks[768];
extern const gint64 BIT_BOARD_over_masks[4096];
extern const gint64 BIT_BOARD_clear_location_masks[64];

GType color_get_type (void) {
	static volatile gsize color_type_id__volatile = 0;
	if (g_once_init_enter (&color_type_id__volatile)) {
		static const GEnumValue values[] = {{COLOR_WHITE, "COLOR_WHITE", "white"}, {COLOR_BLACK, "COLOR_BLACK", "black"}, {0, NULL, NULL}};
		GType color_type_id;
		color_type_id = g_enum_register_static ("Color", values);
		g_once_init_leave (&color_type_id__volatile, color_type_id);
	}
	return color_type_id__volatile;
}


ChessPlayer* chess_player_construct (GType object_type, Color color) {
	ChessPlayer * self = NULL;
	Color _tmp0_ = 0;
	self = (ChessPlayer*) g_object_new (object_type, NULL);
	_tmp0_ = color;
	self->color = _tmp0_;
	return self;
}


ChessPlayer* chess_player_new (Color color) {
	return chess_player_construct (TYPE_CHESS_PLAYER, color);
}


gboolean chess_player_move (ChessPlayer* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = move;
	_tmp1_ = apply;
	g_signal_emit_by_name (self, "do-move", _tmp0_, _tmp1_, &_tmp2_);
	result = _tmp2_;
	return result;
}


gboolean chess_player_move_with_coords (ChessPlayer* self, gint r0, gint f0, gint r1, gint f1, gboolean apply, PieceType promotion_type) {
	gboolean result = FALSE;
	gchar* move = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	PieceType _tmp5_ = 0;
	const gchar* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = f0;
	_tmp1_ = r0;
	_tmp2_ = f1;
	_tmp3_ = r1;
	_tmp4_ = g_strdup_printf ("%c%d%c%d", 'a' + _tmp0_, _tmp1_ + 1, 'a' + _tmp2_, _tmp3_ + 1);
	move = _tmp4_;
	_tmp5_ = promotion_type;
	switch (_tmp5_) {
		case PIECE_TYPE_QUEEN:
		{
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp6_ = move;
			_tmp7_ = g_strconcat (_tmp6_, "=N", NULL);
			_g_free0 (move);
			move = _tmp7_;
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			const gchar* _tmp8_ = NULL;
			gchar* _tmp9_ = NULL;
			_tmp8_ = move;
			_tmp9_ = g_strconcat (_tmp8_, "=R", NULL);
			_g_free0 (move);
			move = _tmp9_;
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			const gchar* _tmp10_ = NULL;
			gchar* _tmp11_ = NULL;
			_tmp10_ = move;
			_tmp11_ = g_strconcat (_tmp10_, "=B", NULL);
			_g_free0 (move);
			move = _tmp11_;
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp12_ = move;
	_tmp13_ = apply;
	g_signal_emit_by_name (self, "do-move", _tmp12_, _tmp13_, &_tmp14_);
	result = _tmp14_;
	_g_free0 (move);
	return result;
}


void chess_player_undo (ChessPlayer* self) {
	g_return_if_fail (self != NULL);
	g_signal_emit_by_name (self, "do-undo");
}


gboolean chess_player_resign (ChessPlayer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self, "do-resign", &_tmp0_);
	result = _tmp0_;
	return result;
}


gboolean chess_player_claim_draw (ChessPlayer* self) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_signal_emit_by_name (self, "do-claim-draw", &_tmp0_);
	result = _tmp0_;
	return result;
}


gboolean chess_player_get_local_human (ChessPlayer* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_local_human;
	result = _tmp0_;
	return result;
}


void chess_player_set_local_human (ChessPlayer* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_local_human = _tmp0_;
	g_object_notify ((GObject *) self, "local-human");
}


static void g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (gpointer data1, const char* arg_1, gboolean arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__STRING_BOOLEAN callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__STRING_BOOLEAN) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_string (param_values + 1), g_value_get_boolean (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_BOOLEAN__VOID (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__VOID) (gpointer data1, gpointer data2);
	register GMarshalFunc_BOOLEAN__VOID callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 1);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__VOID) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, data2);
	g_value_set_boolean (return_value, v_return);
}


static void chess_player_class_init (ChessPlayerClass * klass) {
	chess_player_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessPlayerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_player_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_player_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_player_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_PLAYER_LOCAL_HUMAN, g_param_spec_boolean ("local-human", "local-human", "local-human", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("start_turn", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("do_move", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__STRING_BOOLEAN, G_TYPE_BOOLEAN, 2, G_TYPE_STRING, G_TYPE_BOOLEAN);
	g_signal_new ("do_undo", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("do_resign", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
	g_signal_new ("do_claim_draw", TYPE_CHESS_PLAYER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__VOID, G_TYPE_BOOLEAN, 0);
}


static void chess_player_instance_init (ChessPlayer * self) {
	self->priv = CHESS_PLAYER_GET_PRIVATE (self);
	self->priv->_local_human = FALSE;
}


static void chess_player_finalize (GObject* obj) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PLAYER, ChessPlayer);
	G_OBJECT_CLASS (chess_player_parent_class)->finalize (obj);
}


GType chess_player_get_type (void) {
	static volatile gsize chess_player_type_id__volatile = 0;
	if (g_once_init_enter (&chess_player_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessPlayerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_player_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPlayer), 0, (GInstanceInitFunc) chess_player_instance_init, NULL };
		GType chess_player_type_id;
		chess_player_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessPlayer", &g_define_type_info, 0);
		g_once_init_leave (&chess_player_type_id__volatile, chess_player_type_id);
	}
	return chess_player_type_id__volatile;
}


static void _vala_chess_player_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PLAYER, ChessPlayer);
	switch (property_id) {
		case CHESS_PLAYER_LOCAL_HUMAN:
		g_value_set_boolean (value, chess_player_get_local_human (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_player_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessPlayer * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_PLAYER, ChessPlayer);
	switch (property_id) {
		case CHESS_PLAYER_LOCAL_HUMAN:
		chess_player_set_local_human (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


GType piece_type_get_type (void) {
	static volatile gsize piece_type_type_id__volatile = 0;
	if (g_once_init_enter (&piece_type_type_id__volatile)) {
		static const GEnumValue values[] = {{PIECE_TYPE_PAWN, "PIECE_TYPE_PAWN", "pawn"}, {PIECE_TYPE_ROOK, "PIECE_TYPE_ROOK", "rook"}, {PIECE_TYPE_KNIGHT, "PIECE_TYPE_KNIGHT", "knight"}, {PIECE_TYPE_BISHOP, "PIECE_TYPE_BISHOP", "bishop"}, {PIECE_TYPE_QUEEN, "PIECE_TYPE_QUEEN", "queen"}, {PIECE_TYPE_KING, "PIECE_TYPE_KING", "king"}, {0, NULL, NULL}};
		GType piece_type_type_id;
		piece_type_type_id = g_enum_register_static ("PieceType", values);
		g_once_init_leave (&piece_type_type_id__volatile, piece_type_type_id);
	}
	return piece_type_type_id__volatile;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


ChessPiece* chess_piece_construct (GType object_type, ChessPlayer* player, PieceType type) {
	ChessPiece* self = NULL;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	PieceType _tmp2_ = 0;
	g_return_val_if_fail (player != NULL, NULL);
	self = (ChessPiece*) g_type_create_instance (object_type);
	_tmp0_ = player;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (self->player);
	self->player = _tmp1_;
	_tmp2_ = type;
	self->type = _tmp2_;
	return self;
}


ChessPiece* chess_piece_new (ChessPlayer* player, PieceType type) {
	return chess_piece_construct (TYPE_CHESS_PIECE, player, type);
}


Color chess_piece_get_color (ChessPiece* self) {
	Color result;
	ChessPlayer* _tmp0_ = NULL;
	Color _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->player;
	_tmp1_ = _tmp0_->color;
	result = _tmp1_;
	return result;
}


gunichar chess_piece_get_symbol (ChessPiece* self) {
	gunichar result;
	gunichar c = 0U;
	PieceType _tmp0_ = 0;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	gunichar _tmp5_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	c = (gunichar) ' ';
	_tmp0_ = self->type;
	switch (_tmp0_) {
		case PIECE_TYPE_PAWN:
		{
			c = (gunichar) 'p';
			break;
		}
		case PIECE_TYPE_ROOK:
		{
			c = (gunichar) 'r';
			break;
		}
		case PIECE_TYPE_KNIGHT:
		{
			c = (gunichar) 'n';
			break;
		}
		case PIECE_TYPE_BISHOP:
		{
			c = (gunichar) 'b';
			break;
		}
		case PIECE_TYPE_QUEEN:
		{
			c = (gunichar) 'q';
			break;
		}
		case PIECE_TYPE_KING:
		{
			c = (gunichar) 'k';
			break;
		}
		default:
		break;
	}
	_tmp1_ = self->player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		gunichar _tmp3_ = 0U;
		gunichar _tmp4_ = 0U;
		_tmp3_ = c;
		_tmp4_ = g_unichar_toupper (_tmp3_);
		c = _tmp4_;
	}
	_tmp5_ = c;
	result = _tmp5_;
	return result;
}


static void value_chess_piece_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_piece_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_piece_unref (value->data[0].v_pointer);
	}
}


static void value_chess_piece_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_piece_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_piece_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_piece_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessPiece* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_piece_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_piece_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessPiece** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_piece_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_piece (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessPiece* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_PIECE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_piece (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_piece (GValue* value, gpointer v_object) {
	ChessPiece* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_PIECE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_piece_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_piece_unref (old);
	}
}


void value_take_chess_piece (GValue* value, gpointer v_object) {
	ChessPiece* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_PIECE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_PIECE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_piece_unref (old);
	}
}


static void chess_piece_class_init (ChessPieceClass * klass) {
	chess_piece_parent_class = g_type_class_peek_parent (klass);
	CHESS_PIECE_CLASS (klass)->finalize = chess_piece_finalize;
	g_signal_new ("moved", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("promoted", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("died", TYPE_CHESS_PIECE, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_piece_instance_init (ChessPiece * self) {
	self->ref_count = 1;
}


static void chess_piece_finalize (ChessPiece* obj) {
	ChessPiece * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_PIECE, ChessPiece);
	_g_object_unref0 (self->player);
}


GType chess_piece_get_type (void) {
	static volatile gsize chess_piece_type_id__volatile = 0;
	if (g_once_init_enter (&chess_piece_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_piece_init, value_chess_piece_free_value, value_chess_piece_copy_value, value_chess_piece_peek_pointer, "p", value_chess_piece_collect_value, "p", value_chess_piece_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessPieceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_piece_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessPiece), 0, (GInstanceInitFunc) chess_piece_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_piece_type_id;
		chess_piece_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessPiece", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_piece_type_id__volatile, chess_piece_type_id);
	}
	return chess_piece_type_id__volatile;
}


gpointer chess_piece_ref (gpointer instance) {
	ChessPiece* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_piece_unref (gpointer instance) {
	ChessPiece* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_PIECE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType check_state_get_type (void) {
	static volatile gsize check_state_type_id__volatile = 0;
	if (g_once_init_enter (&check_state_type_id__volatile)) {
		static const GEnumValue values[] = {{CHECK_STATE_NONE, "CHECK_STATE_NONE", "none"}, {CHECK_STATE_CHECK, "CHECK_STATE_CHECK", "check"}, {CHECK_STATE_CHECKMATE, "CHECK_STATE_CHECKMATE", "checkmate"}, {0, NULL, NULL}};
		GType check_state_type_id;
		check_state_type_id = g_enum_register_static ("CheckState", values);
		g_once_init_leave (&check_state_type_id__volatile, check_state_type_id);
	}
	return check_state_type_id__volatile;
}


gchar* chess_move_get_lan (ChessMove* self) {
	gchar* result = NULL;
	ChessPiece* _tmp0_ = NULL;
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	ChessPiece* _tmp6_ = NULL;
	static const gchar promotion_symbols[] = {' ', 'R', 'N', 'B', 'Q', 'K'};
	ChessPiece* _tmp17_ = NULL;
	CheckState _tmp22_ = 0;
	GString* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->moved_rook;
	if (_tmp0_ != NULL) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = self->f1;
		_tmp2_ = self->f0;
		if (_tmp1_ > _tmp2_) {
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("O-O");
			result = _tmp3_;
			return result;
		} else {
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("O-O-O");
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = g_string_new ("");
	builder = _tmp5_;
	_tmp6_ = self->victim;
	if (_tmp6_ != NULL) {
		GString* _tmp7_ = NULL;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		gint _tmp11_ = 0;
		_tmp7_ = builder;
		_tmp8_ = self->f0;
		_tmp9_ = self->r0;
		_tmp10_ = self->f1;
		_tmp11_ = self->r1;
		g_string_append_printf (_tmp7_, "%c%dx%c%d", 'a' + _tmp8_, _tmp9_ + 1, 'a' + _tmp10_, _tmp11_ + 1);
	} else {
		GString* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		gint _tmp16_ = 0;
		_tmp12_ = builder;
		_tmp13_ = self->f0;
		_tmp14_ = self->r0;
		_tmp15_ = self->f1;
		_tmp16_ = self->r1;
		g_string_append_printf (_tmp12_, "%c%d-%c%d", 'a' + _tmp13_, _tmp14_ + 1, 'a' + _tmp15_, _tmp16_ + 1);
	}
	_tmp17_ = self->promotion_piece;
	if (_tmp17_ != NULL) {
		GString* _tmp18_ = NULL;
		ChessPiece* _tmp19_ = NULL;
		PieceType _tmp20_ = 0;
		gchar _tmp21_ = '\0';
		_tmp18_ = builder;
		_tmp19_ = self->promotion_piece;
		_tmp20_ = _tmp19_->type;
		_tmp21_ = promotion_symbols[_tmp20_];
		g_string_append_printf (_tmp18_, "=%c", (gint) _tmp21_);
	}
	_tmp22_ = self->check_state;
	switch (_tmp22_) {
		case CHECK_STATE_CHECK:
		{
			GString* _tmp23_ = NULL;
			_tmp23_ = builder;
			g_string_append_c (_tmp23_, '+');
			break;
		}
		case CHECK_STATE_CHECKMATE:
		{
			GString* _tmp24_ = NULL;
			_tmp24_ = builder;
			g_string_append_c (_tmp24_, '#');
			break;
		}
		default:
		break;
	}
	_tmp25_ = builder;
	_tmp26_ = _tmp25_->str;
	_tmp27_ = g_strdup (_tmp26_);
	result = _tmp27_;
	_g_string_free0 (builder);
	return result;
}


gchar* chess_move_get_san (ChessMove* self) {
	gchar* result = NULL;
	static const gchar* piece_names[] = {"", "R", "N", "B", "Q", "K"};
	gchar* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_move_make_san (self, (gchar**) piece_names, (G_N_ELEMENTS (piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
	result = _tmp0_;
	return result;
}


gchar* chess_move_get_fan (ChessMove* self) {
	gchar* result = NULL;
	static const gchar* white_piece_names[] = {"", "♖", "♘", "♗", "♕", "♔"};
	static const gchar* black_piece_names[] = {"", "♜", "♞", "♝", "♛", "♚"};
	ChessPiece* _tmp0_ = NULL;
	Color _tmp1_ = 0;
	Color _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->piece;
	_tmp1_ = chess_piece_get_color (_tmp0_);
	_tmp2_ = _tmp1_;
	if (_tmp2_ == COLOR_WHITE) {
		gchar* _tmp3_ = NULL;
		_tmp3_ = chess_move_make_san (self, (gchar**) white_piece_names, (G_N_ELEMENTS (white_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
		result = _tmp3_;
		return result;
	} else {
		gchar* _tmp4_ = NULL;
		_tmp4_ = chess_move_make_san (self, (gchar**) black_piece_names, (G_N_ELEMENTS (black_piece_names) * sizeof (const gchar*)) / sizeof (gchar*));
		result = _tmp4_;
		return result;
	}
}


static gchar* chess_move_make_san (ChessMove* self, gchar** piece_names, int piece_names_length1) {
	gchar* result = NULL;
	ChessPiece* _tmp0_ = NULL;
	GString* builder = NULL;
	GString* _tmp5_ = NULL;
	GString* _tmp6_ = NULL;
	gchar** _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	ChessPiece* _tmp8_ = NULL;
	PieceType _tmp9_ = 0;
	const gchar* _tmp10_ = NULL;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	ChessPiece* _tmp17_ = NULL;
	GString* _tmp19_ = NULL;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	ChessPiece* _tmp22_ = NULL;
	CheckState _tmp28_ = 0;
	GString* _tmp31_ = NULL;
	const gchar* _tmp32_ = NULL;
	gchar* _tmp33_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->moved_rook;
	if (_tmp0_ != NULL) {
		gint _tmp1_ = 0;
		gint _tmp2_ = 0;
		_tmp1_ = self->f1;
		_tmp2_ = self->f0;
		if (_tmp1_ > _tmp2_) {
			gchar* _tmp3_ = NULL;
			_tmp3_ = g_strdup ("O-O");
			result = _tmp3_;
			return result;
		} else {
			gchar* _tmp4_ = NULL;
			_tmp4_ = g_strdup ("O-O-O");
			result = _tmp4_;
			return result;
		}
	}
	_tmp5_ = g_string_new ("");
	builder = _tmp5_;
	_tmp6_ = builder;
	_tmp7_ = piece_names;
	_tmp7__length1 = piece_names_length1;
	_tmp8_ = self->piece;
	_tmp9_ = _tmp8_->type;
	_tmp10_ = _tmp7_[_tmp9_];
	g_string_append (_tmp6_, _tmp10_);
	_tmp11_ = self->ambiguous_file;
	if (_tmp11_) {
		GString* _tmp12_ = NULL;
		gint _tmp13_ = 0;
		_tmp12_ = builder;
		_tmp13_ = self->f0;
		g_string_append_printf (_tmp12_, "%c", 'a' + _tmp13_);
	}
	_tmp14_ = self->ambiguous_rank;
	if (_tmp14_) {
		GString* _tmp15_ = NULL;
		gint _tmp16_ = 0;
		_tmp15_ = builder;
		_tmp16_ = self->r0;
		g_string_append_printf (_tmp15_, "%d", _tmp16_ + 1);
	}
	_tmp17_ = self->victim;
	if (_tmp17_ != NULL) {
		GString* _tmp18_ = NULL;
		_tmp18_ = builder;
		g_string_append (_tmp18_, "x");
	}
	_tmp19_ = builder;
	_tmp20_ = self->f1;
	_tmp21_ = self->r1;
	g_string_append_printf (_tmp19_, "%c%d", 'a' + _tmp20_, _tmp21_ + 1);
	_tmp22_ = self->promotion_piece;
	if (_tmp22_ != NULL) {
		GString* _tmp23_ = NULL;
		gchar** _tmp24_ = NULL;
		gint _tmp24__length1 = 0;
		ChessPiece* _tmp25_ = NULL;
		PieceType _tmp26_ = 0;
		const gchar* _tmp27_ = NULL;
		_tmp23_ = builder;
		_tmp24_ = piece_names;
		_tmp24__length1 = piece_names_length1;
		_tmp25_ = self->promotion_piece;
		_tmp26_ = _tmp25_->type;
		_tmp27_ = _tmp24_[_tmp26_];
		g_string_append_printf (_tmp23_, "=%s", _tmp27_);
	}
	_tmp28_ = self->check_state;
	switch (_tmp28_) {
		case CHECK_STATE_CHECK:
		{
			GString* _tmp29_ = NULL;
			_tmp29_ = builder;
			g_string_append_c (_tmp29_, '+');
			break;
		}
		case CHECK_STATE_CHECKMATE:
		{
			GString* _tmp30_ = NULL;
			_tmp30_ = builder;
			g_string_append_c (_tmp30_, '#');
			break;
		}
		default:
		break;
	}
	_tmp31_ = builder;
	_tmp32_ = _tmp31_->str;
	_tmp33_ = g_strdup (_tmp32_);
	result = _tmp33_;
	_g_string_free0 (builder);
	return result;
}


gchar* chess_move_get_engine (ChessMove* self) {
	gchar* result = NULL;
	GString* builder = NULL;
	GString* _tmp0_ = NULL;
	static const gchar promotion_symbols[] = {' ', 'r', 'n', 'b', 'q', ' '};
	ChessPiece* _tmp1_ = NULL;
	GString* _tmp15_ = NULL;
	const gchar* _tmp16_ = NULL;
	gchar* _tmp17_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	builder = _tmp0_;
	_tmp1_ = self->promotion_piece;
	if (_tmp1_ != NULL) {
		GString* _tmp2_ = NULL;
		gint _tmp3_ = 0;
		gint _tmp4_ = 0;
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		ChessPiece* _tmp7_ = NULL;
		PieceType _tmp8_ = 0;
		gchar _tmp9_ = '\0';
		_tmp2_ = builder;
		_tmp3_ = self->f0;
		_tmp4_ = self->r0;
		_tmp5_ = self->f1;
		_tmp6_ = self->r1;
		_tmp7_ = self->promotion_piece;
		_tmp8_ = _tmp7_->type;
		_tmp9_ = promotion_symbols[_tmp8_];
		g_string_append_printf (_tmp2_, "%c%d%c%d%c", 'a' + _tmp3_, _tmp4_ + 1, 'a' + _tmp5_, _tmp6_ + 1, (gint) _tmp9_);
	} else {
		GString* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		_tmp10_ = builder;
		_tmp11_ = self->f0;
		_tmp12_ = self->r0;
		_tmp13_ = self->f1;
		_tmp14_ = self->r1;
		g_string_append_printf (_tmp10_, "%c%d%c%d", 'a' + _tmp11_, _tmp12_ + 1, 'a' + _tmp13_, _tmp14_ + 1);
	}
	_tmp15_ = builder;
	_tmp16_ = _tmp15_->str;
	_tmp17_ = g_strdup (_tmp16_);
	result = _tmp17_;
	_g_string_free0 (builder);
	return result;
}


static gpointer _chess_piece_ref0 (gpointer self) {
	return self ? chess_piece_ref (self) : NULL;
}


ChessMove* chess_move_copy (ChessMove* self) {
	ChessMove* result = NULL;
	ChessMove* move = NULL;
	ChessMove* _tmp0_ = NULL;
	gint _tmp1_ = 0;
	ChessPiece* _tmp2_ = NULL;
	ChessPiece* _tmp3_ = NULL;
	ChessPiece* _tmp4_ = NULL;
	ChessPiece* _tmp5_ = NULL;
	ChessPiece* _tmp6_ = NULL;
	ChessPiece* _tmp7_ = NULL;
	ChessPiece* _tmp8_ = NULL;
	ChessPiece* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gint _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	CheckState _tmp16_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_move_new ();
	move = _tmp0_;
	_tmp1_ = self->number;
	move->number = _tmp1_;
	_tmp2_ = self->piece;
	_tmp3_ = _chess_piece_ref0 (_tmp2_);
	_chess_piece_unref0 (move->piece);
	move->piece = _tmp3_;
	_tmp4_ = self->promotion_piece;
	_tmp5_ = _chess_piece_ref0 (_tmp4_);
	_chess_piece_unref0 (move->promotion_piece);
	move->promotion_piece = _tmp5_;
	_tmp6_ = self->moved_rook;
	_tmp7_ = _chess_piece_ref0 (_tmp6_);
	_chess_piece_unref0 (move->moved_rook);
	move->moved_rook = _tmp7_;
	_tmp8_ = self->victim;
	_tmp9_ = _chess_piece_ref0 (_tmp8_);
	_chess_piece_unref0 (move->victim);
	move->victim = _tmp9_;
	_tmp10_ = self->r0;
	move->r0 = _tmp10_;
	_tmp11_ = self->f0;
	move->f0 = _tmp11_;
	_tmp12_ = self->r1;
	move->r1 = _tmp12_;
	_tmp13_ = self->f1;
	move->f1 = _tmp13_;
	_tmp14_ = self->ambiguous_rank;
	move->ambiguous_rank = _tmp14_;
	_tmp15_ = self->ambiguous_file;
	move->ambiguous_file = _tmp15_;
	_tmp16_ = self->check_state;
	move->check_state = _tmp16_;
	result = move;
	return result;
}


ChessMove* chess_move_construct (GType object_type) {
	ChessMove* self = NULL;
	self = (ChessMove*) g_type_create_instance (object_type);
	return self;
}


ChessMove* chess_move_new (void) {
	return chess_move_construct (TYPE_CHESS_MOVE);
}


static void value_chess_move_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_move_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_move_unref (value->data[0].v_pointer);
	}
}


static void value_chess_move_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_move_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_move_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_move_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessMove* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_move_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_move_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessMove** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_move_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_move (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessMove* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_MOVE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_move (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_move (GValue* value, gpointer v_object) {
	ChessMove* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MOVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_move_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_move_unref (old);
	}
}


void value_take_chess_move (GValue* value, gpointer v_object) {
	ChessMove* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_MOVE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_MOVE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_move_unref (old);
	}
}


static void chess_move_class_init (ChessMoveClass * klass) {
	chess_move_parent_class = g_type_class_peek_parent (klass);
	CHESS_MOVE_CLASS (klass)->finalize = chess_move_finalize;
}


static void chess_move_instance_init (ChessMove * self) {
	self->ref_count = 1;
}


static void chess_move_finalize (ChessMove* obj) {
	ChessMove * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_MOVE, ChessMove);
	_chess_piece_unref0 (self->piece);
	_chess_piece_unref0 (self->promotion_piece);
	_chess_piece_unref0 (self->moved_rook);
	_chess_piece_unref0 (self->victim);
}


GType chess_move_get_type (void) {
	static volatile gsize chess_move_type_id__volatile = 0;
	if (g_once_init_enter (&chess_move_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_move_init, value_chess_move_free_value, value_chess_move_copy_value, value_chess_move_peek_pointer, "p", value_chess_move_collect_value, "p", value_chess_move_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessMoveClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_move_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessMove), 0, (GInstanceInitFunc) chess_move_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_move_type_id;
		chess_move_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessMove", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_move_type_id__volatile, chess_move_type_id);
	}
	return chess_move_type_id__volatile;
}


gpointer chess_move_ref (gpointer instance) {
	ChessMove* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_move_unref (gpointer instance) {
	ChessMove* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_MOVE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static ChessState* chess_state_construct_empty (GType object_type) {
	ChessState* self = NULL;
	self = (ChessState*) g_type_create_instance (object_type);
	return self;
}


static ChessState* chess_state_new_empty (void) {
	return chess_state_construct_empty (TYPE_CHESS_STATE);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


ChessState* chess_state_construct (GType object_type, const gchar* fen) {
	ChessState* self = NULL;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessPlayer* _tmp3_ = NULL;
	gchar** fields = NULL;
	const gchar* _tmp9_ = NULL;
	gchar** _tmp10_ = NULL;
	gchar** _tmp11_ = NULL;
	gint fields_length1 = 0;
	gint _fields_size_ = 0;
	gchar** ranks = NULL;
	gchar** _tmp12_ = NULL;
	gint _tmp12__length1 = 0;
	const gchar* _tmp13_ = NULL;
	gchar** _tmp14_ = NULL;
	gchar** _tmp15_ = NULL;
	gint ranks_length1 = 0;
	gint _ranks_size_ = 0;
	gchar** _tmp63_ = NULL;
	gint _tmp63__length1 = 0;
	const gchar* _tmp64_ = NULL;
	gchar** _tmp71_ = NULL;
	gint _tmp71__length1 = 0;
	const gchar* _tmp72_ = NULL;
	gchar** _tmp92_ = NULL;
	gint _tmp92__length1 = 0;
	const gchar* _tmp93_ = NULL;
	gchar** _tmp101_ = NULL;
	gint _tmp101__length1 = 0;
	const gchar* _tmp102_ = NULL;
	gint _tmp103_ = 0;
	gchar** _tmp104_ = NULL;
	gint _tmp104__length1 = 0;
	const gchar* _tmp105_ = NULL;
	gint _tmp106_ = 0;
	ChessPlayer* _tmp107_ = NULL;
	Color _tmp108_ = 0;
	ChessPlayer* _tmp110_ = NULL;
	CheckState _tmp111_ = 0;
	g_return_val_if_fail (fen != NULL, NULL);
	self = (ChessState*) g_type_create_instance (object_type);
	_tmp0_ = chess_player_new (COLOR_WHITE);
	_g_object_unref0 (self->players[COLOR_WHITE]);
	self->players[COLOR_WHITE] = _tmp0_;
	_tmp1_ = self->players[COLOR_WHITE];
	_tmp2_ = chess_player_new (COLOR_BLACK);
	_g_object_unref0 (self->players[COLOR_BLACK]);
	self->players[COLOR_BLACK] = _tmp2_;
	_tmp3_ = self->players[COLOR_BLACK];
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp4_ = FALSE;
			_tmp4_ = TRUE;
			while (TRUE) {
				gint _tmp6_ = 0;
				gint _tmp7_ = 0;
				ChessPiece* _tmp8_ = NULL;
				if (!_tmp4_) {
					gint _tmp5_ = 0;
					_tmp5_ = i;
					i = _tmp5_ + 1;
				}
				_tmp4_ = FALSE;
				_tmp6_ = i;
				if (!(_tmp6_ < 64)) {
					break;
				}
				_tmp7_ = i;
				_chess_piece_unref0 (self->board[_tmp7_]);
				self->board[_tmp7_] = NULL;
				_tmp8_ = self->board[_tmp7_];
			}
		}
	}
	_tmp9_ = fen;
	_tmp11_ = _tmp10_ = g_strsplit (_tmp9_, " ", 0);
	fields = _tmp11_;
	fields_length1 = _vala_array_length (_tmp10_);
	_fields_size_ = fields_length1;
	_tmp12_ = fields;
	_tmp12__length1 = fields_length1;
	_tmp13_ = _tmp12_[0];
	_tmp15_ = _tmp14_ = g_strsplit (_tmp13_, "/", 0);
	ranks = _tmp15_;
	ranks_length1 = _vala_array_length (_tmp14_);
	_ranks_size_ = ranks_length1;
	{
		gint rank = 0;
		rank = 0;
		{
			gboolean _tmp16_ = FALSE;
			_tmp16_ = TRUE;
			while (TRUE) {
				gint _tmp18_ = 0;
				gchar* rank_string = NULL;
				gchar** _tmp19_ = NULL;
				gint _tmp19__length1 = 0;
				gint _tmp20_ = 0;
				const gchar* _tmp21_ = NULL;
				gchar* _tmp22_ = NULL;
				if (!_tmp16_) {
					gint _tmp17_ = 0;
					_tmp17_ = rank;
					rank = _tmp17_ + 1;
				}
				_tmp16_ = FALSE;
				_tmp18_ = rank;
				if (!(_tmp18_ < 8)) {
					break;
				}
				_tmp19_ = ranks;
				_tmp19__length1 = ranks_length1;
				_tmp20_ = rank;
				_tmp21_ = _tmp19_[7 - _tmp20_];
				_tmp22_ = g_strdup (_tmp21_);
				rank_string = _tmp22_;
				{
					gint file = 0;
					gint offset = 0;
					file = 0;
					offset = 0;
					{
						gboolean _tmp23_ = FALSE;
						_tmp23_ = TRUE;
						while (TRUE) {
							gboolean _tmp25_ = FALSE;
							gint _tmp26_ = 0;
							gchar c = '\0';
							const gchar* _tmp31_ = NULL;
							gint _tmp32_ = 0;
							gchar _tmp33_ = '\0';
							gboolean _tmp34_ = FALSE;
							gchar _tmp35_ = '\0';
							PieceType type = 0;
							Color _tmp39_ = 0;
							gchar _tmp40_ = '\0';
							gboolean _tmp41_ = FALSE;
							Color color = 0;
							gchar _tmp42_ = '\0';
							gchar _tmp43_ = '\0';
							PieceType _tmp44_ = 0;
							gboolean _tmp45_ = FALSE;
							gint index = 0;
							gint _tmp46_ = 0;
							gint _tmp47_ = 0;
							gint _tmp48_ = 0;
							ChessPiece* piece = NULL;
							Color _tmp49_ = 0;
							ChessPlayer* _tmp50_ = NULL;
							PieceType _tmp51_ = 0;
							ChessPiece* _tmp52_ = NULL;
							gint _tmp53_ = 0;
							ChessPiece* _tmp54_ = NULL;
							ChessPiece* _tmp55_ = NULL;
							ChessPiece* _tmp56_ = NULL;
							gint64 mask = 0LL;
							gint _tmp57_ = 0;
							gint64 _tmp58_ = 0LL;
							Color _tmp59_ = 0;
							gint64 _tmp60_ = 0LL;
							gint64 _tmp61_ = 0LL;
							gint _tmp62_ = 0;
							if (!_tmp23_) {
								gint _tmp24_ = 0;
								_tmp24_ = offset;
								offset = _tmp24_ + 1;
							}
							_tmp23_ = FALSE;
							_tmp26_ = file;
							if (_tmp26_ < 8) {
								gint _tmp27_ = 0;
								const gchar* _tmp28_ = NULL;
								gint _tmp29_ = 0;
								gint _tmp30_ = 0;
								_tmp27_ = offset;
								_tmp28_ = rank_string;
								_tmp29_ = strlen (_tmp28_);
								_tmp30_ = _tmp29_;
								_tmp25_ = _tmp27_ < _tmp30_;
							} else {
								_tmp25_ = FALSE;
							}
							if (!_tmp25_) {
								break;
							}
							_tmp31_ = rank_string;
							_tmp32_ = offset;
							_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
							c = _tmp33_;
							_tmp35_ = c;
							if (_tmp35_ >= '1') {
								gchar _tmp36_ = '\0';
								_tmp36_ = c;
								_tmp34_ = _tmp36_ <= '8';
							} else {
								_tmp34_ = FALSE;
							}
							if (_tmp34_) {
								gint _tmp37_ = 0;
								gchar _tmp38_ = '\0';
								_tmp37_ = file;
								_tmp38_ = c;
								file = _tmp37_ + (_tmp38_ - '0');
								continue;
							}
							_tmp40_ = c;
							_tmp41_ = g_ascii_isupper (_tmp40_);
							if (_tmp41_) {
								_tmp39_ = COLOR_WHITE;
							} else {
								_tmp39_ = COLOR_BLACK;
							}
							color = _tmp39_;
							_tmp42_ = c;
							_tmp43_ = g_ascii_toupper (_tmp42_);
							_tmp45_ = chess_state_decode_piece_type (self, (gunichar) _tmp43_, &_tmp44_);
							type = _tmp44_;
							if (!_tmp45_) {
							}
							_tmp46_ = rank;
							_tmp47_ = file;
							_tmp48_ = chess_state_get_index (self, _tmp46_, _tmp47_);
							index = _tmp48_;
							_tmp49_ = color;
							_tmp50_ = self->players[_tmp49_];
							_tmp51_ = type;
							_tmp52_ = chess_piece_new (_tmp50_, _tmp51_);
							piece = _tmp52_;
							_tmp53_ = index;
							_tmp54_ = piece;
							_tmp55_ = _chess_piece_ref0 (_tmp54_);
							_chess_piece_unref0 (self->board[_tmp53_]);
							self->board[_tmp53_] = _tmp55_;
							_tmp56_ = self->board[_tmp53_];
							_tmp57_ = index;
							_tmp58_ = BIT_BOARD_set_location_masks[_tmp57_];
							mask = _tmp58_;
							_tmp59_ = color;
							_tmp60_ = mask;
							self->priv->piece_masks[_tmp59_] |= _tmp60_;
							_tmp61_ = self->priv->piece_masks[_tmp59_];
							_tmp62_ = file;
							file = _tmp62_ + 1;
							_chess_piece_unref0 (piece);
						}
					}
				}
				_g_free0 (rank_string);
			}
		}
	}
	_tmp63_ = fields;
	_tmp63__length1 = fields_length1;
	_tmp64_ = _tmp63_[1];
	if (g_strcmp0 (_tmp64_, "w") == 0) {
		ChessPlayer* _tmp65_ = NULL;
		ChessPlayer* _tmp66_ = NULL;
		_tmp65_ = self->players[COLOR_WHITE];
		_tmp66_ = _g_object_ref0 (_tmp65_);
		_g_object_unref0 (self->current_player);
		self->current_player = _tmp66_;
	} else {
		gchar** _tmp67_ = NULL;
		gint _tmp67__length1 = 0;
		const gchar* _tmp68_ = NULL;
		_tmp67_ = fields;
		_tmp67__length1 = fields_length1;
		_tmp68_ = _tmp67_[1];
		if (g_strcmp0 (_tmp68_, "b") == 0) {
			ChessPlayer* _tmp69_ = NULL;
			ChessPlayer* _tmp70_ = NULL;
			_tmp69_ = self->players[COLOR_BLACK];
			_tmp70_ = _g_object_ref0 (_tmp69_);
			_g_object_unref0 (self->current_player);
			self->current_player = _tmp70_;
		}
	}
	_tmp71_ = fields;
	_tmp71__length1 = fields_length1;
	_tmp72_ = _tmp71_[2];
	if (g_strcmp0 (_tmp72_, "-") != 0) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp73_ = FALSE;
				_tmp73_ = TRUE;
				while (TRUE) {
					gint _tmp75_ = 0;
					gchar** _tmp76_ = NULL;
					gint _tmp76__length1 = 0;
					const gchar* _tmp77_ = NULL;
					gint _tmp78_ = 0;
					gint _tmp79_ = 0;
					gchar c = '\0';
					gchar** _tmp80_ = NULL;
					gint _tmp80__length1 = 0;
					const gchar* _tmp81_ = NULL;
					gint _tmp82_ = 0;
					gchar _tmp83_ = '\0';
					gchar _tmp84_ = '\0';
					if (!_tmp73_) {
						gint _tmp74_ = 0;
						_tmp74_ = i;
						i = _tmp74_ + 1;
					}
					_tmp73_ = FALSE;
					_tmp75_ = i;
					_tmp76_ = fields;
					_tmp76__length1 = fields_length1;
					_tmp77_ = _tmp76_[2];
					_tmp78_ = strlen (_tmp77_);
					_tmp79_ = _tmp78_;
					if (!(_tmp75_ < _tmp79_)) {
						break;
					}
					_tmp80_ = fields;
					_tmp80__length1 = fields_length1;
					_tmp81_ = _tmp80_[2];
					_tmp82_ = i;
					_tmp83_ = string_get (_tmp81_, (glong) _tmp82_);
					c = _tmp83_;
					_tmp84_ = c;
					if (_tmp84_ == 'K') {
						gboolean _tmp85_ = FALSE;
						self->can_castle_kingside[COLOR_WHITE] = TRUE;
						_tmp85_ = self->can_castle_kingside[COLOR_WHITE];
					} else {
						gchar _tmp86_ = '\0';
						_tmp86_ = c;
						if (_tmp86_ == 'Q') {
							gboolean _tmp87_ = FALSE;
							self->can_castle_queenside[COLOR_WHITE] = TRUE;
							_tmp87_ = self->can_castle_queenside[COLOR_WHITE];
						} else {
							gchar _tmp88_ = '\0';
							_tmp88_ = c;
							if (_tmp88_ == 'k') {
								gboolean _tmp89_ = FALSE;
								self->can_castle_kingside[COLOR_BLACK] = TRUE;
								_tmp89_ = self->can_castle_kingside[COLOR_BLACK];
							} else {
								gchar _tmp90_ = '\0';
								_tmp90_ = c;
								if (_tmp90_ == 'q') {
									gboolean _tmp91_ = FALSE;
									self->can_castle_queenside[COLOR_BLACK] = TRUE;
									_tmp91_ = self->can_castle_queenside[COLOR_BLACK];
								}
							}
						}
					}
				}
			}
		}
	}
	_tmp92_ = fields;
	_tmp92__length1 = fields_length1;
	_tmp93_ = _tmp92_[3];
	if (g_strcmp0 (_tmp93_, "-") != 0) {
		gchar** _tmp94_ = NULL;
		gint _tmp94__length1 = 0;
		const gchar* _tmp95_ = NULL;
		gchar _tmp96_ = '\0';
		gchar** _tmp97_ = NULL;
		gint _tmp97__length1 = 0;
		const gchar* _tmp98_ = NULL;
		gchar _tmp99_ = '\0';
		gint _tmp100_ = 0;
		_tmp94_ = fields;
		_tmp94__length1 = fields_length1;
		_tmp95_ = _tmp94_[3];
		_tmp96_ = string_get (_tmp95_, (glong) 1);
		_tmp97_ = fields;
		_tmp97__length1 = fields_length1;
		_tmp98_ = _tmp97_[3];
		_tmp99_ = string_get (_tmp98_, (glong) 0);
		_tmp100_ = chess_state_get_index (self, (gint) (_tmp96_ - '1'), (gint) (_tmp99_ - 'a'));
		self->en_passant_index = _tmp100_;
	}
	_tmp101_ = fields;
	_tmp101__length1 = fields_length1;
	_tmp102_ = _tmp101_[4];
	_tmp103_ = atoi (_tmp102_);
	self->halfmove_clock = _tmp103_;
	_tmp104_ = fields;
	_tmp104__length1 = fields_length1;
	_tmp105_ = _tmp104_[5];
	_tmp106_ = atoi (_tmp105_);
	self->number = (_tmp106_ - 1) * 2;
	_tmp107_ = self->current_player;
	_tmp108_ = _tmp107_->color;
	if (_tmp108_ == COLOR_BLACK) {
		gint _tmp109_ = 0;
		_tmp109_ = self->number;
		self->number = _tmp109_ + 1;
	}
	_tmp110_ = self->current_player;
	_tmp111_ = chess_state_get_check_state (self, _tmp110_);
	self->check_state = _tmp111_;
	ranks = (_vala_array_free (ranks, ranks_length1, (GDestroyNotify) g_free), NULL);
	fields = (_vala_array_free (fields, fields_length1, (GDestroyNotify) g_free), NULL);
	return self;
}


ChessState* chess_state_new (const gchar* fen) {
	return chess_state_construct (TYPE_CHESS_STATE, fen);
}


ChessState* chess_state_copy (ChessState* self) {
	ChessState* result = NULL;
	ChessState* state = NULL;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	ChessState* _tmp3_ = NULL;
	ChessPlayer* _tmp4_ = NULL;
	ChessPlayer* _tmp5_ = NULL;
	ChessPlayer* _tmp6_ = NULL;
	ChessState* _tmp7_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	ChessPlayer* _tmp9_ = NULL;
	ChessPlayer* _tmp10_ = NULL;
	ChessState* _tmp11_ = NULL;
	ChessPlayer* _tmp12_ = NULL;
	ChessPlayer* _tmp13_ = NULL;
	ChessState* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	ChessState* _tmp17_ = NULL;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp19_ = FALSE;
	ChessState* _tmp20_ = NULL;
	gboolean _tmp21_ = FALSE;
	gboolean _tmp22_ = FALSE;
	ChessState* _tmp23_ = NULL;
	gboolean _tmp24_ = FALSE;
	gboolean _tmp25_ = FALSE;
	ChessState* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	ChessState* _tmp28_ = NULL;
	CheckState _tmp29_ = 0;
	ChessMove* _tmp30_ = NULL;
	ChessState* _tmp43_ = NULL;
	gint64 _tmp44_ = 0LL;
	gint64 _tmp45_ = 0LL;
	ChessState* _tmp46_ = NULL;
	gint64 _tmp47_ = 0LL;
	gint64 _tmp48_ = 0LL;
	ChessState* _tmp49_ = NULL;
	gint _tmp50_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_state_new_empty ();
	state = _tmp0_;
	_tmp1_ = state;
	_tmp2_ = self->number;
	_tmp1_->number = _tmp2_;
	_tmp3_ = state;
	_tmp4_ = self->players[COLOR_WHITE];
	_tmp5_ = _g_object_ref0 (_tmp4_);
	_g_object_unref0 (_tmp3_->players[COLOR_WHITE]);
	_tmp3_->players[COLOR_WHITE] = _tmp5_;
	_tmp6_ = _tmp3_->players[COLOR_WHITE];
	_tmp7_ = state;
	_tmp8_ = self->players[COLOR_BLACK];
	_tmp9_ = _g_object_ref0 (_tmp8_);
	_g_object_unref0 (_tmp7_->players[COLOR_BLACK]);
	_tmp7_->players[COLOR_BLACK] = _tmp9_;
	_tmp10_ = _tmp7_->players[COLOR_BLACK];
	_tmp11_ = state;
	_tmp12_ = self->current_player;
	_tmp13_ = _g_object_ref0 (_tmp12_);
	_g_object_unref0 (_tmp11_->current_player);
	_tmp11_->current_player = _tmp13_;
	_tmp14_ = state;
	_tmp15_ = self->can_castle_kingside[COLOR_WHITE];
	_tmp14_->can_castle_kingside[COLOR_WHITE] = _tmp15_;
	_tmp16_ = _tmp14_->can_castle_kingside[COLOR_WHITE];
	_tmp17_ = state;
	_tmp18_ = self->can_castle_queenside[COLOR_WHITE];
	_tmp17_->can_castle_queenside[COLOR_WHITE] = _tmp18_;
	_tmp19_ = _tmp17_->can_castle_queenside[COLOR_WHITE];
	_tmp20_ = state;
	_tmp21_ = self->can_castle_kingside[COLOR_BLACK];
	_tmp20_->can_castle_kingside[COLOR_BLACK] = _tmp21_;
	_tmp22_ = _tmp20_->can_castle_kingside[COLOR_BLACK];
	_tmp23_ = state;
	_tmp24_ = self->can_castle_queenside[COLOR_BLACK];
	_tmp23_->can_castle_queenside[COLOR_BLACK] = _tmp24_;
	_tmp25_ = _tmp23_->can_castle_queenside[COLOR_BLACK];
	_tmp26_ = state;
	_tmp27_ = self->en_passant_index;
	_tmp26_->en_passant_index = _tmp27_;
	_tmp28_ = state;
	_tmp29_ = self->check_state;
	_tmp28_->check_state = _tmp29_;
	_tmp30_ = self->last_move;
	if (_tmp30_ != NULL) {
		ChessState* _tmp31_ = NULL;
		ChessMove* _tmp32_ = NULL;
		ChessMove* _tmp33_ = NULL;
		_tmp31_ = state;
		_tmp32_ = self->last_move;
		_tmp33_ = chess_move_copy (_tmp32_);
		_chess_move_unref0 (_tmp31_->last_move);
		_tmp31_->last_move = _tmp33_;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp34_ = FALSE;
			_tmp34_ = TRUE;
			while (TRUE) {
				gint _tmp36_ = 0;
				ChessState* _tmp37_ = NULL;
				gint _tmp38_ = 0;
				gint _tmp39_ = 0;
				ChessPiece* _tmp40_ = NULL;
				ChessPiece* _tmp41_ = NULL;
				ChessPiece* _tmp42_ = NULL;
				if (!_tmp34_) {
					gint _tmp35_ = 0;
					_tmp35_ = i;
					i = _tmp35_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp36_ = i;
				if (!(_tmp36_ < 64)) {
					break;
				}
				_tmp37_ = state;
				_tmp38_ = i;
				_tmp39_ = i;
				_tmp40_ = self->board[_tmp39_];
				_tmp41_ = _chess_piece_ref0 (_tmp40_);
				_chess_piece_unref0 (_tmp37_->board[_tmp38_]);
				_tmp37_->board[_tmp38_] = _tmp41_;
				_tmp42_ = _tmp37_->board[_tmp38_];
			}
		}
	}
	_tmp43_ = state;
	_tmp44_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp43_->priv->piece_masks[COLOR_WHITE] = _tmp44_;
	_tmp45_ = _tmp43_->priv->piece_masks[COLOR_WHITE];
	_tmp46_ = state;
	_tmp47_ = self->priv->piece_masks[COLOR_BLACK];
	_tmp46_->priv->piece_masks[COLOR_BLACK] = _tmp47_;
	_tmp48_ = _tmp46_->priv->piece_masks[COLOR_BLACK];
	_tmp49_ = state;
	_tmp50_ = self->halfmove_clock;
	_tmp49_->halfmove_clock = _tmp50_;
	result = state;
	return result;
}


gboolean chess_state_equals (ChessState* self, ChessState* state) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gint64 _tmp7_ = 0LL;
	ChessState* _tmp8_ = NULL;
	gint64 _tmp9_ = 0LL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (state != NULL, FALSE);
	_tmp7_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp8_ = state;
	_tmp9_ = _tmp8_->priv->piece_masks[COLOR_WHITE];
	if (_tmp7_ != _tmp9_) {
		_tmp6_ = TRUE;
	} else {
		gint64 _tmp10_ = 0LL;
		ChessState* _tmp11_ = NULL;
		gint64 _tmp12_ = 0LL;
		_tmp10_ = self->priv->piece_masks[COLOR_BLACK];
		_tmp11_ = state;
		_tmp12_ = _tmp11_->priv->piece_masks[COLOR_BLACK];
		_tmp6_ = _tmp10_ != _tmp12_;
	}
	if (_tmp6_) {
		_tmp5_ = TRUE;
	} else {
		ChessPlayer* _tmp13_ = NULL;
		Color _tmp14_ = 0;
		ChessState* _tmp15_ = NULL;
		ChessPlayer* _tmp16_ = NULL;
		Color _tmp17_ = 0;
		_tmp13_ = self->current_player;
		_tmp14_ = _tmp13_->color;
		_tmp15_ = state;
		_tmp16_ = _tmp15_->current_player;
		_tmp17_ = _tmp16_->color;
		_tmp5_ = _tmp14_ != _tmp17_;
	}
	if (_tmp5_) {
		_tmp4_ = TRUE;
	} else {
		gboolean _tmp18_ = FALSE;
		ChessState* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		_tmp18_ = self->can_castle_kingside[COLOR_WHITE];
		_tmp19_ = state;
		_tmp20_ = _tmp19_->can_castle_kingside[COLOR_WHITE];
		_tmp4_ = _tmp18_ != _tmp20_;
	}
	if (_tmp4_) {
		_tmp3_ = TRUE;
	} else {
		gboolean _tmp21_ = FALSE;
		ChessState* _tmp22_ = NULL;
		gboolean _tmp23_ = FALSE;
		_tmp21_ = self->can_castle_queenside[COLOR_WHITE];
		_tmp22_ = state;
		_tmp23_ = _tmp22_->can_castle_queenside[COLOR_WHITE];
		_tmp3_ = _tmp21_ != _tmp23_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		gboolean _tmp24_ = FALSE;
		ChessState* _tmp25_ = NULL;
		gboolean _tmp26_ = FALSE;
		_tmp24_ = self->can_castle_kingside[COLOR_BLACK];
		_tmp25_ = state;
		_tmp26_ = _tmp25_->can_castle_kingside[COLOR_BLACK];
		_tmp2_ = _tmp24_ != _tmp26_;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp27_ = FALSE;
		ChessState* _tmp28_ = NULL;
		gboolean _tmp29_ = FALSE;
		_tmp27_ = self->can_castle_queenside[COLOR_BLACK];
		_tmp28_ = state;
		_tmp29_ = _tmp28_->can_castle_queenside[COLOR_BLACK];
		_tmp1_ = _tmp27_ != _tmp29_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		gint _tmp30_ = 0;
		ChessState* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		_tmp30_ = self->en_passant_index;
		_tmp31_ = state;
		_tmp32_ = _tmp31_->en_passant_index;
		_tmp0_ = _tmp30_ != _tmp32_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp33_ = FALSE;
			_tmp33_ = TRUE;
			while (TRUE) {
				gint _tmp35_ = 0;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_ = 0;
				ChessPiece* _tmp38_ = NULL;
				if (!_tmp33_) {
					gint _tmp34_ = 0;
					_tmp34_ = i;
					i = _tmp34_ + 1;
				}
				_tmp33_ = FALSE;
				_tmp35_ = i;
				if (!(_tmp35_ < 64)) {
					break;
				}
				_tmp37_ = i;
				_tmp38_ = self->board[_tmp37_];
				if (_tmp38_ != NULL) {
					gint _tmp39_ = 0;
					ChessPiece* _tmp40_ = NULL;
					PieceType _tmp41_ = 0;
					ChessState* _tmp42_ = NULL;
					gint _tmp43_ = 0;
					ChessPiece* _tmp44_ = NULL;
					PieceType _tmp45_ = 0;
					_tmp39_ = i;
					_tmp40_ = self->board[_tmp39_];
					_tmp41_ = _tmp40_->type;
					_tmp42_ = state;
					_tmp43_ = i;
					_tmp44_ = _tmp42_->board[_tmp43_];
					_tmp45_ = _tmp44_->type;
					_tmp36_ = _tmp41_ != _tmp45_;
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
					result = FALSE;
					return result;
				}
			}
		}
	}
	result = TRUE;
	return result;
}


gchar* chess_state_get_fen (ChessState* self) {
	gchar* result = NULL;
	GString* value = NULL;
	GString* _tmp0_ = NULL;
	GString* _tmp26_ = NULL;
	ChessPlayer* _tmp27_ = NULL;
	Color _tmp28_ = 0;
	GString* _tmp31_ = NULL;
	gboolean _tmp32_ = FALSE;
	gboolean _tmp34_ = FALSE;
	gboolean _tmp36_ = FALSE;
	gboolean _tmp38_ = FALSE;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	gboolean _tmp43_ = FALSE;
	GString* _tmp45_ = NULL;
	gint _tmp46_ = 0;
	GString* _tmp53_ = NULL;
	GString* _tmp54_ = NULL;
	gint _tmp55_ = 0;
	GString* _tmp56_ = NULL;
	ChessPlayer* _tmp57_ = NULL;
	Color _tmp58_ = 0;
	GString* _tmp63_ = NULL;
	const gchar* _tmp64_ = NULL;
	gchar* _tmp65_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = g_string_new ("");
	value = _tmp0_;
	{
		gint rank = 0;
		rank = 7;
		{
			gboolean _tmp1_ = FALSE;
			_tmp1_ = TRUE;
			while (TRUE) {
				gint _tmp3_ = 0;
				gint skip_count = 0;
				gint _tmp21_ = 0;
				gint _tmp24_ = 0;
				if (!_tmp1_) {
					gint _tmp2_ = 0;
					_tmp2_ = rank;
					rank = _tmp2_ - 1;
				}
				_tmp1_ = FALSE;
				_tmp3_ = rank;
				if (!(_tmp3_ >= 0)) {
					break;
				}
				skip_count = 0;
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp4_ = FALSE;
						_tmp4_ = TRUE;
						while (TRUE) {
							gint _tmp6_ = 0;
							ChessPiece* p = NULL;
							gint _tmp7_ = 0;
							gint _tmp8_ = 0;
							gint _tmp9_ = 0;
							ChessPiece* _tmp10_ = NULL;
							ChessPiece* _tmp11_ = NULL;
							ChessPiece* _tmp12_ = NULL;
							if (!_tmp4_) {
								gint _tmp5_ = 0;
								_tmp5_ = file;
								file = _tmp5_ + 1;
							}
							_tmp4_ = FALSE;
							_tmp6_ = file;
							if (!(_tmp6_ < 8)) {
								break;
							}
							_tmp7_ = rank;
							_tmp8_ = file;
							_tmp9_ = chess_state_get_index (self, _tmp7_, _tmp8_);
							_tmp10_ = self->board[_tmp9_];
							_tmp11_ = _chess_piece_ref0 (_tmp10_);
							p = _tmp11_;
							_tmp12_ = p;
							if (_tmp12_ == NULL) {
								gint _tmp13_ = 0;
								_tmp13_ = skip_count;
								skip_count = _tmp13_ + 1;
							} else {
								gint _tmp14_ = 0;
								GString* _tmp17_ = NULL;
								ChessPiece* _tmp18_ = NULL;
								gunichar _tmp19_ = 0U;
								gunichar _tmp20_ = 0U;
								_tmp14_ = skip_count;
								if (_tmp14_ > 0) {
									GString* _tmp15_ = NULL;
									gint _tmp16_ = 0;
									_tmp15_ = value;
									_tmp16_ = skip_count;
									g_string_append_printf (_tmp15_, "%d", _tmp16_);
									skip_count = 0;
								}
								_tmp17_ = value;
								_tmp18_ = p;
								_tmp19_ = chess_piece_get_symbol (_tmp18_);
								_tmp20_ = _tmp19_;
								g_string_append_printf (_tmp17_, "%c", (gint) _tmp20_);
							}
							_chess_piece_unref0 (p);
						}
					}
				}
				_tmp21_ = skip_count;
				if (_tmp21_ > 0) {
					GString* _tmp22_ = NULL;
					gint _tmp23_ = 0;
					_tmp22_ = value;
					_tmp23_ = skip_count;
					g_string_append_printf (_tmp22_, "%d", _tmp23_);
				}
				_tmp24_ = rank;
				if (_tmp24_ != 0) {
					GString* _tmp25_ = NULL;
					_tmp25_ = value;
					g_string_append_c (_tmp25_, '/');
				}
			}
		}
	}
	_tmp26_ = value;
	g_string_append_c (_tmp26_, ' ');
	_tmp27_ = self->current_player;
	_tmp28_ = _tmp27_->color;
	if (_tmp28_ == COLOR_WHITE) {
		GString* _tmp29_ = NULL;
		_tmp29_ = value;
		g_string_append_c (_tmp29_, 'w');
	} else {
		GString* _tmp30_ = NULL;
		_tmp30_ = value;
		g_string_append_c (_tmp30_, 'b');
	}
	_tmp31_ = value;
	g_string_append_c (_tmp31_, ' ');
	_tmp32_ = self->can_castle_kingside[COLOR_WHITE];
	if (_tmp32_) {
		GString* _tmp33_ = NULL;
		_tmp33_ = value;
		g_string_append_c (_tmp33_, 'K');
	}
	_tmp34_ = self->can_castle_queenside[COLOR_WHITE];
	if (_tmp34_) {
		GString* _tmp35_ = NULL;
		_tmp35_ = value;
		g_string_append_c (_tmp35_, 'Q');
	}
	_tmp36_ = self->can_castle_kingside[COLOR_BLACK];
	if (_tmp36_) {
		GString* _tmp37_ = NULL;
		_tmp37_ = value;
		g_string_append_c (_tmp37_, 'k');
	}
	_tmp38_ = self->can_castle_queenside[COLOR_BLACK];
	if (_tmp38_) {
		GString* _tmp39_ = NULL;
		_tmp39_ = value;
		g_string_append_c (_tmp39_, 'q');
	}
	_tmp40_ = self->can_castle_kingside[COLOR_WHITE];
	_tmp41_ = self->can_castle_queenside[COLOR_WHITE];
	_tmp42_ = self->can_castle_kingside[COLOR_BLACK];
	_tmp43_ = self->can_castle_queenside[COLOR_BLACK];
	if (!(((_tmp40_ | _tmp41_) | _tmp42_) | _tmp43_)) {
		GString* _tmp44_ = NULL;
		_tmp44_ = value;
		g_string_append_c (_tmp44_, '-');
	}
	_tmp45_ = value;
	g_string_append_c (_tmp45_, ' ');
	_tmp46_ = self->en_passant_index;
	if (_tmp46_ >= 0) {
		GString* _tmp47_ = NULL;
		gint _tmp48_ = 0;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		_tmp47_ = value;
		_tmp48_ = self->en_passant_index;
		_tmp49_ = chess_state_get_file (self, _tmp48_);
		_tmp50_ = self->en_passant_index;
		_tmp51_ = chess_state_get_rank (self, _tmp50_);
		g_string_append_printf (_tmp47_, "%c%d", 'a' + _tmp49_, _tmp51_ + 1);
	} else {
		GString* _tmp52_ = NULL;
		_tmp52_ = value;
		g_string_append_c (_tmp52_, '-');
	}
	_tmp53_ = value;
	g_string_append_c (_tmp53_, ' ');
	_tmp54_ = value;
	_tmp55_ = self->halfmove_clock;
	g_string_append_printf (_tmp54_, "%d", _tmp55_);
	_tmp56_ = value;
	g_string_append_c (_tmp56_, ' ');
	_tmp57_ = self->current_player;
	_tmp58_ = _tmp57_->color;
	if (_tmp58_ == COLOR_WHITE) {
		GString* _tmp59_ = NULL;
		gint _tmp60_ = 0;
		_tmp59_ = value;
		_tmp60_ = self->number;
		g_string_append_printf (_tmp59_, "%d", _tmp60_ / 2);
	} else {
		GString* _tmp61_ = NULL;
		gint _tmp62_ = 0;
		_tmp61_ = value;
		_tmp62_ = self->number;
		g_string_append_printf (_tmp61_, "%d", (_tmp62_ / 2) + 1);
	}
	_tmp63_ = value;
	_tmp64_ = _tmp63_->str;
	_tmp65_ = g_strdup (_tmp64_);
	result = _tmp65_;
	_g_string_free0 (value);
	return result;
}


gint chess_state_get_index (ChessState* self, gint rank, gint file) {
	gint result = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = rank;
	_tmp1_ = file;
	result = (_tmp0_ * 8) + _tmp1_;
	return result;
}


gint chess_state_get_rank (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	result = _tmp0_ / 8;
	return result;
}


gint chess_state_get_file (ChessState* self, gint index) {
	gint result = 0;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = index;
	result = _tmp0_ % 8;
	return result;
}


gboolean chess_state_move (ChessState* self, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gint r0 = 0;
	gint f0 = 0;
	gint r1 = 0;
	gint f1 = 0;
	PieceType promotion_type = 0;
	ChessPlayer* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	PieceType _tmp6_ = 0;
	gboolean _tmp7_ = FALSE;
	ChessPlayer* _tmp8_ = NULL;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	PieceType _tmp13_ = 0;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = self->current_player;
	_tmp1_ = move;
	_tmp7_ = chess_state_decode_move (self, _tmp0_, _tmp1_, &_tmp2_, &_tmp3_, &_tmp4_, &_tmp5_, &_tmp6_);
	r0 = _tmp2_;
	f0 = _tmp3_;
	r1 = _tmp4_;
	f1 = _tmp5_;
	promotion_type = _tmp6_;
	if (!_tmp7_) {
		result = FALSE;
		return result;
	}
	_tmp8_ = self->current_player;
	_tmp9_ = r0;
	_tmp10_ = f0;
	_tmp11_ = r1;
	_tmp12_ = f1;
	_tmp13_ = promotion_type;
	_tmp14_ = apply;
	_tmp15_ = chess_state_move_with_coords (self, _tmp8_, _tmp9_, _tmp10_, _tmp11_, _tmp12_, _tmp13_, _tmp14_, TRUE);
	if (!_tmp15_) {
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


gboolean chess_state_move_with_coords (ChessState* self, ChessPlayer* player, gint r0, gint f0, gint r1, gint f1, PieceType promotion_type, gboolean apply, gboolean test_check) {
	gboolean result = FALSE;
	gint start = 0;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint end = 0;
	gint _tmp3_ = 0;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	Color color = 0;
	ChessPlayer* _tmp6_ = NULL;
	Color _tmp7_ = 0;
	Color _tmp8_ = 0;
	Color _tmp9_ = 0;
	Color opponent_color = 0;
	ChessPiece* piece = NULL;
	gint _tmp10_ = 0;
	ChessPiece* _tmp11_ = NULL;
	ChessPiece* _tmp12_ = NULL;
	gboolean _tmp13_ = FALSE;
	ChessPiece* _tmp14_ = NULL;
	gint64 end_mask = 0LL;
	gint _tmp18_ = 0;
	gint64 _tmp19_ = 0LL;
	gint64 move_mask = 0LL;
	Color _tmp20_ = 0;
	ChessPiece* _tmp21_ = NULL;
	PieceType _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint64 _tmp24_ = 0LL;
	gint64 _tmp25_ = 0LL;
	gint64 _tmp26_ = 0LL;
	gint64 over_mask = 0LL;
	gint _tmp27_ = 0;
	gint _tmp28_ = 0;
	gint64 _tmp29_ = 0LL;
	gint64 _tmp30_ = 0LL;
	gint64 _tmp31_ = 0LL;
	gint64 _tmp32_ = 0LL;
	ChessPiece* victim = NULL;
	gint _tmp33_ = 0;
	ChessPiece* _tmp34_ = NULL;
	ChessPiece* _tmp35_ = NULL;
	gint victim_index = 0;
	gint _tmp36_ = 0;
	gboolean _tmp37_ = FALSE;
	ChessPiece* _tmp38_ = NULL;
	gint rook_start = 0;
	gint rook_end = 0;
	gboolean is_promotion = FALSE;
	gboolean ambiguous_rank = FALSE;
	gboolean ambiguous_file = FALSE;
	ChessPiece* _tmp42_ = NULL;
	PieceType _tmp43_ = 0;
	gboolean _tmp111_ = FALSE;
	gboolean _tmp112_ = FALSE;
	gboolean _tmp114_ = FALSE;
	gint64 old_white_mask = 0LL;
	gint64 _tmp147_ = 0LL;
	gint64 old_black_mask = 0LL;
	gint64 _tmp148_ = 0LL;
	gboolean old_white_can_castle_kingside = FALSE;
	gboolean _tmp149_ = FALSE;
	gboolean old_white_can_castle_queenside = FALSE;
	gboolean _tmp150_ = FALSE;
	gboolean old_black_can_castle_kingside = FALSE;
	gboolean _tmp151_ = FALSE;
	gboolean old_black_can_castle_queenside = FALSE;
	gboolean _tmp152_ = FALSE;
	gint old_en_passant_index = 0;
	gint _tmp153_ = 0;
	gint old_halfmove_clock = 0;
	gint _tmp154_ = 0;
	gint _tmp155_ = 0;
	ChessPiece* _tmp156_ = NULL;
	gint _tmp157_ = 0;
	gint64 _tmp158_ = 0LL;
	gint64 _tmp159_ = 0LL;
	gint _tmp160_ = 0;
	gint64 _tmp161_ = 0LL;
	gint64 _tmp162_ = 0LL;
	ChessPiece* _tmp163_ = NULL;
	gboolean _tmp172_ = FALSE;
	Color _tmp182_ = 0;
	gint64 _tmp183_ = 0LL;
	gint64 _tmp184_ = 0LL;
	Color _tmp185_ = 0;
	gint _tmp186_ = 0;
	gint64 _tmp187_ = 0LL;
	gint64 _tmp188_ = 0LL;
	gint _tmp189_ = 0;
	ChessPiece* _tmp207_ = NULL;
	PieceType _tmp208_ = 0;
	gboolean _tmp239_ = FALSE;
	ChessPiece* _tmp240_ = NULL;
	PieceType _tmp241_ = 0;
	gboolean _tmp247_ = FALSE;
	ChessPiece* _tmp248_ = NULL;
	PieceType _tmp249_ = 0;
	gboolean _result_ = FALSE;
	gboolean _tmp252_ = FALSE;
	gboolean _tmp253_ = FALSE;
	gboolean _tmp256_ = FALSE;
	gboolean _tmp257_ = FALSE;
	ChessPlayer* _tmp294_ = NULL;
	Color _tmp295_ = 0;
	ChessPlayer* _tmp298_ = NULL;
	ChessPlayer* _tmp299_ = NULL;
	CheckState _tmp300_ = 0;
	ChessMove* _tmp301_ = NULL;
	ChessMove* _tmp302_ = NULL;
	gint _tmp303_ = 0;
	ChessMove* _tmp304_ = NULL;
	ChessPiece* _tmp305_ = NULL;
	ChessPiece* _tmp306_ = NULL;
	gboolean _tmp307_ = FALSE;
	ChessMove* _tmp312_ = NULL;
	ChessPiece* _tmp313_ = NULL;
	ChessPiece* _tmp314_ = NULL;
	gint _tmp315_ = 0;
	ChessMove* _tmp320_ = NULL;
	gint _tmp321_ = 0;
	ChessMove* _tmp322_ = NULL;
	gint _tmp323_ = 0;
	ChessMove* _tmp324_ = NULL;
	gint _tmp325_ = 0;
	ChessMove* _tmp326_ = NULL;
	gint _tmp327_ = 0;
	ChessMove* _tmp328_ = NULL;
	gboolean _tmp329_ = FALSE;
	ChessMove* _tmp330_ = NULL;
	gboolean _tmp331_ = FALSE;
	ChessMove* _tmp332_ = NULL;
	CheckState _tmp333_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = r0;
	_tmp1_ = f0;
	_tmp2_ = chess_state_get_index (self, _tmp0_, _tmp1_);
	start = _tmp2_;
	_tmp3_ = r1;
	_tmp4_ = f1;
	_tmp5_ = chess_state_get_index (self, _tmp3_, _tmp4_);
	end = _tmp5_;
	_tmp6_ = player;
	_tmp7_ = _tmp6_->color;
	color = _tmp7_;
	_tmp9_ = color;
	if (_tmp9_ == COLOR_WHITE) {
		_tmp8_ = COLOR_BLACK;
	} else {
		_tmp8_ = COLOR_WHITE;
	}
	opponent_color = _tmp8_;
	_tmp10_ = start;
	_tmp11_ = self->board[_tmp10_];
	_tmp12_ = _chess_piece_ref0 (_tmp11_);
	piece = _tmp12_;
	_tmp14_ = piece;
	if (_tmp14_ == NULL) {
		_tmp13_ = TRUE;
	} else {
		ChessPiece* _tmp15_ = NULL;
		ChessPlayer* _tmp16_ = NULL;
		ChessPlayer* _tmp17_ = NULL;
		_tmp15_ = piece;
		_tmp16_ = _tmp15_->player;
		_tmp17_ = player;
		_tmp13_ = _tmp16_ != _tmp17_;
	}
	if (_tmp13_) {
		result = FALSE;
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp18_ = end;
	_tmp19_ = BIT_BOARD_set_location_masks[_tmp18_];
	end_mask = _tmp19_;
	_tmp20_ = color;
	_tmp21_ = piece;
	_tmp22_ = _tmp21_->type;
	_tmp23_ = start;
	_tmp24_ = BIT_BOARD_move_masks[(((_tmp20_ * 64) * 6) + (_tmp22_ * 64)) + _tmp23_];
	move_mask = _tmp24_;
	_tmp25_ = end_mask;
	_tmp26_ = move_mask;
	if ((_tmp25_ & _tmp26_) == ((gint64) 0)) {
		result = FALSE;
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp27_ = start;
	_tmp28_ = end;
	_tmp29_ = BIT_BOARD_over_masks[(_tmp27_ * 64) + _tmp28_];
	over_mask = _tmp29_;
	_tmp30_ = over_mask;
	_tmp31_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp32_ = self->priv->piece_masks[COLOR_BLACK];
	if ((_tmp30_ & (_tmp31_ | _tmp32_)) != ((gint64) 0)) {
		result = FALSE;
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp33_ = end;
	_tmp34_ = self->board[_tmp33_];
	_tmp35_ = _chess_piece_ref0 (_tmp34_);
	victim = _tmp35_;
	_tmp36_ = end;
	victim_index = _tmp36_;
	_tmp38_ = victim;
	if (_tmp38_ != NULL) {
		ChessPiece* _tmp39_ = NULL;
		ChessPlayer* _tmp40_ = NULL;
		ChessPlayer* _tmp41_ = NULL;
		_tmp39_ = victim;
		_tmp40_ = _tmp39_->player;
		_tmp41_ = player;
		_tmp37_ = _tmp40_ == _tmp41_;
	} else {
		_tmp37_ = FALSE;
	}
	if (_tmp37_) {
		result = FALSE;
		_chess_piece_unref0 (victim);
		_chess_piece_unref0 (piece);
		return result;
	}
	rook_start = -1;
	rook_end = -1;
	is_promotion = FALSE;
	ambiguous_rank = FALSE;
	ambiguous_file = FALSE;
	_tmp42_ = piece;
	_tmp43_ = _tmp42_->type;
	switch (_tmp43_) {
		case PIECE_TYPE_PAWN:
		{
			gboolean _tmp44_ = FALSE;
			ChessPiece* _tmp45_ = NULL;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			gboolean _tmp59_ = FALSE;
			gint _tmp60_ = 0;
			ChessPiece* _tmp62_ = NULL;
			_tmp45_ = victim;
			if (_tmp45_ == NULL) {
				gint _tmp46_ = 0;
				gint _tmp47_ = 0;
				_tmp46_ = end;
				_tmp47_ = self->en_passant_index;
				_tmp44_ = _tmp46_ == _tmp47_;
			} else {
				_tmp44_ = FALSE;
			}
			if (_tmp44_) {
				gint _tmp48_ = 0;
				gint _tmp49_ = 0;
				gint _tmp50_ = 0;
				gint _tmp51_ = 0;
				gint _tmp52_ = 0;
				ChessPiece* _tmp53_ = NULL;
				ChessPiece* _tmp54_ = NULL;
				_tmp49_ = r1;
				if (_tmp49_ == 2) {
					_tmp48_ = 3;
				} else {
					_tmp48_ = 4;
				}
				_tmp50_ = f1;
				_tmp51_ = chess_state_get_index (self, _tmp48_, _tmp50_);
				victim_index = _tmp51_;
				_tmp52_ = victim_index;
				_tmp53_ = self->board[_tmp52_];
				_tmp54_ = _chess_piece_ref0 (_tmp53_);
				_chess_piece_unref0 (victim);
				victim = _tmp54_;
			}
			_tmp55_ = f0;
			_tmp56_ = f1;
			if (_tmp55_ != _tmp56_) {
				ChessPiece* _tmp57_ = NULL;
				_tmp57_ = victim;
				if (_tmp57_ == NULL) {
					result = FALSE;
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
			} else {
				ChessPiece* _tmp58_ = NULL;
				_tmp58_ = victim;
				if (_tmp58_ != NULL) {
					result = FALSE;
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
			}
			_tmp60_ = r1;
			if (_tmp60_ == 0) {
				_tmp59_ = TRUE;
			} else {
				gint _tmp61_ = 0;
				_tmp61_ = r1;
				_tmp59_ = _tmp61_ == 7;
			}
			is_promotion = _tmp59_;
			_tmp62_ = victim;
			if (_tmp62_ != NULL) {
				ambiguous_file = TRUE;
			}
			break;
		}
		case PIECE_TYPE_KING:
		{
			gint _tmp63_ = 0;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			_tmp63_ = f0;
			_tmp64_ = f1;
			_tmp65_ = abs (_tmp63_ - _tmp64_);
			if (_tmp65_ > 1) {
				gint _tmp66_ = 0;
				gint _tmp67_ = 0;
				gint _tmp68_ = 0;
				gint _tmp69_ = 0;
				gint _tmp70_ = 0;
				gint _tmp71_ = 0;
				gint _tmp72_ = 0;
				gint _tmp73_ = 0;
				gint _tmp76_ = 0;
				gint _tmp77_ = 0;
				gint _tmp78_ = 0;
				gint _tmp79_ = 0;
				ChessPiece* rook = NULL;
				gint _tmp84_ = 0;
				ChessPiece* _tmp85_ = NULL;
				ChessPiece* _tmp86_ = NULL;
				gboolean _tmp87_ = FALSE;
				gboolean _tmp88_ = FALSE;
				ChessPiece* _tmp89_ = NULL;
				gint64 rook_over_mask = 0LL;
				gint _tmp96_ = 0;
				gint _tmp97_ = 0;
				gint64 _tmp98_ = 0LL;
				gint64 _tmp99_ = 0LL;
				gint64 _tmp100_ = 0LL;
				gint64 _tmp101_ = 0LL;
				CheckState _tmp102_ = 0;
				ChessPlayer* _tmp103_ = NULL;
				gint _tmp104_ = 0;
				gint _tmp105_ = 0;
				gint _tmp106_ = 0;
				gint _tmp107_ = 0;
				gint _tmp108_ = 0;
				gint _tmp109_ = 0;
				gboolean _tmp110_ = FALSE;
				_tmp67_ = f1;
				_tmp68_ = f0;
				if (_tmp67_ > _tmp68_) {
					_tmp66_ = 7;
				} else {
					_tmp66_ = 0;
				}
				_tmp69_ = r0;
				_tmp70_ = chess_state_get_index (self, _tmp69_, _tmp66_);
				rook_start = _tmp70_;
				_tmp72_ = f1;
				_tmp73_ = f0;
				if (_tmp72_ > _tmp73_) {
					gint _tmp74_ = 0;
					_tmp74_ = f1;
					_tmp71_ = _tmp74_ - 1;
				} else {
					gint _tmp75_ = 0;
					_tmp75_ = f1;
					_tmp71_ = _tmp75_ + 1;
				}
				_tmp76_ = r0;
				_tmp77_ = chess_state_get_index (self, _tmp76_, _tmp71_);
				rook_end = _tmp77_;
				_tmp78_ = f1;
				_tmp79_ = f0;
				if (_tmp78_ > _tmp79_) {
					Color _tmp80_ = 0;
					gboolean _tmp81_ = FALSE;
					_tmp80_ = color;
					_tmp81_ = self->can_castle_kingside[_tmp80_];
					if (!_tmp81_) {
						result = FALSE;
						_chess_piece_unref0 (victim);
						_chess_piece_unref0 (piece);
						return result;
					}
				} else {
					Color _tmp82_ = 0;
					gboolean _tmp83_ = FALSE;
					_tmp82_ = color;
					_tmp83_ = self->can_castle_queenside[_tmp82_];
					if (!_tmp83_) {
						result = FALSE;
						_chess_piece_unref0 (victim);
						_chess_piece_unref0 (piece);
						return result;
					}
				}
				_tmp84_ = rook_start;
				_tmp85_ = self->board[_tmp84_];
				_tmp86_ = _chess_piece_ref0 (_tmp85_);
				rook = _tmp86_;
				_tmp89_ = rook;
				if (_tmp89_ == NULL) {
					_tmp88_ = TRUE;
				} else {
					ChessPiece* _tmp90_ = NULL;
					PieceType _tmp91_ = 0;
					_tmp90_ = rook;
					_tmp91_ = _tmp90_->type;
					_tmp88_ = _tmp91_ != PIECE_TYPE_ROOK;
				}
				if (_tmp88_) {
					_tmp87_ = TRUE;
				} else {
					ChessPiece* _tmp92_ = NULL;
					Color _tmp93_ = 0;
					Color _tmp94_ = 0;
					Color _tmp95_ = 0;
					_tmp92_ = rook;
					_tmp93_ = chess_piece_get_color (_tmp92_);
					_tmp94_ = _tmp93_;
					_tmp95_ = color;
					_tmp87_ = _tmp94_ != _tmp95_;
				}
				if (_tmp87_) {
					result = FALSE;
					_chess_piece_unref0 (rook);
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
				_tmp96_ = rook_start;
				_tmp97_ = rook_end;
				_tmp98_ = BIT_BOARD_over_masks[(_tmp96_ * 64) + _tmp97_];
				rook_over_mask = _tmp98_;
				_tmp99_ = rook_over_mask;
				_tmp100_ = self->priv->piece_masks[COLOR_WHITE];
				_tmp101_ = self->priv->piece_masks[COLOR_BLACK];
				if ((_tmp99_ & (_tmp100_ | _tmp101_)) != ((gint64) 0)) {
					result = FALSE;
					_chess_piece_unref0 (rook);
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
				_tmp102_ = self->check_state;
				if (_tmp102_ == CHECK_STATE_CHECK) {
					result = FALSE;
					_chess_piece_unref0 (rook);
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
				_tmp103_ = player;
				_tmp104_ = r0;
				_tmp105_ = f0;
				_tmp106_ = rook_end;
				_tmp107_ = chess_state_get_rank (self, _tmp106_);
				_tmp108_ = rook_end;
				_tmp109_ = chess_state_get_file (self, _tmp108_);
				_tmp110_ = chess_state_move_with_coords (self, _tmp103_, _tmp104_, _tmp105_, _tmp107_, _tmp109_, PIECE_TYPE_QUEEN, FALSE, TRUE);
				if (!_tmp110_) {
					result = FALSE;
					_chess_piece_unref0 (rook);
					_chess_piece_unref0 (victim);
					_chess_piece_unref0 (piece);
					return result;
				}
				_chess_piece_unref0 (rook);
			}
			break;
		}
		default:
		{
			break;
		}
	}
	_tmp112_ = apply;
	if (!_tmp112_) {
		gboolean _tmp113_ = FALSE;
		_tmp113_ = test_check;
		_tmp111_ = !_tmp113_;
	} else {
		_tmp111_ = FALSE;
	}
	if (_tmp111_) {
		result = TRUE;
		_chess_piece_unref0 (victim);
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp114_ = apply;
	if (_tmp114_) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp115_ = FALSE;
				_tmp115_ = TRUE;
				while (TRUE) {
					gint _tmp117_ = 0;
					gint _tmp118_ = 0;
					gint _tmp119_ = 0;
					ChessPiece* p = NULL;
					gint _tmp120_ = 0;
					ChessPiece* _tmp121_ = NULL;
					ChessPiece* _tmp122_ = NULL;
					gboolean _tmp123_ = FALSE;
					gboolean _tmp124_ = FALSE;
					ChessPiece* _tmp125_ = NULL;
					gint r = 0;
					gint _tmp133_ = 0;
					gint _tmp134_ = 0;
					gint f = 0;
					gint _tmp135_ = 0;
					gint _tmp136_ = 0;
					ChessPlayer* _tmp137_ = NULL;
					gint _tmp138_ = 0;
					gint _tmp139_ = 0;
					gint _tmp140_ = 0;
					gint _tmp141_ = 0;
					gboolean _tmp142_ = FALSE;
					if (!_tmp115_) {
						gint _tmp116_ = 0;
						_tmp116_ = i;
						i = _tmp116_ + 1;
					}
					_tmp115_ = FALSE;
					_tmp117_ = i;
					if (!(_tmp117_ < 64)) {
						break;
					}
					_tmp118_ = i;
					_tmp119_ = start;
					if (_tmp118_ == _tmp119_) {
						continue;
					}
					_tmp120_ = i;
					_tmp121_ = self->board[_tmp120_];
					_tmp122_ = _chess_piece_ref0 (_tmp121_);
					p = _tmp122_;
					_tmp125_ = p;
					if (_tmp125_ == NULL) {
						_tmp124_ = TRUE;
					} else {
						ChessPiece* _tmp126_ = NULL;
						ChessPlayer* _tmp127_ = NULL;
						ChessPlayer* _tmp128_ = NULL;
						_tmp126_ = p;
						_tmp127_ = _tmp126_->player;
						_tmp128_ = player;
						_tmp124_ = _tmp127_ != _tmp128_;
					}
					if (_tmp124_) {
						_tmp123_ = TRUE;
					} else {
						ChessPiece* _tmp129_ = NULL;
						PieceType _tmp130_ = 0;
						ChessPiece* _tmp131_ = NULL;
						PieceType _tmp132_ = 0;
						_tmp129_ = p;
						_tmp130_ = _tmp129_->type;
						_tmp131_ = piece;
						_tmp132_ = _tmp131_->type;
						_tmp123_ = _tmp130_ != _tmp132_;
					}
					if (_tmp123_) {
						_chess_piece_unref0 (p);
						continue;
					}
					_tmp133_ = i;
					_tmp134_ = chess_state_get_rank (self, _tmp133_);
					r = _tmp134_;
					_tmp135_ = i;
					_tmp136_ = chess_state_get_file (self, _tmp135_);
					f = _tmp136_;
					_tmp137_ = player;
					_tmp138_ = r;
					_tmp139_ = f;
					_tmp140_ = r1;
					_tmp141_ = f1;
					_tmp142_ = chess_state_move_with_coords (self, _tmp137_, _tmp138_, _tmp139_, _tmp140_, _tmp141_, PIECE_TYPE_QUEEN, FALSE, TRUE);
					if (_tmp142_) {
						gint _tmp143_ = 0;
						gint _tmp144_ = 0;
						gint _tmp145_ = 0;
						gint _tmp146_ = 0;
						_tmp143_ = r;
						_tmp144_ = r0;
						if (_tmp143_ != _tmp144_) {
							ambiguous_rank = TRUE;
						}
						_tmp145_ = f;
						_tmp146_ = f0;
						if (_tmp145_ != _tmp146_) {
							ambiguous_file = TRUE;
						}
					}
					_chess_piece_unref0 (p);
				}
			}
		}
	}
	_tmp147_ = self->priv->piece_masks[COLOR_WHITE];
	old_white_mask = _tmp147_;
	_tmp148_ = self->priv->piece_masks[COLOR_BLACK];
	old_black_mask = _tmp148_;
	_tmp149_ = self->can_castle_kingside[COLOR_WHITE];
	old_white_can_castle_kingside = _tmp149_;
	_tmp150_ = self->can_castle_queenside[COLOR_WHITE];
	old_white_can_castle_queenside = _tmp150_;
	_tmp151_ = self->can_castle_kingside[COLOR_BLACK];
	old_black_can_castle_kingside = _tmp151_;
	_tmp152_ = self->can_castle_queenside[COLOR_BLACK];
	old_black_can_castle_queenside = _tmp152_;
	_tmp153_ = self->en_passant_index;
	old_en_passant_index = _tmp153_;
	_tmp154_ = self->halfmove_clock;
	old_halfmove_clock = _tmp154_;
	_tmp155_ = start;
	_chess_piece_unref0 (self->board[_tmp155_]);
	self->board[_tmp155_] = NULL;
	_tmp156_ = self->board[_tmp155_];
	_tmp157_ = start;
	_tmp158_ = BIT_BOARD_clear_location_masks[_tmp157_];
	self->priv->piece_masks[COLOR_WHITE] &= _tmp158_;
	_tmp159_ = self->priv->piece_masks[COLOR_WHITE];
	_tmp160_ = start;
	_tmp161_ = BIT_BOARD_clear_location_masks[_tmp160_];
	self->priv->piece_masks[COLOR_BLACK] &= _tmp161_;
	_tmp162_ = self->priv->piece_masks[COLOR_BLACK];
	_tmp163_ = victim;
	if (_tmp163_ != NULL) {
		gint _tmp164_ = 0;
		ChessPiece* _tmp165_ = NULL;
		gint _tmp166_ = 0;
		gint64 _tmp167_ = 0LL;
		gint64 _tmp168_ = 0LL;
		gint _tmp169_ = 0;
		gint64 _tmp170_ = 0LL;
		gint64 _tmp171_ = 0LL;
		_tmp164_ = victim_index;
		_chess_piece_unref0 (self->board[_tmp164_]);
		self->board[_tmp164_] = NULL;
		_tmp165_ = self->board[_tmp164_];
		_tmp166_ = victim_index;
		_tmp167_ = BIT_BOARD_clear_location_masks[_tmp166_];
		self->priv->piece_masks[COLOR_WHITE] &= _tmp167_;
		_tmp168_ = self->priv->piece_masks[COLOR_WHITE];
		_tmp169_ = victim_index;
		_tmp170_ = BIT_BOARD_clear_location_masks[_tmp169_];
		self->priv->piece_masks[COLOR_BLACK] &= _tmp170_;
		_tmp171_ = self->priv->piece_masks[COLOR_BLACK];
	}
	_tmp172_ = is_promotion;
	if (_tmp172_) {
		gint _tmp173_ = 0;
		ChessPlayer* _tmp174_ = NULL;
		PieceType _tmp175_ = 0;
		ChessPiece* _tmp176_ = NULL;
		ChessPiece* _tmp177_ = NULL;
		_tmp173_ = end;
		_tmp174_ = player;
		_tmp175_ = promotion_type;
		_tmp176_ = chess_piece_new (_tmp174_, _tmp175_);
		_chess_piece_unref0 (self->board[_tmp173_]);
		self->board[_tmp173_] = _tmp176_;
		_tmp177_ = self->board[_tmp173_];
	} else {
		gint _tmp178_ = 0;
		ChessPiece* _tmp179_ = NULL;
		ChessPiece* _tmp180_ = NULL;
		ChessPiece* _tmp181_ = NULL;
		_tmp178_ = end;
		_tmp179_ = piece;
		_tmp180_ = _chess_piece_ref0 (_tmp179_);
		_chess_piece_unref0 (self->board[_tmp178_]);
		self->board[_tmp178_] = _tmp180_;
		_tmp181_ = self->board[_tmp178_];
	}
	_tmp182_ = color;
	_tmp183_ = end_mask;
	self->priv->piece_masks[_tmp182_] |= _tmp183_;
	_tmp184_ = self->priv->piece_masks[_tmp182_];
	_tmp185_ = opponent_color;
	_tmp186_ = end;
	_tmp187_ = BIT_BOARD_clear_location_masks[_tmp186_];
	self->priv->piece_masks[_tmp185_] &= _tmp187_;
	_tmp188_ = self->priv->piece_masks[_tmp185_];
	_tmp189_ = rook_start;
	if (_tmp189_ >= 0) {
		ChessPiece* rook = NULL;
		gint _tmp190_ = 0;
		ChessPiece* _tmp191_ = NULL;
		ChessPiece* _tmp192_ = NULL;
		gint _tmp193_ = 0;
		ChessPiece* _tmp194_ = NULL;
		Color _tmp195_ = 0;
		gint _tmp196_ = 0;
		gint64 _tmp197_ = 0LL;
		gint64 _tmp198_ = 0LL;
		gint _tmp199_ = 0;
		ChessPiece* _tmp200_ = NULL;
		ChessPiece* _tmp201_ = NULL;
		ChessPiece* _tmp202_ = NULL;
		Color _tmp203_ = 0;
		gint _tmp204_ = 0;
		gint64 _tmp205_ = 0LL;
		gint64 _tmp206_ = 0LL;
		_tmp190_ = rook_start;
		_tmp191_ = self->board[_tmp190_];
		_tmp192_ = _chess_piece_ref0 (_tmp191_);
		rook = _tmp192_;
		_tmp193_ = rook_start;
		_chess_piece_unref0 (self->board[_tmp193_]);
		self->board[_tmp193_] = NULL;
		_tmp194_ = self->board[_tmp193_];
		_tmp195_ = color;
		_tmp196_ = rook_start;
		_tmp197_ = BIT_BOARD_clear_location_masks[_tmp196_];
		self->priv->piece_masks[_tmp195_] &= _tmp197_;
		_tmp198_ = self->priv->piece_masks[_tmp195_];
		_tmp199_ = rook_end;
		_tmp200_ = rook;
		_tmp201_ = _chess_piece_ref0 (_tmp200_);
		_chess_piece_unref0 (self->board[_tmp199_]);
		self->board[_tmp199_] = _tmp201_;
		_tmp202_ = self->board[_tmp199_];
		_tmp203_ = color;
		_tmp204_ = rook_end;
		_tmp205_ = BIT_BOARD_set_location_masks[_tmp204_];
		self->priv->piece_masks[_tmp203_] |= _tmp205_;
		_tmp206_ = self->priv->piece_masks[_tmp203_];
		_chess_piece_unref0 (rook);
	}
	_tmp207_ = piece;
	_tmp208_ = _tmp207_->type;
	if (_tmp208_ == PIECE_TYPE_KING) {
		Color _tmp209_ = 0;
		gboolean _tmp210_ = FALSE;
		Color _tmp211_ = 0;
		gboolean _tmp212_ = FALSE;
		_tmp209_ = color;
		self->can_castle_kingside[_tmp209_] = FALSE;
		_tmp210_ = self->can_castle_kingside[_tmp209_];
		_tmp211_ = color;
		self->can_castle_queenside[_tmp211_] = FALSE;
		_tmp212_ = self->can_castle_queenside[_tmp211_];
	} else {
		ChessPiece* _tmp213_ = NULL;
		PieceType _tmp214_ = 0;
		_tmp213_ = piece;
		_tmp214_ = _tmp213_->type;
		if (_tmp214_ == PIECE_TYPE_ROOK) {
			gint _tmp215_ = 0;
			Color _tmp216_ = 0;
			gint base_rank = 0;
			gint _tmp217_ = 0;
			gint _tmp218_ = 0;
			_tmp216_ = color;
			if (_tmp216_ == COLOR_WHITE) {
				_tmp215_ = 0;
			} else {
				_tmp215_ = 7;
			}
			base_rank = _tmp215_;
			_tmp217_ = r0;
			_tmp218_ = base_rank;
			if (_tmp217_ == _tmp218_) {
				gint _tmp219_ = 0;
				_tmp219_ = f0;
				if (_tmp219_ == 0) {
					Color _tmp220_ = 0;
					gboolean _tmp221_ = FALSE;
					_tmp220_ = color;
					self->can_castle_queenside[_tmp220_] = FALSE;
					_tmp221_ = self->can_castle_queenside[_tmp220_];
				} else {
					gint _tmp222_ = 0;
					_tmp222_ = f0;
					if (_tmp222_ == 7) {
						Color _tmp223_ = 0;
						gboolean _tmp224_ = FALSE;
						_tmp223_ = color;
						self->can_castle_kingside[_tmp223_] = FALSE;
						_tmp224_ = self->can_castle_kingside[_tmp223_];
					}
				}
			}
		} else {
			gboolean _tmp225_ = FALSE;
			ChessPiece* _tmp226_ = NULL;
			_tmp226_ = victim;
			if (_tmp226_ != NULL) {
				ChessPiece* _tmp227_ = NULL;
				PieceType _tmp228_ = 0;
				_tmp227_ = victim;
				_tmp228_ = _tmp227_->type;
				_tmp225_ = _tmp228_ == PIECE_TYPE_ROOK;
			} else {
				_tmp225_ = FALSE;
			}
			if (_tmp225_) {
				gint _tmp229_ = 0;
				Color _tmp230_ = 0;
				gint base_rank = 0;
				gint _tmp231_ = 0;
				gint _tmp232_ = 0;
				_tmp230_ = opponent_color;
				if (_tmp230_ == COLOR_WHITE) {
					_tmp229_ = 0;
				} else {
					_tmp229_ = 7;
				}
				base_rank = _tmp229_;
				_tmp231_ = r1;
				_tmp232_ = base_rank;
				if (_tmp231_ == _tmp232_) {
					gint _tmp233_ = 0;
					_tmp233_ = f1;
					if (_tmp233_ == 0) {
						Color _tmp234_ = 0;
						gboolean _tmp235_ = FALSE;
						_tmp234_ = opponent_color;
						self->can_castle_queenside[_tmp234_] = FALSE;
						_tmp235_ = self->can_castle_queenside[_tmp234_];
					} else {
						gint _tmp236_ = 0;
						_tmp236_ = f1;
						if (_tmp236_ == 7) {
							Color _tmp237_ = 0;
							gboolean _tmp238_ = FALSE;
							_tmp237_ = opponent_color;
							self->can_castle_kingside[_tmp237_] = FALSE;
							_tmp238_ = self->can_castle_kingside[_tmp237_];
						}
					}
				}
			}
		}
	}
	_tmp240_ = piece;
	_tmp241_ = _tmp240_->type;
	if (_tmp241_ == PIECE_TYPE_PAWN) {
		gint64 _tmp242_ = 0LL;
		_tmp242_ = over_mask;
		_tmp239_ = _tmp242_ != ((gint64) 0);
	} else {
		_tmp239_ = FALSE;
	}
	if (_tmp239_) {
		gint _tmp243_ = 0;
		gint _tmp244_ = 0;
		gint _tmp245_ = 0;
		gint _tmp246_ = 0;
		_tmp243_ = r0;
		_tmp244_ = r1;
		_tmp245_ = f0;
		_tmp246_ = chess_state_get_index (self, (_tmp243_ + _tmp244_) / 2, _tmp245_);
		self->en_passant_index = _tmp246_;
	} else {
		self->en_passant_index = -1;
	}
	_tmp248_ = piece;
	_tmp249_ = _tmp248_->type;
	if (_tmp249_ == PIECE_TYPE_PAWN) {
		_tmp247_ = TRUE;
	} else {
		ChessPiece* _tmp250_ = NULL;
		_tmp250_ = victim;
		_tmp247_ = _tmp250_ != NULL;
	}
	if (_tmp247_) {
		self->halfmove_clock = 0;
	} else {
		gint _tmp251_ = 0;
		_tmp251_ = self->halfmove_clock;
		self->halfmove_clock = _tmp251_ + 1;
	}
	_result_ = TRUE;
	_tmp253_ = test_check;
	if (_tmp253_) {
		ChessPlayer* _tmp254_ = NULL;
		gboolean _tmp255_ = FALSE;
		_tmp254_ = player;
		_tmp255_ = chess_state_is_in_check (self, _tmp254_);
		_tmp252_ = _tmp255_;
	} else {
		_tmp252_ = FALSE;
	}
	if (_tmp252_) {
		_result_ = FALSE;
	}
	_tmp257_ = apply;
	if (!_tmp257_) {
		_tmp256_ = TRUE;
	} else {
		gboolean _tmp258_ = FALSE;
		_tmp258_ = _result_;
		_tmp256_ = !_tmp258_;
	}
	if (_tmp256_) {
		gint _tmp259_ = 0;
		ChessPiece* _tmp260_ = NULL;
		ChessPiece* _tmp261_ = NULL;
		ChessPiece* _tmp262_ = NULL;
		gint _tmp263_ = 0;
		ChessPiece* _tmp264_ = NULL;
		ChessPiece* _tmp265_ = NULL;
		gint _tmp270_ = 0;
		gint64 _tmp280_ = 0LL;
		gint64 _tmp281_ = 0LL;
		gint64 _tmp282_ = 0LL;
		gint64 _tmp283_ = 0LL;
		gboolean _tmp284_ = FALSE;
		gboolean _tmp285_ = FALSE;
		gboolean _tmp286_ = FALSE;
		gboolean _tmp287_ = FALSE;
		gboolean _tmp288_ = FALSE;
		gboolean _tmp289_ = FALSE;
		gboolean _tmp290_ = FALSE;
		gboolean _tmp291_ = FALSE;
		gint _tmp292_ = 0;
		gint _tmp293_ = 0;
		_tmp259_ = start;
		_tmp260_ = piece;
		_tmp261_ = _chess_piece_ref0 (_tmp260_);
		_chess_piece_unref0 (self->board[_tmp259_]);
		self->board[_tmp259_] = _tmp261_;
		_tmp262_ = self->board[_tmp259_];
		_tmp263_ = end;
		_chess_piece_unref0 (self->board[_tmp263_]);
		self->board[_tmp263_] = NULL;
		_tmp264_ = self->board[_tmp263_];
		_tmp265_ = victim;
		if (_tmp265_ != NULL) {
			gint _tmp266_ = 0;
			ChessPiece* _tmp267_ = NULL;
			ChessPiece* _tmp268_ = NULL;
			ChessPiece* _tmp269_ = NULL;
			_tmp266_ = victim_index;
			_tmp267_ = victim;
			_tmp268_ = _chess_piece_ref0 (_tmp267_);
			_chess_piece_unref0 (self->board[_tmp266_]);
			self->board[_tmp266_] = _tmp268_;
			_tmp269_ = self->board[_tmp266_];
		}
		_tmp270_ = rook_start;
		if (_tmp270_ >= 0) {
			ChessPiece* rook = NULL;
			gint _tmp271_ = 0;
			ChessPiece* _tmp272_ = NULL;
			ChessPiece* _tmp273_ = NULL;
			gint _tmp274_ = 0;
			ChessPiece* _tmp275_ = NULL;
			ChessPiece* _tmp276_ = NULL;
			ChessPiece* _tmp277_ = NULL;
			gint _tmp278_ = 0;
			ChessPiece* _tmp279_ = NULL;
			_tmp271_ = rook_end;
			_tmp272_ = self->board[_tmp271_];
			_tmp273_ = _chess_piece_ref0 (_tmp272_);
			rook = _tmp273_;
			_tmp274_ = rook_start;
			_tmp275_ = rook;
			_tmp276_ = _chess_piece_ref0 (_tmp275_);
			_chess_piece_unref0 (self->board[_tmp274_]);
			self->board[_tmp274_] = _tmp276_;
			_tmp277_ = self->board[_tmp274_];
			_tmp278_ = rook_end;
			_chess_piece_unref0 (self->board[_tmp278_]);
			self->board[_tmp278_] = NULL;
			_tmp279_ = self->board[_tmp278_];
			_chess_piece_unref0 (rook);
		}
		_tmp280_ = old_white_mask;
		self->priv->piece_masks[COLOR_WHITE] = _tmp280_;
		_tmp281_ = self->priv->piece_masks[COLOR_WHITE];
		_tmp282_ = old_black_mask;
		self->priv->piece_masks[COLOR_BLACK] = _tmp282_;
		_tmp283_ = self->priv->piece_masks[COLOR_BLACK];
		_tmp284_ = old_white_can_castle_kingside;
		self->can_castle_kingside[COLOR_WHITE] = _tmp284_;
		_tmp285_ = self->can_castle_kingside[COLOR_WHITE];
		_tmp286_ = old_white_can_castle_queenside;
		self->can_castle_queenside[COLOR_WHITE] = _tmp286_;
		_tmp287_ = self->can_castle_queenside[COLOR_WHITE];
		_tmp288_ = old_black_can_castle_kingside;
		self->can_castle_kingside[COLOR_BLACK] = _tmp288_;
		_tmp289_ = self->can_castle_kingside[COLOR_BLACK];
		_tmp290_ = old_black_can_castle_queenside;
		self->can_castle_queenside[COLOR_BLACK] = _tmp290_;
		_tmp291_ = self->can_castle_queenside[COLOR_BLACK];
		_tmp292_ = old_en_passant_index;
		self->en_passant_index = _tmp292_;
		_tmp293_ = old_halfmove_clock;
		self->halfmove_clock = _tmp293_;
		result = _result_;
		_chess_piece_unref0 (victim);
		_chess_piece_unref0 (piece);
		return result;
	}
	_tmp295_ = color;
	if (_tmp295_ == COLOR_WHITE) {
		ChessPlayer* _tmp296_ = NULL;
		_tmp296_ = self->players[COLOR_BLACK];
		_tmp294_ = _tmp296_;
	} else {
		ChessPlayer* _tmp297_ = NULL;
		_tmp297_ = self->players[COLOR_WHITE];
		_tmp294_ = _tmp297_;
	}
	_tmp298_ = _g_object_ref0 (_tmp294_);
	_g_object_unref0 (self->current_player);
	self->current_player = _tmp298_;
	_tmp299_ = self->current_player;
	_tmp300_ = chess_state_get_check_state (self, _tmp299_);
	self->check_state = _tmp300_;
	_tmp301_ = chess_move_new ();
	_chess_move_unref0 (self->last_move);
	self->last_move = _tmp301_;
	_tmp302_ = self->last_move;
	_tmp303_ = self->number;
	_tmp302_->number = _tmp303_;
	_tmp304_ = self->last_move;
	_tmp305_ = piece;
	_tmp306_ = _chess_piece_ref0 (_tmp305_);
	_chess_piece_unref0 (_tmp304_->piece);
	_tmp304_->piece = _tmp306_;
	_tmp307_ = is_promotion;
	if (_tmp307_) {
		ChessMove* _tmp308_ = NULL;
		gint _tmp309_ = 0;
		ChessPiece* _tmp310_ = NULL;
		ChessPiece* _tmp311_ = NULL;
		_tmp308_ = self->last_move;
		_tmp309_ = end;
		_tmp310_ = self->board[_tmp309_];
		_tmp311_ = _chess_piece_ref0 (_tmp310_);
		_chess_piece_unref0 (_tmp308_->promotion_piece);
		_tmp308_->promotion_piece = _tmp311_;
	}
	_tmp312_ = self->last_move;
	_tmp313_ = victim;
	_tmp314_ = _chess_piece_ref0 (_tmp313_);
	_chess_piece_unref0 (_tmp312_->victim);
	_tmp312_->victim = _tmp314_;
	_tmp315_ = rook_end;
	if (_tmp315_ >= 0) {
		ChessMove* _tmp316_ = NULL;
		gint _tmp317_ = 0;
		ChessPiece* _tmp318_ = NULL;
		ChessPiece* _tmp319_ = NULL;
		_tmp316_ = self->last_move;
		_tmp317_ = rook_end;
		_tmp318_ = self->board[_tmp317_];
		_tmp319_ = _chess_piece_ref0 (_tmp318_);
		_chess_piece_unref0 (_tmp316_->moved_rook);
		_tmp316_->moved_rook = _tmp319_;
	}
	_tmp320_ = self->last_move;
	_tmp321_ = r0;
	_tmp320_->r0 = _tmp321_;
	_tmp322_ = self->last_move;
	_tmp323_ = f0;
	_tmp322_->f0 = _tmp323_;
	_tmp324_ = self->last_move;
	_tmp325_ = r1;
	_tmp324_->r1 = _tmp325_;
	_tmp326_ = self->last_move;
	_tmp327_ = f1;
	_tmp326_->f1 = _tmp327_;
	_tmp328_ = self->last_move;
	_tmp329_ = ambiguous_rank;
	_tmp328_->ambiguous_rank = _tmp329_;
	_tmp330_ = self->last_move;
	_tmp331_ = ambiguous_file;
	_tmp330_->ambiguous_file = _tmp331_;
	_tmp332_ = self->last_move;
	_tmp333_ = self->check_state;
	_tmp332_->check_state = _tmp333_;
	result = TRUE;
	_chess_piece_unref0 (victim);
	_chess_piece_unref0 (piece);
	return result;
}


ChessResult chess_state_get_result (ChessState* self, ChessRule* rule) {
	ChessRule _vala_rule = 0;
	ChessResult result = 0;
	CheckState _tmp0_ = 0;
	ChessPlayer* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp5_ = FALSE;
	gboolean _tmp6_ = FALSE;
	ChessMove* _tmp7_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	_vala_rule = CHESS_RULE_CHECKMATE;
	_tmp0_ = self->check_state;
	if (_tmp0_ == CHECK_STATE_CHECKMATE) {
		ChessPlayer* _tmp1_ = NULL;
		Color _tmp2_ = 0;
		_tmp1_ = self->current_player;
		_tmp2_ = _tmp1_->color;
		if (_tmp2_ == COLOR_WHITE) {
			_vala_rule = CHESS_RULE_CHECKMATE;
			result = CHESS_RESULT_BLACK_WON;
			if (rule) {
				*rule = _vala_rule;
			}
			return result;
		} else {
			_vala_rule = CHESS_RULE_CHECKMATE;
			result = CHESS_RESULT_WHITE_WON;
			if (rule) {
				*rule = _vala_rule;
			}
			return result;
		}
	}
	_tmp3_ = self->current_player;
	_tmp4_ = chess_state_can_move (self, _tmp3_);
	if (!_tmp4_) {
		_vala_rule = CHESS_RULE_STALEMATE;
		result = CHESS_RESULT_DRAW;
		if (rule) {
			*rule = _vala_rule;
		}
		return result;
	}
	_tmp7_ = self->last_move;
	if (_tmp7_ != NULL) {
		ChessMove* _tmp8_ = NULL;
		ChessPiece* _tmp9_ = NULL;
		_tmp8_ = self->last_move;
		_tmp9_ = _tmp8_->victim;
		_tmp6_ = _tmp9_ != NULL;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		gboolean _tmp10_ = FALSE;
		_tmp10_ = chess_state_have_sufficient_material (self);
		_tmp5_ = !_tmp10_;
	} else {
		_tmp5_ = FALSE;
	}
	if (_tmp5_) {
		_vala_rule = CHESS_RULE_INSUFFICIENT_MATERIAL;
		result = CHESS_RESULT_DRAW;
		if (rule) {
			*rule = _vala_rule;
		}
		return result;
	}
	result = CHESS_RESULT_IN_PROGRESS;
	if (rule) {
		*rule = _vala_rule;
	}
	return result;
}


static CheckState chess_state_get_check_state (ChessState* self, ChessPlayer* player) {
	CheckState result = 0;
	ChessPlayer* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (player != NULL, 0);
	_tmp0_ = player;
	_tmp1_ = chess_state_is_in_check (self, _tmp0_);
	if (_tmp1_) {
		ChessPlayer* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		_tmp2_ = player;
		_tmp3_ = chess_state_is_in_checkmate (self, _tmp2_);
		if (_tmp3_) {
			result = CHECK_STATE_CHECKMATE;
			return result;
		} else {
			result = CHECK_STATE_CHECK;
			return result;
		}
	}
	result = CHECK_STATE_NONE;
	return result;
}


gboolean chess_state_is_in_check (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	ChessPlayer* opponent = NULL;
	ChessPlayer* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp1_ = player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessPlayer* _tmp3_ = NULL;
		_tmp3_ = self->players[COLOR_BLACK];
		_tmp0_ = _tmp3_;
	} else {
		ChessPlayer* _tmp4_ = NULL;
		_tmp4_ = self->players[COLOR_WHITE];
		_tmp0_ = _tmp4_;
	}
	_tmp5_ = _g_object_ref0 (_tmp0_);
	opponent = _tmp5_;
	{
		gint king_index = 0;
		king_index = 0;
		{
			gboolean _tmp6_ = FALSE;
			_tmp6_ = TRUE;
			while (TRUE) {
				gint _tmp8_ = 0;
				ChessPiece* p = NULL;
				gint _tmp9_ = 0;
				ChessPiece* _tmp10_ = NULL;
				ChessPiece* _tmp11_ = NULL;
				gboolean _tmp12_ = FALSE;
				gboolean _tmp13_ = FALSE;
				ChessPiece* _tmp14_ = NULL;
				if (!_tmp6_) {
					gint _tmp7_ = 0;
					_tmp7_ = king_index;
					king_index = _tmp7_ + 1;
				}
				_tmp6_ = FALSE;
				_tmp8_ = king_index;
				if (!(_tmp8_ < 64)) {
					break;
				}
				_tmp9_ = king_index;
				_tmp10_ = self->board[_tmp9_];
				_tmp11_ = _chess_piece_ref0 (_tmp10_);
				p = _tmp11_;
				_tmp14_ = p;
				if (_tmp14_ != NULL) {
					ChessPiece* _tmp15_ = NULL;
					ChessPlayer* _tmp16_ = NULL;
					ChessPlayer* _tmp17_ = NULL;
					_tmp15_ = p;
					_tmp16_ = _tmp15_->player;
					_tmp17_ = player;
					_tmp13_ = _tmp16_ == _tmp17_;
				} else {
					_tmp13_ = FALSE;
				}
				if (_tmp13_) {
					ChessPiece* _tmp18_ = NULL;
					PieceType _tmp19_ = 0;
					_tmp18_ = p;
					_tmp19_ = _tmp18_->type;
					_tmp12_ = _tmp19_ == PIECE_TYPE_KING;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					{
						gint start = 0;
						start = 0;
						{
							gboolean _tmp20_ = FALSE;
							_tmp20_ = TRUE;
							while (TRUE) {
								gint _tmp22_ = 0;
								ChessPlayer* _tmp23_ = NULL;
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								gint _tmp26_ = 0;
								gint _tmp27_ = 0;
								gint _tmp28_ = 0;
								gint _tmp29_ = 0;
								gint _tmp30_ = 0;
								gint _tmp31_ = 0;
								gboolean _tmp32_ = FALSE;
								if (!_tmp20_) {
									gint _tmp21_ = 0;
									_tmp21_ = start;
									start = _tmp21_ + 1;
								}
								_tmp20_ = FALSE;
								_tmp22_ = start;
								if (!(_tmp22_ < 64)) {
									break;
								}
								_tmp23_ = opponent;
								_tmp24_ = start;
								_tmp25_ = chess_state_get_rank (self, _tmp24_);
								_tmp26_ = start;
								_tmp27_ = chess_state_get_file (self, _tmp26_);
								_tmp28_ = king_index;
								_tmp29_ = chess_state_get_rank (self, _tmp28_);
								_tmp30_ = king_index;
								_tmp31_ = chess_state_get_file (self, _tmp30_);
								_tmp32_ = chess_state_move_with_coords (self, _tmp23_, _tmp25_, _tmp27_, _tmp29_, _tmp31_, PIECE_TYPE_QUEEN, FALSE, FALSE);
								if (_tmp32_) {
									result = TRUE;
									_chess_piece_unref0 (p);
									_g_object_unref0 (opponent);
									return result;
								}
							}
						}
					}
				}
				_chess_piece_unref0 (p);
			}
		}
	}
	result = FALSE;
	_g_object_unref0 (opponent);
	return result;
}


static gboolean chess_state_is_in_checkmate (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	{
		gint piece_index = 0;
		piece_index = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				ChessPiece* p = NULL;
				gint _tmp3_ = 0;
				ChessPiece* _tmp4_ = NULL;
				ChessPiece* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				ChessPiece* _tmp7_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = piece_index;
					piece_index = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = piece_index;
				if (!(_tmp2_ < 64)) {
					break;
				}
				_tmp3_ = piece_index;
				_tmp4_ = self->board[_tmp3_];
				_tmp5_ = _chess_piece_ref0 (_tmp4_);
				p = _tmp5_;
				_tmp7_ = p;
				if (_tmp7_ != NULL) {
					ChessPiece* _tmp8_ = NULL;
					ChessPlayer* _tmp9_ = NULL;
					ChessPlayer* _tmp10_ = NULL;
					_tmp8_ = p;
					_tmp9_ = _tmp8_->player;
					_tmp10_ = player;
					_tmp6_ = _tmp9_ == _tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					{
						gint end = 0;
						end = 0;
						{
							gboolean _tmp11_ = FALSE;
							_tmp11_ = TRUE;
							while (TRUE) {
								gint _tmp13_ = 0;
								ChessPlayer* _tmp14_ = NULL;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gboolean _tmp23_ = FALSE;
								if (!_tmp11_) {
									gint _tmp12_ = 0;
									_tmp12_ = end;
									end = _tmp12_ + 1;
								}
								_tmp11_ = FALSE;
								_tmp13_ = end;
								if (!(_tmp13_ < 64)) {
									break;
								}
								_tmp14_ = player;
								_tmp15_ = piece_index;
								_tmp16_ = chess_state_get_rank (self, _tmp15_);
								_tmp17_ = piece_index;
								_tmp18_ = chess_state_get_file (self, _tmp17_);
								_tmp19_ = end;
								_tmp20_ = chess_state_get_rank (self, _tmp19_);
								_tmp21_ = end;
								_tmp22_ = chess_state_get_file (self, _tmp21_);
								_tmp23_ = chess_state_move_with_coords (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, PIECE_TYPE_QUEEN, FALSE, TRUE);
								if (_tmp23_) {
									result = FALSE;
									_chess_piece_unref0 (p);
									return result;
								}
							}
						}
					}
				}
				_chess_piece_unref0 (p);
			}
		}
	}
	result = TRUE;
	return result;
}


static gboolean chess_state_can_move (ChessState* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean have_pieces = FALSE;
	gboolean _tmp24_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	have_pieces = FALSE;
	{
		gint start = 0;
		start = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				ChessPiece* p = NULL;
				gint _tmp3_ = 0;
				ChessPiece* _tmp4_ = NULL;
				ChessPiece* _tmp5_ = NULL;
				gboolean _tmp6_ = FALSE;
				ChessPiece* _tmp7_ = NULL;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = start;
					start = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = start;
				if (!(_tmp2_ < 64)) {
					break;
				}
				_tmp3_ = start;
				_tmp4_ = self->board[_tmp3_];
				_tmp5_ = _chess_piece_ref0 (_tmp4_);
				p = _tmp5_;
				_tmp7_ = p;
				if (_tmp7_ != NULL) {
					ChessPiece* _tmp8_ = NULL;
					ChessPlayer* _tmp9_ = NULL;
					ChessPlayer* _tmp10_ = NULL;
					_tmp8_ = p;
					_tmp9_ = _tmp8_->player;
					_tmp10_ = player;
					_tmp6_ = _tmp9_ == _tmp10_;
				} else {
					_tmp6_ = FALSE;
				}
				if (_tmp6_) {
					have_pieces = TRUE;
					{
						gint end = 0;
						end = 0;
						{
							gboolean _tmp11_ = FALSE;
							_tmp11_ = TRUE;
							while (TRUE) {
								gint _tmp13_ = 0;
								ChessPlayer* _tmp14_ = NULL;
								gint _tmp15_ = 0;
								gint _tmp16_ = 0;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gint _tmp19_ = 0;
								gint _tmp20_ = 0;
								gint _tmp21_ = 0;
								gint _tmp22_ = 0;
								gboolean _tmp23_ = FALSE;
								if (!_tmp11_) {
									gint _tmp12_ = 0;
									_tmp12_ = end;
									end = _tmp12_ + 1;
								}
								_tmp11_ = FALSE;
								_tmp13_ = end;
								if (!(_tmp13_ < 64)) {
									break;
								}
								_tmp14_ = player;
								_tmp15_ = start;
								_tmp16_ = chess_state_get_rank (self, _tmp15_);
								_tmp17_ = start;
								_tmp18_ = chess_state_get_file (self, _tmp17_);
								_tmp19_ = end;
								_tmp20_ = chess_state_get_rank (self, _tmp19_);
								_tmp21_ = end;
								_tmp22_ = chess_state_get_file (self, _tmp21_);
								_tmp23_ = chess_state_move_with_coords (self, _tmp14_, _tmp16_, _tmp18_, _tmp20_, _tmp22_, PIECE_TYPE_QUEEN, FALSE, TRUE);
								if (_tmp23_) {
									result = TRUE;
									_chess_piece_unref0 (p);
									return result;
								}
							}
						}
					}
				}
				_chess_piece_unref0 (p);
			}
		}
	}
	_tmp24_ = have_pieces;
	if (_tmp24_) {
		result = FALSE;
		return result;
	} else {
		result = TRUE;
		return result;
	}
}


gboolean chess_state_have_sufficient_material (ChessState* self) {
	gboolean result = FALSE;
	gint white_knight_count = 0;
	gint white_bishop_count = 0;
	gboolean white_bishop_on_white_square = FALSE;
	gboolean white_bishop_on_black_square = FALSE;
	gint black_knight_count = 0;
	gint black_bishop_count = 0;
	gboolean black_bishop_on_white_square = FALSE;
	gboolean black_bishop_on_black_square = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	white_knight_count = 0;
	white_bishop_count = 0;
	white_bishop_on_white_square = FALSE;
	white_bishop_on_black_square = FALSE;
	black_knight_count = 0;
	black_bishop_count = 0;
	black_bishop_on_white_square = FALSE;
	black_bishop_on_black_square = FALSE;
	{
		gint i = 0;
		i = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				ChessPiece* p = NULL;
				gint _tmp3_ = 0;
				ChessPiece* _tmp4_ = NULL;
				ChessPiece* _tmp5_ = NULL;
				ChessPiece* _tmp6_ = NULL;
				gboolean _tmp7_ = FALSE;
				gboolean _tmp8_ = FALSE;
				ChessPiece* _tmp9_ = NULL;
				PieceType _tmp10_ = 0;
				ChessPiece* _tmp15_ = NULL;
				PieceType _tmp16_ = 0;
				ChessPiece* _tmp22_ = NULL;
				PieceType _tmp23_ = 0;
				gboolean _tmp33_ = FALSE;
				gint _tmp34_ = 0;
				gboolean _tmp36_ = FALSE;
				gint _tmp37_ = 0;
				gboolean _tmp39_ = FALSE;
				gint _tmp40_ = 0;
				gboolean _tmp42_ = FALSE;
				gboolean _tmp43_ = FALSE;
				gboolean _tmp45_ = FALSE;
				gboolean _tmp46_ = FALSE;
				gboolean _tmp48_ = FALSE;
				gboolean _tmp49_ = FALSE;
				gint _tmp50_ = 0;
				gboolean _tmp53_ = FALSE;
				gboolean _tmp54_ = FALSE;
				gint _tmp55_ = 0;
				gboolean _tmp58_ = FALSE;
				gint _tmp59_ = 0;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = i;
					i = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = i;
				if (!(_tmp2_ < 64)) {
					break;
				}
				_tmp3_ = i;
				_tmp4_ = self->board[_tmp3_];
				_tmp5_ = _chess_piece_ref0 (_tmp4_);
				p = _tmp5_;
				_tmp6_ = p;
				if (_tmp6_ == NULL) {
					_chess_piece_unref0 (p);
					continue;
				}
				_tmp9_ = p;
				_tmp10_ = _tmp9_->type;
				if (_tmp10_ == PIECE_TYPE_PAWN) {
					_tmp8_ = TRUE;
				} else {
					ChessPiece* _tmp11_ = NULL;
					PieceType _tmp12_ = 0;
					_tmp11_ = p;
					_tmp12_ = _tmp11_->type;
					_tmp8_ = _tmp12_ == PIECE_TYPE_ROOK;
				}
				if (_tmp8_) {
					_tmp7_ = TRUE;
				} else {
					ChessPiece* _tmp13_ = NULL;
					PieceType _tmp14_ = 0;
					_tmp13_ = p;
					_tmp14_ = _tmp13_->type;
					_tmp7_ = _tmp14_ == PIECE_TYPE_QUEEN;
				}
				if (_tmp7_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp15_ = p;
				_tmp16_ = _tmp15_->type;
				if (_tmp16_ == PIECE_TYPE_KNIGHT) {
					ChessPiece* _tmp17_ = NULL;
					Color _tmp18_ = 0;
					Color _tmp19_ = 0;
					_tmp17_ = p;
					_tmp18_ = chess_piece_get_color (_tmp17_);
					_tmp19_ = _tmp18_;
					if (_tmp19_ == COLOR_WHITE) {
						gint _tmp20_ = 0;
						_tmp20_ = white_knight_count;
						white_knight_count = _tmp20_ + 1;
					} else {
						gint _tmp21_ = 0;
						_tmp21_ = black_knight_count;
						black_knight_count = _tmp21_ + 1;
					}
				}
				_tmp22_ = p;
				_tmp23_ = _tmp22_->type;
				if (_tmp23_ == PIECE_TYPE_BISHOP) {
					Color color = 0;
					gint _tmp24_ = 0;
					gint _tmp25_ = 0;
					ChessPiece* _tmp26_ = NULL;
					Color _tmp27_ = 0;
					Color _tmp28_ = 0;
					color = COLOR_BLACK;
					_tmp24_ = i;
					_tmp25_ = i;
					if (((_tmp24_ + (_tmp25_ / 8)) % 2) != 0) {
						color = COLOR_WHITE;
					}
					_tmp26_ = p;
					_tmp27_ = chess_piece_get_color (_tmp26_);
					_tmp28_ = _tmp27_;
					if (_tmp28_ == COLOR_WHITE) {
						Color _tmp29_ = 0;
						gint _tmp30_ = 0;
						_tmp29_ = color;
						if (_tmp29_ == COLOR_WHITE) {
							white_bishop_on_white_square = TRUE;
						} else {
							white_bishop_on_black_square = TRUE;
						}
						_tmp30_ = white_bishop_count;
						white_bishop_count = _tmp30_ + 1;
					} else {
						Color _tmp31_ = 0;
						gint _tmp32_ = 0;
						_tmp31_ = color;
						if (_tmp31_ == COLOR_WHITE) {
							black_bishop_on_white_square = TRUE;
						} else {
							black_bishop_on_black_square = TRUE;
						}
						_tmp32_ = black_bishop_count;
						black_bishop_count = _tmp32_ + 1;
					}
				}
				_tmp34_ = white_knight_count;
				if (_tmp34_ > 1) {
					_tmp33_ = TRUE;
				} else {
					gint _tmp35_ = 0;
					_tmp35_ = black_knight_count;
					_tmp33_ = _tmp35_ > 1;
				}
				if (_tmp33_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp37_ = white_bishop_count;
				if (_tmp37_ > 0) {
					gint _tmp38_ = 0;
					_tmp38_ = white_knight_count;
					_tmp36_ = _tmp38_ > 0;
				} else {
					_tmp36_ = FALSE;
				}
				if (_tmp36_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp40_ = black_bishop_count;
				if (_tmp40_ > 0) {
					gint _tmp41_ = 0;
					_tmp41_ = black_knight_count;
					_tmp39_ = _tmp41_ > 0;
				} else {
					_tmp39_ = FALSE;
				}
				if (_tmp39_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp43_ = white_bishop_on_white_square;
				if (_tmp43_) {
					gboolean _tmp44_ = FALSE;
					_tmp44_ = white_bishop_on_black_square;
					_tmp42_ = _tmp44_;
				} else {
					_tmp42_ = FALSE;
				}
				if (_tmp42_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp46_ = black_bishop_on_white_square;
				if (_tmp46_) {
					gboolean _tmp47_ = FALSE;
					_tmp47_ = black_bishop_on_black_square;
					_tmp45_ = _tmp47_;
				} else {
					_tmp45_ = FALSE;
				}
				if (_tmp45_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp50_ = white_bishop_count;
				if (_tmp50_ > 0) {
					_tmp49_ = TRUE;
				} else {
					gint _tmp51_ = 0;
					_tmp51_ = white_knight_count;
					_tmp49_ = _tmp51_ > 0;
				}
				if (_tmp49_) {
					gint _tmp52_ = 0;
					_tmp52_ = black_knight_count;
					_tmp48_ = _tmp52_ > 0;
				} else {
					_tmp48_ = FALSE;
				}
				if (_tmp48_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp55_ = black_bishop_count;
				if (_tmp55_ > 0) {
					_tmp54_ = TRUE;
				} else {
					gint _tmp56_ = 0;
					_tmp56_ = black_knight_count;
					_tmp54_ = _tmp56_ > 0;
				}
				if (_tmp54_) {
					gint _tmp57_ = 0;
					_tmp57_ = white_knight_count;
					_tmp53_ = _tmp57_ > 0;
				} else {
					_tmp53_ = FALSE;
				}
				if (_tmp53_) {
					result = TRUE;
					_chess_piece_unref0 (p);
					return result;
				}
				_tmp59_ = white_bishop_count;
				if (_tmp59_ > 0) {
					gint _tmp60_ = 0;
					_tmp60_ = black_bishop_count;
					_tmp58_ = _tmp60_ > 0;
				} else {
					_tmp58_ = FALSE;
				}
				if (_tmp58_) {
					gboolean _tmp61_ = FALSE;
					gboolean _tmp62_ = FALSE;
					_tmp62_ = white_bishop_on_white_square;
					if (_tmp62_) {
						gboolean _tmp63_ = FALSE;
						_tmp63_ = black_bishop_on_black_square;
						_tmp61_ = _tmp63_;
					} else {
						_tmp61_ = FALSE;
					}
					if (_tmp61_) {
						result = TRUE;
						_chess_piece_unref0 (p);
						return result;
					} else {
						gboolean _tmp64_ = FALSE;
						gboolean _tmp65_ = FALSE;
						_tmp65_ = white_bishop_on_black_square;
						if (_tmp65_) {
							gboolean _tmp66_ = FALSE;
							_tmp66_ = black_bishop_on_white_square;
							_tmp64_ = _tmp66_;
						} else {
							_tmp64_ = FALSE;
						}
						if (_tmp64_) {
							result = TRUE;
							_chess_piece_unref0 (p);
							return result;
						}
					}
				}
				_chess_piece_unref0 (p);
			}
		}
	}
	result = FALSE;
	return result;
}


static gboolean chess_state_decode_piece_type (ChessState* self, gunichar c, PieceType* type) {
	PieceType _vala_type = 0;
	gboolean result = FALSE;
	gunichar _tmp0_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	_vala_type = PIECE_TYPE_PAWN;
	_tmp0_ = c;
	switch (_tmp0_) {
		case 'P':
		{
			_vala_type = PIECE_TYPE_PAWN;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'R':
		{
			_vala_type = PIECE_TYPE_ROOK;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'N':
		{
			_vala_type = PIECE_TYPE_KNIGHT;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'B':
		{
			_vala_type = PIECE_TYPE_BISHOP;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'Q':
		{
			_vala_type = PIECE_TYPE_QUEEN;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		case 'K':
		{
			_vala_type = PIECE_TYPE_KING;
			result = TRUE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
		default:
		{
			result = FALSE;
			if (type) {
				*type = _vala_type;
			}
			return result;
		}
	}
	if (type) {
		*type = _vala_type;
	}
}


static gboolean chess_state_decode_move (ChessState* self, ChessPlayer* player, const gchar* move, gint* r0, gint* f0, gint* r1, gint* f1, PieceType* promotion_type) {
	gint _vala_r0 = 0;
	gint _vala_f0 = 0;
	gint _vala_r1 = 0;
	gint _vala_f1 = 0;
	PieceType _vala_promotion_type = 0;
	gboolean result = FALSE;
	gint i = 0;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp150_ = NULL;
	gint _tmp151_ = 0;
	gchar _tmp152_ = '\0';
	const gchar* _tmp158_ = NULL;
	gint _tmp159_ = 0;
	gchar _tmp160_ = '\0';
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	i = 0;
	_vala_promotion_type = PIECE_TYPE_QUEEN;
	_tmp0_ = move;
	_tmp1_ = g_str_has_prefix (_tmp0_, "O-O-O");
	if (_tmp1_) {
		ChessPlayer* _tmp2_ = NULL;
		Color _tmp3_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp2_ = player;
		_tmp3_ = _tmp2_->color;
		if (_tmp3_ == COLOR_WHITE) {
			gint _tmp4_ = 0;
			_vala_r1 = 0;
			_tmp4_ = _vala_r1;
			_vala_r0 = _tmp4_;
		} else {
			gint _tmp5_ = 0;
			_vala_r1 = 7;
			_tmp5_ = _vala_r1;
			_vala_r0 = _tmp5_;
		}
		_vala_f0 = 4;
		_vala_f1 = 2;
		_tmp6_ = i;
		_tmp7_ = strlen ("O-O-O");
		_tmp8_ = _tmp7_;
		i = _tmp6_ + ((gint) _tmp8_);
	} else {
		const gchar* _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		_tmp9_ = move;
		_tmp10_ = g_str_has_prefix (_tmp9_, "O-O");
		if (_tmp10_) {
			ChessPlayer* _tmp11_ = NULL;
			Color _tmp12_ = 0;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			gint _tmp17_ = 0;
			_tmp11_ = player;
			_tmp12_ = _tmp11_->color;
			if (_tmp12_ == COLOR_WHITE) {
				gint _tmp13_ = 0;
				_vala_r1 = 0;
				_tmp13_ = _vala_r1;
				_vala_r0 = _tmp13_;
			} else {
				gint _tmp14_ = 0;
				_vala_r1 = 7;
				_tmp14_ = _vala_r1;
				_vala_r0 = _tmp14_;
			}
			_vala_f0 = 4;
			_vala_f1 = 6;
			_tmp15_ = i;
			_tmp16_ = strlen ("O-O");
			_tmp17_ = _tmp16_;
			i = _tmp15_ + ((gint) _tmp17_);
		} else {
			PieceType type = 0;
			const gchar* _tmp18_ = NULL;
			gint _tmp19_ = 0;
			gchar _tmp20_ = '\0';
			PieceType _tmp21_ = 0;
			gboolean _tmp22_ = FALSE;
			gint _tmp24_ = 0;
			gint _tmp25_ = 0;
			gint _tmp26_ = 0;
			gboolean _tmp27_ = FALSE;
			const gchar* _tmp28_ = NULL;
			gint _tmp29_ = 0;
			gchar _tmp30_ = '\0';
			gboolean _tmp38_ = FALSE;
			const gchar* _tmp39_ = NULL;
			gint _tmp40_ = 0;
			gchar _tmp41_ = '\0';
			gboolean _tmp49_ = FALSE;
			const gchar* _tmp50_ = NULL;
			gint _tmp51_ = 0;
			gchar _tmp52_ = '\0';
			gboolean _tmp57_ = FALSE;
			const gchar* _tmp58_ = NULL;
			gint _tmp59_ = 0;
			gchar _tmp60_ = '\0';
			gboolean _tmp69_ = FALSE;
			const gchar* _tmp70_ = NULL;
			gint _tmp71_ = 0;
			gchar _tmp72_ = '\0';
			const gchar* _tmp81_ = NULL;
			gint _tmp82_ = 0;
			gchar _tmp83_ = '\0';
			gboolean _tmp101_ = FALSE;
			gint _tmp102_ = 0;
			gboolean _tmp105_ = FALSE;
			gint _tmp106_ = 0;
			type = PIECE_TYPE_PAWN;
			_tmp18_ = move;
			_tmp19_ = i;
			_tmp20_ = string_get (_tmp18_, (glong) _tmp19_);
			_tmp22_ = chess_state_decode_piece_type (self, (gunichar) _tmp20_, &_tmp21_);
			type = _tmp21_;
			if (_tmp22_) {
				gint _tmp23_ = 0;
				_tmp23_ = i;
				i = _tmp23_ + 1;
			}
			_vala_f1 = -1;
			_tmp24_ = _vala_f1;
			_vala_r1 = _tmp24_;
			_tmp25_ = _vala_r1;
			_vala_f0 = _tmp25_;
			_tmp26_ = _vala_f0;
			_vala_r0 = _tmp26_;
			_tmp28_ = move;
			_tmp29_ = i;
			_tmp30_ = string_get (_tmp28_, (glong) _tmp29_);
			if (_tmp30_ >= 'a') {
				const gchar* _tmp31_ = NULL;
				gint _tmp32_ = 0;
				gchar _tmp33_ = '\0';
				_tmp31_ = move;
				_tmp32_ = i;
				_tmp33_ = string_get (_tmp31_, (glong) _tmp32_);
				_tmp27_ = _tmp33_ <= 'h';
			} else {
				_tmp27_ = FALSE;
			}
			if (_tmp27_) {
				const gchar* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gchar _tmp36_ = '\0';
				gint _tmp37_ = 0;
				_tmp34_ = move;
				_tmp35_ = i;
				_tmp36_ = string_get (_tmp34_, (glong) _tmp35_);
				_vala_f1 = (gint) (_tmp36_ - 'a');
				_tmp37_ = i;
				i = _tmp37_ + 1;
			}
			_tmp39_ = move;
			_tmp40_ = i;
			_tmp41_ = string_get (_tmp39_, (glong) _tmp40_);
			if (_tmp41_ >= '1') {
				const gchar* _tmp42_ = NULL;
				gint _tmp43_ = 0;
				gchar _tmp44_ = '\0';
				_tmp42_ = move;
				_tmp43_ = i;
				_tmp44_ = string_get (_tmp42_, (glong) _tmp43_);
				_tmp38_ = _tmp44_ <= '8';
			} else {
				_tmp38_ = FALSE;
			}
			if (_tmp38_) {
				const gchar* _tmp45_ = NULL;
				gint _tmp46_ = 0;
				gchar _tmp47_ = '\0';
				gint _tmp48_ = 0;
				_tmp45_ = move;
				_tmp46_ = i;
				_tmp47_ = string_get (_tmp45_, (glong) _tmp46_);
				_vala_r1 = (gint) (_tmp47_ - '1');
				_tmp48_ = i;
				i = _tmp48_ + 1;
			}
			_tmp50_ = move;
			_tmp51_ = i;
			_tmp52_ = string_get (_tmp50_, (glong) _tmp51_);
			if (_tmp52_ == 'x') {
				_tmp49_ = TRUE;
			} else {
				const gchar* _tmp53_ = NULL;
				gint _tmp54_ = 0;
				gchar _tmp55_ = '\0';
				_tmp53_ = move;
				_tmp54_ = i;
				_tmp55_ = string_get (_tmp53_, (glong) _tmp54_);
				_tmp49_ = _tmp55_ == '-';
			}
			if (_tmp49_) {
				gint _tmp56_ = 0;
				_tmp56_ = i;
				i = _tmp56_ + 1;
			}
			_tmp58_ = move;
			_tmp59_ = i;
			_tmp60_ = string_get (_tmp58_, (glong) _tmp59_);
			if (_tmp60_ >= 'a') {
				const gchar* _tmp61_ = NULL;
				gint _tmp62_ = 0;
				gchar _tmp63_ = '\0';
				_tmp61_ = move;
				_tmp62_ = i;
				_tmp63_ = string_get (_tmp61_, (glong) _tmp62_);
				_tmp57_ = _tmp63_ <= 'h';
			} else {
				_tmp57_ = FALSE;
			}
			if (_tmp57_) {
				gint _tmp64_ = 0;
				const gchar* _tmp65_ = NULL;
				gint _tmp66_ = 0;
				gchar _tmp67_ = '\0';
				gint _tmp68_ = 0;
				_tmp64_ = _vala_f1;
				_vala_f0 = _tmp64_;
				_tmp65_ = move;
				_tmp66_ = i;
				_tmp67_ = string_get (_tmp65_, (glong) _tmp66_);
				_vala_f1 = (gint) (_tmp67_ - 'a');
				_tmp68_ = i;
				i = _tmp68_ + 1;
			}
			_tmp70_ = move;
			_tmp71_ = i;
			_tmp72_ = string_get (_tmp70_, (glong) _tmp71_);
			if (_tmp72_ >= '1') {
				const gchar* _tmp73_ = NULL;
				gint _tmp74_ = 0;
				gchar _tmp75_ = '\0';
				_tmp73_ = move;
				_tmp74_ = i;
				_tmp75_ = string_get (_tmp73_, (glong) _tmp74_);
				_tmp69_ = _tmp75_ <= '8';
			} else {
				_tmp69_ = FALSE;
			}
			if (_tmp69_) {
				gint _tmp76_ = 0;
				const gchar* _tmp77_ = NULL;
				gint _tmp78_ = 0;
				gchar _tmp79_ = '\0';
				gint _tmp80_ = 0;
				_tmp76_ = _vala_r1;
				_vala_r0 = _tmp76_;
				_tmp77_ = move;
				_tmp78_ = i;
				_tmp79_ = string_get (_tmp77_, (glong) _tmp78_);
				_vala_r1 = (gint) (_tmp79_ - '1');
				_tmp80_ = i;
				i = _tmp80_ + 1;
			}
			_tmp81_ = move;
			_tmp82_ = i;
			_tmp83_ = string_get (_tmp81_, (glong) _tmp82_);
			if (_tmp83_ == '=') {
				gint _tmp84_ = 0;
				const gchar* _tmp85_ = NULL;
				gint _tmp86_ = 0;
				gchar _tmp87_ = '\0';
				PieceType _tmp88_ = 0;
				gboolean _tmp89_ = FALSE;
				_tmp84_ = i;
				i = _tmp84_ + 1;
				_tmp85_ = move;
				_tmp86_ = i;
				_tmp87_ = string_get (_tmp85_, (glong) _tmp86_);
				_tmp89_ = chess_state_decode_piece_type (self, (gunichar) _tmp87_, &_tmp88_);
				_vala_promotion_type = _tmp88_;
				if (_tmp89_) {
					gint _tmp90_ = 0;
					_tmp90_ = i;
					i = _tmp90_ + 1;
				}
			} else {
				const gchar* _tmp91_ = NULL;
				gint _tmp92_ = 0;
				gchar _tmp93_ = '\0';
				_tmp91_ = move;
				_tmp92_ = i;
				_tmp93_ = string_get (_tmp91_, (glong) _tmp92_);
				if (_tmp93_ != '\0') {
					const gchar* _tmp94_ = NULL;
					gint _tmp95_ = 0;
					gchar _tmp96_ = '\0';
					_tmp94_ = move;
					_tmp95_ = i;
					_tmp96_ = string_get (_tmp94_, (glong) _tmp95_);
					switch (_tmp96_) {
						case 'q':
						case 'Q':
						{
							gint _tmp97_ = 0;
							_vala_promotion_type = PIECE_TYPE_QUEEN;
							_tmp97_ = i;
							i = _tmp97_ + 1;
							break;
						}
						case 'n':
						case 'N':
						{
							gint _tmp98_ = 0;
							_vala_promotion_type = PIECE_TYPE_KNIGHT;
							_tmp98_ = i;
							i = _tmp98_ + 1;
							break;
						}
						case 'r':
						case 'R':
						{
							gint _tmp99_ = 0;
							_vala_promotion_type = PIECE_TYPE_ROOK;
							_tmp99_ = i;
							i = _tmp99_ + 1;
							break;
						}
						case 'b':
						case 'B':
						{
							gint _tmp100_ = 0;
							_vala_promotion_type = PIECE_TYPE_BISHOP;
							_tmp100_ = i;
							i = _tmp100_ + 1;
							break;
						}
						default:
						break;
					}
				}
			}
			_tmp102_ = _vala_r1;
			if (_tmp102_ < 0) {
				_tmp101_ = TRUE;
			} else {
				gint _tmp103_ = 0;
				_tmp103_ = _vala_f1;
				_tmp101_ = _tmp103_ < 0;
			}
			if (_tmp101_) {
				const gchar* _tmp104_ = NULL;
				_tmp104_ = move;
				g_debug ("chess-game.vala:1179: Move %s missing destination", _tmp104_);
				result = FALSE;
				if (r0) {
					*r0 = _vala_r0;
				}
				if (f0) {
					*f0 = _vala_f0;
				}
				if (r1) {
					*r1 = _vala_r1;
				}
				if (f1) {
					*f1 = _vala_f1;
				}
				if (promotion_type) {
					*promotion_type = _vala_promotion_type;
				}
				return result;
			}
			_tmp106_ = _vala_r0;
			if (_tmp106_ < 0) {
				_tmp105_ = TRUE;
			} else {
				gint _tmp107_ = 0;
				_tmp107_ = _vala_f0;
				_tmp105_ = _tmp107_ < 0;
			}
			if (_tmp105_) {
				gint match_rank = 0;
				gint match_file = 0;
				gint _tmp146_ = 0;
				gint _tmp148_ = 0;
				gint _tmp149_ = 0;
				match_rank = -1;
				match_file = -1;
				{
					gint file = 0;
					file = 0;
					{
						gboolean _tmp108_ = FALSE;
						_tmp108_ = TRUE;
						while (TRUE) {
							gint _tmp110_ = 0;
							gboolean _tmp111_ = FALSE;
							gint _tmp112_ = 0;
							if (!_tmp108_) {
								gint _tmp109_ = 0;
								_tmp109_ = file;
								file = _tmp109_ + 1;
							}
							_tmp108_ = FALSE;
							_tmp110_ = file;
							if (!(_tmp110_ < 8)) {
								break;
							}
							_tmp112_ = _vala_f0;
							if (_tmp112_ >= 0) {
								gint _tmp113_ = 0;
								gint _tmp114_ = 0;
								_tmp113_ = file;
								_tmp114_ = _vala_f0;
								_tmp111_ = _tmp113_ != _tmp114_;
							} else {
								_tmp111_ = FALSE;
							}
							if (_tmp111_) {
								continue;
							}
							{
								gint rank = 0;
								rank = 0;
								{
									gboolean _tmp115_ = FALSE;
									_tmp115_ = TRUE;
									while (TRUE) {
										gint _tmp117_ = 0;
										gboolean _tmp118_ = FALSE;
										gint _tmp119_ = 0;
										ChessPiece* piece = NULL;
										gint _tmp122_ = 0;
										gint _tmp123_ = 0;
										gint _tmp124_ = 0;
										ChessPiece* _tmp125_ = NULL;
										ChessPiece* _tmp126_ = NULL;
										gboolean _tmp127_ = FALSE;
										gboolean _tmp128_ = FALSE;
										ChessPiece* _tmp129_ = NULL;
										ChessPlayer* _tmp136_ = NULL;
										gint _tmp137_ = 0;
										gint _tmp138_ = 0;
										gint _tmp139_ = 0;
										gint _tmp140_ = 0;
										gboolean _tmp141_ = FALSE;
										gint _tmp142_ = 0;
										gint _tmp144_ = 0;
										gint _tmp145_ = 0;
										if (!_tmp115_) {
											gint _tmp116_ = 0;
											_tmp116_ = rank;
											rank = _tmp116_ + 1;
										}
										_tmp115_ = FALSE;
										_tmp117_ = rank;
										if (!(_tmp117_ < 8)) {
											break;
										}
										_tmp119_ = _vala_r0;
										if (_tmp119_ >= 0) {
											gint _tmp120_ = 0;
											gint _tmp121_ = 0;
											_tmp120_ = rank;
											_tmp121_ = _vala_r0;
											_tmp118_ = _tmp120_ != _tmp121_;
										} else {
											_tmp118_ = FALSE;
										}
										if (_tmp118_) {
											continue;
										}
										_tmp122_ = rank;
										_tmp123_ = file;
										_tmp124_ = chess_state_get_index (self, _tmp122_, _tmp123_);
										_tmp125_ = self->board[_tmp124_];
										_tmp126_ = _chess_piece_ref0 (_tmp125_);
										piece = _tmp126_;
										_tmp129_ = piece;
										if (_tmp129_ == NULL) {
											_tmp128_ = TRUE;
										} else {
											ChessPiece* _tmp130_ = NULL;
											PieceType _tmp131_ = 0;
											PieceType _tmp132_ = 0;
											_tmp130_ = piece;
											_tmp131_ = _tmp130_->type;
											_tmp132_ = type;
											_tmp128_ = _tmp131_ != _tmp132_;
										}
										if (_tmp128_) {
											_tmp127_ = TRUE;
										} else {
											ChessPiece* _tmp133_ = NULL;
											ChessPlayer* _tmp134_ = NULL;
											ChessPlayer* _tmp135_ = NULL;
											_tmp133_ = piece;
											_tmp134_ = _tmp133_->player;
											_tmp135_ = player;
											_tmp127_ = _tmp134_ != _tmp135_;
										}
										if (_tmp127_) {
											_chess_piece_unref0 (piece);
											continue;
										}
										_tmp136_ = player;
										_tmp137_ = rank;
										_tmp138_ = file;
										_tmp139_ = _vala_r1;
										_tmp140_ = _vala_f1;
										_tmp141_ = chess_state_move_with_coords (self, _tmp136_, _tmp137_, _tmp138_, _tmp139_, _tmp140_, PIECE_TYPE_QUEEN, FALSE, TRUE);
										if (!_tmp141_) {
											_chess_piece_unref0 (piece);
											continue;
										}
										_tmp142_ = match_rank;
										if (_tmp142_ >= 0) {
											const gchar* _tmp143_ = NULL;
											_tmp143_ = move;
											g_debug ("chess-game.vala:1210: Move %s is ambiguous", _tmp143_);
											result = FALSE;
											_chess_piece_unref0 (piece);
											if (r0) {
												*r0 = _vala_r0;
											}
											if (f0) {
												*f0 = _vala_f0;
											}
											if (r1) {
												*r1 = _vala_r1;
											}
											if (f1) {
												*f1 = _vala_f1;
											}
											if (promotion_type) {
												*promotion_type = _vala_promotion_type;
											}
											return result;
										}
										_tmp144_ = rank;
										match_rank = _tmp144_;
										_tmp145_ = file;
										match_file = _tmp145_;
										_chess_piece_unref0 (piece);
									}
								}
							}
						}
					}
				}
				_tmp146_ = match_rank;
				if (_tmp146_ < 0) {
					const gchar* _tmp147_ = NULL;
					_tmp147_ = move;
					g_debug ("chess-game.vala:1221: Move %s has no matches", _tmp147_);
					result = FALSE;
					if (r0) {
						*r0 = _vala_r0;
					}
					if (f0) {
						*f0 = _vala_f0;
					}
					if (r1) {
						*r1 = _vala_r1;
					}
					if (f1) {
						*f1 = _vala_f1;
					}
					if (promotion_type) {
						*promotion_type = _vala_promotion_type;
					}
					return result;
				}
				_tmp148_ = match_rank;
				_vala_r0 = _tmp148_;
				_tmp149_ = match_file;
				_vala_f0 = _tmp149_;
			}
		}
	}
	_tmp150_ = move;
	_tmp151_ = i;
	_tmp152_ = string_get (_tmp150_, (glong) _tmp151_);
	if (_tmp152_ == '+') {
		gint _tmp153_ = 0;
		_tmp153_ = i;
		i = _tmp153_ + 1;
	} else {
		const gchar* _tmp154_ = NULL;
		gint _tmp155_ = 0;
		gchar _tmp156_ = '\0';
		_tmp154_ = move;
		_tmp155_ = i;
		_tmp156_ = string_get (_tmp154_, (glong) _tmp155_);
		if (_tmp156_ == '#') {
			gint _tmp157_ = 0;
			_tmp157_ = i;
			i = _tmp157_ + 1;
		}
	}
	_tmp158_ = move;
	_tmp159_ = i;
	_tmp160_ = string_get (_tmp158_, (glong) _tmp159_);
	if (_tmp160_ != '\0') {
		const gchar* _tmp161_ = NULL;
		_tmp161_ = move;
		g_debug ("chess-game.vala:1237: Move %s has unexpected characters", _tmp161_);
		result = FALSE;
		if (r0) {
			*r0 = _vala_r0;
		}
		if (f0) {
			*f0 = _vala_f0;
		}
		if (r1) {
			*r1 = _vala_r1;
		}
		if (f1) {
			*f1 = _vala_f1;
		}
		if (promotion_type) {
			*promotion_type = _vala_promotion_type;
		}
		return result;
	}
	result = TRUE;
	if (r0) {
		*r0 = _vala_r0;
	}
	if (f0) {
		*f0 = _vala_f0;
	}
	if (r1) {
		*r1 = _vala_r1;
	}
	if (f1) {
		*f1 = _vala_f1;
	}
	if (promotion_type) {
		*promotion_type = _vala_promotion_type;
	}
	return result;
}


ChessPlayer* chess_state_get_opponent (ChessState* self) {
	ChessPlayer* result;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp1_ = self->current_player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		ChessPlayer* _tmp3_ = NULL;
		_tmp3_ = self->players[COLOR_BLACK];
		_tmp0_ = _tmp3_;
	} else {
		ChessPlayer* _tmp4_ = NULL;
		_tmp4_ = self->players[COLOR_WHITE];
		_tmp0_ = _tmp4_;
	}
	result = _tmp0_;
	return result;
}


static void value_chess_state_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void value_chess_state_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		chess_state_unref (value->data[0].v_pointer);
	}
}


static void value_chess_state_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = chess_state_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer value_chess_state_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* value_chess_state_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		ChessState* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = chess_state_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* value_chess_state_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	ChessState** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = chess_state_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* param_spec_chess_state (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	ParamSpecChessState* spec;
	g_return_val_if_fail (g_type_is_a (object_type, TYPE_CHESS_STATE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer value_get_chess_state (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE), NULL);
	return value->data[0].v_pointer;
}


void value_set_chess_state (GValue* value, gpointer v_object) {
	ChessState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		chess_state_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_state_unref (old);
	}
}


void value_take_chess_state (GValue* value, gpointer v_object) {
	ChessState* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, TYPE_CHESS_STATE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, TYPE_CHESS_STATE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		chess_state_unref (old);
	}
}


static void chess_state_class_init (ChessStateClass * klass) {
	chess_state_parent_class = g_type_class_peek_parent (klass);
	CHESS_STATE_CLASS (klass)->finalize = chess_state_finalize;
	g_type_class_add_private (klass, sizeof (ChessStatePrivate));
}


static void chess_state_instance_init (ChessState * self) {
	self->priv = CHESS_STATE_GET_PRIVATE (self);
	self->number = 0;
	self->en_passant_index = -1;
	self->last_move = NULL;
	self->ref_count = 1;
}


static void chess_state_finalize (ChessState* obj) {
	ChessState * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_STATE, ChessState);
	_vala_array_destroy (self->players, 2, (GDestroyNotify) g_object_unref);
	_g_object_unref0 (self->current_player);
	_vala_array_destroy (self->board, 64, (GDestroyNotify) chess_piece_unref);
	_chess_move_unref0 (self->last_move);
}


GType chess_state_get_type (void) {
	static volatile gsize chess_state_type_id__volatile = 0;
	if (g_once_init_enter (&chess_state_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { value_chess_state_init, value_chess_state_free_value, value_chess_state_copy_value, value_chess_state_peek_pointer, "p", value_chess_state_collect_value, "p", value_chess_state_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (ChessStateClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_state_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessState), 0, (GInstanceInitFunc) chess_state_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType chess_state_type_id;
		chess_state_type_id = g_type_register_fundamental (g_type_fundamental_next (), "ChessState", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&chess_state_type_id__volatile, chess_state_type_id);
	}
	return chess_state_type_id__volatile;
}


gpointer chess_state_ref (gpointer instance) {
	ChessState* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void chess_state_unref (gpointer instance) {
	ChessState* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		CHESS_STATE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


GType chess_result_get_type (void) {
	static volatile gsize chess_result_type_id__volatile = 0;
	if (g_once_init_enter (&chess_result_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RESULT_IN_PROGRESS, "CHESS_RESULT_IN_PROGRESS", "in-progress"}, {CHESS_RESULT_WHITE_WON, "CHESS_RESULT_WHITE_WON", "white-won"}, {CHESS_RESULT_BLACK_WON, "CHESS_RESULT_BLACK_WON", "black-won"}, {CHESS_RESULT_DRAW, "CHESS_RESULT_DRAW", "draw"}, {CHESS_RESULT_BUG, "CHESS_RESULT_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_result_type_id;
		chess_result_type_id = g_enum_register_static ("ChessResult", values);
		g_once_init_leave (&chess_result_type_id__volatile, chess_result_type_id);
	}
	return chess_result_type_id__volatile;
}


GType chess_rule_get_type (void) {
	static volatile gsize chess_rule_type_id__volatile = 0;
	if (g_once_init_enter (&chess_rule_type_id__volatile)) {
		static const GEnumValue values[] = {{CHESS_RULE_CHECKMATE, "CHESS_RULE_CHECKMATE", "checkmate"}, {CHESS_RULE_STALEMATE, "CHESS_RULE_STALEMATE", "stalemate"}, {CHESS_RULE_FIFTY_MOVES, "CHESS_RULE_FIFTY_MOVES", "fifty-moves"}, {CHESS_RULE_TIMEOUT, "CHESS_RULE_TIMEOUT", "timeout"}, {CHESS_RULE_THREE_FOLD_REPETITION, "CHESS_RULE_THREE_FOLD_REPETITION", "three-fold-repetition"}, {CHESS_RULE_INSUFFICIENT_MATERIAL, "CHESS_RULE_INSUFFICIENT_MATERIAL", "insufficient-material"}, {CHESS_RULE_RESIGN, "CHESS_RULE_RESIGN", "resign"}, {CHESS_RULE_ABANDONMENT, "CHESS_RULE_ABANDONMENT", "abandonment"}, {CHESS_RULE_DEATH, "CHESS_RULE_DEATH", "death"}, {CHESS_RULE_BUG, "CHESS_RULE_BUG", "bug"}, {0, NULL, NULL}};
		GType chess_rule_type_id;
		chess_rule_type_id = g_enum_register_static ("ChessRule", values);
		g_once_init_leave (&chess_rule_type_id__volatile, chess_rule_type_id);
	}
	return chess_rule_type_id__volatile;
}


static void _chess_state_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (chess_state_unref (var), NULL));
}


static void _g_list_free__chess_state_unref0_ (GList* self) {
	g_list_foreach (self, (GFunc) _chess_state_unref0_, NULL);
	g_list_free (self);
}


static gboolean _chess_game_move_cb_chess_player_do_move (ChessPlayer* _sender, const gchar* move, gboolean apply, gpointer self) {
	gboolean result;
	result = chess_game_move_cb ((ChessGame*) self, _sender, move, apply);
	return result;
}


static void _chess_game_undo_cb_chess_player_do_undo (ChessPlayer* _sender, gpointer self) {
	chess_game_undo_cb ((ChessGame*) self, _sender);
}


static gboolean _chess_game_resign_cb_chess_player_do_resign (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_resign_cb ((ChessGame*) self, _sender);
	return result;
}


static gboolean _chess_game_claim_draw_cb_chess_player_do_claim_draw (ChessPlayer* _sender, gpointer self) {
	gboolean result;
	result = chess_game_claim_draw_cb ((ChessGame*) self, _sender);
	return result;
}


ChessGame* chess_game_construct (GType object_type, const gchar* fen, gchar** moves, int moves_length1) {
	ChessGame * self = NULL;
	const gchar* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	gchar** _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	ChessPlayer* _tmp16_ = NULL;
	ChessPlayer* _tmp17_ = NULL;
	ChessPlayer* _tmp18_ = NULL;
	ChessPlayer* _tmp19_ = NULL;
	ChessPlayer* _tmp20_ = NULL;
	ChessPlayer* _tmp21_ = NULL;
	ChessPlayer* _tmp22_ = NULL;
	ChessPlayer* _tmp23_ = NULL;
	ChessPlayer* _tmp24_ = NULL;
	ChessPlayer* _tmp25_ = NULL;
	ChessPlayer* _tmp26_ = NULL;
	ChessPlayer* _tmp27_ = NULL;
	ChessPlayer* _tmp28_ = NULL;
	ChessPlayer* _tmp29_ = NULL;
	ChessPlayer* _tmp30_ = NULL;
	ChessPlayer* _tmp31_ = NULL;
	g_return_val_if_fail (fen != NULL, NULL);
	self = (ChessGame*) g_object_new (object_type, NULL);
	self->is_started = FALSE;
	_tmp0_ = fen;
	_tmp1_ = chess_state_new (_tmp0_);
	self->move_stack = g_list_prepend (self->move_stack, _tmp1_);
	self->result = CHESS_RESULT_IN_PROGRESS;
	_tmp2_ = moves;
	_tmp2__length1 = moves_length1;
	if (_tmp2_ != NULL) {
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp3_ = FALSE;
				_tmp3_ = TRUE;
				while (TRUE) {
					gint _tmp5_ = 0;
					gchar** _tmp6_ = NULL;
					gint _tmp6__length1 = 0;
					ChessPlayer* _tmp7_ = NULL;
					ChessPlayer* _tmp8_ = NULL;
					gchar** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					const gchar* _tmp11_ = NULL;
					gboolean _tmp12_ = FALSE;
					if (!_tmp3_) {
						gint _tmp4_ = 0;
						_tmp4_ = i;
						i = _tmp4_ + 1;
					}
					_tmp3_ = FALSE;
					_tmp5_ = i;
					_tmp6_ = moves;
					_tmp6__length1 = moves_length1;
					if (!(_tmp5_ < _tmp6__length1)) {
						break;
					}
					_tmp7_ = chess_game_get_current_player (self);
					_tmp8_ = _tmp7_;
					_tmp9_ = moves;
					_tmp9__length1 = moves_length1;
					_tmp10_ = i;
					_tmp11_ = _tmp9_[_tmp10_];
					_tmp12_ = chess_game_do_move (self, _tmp8_, _tmp11_, TRUE);
					if (!_tmp12_) {
						gchar** _tmp13_ = NULL;
						gint _tmp13__length1 = 0;
						gint _tmp14_ = 0;
						const gchar* _tmp15_ = NULL;
						_tmp13_ = moves;
						_tmp13__length1 = moves_length1;
						_tmp14_ = i;
						_tmp15_ = _tmp13_[_tmp14_];
						g_warning ("chess-game.vala:1332: Invalid move %s", _tmp15_);
					}
				}
			}
		}
	}
	_tmp16_ = chess_game_get_white (self);
	_tmp17_ = _tmp16_;
	g_signal_connect_object (_tmp17_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self, 0);
	_tmp18_ = chess_game_get_white (self);
	_tmp19_ = _tmp18_;
	g_signal_connect_object (_tmp19_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self, 0);
	_tmp20_ = chess_game_get_white (self);
	_tmp21_ = _tmp20_;
	g_signal_connect_object (_tmp21_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self, 0);
	_tmp22_ = chess_game_get_white (self);
	_tmp23_ = _tmp22_;
	g_signal_connect_object (_tmp23_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self, 0);
	_tmp24_ = chess_game_get_black (self);
	_tmp25_ = _tmp24_;
	g_signal_connect_object (_tmp25_, "do-move", (GCallback) _chess_game_move_cb_chess_player_do_move, self, 0);
	_tmp26_ = chess_game_get_black (self);
	_tmp27_ = _tmp26_;
	g_signal_connect_object (_tmp27_, "do-undo", (GCallback) _chess_game_undo_cb_chess_player_do_undo, self, 0);
	_tmp28_ = chess_game_get_black (self);
	_tmp29_ = _tmp28_;
	g_signal_connect_object (_tmp29_, "do-resign", (GCallback) _chess_game_resign_cb_chess_player_do_resign, self, 0);
	_tmp30_ = chess_game_get_black (self);
	_tmp31_ = _tmp30_;
	g_signal_connect_object (_tmp31_, "do-claim-draw", (GCallback) _chess_game_claim_draw_cb_chess_player_do_claim_draw, self, 0);
	return self;
}


ChessGame* chess_game_new (const gchar* fen, gchar** moves, int moves_length1) {
	return chess_game_construct (TYPE_CHESS_GAME, fen, moves, moves_length1);
}


static gboolean chess_game_move_cb (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessPlayer* _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	g_return_val_if_fail (move != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = player;
	_tmp2_ = move;
	_tmp3_ = apply;
	_tmp4_ = chess_game_do_move (self, _tmp1_, _tmp2_, _tmp3_);
	result = _tmp4_;
	return result;
}


static gpointer _chess_state_ref0 (gpointer self) {
	return self ? chess_state_ref (self) : NULL;
}


static gboolean chess_game_do_move (ChessGame* self, ChessPlayer* player, const gchar* move, gboolean apply) {
	gboolean result = FALSE;
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessState* state = NULL;
	ChessState* _tmp3_ = NULL;
	ChessState* _tmp4_ = NULL;
	ChessState* _tmp5_ = NULL;
	ChessState* _tmp6_ = NULL;
	gint _tmp7_ = 0;
	ChessState* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp12_ = FALSE;
	ChessState* _tmp13_ = NULL;
	ChessState* _tmp14_ = NULL;
	ChessState* _tmp15_ = NULL;
	ChessMove* _tmp16_ = NULL;
	ChessPiece* _tmp17_ = NULL;
	ChessState* _tmp21_ = NULL;
	ChessMove* _tmp22_ = NULL;
	ChessPiece* _tmp23_ = NULL;
	ChessState* _tmp24_ = NULL;
	ChessMove* _tmp25_ = NULL;
	ChessPiece* _tmp26_ = NULL;
	ChessState* _tmp30_ = NULL;
	ChessMove* _tmp31_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = player;
	_tmp1_ = chess_game_get_current_player (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp3_ = chess_game_get_current_state (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = chess_state_copy (_tmp4_);
	state = _tmp5_;
	_tmp6_ = state;
	_tmp7_ = _tmp6_->number;
	_tmp6_->number = _tmp7_ + 1;
	_tmp8_ = state;
	_tmp9_ = move;
	_tmp10_ = apply;
	_tmp11_ = chess_state_move (_tmp8_, _tmp9_, _tmp10_);
	if (!_tmp11_) {
		result = FALSE;
		_chess_state_unref0 (state);
		return result;
	}
	_tmp12_ = apply;
	if (!_tmp12_) {
		result = TRUE;
		_chess_state_unref0 (state);
		return result;
	}
	_tmp13_ = state;
	_tmp14_ = _chess_state_ref0 (_tmp13_);
	self->move_stack = g_list_prepend (self->move_stack, _tmp14_);
	_tmp15_ = state;
	_tmp16_ = _tmp15_->last_move;
	_tmp17_ = _tmp16_->victim;
	if (_tmp17_ != NULL) {
		ChessState* _tmp18_ = NULL;
		ChessMove* _tmp19_ = NULL;
		ChessPiece* _tmp20_ = NULL;
		_tmp18_ = state;
		_tmp19_ = _tmp18_->last_move;
		_tmp20_ = _tmp19_->victim;
		g_signal_emit_by_name (_tmp20_, "died");
	}
	_tmp21_ = state;
	_tmp22_ = _tmp21_->last_move;
	_tmp23_ = _tmp22_->piece;
	g_signal_emit_by_name (_tmp23_, "moved");
	_tmp24_ = state;
	_tmp25_ = _tmp24_->last_move;
	_tmp26_ = _tmp25_->moved_rook;
	if (_tmp26_ != NULL) {
		ChessState* _tmp27_ = NULL;
		ChessMove* _tmp28_ = NULL;
		ChessPiece* _tmp29_ = NULL;
		_tmp27_ = state;
		_tmp28_ = _tmp27_->last_move;
		_tmp29_ = _tmp28_->moved_rook;
		g_signal_emit_by_name (_tmp29_, "moved");
	}
	_tmp30_ = state;
	_tmp31_ = _tmp30_->last_move;
	g_signal_emit_by_name (self, "moved", _tmp31_);
	chess_game_complete_move (self);
	result = TRUE;
	_chess_state_unref0 (state);
	return result;
}


void chess_game_add_hold (ChessGame* self) {
	gint _tmp0_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	self->priv->hold_count = _tmp0_ + 1;
}


void chess_game_remove_hold (ChessGame* self) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	g_return_if_fail (_tmp0_ > 0);
	_tmp1_ = self->priv->hold_count;
	self->priv->hold_count = _tmp1_ - 1;
	_tmp2_ = self->priv->hold_count;
	if (_tmp2_ == 0) {
		chess_game_complete_move (self);
	}
}


static void chess_game_complete_move (ChessGame* self) {
	gint _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ChessRule rule = 0;
	ChessResult _result_ = 0;
	ChessState* _tmp2_ = NULL;
	ChessState* _tmp3_ = NULL;
	ChessRule _tmp4_ = 0;
	ChessResult _tmp5_ = 0;
	ChessResult _tmp6_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->hold_count;
	if (_tmp0_ > 0) {
		return;
	}
	_tmp1_ = self->is_started;
	if (!_tmp1_) {
		return;
	}
	_tmp2_ = chess_game_get_current_state (self);
	_tmp3_ = _tmp2_;
	_tmp5_ = chess_state_get_result (_tmp3_, &_tmp4_);
	rule = _tmp4_;
	_result_ = _tmp5_;
	_tmp6_ = _result_;
	if (_tmp6_ != CHESS_RESULT_IN_PROGRESS) {
		ChessResult _tmp7_ = 0;
		ChessRule _tmp8_ = 0;
		_tmp7_ = _result_;
		_tmp8_ = rule;
		chess_game_stop (self, _tmp7_, _tmp8_);
	} else {
		ChessClock* _tmp9_ = NULL;
		ChessPlayer* _tmp14_ = NULL;
		ChessPlayer* _tmp15_ = NULL;
		ChessPlayer* _tmp16_ = NULL;
		ChessPlayer* _tmp17_ = NULL;
		_tmp9_ = self->priv->_clock;
		if (_tmp9_ != NULL) {
			ChessClock* _tmp10_ = NULL;
			ChessPlayer* _tmp11_ = NULL;
			ChessPlayer* _tmp12_ = NULL;
			Color _tmp13_ = 0;
			_tmp10_ = self->priv->_clock;
			_tmp11_ = chess_game_get_current_player (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = _tmp12_->color;
			chess_clock_set_active_color (_tmp10_, _tmp13_);
		}
		_tmp14_ = chess_game_get_current_player (self);
		_tmp15_ = _tmp14_;
		g_signal_emit_by_name (_tmp15_, "start-turn");
		_tmp16_ = chess_game_get_current_player (self);
		_tmp17_ = _tmp16_;
		g_signal_emit_by_name (self, "turn-started", _tmp17_);
	}
}


static void chess_game_undo_cb (ChessGame* self, ChessPlayer* player) {
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	GList* _tmp5_ = NULL;
	GList* _tmp6_ = NULL;
	GList* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (player != NULL);
	_tmp0_ = player;
	_tmp1_ = chess_game_get_current_player (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ == _tmp2_) {
		ChessPlayer* _tmp3_ = NULL;
		ChessPlayer* _tmp4_ = NULL;
		_tmp3_ = chess_game_get_opponent (self);
		_tmp4_ = _tmp3_;
		chess_game_undo_cb (self, _tmp4_);
	}
	_tmp5_ = self->move_stack;
	_tmp6_ = _tmp5_->next;
	if (_tmp6_ == NULL) {
		return;
	}
	_tmp7_ = self->move_stack;
	self->move_stack = g_list_remove_link (self->move_stack, _tmp7_);
	g_signal_emit_by_name (self, "undo");
}


static gboolean chess_game_resign_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = player;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_RESIGN);
	} else {
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_RESIGN);
	}
	result = TRUE;
	return result;
}


static gboolean chess_game_claim_draw_cb (ChessGame* self, ChessPlayer* player) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	ChessState* _tmp1_ = NULL;
	ChessState* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (player != NULL, FALSE);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp1_ = chess_game_get_current_state (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->halfmove_clock;
	if (_tmp3_ >= 100) {
		chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_FIFTY_MOVES);
	} else {
		gboolean _tmp4_ = FALSE;
		_tmp4_ = chess_game_is_three_fold_repeat (self);
		if (_tmp4_) {
			chess_game_stop (self, CHESS_RESULT_DRAW, CHESS_RULE_THREE_FOLD_REPETITION);
		} else {
			result = FALSE;
			return result;
		}
	}
	result = TRUE;
	return result;
}


static void _chess_game_clock_expired_cb_chess_clock_expired (ChessClock* _sender, gpointer self) {
	chess_game_clock_expired_cb ((ChessGame*) self, _sender);
}


void chess_game_start (ChessGame* self) {
	ChessResult _tmp0_ = 0;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessPlayer* _tmp8_ = NULL;
	ChessPlayer* _tmp9_ = NULL;
	ChessPlayer* _tmp10_ = NULL;
	ChessPlayer* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->result;
	if (_tmp0_ != CHESS_RESULT_IN_PROGRESS) {
		return;
	}
	_tmp1_ = self->is_started;
	if (_tmp1_) {
		return;
	}
	self->is_started = TRUE;
	_tmp2_ = self->priv->_clock;
	if (_tmp2_ != NULL) {
		ChessClock* _tmp3_ = NULL;
		ChessClock* _tmp4_ = NULL;
		ChessPlayer* _tmp5_ = NULL;
		ChessPlayer* _tmp6_ = NULL;
		Color _tmp7_ = 0;
		_tmp3_ = self->priv->_clock;
		g_signal_connect_object (_tmp3_, "expired", (GCallback) _chess_game_clock_expired_cb_chess_clock_expired, self, 0);
		_tmp4_ = self->priv->_clock;
		_tmp5_ = chess_game_get_current_player (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = _tmp6_->color;
		chess_clock_set_active_color (_tmp4_, _tmp7_);
	}
	_tmp8_ = chess_game_get_current_player (self);
	_tmp9_ = _tmp8_;
	g_signal_emit_by_name (_tmp9_, "start-turn");
	_tmp10_ = chess_game_get_current_player (self);
	_tmp11_ = _tmp10_;
	g_signal_emit_by_name (self, "turn-started", _tmp11_);
}


static void chess_game_clock_expired_cb (ChessGame* self, ChessClock* clock) {
	ChessPlayer* _tmp0_ = NULL;
	ChessPlayer* _tmp1_ = NULL;
	Color _tmp2_ = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (clock != NULL);
	_tmp0_ = chess_game_get_current_player (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->color;
	if (_tmp2_ == COLOR_WHITE) {
		chess_game_stop (self, CHESS_RESULT_BLACK_WON, CHESS_RULE_TIMEOUT);
	} else {
		chess_game_stop (self, CHESS_RESULT_WHITE_WON, CHESS_RULE_TIMEOUT);
	}
}


ChessPiece* chess_game_get_piece (ChessGame* self, gint rank, gint file, gint move_number) {
	ChessPiece* result = NULL;
	gint _tmp0_ = 0;
	ChessState* state = NULL;
	GList* _tmp4_ = NULL;
	GList* _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	gint _tmp7_ = 0;
	gconstpointer _tmp8_ = NULL;
	ChessState* _tmp9_ = NULL;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	ChessPiece* _tmp13_ = NULL;
	ChessPiece* _tmp14_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = move_number;
	if (_tmp0_ < 0) {
		gint _tmp1_ = 0;
		GList* _tmp2_ = NULL;
		guint _tmp3_ = 0U;
		_tmp1_ = move_number;
		_tmp2_ = self->move_stack;
		_tmp3_ = g_list_length (_tmp2_);
		move_number = _tmp1_ + ((gint) _tmp3_);
	}
	_tmp4_ = self->move_stack;
	_tmp5_ = self->move_stack;
	_tmp6_ = g_list_length (_tmp5_);
	_tmp7_ = move_number;
	_tmp8_ = g_list_nth_data (_tmp4_, (_tmp6_ - _tmp7_) - 1);
	_tmp9_ = _chess_state_ref0 ((ChessState*) _tmp8_);
	state = _tmp9_;
	_tmp10_ = rank;
	_tmp11_ = file;
	_tmp12_ = chess_state_get_index (state, _tmp10_, _tmp11_);
	_tmp13_ = state->board[_tmp12_];
	_tmp14_ = _chess_piece_ref0 (_tmp13_);
	result = _tmp14_;
	_chess_state_unref0 (state);
	return result;
}


void chess_game_pause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp2_ = chess_game_get_clock (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ChessResult _tmp4_ = 0;
		_tmp4_ = self->result;
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->_is_paused;
		_tmp0_ = !_tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessClock* _tmp6_ = NULL;
		ChessClock* _tmp7_ = NULL;
		_tmp6_ = chess_game_get_clock (self);
		_tmp7_ = _tmp6_;
		chess_clock_pause (_tmp7_);
		chess_game_set_is_paused (self, TRUE);
		g_signal_emit_by_name (self, "paused");
	}
}


void chess_game_unpause (ChessGame* self) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	ChessClock* _tmp2_ = NULL;
	ChessClock* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp2_ = chess_game_get_clock (self);
	_tmp3_ = _tmp2_;
	if (_tmp3_ != NULL) {
		ChessResult _tmp4_ = 0;
		_tmp4_ = self->result;
		_tmp1_ = _tmp4_ == CHESS_RESULT_IN_PROGRESS;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		gboolean _tmp5_ = FALSE;
		_tmp5_ = self->priv->_is_paused;
		_tmp0_ = _tmp5_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		ChessClock* _tmp6_ = NULL;
		ChessClock* _tmp7_ = NULL;
		_tmp6_ = chess_game_get_clock (self);
		_tmp7_ = _tmp6_;
		chess_clock_unpause (_tmp7_);
		chess_game_set_is_paused (self, FALSE);
		g_signal_emit_by_name (self, "unpaused");
	}
}


void chess_game_stop (ChessGame* self, ChessResult _result_, ChessRule rule) {
	gboolean _tmp0_ = FALSE;
	ChessResult _tmp1_ = 0;
	ChessRule _tmp2_ = 0;
	ChessClock* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_started;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = _result_;
	self->result = _tmp1_;
	_tmp2_ = rule;
	self->rule = _tmp2_;
	self->is_started = FALSE;
	_tmp3_ = self->priv->_clock;
	if (_tmp3_ != NULL) {
		ChessClock* _tmp4_ = NULL;
		_tmp4_ = self->priv->_clock;
		chess_clock_stop (_tmp4_);
	}
	g_signal_emit_by_name (self, "ended");
}


static gboolean chess_game_is_three_fold_repeat (ChessGame* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->move_stack;
	{
		GList* state_collection = NULL;
		GList* state_it = NULL;
		state_collection = _tmp0_;
		for (state_it = state_collection; state_it != NULL; state_it = state_it->next) {
			ChessState* _tmp1_ = NULL;
			ChessState* state = NULL;
			_tmp1_ = _chess_state_ref0 ((ChessState*) state_it->data);
			state = _tmp1_;
			{
				ChessState* _tmp2_ = NULL;
				gint _tmp3_ = 0;
				_tmp2_ = state;
				_tmp3_ = chess_game_state_repeated_times (self, _tmp2_);
				if (_tmp3_ >= 3) {
					result = TRUE;
					_chess_state_unref0 (state);
					return result;
				}
				_chess_state_unref0 (state);
			}
		}
	}
	result = FALSE;
	return result;
}


gint chess_game_state_repeated_times (ChessGame* self, ChessState* s1) {
	gint result = 0;
	gint count = 0;
	GList* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, 0);
	g_return_val_if_fail (s1 != NULL, 0);
	count = 1;
	_tmp0_ = self->move_stack;
	{
		GList* s2_collection = NULL;
		GList* s2_it = NULL;
		s2_collection = _tmp0_;
		for (s2_it = s2_collection; s2_it != NULL; s2_it = s2_it->next) {
			ChessState* _tmp1_ = NULL;
			ChessState* s2 = NULL;
			_tmp1_ = _chess_state_ref0 ((ChessState*) s2_it->data);
			s2 = _tmp1_;
			{
				gboolean _tmp2_ = FALSE;
				ChessState* _tmp3_ = NULL;
				ChessState* _tmp4_ = NULL;
				_tmp3_ = s1;
				_tmp4_ = s2;
				if (_tmp3_ != _tmp4_) {
					ChessState* _tmp5_ = NULL;
					ChessState* _tmp6_ = NULL;
					gboolean _tmp7_ = FALSE;
					_tmp5_ = s1;
					_tmp6_ = s2;
					_tmp7_ = chess_state_equals (_tmp5_, _tmp6_);
					_tmp2_ = _tmp7_;
				} else {
					_tmp2_ = FALSE;
				}
				if (_tmp2_) {
					gint _tmp8_ = 0;
					_tmp8_ = count;
					count = _tmp8_ + 1;
				}
				_chess_state_unref0 (s2);
			}
		}
	}
	result = count;
	return result;
}


gboolean chess_game_get_is_paused (ChessGame* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_paused;
	result = _tmp0_;
	return result;
}


static void chess_game_set_is_paused (ChessGame* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_is_paused = _tmp0_;
	g_object_notify ((GObject *) self, "is-paused");
}


ChessState* chess_game_get_current_state (ChessGame* self) {
	ChessState* result;
	GList* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->move_stack;
	_tmp1_ = _tmp0_->data;
	result = (ChessState*) _tmp1_;
	return result;
}


ChessPlayer* chess_game_get_white (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->players[COLOR_WHITE];
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_black (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->players[COLOR_BLACK];
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_current_player (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->current_player;
	result = _tmp2_;
	return result;
}


ChessPlayer* chess_game_get_opponent (ChessGame* self) {
	ChessPlayer* result;
	ChessState* _tmp0_ = NULL;
	ChessState* _tmp1_ = NULL;
	ChessPlayer* _tmp2_ = NULL;
	ChessPlayer* _tmp3_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = chess_game_get_current_state (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = chess_state_get_opponent (_tmp1_);
	_tmp3_ = _tmp2_;
	result = _tmp3_;
	return result;
}


ChessClock* chess_game_get_clock (ChessGame* self) {
	ChessClock* result;
	ChessClock* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_clock;
	result = _tmp0_;
	return result;
}


void chess_game_set_clock (ChessGame* self, ChessClock* value) {
	gboolean _tmp0_ = FALSE;
	ChessClock* _tmp1_ = NULL;
	ChessClock* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->is_started;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = value;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (self->priv->_clock);
	self->priv->_clock = _tmp2_;
	g_object_notify ((GObject *) self, "clock");
}


guint chess_game_get_n_moves (ChessGame* self) {
	guint result;
	GList* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = self->move_stack;
	_tmp1_ = g_list_length (_tmp0_);
	result = _tmp1_ - 1;
	return result;
}


static void g_cclosure_user_marshal_VOID__CHESS_MOVE (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__CHESS_MOVE) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__CHESS_MOVE callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__CHESS_MOVE) (marshal_data ? marshal_data : cc->callback);
	callback (data1, value_get_chess_move (param_values + 1), data2);
}


static void chess_game_class_init (ChessGameClass * klass) {
	chess_game_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ChessGamePrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_chess_game_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_chess_game_set_property;
	G_OBJECT_CLASS (klass)->finalize = chess_game_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_IS_PAUSED, g_param_spec_boolean ("is-paused", "is-paused", "is-paused", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CURRENT_STATE, param_spec_chess_state ("current-state", "current-state", "current-state", TYPE_CHESS_STATE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_WHITE, g_param_spec_object ("white", "white", "white", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_BLACK, g_param_spec_object ("black", "black", "black", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CURRENT_PLAYER, g_param_spec_object ("current-player", "current-player", "current-player", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_OPPONENT, g_param_spec_object ("opponent", "opponent", "opponent", TYPE_CHESS_PLAYER, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_CLOCK, g_param_spec_object ("clock", "clock", "clock", TYPE_CHESS_CLOCK, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), CHESS_GAME_N_MOVES, g_param_spec_uint ("n-moves", "n-moves", "n-moves", 0, G_MAXUINT, 0U, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_signal_new ("turn_started", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__OBJECT, G_TYPE_NONE, 1, TYPE_CHESS_PLAYER);
	g_signal_new ("moved", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__CHESS_MOVE, G_TYPE_NONE, 1, TYPE_CHESS_MOVE);
	g_signal_new ("paused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("unpaused", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("undo", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("ended", TYPE_CHESS_GAME, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void chess_game_instance_init (ChessGame * self) {
	self->priv = CHESS_GAME_GET_PRIVATE (self);
	self->priv->hold_count = 0;
	self->priv->_is_paused = FALSE;
}


static void chess_game_finalize (GObject* obj) {
	ChessGame * self;
	ChessClock* _tmp0_ = NULL;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_CHESS_GAME, ChessGame);
	_tmp0_ = self->priv->_clock;
	if (_tmp0_ != NULL) {
		ChessClock* _tmp1_ = NULL;
		_tmp1_ = self->priv->_clock;
		chess_clock_stop (_tmp1_);
	}
	__g_list_free__chess_state_unref0_0 (self->move_stack);
	_g_object_unref0 (self->priv->_clock);
	G_OBJECT_CLASS (chess_game_parent_class)->finalize (obj);
}


GType chess_game_get_type (void) {
	static volatile gsize chess_game_type_id__volatile = 0;
	if (g_once_init_enter (&chess_game_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (ChessGameClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) chess_game_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ChessGame), 0, (GInstanceInitFunc) chess_game_instance_init, NULL };
		GType chess_game_type_id;
		chess_game_type_id = g_type_register_static (G_TYPE_OBJECT, "ChessGame", &g_define_type_info, 0);
		g_once_init_leave (&chess_game_type_id__volatile, chess_game_type_id);
	}
	return chess_game_type_id__volatile;
}


static void _vala_chess_game_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_GAME, ChessGame);
	switch (property_id) {
		case CHESS_GAME_IS_PAUSED:
		g_value_set_boolean (value, chess_game_get_is_paused (self));
		break;
		case CHESS_GAME_CURRENT_STATE:
		value_set_chess_state (value, chess_game_get_current_state (self));
		break;
		case CHESS_GAME_WHITE:
		g_value_set_object (value, chess_game_get_white (self));
		break;
		case CHESS_GAME_BLACK:
		g_value_set_object (value, chess_game_get_black (self));
		break;
		case CHESS_GAME_CURRENT_PLAYER:
		g_value_set_object (value, chess_game_get_current_player (self));
		break;
		case CHESS_GAME_OPPONENT:
		g_value_set_object (value, chess_game_get_opponent (self));
		break;
		case CHESS_GAME_CLOCK:
		g_value_set_object (value, chess_game_get_clock (self));
		break;
		case CHESS_GAME_N_MOVES:
		g_value_set_uint (value, chess_game_get_n_moves (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_chess_game_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	ChessGame * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_CHESS_GAME, ChessGame);
	switch (property_id) {
		case CHESS_GAME_IS_PAUSED:
		chess_game_set_is_paused (self, g_value_get_boolean (value));
		break;
		case CHESS_GAME_CLOCK:
		chess_game_set_clock (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



