/* fedora-installer.c generated by valac 0.17.7, the Vala compiler
 * generated from fedora-installer.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <libvirt-gconfig/libvirt-gconfig.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <libcommon.h>
#include <osinfo/osinfo.h>


#define BOXES_TYPE_INSTALLER_MEDIA (boxes_installer_media_get_type ())
#define BOXES_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMedia))
#define BOXES_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))
#define BOXES_IS_INSTALLER_MEDIA(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_IS_INSTALLER_MEDIA_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_INSTALLER_MEDIA))
#define BOXES_INSTALLER_MEDIA_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_INSTALLER_MEDIA, BoxesInstallerMediaClass))

typedef struct _BoxesInstallerMedia BoxesInstallerMedia;
typedef struct _BoxesInstallerMediaClass BoxesInstallerMediaClass;
typedef struct _BoxesInstallerMediaPrivate BoxesInstallerMediaPrivate;

#define BOXES_TYPE_UNATTENDED_INSTALLER (boxes_unattended_installer_get_type ())
#define BOXES_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller))
#define BOXES_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))
#define BOXES_IS_UNATTENDED_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_IS_UNATTENDED_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_UNATTENDED_INSTALLER))
#define BOXES_UNATTENDED_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstallerClass))

typedef struct _BoxesUnattendedInstaller BoxesUnattendedInstaller;
typedef struct _BoxesUnattendedInstallerClass BoxesUnattendedInstallerClass;
typedef struct _BoxesUnattendedInstallerPrivate BoxesUnattendedInstallerPrivate;

#define BOXES_TYPE_UNATTENDED_FILE (boxes_unattended_file_get_type ())
#define BOXES_UNATTENDED_FILE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFile))
#define BOXES_IS_UNATTENDED_FILE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_UNATTENDED_FILE))
#define BOXES_UNATTENDED_FILE_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BOXES_TYPE_UNATTENDED_FILE, BoxesUnattendedFileIface))

typedef struct _BoxesUnattendedFile BoxesUnattendedFile;
typedef struct _BoxesUnattendedFileIface BoxesUnattendedFileIface;

#define TYPE_AVATAR_FORMAT (avatar_format_get_type ())
#define AVATAR_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_FORMAT, AvatarFormat))
#define AVATAR_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_FORMAT, AvatarFormatClass))
#define IS_AVATAR_FORMAT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_FORMAT))
#define IS_AVATAR_FORMAT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_FORMAT))
#define AVATAR_FORMAT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_FORMAT, AvatarFormatClass))

typedef struct _AvatarFormat AvatarFormat;
typedef struct _AvatarFormatClass AvatarFormatClass;

#define BOXES_TYPE_FEDORA_INSTALLER (boxes_fedora_installer_get_type ())
#define BOXES_FEDORA_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstaller))
#define BOXES_FEDORA_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstallerClass))
#define BOXES_IS_FEDORA_INSTALLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_FEDORA_INSTALLER))
#define BOXES_IS_FEDORA_INSTALLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_FEDORA_INSTALLER))
#define BOXES_FEDORA_INSTALLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstallerClass))

typedef struct _BoxesFedoraInstaller BoxesFedoraInstaller;
typedef struct _BoxesFedoraInstallerClass BoxesFedoraInstallerClass;
typedef struct _BoxesFedoraInstallerPrivate BoxesFedoraInstallerPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define BOXES_FEDORA_INSTALLER_TYPE_KBD_LAYOUT (boxes_fedora_installer_kbd_layout_get_type ())
typedef struct _BoxesFedoraInstallerKbdLayout BoxesFedoraInstallerKbdLayout;

#define BOXES_TYPE_ISO_EXTRACTOR (boxes_iso_extractor_get_type ())
#define BOXES_ISO_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractor))
#define BOXES_ISO_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractorClass))
#define BOXES_IS_ISO_EXTRACTOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_ISO_EXTRACTOR))
#define BOXES_IS_ISO_EXTRACTOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_ISO_EXTRACTOR))
#define BOXES_ISO_EXTRACTOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_ISO_EXTRACTOR, BoxesISOExtractorClass))

typedef struct _BoxesISOExtractor BoxesISOExtractor;
typedef struct _BoxesISOExtractorClass BoxesISOExtractorClass;
typedef struct _BoxesFedoraInstallerPrepareForInstallationData BoxesFedoraInstallerPrepareForInstallationData;
typedef struct _BoxesFedoraInstallerExtractBootFilesData BoxesFedoraInstallerExtractBootFilesData;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesFedoraInstallerCopyFileData BoxesFedoraInstallerCopyFileData;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

struct _BoxesInstallerMedia {
	GObject parent_instance;
	BoxesInstallerMediaPrivate * priv;
	OsinfoOs* os;
	OsinfoResources* resources;
	OsinfoMedia* os_media;
	gchar* label;
	gchar* device_file;
	gchar* mount_point;
	gboolean from_image;
};

struct _BoxesInstallerMediaClass {
	GObjectClass parent_class;
	void (*set_direct_boot_params) (BoxesInstallerMedia* self, GVirConfigDomainOs* os);
	void (*prepare_for_installation) (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*prepare_for_installation_finish) (BoxesInstallerMedia* self, GAsyncResult* _res_, GError** error);
	void (*setup_domain_config) (BoxesInstallerMedia* self, GVirConfigDomain* domain);
	void (*populate_setup_vbox) (BoxesInstallerMedia* self, GtkVBox* setup_vbox);
	GList* (*get_vm_properties) (BoxesInstallerMedia* self);
	guint64 (*get_installed_size) (BoxesInstallerMedia* self);
	gboolean (*get_need_user_input_for_vm_creation) (BoxesInstallerMedia* self);
	gboolean (*get_user_data_for_vm_creation_available) (BoxesInstallerMedia* self);
	gboolean (*get_supports_virtio_disk) (BoxesInstallerMedia* self);
};

struct _BoxesUnattendedFileIface {
	GTypeInterface parent_iface;
	void (*get_source_file) (BoxesUnattendedFile* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
	GFile* (*get_source_file_finish) (BoxesUnattendedFile* self, GAsyncResult* _res_, GError** error);
	const gchar* (*get_src_path) (BoxesUnattendedFile* self);
	void (*set_src_path) (BoxesUnattendedFile* self, const gchar* value);
	const gchar* (*get_dest_name) (BoxesUnattendedFile* self);
	void (*set_dest_name) (BoxesUnattendedFile* self, const gchar* value);
	BoxesUnattendedInstaller* (*get_installer) (BoxesUnattendedFile* self);
	void (*set_installer) (BoxesUnattendedFile* self, BoxesUnattendedInstaller* value);
};

struct _BoxesUnattendedInstaller {
	BoxesInstallerMedia parent_instance;
	BoxesUnattendedInstallerPrivate * priv;
	GDataStreamNewlineType newline_type;
	GFile* disk_file;
	GList* unattended_files;
	GtkTable* setup_table;
	GtkLabel* setup_label;
	GtkHBox* setup_hbox;
	GtkSwitch* express_toggle;
	GtkEntry* username_entry;
	GtkEntry* password_entry;
	gchar* timezone;
	gchar* lang;
	gchar* hostname;
	AvatarFormat* avatar_format;
};

struct _BoxesUnattendedInstallerClass {
	BoxesInstallerMediaClass parent_class;
	gchar* (*fill_unattended_data) (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
	void (*setup_ui) (BoxesUnattendedInstaller* self);
	void (*clean_up) (BoxesUnattendedInstaller* self, GError** error);
	GVirConfigDomainDisk* (*get_unattended_disk_config) (BoxesUnattendedInstaller* self);
};

struct _BoxesFedoraInstaller {
	BoxesUnattendedInstaller parent_instance;
	BoxesFedoraInstallerPrivate * priv;
};

struct _BoxesFedoraInstallerClass {
	BoxesUnattendedInstallerClass parent_class;
};

struct _BoxesFedoraInstallerPrivate {
	GFile* kernel_file;
	GFile* initrd_file;
	gchar* kbd;
};

struct _BoxesFedoraInstallerKbdLayout {
	gchar* xkb_layout;
	gchar* xkb_variant;
	gchar* console_layout;
};

struct _BoxesFedoraInstallerPrepareForInstallationData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesFedoraInstaller* self;
	gchar* vm_name;
	GCancellable* cancellable;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	GtkSwitch* _tmp2_;
	gboolean _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	OsinfoMedia* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gboolean _tmp10_;
	OsinfoMedia* _tmp11_;
	gchar* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gboolean _tmp15_;
	const gchar* _tmp16_;
	BoxesISOExtractor* _tmp17_;
	BoxesISOExtractor* extractor;
	BoxesISOExtractor* _tmp18_;
	GCancellable* _tmp19_;
	BoxesISOExtractor* _tmp20_;
	GCancellable* _tmp21_;
	GError * _inner_error_;
};

struct _BoxesFedoraInstallerExtractBootFilesData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesFedoraInstaller* self;
	BoxesISOExtractor* extractor;
	GCancellable* cancellable;
	BoxesISOExtractor* _tmp0_;
	OsinfoMedia* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* src_path;
	gchar* _tmp7_;
	gchar* dest_path;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	GCancellable* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	BoxesISOExtractor* _tmp13_;
	OsinfoMedia* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar* _tmp17_;
	gchar* _tmp18_;
	gchar* _tmp19_;
	gchar* _tmp20_;
	gchar* _tmp21_;
	const gchar* _tmp22_;
	const gchar* _tmp23_;
	GCancellable* _tmp24_;
	GFile* _tmp25_;
	GFile* _tmp26_;
	GError * _inner_error_;
};

struct _BoxesFedoraInstallerCopyFileData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesFedoraInstaller* self;
	gchar* src_path;
	gchar* dest_path;
	GCancellable* cancellable;
	GFile* result;
	const gchar* _tmp0_;
	GFile* _tmp1_;
	GFile* src_file;
	const gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* dest_file;
	const gchar* _tmp4_;
	const gchar* _tmp5_;
	GCancellable* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer boxes_fedora_installer_parent_class = NULL;
static GRegex* boxes_fedora_installer_kbd_regex;
static GRegex* boxes_fedora_installer_kbd_regex = NULL;

GType boxes_installer_media_get_type (void) G_GNUC_CONST;
GType boxes_unattended_installer_get_type (void) G_GNUC_CONST;
GType boxes_unattended_file_get_type (void) G_GNUC_CONST;
gpointer avatar_format_ref (gpointer instance);
void avatar_format_unref (gpointer instance);
GParamSpec* param_spec_avatar_format (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_avatar_format (GValue* value, gpointer v_object);
void value_take_avatar_format (GValue* value, gpointer v_object);
gpointer value_get_avatar_format (const GValue* value);
GType avatar_format_get_type (void) G_GNUC_CONST;
GType boxes_fedora_installer_get_type (void) G_GNUC_CONST;
#define BOXES_FEDORA_INSTALLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstallerPrivate))
enum  {
	BOXES_FEDORA_INSTALLER_DUMMY_PROPERTY
};
static GType boxes_fedora_installer_kbd_layout_get_type (void) G_GNUC_CONST G_GNUC_UNUSED;
static BoxesFedoraInstallerKbdLayout* boxes_fedora_installer_kbd_layout_dup (const BoxesFedoraInstallerKbdLayout* self);
static void boxes_fedora_installer_kbd_layout_free (BoxesFedoraInstallerKbdLayout* self);
static void boxes_fedora_installer_kbd_layout_copy (const BoxesFedoraInstallerKbdLayout* self, BoxesFedoraInstallerKbdLayout* dest);
static void boxes_fedora_installer_kbd_layout_destroy (BoxesFedoraInstallerKbdLayout* self);
BoxesFedoraInstaller* boxes_fedora_installer_new_from_media (BoxesInstallerMedia* media, GError** error);
BoxesFedoraInstaller* boxes_fedora_installer_construct_from_media (GType object_type, BoxesInstallerMedia* media, GError** error);
BoxesUnattendedInstaller* boxes_unattended_installer_construct_from_media (GType object_type, BoxesInstallerMedia* media, const gchar* unattended_src_path, const gchar* unattended_dest_name, AvatarFormat* avatar_format, GError** error);
static gchar* boxes_fedora_installer_fetch_console_kbd_layout (BoxesFedoraInstaller* self);
static void boxes_fedora_installer_real_set_direct_boot_params (BoxesInstallerMedia* base, GVirConfigDomainOs* os);
static void boxes_fedora_installer_real_prepare_for_installation_data_free (gpointer _data);
static void boxes_fedora_installer_real_prepare_for_installation (BoxesInstallerMedia* base, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static gboolean boxes_fedora_installer_real_prepare_for_installation_co (BoxesFedoraInstallerPrepareForInstallationData* _data_);
void boxes_installer_media_prepare_for_installation (BoxesInstallerMedia* self, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void boxes_installer_media_prepare_for_installation_finish (BoxesInstallerMedia* self, GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_prepare_for_installation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
BoxesISOExtractor* boxes_iso_extractor_new (const gchar* iso_path);
BoxesISOExtractor* boxes_iso_extractor_construct (GType object_type, const gchar* iso_path);
GType boxes_iso_extractor_get_type (void) G_GNUC_CONST;
void boxes_iso_extractor_mount_media (BoxesISOExtractor* self, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
void boxes_iso_extractor_mount_media_finish (BoxesISOExtractor* self, GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_extract_boot_files (BoxesFedoraInstaller* self, BoxesISOExtractor* extractor, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void boxes_fedora_installer_extract_boot_files_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_real_clean_up (BoxesUnattendedInstaller* base, GError** error);
void boxes_unattended_installer_clean_up (BoxesUnattendedInstaller* self, GError** error);
static gchar* boxes_fedora_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, GError** error);
gchar* boxes_unattended_installer_fill_unattended_data (BoxesUnattendedInstaller* self, const gchar* data, GError** error);
static void boxes_fedora_installer_extract_boot_files_data_free (gpointer _data);
static gboolean boxes_fedora_installer_extract_boot_files_co (BoxesFedoraInstallerExtractBootFilesData* _data_);
gchar* boxes_iso_extractor_get_absolute_path (BoxesISOExtractor* self, const gchar* relative_path, GError** error);
gchar* boxes_unattended_installer_get_user_unattended (BoxesUnattendedInstaller* self, const gchar* suffix);
static void boxes_fedora_installer_copy_file (BoxesFedoraInstaller* self, const gchar* src_path, const gchar* dest_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
static GFile* boxes_fedora_installer_copy_file_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error);
static void boxes_fedora_installer_extract_boot_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static void boxes_fedora_installer_copy_file_data_free (gpointer _data);
static gboolean boxes_fedora_installer_copy_file_co (BoxesFedoraInstallerCopyFileData* _data_);
static void boxes_fedora_installer_copy_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gchar** _vala_array_dup1 (gchar** self, int length);
BoxesFedoraInstaller* boxes_fedora_installer_new (void);
BoxesFedoraInstaller* boxes_fedora_installer_construct (GType object_type);
BoxesUnattendedInstaller* boxes_unattended_installer_construct (GType object_type);
static void boxes_fedora_installer_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);

static const BoxesFedoraInstallerKbdLayout BOXES_FEDORA_INSTALLER_kbd_layouts[65] = {{"ara", NULL, "ar-azerty"}, {"ara", "azerty", "ar-azerty"}, {"ara", "azerty_digits", "ar-azerty-digits"}, {"ara", "digits", "ar-digits"}, {"ara", "qwerty", "ar-qwerty"}, {"ara", "qwerty_digits", "ar-qwerty-digits"}, {"be", NULL, "be-latin1"}, {"bg", NULL, "bg_bds-utf8"}, {"bg", "phonetic", "bg_pho-utf8"}, {"bg", "bas_phonetic", "bg_pho-utf8"}, {"br", NULL, "br-abnt2"}, {"ca(fr)", NULL, "cf"}, {"hr", NULL, "croat"}, {"cz", NULL, "cz-us-qwertz"}, {"cz", "qwerty", "cz-lat2"}, {"cz", "", "cz-us-qwertz"}, {"de", NULL, "de"}, {"de", "nodeadkeys", "de-latin1-nodeadkeys"}, {"dev", NULL, "dev"}, {"dk", NULL, "dk"}, {"dk", "dvorak", "dk-dvorak"}, {"es", NULL, "es"}, {"ee", NULL, "et"}, {"fi", NULL, "fi"}, {"fr", NULL, "fr"}, {"fr", "latin9", "fr-latin9"}, {"gr", NULL, "gr"}, {"gur", NULL, "gur"}, {"hu", NULL, "hu"}, {"hu", "qwerty", "hu101"}, {"ie", NULL, "ie"}, {"in", NULL, "us"}, {"in", "ben", "ben"}, {"in", "ben-probhat", "ben_probhat"}, {"in", "guj", "guj"}, {"in", "tam", "tml-inscript"}, {"in", "tam_TAB", "tml-uni"}, {"is", NULL, "is-latin1"}, {"it", NULL, "it"}, {"jp", NULL, "jp106"}, {"kr", NULL, "ko"}, {"latam", NULL, "la-latin1"}, {"mkd", NULL, "mk-utf"}, {"nl", NULL, "nl"}, {"no", NULL, "no"}, {"pl", NULL, "pl2"}, {"pt", NULL, "pt-latin1"}, {"ro", NULL, "ro"}, {"ro", "std", "ro-std"}, {"ro", "cedilla", "ro-cedilla"}, {"ro", "std_cedilla", "ro-std-cedilla"}, {"ru", NULL, "ru"}, {"rs", NULL, "sr-cy"}, {"rs", "latin", "sr-latin"}, {"se", NULL, "sv-latin1"}, {"ch", "de_nodeadkeys", "sg"}, {"ch", "fr", "fr_CH"}, {"sk", NULL, "sk-qwerty"}, {"si", NULL, "slovene"}, {"tj", NULL, "tj"}, {"tr", NULL, "trq"}, {"gb", NULL, "uk"}, {"ua", NULL, "ua-utf"}, {"us", NULL, "us"}, {"us", "intl", "us-acentos"}};

BoxesFedoraInstaller* boxes_fedora_installer_construct_from_media (GType object_type, BoxesInstallerMedia* media, GError** error) {
	BoxesFedoraInstaller * self = NULL;
	gchar* _tmp0_ = NULL;
	gchar* source_path;
	BoxesInstallerMedia* _tmp1_;
	gchar* _tmp2_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (media != NULL, NULL);
	_tmp0_ = boxes_get_unattended ("fedora.ks");
	source_path = _tmp0_;
	_tmp1_ = media;
	self = (BoxesFedoraInstaller*) boxes_unattended_installer_construct_from_media (object_type, _tmp1_, source_path, "ks.cfg", NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		_g_free0 (source_path);
		_g_object_unref0 (self);
		return NULL;
	}
	_tmp2_ = boxes_fedora_installer_fetch_console_kbd_layout (self);
	_g_free0 (self->priv->kbd);
	self->priv->kbd = _tmp2_;
	_g_free0 (source_path);
	return self;
}


BoxesFedoraInstaller* boxes_fedora_installer_new_from_media (BoxesInstallerMedia* media, GError** error) {
	return boxes_fedora_installer_construct_from_media (BOXES_TYPE_FEDORA_INSTALLER, media, error);
}


static void boxes_fedora_installer_real_set_direct_boot_params (BoxesInstallerMedia* base, GVirConfigDomainOs* os) {
	BoxesFedoraInstaller * self;
	gboolean _tmp0_ = FALSE;
	GFile* _tmp1_;
	gboolean _tmp3_;
	GVirConfigDomainOs* _tmp4_;
	GFile* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	GVirConfigDomainOs* _tmp8_;
	GFile* _tmp9_;
	gchar* _tmp10_ = NULL;
	gchar* _tmp11_;
	GVirConfigDomainOs* _tmp12_;
	self = (BoxesFedoraInstaller*) base;
	g_return_if_fail (os != NULL);
	_tmp1_ = self->priv->kernel_file;
	if (_tmp1_ == NULL) {
		_tmp0_ = TRUE;
	} else {
		GFile* _tmp2_;
		_tmp2_ = self->priv->initrd_file;
		_tmp0_ = _tmp2_ == NULL;
	}
	_tmp3_ = _tmp0_;
	if (_tmp3_) {
		return;
	}
	_tmp4_ = os;
	_tmp5_ = self->priv->kernel_file;
	_tmp6_ = g_file_get_path (_tmp5_);
	_tmp7_ = _tmp6_;
	gvir_config_domain_os_set_kernel (_tmp4_, _tmp7_);
	_g_free0 (_tmp7_);
	_tmp8_ = os;
	_tmp9_ = self->priv->initrd_file;
	_tmp10_ = g_file_get_path (_tmp9_);
	_tmp11_ = _tmp10_;
	gvir_config_domain_os_set_ramdisk (_tmp8_, _tmp11_);
	_g_free0 (_tmp11_);
	_tmp12_ = os;
	gvir_config_domain_os_set_cmdline (_tmp12_, "ks=hd:sda:/ks.cfg");
}


static void boxes_fedora_installer_real_prepare_for_installation_data_free (gpointer _data) {
	BoxesFedoraInstallerPrepareForInstallationData* _data_;
	_data_ = _data;
	_g_free0 (_data_->vm_name);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesFedoraInstallerPrepareForInstallationData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void boxes_fedora_installer_real_prepare_for_installation (BoxesInstallerMedia* base, const gchar* vm_name, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesFedoraInstaller * self;
	BoxesFedoraInstallerPrepareForInstallationData* _data_;
	BoxesFedoraInstaller* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	self = (BoxesFedoraInstaller*) base;
	_data_ = g_slice_new0 (BoxesFedoraInstallerPrepareForInstallationData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_fedora_installer_real_prepare_for_installation);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_fedora_installer_real_prepare_for_installation_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = vm_name;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->vm_name);
	_data_->vm_name = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	boxes_fedora_installer_real_prepare_for_installation_co (_data_);
}


static void boxes_fedora_installer_real_prepare_for_installation_finish (BoxesInstallerMedia* base, GAsyncResult* _res_, GError** error) {
	BoxesFedoraInstallerPrepareForInstallationData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void boxes_fedora_installer_prepare_for_installation_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesFedoraInstallerPrepareForInstallationData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_fedora_installer_real_prepare_for_installation_co (_data_);
}


static gboolean boxes_fedora_installer_real_prepare_for_installation_co (BoxesFedoraInstallerPrepareForInstallationData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		case 3:
		goto _state_3;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->vm_name;
	_data_->_tmp1_ = _data_->cancellable;
	_data_->_state_ = 1;
	BOXES_INSTALLER_MEDIA_CLASS (boxes_fedora_installer_parent_class)->prepare_for_installation ((BoxesInstallerMedia*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller), _data_->_tmp0_, _data_->_tmp1_, boxes_fedora_installer_prepare_for_installation_ready, _data_);
	return FALSE;
	_state_1:
	BOXES_INSTALLER_MEDIA_CLASS (boxes_fedora_installer_parent_class)->prepare_for_installation_finish ((BoxesInstallerMedia*) G_TYPE_CHECK_INSTANCE_CAST (_data_->self, BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller), _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp2_ = ((BoxesUnattendedInstaller*) _data_->self)->express_toggle;
	_data_->_tmp3_ = gtk_switch_get_active (_data_->_tmp2_);
	_data_->_tmp4_ = _data_->_tmp3_;
	if (!_data_->_tmp4_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp6_ = ((BoxesInstallerMedia*) _data_->self)->os_media;
	_data_->_tmp7_ = NULL;
	g_object_get (_data_->_tmp6_, "kernel-path", &_data_->_tmp7_, NULL);
	_data_->_tmp8_ = _data_->_tmp7_;
	_data_->_tmp9_ = _data_->_tmp8_;
	_data_->_tmp10_ = _data_->_tmp9_ == NULL;
	_g_free0 (_data_->_tmp9_);
	if (_data_->_tmp10_) {
		_data_->_tmp5_ = TRUE;
	} else {
		_data_->_tmp11_ = ((BoxesInstallerMedia*) _data_->self)->os_media;
		_data_->_tmp12_ = NULL;
		g_object_get (_data_->_tmp11_, "initrd-path", &_data_->_tmp12_, NULL);
		_data_->_tmp13_ = _data_->_tmp12_;
		_data_->_tmp14_ = _data_->_tmp13_;
		_data_->_tmp5_ = _data_->_tmp14_ == NULL;
		_g_free0 (_data_->_tmp14_);
	}
	_data_->_tmp15_ = _data_->_tmp5_;
	if (_data_->_tmp15_) {
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp16_ = ((BoxesInstallerMedia*) _data_->self)->device_file;
	_data_->_tmp17_ = boxes_iso_extractor_new (_data_->_tmp16_);
	_data_->extractor = _data_->_tmp17_;
	_data_->_tmp18_ = _data_->extractor;
	_data_->_tmp19_ = _data_->cancellable;
	_data_->_state_ = 2;
	boxes_iso_extractor_mount_media (_data_->_tmp18_, _data_->_tmp19_, boxes_fedora_installer_prepare_for_installation_ready, _data_);
	return FALSE;
	_state_2:
	boxes_iso_extractor_mount_media_finish (_data_->_tmp18_, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->extractor);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp20_ = _data_->extractor;
	_data_->_tmp21_ = _data_->cancellable;
	_data_->_state_ = 3;
	boxes_fedora_installer_extract_boot_files (_data_->self, _data_->_tmp20_, _data_->_tmp21_, boxes_fedora_installer_prepare_for_installation_ready, _data_);
	return FALSE;
	_state_3:
	boxes_fedora_installer_extract_boot_files_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->extractor);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->extractor);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_fedora_installer_real_clean_up (BoxesUnattendedInstaller* base, GError** error) {
	BoxesFedoraInstaller * self;
	GFile* _tmp0_;
	GFile* _tmp2_;
	GError * _inner_error_ = NULL;
	self = (BoxesFedoraInstaller*) base;
	BOXES_UNATTENDED_INSTALLER_CLASS (boxes_fedora_installer_parent_class)->clean_up (G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller), &_inner_error_);
	if (_inner_error_ != NULL) {
		g_propagate_error (error, _inner_error_);
		return;
	}
	_tmp0_ = self->priv->kernel_file;
	if (_tmp0_ != NULL) {
		GFile* _tmp1_;
		_tmp1_ = self->priv->kernel_file;
		boxes_delete_file (_tmp1_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_g_object_unref0 (self->priv->kernel_file);
		self->priv->kernel_file = NULL;
	}
	_tmp2_ = self->priv->initrd_file;
	if (_tmp2_ != NULL) {
		GFile* _tmp3_;
		_tmp3_ = self->priv->initrd_file;
		boxes_delete_file (_tmp3_, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_propagate_error (error, _inner_error_);
			return;
		}
		_g_object_unref0 (self->priv->initrd_file);
		self->priv->initrd_file = NULL;
	}
}


static gchar* boxes_fedora_installer_real_fill_unattended_data (BoxesUnattendedInstaller* base, const gchar* data, GError** error) {
	BoxesFedoraInstaller * self;
	gchar* result = NULL;
	const gchar* _tmp0_;
	gchar* _tmp1_ = NULL;
	gchar* str;
	GRegex* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	gint _tmp5_;
	gint _tmp6_;
	const gchar* _tmp7_;
	gchar* _tmp8_ = NULL;
	gchar* _tmp9_;
	GError * _inner_error_ = NULL;
	self = (BoxesFedoraInstaller*) base;
	g_return_val_if_fail (data != NULL, NULL);
	_tmp0_ = data;
	_tmp1_ = BOXES_UNATTENDED_INSTALLER_CLASS (boxes_fedora_installer_parent_class)->fill_unattended_data (G_TYPE_CHECK_INSTANCE_CAST (self, BOXES_TYPE_UNATTENDED_INSTALLER, BoxesUnattendedInstaller), _tmp0_, &_inner_error_);
	str = _tmp1_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			return NULL;
		} else {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	_tmp2_ = boxes_fedora_installer_kbd_regex;
	_tmp3_ = str;
	_tmp4_ = str;
	_tmp5_ = strlen (_tmp4_);
	_tmp6_ = _tmp5_;
	_tmp7_ = self->priv->kbd;
	_tmp8_ = g_regex_replace (_tmp2_, _tmp3_, (gssize) _tmp6_, 0, _tmp7_, 0, &_inner_error_);
	_tmp9_ = _tmp8_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			g_propagate_error (error, _inner_error_);
			_g_free0 (str);
			return NULL;
		} else {
			_g_free0 (str);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
	}
	result = _tmp9_;
	_g_free0 (str);
	return result;
}


static void boxes_fedora_installer_extract_boot_files_data_free (gpointer _data) {
	BoxesFedoraInstallerExtractBootFilesData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->extractor);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesFedoraInstallerExtractBootFilesData, _data_);
}


static void boxes_fedora_installer_extract_boot_files (BoxesFedoraInstaller* self, BoxesISOExtractor* extractor, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesFedoraInstallerExtractBootFilesData* _data_;
	BoxesFedoraInstaller* _tmp0_;
	BoxesISOExtractor* _tmp1_;
	BoxesISOExtractor* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
	_data_ = g_slice_new0 (BoxesFedoraInstallerExtractBootFilesData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_fedora_installer_extract_boot_files);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_fedora_installer_extract_boot_files_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = extractor;
	_tmp2_ = _g_object_ref0 (_tmp1_);
	_g_object_unref0 (_data_->extractor);
	_data_->extractor = _tmp2_;
	_tmp3_ = cancellable;
	_tmp4_ = _g_object_ref0 (_tmp3_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp4_;
	boxes_fedora_installer_extract_boot_files_co (_data_);
}


static void boxes_fedora_installer_extract_boot_files_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error) {
	BoxesFedoraInstallerExtractBootFilesData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void boxes_fedora_installer_extract_boot_files_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesFedoraInstallerExtractBootFilesData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_fedora_installer_extract_boot_files_co (_data_);
}


static gboolean boxes_fedora_installer_extract_boot_files_co (BoxesFedoraInstallerExtractBootFilesData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		case 2:
		goto _state_2;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->extractor;
	_data_->_tmp1_ = ((BoxesInstallerMedia*) _data_->self)->os_media;
	_data_->_tmp2_ = NULL;
	g_object_get (_data_->_tmp1_, "kernel-path", &_data_->_tmp2_, NULL);
	_data_->_tmp3_ = _data_->_tmp2_;
	_data_->_tmp4_ = _data_->_tmp3_;
	_data_->_tmp5_ = NULL;
	_data_->_tmp5_ = boxes_iso_extractor_get_absolute_path (_data_->_tmp0_, _data_->_tmp4_, &_data_->_inner_error_);
	_data_->_tmp6_ = _data_->_tmp5_;
	_g_free0 (_data_->_tmp4_);
	_data_->src_path = _data_->_tmp6_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->_tmp7_ = NULL;
	_data_->_tmp7_ = boxes_unattended_installer_get_user_unattended ((BoxesUnattendedInstaller*) _data_->self, "kernel");
	_data_->dest_path = _data_->_tmp7_;
	_data_->_tmp8_ = _data_->src_path;
	_data_->_tmp9_ = _data_->dest_path;
	_data_->_tmp10_ = _data_->cancellable;
	_data_->_state_ = 1;
	boxes_fedora_installer_copy_file (_data_->self, _data_->_tmp8_, _data_->_tmp9_, _data_->_tmp10_, boxes_fedora_installer_extract_boot_files_ready, _data_);
	return FALSE;
	_state_1:
	_data_->_tmp11_ = NULL;
	_data_->_tmp11_ = boxes_fedora_installer_copy_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp12_ = _data_->_tmp11_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->dest_path);
		_g_free0 (_data_->src_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->kernel_file);
	_data_->self->priv->kernel_file = _data_->_tmp12_;
	_data_->_tmp13_ = _data_->extractor;
	_data_->_tmp14_ = ((BoxesInstallerMedia*) _data_->self)->os_media;
	_data_->_tmp15_ = NULL;
	g_object_get (_data_->_tmp14_, "initrd-path", &_data_->_tmp15_, NULL);
	_data_->_tmp16_ = _data_->_tmp15_;
	_data_->_tmp17_ = _data_->_tmp16_;
	_data_->_tmp18_ = NULL;
	_data_->_tmp18_ = boxes_iso_extractor_get_absolute_path (_data_->_tmp13_, _data_->_tmp17_, &_data_->_inner_error_);
	_data_->_tmp19_ = _data_->_tmp18_;
	_g_free0 (_data_->_tmp17_);
	_data_->_tmp20_ = _data_->_tmp19_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->dest_path);
		_g_free0 (_data_->src_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_free0 (_data_->src_path);
	_data_->src_path = _data_->_tmp20_;
	_data_->_tmp21_ = NULL;
	_data_->_tmp21_ = boxes_unattended_installer_get_user_unattended ((BoxesUnattendedInstaller*) _data_->self, "initrd");
	_g_free0 (_data_->dest_path);
	_data_->dest_path = _data_->_tmp21_;
	_data_->_tmp22_ = _data_->src_path;
	_data_->_tmp23_ = _data_->dest_path;
	_data_->_tmp24_ = _data_->cancellable;
	_data_->_state_ = 2;
	boxes_fedora_installer_copy_file (_data_->self, _data_->_tmp22_, _data_->_tmp23_, _data_->_tmp24_, boxes_fedora_installer_extract_boot_files_ready, _data_);
	return FALSE;
	_state_2:
	_data_->_tmp25_ = NULL;
	_data_->_tmp25_ = boxes_fedora_installer_copy_file_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
	_data_->_tmp26_ = _data_->_tmp25_;
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_free0 (_data_->dest_path);
		_g_free0 (_data_->src_path);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_g_object_unref0 (_data_->self->priv->initrd_file);
	_data_->self->priv->initrd_file = _data_->_tmp26_;
	_g_free0 (_data_->dest_path);
	_g_free0 (_data_->src_path);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static void boxes_fedora_installer_copy_file_data_free (gpointer _data) {
	BoxesFedoraInstallerCopyFileData* _data_;
	_data_ = _data;
	_g_free0 (_data_->src_path);
	_g_free0 (_data_->dest_path);
	_g_object_unref0 (_data_->cancellable);
	_g_object_unref0 (_data_->result);
	_g_object_unref0 (_data_->self);
	g_slice_free (BoxesFedoraInstallerCopyFileData, _data_);
}


static void boxes_fedora_installer_copy_file (BoxesFedoraInstaller* self, const gchar* src_path, const gchar* dest_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesFedoraInstallerCopyFileData* _data_;
	BoxesFedoraInstaller* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	const gchar* _tmp3_;
	gchar* _tmp4_;
	GCancellable* _tmp5_;
	GCancellable* _tmp6_;
	_data_ = g_slice_new0 (BoxesFedoraInstallerCopyFileData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, boxes_fedora_installer_copy_file);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_fedora_installer_copy_file_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	_tmp1_ = src_path;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (_data_->src_path);
	_data_->src_path = _tmp2_;
	_tmp3_ = dest_path;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (_data_->dest_path);
	_data_->dest_path = _tmp4_;
	_tmp5_ = cancellable;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (_data_->cancellable);
	_data_->cancellable = _tmp6_;
	boxes_fedora_installer_copy_file_co (_data_);
}


static GFile* boxes_fedora_installer_copy_file_finish (BoxesFedoraInstaller* self, GAsyncResult* _res_, GError** error) {
	GFile* result;
	BoxesFedoraInstallerCopyFileData* _data_;
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
		return NULL;
	}
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
	result = _data_->result;
	_data_->result = NULL;
	return result;
}


static void boxes_fedora_installer_copy_file_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesFedoraInstallerCopyFileData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	boxes_fedora_installer_copy_file_co (_data_);
}


static gboolean boxes_fedora_installer_copy_file_co (BoxesFedoraInstallerCopyFileData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	_data_->_tmp0_ = _data_->src_path;
	_data_->_tmp1_ = NULL;
	_data_->_tmp1_ = g_file_new_for_path (_data_->_tmp0_);
	_data_->src_file = _data_->_tmp1_;
	_data_->_tmp2_ = _data_->dest_path;
	_data_->_tmp3_ = NULL;
	_data_->_tmp3_ = g_file_new_for_path (_data_->_tmp2_);
	_data_->dest_file = _data_->_tmp3_;
	{
		_data_->_tmp4_ = _data_->src_path;
		_data_->_tmp5_ = _data_->dest_path;
		g_debug ("fedora-installer.vala:88: Copying '%s' to '%s'..", _data_->_tmp4_, _data_->_tmp5_);
		_data_->_tmp6_ = _data_->cancellable;
		_data_->_state_ = 1;
		g_file_copy_async (_data_->src_file, _data_->dest_file, 0, G_PRIORITY_DEFAULT, _data_->_tmp6_, NULL, NULL, boxes_fedora_installer_copy_file_ready, _data_);
		return FALSE;
		_state_1:
		g_file_copy_finish (_data_->src_file, _data_->_res_, &_data_->_inner_error_);
		if (_data_->_inner_error_ != NULL) {
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
				goto __catch8_g_io_error_exists;
			}
			goto __finally8;
		}
		_data_->_tmp7_ = _data_->src_path;
		_data_->_tmp8_ = _data_->dest_path;
		g_debug ("fedora-installer.vala:90: Copied '%s' to '%s'.", _data_->_tmp7_, _data_->_tmp8_);
	}
	goto __finally8;
	__catch8_g_io_error_exists:
	{
		_data_->_error_ = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_g_error_free0 (_data_->_error_);
	}
	__finally8:
	if (_data_->_inner_error_ != NULL) {
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
		g_error_free (_data_->_inner_error_);
		_g_object_unref0 (_data_->dest_file);
		_g_object_unref0 (_data_->src_file);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	_data_->result = _data_->dest_file;
	_g_object_unref0 (_data_->src_file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
	_g_object_unref0 (_data_->dest_file);
	_g_object_unref0 (_data_->src_file);
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gchar** _vala_array_dup1 (gchar** self, int length) {
	gchar** result;
	int i;
	result = g_new0 (gchar*, length + 1);
	for (i = 0; i < length; i++) {
		gchar* _tmp0_;
		_tmp0_ = g_strdup (self[i]);
		result[i] = _tmp0_;
	}
	return result;
}


static gchar* boxes_fedora_installer_fetch_console_kbd_layout (BoxesFedoraInstaller* self) {
	gchar* result = NULL;
	gchar* method;
	gchar* layout_str;
	gchar** _tmp0_;
	gchar** _tmp1_ = NULL;
	gchar** _tmp2_;
	gint _tmp2__length1;
	gchar** schemas;
	gint schemas_length1;
	gint _schemas_size_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_;
	gboolean _tmp22_;
	const gchar* _tmp24_;
	gchar** _tmp25_;
	gchar** _tmp26_ = NULL;
	gchar** tokens;
	gint tokens_length1;
	gint _tokens_size_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	const gchar* _tmp28_;
	gchar* _tmp29_;
	gchar* xkb_layout;
	gchar** _tmp30_;
	gint _tmp30__length1;
	const gchar* _tmp31_;
	gchar* _tmp32_;
	gchar* xkb_variant;
	gchar* _tmp33_;
	gchar* console_layout;
	const gchar* _tmp57_;
	const gchar* _tmp60_;
	g_return_val_if_fail (self != NULL, NULL);
	method = NULL;
	layout_str = NULL;
	_tmp1_ = _tmp0_ = g_settings_list_schemas ();
	_tmp2_ = (_tmp1_ != NULL) ? _vala_array_dup1 (_tmp1_, _vala_array_length (_tmp0_)) : ((gpointer) _tmp1_);
	_tmp2__length1 = _vala_array_length (_tmp0_);
	schemas = _tmp2_;
	schemas_length1 = _tmp2__length1;
	_schemas_size_ = schemas_length1;
	_tmp3_ = schemas;
	_tmp3__length1 = schemas_length1;
	{
		gchar** s_collection = NULL;
		gint s_collection_length1 = 0;
		gint _s_collection_size_ = 0;
		gint s_it = 0;
		s_collection = _tmp3_;
		s_collection_length1 = _tmp3__length1;
		for (s_it = 0; s_it < _tmp3__length1; s_it = s_it + 1) {
			gchar* _tmp4_;
			gchar* s = NULL;
			_tmp4_ = g_strdup (s_collection[s_it]);
			s = _tmp4_;
			{
				const gchar* _tmp5_;
				_tmp5_ = s;
				if (g_strcmp0 (_tmp5_, "org.gnome.desktop.input-sources") == 0) {
					const gchar* _tmp6_;
					GSettings* _tmp7_;
					GSettings* settings;
					GSettings* _tmp8_;
					GVariant* _tmp9_ = NULL;
					GVariant* sources;
					GSettings* _tmp10_;
					guint _tmp11_ = 0U;
					guint current;
					guint _tmp12_;
					GVariant* _tmp13_;
					gsize _tmp14_ = 0UL;
					GVariant* _tmp15_;
					gsize _tmp16_ = 0UL;
					_tmp6_ = s;
					_tmp7_ = g_settings_new (_tmp6_);
					settings = _tmp7_;
					_tmp8_ = settings;
					_tmp9_ = g_settings_get_value (_tmp8_, "sources");
					sources = _tmp9_;
					_tmp10_ = settings;
					_tmp11_ = g_settings_get_uint (_tmp10_, "current");
					current = _tmp11_;
					_tmp12_ = current;
					_tmp13_ = sources;
					_tmp14_ = g_variant_n_children (_tmp13_);
					if (((gsize) _tmp12_) > _tmp14_) {
						current = (guint) 0;
					}
					_tmp15_ = sources;
					_tmp16_ = g_variant_n_children (_tmp15_);
					if (_tmp16_ > ((gsize) 0)) {
						GVariant* _tmp17_;
						guint _tmp18_;
						_tmp17_ = sources;
						_tmp18_ = current;
						g_variant_get_child (_tmp17_, (gsize) _tmp18_, "(ss)", &method, &layout_str, NULL);
					}
					_g_variant_unref0 (sources);
					_g_object_unref0 (settings);
					_g_free0 (s);
					break;
				}
				_g_free0 (s);
			}
		}
	}
	_tmp20_ = method;
	if (g_strcmp0 (_tmp20_, "xkb") != 0) {
		_tmp19_ = TRUE;
	} else {
		const gchar* _tmp21_;
		_tmp21_ = layout_str;
		_tmp19_ = _tmp21_ == NULL;
	}
	_tmp22_ = _tmp19_;
	if (_tmp22_) {
		gchar* _tmp23_;
		g_warning ("fedora-installer.vala:123: Failed to fetch prefered keyboard layout fr" \
"om user settings, falling back to 'us'..");
		_tmp23_ = g_strdup ("us");
		result = _tmp23_;
		schemas = (_vala_array_free (schemas, schemas_length1, (GDestroyNotify) g_free), NULL);
		_g_free0 (layout_str);
		_g_free0 (method);
		return result;
	}
	_tmp24_ = layout_str;
	_tmp26_ = _tmp25_ = g_strsplit (_tmp24_, "+", 0);
	tokens = _tmp26_;
	tokens_length1 = _vala_array_length (_tmp25_);
	_tokens_size_ = tokens_length1;
	_tmp27_ = tokens;
	_tmp27__length1 = tokens_length1;
	_tmp28_ = _tmp27_[0];
	_tmp29_ = g_strdup (_tmp28_);
	xkb_layout = _tmp29_;
	_tmp30_ = tokens;
	_tmp30__length1 = tokens_length1;
	_tmp31_ = _tmp30_[1];
	_tmp32_ = g_strdup (_tmp31_);
	xkb_variant = _tmp32_;
	_tmp33_ = g_strdup ((const gchar*) NULL);
	console_layout = _tmp33_;
	{
		gint i;
		i = 0;
		{
			gboolean _tmp34_;
			_tmp34_ = TRUE;
			while (TRUE) {
				gboolean _tmp35_;
				gint _tmp37_;
				const gchar* _tmp38_;
				gint _tmp39_;
				BoxesFedoraInstallerKbdLayout _tmp40_;
				const gchar* _tmp41_;
				_tmp35_ = _tmp34_;
				if (!_tmp35_) {
					gint _tmp36_;
					_tmp36_ = i;
					i = _tmp36_ + 1;
				}
				_tmp34_ = FALSE;
				_tmp37_ = i;
				if (!(_tmp37_ < G_N_ELEMENTS (BOXES_FEDORA_INSTALLER_kbd_layouts))) {
					break;
				}
				_tmp38_ = xkb_layout;
				_tmp39_ = i;
				_tmp40_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp39_];
				_tmp41_ = _tmp40_.xkb_layout;
				if (g_strcmp0 (_tmp38_, _tmp41_) == 0) {
					const gchar* _tmp42_;
					gint _tmp43_;
					BoxesFedoraInstallerKbdLayout _tmp44_;
					const gchar* _tmp45_;
					_tmp42_ = xkb_variant;
					_tmp43_ = i;
					_tmp44_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp43_];
					_tmp45_ = _tmp44_.xkb_variant;
					if (g_strcmp0 (_tmp42_, _tmp45_) == 0) {
						gint _tmp46_;
						BoxesFedoraInstallerKbdLayout _tmp47_;
						const gchar* _tmp48_;
						gchar* _tmp49_;
						_tmp46_ = i;
						_tmp47_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp46_];
						_tmp48_ = _tmp47_.console_layout;
						_tmp49_ = g_strdup (_tmp48_);
						_g_free0 (console_layout);
						console_layout = _tmp49_;
						break;
					} else {
						gint _tmp50_;
						BoxesFedoraInstallerKbdLayout _tmp51_;
						const gchar* _tmp52_;
						_tmp50_ = i;
						_tmp51_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp50_];
						_tmp52_ = _tmp51_.xkb_variant;
						if (_tmp52_ == NULL) {
							gint _tmp53_;
							BoxesFedoraInstallerKbdLayout _tmp54_;
							const gchar* _tmp55_;
							gchar* _tmp56_;
							_tmp53_ = i;
							_tmp54_ = BOXES_FEDORA_INSTALLER_kbd_layouts[_tmp53_];
							_tmp55_ = _tmp54_.console_layout;
							_tmp56_ = g_strdup (_tmp55_);
							_g_free0 (console_layout);
							console_layout = _tmp56_;
						}
					}
				}
			}
		}
	}
	_tmp57_ = console_layout;
	if (_tmp57_ == NULL) {
		const gchar* _tmp58_;
		gchar* _tmp59_;
		_tmp58_ = layout_str;
		g_debug ("fedora-installer.vala:143: Couldn't find a console layout for X layout" \
" '%s', falling back to 'us'..", _tmp58_);
		_tmp59_ = g_strdup ("us");
		_g_free0 (console_layout);
		console_layout = _tmp59_;
	}
	_tmp60_ = console_layout;
	g_debug ("fedora-installer.vala:146: Using '%s' keyboard layout.", _tmp60_);
	result = console_layout;
	_g_free0 (xkb_variant);
	_g_free0 (xkb_layout);
	tokens = (_vala_array_free (tokens, tokens_length1, (GDestroyNotify) g_free), NULL);
	schemas = (_vala_array_free (schemas, schemas_length1, (GDestroyNotify) g_free), NULL);
	_g_free0 (layout_str);
	_g_free0 (method);
	return result;
}


BoxesFedoraInstaller* boxes_fedora_installer_construct (GType object_type) {
	BoxesFedoraInstaller * self = NULL;
	self = (BoxesFedoraInstaller*) boxes_unattended_installer_construct (object_type);
	return self;
}


BoxesFedoraInstaller* boxes_fedora_installer_new (void) {
	return boxes_fedora_installer_construct (BOXES_TYPE_FEDORA_INSTALLER);
}


static void boxes_fedora_installer_kbd_layout_copy (const BoxesFedoraInstallerKbdLayout* self, BoxesFedoraInstallerKbdLayout* dest) {
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	gchar* _tmp3_;
	const gchar* _tmp4_;
	gchar* _tmp5_;
	_tmp0_ = (*self).xkb_layout;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).xkb_layout);
	(*dest).xkb_layout = _tmp1_;
	_tmp2_ = (*self).xkb_variant;
	_tmp3_ = g_strdup (_tmp2_);
	_g_free0 ((*dest).xkb_variant);
	(*dest).xkb_variant = _tmp3_;
	_tmp4_ = (*self).console_layout;
	_tmp5_ = g_strdup (_tmp4_);
	_g_free0 ((*dest).console_layout);
	(*dest).console_layout = _tmp5_;
}


static void boxes_fedora_installer_kbd_layout_destroy (BoxesFedoraInstallerKbdLayout* self) {
	_g_free0 ((*self).xkb_layout);
	_g_free0 ((*self).xkb_variant);
	_g_free0 ((*self).console_layout);
}


static BoxesFedoraInstallerKbdLayout* boxes_fedora_installer_kbd_layout_dup (const BoxesFedoraInstallerKbdLayout* self) {
	BoxesFedoraInstallerKbdLayout* dup;
	dup = g_new0 (BoxesFedoraInstallerKbdLayout, 1);
	boxes_fedora_installer_kbd_layout_copy (self, dup);
	return dup;
}


static void boxes_fedora_installer_kbd_layout_free (BoxesFedoraInstallerKbdLayout* self) {
	boxes_fedora_installer_kbd_layout_destroy (self);
	g_free (self);
}


static GType boxes_fedora_installer_kbd_layout_get_type (void) {
	static volatile gsize boxes_fedora_installer_kbd_layout_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_fedora_installer_kbd_layout_type_id__volatile)) {
		GType boxes_fedora_installer_kbd_layout_type_id;
		boxes_fedora_installer_kbd_layout_type_id = g_boxed_type_register_static ("BoxesFedoraInstallerKbdLayout", (GBoxedCopyFunc) boxes_fedora_installer_kbd_layout_dup, (GBoxedFreeFunc) boxes_fedora_installer_kbd_layout_free);
		g_once_init_leave (&boxes_fedora_installer_kbd_layout_type_id__volatile, boxes_fedora_installer_kbd_layout_type_id);
	}
	return boxes_fedora_installer_kbd_layout_type_id__volatile;
}


static void boxes_fedora_installer_class_init (BoxesFedoraInstallerClass * klass) {
	GError * _inner_error_ = NULL;
	boxes_fedora_installer_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BoxesFedoraInstallerPrivate));
	BOXES_INSTALLER_MEDIA_CLASS (klass)->set_direct_boot_params = boxes_fedora_installer_real_set_direct_boot_params;
	BOXES_INSTALLER_MEDIA_CLASS (klass)->prepare_for_installation = boxes_fedora_installer_real_prepare_for_installation;
	BOXES_INSTALLER_MEDIA_CLASS (klass)->prepare_for_installation_finish = boxes_fedora_installer_real_prepare_for_installation_finish;
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->clean_up = boxes_fedora_installer_real_clean_up;
	BOXES_UNATTENDED_INSTALLER_CLASS (klass)->fill_unattended_data = boxes_fedora_installer_real_fill_unattended_data;
	G_OBJECT_CLASS (klass)->finalize = boxes_fedora_installer_finalize;
	{
		GRegex* _tmp0_;
		GRegex* _tmp1_;
		_tmp0_ = g_regex_new ("BOXES_FEDORA_KBD", 0, 0, &_inner_error_);
		_tmp1_ = _tmp0_;
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch9_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
		}
		_g_regex_unref0 (boxes_fedora_installer_kbd_regex);
		boxes_fedora_installer_kbd_regex = _tmp1_;
	}
	goto __finally9;
	__catch9_g_regex_error:
	{
		GError* _error_ = NULL;
		_error_ = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (_error_);
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
	}
}


static void boxes_fedora_installer_instance_init (BoxesFedoraInstaller * self) {
	self->priv = BOXES_FEDORA_INSTALLER_GET_PRIVATE (self);
}


static void boxes_fedora_installer_finalize (GObject* obj) {
	BoxesFedoraInstaller * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_FEDORA_INSTALLER, BoxesFedoraInstaller);
	_g_object_unref0 (self->priv->kernel_file);
	_g_object_unref0 (self->priv->initrd_file);
	_g_free0 (self->priv->kbd);
	G_OBJECT_CLASS (boxes_fedora_installer_parent_class)->finalize (obj);
}


GType boxes_fedora_installer_get_type (void) {
	static volatile gsize boxes_fedora_installer_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_fedora_installer_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesFedoraInstallerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_fedora_installer_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesFedoraInstaller), 0, (GInstanceInitFunc) boxes_fedora_installer_instance_init, NULL };
		GType boxes_fedora_installer_type_id;
		boxes_fedora_installer_type_id = g_type_register_static (BOXES_TYPE_UNATTENDED_INSTALLER, "BoxesFedoraInstaller", &g_define_type_info, 0);
		g_once_init_leave (&boxes_fedora_installer_type_id__volatile, boxes_fedora_installer_type_id);
	}
	return boxes_fedora_installer_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



