/* os-database.c generated by valac 0.17.4.26-61532, the Vala compiler
 * generated from os-database.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <osinfo/osinfo.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_OS_DATABASE (boxes_os_database_get_type ())
#define BOXES_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabase))
#define BOXES_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))
#define BOXES_IS_OS_DATABASE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_OS_DATABASE))
#define BOXES_IS_OS_DATABASE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_OS_DATABASE))
#define BOXES_OS_DATABASE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_OS_DATABASE, BoxesOSDatabaseClass))

typedef struct _BoxesOSDatabase BoxesOSDatabase;
typedef struct _BoxesOSDatabaseClass BoxesOSDatabaseClass;
typedef struct _BoxesOSDatabasePrivate BoxesOSDatabasePrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _boxes_os_database_unref0(var) ((var == NULL) ? NULL : (var = (boxes_os_database_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _BoxesOsDatabaseGuessOsFromInstallMediaData BoxesOsDatabaseGuessOsFromInstallMediaData;
typedef struct _BoxesParamSpecOSDatabase BoxesParamSpecOSDatabase;

typedef enum  {
	BOXES_OS_DATABASE_ERROR_NON_BOOTABLE,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID,
	BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID
} BoxesOSDatabaseError;
#define BOXES_OS_DATABASE_ERROR boxes_os_database_error_quark ()
struct _BoxesOSDatabase {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesOSDatabasePrivate * priv;
};

struct _BoxesOSDatabaseClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesOSDatabase *self);
};

struct _BoxesOSDatabasePrivate {
	OsinfoDb* db;
};

struct _BoxesOsDatabaseGuessOsFromInstallMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BoxesOSDatabase* self;
	gchar* media_path;
	OsinfoMedia* os_media;
	GCancellable* cancellable;
	OsinfoOs* result;
	const gchar* _tmp0_;
	GCancellable* _tmp1_;
	OsinfoMedia* _tmp2_;
	OsinfoMedia* media;
	OsinfoDb* _tmp3_;
	OsinfoMedia* _tmp4_;
	OsinfoOs* _tmp5_;
	OsinfoMedia* _tmp6_;
	OsinfoOs* _tmp7_;
	GError * _inner_error_;
};

struct _BoxesParamSpecOSDatabase {
	GParamSpec parent_instance;
};


static gpointer boxes_os_database_parent_class = NULL;

GQuark boxes_os_database_error_quark (void);
gpointer boxes_os_database_ref (gpointer instance);
void boxes_os_database_unref (gpointer instance);
GParamSpec* boxes_param_spec_os_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void boxes_value_set_os_database (GValue* value, gpointer v_object);
void boxes_value_take_os_database (GValue* value, gpointer v_object);
gpointer boxes_value_get_os_database (const GValue* value);
GType boxes_os_database_get_type (void) G_GNUC_CONST;
#define BOXES_OS_DATABASE_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_OS_DATABASE, BoxesOSDatabasePrivate))
enum  {
	BOXES_OS_DATABASE_DUMMY_PROPERTY
};
#define BOXES_OS_DATABASE_DEFAULT_VCPUS 1
#define BOXES_OS_DATABASE_DEFAULT_RAM (500 * ((gint64) OSINFO_MEBIBYTES))
#define BOXES_OS_DATABASE_DEFAULT_STORAGE (20 * ((gint64) OSINFO_GIBIBYTES))
static OsinfoResources* boxes_os_database_get_default_resources (void);
BoxesOSDatabase* boxes_os_database_new (GError** error);
BoxesOSDatabase* boxes_os_database_construct (GType object_type, GError** error);
static void boxes_os_database_guess_os_from_install_media_data_free (gpointer _data);
void boxes_os_database_guess_os_from_install_media (BoxesOSDatabase* self, const gchar* media_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_);
OsinfoOs* boxes_os_database_guess_os_from_install_media_finish (BoxesOSDatabase* self, GAsyncResult* _res_, OsinfoMedia** os_media, GError** error);
static gboolean boxes_os_database_guess_os_from_install_media_co (BoxesOsDatabaseGuessOsFromInstallMediaData* _data_);
static void boxes_os_database_guess_os_from_install_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
OsinfoOs* boxes_os_database_get_os_by_id (BoxesOSDatabase* self, const gchar* id, GError** error);
OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self, OsinfoOs* os, const gchar* id, GError** error);
OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self, OsinfoOs* os, const gchar* architecture);
static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value);
static gchar** _vala_array_dup4 (gchar** self, int length);
static OsinfoResources* boxes_os_database_get_prefered_resources (BoxesOSDatabase* self, OsinfoResourcesList* list, gchar** prefs, int prefs_length1);
static OsinfoResources* boxes_os_database_get_resources_from_os_resources (BoxesOSDatabase* self, OsinfoResources* minimum, OsinfoResources* recommended);
static void boxes_os_database_finalize (BoxesOSDatabase* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);


GQuark boxes_os_database_error_quark (void) {
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	return g_quark_from_static_string ("boxes_os_database_error-quark");
#line 121 "os-database.c"
}


static OsinfoResources* boxes_os_database_get_default_resources (void) {
	OsinfoResources* result = NULL;
	OsinfoResources* _tmp0_;
	OsinfoResources* resources;
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = osinfo_resources_new ("whatever", "x86_64");
#line 22 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	resources = _tmp0_;
#line 24 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_resources_set_n_cpus (resources, BOXES_OS_DATABASE_DEFAULT_VCPUS);
#line 25 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_resources_set_ram (resources, BOXES_OS_DATABASE_DEFAULT_RAM);
#line 26 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_resources_set_storage (resources, BOXES_OS_DATABASE_DEFAULT_STORAGE);
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = resources;
#line 28 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 143 "os-database.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return self ? g_object_ref (self) : NULL;
#line 150 "os-database.c"
}


BoxesOSDatabase* boxes_os_database_construct (GType object_type, GError** error) {
	BoxesOSDatabase* self = NULL;
	OsinfoLoader* _tmp0_;
	OsinfoLoader* loader;
	OsinfoDb* _tmp1_ = NULL;
	OsinfoDb* _tmp2_;
	GError * _inner_error_ = NULL;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self = (BoxesOSDatabase*) g_type_create_instance (object_type);
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = osinfo_loader_new ();
#line 32 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	loader = _tmp0_;
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_loader_process_default_path (loader, &_inner_error_);
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_inner_error_ != NULL) {
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_propagate_error (error, _inner_error_);
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (loader);
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_boxes_os_database_unref0 (self);
#line 33 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return NULL;
#line 179 "os-database.c"
	}
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp1_ = osinfo_loader_get_db (loader);
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = _g_object_ref0 (_tmp1_);
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (self->priv->db);
#line 34 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self->priv->db = _tmp2_;
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (loader);
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return self;
#line 193 "os-database.c"
}


BoxesOSDatabase* boxes_os_database_new (GError** error) {
#line 31 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return boxes_os_database_construct (BOXES_TYPE_OS_DATABASE, error);
#line 200 "os-database.c"
}


static void boxes_os_database_guess_os_from_install_media_data_free (gpointer _data) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	_data_ = _data;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_free0 (_data_->media_path);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->cancellable);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->result);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_boxes_os_database_unref0 (_data_->self);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_slice_free (BoxesOsDatabaseGuessOsFromInstallMediaData, _data_);
#line 217 "os-database.c"
}


static gpointer _boxes_os_database_ref0 (gpointer self) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return self ? boxes_os_database_ref (self) : NULL;
#line 224 "os-database.c"
}


void boxes_os_database_guess_os_from_install_media (BoxesOSDatabase* self, const gchar* media_path, GCancellable* cancellable, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
	BoxesOSDatabase* _tmp0_;
	const gchar* _tmp1_;
	gchar* _tmp2_;
	GCancellable* _tmp3_;
	GCancellable* _tmp4_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_ = g_slice_new0 (BoxesOsDatabaseGuessOsFromInstallMediaData);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_async_result = g_simple_async_result_new (g_object_newv (G_TYPE_OBJECT, 0, NULL), _callback_, _user_data_, boxes_os_database_guess_os_from_install_media);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, boxes_os_database_guess_os_from_install_media_data_free);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = _boxes_os_database_ref0 (self);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->self = _tmp0_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp1_ = media_path;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = g_strdup (_tmp1_);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->media_path = _tmp2_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = cancellable;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = _g_object_ref0 (_tmp3_);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->cancellable = _tmp4_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	boxes_os_database_guess_os_from_install_media_co (_data_);
#line 259 "os-database.c"
}


OsinfoOs* boxes_os_database_guess_os_from_install_media_finish (BoxesOSDatabase* self, GAsyncResult* _res_, OsinfoMedia** os_media, GError** error) {
	OsinfoOs* result;
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (g_simple_async_result_propagate_error (G_SIMPLE_ASYNC_RESULT (_res_), error)) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return NULL;
#line 270 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (os_media) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*os_media = _data_->os_media;
#line 278 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (_data_->os_media);
#line 282 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->os_media = NULL;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = _data_->result;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->result = NULL;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 292 "os-database.c"
}


static void boxes_os_database_guess_os_from_install_media_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BoxesOsDatabaseGuessOsFromInstallMediaData* _data_;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_ = _user_data_;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_source_object_ = source_object;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_res_ = _res_;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	boxes_os_database_guess_os_from_install_media_co (_data_);
#line 306 "os-database.c"
}


static gboolean boxes_os_database_guess_os_from_install_media_co (BoxesOsDatabaseGuessOsFromInstallMediaData* _data_) {
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	switch (_data_->_state_) {
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		case 0:
#line 315 "os-database.c"
		goto _state_0;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		case 1:
#line 319 "os-database.c"
		goto _state_1;
		default:
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_assert_not_reached ();
#line 324 "os-database.c"
	}
	_state_0:
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp0_ = _data_->media_path;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp1_ = _data_->cancellable;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_state_ = 1;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_media_create_from_location_async (_data_->_tmp0_, G_PRIORITY_DEFAULT, _data_->_tmp1_, boxes_os_database_guess_os_from_install_media_ready, _data_);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return FALSE;
#line 337 "os-database.c"
	_state_1:
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp2_ = NULL;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp2_ = osinfo_media_create_from_location_finish (_data_->_res_, &_data_->_inner_error_);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->media = _data_->_tmp2_;
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_data_->_inner_error_ != NULL) {
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_set_from_error (_data_->_async_result, _data_->_inner_error_);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_error_free (_data_->_inner_error_);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_data_->_state_ == 0) {
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 355 "os-database.c"
		} else {
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_simple_async_result_complete (_data_->_async_result);
#line 359 "os-database.c"
		}
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_object_unref (_data_->_async_result);
#line 40 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return FALSE;
#line 365 "os-database.c"
	}
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp3_ = _data_->self->priv->db;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp4_ = NULL;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp5_ = NULL;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp5_ = osinfo_db_guess_os_from_media (_data_->_tmp3_, _data_->media, &_data_->_tmp4_);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->os_media);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp4_);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->os_media = _data_->_tmp6_;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->_tmp7_ = _g_object_ref0 (_data_->_tmp5_);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_data_->result = _data_->_tmp7_;
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->media);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_data_->_state_ == 0) {
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 391 "os-database.c"
	} else {
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 395 "os-database.c"
	}
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_object_unref (_data_->_async_result);
#line 42 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return FALSE;
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (_data_->media);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_data_->_state_ == 0) {
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_complete_in_idle (_data_->_async_result);
#line 407 "os-database.c"
	} else {
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_simple_async_result_complete (_data_->_async_result);
#line 411 "os-database.c"
	}
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_object_unref (_data_->_async_result);
#line 37 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return FALSE;
#line 417 "os-database.c"
}


OsinfoOs* boxes_os_database_get_os_by_id (BoxesOSDatabase* self, const gchar* id, GError** error) {
	OsinfoOs* result = NULL;
	OsinfoDb* _tmp0_;
	const gchar* _tmp1_;
	OsinfoOs* _tmp2_ = NULL;
	OsinfoOs* _tmp3_;
	OsinfoOs* os;
	OsinfoOs* _tmp4_;
	GError * _inner_error_ = NULL;
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 45 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = self->priv->db;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp1_ = id;
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = osinfo_db_get_os (_tmp0_, _tmp1_);
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 46 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	os = _tmp3_;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = os;
#line 47 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp4_ == NULL) {
#line 448 "os-database.c"
		const gchar* _tmp5_;
		GError* _tmp6_;
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp5_ = id;
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp6_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_OS_ID, "Unknown OS ID '%s'", _tmp5_);
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_inner_error_ = _tmp6_;
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_inner_error_->domain == BOXES_OS_DATABASE_ERROR) {
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_propagate_error (error, _inner_error_);
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (os);
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 465 "os-database.c"
		} else {
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (os);
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_clear_error (&_inner_error_);
#line 48 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 475 "os-database.c"
		}
	}
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = os;
#line 50 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 482 "os-database.c"
}


OsinfoMedia* boxes_os_database_get_media_by_id (BoxesOSDatabase* self, OsinfoOs* os, const gchar* id, GError** error) {
	OsinfoMedia* result = NULL;
	OsinfoOs* _tmp0_;
	OsinfoMediaList* _tmp1_ = NULL;
	OsinfoMediaList* medias;
	OsinfoMediaList* _tmp2_;
	const gchar* _tmp3_;
	OsinfoEntity* _tmp4_ = NULL;
	OsinfoMedia* _tmp5_;
	OsinfoMedia* media;
	OsinfoMedia* _tmp6_;
	GError * _inner_error_ = NULL;
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (os != NULL, NULL);
#line 53 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = os;
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp1_ = osinfo_os_get_media_list (_tmp0_);
#line 54 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	medias = _tmp1_;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = medias;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = id;
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = osinfo_list_find_by_id ((OsinfoList*) _tmp2_, _tmp3_);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp5_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp4_, osinfo_media_get_type ()) ? ((OsinfoMedia*) _tmp4_) : NULL);
#line 56 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	media = _tmp5_;
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = media;
#line 57 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp6_ == NULL) {
#line 524 "os-database.c"
		const gchar* _tmp7_;
		GError* _tmp8_;
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp7_ = id;
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp8_ = g_error_new (BOXES_OS_DATABASE_ERROR, BOXES_OS_DATABASE_ERROR_UNKNOWN_MEDIA_ID, "Unknown media ID '%s'", _tmp7_);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_inner_error_ = _tmp8_;
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_inner_error_->domain == BOXES_OS_DATABASE_ERROR) {
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_propagate_error (error, _inner_error_);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (media);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (medias);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 543 "os-database.c"
		} else {
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (media);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_g_object_unref0 (medias);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			g_clear_error (&_inner_error_);
#line 58 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return NULL;
#line 555 "os-database.c"
		}
	}
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = media;
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (medias);
#line 60 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 564 "os-database.c"
}


static void _vala_array_add6 (gchar*** array, int* length, int* size, gchar* value) {
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if ((*length) == (*size)) {
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 575 "os-database.c"
	}
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	(*array)[(*length)++] = value;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	(*array)[*length] = NULL;
#line 581 "os-database.c"
}


static void _vala_array_add7 (gchar*** array, int* length, int* size, gchar* value) {
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if ((*length) == (*size)) {
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 592 "os-database.c"
	}
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	(*array)[(*length)++] = value;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	(*array)[*length] = NULL;
#line 598 "os-database.c"
}


static gchar** _vala_array_dup4 (gchar** self, int length) {
	gchar** result;
	int i;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = g_new0 (gchar*, length + 1);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	for (i = 0; i < length; i++) {
#line 609 "os-database.c"
		gchar* _tmp0_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp0_ = g_strdup (self[i]);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result[i] = _tmp0_;
#line 615 "os-database.c"
	}
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 619 "os-database.c"
}


OsinfoResources* boxes_os_database_get_resources_for_os (BoxesOSDatabase* self, OsinfoOs* os, const gchar* architecture) {
	OsinfoResources* result = NULL;
	OsinfoOs* _tmp0_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar** _tmp6_ = NULL;
	gchar** architectures;
	gint architectures_length1;
	gint _architectures_size_;
	gchar** prefs = NULL;
	gint prefs_length1 = 0;
	gint _prefs_size_ = 0;
	const gchar* _tmp7_;
	OsinfoOs* _tmp21_;
	OsinfoResourcesList* _tmp22_ = NULL;
	OsinfoResourcesList* list;
	OsinfoResourcesList* _tmp23_;
	gchar** _tmp24_;
	gint _tmp24__length1;
	OsinfoResources* _tmp25_ = NULL;
	OsinfoResources* recommended;
	OsinfoOs* _tmp26_;
	OsinfoResourcesList* _tmp27_ = NULL;
	OsinfoResourcesList* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	OsinfoResources* _tmp30_ = NULL;
	OsinfoResources* minimum;
	OsinfoResources* _tmp31_;
	OsinfoResources* _tmp32_;
	OsinfoResources* _tmp33_ = NULL;
#line 63 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = os;
#line 64 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp0_ == NULL) {
#line 662 "os-database.c"
		OsinfoResources* _tmp1_ = NULL;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp1_ = boxes_os_database_get_default_resources ();
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result = _tmp1_;
#line 65 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return result;
#line 670 "os-database.c"
	}
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = g_strdup ("x86_64");
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = g_strdup ("i686");
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = g_strdup ("i386");
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp5_ = g_strdup (OSINFO_ARCHITECTURE_ALL);
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = g_new0 (gchar*, 4 + 1);
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_[0] = _tmp2_;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_[1] = _tmp3_;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_[2] = _tmp4_;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_[3] = _tmp5_;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	architectures = _tmp6_;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	architectures_length1 = 4;
#line 68 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_architectures_size_ = architectures_length1;
#line 70 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp7_ = architecture;
#line 70 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp7_ != NULL) {
#line 700 "os-database.c"
		gchar** _tmp8_ = NULL;
		gchar** _tmp9_;
		gint _tmp9__length1;
		const gchar* _tmp10_;
		gchar* _tmp11_;
		gchar** _tmp12_;
		gint _tmp12__length1;
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp8_ = g_new0 (gchar*, 0 + 1);
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs = _tmp8_;
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs_length1 = 0;
#line 71 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_prefs_size_ = prefs_length1;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp9_ = prefs;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp9__length1 = prefs_length1;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp10_ = architecture;
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp11_ = g_strdup (_tmp10_);
#line 72 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_vala_array_add6 (&prefs, &prefs_length1, &_prefs_size_, _tmp11_);
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12_ = architectures;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12__length1 = architectures_length1;
#line 732 "os-database.c"
		{
			gchar** arch_collection = NULL;
			gint arch_collection_length1 = 0;
			gint _arch_collection_size_ = 0;
			gint arch_it = 0;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			arch_collection = _tmp12_;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			arch_collection_length1 = _tmp12__length1;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			for (arch_it = 0; arch_it < _tmp12__length1; arch_it = arch_it + 1) {
#line 744 "os-database.c"
				gchar* _tmp13_;
				gchar* arch = NULL;
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
				_tmp13_ = g_strdup (arch_collection[arch_it]);
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
				arch = _tmp13_;
#line 751 "os-database.c"
				{
					const gchar* _tmp14_;
					const gchar* _tmp15_;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
					_tmp14_ = arch;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
					_tmp15_ = architecture;
#line 75 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
					if (g_strcmp0 (_tmp14_, _tmp15_) != 0) {
#line 761 "os-database.c"
						gchar** _tmp16_;
						gint _tmp16__length1;
						const gchar* _tmp17_;
						gchar* _tmp18_;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_tmp16_ = prefs;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_tmp16__length1 = prefs_length1;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_tmp17_ = arch;
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_tmp18_ = g_strdup (_tmp17_);
#line 76 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
						_vala_array_add7 (&prefs, &prefs_length1, &_prefs_size_, _tmp18_);
#line 776 "os-database.c"
					}
#line 74 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
					_g_free0 (arch);
#line 780 "os-database.c"
				}
			}
		}
	} else {
		gchar** _tmp19_;
		gint _tmp19__length1;
		gchar** _tmp20_;
		gint _tmp20__length1;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp19_ = architectures;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp19__length1 = architectures_length1;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp20_ = (_tmp19_ != NULL) ? _vala_array_dup4 (_tmp19_, _tmp19__length1) : ((gpointer) _tmp19_);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp20__length1 = _tmp19__length1;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs = _tmp20_;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		prefs_length1 = _tmp20__length1;
#line 78 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_prefs_size_ = prefs_length1;
#line 805 "os-database.c"
	}
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp21_ = os;
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp22_ = osinfo_os_get_recommended_resources (_tmp21_);
#line 81 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	list = _tmp22_;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp23_ = list;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp24_ = prefs;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp24__length1 = prefs_length1;
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp25_ = boxes_os_database_get_prefered_resources (self, _tmp23_, _tmp24_, _tmp24__length1);
#line 82 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	recommended = _tmp25_;
#line 84 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp26_ = os;
#line 84 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp27_ = osinfo_os_get_minimum_resources (_tmp26_);
#line 84 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (list);
#line 84 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	list = _tmp27_;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp28_ = list;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp29_ = prefs;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp29__length1 = prefs_length1;
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp30_ = boxes_os_database_get_prefered_resources (self, _tmp28_, _tmp29_, _tmp29__length1);
#line 85 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	minimum = _tmp30_;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp31_ = minimum;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp32_ = recommended;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp33_ = boxes_os_database_get_resources_from_os_resources (self, _tmp31_, _tmp32_);
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = _tmp33_;
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (minimum);
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (recommended);
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (list);
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	prefs = (_vala_array_free (prefs, prefs_length1, (GDestroyNotify) g_free), NULL);
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	architectures = (_vala_array_free (architectures, architectures_length1, (GDestroyNotify) g_free), NULL);
#line 87 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 861 "os-database.c"
}


static OsinfoResources* boxes_os_database_get_resources_from_os_resources (BoxesOSDatabase* self, OsinfoResources* minimum, OsinfoResources* recommended) {
	OsinfoResources* result = NULL;
	OsinfoResources* _tmp0_ = NULL;
	OsinfoResources* resources;
	gboolean _tmp1_ = FALSE;
	OsinfoResources* _tmp2_;
	gboolean _tmp6_;
	gboolean _tmp25_ = FALSE;
	OsinfoResources* _tmp26_;
	gboolean _tmp30_;
	gboolean _tmp49_ = FALSE;
	OsinfoResources* _tmp50_;
	gboolean _tmp54_;
#line 90 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = boxes_os_database_get_default_resources ();
#line 91 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	resources = _tmp0_;
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = recommended;
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp2_ != NULL) {
#line 888 "os-database.c"
		OsinfoResources* _tmp3_;
		gint _tmp4_;
		gint _tmp5_;
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp3_ = recommended;
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp4_ = osinfo_resources_get_n_cpus (_tmp3_);
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp5_ = _tmp4_;
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp1_ = _tmp5_ > 0;
#line 900 "os-database.c"
	} else {
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp1_ = FALSE;
#line 904 "os-database.c"
	}
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = _tmp1_;
#line 94 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp6_) {
#line 910 "os-database.c"
		OsinfoResources* _tmp7_;
		OsinfoResources* _tmp8_;
		gint _tmp9_;
		gint _tmp10_;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp7_ = resources;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp8_ = recommended;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp9_ = osinfo_resources_get_n_cpus (_tmp8_);
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp10_ = _tmp9_;
#line 95 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		osinfo_resources_set_n_cpus (_tmp7_, _tmp10_);
#line 925 "os-database.c"
	} else {
		gboolean _tmp11_ = FALSE;
		OsinfoResources* _tmp12_;
		gboolean _tmp16_;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12_ = minimum;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp12_ != NULL) {
#line 934 "os-database.c"
			OsinfoResources* _tmp13_;
			gint _tmp14_;
			gint _tmp15_;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp13_ = minimum;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp14_ = osinfo_resources_get_n_cpus (_tmp13_);
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp15_ = _tmp14_;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp11_ = _tmp15_ > 0;
#line 946 "os-database.c"
		} else {
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp11_ = FALSE;
#line 950 "os-database.c"
		}
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp16_ = _tmp11_;
#line 96 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp16_) {
#line 956 "os-database.c"
			OsinfoResources* _tmp17_;
			OsinfoResources* _tmp18_;
			gint _tmp19_;
			gint _tmp20_;
			OsinfoResources* _tmp21_;
			gint _tmp22_;
			gint _tmp23_;
			gint _tmp24_ = 0;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp17_ = resources;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp18_ = minimum;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp19_ = osinfo_resources_get_n_cpus (_tmp18_);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp20_ = _tmp19_;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp21_ = resources;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp22_ = osinfo_resources_get_n_cpus (_tmp21_);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp23_ = _tmp22_;
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp24_ = MAX (_tmp20_, _tmp23_);
#line 97 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			osinfo_resources_set_n_cpus (_tmp17_, _tmp24_);
#line 983 "os-database.c"
		}
	}
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp26_ = recommended;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp26_ != NULL) {
#line 990 "os-database.c"
		OsinfoResources* _tmp27_;
		gint64 _tmp28_;
		gint64 _tmp29_;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp27_ = recommended;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp28_ = osinfo_resources_get_ram (_tmp27_);
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp29_ = _tmp28_;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp25_ = _tmp29_ > ((gint64) 0);
#line 1002 "os-database.c"
	} else {
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp25_ = FALSE;
#line 1006 "os-database.c"
	}
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp30_ = _tmp25_;
#line 100 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp30_) {
#line 1012 "os-database.c"
		OsinfoResources* _tmp31_;
		OsinfoResources* _tmp32_;
		gint64 _tmp33_;
		gint64 _tmp34_;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp31_ = resources;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp32_ = recommended;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp33_ = osinfo_resources_get_ram (_tmp32_);
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp34_ = _tmp33_;
#line 101 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		osinfo_resources_set_ram (_tmp31_, _tmp34_);
#line 1027 "os-database.c"
	} else {
		gboolean _tmp35_ = FALSE;
		OsinfoResources* _tmp36_;
		gboolean _tmp40_;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp36_ = minimum;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp36_ != NULL) {
#line 1036 "os-database.c"
			OsinfoResources* _tmp37_;
			gint64 _tmp38_;
			gint64 _tmp39_;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp37_ = minimum;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp38_ = osinfo_resources_get_ram (_tmp37_);
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp39_ = _tmp38_;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp35_ = _tmp39_ > ((gint64) 0);
#line 1048 "os-database.c"
		} else {
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp35_ = FALSE;
#line 1052 "os-database.c"
		}
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp40_ = _tmp35_;
#line 102 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp40_) {
#line 1058 "os-database.c"
			OsinfoResources* _tmp41_;
			OsinfoResources* _tmp42_;
			gint64 _tmp43_;
			gint64 _tmp44_;
			OsinfoResources* _tmp45_;
			gint64 _tmp46_;
			gint64 _tmp47_;
			gint64 _tmp48_ = 0LL;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp41_ = resources;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp42_ = minimum;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp43_ = osinfo_resources_get_ram (_tmp42_);
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp44_ = _tmp43_;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp45_ = resources;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp46_ = osinfo_resources_get_ram (_tmp45_);
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp47_ = _tmp46_;
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp48_ = MAX (_tmp44_, _tmp47_);
#line 103 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			osinfo_resources_set_ram (_tmp41_, _tmp48_);
#line 1085 "os-database.c"
		}
	}
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp50_ = recommended;
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp50_ != NULL) {
#line 1092 "os-database.c"
		OsinfoResources* _tmp51_;
		gint64 _tmp52_;
		gint64 _tmp53_;
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp51_ = recommended;
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp52_ = osinfo_resources_get_storage (_tmp51_);
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp53_ = _tmp52_;
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp49_ = _tmp53_ > ((gint64) 0);
#line 1104 "os-database.c"
	} else {
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp49_ = FALSE;
#line 1108 "os-database.c"
	}
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp54_ = _tmp49_;
#line 106 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp54_) {
#line 1114 "os-database.c"
		OsinfoResources* _tmp55_;
		OsinfoResources* _tmp56_;
		gint64 _tmp57_;
		gint64 _tmp58_;
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp55_ = resources;
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp56_ = recommended;
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp57_ = osinfo_resources_get_storage (_tmp56_);
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp58_ = _tmp57_;
#line 107 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		osinfo_resources_set_storage (_tmp55_, _tmp58_);
#line 1129 "os-database.c"
	} else {
		gboolean _tmp59_ = FALSE;
		OsinfoResources* _tmp60_;
		gboolean _tmp64_;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp60_ = minimum;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp60_ != NULL) {
#line 1138 "os-database.c"
			OsinfoResources* _tmp61_;
			gint64 _tmp62_;
			gint64 _tmp63_;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp61_ = minimum;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp62_ = osinfo_resources_get_storage (_tmp61_);
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp63_ = _tmp62_;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp59_ = _tmp63_ > ((gint64) 0);
#line 1150 "os-database.c"
		} else {
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp59_ = FALSE;
#line 1154 "os-database.c"
		}
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp64_ = _tmp59_;
#line 108 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (_tmp64_) {
#line 1160 "os-database.c"
			OsinfoResources* _tmp65_;
			OsinfoResources* _tmp66_;
			gint64 _tmp67_;
			gint64 _tmp68_;
			OsinfoResources* _tmp69_;
			gint64 _tmp70_;
			gint64 _tmp71_;
			gint64 _tmp72_ = 0LL;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp65_ = resources;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp66_ = minimum;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp67_ = osinfo_resources_get_storage (_tmp66_);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp68_ = _tmp67_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp69_ = resources;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp70_ = osinfo_resources_get_storage (_tmp69_);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp71_ = _tmp70_;
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			_tmp72_ = MAX (_tmp68_ * 2, _tmp71_);
#line 109 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			osinfo_resources_set_storage (_tmp65_, _tmp72_);
#line 1187 "os-database.c"
		}
	}
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	result = resources;
#line 111 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return result;
#line 1194 "os-database.c"
}


static OsinfoResources* boxes_os_database_get_prefered_resources (BoxesOSDatabase* self, OsinfoResourcesList* list, gchar** prefs, int prefs_length1) {
	OsinfoResources* result = NULL;
	gchar** _tmp0_;
	gint _tmp0__length1;
	OsinfoFilter* _tmp1_;
	OsinfoFilter* filter;
	OsinfoFilter* _tmp2_;
	gchar** _tmp3_;
	gint _tmp3__length1;
	const gchar* _tmp4_;
	OsinfoResourcesList* _tmp5_;
	OsinfoFilter* _tmp6_;
	OsinfoResourcesList* _tmp7_ = NULL;
	OsinfoResourcesList* filtered;
	OsinfoResourcesList* _tmp8_;
	gint _tmp9_ = 0;
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (list != NULL, NULL);
#line 115 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0_ = prefs;
#line 115 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp0__length1 = prefs_length1;
#line 115 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp0__length1 <= 0) {
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result = NULL;
#line 116 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return result;
#line 1228 "os-database.c"
	}
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp1_ = osinfo_filter_new ();
#line 118 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	filter = _tmp1_;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp2_ = filter;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3_ = prefs;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp3__length1 = prefs_length1;
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp4_ = _tmp3_[0];
#line 119 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	osinfo_filter_add_constraint (_tmp2_, OSINFO_RESOURCES_PROP_ARCHITECTURE, _tmp4_);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp5_ = list;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp6_ = filter;
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp7_ = osinfo_resourceslist_new_filtered (_tmp5_, _tmp6_);
#line 120 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	filtered = _tmp7_;
#line 121 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp8_ = filtered;
#line 121 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_tmp9_ = osinfo_list_get_length ((OsinfoList*) _tmp8_);
#line 121 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (_tmp9_ <= 0) {
#line 1258 "os-database.c"
		OsinfoResourcesList* _tmp10_;
		gchar** _tmp11_;
		gint _tmp11__length1;
		gchar** _tmp12_;
		gint _tmp12__length1;
		OsinfoResources* _tmp13_ = NULL;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp10_ = list;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp11_ = prefs;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp11__length1 = prefs_length1;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12_ = prefs;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp12__length1 = prefs_length1;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp13_ = boxes_os_database_get_prefered_resources (self, _tmp10_, _tmp11_ + 1, _tmp12__length1 - 1);
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result = _tmp13_;
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (filtered);
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (filter);
#line 122 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return result;
#line 1285 "os-database.c"
	} else {
		OsinfoResourcesList* _tmp14_;
		OsinfoEntity* _tmp15_ = NULL;
		OsinfoResources* _tmp16_;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp14_ = filtered;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp15_ = osinfo_list_get_nth ((OsinfoList*) _tmp14_, 0);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_tmp16_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp15_, osinfo_resources_get_type ()) ? ((OsinfoResources*) _tmp15_) : NULL);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		result = _tmp16_;
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (filtered);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		_g_object_unref0 (filter);
#line 126 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return result;
#line 1304 "os-database.c"
	}
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (filtered);
#line 114 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (filter);
#line 1310 "os-database.c"
}


static void boxes_value_os_database_init (GValue* value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	value->data[0].v_pointer = NULL;
#line 1317 "os-database.c"
}


static void boxes_value_os_database_free_value (GValue* value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (value->data[0].v_pointer) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		boxes_os_database_unref (value->data[0].v_pointer);
#line 1326 "os-database.c"
	}
}


static void boxes_value_os_database_copy_value (const GValue* src_value, GValue* dest_value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (src_value->data[0].v_pointer) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		dest_value->data[0].v_pointer = boxes_os_database_ref (src_value->data[0].v_pointer);
#line 1336 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		dest_value->data[0].v_pointer = NULL;
#line 1340 "os-database.c"
	}
}


static gpointer boxes_value_os_database_peek_pointer (const GValue* value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return value->data[0].v_pointer;
#line 1348 "os-database.c"
}


static gchar* boxes_value_os_database_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (collect_values[0].v_pointer) {
#line 1355 "os-database.c"
		BoxesOSDatabase* object;
		object = collect_values[0].v_pointer;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		if (object->parent_instance.g_class == NULL) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1362 "os-database.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 1366 "os-database.c"
		}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = boxes_os_database_ref (object);
#line 1370 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = NULL;
#line 1374 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return NULL;
#line 1378 "os-database.c"
}


static gchar* boxes_value_os_database_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BoxesOSDatabase** object_p;
	object_p = collect_values[0].v_pointer;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (!object_p) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 1389 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (!value->data[0].v_pointer) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*object_p = NULL;
#line 1395 "os-database.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*object_p = value->data[0].v_pointer;
#line 1399 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		*object_p = boxes_os_database_ref (value->data[0].v_pointer);
#line 1403 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return NULL;
#line 1407 "os-database.c"
}


GParamSpec* boxes_param_spec_os_database (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BoxesParamSpecOSDatabase* spec;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_OS_DATABASE), NULL);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return G_PARAM_SPEC (spec);
#line 1421 "os-database.c"
}


gpointer boxes_value_get_os_database (const GValue* value) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE), NULL);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return value->data[0].v_pointer;
#line 1430 "os-database.c"
}


void boxes_value_set_os_database (GValue* value, gpointer v_object) {
	BoxesOSDatabase* old;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	old = value->data[0].v_pointer;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (v_object) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_OS_DATABASE));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = v_object;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		boxes_os_database_ref (value->data[0].v_pointer);
#line 1450 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = NULL;
#line 1454 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (old) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		boxes_os_database_unref (old);
#line 1460 "os-database.c"
	}
}


void boxes_value_take_os_database (GValue* value, gpointer v_object) {
	BoxesOSDatabase* old;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_OS_DATABASE));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	old = value->data[0].v_pointer;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (v_object) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_OS_DATABASE));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = v_object;
#line 1479 "os-database.c"
	} else {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		value->data[0].v_pointer = NULL;
#line 1483 "os-database.c"
	}
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (old) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		boxes_os_database_unref (old);
#line 1489 "os-database.c"
	}
}


static void boxes_os_database_class_init (BoxesOSDatabaseClass * klass) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	boxes_os_database_parent_class = g_type_class_peek_parent (klass);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	BOXES_OS_DATABASE_CLASS (klass)->finalize = boxes_os_database_finalize;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_type_class_add_private (klass, sizeof (BoxesOSDatabasePrivate));
#line 1501 "os-database.c"
}


static void boxes_os_database_instance_init (BoxesOSDatabase * self) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self->priv = BOXES_OS_DATABASE_GET_PRIVATE (self);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self->ref_count = 1;
#line 1510 "os-database.c"
}


static void boxes_os_database_finalize (BoxesOSDatabase* obj) {
	BoxesOSDatabase * self;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_OS_DATABASE, BoxesOSDatabase);
#line 19 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	_g_object_unref0 (self->priv->db);
#line 1520 "os-database.c"
}


GType boxes_os_database_get_type (void) {
	static volatile gsize boxes_os_database_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_os_database_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_os_database_init, boxes_value_os_database_free_value, boxes_value_os_database_copy_value, boxes_value_os_database_peek_pointer, "p", boxes_value_os_database_collect_value, "p", boxes_value_os_database_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesOSDatabaseClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_os_database_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesOSDatabase), 0, (GInstanceInitFunc) boxes_os_database_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_os_database_type_id;
		boxes_os_database_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesOSDatabase", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_os_database_type_id__volatile, boxes_os_database_type_id);
	}
	return boxes_os_database_type_id__volatile;
}


gpointer boxes_os_database_ref (gpointer instance) {
	BoxesOSDatabase* self;
	self = instance;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	g_atomic_int_inc (&self->ref_count);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	return instance;
#line 1545 "os-database.c"
}


void boxes_os_database_unref (gpointer instance) {
	BoxesOSDatabase* self;
	self = instance;
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		BOXES_OS_DATABASE_GET_CLASS (self)->finalize (self);
#line 11 "/extra-data/checkout/gnome/gnome-boxes/src/os-database.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 1558 "os-database.c"
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 1566 "os-database.c"
		int i;
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
				destroy_func (((gpointer*) array)[i]);
#line 1574 "os-database.c"
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 424 "/extra-data/checkout/gnome/gnome-boxes/src/libvirt-machine.vala"
	g_free (array);
#line 1586 "os-database.c"
}



