/* downloader.c generated by valac 0.39.5, the Vala compiler
 * generated from downloader.vala, do not modify */

/* This file is part of GNOME Boxes. License: LGPLv2+*/

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <libcommon.h>
#include <libsoup/soup.h>
#include <osinfo/osinfo.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk-pixbuf/gdk-pixbuf.h>
#include <gobject/gvaluecollector.h>


#define BOXES_TYPE_DOWNLOAD (boxes_download_get_type ())
#define BOXES_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DOWNLOAD, BoxesDownload))
#define BOXES_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DOWNLOAD, BoxesDownloadClass))
#define BOXES_IS_DOWNLOAD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DOWNLOAD))
#define BOXES_IS_DOWNLOAD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DOWNLOAD))
#define BOXES_DOWNLOAD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DOWNLOAD, BoxesDownloadClass))

typedef struct _BoxesDownload BoxesDownload;
typedef struct _BoxesDownloadClass BoxesDownloadClass;
typedef struct _BoxesDownloadPrivate BoxesDownloadPrivate;
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
typedef struct _BoxesParamSpecDownload BoxesParamSpecDownload;

#define BOXES_TYPE_DOWNLOADER (boxes_downloader_get_type ())
#define BOXES_DOWNLOADER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BOXES_TYPE_DOWNLOADER, BoxesDownloader))
#define BOXES_DOWNLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BOXES_TYPE_DOWNLOADER, BoxesDownloaderClass))
#define BOXES_IS_DOWNLOADER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BOXES_TYPE_DOWNLOADER))
#define BOXES_IS_DOWNLOADER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BOXES_TYPE_DOWNLOADER))
#define BOXES_DOWNLOADER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BOXES_TYPE_DOWNLOADER, BoxesDownloaderClass))

typedef struct _BoxesDownloader BoxesDownloader;
typedef struct _BoxesDownloaderClass BoxesDownloaderClass;
typedef struct _BoxesDownloaderPrivate BoxesDownloaderPrivate;
enum  {
	BOXES_DOWNLOADER_0_PROPERTY,
	BOXES_DOWNLOADER_NUM_PROPERTIES
};
static GParamSpec* boxes_downloader_properties[BOXES_DOWNLOADER_NUM_PROPERTIES];
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _boxes_download_unref0(var) ((var == NULL) ? NULL : (var = (boxes_download_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BoxesDownloaderDownloadData BoxesDownloaderDownloadData;
typedef struct _Block103Data Block103Data;
typedef struct _BoxesDownloaderDownloadFromHttpData BoxesDownloaderDownloadFromHttpData;
typedef struct _BoxesDownloaderFetchOsLogoData BoxesDownloaderFetchOsLogoData;
typedef struct _BoxesDownloaderFetchMediaData BoxesDownloaderFetchMediaData;
typedef struct _Block104Data Block104Data;
typedef struct _BoxesDownloaderAwaitDownloadData BoxesDownloaderAwaitDownloadData;
typedef struct _Block105Data Block105Data;
typedef struct _BoxesDownloaderDownloadFromFilesystemData BoxesDownloaderDownloadFromFilesystemData;
enum  {
	BOXES_DOWNLOADER_DOWNLOADED_SIGNAL,
	BOXES_DOWNLOADER_DOWNLOAD_FAILED_SIGNAL,
	BOXES_DOWNLOADER_NUM_SIGNALS
};
static guint boxes_downloader_signals[BOXES_DOWNLOADER_NUM_SIGNALS] = {0};

struct _BoxesDownload {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BoxesDownloadPrivate * priv;
	gchar* uri;
	GFile* remote_file;
	GFile* cached_file;
	BoxesActivityProgress* progress;
};

struct _BoxesDownloadClass {
	GTypeClass parent_class;
	void (*finalize) (BoxesDownload *self);
};

struct _BoxesParamSpecDownload {
	GParamSpec parent_instance;
};

struct _BoxesDownloader {
	GObject parent_instance;
	BoxesDownloaderPrivate * priv;
};

struct _BoxesDownloaderClass {
	GObjectClass parent_class;
};

struct _BoxesDownloaderPrivate {
	SoupSession* session;
	GHashTable* downloads;
};

struct _BoxesDownloaderDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloader* self;
	GFile* remote_file;
	gchar** cached_paths;
	gint cached_paths_length1;
	BoxesActivityProgress* progress;
	GCancellable* cancellable;
	GFile* result;
	gchar* uri;
	gchar* _tmp0_;
	BoxesDownload* download;
	GHashTable* _tmp1_;
	const gchar* _tmp2_;
	gconstpointer _tmp3_;
	BoxesDownload* _tmp4_;
	gchar* cached_path;
	const gchar* _tmp5_;
	gchar* _tmp6_;
	BoxesDownload* _tmp7_;
	GFile* _tmp8_;
	BoxesDownload* _tmp9_;
	const gchar* _tmp10_;
	GFile* _tmp11_;
	GFile* _tmp12_;
	GFile* cached_file;
	GFile* _tmp13_;
	GFile* _tmp14_;
	gchar* tmp_path;
	const gchar* _tmp15_;
	gchar* _tmp16_;
	GFile* tmp_file;
	const gchar* _tmp17_;
	GFile* _tmp18_;
	const gchar* _tmp19_;
	GFile* _tmp20_;
	BoxesDownload* _tmp21_;
	GHashTable* _tmp22_;
	const gchar* _tmp23_;
	gchar* _tmp24_;
	BoxesDownload* _tmp25_;
	BoxesDownload* _tmp26_;
	gchar* _tmp27_;
	gchar* _tmp28_;
	gchar** _tmp29_;
	gint _tmp29__length1;
	gboolean _tmp30_;
	BoxesDownload* _tmp31_;
	BoxesDownload* _tmp32_;
	GError* _error_;
	BoxesDownload* _tmp33_;
	GError* _tmp34_;
	GError* _tmp35_;
	GError* _tmp36_;
	GHashTable* _tmp37_;
	const gchar* _tmp38_;
	const gchar* _tmp39_;
	GFile* _tmp40_;
	GFile* _tmp41_;
	GFile* _tmp42_;
	BoxesDownload* _tmp43_;
	GFile* _tmp44_;
	GFile* _tmp45_;
	const gchar* _tmp46_;
	const gchar* _tmp47_;
	BoxesDownload* _tmp48_;
	GError * _inner_error_;
};

struct _Block103Data {
	int _ref_count_;
	BoxesDownloader* self;
	SoupMessage* msg;
	GError* err;
	gint64 total_num_bytes;
	GFileOutputStream* cached_file_stream;
	gint64 current_num_bytes;
	BoxesDownload* download;
	gpointer _async_data_;
};

struct _BoxesDownloaderDownloadFromHttpData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloader* self;
	BoxesDownload* download;
	GCancellable* cancellable;
	Block103Data* _data103_;
	const gchar* _tmp0_;
	SoupMessage* _tmp1_;
	SoupMessage* _tmp2_;
	SoupMessageBody* _tmp3_;
	SoupAddress* address;
	SoupMessage* _tmp4_;
	SoupAddress* _tmp5_;
	SoupAddress* _tmp6_;
	GNetworkAddress* connectable;
	SoupAddress* _tmp7_;
	const gchar* _tmp8_;
	const gchar* _tmp9_;
	SoupAddress* _tmp10_;
	gint _tmp11_;
	gint _tmp12_;
	GNetworkAddress* _tmp13_;
	GNetworkMonitor* network_monitor;
	GNetworkMonitor* _tmp14_;
	GNetworkMonitor* _tmp15_;
	gboolean _tmp16_;
	GNetworkMonitor* _tmp17_;
	GNetworkAddress* _tmp18_;
	SoupAddress* _tmp19_;
	const gchar* _tmp20_;
	const gchar* _tmp21_;
	SoupAddress* _tmp22_;
	gint _tmp23_;
	gint _tmp24_;
	GError* _tmp25_;
	gulong cancelled_id;
	SoupMessage* _tmp26_;
	GFile* _tmp27_;
	GFileOutputStream* _tmp28_;
	SoupMessage* _tmp29_;
	SoupSession* _tmp30_;
	SoupMessage* _tmp31_;
	SoupMessage* _tmp32_;
	gulong _tmp33_;
	gulong _tmp34_;
	GFileOutputStream* _tmp35_;
	SoupMessage* _tmp36_;
	guint _tmp37_;
	guint _tmp38_;
	GFile* _tmp39_;
	GError* _tmp40_;
	SoupMessage* _tmp41_;
	guint _tmp42_;
	guint _tmp43_;
	SoupMessage* _tmp44_;
	gchar* _tmp45_;
	gchar* _tmp46_;
	gchar* _tmp47_;
	GError* _tmp48_;
	GError* _tmp49_;
	GError* _tmp50_;
	GError * _inner_error_;
};

struct _BoxesDownloaderFetchOsLogoData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	GtkImage* image;
	OsinfoOs* os;
	gint size;
	gchar* logo_url;
	gchar* _tmp0_;
	const gchar* _tmp1_;
	const gchar* _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GFile* remote_file;
	const gchar* _tmp5_;
	GFile* _tmp6_;
	gchar* system_cached_path;
	GFile* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	gchar* cached_path;
	GFile* _tmp12_;
	gchar* _tmp13_;
	gchar* _tmp14_;
	gchar* _tmp15_;
	gchar* _tmp16_;
	gchar** cached_paths;
	const gchar* _tmp17_;
	gchar* _tmp18_;
	gchar** _tmp19_;
	gint cached_paths_length1;
	gint _cached_paths_size_;
	const gchar* _tmp20_;
	gchar** _tmp21_;
	gint _tmp21__length1;
	const gchar* _tmp22_;
	gchar* _tmp23_;
	GFile* cached_file;
	BoxesDownloader* _tmp24_;
	BoxesDownloader* _tmp25_;
	GFile* _tmp26_;
	gchar** _tmp27_;
	gint _tmp27__length1;
	BoxesActivityProgress* _tmp28_;
	BoxesActivityProgress* _tmp29_;
	GFile* _tmp30_;
	GFile* _tmp31_;
	GdkPixbuf* pixbuf;
	GFile* _tmp32_;
	gchar* _tmp33_;
	gchar* _tmp34_;
	GdkPixbuf* _tmp35_;
	GdkPixbuf* _tmp36_;
	GdkPixbuf* _tmp37_;
	GError* _error_;
	const gchar* _tmp38_;
	GError* _tmp39_;
	const gchar* _tmp40_;
	GError * _inner_error_;
};

struct _BoxesDownloaderFetchMediaData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	gchar* uri;
	gchar* filename;
	BoxesActivityProgress* progress;
	GCancellable* cancellable;
	gchar* result;
	GFile* file;
	GFile* _tmp0_;
	gchar* basename;
	GFile* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gboolean _tmp4_;
	gboolean _tmp5_;
	const gchar* _tmp6_;
	const gchar* _tmp7_;
	const gchar* _tmp8_;
	BoxesDownloader* downloader;
	BoxesDownloader* _tmp9_;
	gchar* cache;
	const gchar* _tmp10_;
	const gchar* _tmp11_;
	gchar* _tmp12_;
	GFile* _tmp13_;
	gchar* _tmp14_;
	gchar** _tmp15_;
	gchar** _tmp16_;
	gint _tmp16__length1;
	GFile* _tmp17_;
	GFile* _tmp18_;
	GError * _inner_error_;
};

struct _Block104Data {
	int _ref_count_;
	BoxesDownloader* self;
	GFile* downloaded_file;
	GError* download_error;
	GSourceFunc callback;
	gpointer callback_target;
	GDestroyNotify callback_target_destroy_notify;
	BoxesDownload* download;
	gpointer _async_data_;
};

struct _BoxesDownloaderAwaitDownloadData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloader* self;
	BoxesDownload* download;
	gchar* cached_path;
	BoxesActivityProgress* progress;
	GFile* result;
	Block104Data* _data104_;
	BoxesActivityProgress* _tmp0_;
	gulong downloaded_id;
	gulong _tmp1_;
	gulong downloaded_failed_id;
	gulong _tmp2_;
	const gchar* _tmp3_;
	const gchar* _tmp4_;
	GError* _tmp5_;
	GFile* cached_file;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gboolean _tmp8_;
	GFile* _tmp9_;
	GFile* _tmp10_;
	GFile* _tmp11_;
	GError * _inner_error_;
};

struct _Block105Data {
	int _ref_count_;
	BoxesDownloader* self;
	BoxesDownload* download;
	gpointer _async_data_;
};

struct _BoxesDownloaderDownloadFromFilesystemData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GTask* _async_result;
	BoxesDownloader* self;
	BoxesDownload* download;
	GCancellable* cancellable;
	Block105Data* _data105_;
	GFile* src_file;
	GFile* _tmp0_;
	GFile* _tmp1_;
	GFile* dest_file;
	GFile* _tmp2_;
	GFile* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_;
	GError* _error_;
	GError * _inner_error_;
};


static gpointer boxes_download_parent_class = NULL;
static gpointer boxes_downloader_parent_class = NULL;
static BoxesDownloader* boxes_downloader_downloader;
static BoxesDownloader* boxes_downloader_downloader = NULL;
extern gchar** boxes_downloader_supported_schemes;
extern gint boxes_downloader_supported_schemes_length1;
gchar** boxes_downloader_supported_schemes = NULL;
gint boxes_downloader_supported_schemes_length1 = 0;
static gint _boxes_downloader_supported_schemes_size_ = 0;

gpointer boxes_download_ref (gpointer instance);
void boxes_download_unref (gpointer instance);
GParamSpec* boxes_param_spec_download (const gchar* name,
                                       const gchar* nick,
                                       const gchar* blurb,
                                       GType object_type,
                                       GParamFlags flags);
void boxes_value_set_download (GValue* value,
                               gpointer v_object);
void boxes_value_take_download (GValue* value,
                                gpointer v_object);
gpointer boxes_value_get_download (const GValue* value);
GType boxes_download_get_type (void) G_GNUC_CONST;
BoxesDownload* boxes_download_new (GFile* remote_file,
                                   GFile* cached_file,
                                   BoxesActivityProgress* progress);
BoxesDownload* boxes_download_construct (GType object_type,
                                         GFile* remote_file,
                                         GFile* cached_file,
                                         BoxesActivityProgress* progress);
static void boxes_download_finalize (BoxesDownload * obj);
GType boxes_downloader_get_type (void) G_GNUC_CONST;
#define BOXES_DOWNLOADER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BOXES_TYPE_DOWNLOADER, BoxesDownloaderPrivate))
BoxesDownloader* boxes_downloader_get_instance (void);
static BoxesDownloader* boxes_downloader_new (void);
static BoxesDownloader* boxes_downloader_construct (GType object_type);
gchar* boxes_downloader_fetch_os_logo_url (OsinfoOs* os);
static void _g_free0_ (gpointer var);
static void _boxes_download_unref0_ (gpointer var);
static void boxes_downloader_download_data_free (gpointer _data);
void boxes_downloader_download (BoxesDownloader* self,
                                GFile* remote_file,
                                gchar** cached_paths,
                                int cached_paths_length1,
                                BoxesActivityProgress* progress,
                                GCancellable* cancellable,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_);
GFile* boxes_downloader_download_finish (BoxesDownloader* self,
                                         GAsyncResult* _res_,
                                         GError** error);
static gboolean boxes_downloader_download_co (BoxesDownloaderDownloadData* _data_);
static void boxes_downloader_await_download (BoxesDownloader* self,
                                      BoxesDownload* download,
                                      const gchar* cached_path,
                                      BoxesActivityProgress* progress,
                                      GAsyncReadyCallback _callback_,
                                      gpointer _user_data_);
static GFile* boxes_downloader_await_download_finish (BoxesDownloader* self,
                                               GAsyncResult* _res_,
                                               GError** error);
static void boxes_downloader_download_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_);
static GFile* boxes_downloader_get_cached_file (BoxesDownloader* self,
                                         GFile* remote_file,
                                         gchar** cached_paths,
                                         int cached_paths_length1);
static gboolean _vala_string_array_contains (gchar* * stack,
                                      int stack_length,
                                      gchar* needle);
static void boxes_downloader_download_from_http (BoxesDownloader* self,
                                          BoxesDownload* download,
                                          GCancellable* cancellable,
                                          GAsyncReadyCallback _callback_,
                                          gpointer _user_data_);
static void boxes_downloader_download_from_http_finish (BoxesDownloader* self,
                                                 GAsyncResult* _res_,
                                                 GError** error);
static void boxes_downloader_download_from_filesystem (BoxesDownloader* self,
                                                BoxesDownload* download,
                                                GCancellable* cancellable,
                                                GAsyncReadyCallback _callback_,
                                                gpointer _user_data_);
static void boxes_downloader_download_from_filesystem_finish (BoxesDownloader* self,
                                                       GAsyncResult* _res_,
                                                       GError** error);
static void boxes_downloader_download_from_http_data_free (gpointer _data);
static gboolean boxes_downloader_download_from_http_co (BoxesDownloaderDownloadFromHttpData* _data_);
static Block103Data* block103_data_ref (Block103Data* _data103_);
static void block103_data_unref (void * _userdata_);
static void boxes_downloader_download_from_http_ready (GObject* source_object,
                                                GAsyncResult* _res_,
                                                gpointer _user_data_);
static void ___lambda68_ (Block103Data* _data103_);
static void ____lambda68__gfunc (gconstpointer data,
                          gpointer self);
static void __lambda69_ (Block103Data* _data103_);
static void ___lambda69__soup_message_got_headers (SoupMessage* _sender,
                                            gpointer self);
static void __lambda70_ (Block103Data* _data103_,
                  SoupMessage* msg,
                  SoupBuffer* chunk);
static void ___lambda70__soup_message_got_chunk (SoupMessage* _sender,
                                          SoupBuffer* chunk,
                                          gpointer self);
static void __lambda71_ (Block103Data* _data103_,
                  SoupSession* session,
                  SoupMessage* msg);
static void ___lambda71__soup_session_callback (SoupSession* session,
                                         SoupMessage* msg,
                                         gpointer self);
static void boxes_downloader_fetch_os_logo_data_free (gpointer _data);
void boxes_downloader_fetch_os_logo (GtkImage* image,
                                     OsinfoOs* os,
                                     gint size,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_);
void boxes_downloader_fetch_os_logo_finish (GAsyncResult* _res_);
static gboolean boxes_downloader_fetch_os_logo_co (BoxesDownloaderFetchOsLogoData* _data_);
static void _vala_array_add25 (gchar** * array,
                        int* length,
                        int* size,
                        gchar* value);
static void boxes_downloader_fetch_os_logo_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_);
static void boxes_downloader_fetch_media_data_free (gpointer _data);
void boxes_downloader_fetch_media (const gchar* uri,
                                   const gchar* filename,
                                   BoxesActivityProgress* progress,
                                   GCancellable* cancellable,
                                   GAsyncReadyCallback _callback_,
                                   gpointer _user_data_);
gchar* boxes_downloader_fetch_media_finish (GAsyncResult* _res_,
                                            GError** error);
static gboolean boxes_downloader_fetch_media_co (BoxesDownloaderFetchMediaData* _data_);
static void boxes_downloader_fetch_media_ready (GObject* source_object,
                                         GAsyncResult* _res_,
                                         gpointer _user_data_);
static void boxes_downloader_await_download_data_free (gpointer _data);
static gboolean boxes_downloader_await_download_co (BoxesDownloaderAwaitDownloadData* _data_);
static Block104Data* block104_data_ref (Block104Data* _data104_);
static void block104_data_unref (void * _userdata_);
static gboolean _boxes_downloader_await_download_co_gsource_func (gpointer self);
static void __lambda66_ (Block104Data* _data104_,
                  BoxesDownloader* downloader,
                  BoxesDownload* downloaded);
static void ___lambda66__boxes_downloader_downloaded (BoxesDownloader* _sender,
                                               BoxesDownload* download,
                                               gpointer self);
static void __lambda67_ (Block104Data* _data104_,
                  BoxesDownloader* downloader,
                  BoxesDownload* failed_download,
                  GError* _error_);
static void ___lambda67__boxes_downloader_download_failed (BoxesDownloader* _sender,
                                                    BoxesDownload* download,
                                                    GError* _error_,
                                                    gpointer self);
static void boxes_downloader_await_download_ready (GObject* source_object,
                                            GAsyncResult* _res_,
                                            gpointer _user_data_);
static void boxes_downloader_download_from_filesystem_data_free (gpointer _data);
static gboolean boxes_downloader_download_from_filesystem_co (BoxesDownloaderDownloadFromFilesystemData* _data_);
static Block105Data* block105_data_ref (Block105Data* _data105_);
static void block105_data_unref (void * _userdata_);
static void ___lambda72_ (Block105Data* _data105_,
                   gint64 current,
                   gint64 total);
static void ____lambda72__gfile_progress_callback (gint64 current_num_bytes,
                                            gint64 total_num_bytes,
                                            gpointer self);
static void boxes_downloader_download_from_filesystem_ready (GObject* source_object,
                                                      GAsyncResult* _res_,
                                                      gpointer _user_data_);
static void g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD (GClosure * closure,
                                                   GValue * return_value,
                                                   guint n_param_values,
                                                   const GValue * param_values,
                                                   gpointer invocation_hint,
                                                   gpointer marshal_data);
static void g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD_POINTER (GClosure * closure,
                                                           GValue * return_value,
                                                           guint n_param_values,
                                                           const GValue * param_values,
                                                           gpointer invocation_hint,
                                                           gpointer marshal_data);
static void boxes_downloader_finalize (GObject * obj);
static void _vala_array_destroy (gpointer array,
                          gint array_length,
                          GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array,
                       gint array_length,
                       GDestroyNotify destroy_func);


static gpointer
_g_object_ref0 (gpointer self)
{
#line 10 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return self ? g_object_ref (self) : NULL;
#line 632 "downloader.c"
}


BoxesDownload*
boxes_download_construct (GType object_type,
                          GFile* remote_file,
                          GFile* cached_file,
                          BoxesActivityProgress* progress)
{
	BoxesDownload* self = NULL;
	GFile* _tmp0_;
	gchar* _tmp1_;
	GFile* _tmp2_;
	BoxesActivityProgress* _tmp3_;
#line 9 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (remote_file != NULL, NULL);
#line 9 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (cached_file != NULL, NULL);
#line 9 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (progress != NULL, NULL);
#line 9 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = (BoxesDownload*) g_type_create_instance (object_type);
#line 10 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = _g_object_ref0 (remote_file);
#line 10 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (self->remote_file);
#line 10 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self->remote_file = _tmp0_;
#line 11 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = g_file_get_uri (remote_file);
#line 11 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (self->uri);
#line 11 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self->uri = _tmp1_;
#line 12 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = _g_object_ref0 (cached_file);
#line 12 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (self->cached_file);
#line 12 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self->cached_file = _tmp2_;
#line 13 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp3_ = _g_object_ref0 (progress);
#line 13 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (self->progress);
#line 13 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self->progress = _tmp3_;
#line 9 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return self;
#line 681 "downloader.c"
}


BoxesDownload*
boxes_download_new (GFile* remote_file,
                    GFile* cached_file,
                    BoxesActivityProgress* progress)
{
#line 9 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return boxes_download_construct (BOXES_TYPE_DOWNLOAD, remote_file, cached_file, progress);
#line 692 "downloader.c"
}


static void
boxes_value_download_init (GValue* value)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	value->data[0].v_pointer = NULL;
#line 701 "downloader.c"
}


static void
boxes_value_download_free_value (GValue* value)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (value->data[0].v_pointer) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		boxes_download_unref (value->data[0].v_pointer);
#line 712 "downloader.c"
	}
}


static void
boxes_value_download_copy_value (const GValue* src_value,
                                 GValue* dest_value)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (src_value->data[0].v_pointer) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		dest_value->data[0].v_pointer = boxes_download_ref (src_value->data[0].v_pointer);
#line 725 "downloader.c"
	} else {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		dest_value->data[0].v_pointer = NULL;
#line 729 "downloader.c"
	}
}


static gpointer
boxes_value_download_peek_pointer (const GValue* value)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return value->data[0].v_pointer;
#line 739 "downloader.c"
}


static gchar*
boxes_value_download_collect_value (GValue* value,
                                    guint n_collect_values,
                                    GTypeCValue* collect_values,
                                    guint collect_flags)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (collect_values[0].v_pointer) {
#line 751 "downloader.c"
		BoxesDownload * object;
		object = collect_values[0].v_pointer;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (object->parent_instance.g_class == NULL) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 758 "downloader.c"
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
#line 762 "downloader.c"
		}
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		value->data[0].v_pointer = boxes_download_ref (object);
#line 766 "downloader.c"
	} else {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		value->data[0].v_pointer = NULL;
#line 770 "downloader.c"
	}
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return NULL;
#line 774 "downloader.c"
}


static gchar*
boxes_value_download_lcopy_value (const GValue* value,
                                  guint n_collect_values,
                                  GTypeCValue* collect_values,
                                  guint collect_flags)
{
	BoxesDownload ** object_p;
	object_p = collect_values[0].v_pointer;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (!object_p) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
#line 790 "downloader.c"
	}
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (!value->data[0].v_pointer) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		*object_p = NULL;
#line 796 "downloader.c"
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		*object_p = value->data[0].v_pointer;
#line 800 "downloader.c"
	} else {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		*object_p = boxes_download_ref (value->data[0].v_pointer);
#line 804 "downloader.c"
	}
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return NULL;
#line 808 "downloader.c"
}


GParamSpec*
boxes_param_spec_download (const gchar* name,
                           const gchar* nick,
                           const gchar* blurb,
                           GType object_type,
                           GParamFlags flags)
{
	BoxesParamSpecDownload* spec;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (g_type_is_a (object_type, BOXES_TYPE_DOWNLOAD), NULL);
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	G_PARAM_SPEC (spec)->value_type = object_type;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return G_PARAM_SPEC (spec);
#line 828 "downloader.c"
}


gpointer
boxes_value_get_download (const GValue* value)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_DOWNLOAD), NULL);
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return value->data[0].v_pointer;
#line 839 "downloader.c"
}


void
boxes_value_set_download (GValue* value,
                          gpointer v_object)
{
	BoxesDownload * old;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_DOWNLOAD));
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	old = value->data[0].v_pointer;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (v_object) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_DOWNLOAD));
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		value->data[0].v_pointer = v_object;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		boxes_download_ref (value->data[0].v_pointer);
#line 862 "downloader.c"
	} else {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		value->data[0].v_pointer = NULL;
#line 866 "downloader.c"
	}
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (old) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		boxes_download_unref (old);
#line 872 "downloader.c"
	}
}


void
boxes_value_take_download (GValue* value,
                           gpointer v_object)
{
	BoxesDownload * old;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BOXES_TYPE_DOWNLOAD));
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	old = value->data[0].v_pointer;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (v_object) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BOXES_TYPE_DOWNLOAD));
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		value->data[0].v_pointer = v_object;
#line 894 "downloader.c"
	} else {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		value->data[0].v_pointer = NULL;
#line 898 "downloader.c"
	}
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (old) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		boxes_download_unref (old);
#line 904 "downloader.c"
	}
}


static void
boxes_download_class_init (BoxesDownloadClass * klass)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_download_parent_class = g_type_class_peek_parent (klass);
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	((BoxesDownloadClass *) klass)->finalize = boxes_download_finalize;
#line 916 "downloader.c"
}


static void
boxes_download_instance_init (BoxesDownload * self)
{
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self->ref_count = 1;
#line 925 "downloader.c"
}


static void
boxes_download_finalize (BoxesDownload * obj)
{
	BoxesDownload * self;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DOWNLOAD, BoxesDownload);
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_signal_handlers_destroy (self);
#line 4 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (self->uri);
#line 5 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (self->remote_file);
#line 6 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (self->cached_file);
#line 7 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (self->progress);
#line 945 "downloader.c"
}


GType
boxes_download_get_type (void)
{
	static volatile gsize boxes_download_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_download_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { boxes_value_download_init, boxes_value_download_free_value, boxes_value_download_copy_value, boxes_value_download_peek_pointer, "p", boxes_value_download_collect_value, "p", boxes_value_download_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BoxesDownloadClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_download_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesDownload), 0, (GInstanceInitFunc) boxes_download_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType boxes_download_type_id;
		boxes_download_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BoxesDownload", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&boxes_download_type_id__volatile, boxes_download_type_id);
	}
	return boxes_download_type_id__volatile;
}


gpointer
boxes_download_ref (gpointer instance)
{
	BoxesDownload * self;
	self = instance;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_atomic_int_inc (&self->ref_count);
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return instance;
#line 974 "downloader.c"
}


void
boxes_download_unref (gpointer instance)
{
	BoxesDownload * self;
	self = instance;
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		BOXES_DOWNLOAD_GET_CLASS (self)->finalize (self);
#line 3 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_type_free_instance ((GTypeInstance *) self);
#line 989 "downloader.c"
	}
}


BoxesDownloader*
boxes_downloader_get_instance (void)
{
	BoxesDownloader* result = NULL;
	BoxesDownloader* _tmp0_;
	BoxesDownloader* _tmp2_;
	BoxesDownloader* _tmp3_;
#line 32 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = boxes_downloader_downloader;
#line 32 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_tmp0_ == NULL) {
#line 1005 "downloader.c"
		BoxesDownloader* _tmp1_;
#line 33 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp1_ = boxes_downloader_new ();
#line 33 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (boxes_downloader_downloader);
#line 33 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		boxes_downloader_downloader = _tmp1_;
#line 1013 "downloader.c"
	}
#line 35 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = boxes_downloader_downloader;
#line 35 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 35 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	result = _tmp3_;
#line 35 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return result;
#line 1023 "downloader.c"
}


gchar*
boxes_downloader_fetch_os_logo_url (OsinfoOs* os)
{
	gchar* result = NULL;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	gchar* logo_url = NULL;
	OsinfoProductList* derived = NULL;
	OsinfoProductList* _tmp5_;
#line 38 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (os != NULL, NULL);
#line 39 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = osinfo_product_get_logo ((OsinfoProduct*) os);
#line 39 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _tmp0_;
#line 39 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_tmp1_ != NULL) {
#line 1044 "downloader.c"
		const gchar* _tmp2_;
		const gchar* _tmp3_;
		gchar* _tmp4_;
#line 40 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp2_ = osinfo_product_get_logo ((OsinfoProduct*) os);
#line 40 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp3_ = _tmp2_;
#line 40 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp4_ = g_strdup (_tmp3_);
#line 40 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		result = _tmp4_;
#line 40 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return result;
#line 1058 "downloader.c"
	}
#line 42 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	logo_url = NULL;
#line 43 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp5_ = osinfo_product_get_related ((OsinfoProduct*) os, OSINFO_PRODUCT_RELATIONSHIP_DERIVES_FROM);
#line 43 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	derived = _tmp5_;
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	while (TRUE) {
#line 1068 "downloader.c"
		gboolean _tmp6_ = FALSE;
		OsinfoProductList* _tmp7_;
		OsinfoOs* parent = NULL;
		OsinfoProductList* _tmp9_;
		OsinfoEntity* _tmp10_;
		OsinfoOs* _tmp11_;
		OsinfoOs* _tmp12_;
		const gchar* _tmp13_;
		const gchar* _tmp14_;
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp7_ = derived;
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (osinfo_list_get_length ((OsinfoList*) _tmp7_) > 0) {
#line 1082 "downloader.c"
			const gchar* _tmp8_;
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp8_ = logo_url;
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp6_ = _tmp8_ == NULL;
#line 1088 "downloader.c"
		} else {
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp6_ = FALSE;
#line 1092 "downloader.c"
		}
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (!_tmp6_) {
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			break;
#line 1098 "downloader.c"
		}
#line 46 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp9_ = derived;
#line 46 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp10_ = osinfo_list_get_nth ((OsinfoList*) _tmp9_, 0);
#line 46 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp11_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp10_, osinfo_os_get_type ()) ? ((OsinfoOs*) _tmp10_) : NULL);
#line 46 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		parent = _tmp11_;
#line 48 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp12_ = parent;
#line 48 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp13_ = osinfo_product_get_logo ((OsinfoProduct*) _tmp12_);
#line 48 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp14_ = _tmp13_;
#line 48 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (_tmp14_ != NULL) {
#line 1116 "downloader.c"
			OsinfoOs* _tmp15_;
			const gchar* _tmp16_;
			const gchar* _tmp17_;
			gchar* _tmp18_;
#line 49 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp15_ = parent;
#line 49 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp16_ = osinfo_product_get_logo ((OsinfoProduct*) _tmp15_);
#line 49 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp17_ = _tmp16_;
#line 49 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp18_ = g_strdup (_tmp17_);
#line 49 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_free0 (logo_url);
#line 49 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			logo_url = _tmp18_;
#line 1133 "downloader.c"
		} else {
			OsinfoOs* _tmp19_;
			OsinfoProductList* _tmp20_;
#line 51 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp19_ = parent;
#line 51 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp20_ = osinfo_product_get_related ((OsinfoProduct*) _tmp19_, OSINFO_PRODUCT_RELATIONSHIP_DERIVES_FROM);
#line 51 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_object_unref0 (derived);
#line 51 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			derived = _tmp20_;
#line 1145 "downloader.c"
		}
#line 44 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (parent);
#line 1149 "downloader.c"
	}
#line 54 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	result = logo_url;
#line 54 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (derived);
#line 54 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return result;
#line 1157 "downloader.c"
}


static void
_g_free0_ (gpointer var)
{
#line 58 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	var = (g_free (var), NULL);
#line 1166 "downloader.c"
}


static void
_boxes_download_unref0_ (gpointer var)
{
#line 58 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	(var == NULL) ? NULL : (var = (boxes_download_unref (var), NULL));
#line 1175 "downloader.c"
}


static BoxesDownloader*
boxes_downloader_construct (GType object_type)
{
	BoxesDownloader * self = NULL;
	GHashFunc _tmp0_;
	GEqualFunc _tmp1_;
	GHashTable* _tmp2_;
	SoupSession* _tmp3_;
	const gchar* _tmp4_;
	gchar* user_agent = NULL;
	gchar* _tmp8_;
	SoupSession* _tmp9_;
#line 57 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = (BoxesDownloader*) g_object_new (object_type, NULL);
#line 58 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = g_str_hash;
#line 58 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = g_str_equal;
#line 58 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _boxes_download_unref0_);
#line 58 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_hash_table_unref0 (self->priv->downloads);
#line 58 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self->priv->downloads = _tmp2_;
#line 60 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp3_ = soup_session_new ();
#line 60 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (self->priv->session);
#line 60 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self->priv->session = _tmp3_;
#line 61 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp4_ = g_getenv ("SOUP_DEBUG");
#line 61 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_tmp4_ != NULL) {
#line 1213 "downloader.c"
		SoupSession* _tmp5_;
		SoupLogger* _tmp6_;
		SoupLogger* _tmp7_;
#line 62 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp5_ = self->priv->session;
#line 62 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp6_ = soup_logger_new (SOUP_LOGGER_LOG_HEADERS, -1);
#line 62 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp7_ = _tmp6_;
#line 62 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		soup_session_add_feature (_tmp5_, (SoupSessionFeature*) _tmp7_);
#line 62 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_tmp7_);
#line 1227 "downloader.c"
	}
#line 64 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp8_ = boxes_get_user_agent ();
#line 64 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	user_agent = _tmp8_;
#line 65 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp9_ = self->priv->session;
#line 65 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_set (_tmp9_, "user-agent", user_agent, NULL);
#line 57 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (user_agent);
#line 57 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return self;
#line 1241 "downloader.c"
}


static BoxesDownloader*
boxes_downloader_new (void)
{
#line 57 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return boxes_downloader_construct (BOXES_TYPE_DOWNLOADER);
#line 1250 "downloader.c"
}


static void
boxes_downloader_download_data_free (gpointer _data)
{
	BoxesDownloaderDownloadData* _data_;
	_data_ = _data;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->remote_file);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->result);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->self);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_slice_free (BoxesDownloaderDownloadData, _data_);
#line 1271 "downloader.c"
}


void
boxes_downloader_download (BoxesDownloader* self,
                           GFile* remote_file,
                           gchar** cached_paths,
                           int cached_paths_length1,
                           BoxesActivityProgress* progress,
                           GCancellable* cancellable,
                           GAsyncReadyCallback _callback_,
                           gpointer _user_data_)
{
	BoxesDownloaderDownloadData* _data_;
	BoxesDownloader* _tmp0_;
	GFile* _tmp1_;
	BoxesActivityProgress* _tmp2_;
	GCancellable* _tmp3_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_slice_new0 (BoxesDownloaderDownloadData);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_download_data_free);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->self = _tmp0_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _g_object_ref0 (remote_file);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->remote_file);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->remote_file = _tmp1_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_paths = cached_paths;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_paths_length1 = cached_paths_length1;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = _g_object_ref0 (progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->progress = _tmp2_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cancellable = _tmp3_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_download_co (_data_);
#line 1324 "downloader.c"
}


GFile*
boxes_downloader_download_finish (BoxesDownloader* self,
                                  GAsyncResult* _res_,
                                  GError** error)
{
	GFile* result;
	BoxesDownloaderDownloadData* _data_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (NULL == _data_) {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return NULL;
#line 1341 "downloader.c"
	}
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	result = _data_->result;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->result = NULL;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return result;
#line 1349 "downloader.c"
}


/**
     * Downloads the given file.
     *
     * @param remote_file The remote file to download.
     * @param cached_paths Array of possible cache locations. If not found, the file will be saved
     *                     to the location specified by the first element.
     * @param progress The ActivityProgress object to report progress to.
     * @param cancellable The Cancellable object for cancellation.
     *
     * @return A file handle to the (now) local file.
     */
static gpointer
_boxes_download_ref0 (gpointer self)
{
#line 84 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return self ? boxes_download_ref (self) : NULL;
#line 1369 "downloader.c"
}


static void
boxes_downloader_download_ready (GObject* source_object,
                                 GAsyncResult* _res_,
                                 gpointer _user_data_)
{
	BoxesDownloaderDownloadData* _data_;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = _user_data_;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_source_object_ = source_object;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_res_ = _res_;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_download_co (_data_);
#line 1387 "downloader.c"
}


static gboolean
_vala_string_array_contains (gchar* * stack,
                             int stack_length,
                             gchar* needle)
{
	int i;
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	for (i = 0; i < stack_length; i++) {
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (g_strcmp0 (stack[i], needle) == 0) {
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			return TRUE;
#line 1403 "downloader.c"
		}
	}
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 1408 "downloader.c"
}


static gpointer
_g_error_copy0 (gpointer self)
{
#line 109 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return self ? g_error_copy (self) : NULL;
#line 1417 "downloader.c"
}


static gboolean
boxes_downloader_download_co (BoxesDownloaderDownloadData* _data_)
{
#line 79 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	switch (_data_->_state_) {
#line 79 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 0:
#line 1428 "downloader.c"
		goto _state_0;
#line 79 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 1:
#line 1432 "downloader.c"
		goto _state_1;
#line 79 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 2:
#line 1436 "downloader.c"
		goto _state_2;
#line 79 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 3:
#line 1440 "downloader.c"
		goto _state_3;
		default:
#line 79 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_assert_not_reached ();
#line 1445 "downloader.c"
	}
	_state_0:
#line 83 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp0_ = g_file_get_uri (_data_->remote_file);
#line 83 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->uri = _data_->_tmp0_;
#line 84 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp1_ = _data_->self->priv->downloads;
#line 84 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp2_ = _data_->uri;
#line 84 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp3_ = g_hash_table_lookup (_data_->_tmp1_, _data_->_tmp2_);
#line 84 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp4_ = _boxes_download_ref0 ((BoxesDownload*) _data_->_tmp3_);
#line 84 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->download = _data_->_tmp4_;
#line 85 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp5_ = _data_->cached_paths[0];
#line 85 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp6_ = g_strdup (_data_->_tmp5_);
#line 85 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_path = _data_->_tmp6_;
#line 87 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp7_ = _data_->download;
#line 87 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp7_ != NULL) {
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp9_ = _data_->download;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp10_ = _data_->cached_path;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_state_ = 1;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		boxes_downloader_await_download (_data_->self, _data_->_tmp9_, _data_->_tmp10_, _data_->progress, boxes_downloader_download_ready, _data_);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 1482 "downloader.c"
		_state_1:
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp11_ = boxes_downloader_await_download_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp8_ = _data_->_tmp11_;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_free0 (_data_->cached_path);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_boxes_download_unref0 (_data_->download);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_free0 (_data_->uri);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_object_unref (_data_->_async_result);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			return FALSE;
#line 1502 "downloader.c"
		}
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp12_ = _data_->_tmp8_;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp8_ = NULL;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->result = _data_->_tmp12_;
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->_tmp8_);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->cached_path);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_boxes_download_unref0 (_data_->download);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->uri);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (_data_->_state_ != 0) {
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1526 "downloader.c"
			}
		}
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 89 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 1533 "downloader.c"
	}
#line 91 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp13_ = boxes_downloader_get_cached_file (_data_->self, _data_->remote_file, _data_->cached_paths, _data_->cached_paths_length1);
#line 91 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_file = _data_->_tmp13_;
#line 92 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp14_ = _data_->cached_file;
#line 92 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp14_ != NULL) {
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->result = _data_->cached_file;
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->cached_path);
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_boxes_download_unref0 (_data_->download);
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->uri);
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (_data_->_state_ != 0) {
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1559 "downloader.c"
			}
		}
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 93 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 1566 "downloader.c"
	}
#line 95 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp15_ = _data_->cached_path;
#line 95 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp16_ = g_strconcat (_data_->_tmp15_, "~", NULL);
#line 95 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->tmp_path = _data_->_tmp16_;
#line 96 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp17_ = _data_->tmp_path;
#line 96 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp18_ = g_file_new_for_path (_data_->_tmp17_);
#line 96 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->tmp_file = _data_->_tmp18_;
#line 97 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp19_ = _data_->uri;
#line 97 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_debug ("downloader.vala:97: Downloading '%s'...", _data_->_tmp19_);
#line 98 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp20_ = _data_->tmp_file;
#line 98 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp21_ = boxes_download_new (_data_->remote_file, _data_->_tmp20_, _data_->progress);
#line 98 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_boxes_download_unref0 (_data_->download);
#line 98 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->download = _data_->_tmp21_;
#line 99 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp22_ = _data_->self->priv->downloads;
#line 99 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp23_ = _data_->uri;
#line 99 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp24_ = g_strdup (_data_->_tmp23_);
#line 99 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp25_ = _data_->download;
#line 99 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp26_ = _boxes_download_ref0 (_data_->_tmp25_);
#line 99 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_hash_table_insert (_data_->_tmp22_, _data_->_tmp24_, _data_->_tmp26_);
#line 1604 "downloader.c"
	{
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp27_ = g_file_get_uri_scheme (_data_->remote_file);
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp28_ = _data_->_tmp27_;
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp29_ = boxes_downloader_supported_schemes;
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp29__length1 = boxes_downloader_supported_schemes_length1;
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp30_ = _vala_string_array_contains (_data_->_tmp29_, _data_->_tmp29__length1, _data_->_tmp28_);
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->_tmp28_);
#line 102 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (_data_->_tmp30_) {
#line 103 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_tmp31_ = _data_->download;
#line 103 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_state_ = 2;
#line 103 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			boxes_downloader_download_from_http (_data_->self, _data_->_tmp31_, _data_->cancellable, boxes_downloader_download_ready, _data_);
#line 103 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			return FALSE;
#line 1628 "downloader.c"
			_state_2:
#line 103 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			boxes_downloader_download_from_http_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 103 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1634 "downloader.c"
				goto __catch152_g_error;
			}
		} else {
#line 105 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_tmp32_ = _data_->download;
#line 105 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_state_ = 3;
#line 105 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			boxes_downloader_download_from_filesystem (_data_->self, _data_->_tmp32_, _data_->cancellable, boxes_downloader_download_ready, _data_);
#line 105 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			return FALSE;
#line 1646 "downloader.c"
			_state_3:
#line 105 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			boxes_downloader_download_from_filesystem_finish (_data_->self, _data_->_res_, &_data_->_inner_error_);
#line 105 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 1652 "downloader.c"
				goto __catch152_g_error;
			}
		}
	}
	goto __finally152;
	__catch152_g_error:
	{
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_inner_error_ = NULL;
#line 107 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp33_ = _data_->download;
#line 107 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp34_ = _data_->_error_;
#line 107 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_signal_emit (_data_->self, boxes_downloader_signals[BOXES_DOWNLOADER_DOWNLOAD_FAILED_SIGNAL], 0, _data_->_tmp33_, _data_->_tmp34_);
#line 109 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp35_ = _data_->_error_;
#line 109 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp36_ = _g_error_copy0 (_data_->_tmp35_);
#line 109 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_inner_error_ = _data_->_tmp36_;
#line 109 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_error_free0 (_data_->_error_);
#line 1678 "downloader.c"
		goto __finally152;
	}
	__finally152:
	{
#line 111 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp37_ = _data_->self->priv->downloads;
#line 111 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp38_ = _data_->uri;
#line 111 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_hash_table_remove (_data_->_tmp37_, _data_->_tmp38_);
#line 1689 "downloader.c"
	}
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->tmp_file);
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->tmp_path);
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->cached_file);
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->cached_path);
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_boxes_download_unref0 (_data_->download);
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->uri);
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 101 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 1711 "downloader.c"
	}
#line 114 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp39_ = _data_->cached_path;
#line 114 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp40_ = g_file_new_for_path (_data_->_tmp39_);
#line 114 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cached_file);
#line 114 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_file = _data_->_tmp40_;
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp41_ = _data_->tmp_file;
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp42_ = _data_->cached_file;
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_file_move (_data_->_tmp41_, _data_->_tmp42_, G_FILE_COPY_NONE, _data_->cancellable, NULL, NULL, &_data_->_inner_error_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->tmp_file);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->tmp_path);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->cached_file);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->cached_path);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_boxes_download_unref0 (_data_->download);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->uri);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 115 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 1747 "downloader.c"
	}
#line 116 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp43_ = _data_->download;
#line 116 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp44_ = _data_->cached_file;
#line 116 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp45_ = _g_object_ref0 (_data_->_tmp44_);
#line 116 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->_tmp43_->cached_file);
#line 116 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp43_->cached_file = _data_->_tmp45_;
#line 118 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp46_ = _data_->uri;
#line 118 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp47_ = _data_->cached_path;
#line 118 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_debug ("downloader.vala:118: Downloaded '%s' and it's now locally available at" \
" '%s'.", _data_->_tmp46_, _data_->_tmp47_);
#line 119 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp48_ = _data_->download;
#line 119 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_signal_emit (_data_->self, boxes_downloader_signals[BOXES_DOWNLOADER_DOWNLOADED_SIGNAL], 0, _data_->_tmp48_);
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->result = _data_->cached_file;
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->tmp_file);
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->tmp_path);
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->cached_path);
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_boxes_download_unref0 (_data_->download);
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->uri);
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_state_ != 0) {
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 1789 "downloader.c"
		}
	}
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_unref (_data_->_async_result);
#line 121 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 1796 "downloader.c"
}


static void
boxes_downloader_download_from_http_data_free (gpointer _data)
{
	BoxesDownloaderDownloadFromHttpData* _data_;
	_data_ = _data;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->self);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_slice_free (BoxesDownloaderDownloadFromHttpData, _data_);
#line 1811 "downloader.c"
}


static void
boxes_downloader_download_from_http (BoxesDownloader* self,
                                     BoxesDownload* download,
                                     GCancellable* cancellable,
                                     GAsyncReadyCallback _callback_,
                                     gpointer _user_data_)
{
	BoxesDownloaderDownloadFromHttpData* _data_;
	BoxesDownloader* _tmp0_;
	BoxesDownload* _tmp1_;
	GCancellable* _tmp2_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_slice_new0 (BoxesDownloaderDownloadFromHttpData);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_download_from_http_data_free);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->self = _tmp0_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _boxes_download_ref0 (download);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_boxes_download_unref0 (_data_->download);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->download = _tmp1_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cancellable = _tmp2_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_download_from_http_co (_data_);
#line 1850 "downloader.c"
}


static void
boxes_downloader_download_from_http_finish (BoxesDownloader* self,
                                            GAsyncResult* _res_,
                                            GError** error)
{
	BoxesDownloaderDownloadFromHttpData* _data_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (NULL == _data_) {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return;
#line 1866 "downloader.c"
	}
}


static Block103Data*
block103_data_ref (Block103Data* _data103_)
{
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_atomic_int_inc (&_data103_->_ref_count_);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return _data103_;
#line 1878 "downloader.c"
}


static void
block103_data_unref (void * _userdata_)
{
	Block103Data* _data103_;
	_data103_ = (Block103Data*) _userdata_;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (g_atomic_int_dec_and_test (&_data103_->_ref_count_)) {
#line 1889 "downloader.c"
		BoxesDownloader* self;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		self = _data103_->self;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data103_->cached_file_stream);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_error_free0 (_data103_->err);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data103_->msg);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_boxes_download_unref0 (_data103_->download);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (self);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_slice_free (Block103Data, _data103_);
#line 1905 "downloader.c"
	}
}


static void
boxes_downloader_download_from_http_ready (GObject* source_object,
                                           GAsyncResult* _res_,
                                           gpointer _user_data_)
{
	BoxesDownloaderDownloadFromHttpData* _data_;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = _user_data_;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_source_object_ = source_object;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_res_ = _res_;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_download_from_http_co (_data_);
#line 1924 "downloader.c"
}


static void
___lambda68_ (Block103Data* _data103_)
{
	BoxesDownloader* self;
	GError* _tmp0_;
	SoupSession* _tmp1_;
	SoupMessage* _tmp2_;
#line 136 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = _data103_->self;
#line 137 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = g_error_new_literal (G_IO_ERROR, G_IO_ERROR_CANCELLED, "Cancelled by cancellable.");
#line 137 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_error_free0 (_data103_->err);
#line 137 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data103_->err = _tmp0_;
#line 138 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = self->priv->session;
#line 138 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = _data103_->msg;
#line 138 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	soup_session_cancel_message (_tmp1_, _tmp2_, (guint) SOUP_STATUS_CANCELLED);
#line 1949 "downloader.c"
}


static void
____lambda68__gfunc (gconstpointer data,
                     gpointer self)
{
#line 136 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	___lambda68_ (self);
#line 1959 "downloader.c"
}


static void
__lambda69_ (Block103Data* _data103_)
{
	BoxesDownloader* self;
	SoupMessage* _tmp0_;
	SoupMessageHeaders* _tmp1_;
#line 142 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = _data103_->self;
#line 143 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = _data103_->msg;
#line 143 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _tmp0_->response_headers;
#line 143 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data103_->total_num_bytes = soup_message_headers_get_content_length (_tmp1_);
#line 1977 "downloader.c"
}


static void
___lambda69__soup_message_got_headers (SoupMessage* _sender,
                                       gpointer self)
{
#line 142 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	__lambda69_ (self);
#line 1987 "downloader.c"
}


static void
__lambda70_ (Block103Data* _data103_,
             SoupMessage* msg,
             SoupBuffer* chunk)
{
	BoxesDownloader* self;
	SoupSession* _tmp0_;
	gint64 _tmp1_;
	gsize _tmp2_;
	GError * _inner_error_ = NULL;
#line 152 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = _data103_->self;
#line 152 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (msg != NULL);
#line 152 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (chunk != NULL);
#line 153 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = self->priv->session;
#line 153 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (soup_session_would_redirect (_tmp0_, msg)) {
#line 154 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return;
#line 2013 "downloader.c"
	}
#line 156 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _data103_->current_num_bytes;
#line 156 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = chunk->length;
#line 156 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data103_->current_num_bytes = _tmp1_ + _tmp2_;
#line 2021 "downloader.c"
	{
		GFileOutputStream* _tmp3_;
		guint8* _tmp4_;
		gint _tmp4__length1;
		gint64 _tmp5_;
#line 161 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp3_ = _data103_->cached_file_stream;
#line 161 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp4_ = chunk->data;
#line 161 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp4__length1 = (gint) chunk->length;
#line 161 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_output_stream_write ((GOutputStream*) _tmp3_, _tmp4_, (gsize) _tmp4__length1, NULL, &_inner_error_);
#line 161 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 2037 "downloader.c"
			goto __catch153_g_error;
		}
#line 162 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp5_ = _data103_->total_num_bytes;
#line 162 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (_tmp5_ > ((gint64) 0)) {
#line 2044 "downloader.c"
			BoxesActivityProgress* _tmp6_;
			gint64 _tmp7_;
			gint64 _tmp8_;
#line 164 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp6_ = _data103_->download->progress;
#line 164 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp7_ = _data103_->current_num_bytes;
#line 164 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp8_ = _data103_->total_num_bytes;
#line 164 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			boxes_activity_progress_set_progress (_tmp6_, ((gdouble) _tmp7_) / _tmp8_);
#line 2056 "downloader.c"
		}
	}
	goto __finally153;
	__catch153_g_error:
	{
		GError* e = NULL;
		GError* _tmp9_;
		GError* _tmp10_;
		SoupSession* _tmp11_;
#line 157 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		e = _inner_error_;
#line 157 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_inner_error_ = NULL;
#line 166 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp9_ = e;
#line 166 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp10_ = _g_error_copy0 (_tmp9_);
#line 166 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_error_free0 (_data103_->err);
#line 166 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data103_->err = _tmp10_;
#line 167 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_tmp11_ = self->priv->session;
#line 167 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		soup_session_cancel_message (_tmp11_, msg, (guint) SOUP_STATUS_CANCELLED);
#line 157 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_error_free0 (e);
#line 2084 "downloader.c"
	}
	__finally153:
#line 157 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 157 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 157 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_clear_error (&_inner_error_);
#line 157 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return;
#line 2095 "downloader.c"
	}
}


static void
___lambda70__soup_message_got_chunk (SoupMessage* _sender,
                                     SoupBuffer* chunk,
                                     gpointer self)
{
#line 152 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	__lambda70_ (self, _sender, chunk);
#line 2107 "downloader.c"
}


static void
__lambda71_ (Block103Data* _data103_,
             SoupSession* session,
             SoupMessage* msg)
{
	BoxesDownloader* self;
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = _data103_->self;
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (session != NULL);
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (msg != NULL);
#line 172 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_download_from_http_co (_data103_->_async_data_);
#line 2125 "downloader.c"
}


static void
___lambda71__soup_session_callback (SoupSession* session,
                                    SoupMessage* msg,
                                    gpointer self)
{
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	__lambda71_ (self, session, msg);
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	block103_data_unref (self);
#line 2138 "downloader.c"
}


static gboolean
boxes_downloader_download_from_http_co (BoxesDownloaderDownloadFromHttpData* _data_)
{
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	switch (_data_->_state_) {
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 0:
#line 2149 "downloader.c"
		goto _state_0;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 1:
#line 2153 "downloader.c"
		goto _state_1;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 2:
#line 2157 "downloader.c"
		goto _state_2;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 3:
#line 2161 "downloader.c"
		goto _state_3;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 4:
#line 2165 "downloader.c"
		goto _state_4;
		default:
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_assert_not_reached ();
#line 2170 "downloader.c"
	}
	_state_0:
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_ = g_slice_new0 (Block103Data);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->_ref_count_ = 1;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->self = g_object_ref (_data_->self);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_boxes_download_unref0 (_data_->_data103_->download);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->download = _data_->download;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->_async_data_ = _data_;
#line 125 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp0_ = _data_->_data103_->download->uri;
#line 125 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp1_ = soup_message_new ("GET", _data_->_tmp0_);
#line 125 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->msg = _data_->_tmp1_;
#line 126 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp2_ = _data_->_data103_->msg;
#line 126 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp3_ = _data_->_tmp2_->response_body;
#line 126 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	soup_message_body_set_accumulate (_data_->_tmp3_, FALSE);
#line 127 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp4_ = _data_->_data103_->msg;
#line 127 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp5_ = soup_message_get_address (_data_->_tmp4_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp6_ = _g_object_ref0 (_data_->_tmp5_);
#line 127 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->address = _data_->_tmp6_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp7_ = _data_->address;
#line 128 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp8_ = soup_address_get_name (_data_->_tmp7_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp10_ = _data_->address;
#line 128 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp11_ = soup_address_get_port (_data_->_tmp10_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp12_ = _data_->_tmp11_;
#line 128 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp13_ = (GNetworkAddress*) g_network_address_new (_data_->_tmp9_, (guint16) _data_->_tmp12_);
#line 128 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->connectable = _data_->_tmp13_;
#line 129 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp14_ = g_network_monitor_get_default ();
#line 129 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp15_ = _g_object_ref0 (_data_->_tmp14_);
#line 129 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->network_monitor = _data_->_tmp15_;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp17_ = _data_->network_monitor;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp18_ = _data_->connectable;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_state_ = 1;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_network_monitor_can_reach_async (_data_->_tmp17_, (GSocketConnectable*) _data_->_tmp18_, NULL, boxes_downloader_download_from_http_ready, _data_);
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 2237 "downloader.c"
	_state_1:
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp16_ = g_network_monitor_can_reach_finish (_data_->_tmp17_, _data_->_res_, &_data_->_inner_error_);
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->network_monitor);
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->connectable);
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->address);
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		block103_data_unref (_data_->_data103_);
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_data103_ = NULL;
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 2259 "downloader.c"
	}
#line 130 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (!_data_->_tmp16_) {
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp19_ = _data_->address;
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp20_ = soup_address_get_name (_data_->_tmp19_);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp21_ = _data_->_tmp20_;
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp22_ = _data_->address;
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp23_ = soup_address_get_port (_data_->_tmp22_);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp24_ = _data_->_tmp23_;
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp25_ = g_error_new (BOXES_ERROR, BOXES_ERROR_INVALID, "Failed to reach host '%s' on port '%d'", _data_->_tmp21_, _data_->_tmp24_);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_inner_error_ = _data_->_tmp25_;
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->network_monitor);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->connectable);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->address);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		block103_data_unref (_data_->_data103_);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_data103_ = NULL;
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 131 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 2295 "downloader.c"
	}
#line 133 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->err = NULL;
#line 134 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cancelled_id = (gulong) 0;
#line 135 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->cancellable != NULL) {
#line 136 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->cancelled_id = g_cancellable_connect (_data_->cancellable, (GCallback) ____lambda68__gfunc, block103_data_ref (_data_->_data103_), block103_data_unref);
#line 2305 "downloader.c"
	}
#line 141 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->total_num_bytes = (gint64) 0;
#line 142 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp26_ = _data_->_data103_->msg;
#line 142 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_signal_connect_data (_data_->_tmp26_, "got-headers", (GCallback) ___lambda69__soup_message_got_headers, block103_data_ref (_data_->_data103_), (GClosureNotify) block103_data_unref, 0);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp27_ = _data_->_data103_->download->cached_file;
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_state_ = 2;
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_file_replace_async (_data_->_tmp27_, NULL, FALSE, G_FILE_CREATE_REPLACE_DESTINATION, G_PRIORITY_DEFAULT, NULL, boxes_downloader_download_from_http_ready, _data_);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 2321 "downloader.c"
	_state_2:
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp28_ = g_file_replace_finish (_data_->_tmp27_, _data_->_res_, &_data_->_inner_error_);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->cached_file_stream = _data_->_tmp28_;
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->network_monitor);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->connectable);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->address);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		block103_data_unref (_data_->_data103_);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_data103_ = NULL;
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 146 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 2345 "downloader.c"
	}
#line 150 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_->current_num_bytes = (gint64) 0;
#line 152 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp29_ = _data_->_data103_->msg;
#line 152 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_signal_connect_data (_data_->_tmp29_, "got-chunk", (GCallback) ___lambda70__soup_message_got_chunk, block103_data_ref (_data_->_data103_), (GClosureNotify) block103_data_unref, 0);
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp30_ = _data_->self->priv->session;
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp31_ = _data_->_data103_->msg;
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp32_ = _g_object_ref0 (_data_->_tmp31_);
#line 171 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	soup_session_queue_message (_data_->_tmp30_, _data_->_tmp32_, ___lambda71__soup_session_callback, block103_data_ref (_data_->_data103_));
#line 175 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_state_ = 3;
#line 175 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 2365 "downloader.c"
	_state_3:
	;
#line 177 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp33_ = _data_->cancelled_id;
#line 177 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp33_ != ((gulong) 0)) {
#line 178 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp34_ = _data_->cancelled_id;
#line 178 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_cancellable_disconnect (_data_->cancellable, _data_->_tmp34_);
#line 2376 "downloader.c"
	}
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp35_ = _data_->_data103_->cached_file_stream;
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_state_ = 4;
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_output_stream_close_async ((GOutputStream*) _data_->_tmp35_, G_PRIORITY_DEFAULT, _data_->cancellable, boxes_downloader_download_from_http_ready, _data_);
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 2386 "downloader.c"
	_state_4:
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_output_stream_close_finish ((GOutputStream*) _data_->_tmp35_, _data_->_res_, &_data_->_inner_error_);
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->network_monitor);
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->connectable);
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->address);
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		block103_data_unref (_data_->_data103_);
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_data103_ = NULL;
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 180 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 2408 "downloader.c"
	}
#line 182 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp36_ = _data_->_data103_->msg;
#line 182 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_get (_data_->_tmp36_, "status-code", &_data_->_tmp37_, NULL);
#line 182 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp38_ = _data_->_tmp37_;
#line 182 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp38_ != ((guint) SOUP_STATUS_OK)) {
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp39_ = _data_->_data103_->download->cached_file;
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_file_delete (_data_->_tmp39_, NULL, &_data_->_inner_error_);
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_object_unref0 (_data_->network_monitor);
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_object_unref0 (_data_->connectable);
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_object_unref0 (_data_->address);
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			block103_data_unref (_data_->_data103_);
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_data103_ = NULL;
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_object_unref (_data_->_async_result);
#line 183 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			return FALSE;
#line 2440 "downloader.c"
		}
#line 184 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp40_ = _data_->_data103_->err;
#line 184 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (_data_->_tmp40_ == NULL) {
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_tmp41_ = _data_->_data103_->msg;
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_object_get (_data_->_tmp41_, "status-code", &_data_->_tmp42_, NULL);
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_tmp43_ = _data_->_tmp42_;
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_tmp44_ = _data_->_data103_->msg;
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_object_get (_data_->_tmp44_, "reason-phrase", &_data_->_tmp45_, NULL);
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_tmp46_ = _data_->_tmp45_;
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_tmp47_ = _data_->_tmp46_;
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_tmp48_ = g_error_new (soup_http_error_quark (), (gint) _data_->_tmp43_, "%s", _data_->_tmp47_);
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_error_free0 (_data_->_data103_->err);
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_data103_->err = _data_->_tmp48_;
#line 185 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_free0 (_data_->_tmp47_);
#line 2468 "downloader.c"
		}
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp49_ = _data_->_data103_->err;
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp50_ = _g_error_copy0 (_data_->_tmp49_);
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_inner_error_ = _data_->_tmp50_;
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->network_monitor);
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->connectable);
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->address);
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		block103_data_unref (_data_->_data103_);
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_data103_ = NULL;
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 187 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 2492 "downloader.c"
	}
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->network_monitor);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->connectable);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->address);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	block103_data_unref (_data_->_data103_);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data103_ = NULL;
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_state_ != 0) {
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2512 "downloader.c"
		}
	}
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_unref (_data_->_async_result);
#line 124 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 2519 "downloader.c"
}


static void
boxes_downloader_fetch_os_logo_data_free (gpointer _data)
{
	BoxesDownloaderFetchOsLogoData* _data_;
	_data_ = _data;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->image);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->os);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_slice_free (BoxesDownloaderFetchOsLogoData, _data_);
#line 2534 "downloader.c"
}


void
boxes_downloader_fetch_os_logo (GtkImage* image,
                                OsinfoOs* os,
                                gint size,
                                GAsyncReadyCallback _callback_,
                                gpointer _user_data_)
{
	BoxesDownloaderFetchOsLogoData* _data_;
	GtkImage* _tmp0_;
	OsinfoOs* _tmp1_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_slice_new0 (BoxesDownloaderFetchOsLogoData);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_async_result = g_task_new (NULL, NULL, _callback_, _user_data_);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_fetch_os_logo_data_free);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = _g_object_ref0 (image);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->image);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->image = _tmp0_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _g_object_ref0 (os);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->os);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->os = _tmp1_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->size = size;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_fetch_os_logo_co (_data_);
#line 2570 "downloader.c"
}


void
boxes_downloader_fetch_os_logo_finish (GAsyncResult* _res_)
{
	BoxesDownloaderFetchOsLogoData* _data_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), NULL);
#line 2580 "downloader.c"
}


static void
_vala_array_add25 (gchar** * array,
                   int* length,
                   int* size,
                   gchar* value)
{
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if ((*length) == (*size)) {
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		*size = (*size) ? (2 * (*size)) : 4;
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		*array = g_renew (gchar*, *array, (*size) + 1);
#line 2596 "downloader.c"
	}
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	(*array)[(*length)++] = value;
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	(*array)[*length] = NULL;
#line 2602 "downloader.c"
}


static void
boxes_downloader_fetch_os_logo_ready (GObject* source_object,
                                      GAsyncResult* _res_,
                                      gpointer _user_data_)
{
	BoxesDownloaderFetchOsLogoData* _data_;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = _user_data_;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_source_object_ = source_object;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_res_ = _res_;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_fetch_os_logo_co (_data_);
#line 2620 "downloader.c"
}


static gboolean
boxes_downloader_fetch_os_logo_co (BoxesDownloaderFetchOsLogoData* _data_)
{
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	switch (_data_->_state_) {
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 0:
#line 2631 "downloader.c"
		goto _state_0;
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 1:
#line 2635 "downloader.c"
		goto _state_1;
		default:
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_assert_not_reached ();
#line 2640 "downloader.c"
	}
	_state_0:
#line 192 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp0_ = boxes_downloader_fetch_os_logo_url (_data_->os);
#line 192 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->logo_url = _data_->_tmp0_;
#line 193 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp1_ = _data_->logo_url;
#line 193 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp1_ == NULL) {
#line 194 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->logo_url);
#line 194 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 194 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (_data_->_state_ != 0) {
#line 194 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 194 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2661 "downloader.c"
			}
		}
#line 194 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 194 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 2668 "downloader.c"
	}
#line 196 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp2_ = osinfo_product_get_name ((OsinfoProduct*) _data_->os);
#line 196 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp3_ = _data_->_tmp2_;
#line 196 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp4_ = _data_->logo_url;
#line 196 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_debug ("downloader.vala:196: %s has logo '%s'.", _data_->_tmp3_, _data_->_tmp4_);
#line 198 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp5_ = _data_->logo_url;
#line 198 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp6_ = g_file_new_for_uri (_data_->_tmp5_);
#line 198 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->remote_file = _data_->_tmp6_;
#line 199 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp7_ = _data_->remote_file;
#line 199 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp8_ = g_file_get_basename (_data_->_tmp7_);
#line 199 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp9_ = _data_->_tmp8_;
#line 199 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp10_ = boxes_get_system_logo_cache (_data_->_tmp9_);
#line 199 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp11_ = _data_->_tmp10_;
#line 199 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->_tmp9_);
#line 199 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->system_cached_path = _data_->_tmp11_;
#line 200 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp12_ = _data_->remote_file;
#line 200 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp13_ = g_file_get_basename (_data_->_tmp12_);
#line 200 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp14_ = _data_->_tmp13_;
#line 200 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp15_ = boxes_get_logo_cache (_data_->_tmp14_);
#line 200 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp16_ = _data_->_tmp15_;
#line 200 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->_tmp14_);
#line 200 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_path = _data_->_tmp16_;
#line 202 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp17_ = _data_->cached_path;
#line 202 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp18_ = g_strdup (_data_->_tmp17_);
#line 202 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp19_ = g_new0 (gchar*, 1 + 1);
#line 202 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp19_[0] = _data_->_tmp18_;
#line 202 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_paths = _data_->_tmp19_;
#line 202 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_paths_length1 = 1;
#line 202 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_cached_paths_size_ = _data_->cached_paths_length1;
#line 203 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp20_ = _data_->system_cached_path;
#line 203 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp20_ != NULL) {
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp21_ = _data_->cached_paths;
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp21__length1 = _data_->cached_paths_length1;
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp22_ = _data_->system_cached_path;
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp23_ = g_strdup (_data_->_tmp22_);
#line 204 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_vala_array_add25 (&_data_->cached_paths, &_data_->cached_paths_length1, &_data_->_cached_paths_size_, _data_->_tmp23_);
#line 2740 "downloader.c"
	}
	{
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp24_ = boxes_downloader_get_instance ();
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp25_ = _data_->_tmp24_;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp26_ = _data_->remote_file;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp27_ = _data_->cached_paths;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp27__length1 = _data_->cached_paths_length1;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp28_ = boxes_activity_progress_new ();
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp29_ = _data_->_tmp28_;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_state_ = 1;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		boxes_downloader_download (_data_->_tmp25_, _data_->_tmp26_, _data_->_tmp27_, _data_->_tmp27__length1, _data_->_tmp29_, NULL, boxes_downloader_fetch_os_logo_ready, _data_);
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 2763 "downloader.c"
		_state_1:
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp30_ = boxes_downloader_download_finish (_data_->_tmp25_, _data_->_res_, &_data_->_inner_error_);
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp31_ = _data_->_tmp30_;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->_tmp29_);
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->_tmp25_);
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->cached_file = _data_->_tmp31_;
#line 207 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 2777 "downloader.c"
			goto __catch154_g_error;
		}
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp32_ = _data_->cached_file;
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp33_ = g_file_get_path (_data_->_tmp32_);
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp34_ = _data_->_tmp33_;
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp35_ = gdk_pixbuf_new_from_file_at_size (_data_->_tmp34_, _data_->size, _data_->size, &_data_->_inner_error_);
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp36_ = _data_->_tmp35_;
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->_tmp34_);
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->pixbuf = _data_->_tmp36_;
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 208 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_object_unref0 (_data_->cached_file);
#line 2798 "downloader.c"
			goto __catch154_g_error;
		}
#line 209 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp37_ = _data_->pixbuf;
#line 209 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		gtk_image_set_from_pixbuf (_data_->image, _data_->_tmp37_);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->pixbuf);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->cached_file);
#line 2809 "downloader.c"
	}
	goto __finally154;
	__catch154_g_error:
	{
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_inner_error_ = NULL;
#line 211 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp38_ = _data_->logo_url;
#line 211 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp39_ = _data_->_error_;
#line 211 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp40_ = _data_->_tmp39_->message;
#line 211 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_warning ("downloader.vala:211: Error loading logo file '%s': %s", _data_->_tmp38_, _data_->_tmp40_);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_error_free0 (_data_->_error_);
#line 2828 "downloader.c"
	}
	__finally154:
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->cached_paths = (_vala_array_free (_data_->cached_paths, _data_->cached_paths_length1, (GDestroyNotify) g_free), NULL);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->cached_path);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->system_cached_path);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->remote_file);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->logo_url);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_clear_error (&_data_->_inner_error_);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 206 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 2851 "downloader.c"
	}
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_paths = (_vala_array_free (_data_->cached_paths, _data_->cached_paths_length1, (GDestroyNotify) g_free), NULL);
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->cached_path);
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->system_cached_path);
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->remote_file);
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->logo_url);
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_state_ != 0) {
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 2871 "downloader.c"
		}
	}
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_unref (_data_->_async_result);
#line 191 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 2878 "downloader.c"
}


static void
boxes_downloader_fetch_media_data_free (gpointer _data)
{
	BoxesDownloaderFetchMediaData* _data_;
	_data_ = _data;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->uri);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->filename);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->result);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_slice_free (BoxesDownloaderFetchMediaData, _data_);
#line 2899 "downloader.c"
}


void
boxes_downloader_fetch_media (const gchar* uri,
                              const gchar* filename,
                              BoxesActivityProgress* progress,
                              GCancellable* cancellable,
                              GAsyncReadyCallback _callback_,
                              gpointer _user_data_)
{
	BoxesDownloaderFetchMediaData* _data_;
	gchar* _tmp0_;
	gchar* _tmp1_;
	BoxesActivityProgress* _tmp2_;
	GCancellable* _tmp3_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_slice_new0 (BoxesDownloaderFetchMediaData);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_async_result = g_task_new (NULL, cancellable, _callback_, _user_data_);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_fetch_media_data_free);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = g_strdup (uri);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->uri);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->uri = _tmp0_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = g_strdup (filename);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->filename);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->filename = _tmp1_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = _g_object_ref0 (progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->progress = _tmp2_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp3_ = _g_object_ref0 (cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cancellable = _tmp3_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_fetch_media_co (_data_);
#line 2948 "downloader.c"
}


gchar*
boxes_downloader_fetch_media_finish (GAsyncResult* _res_,
                                     GError** error)
{
	gchar* result;
	BoxesDownloaderFetchMediaData* _data_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (NULL == _data_) {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return NULL;
#line 2964 "downloader.c"
	}
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	result = _data_->result;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->result = NULL;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return result;
#line 2972 "downloader.c"
}


static void
boxes_downloader_fetch_media_ready (GObject* source_object,
                                    GAsyncResult* _res_,
                                    gpointer _user_data_)
{
	BoxesDownloaderFetchMediaData* _data_;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = _user_data_;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_source_object_ = source_object;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_res_ = _res_;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_fetch_media_co (_data_);
#line 2990 "downloader.c"
}


static gboolean
boxes_downloader_fetch_media_co (BoxesDownloaderFetchMediaData* _data_)
{
#line 215 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	switch (_data_->_state_) {
#line 215 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 0:
#line 3001 "downloader.c"
		goto _state_0;
#line 215 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 1:
#line 3005 "downloader.c"
		goto _state_1;
		default:
#line 215 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_assert_not_reached ();
#line 3010 "downloader.c"
	}
	_state_0:
#line 219 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp0_ = g_file_new_for_uri (_data_->uri);
#line 219 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->file = _data_->_tmp0_;
#line 220 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->basename = NULL;
#line 222 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->filename == NULL) {
#line 223 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp1_ = _data_->file;
#line 223 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp2_ = g_file_get_basename (_data_->_tmp1_);
#line 223 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->basename);
#line 223 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->basename = _data_->_tmp2_;
#line 3029 "downloader.c"
	} else {
#line 225 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp3_ = g_strdup (_data_->filename);
#line 225 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->basename);
#line 225 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->basename = _data_->_tmp3_;
#line 3037 "downloader.c"
	}
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp6_ = _data_->basename;
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp6_ != NULL) {
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp7_ = _data_->basename;
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp5_ = g_strcmp0 (_data_->_tmp7_, "") != 0;
#line 3047 "downloader.c"
	} else {
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp5_ = FALSE;
#line 3051 "downloader.c"
	}
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp5_) {
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp8_ = _data_->basename;
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp4_ = g_strcmp0 (_data_->_tmp8_, "/") != 0;
#line 3059 "downloader.c"
	} else {
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp4_ = FALSE;
#line 3063 "downloader.c"
	}
#line 228 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (_data_->_tmp4_, NULL);
#line 230 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp9_ = boxes_downloader_get_instance ();
#line 230 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->downloader = _data_->_tmp9_;
#line 231 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp10_ = g_get_user_special_dir (G_USER_DIRECTORY_DOWNLOAD);
#line 231 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp11_ = _data_->basename;
#line 231 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp12_ = g_build_filename (_data_->_tmp10_, _data_->_tmp11_, NULL);
#line 231 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cache = _data_->_tmp12_;
#line 234 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_activity_progress_set_progress (_data_->progress, (gdouble) 0);
#line 235 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_debug ("downloader.vala:235: Downloading media from '%s' to '%s'.", _data_->uri, _data_->cache);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp13_ = _data_->file;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp14_ = g_strdup (_data_->cache);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp15_ = g_new0 (gchar*, 1 + 1);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp15_[0] = _data_->_tmp14_;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp16_ = _data_->_tmp15_;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp16__length1 = 1;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_state_ = 1;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_download (_data_->downloader, _data_->_tmp13_, _data_->_tmp16_, 1, _data_->progress, _data_->cancellable, boxes_downloader_fetch_media_ready, _data_);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 3101 "downloader.c"
	_state_1:
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp17_ = boxes_downloader_download_finish (_data_->downloader, _data_->_res_, &_data_->_inner_error_);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp18_ = _data_->_tmp17_;
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->_tmp18_);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp16_ = (_vala_array_free (_data_->_tmp16_, _data_->_tmp16__length1, (GDestroyNotify) g_free), NULL);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->cache);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->downloader);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->basename);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->file);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 236 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 3127 "downloader.c"
	}
#line 237 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_activity_progress_set_progress (_data_->progress, (gdouble) 1);
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->result = _data_->cache;
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->downloader);
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->basename);
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->file);
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_state_ != 0) {
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3147 "downloader.c"
		}
	}
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_unref (_data_->_async_result);
#line 239 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 3154 "downloader.c"
}


static void
boxes_downloader_await_download_data_free (gpointer _data)
{
	BoxesDownloaderAwaitDownloadData* _data_;
	_data_ = _data;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->cached_path);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->result);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->self);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_slice_free (BoxesDownloaderAwaitDownloadData, _data_);
#line 3173 "downloader.c"
}


static void
boxes_downloader_await_download (BoxesDownloader* self,
                                 BoxesDownload* download,
                                 const gchar* cached_path,
                                 BoxesActivityProgress* progress,
                                 GAsyncReadyCallback _callback_,
                                 gpointer _user_data_)
{
	BoxesDownloaderAwaitDownloadData* _data_;
	BoxesDownloader* _tmp0_;
	BoxesDownload* _tmp1_;
	gchar* _tmp2_;
	BoxesActivityProgress* _tmp3_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_slice_new0 (BoxesDownloaderAwaitDownloadData);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), NULL, _callback_, _user_data_);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_await_download_data_free);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->self = _tmp0_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _boxes_download_ref0 (download);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_boxes_download_unref0 (_data_->download);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->download = _tmp1_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = g_strdup (cached_path);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->cached_path);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cached_path = _tmp2_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp3_ = _g_object_ref0 (progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->progress);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->progress = _tmp3_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_await_download_co (_data_);
#line 3220 "downloader.c"
}


static GFile*
boxes_downloader_await_download_finish (BoxesDownloader* self,
                                        GAsyncResult* _res_,
                                        GError** error)
{
	GFile* result;
	BoxesDownloaderAwaitDownloadData* _data_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (NULL == _data_) {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return NULL;
#line 3237 "downloader.c"
	}
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	result = _data_->result;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->result = NULL;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return result;
#line 3245 "downloader.c"
}


static Block104Data*
block104_data_ref (Block104Data* _data104_)
{
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_atomic_int_inc (&_data104_->_ref_count_);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return _data104_;
#line 3256 "downloader.c"
}


static void
block104_data_unref (void * _userdata_)
{
	Block104Data* _data104_;
	_data104_ = (Block104Data*) _userdata_;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (g_atomic_int_dec_and_test (&_data104_->_ref_count_)) {
#line 3267 "downloader.c"
		BoxesDownloader* self;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		self = _data104_->self;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		(_data104_->callback_target_destroy_notify == NULL) ? NULL : (_data104_->callback_target_destroy_notify (_data104_->callback_target), NULL);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data104_->callback = NULL;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data104_->callback_target = NULL;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data104_->callback_target_destroy_notify = NULL;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_error_free0 (_data104_->download_error);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data104_->downloaded_file);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_boxes_download_unref0 (_data104_->download);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (self);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_slice_free (Block104Data, _data104_);
#line 3289 "downloader.c"
	}
}


static gboolean
_boxes_downloader_await_download_co_gsource_func (gpointer self)
{
	gboolean result;
	result = boxes_downloader_await_download_co (self);
#line 249 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return result;
#line 3301 "downloader.c"
}


static void
__lambda66_ (Block104Data* _data104_,
             BoxesDownloader* downloader,
             BoxesDownload* downloaded)
{
	BoxesDownloader* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GFile* _tmp2_;
	GFile* _tmp3_;
#line 250 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = _data104_->self;
#line 250 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (downloader != NULL);
#line 250 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (downloaded != NULL);
#line 251 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = downloaded->uri;
#line 251 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _data104_->download->uri;
#line 251 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
#line 252 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return;
#line 3329 "downloader.c"
	}
#line 254 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = downloaded->cached_file;
#line 254 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp3_ = _g_object_ref0 (_tmp2_);
#line 254 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data104_->downloaded_file);
#line 254 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data104_->downloaded_file = _tmp3_;
#line 255 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data104_->callback (_data104_->callback_target);
#line 3341 "downloader.c"
}


static void
___lambda66__boxes_downloader_downloaded (BoxesDownloader* _sender,
                                          BoxesDownload* download,
                                          gpointer self)
{
#line 250 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	__lambda66_ (self, _sender, download);
#line 3352 "downloader.c"
}


static void
__lambda67_ (Block104Data* _data104_,
             BoxesDownloader* downloader,
             BoxesDownload* failed_download,
             GError* _error_)
{
	BoxesDownloader* self;
	const gchar* _tmp0_;
	const gchar* _tmp1_;
	GError* _tmp2_;
#line 257 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = _data104_->self;
#line 257 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (downloader != NULL);
#line 257 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (failed_download != NULL);
#line 258 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = failed_download->uri;
#line 258 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _data104_->download->uri;
#line 258 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (g_strcmp0 (_tmp0_, _tmp1_) != 0) {
#line 259 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return;
#line 3380 "downloader.c"
	}
#line 261 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = _g_error_copy0 (_error_);
#line 261 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_error_free0 (_data104_->download_error);
#line 261 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data104_->download_error = _tmp2_;
#line 262 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data104_->callback (_data104_->callback_target);
#line 3390 "downloader.c"
}


static void
___lambda67__boxes_downloader_download_failed (BoxesDownloader* _sender,
                                               BoxesDownload* download,
                                               GError* _error_,
                                               gpointer self)
{
#line 257 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	__lambda67_ (self, _sender, download, _error_);
#line 3402 "downloader.c"
}


static void
boxes_downloader_await_download_ready (GObject* source_object,
                                       GAsyncResult* _res_,
                                       gpointer _user_data_)
{
	BoxesDownloaderAwaitDownloadData* _data_;
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = _user_data_;
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_source_object_ = source_object;
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_res_ = _res_;
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_await_download_co (_data_);
#line 3420 "downloader.c"
}


static gboolean
boxes_downloader_await_download_co (BoxesDownloaderAwaitDownloadData* _data_)
{
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	switch (_data_->_state_) {
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 0:
#line 3431 "downloader.c"
		goto _state_0;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 1:
#line 3435 "downloader.c"
		goto _state_1;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 2:
#line 3439 "downloader.c"
		goto _state_2;
		default:
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_assert_not_reached ();
#line 3444 "downloader.c"
	}
	_state_0:
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_ = g_slice_new0 (Block104Data);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->_ref_count_ = 1;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->self = g_object_ref (_data_->self);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_boxes_download_unref0 (_data_->_data104_->download);
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->download = _data_->download;
#line 242 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->_async_data_ = _data_;
#line 245 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->downloaded_file = NULL;
#line 246 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->download_error = NULL;
#line 248 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp0_ = _data_->_data104_->download->progress;
#line 248 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_bind_property_with_closures ((GObject*) _data_->_tmp0_, "progress", (GObject*) _data_->progress, "progress", G_BINDING_SYNC_CREATE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, (GClosureNotify) NULL)));
#line 249 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->callback = _boxes_downloader_await_download_co_gsource_func;
#line 249 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->callback_target = _data_;
#line 249 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_->callback_target_destroy_notify = NULL;
#line 250 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp1_ = g_signal_connect_data (_data_->self, "downloaded", (GCallback) ___lambda66__boxes_downloader_downloaded, block104_data_ref (_data_->_data104_), (GClosureNotify) block104_data_unref, 0);
#line 250 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->downloaded_id = _data_->_tmp1_;
#line 257 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp2_ = g_signal_connect_data (_data_->self, "download-failed", (GCallback) ___lambda67__boxes_downloader_download_failed, block104_data_ref (_data_->_data104_), (GClosureNotify) block104_data_unref, 0);
#line 257 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->downloaded_failed_id = _data_->_tmp2_;
#line 265 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp3_ = _data_->_data104_->download->uri;
#line 265 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_debug ("downloader.vala:265: '%s' already being downloaded. Waiting for downlo" \
"ad to complete..", _data_->_tmp3_);
#line 266 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_state_ = 1;
#line 266 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 3489 "downloader.c"
	_state_1:
	;
#line 267 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp4_ = _data_->_data104_->download->uri;
#line 267 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_debug ("downloader.vala:267: Finished waiting for '%s' to download.", _data_->_tmp4_);
#line 268 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->downloaded_id);
#line 269 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_signal_handler_disconnect ((GObject*) _data_->self, _data_->downloaded_failed_id);
#line 271 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_data104_->download_error != NULL) {
#line 272 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp5_ = _g_error_copy0 (_data_->_data104_->download_error);
#line 272 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_inner_error_ = _data_->_tmp5_;
#line 272 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 272 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		block104_data_unref (_data_->_data104_);
#line 272 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_data104_ = NULL;
#line 272 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 272 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 3516 "downloader.c"
	}
#line 275 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp6_ = g_file_get_path (_data_->_data104_->downloaded_file);
#line 275 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp7_ = _data_->_tmp6_;
#line 275 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp8_ = g_strcmp0 (_data_->_tmp7_, _data_->cached_path) != 0;
#line 275 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_free0 (_data_->_tmp7_);
#line 275 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_tmp8_) {
#line 276 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp9_ = g_file_new_for_path (_data_->cached_path);
#line 276 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->cached_file);
#line 276 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->cached_file = _data_->_tmp9_;
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp10_ = _data_->cached_file;
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_state_ = 2;
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_file_copy_async (_data_->_data104_->downloaded_file, _data_->_tmp10_, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, NULL, NULL, NULL, boxes_downloader_await_download_ready, _data_);
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 3542 "downloader.c"
		_state_2:
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_file_copy_finish (_data_->_data104_->downloaded_file, _data_->_res_, &_data_->_inner_error_);
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_g_object_unref0 (_data_->cached_file);
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			block104_data_unref (_data_->_data104_);
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_data_->_data104_ = NULL;
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_object_unref (_data_->_async_result);
#line 277 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			return FALSE;
#line 3560 "downloader.c"
		}
	} else {
#line 279 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp11_ = _g_object_ref0 (_data_->_data104_->downloaded_file);
#line 279 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->cached_file);
#line 279 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->cached_file = _data_->_tmp11_;
#line 3569 "downloader.c"
	}
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->result = _data_->cached_file;
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	block104_data_unref (_data_->_data104_);
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data104_ = NULL;
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_state_ != 0) {
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3585 "downloader.c"
		}
	}
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_unref (_data_->_async_result);
#line 281 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 3592 "downloader.c"
}


static void
boxes_downloader_download_from_filesystem_data_free (gpointer _data)
{
	BoxesDownloaderDownloadFromFilesystemData* _data_;
	_data_ = _data;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->self);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_slice_free (BoxesDownloaderDownloadFromFilesystemData, _data_);
#line 3607 "downloader.c"
}


static void
boxes_downloader_download_from_filesystem (BoxesDownloader* self,
                                           BoxesDownload* download,
                                           GCancellable* cancellable,
                                           GAsyncReadyCallback _callback_,
                                           gpointer _user_data_)
{
	BoxesDownloaderDownloadFromFilesystemData* _data_;
	BoxesDownloader* _tmp0_;
	BoxesDownload* _tmp1_;
	GCancellable* _tmp2_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_slice_new0 (BoxesDownloaderDownloadFromFilesystemData);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_async_result = g_task_new (G_OBJECT (self), cancellable, _callback_, _user_data_);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_set_task_data (_data_->_async_result, _data_, boxes_downloader_download_from_filesystem_data_free);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = _g_object_ref0 (self);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->self = _tmp0_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = _boxes_download_ref0 (download);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_boxes_download_unref0 (_data_->download);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->download = _tmp1_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = _g_object_ref0 (cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->cancellable);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->cancellable = _tmp2_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_download_from_filesystem_co (_data_);
#line 3646 "downloader.c"
}


static void
boxes_downloader_download_from_filesystem_finish (BoxesDownloader* self,
                                                  GAsyncResult* _res_,
                                                  GError** error)
{
	BoxesDownloaderDownloadFromFilesystemData* _data_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = g_task_propagate_pointer (G_TASK (_res_), error);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (NULL == _data_) {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return;
#line 3662 "downloader.c"
	}
}


static Block105Data*
block105_data_ref (Block105Data* _data105_)
{
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_atomic_int_inc (&_data105_->_ref_count_);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return _data105_;
#line 3674 "downloader.c"
}


static void
block105_data_unref (void * _userdata_)
{
	Block105Data* _data105_;
	_data105_ = (Block105Data*) _userdata_;
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (g_atomic_int_dec_and_test (&_data105_->_ref_count_)) {
#line 3685 "downloader.c"
		BoxesDownloader* self;
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		self = _data105_->self;
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_boxes_download_unref0 (_data105_->download);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (self);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_slice_free (Block105Data, _data105_);
#line 3695 "downloader.c"
	}
}


static void
___lambda72_ (Block105Data* _data105_,
              gint64 current,
              gint64 total)
{
	BoxesDownloader* self;
	BoxesActivityProgress* _tmp0_;
#line 295 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = _data105_->self;
#line 296 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = _data105_->download->progress;
#line 296 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_activity_progress_set_progress (_tmp0_, ((gdouble) current) / total);
#line 3713 "downloader.c"
}


static void
____lambda72__gfile_progress_callback (gint64 current_num_bytes,
                                       gint64 total_num_bytes,
                                       gpointer self)
{
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	___lambda72_ (self, current_num_bytes, total_num_bytes);
#line 3724 "downloader.c"
}


static void
boxes_downloader_download_from_filesystem_ready (GObject* source_object,
                                                 GAsyncResult* _res_,
                                                 gpointer _user_data_)
{
	BoxesDownloaderDownloadFromFilesystemData* _data_;
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_ = _user_data_;
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_source_object_ = source_object;
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_res_ = _res_;
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_download_from_filesystem_co (_data_);
#line 3742 "downloader.c"
}


static gboolean
boxes_downloader_download_from_filesystem_co (BoxesDownloaderDownloadFromFilesystemData* _data_)
{
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	switch (_data_->_state_) {
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 0:
#line 3753 "downloader.c"
		goto _state_0;
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		case 1:
#line 3757 "downloader.c"
		goto _state_1;
		default:
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_assert_not_reached ();
#line 3762 "downloader.c"
	}
	_state_0:
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data105_ = g_slice_new0 (Block105Data);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data105_->_ref_count_ = 1;
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data105_->self = g_object_ref (_data_->self);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_boxes_download_unref0 (_data_->_data105_->download);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data105_->download = _data_->download;
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data105_->_async_data_ = _data_;
#line 286 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp0_ = _data_->_data105_->download->remote_file;
#line 286 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp1_ = _g_object_ref0 (_data_->_tmp0_);
#line 286 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->src_file = _data_->_tmp1_;
#line 287 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp2_ = _data_->_data105_->download->cached_file;
#line 287 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_tmp3_ = _g_object_ref0 (_data_->_tmp2_);
#line 287 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->dest_file = _data_->_tmp3_;
#line 3789 "downloader.c"
	{
#line 290 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp4_ = g_file_get_path (_data_->src_file);
#line 290 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp5_ = _data_->_tmp4_;
#line 290 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp6_ = g_file_get_path (_data_->dest_file);
#line 290 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp7_ = _data_->_tmp6_;
#line 290 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_debug ("downloader.vala:290: Copying '%s' to '%s'..", _data_->_tmp5_, _data_->_tmp7_);
#line 290 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->_tmp7_);
#line 290 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->_tmp5_);
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_state_ = 1;
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_file_copy_async (_data_->src_file, _data_->dest_file, G_FILE_COPY_OVERWRITE, G_PRIORITY_DEFAULT, _data_->cancellable, ____lambda72__gfile_progress_callback, _data_->_data105_, boxes_downloader_download_from_filesystem_ready, _data_);
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 3811 "downloader.c"
		_state_1:
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_file_copy_finish (_data_->src_file, _data_->_res_, &_data_->_inner_error_);
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 291 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			if (g_error_matches (_data_->_inner_error_, G_IO_ERROR, G_IO_ERROR_EXISTS)) {
#line 3819 "downloader.c"
				goto __catch155_g_io_error_exists;
			}
			goto __finally155;
		}
#line 298 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp8_ = g_file_get_path (_data_->src_file);
#line 298 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp9_ = _data_->_tmp8_;
#line 298 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp10_ = g_file_get_path (_data_->dest_file);
#line 298 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_tmp11_ = _data_->_tmp10_;
#line 298 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_debug ("downloader.vala:298: Copied '%s' to '%s'.", _data_->_tmp9_, _data_->_tmp11_);
#line 298 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->_tmp11_);
#line 298 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_free0 (_data_->_tmp9_);
#line 3838 "downloader.c"
	}
	goto __finally155;
	__catch155_g_io_error_exists:
	{
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_error_ = _data_->_inner_error_;
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_inner_error_ = NULL;
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_error_free0 (_data_->_error_);
#line 3849 "downloader.c"
	}
	__finally155:
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_task_return_error (_data_->_async_result, _data_->_inner_error_);
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->dest_file);
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_g_object_unref0 (_data_->src_file);
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		block105_data_unref (_data_->_data105_);
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		_data_->_data105_ = NULL;
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		g_object_unref (_data_->_async_result);
#line 289 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		return FALSE;
#line 3868 "downloader.c"
	}
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->dest_file);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (_data_->src_file);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	block105_data_unref (_data_->_data105_);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_data_->_data105_ = NULL;
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_task_return_pointer (_data_->_async_result, _data_, NULL);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (_data_->_state_ != 0) {
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		while (g_task_get_completed (_data_->_async_result) != TRUE) {
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			g_main_context_iteration (g_task_get_context (_data_->_async_result), TRUE);
#line 3886 "downloader.c"
		}
	}
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_object_unref (_data_->_async_result);
#line 284 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return FALSE;
#line 3893 "downloader.c"
}


static GFile*
boxes_downloader_get_cached_file (BoxesDownloader* self,
                                  GFile* remote_file,
                                  gchar** cached_paths,
                                  int cached_paths_length1)
{
	GFile* result = NULL;
#line 302 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 302 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_val_if_fail (remote_file != NULL, NULL);
#line 3908 "downloader.c"
	{
		gchar** path_collection = NULL;
		gint path_collection_length1 = 0;
		gint _path_collection_size_ = 0;
		gint path_it = 0;
#line 303 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		path_collection = cached_paths;
#line 303 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		path_collection_length1 = cached_paths_length1;
#line 303 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		for (path_it = 0; path_it < cached_paths_length1; path_it = path_it + 1) {
#line 3920 "downloader.c"
			gchar* _tmp0_;
			gchar* path = NULL;
#line 303 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			_tmp0_ = g_strdup (path_collection[path_it]);
#line 303 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
			path = _tmp0_;
#line 3927 "downloader.c"
			{
				GFile* cached_file = NULL;
				const gchar* _tmp1_;
				GFile* _tmp2_;
				GFile* _tmp3_;
#line 304 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				_tmp1_ = path;
#line 304 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				_tmp2_ = g_file_new_for_path (_tmp1_);
#line 304 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				cached_file = _tmp2_;
#line 305 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				_tmp3_ = cached_file;
#line 305 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				if (g_file_query_exists (_tmp3_, NULL)) {
#line 3943 "downloader.c"
					gchar* _tmp4_;
					gchar* _tmp5_;
					const gchar* _tmp6_;
#line 306 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
					_tmp4_ = g_file_get_uri (remote_file);
#line 306 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
					_tmp5_ = _tmp4_;
#line 306 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
					_tmp6_ = path;
#line 306 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
					g_debug ("downloader.vala:306: '%s' already available locally at '%s'. Not downl" \
"oading.", _tmp5_, _tmp6_);
#line 306 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
					_g_free0 (_tmp5_);
#line 307 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
					result = cached_file;
#line 307 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
					_g_free0 (path);
#line 307 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
					return result;
#line 3963 "downloader.c"
				}
#line 303 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				_g_object_unref0 (cached_file);
#line 303 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
				_g_free0 (path);
#line 3969 "downloader.c"
			}
		}
	}
#line 311 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	result = NULL;
#line 311 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	return result;
#line 3977 "downloader.c"
}


static void
g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD (GClosure * closure,
                                              GValue * return_value,
                                              guint n_param_values,
                                              const GValue * param_values,
                                              gpointer invocation_hint,
                                              gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXES_DOWNLOAD) (gpointer data1, gpointer arg_1, gpointer data2);
	register GMarshalFunc_VOID__BOXES_DOWNLOAD callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (n_param_values == 2);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		data1 = closure->data;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		data2 = param_values->data[0].v_pointer;
#line 4003 "downloader.c"
	} else {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		data1 = param_values->data[0].v_pointer;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		data2 = closure->data;
#line 4009 "downloader.c"
	}
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	callback = (GMarshalFunc_VOID__BOXES_DOWNLOAD) (marshal_data ? marshal_data : cc->callback);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	callback (data1, boxes_value_get_download (param_values + 1), data2);
#line 4015 "downloader.c"
}


static void
g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD_POINTER (GClosure * closure,
                                                      GValue * return_value,
                                                      guint n_param_values,
                                                      const GValue * param_values,
                                                      gpointer invocation_hint,
                                                      gpointer marshal_data)
{
	typedef void (*GMarshalFunc_VOID__BOXES_DOWNLOAD_POINTER) (gpointer data1, gpointer arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__BOXES_DOWNLOAD_POINTER callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_return_if_fail (n_param_values == 3);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	if (G_CCLOSURE_SWAP_DATA (closure)) {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		data1 = closure->data;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		data2 = param_values->data[0].v_pointer;
#line 4041 "downloader.c"
	} else {
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		data1 = param_values->data[0].v_pointer;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
		data2 = closure->data;
#line 4047 "downloader.c"
	}
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	callback = (GMarshalFunc_VOID__BOXES_DOWNLOAD_POINTER) (marshal_data ? marshal_data : cc->callback);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	callback (data1, boxes_value_get_download (param_values + 1), g_value_get_pointer (param_values + 2), data2);
#line 4053 "downloader.c"
}


static void
boxes_downloader_class_init (BoxesDownloaderClass * klass)
{
	gchar* _tmp0_;
	gchar* _tmp1_;
	gchar** _tmp2_;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_parent_class = g_type_class_peek_parent (klass);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	g_type_class_add_private (klass, sizeof (BoxesDownloaderPrivate));
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	G_OBJECT_CLASS (klass)->finalize = boxes_downloader_finalize;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_signals[BOXES_DOWNLOADER_DOWNLOADED_SIGNAL] = g_signal_new ("downloaded", BOXES_TYPE_DOWNLOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD, G_TYPE_NONE, 1, BOXES_TYPE_DOWNLOAD);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_signals[BOXES_DOWNLOADER_DOWNLOAD_FAILED_SIGNAL] = g_signal_new ("download-failed", BOXES_TYPE_DOWNLOADER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__BOXES_DOWNLOAD_POINTER, G_TYPE_NONE, 2, BOXES_TYPE_DOWNLOAD, G_TYPE_POINTER);
#line 26 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp0_ = g_strdup ("http");
#line 26 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp1_ = g_strdup ("https");
#line 26 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_ = g_new0 (gchar*, 2 + 1);
#line 26 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_[0] = _tmp0_;
#line 26 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_tmp2_[1] = _tmp1_;
#line 26 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_supported_schemes = _tmp2_;
#line 26 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	boxes_downloader_supported_schemes_length1 = 2;
#line 4087 "downloader.c"
}


static void
boxes_downloader_instance_init (BoxesDownloader * self)
{
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self->priv = BOXES_DOWNLOADER_GET_PRIVATE (self);
#line 4096 "downloader.c"
}


static void
boxes_downloader_finalize (GObject * obj)
{
	BoxesDownloader * self;
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BOXES_TYPE_DOWNLOADER, BoxesDownloader);
#line 19 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_object_unref0 (self->priv->session);
#line 21 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	_g_hash_table_unref0 (self->priv->downloads);
#line 17 "/home/fborges/checkout/gnome-boxes/src/downloader.vala"
	G_OBJECT_CLASS (boxes_downloader_parent_class)->finalize (obj);
#line 4112 "downloader.c"
}


GType
boxes_downloader_get_type (void)
{
	static volatile gsize boxes_downloader_type_id__volatile = 0;
	if (g_once_init_enter (&boxes_downloader_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BoxesDownloaderClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) boxes_downloader_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BoxesDownloader), 0, (GInstanceInitFunc) boxes_downloader_instance_init, NULL };
		GType boxes_downloader_type_id;
		boxes_downloader_type_id = g_type_register_static (G_TYPE_OBJECT, "BoxesDownloader", &g_define_type_info, 0);
		g_once_init_leave (&boxes_downloader_type_id__volatile, boxes_downloader_type_id);
	}
	return boxes_downloader_type_id__volatile;
}


static void
_vala_array_destroy (gpointer array,
                     gint array_length,
                     GDestroyNotify destroy_func)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	if ((array != NULL) && (destroy_func != NULL)) {
#line 4137 "downloader.c"
		int i;
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
		for (i = 0; i < array_length; i = i + 1) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
			if (((gpointer*) array)[i] != NULL) {
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
				destroy_func (((gpointer*) array)[i]);
#line 4145 "downloader.c"
			}
		}
	}
}


static void
_vala_array_free (gpointer array,
                  gint array_length,
                  GDestroyNotify destroy_func)
{
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	_vala_array_destroy (array, array_length, destroy_func);
#line 535 "/home/fborges/checkout/gnome-boxes/src/libvirt-machine.vala"
	g_free (array);
#line 4161 "downloader.c"
}



