/**
 * vim: sw=4 ts=4:
 *
 * 	(C) 1998 Lalo Martins <lalo@debian.org>
 * 	    2002-2005 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#ifndef GDEB_GDEB_H
#define GDEB_GDEB_H

#include <gtk/gtk.h>
#include <string>
#include <vector>

using namespace std;

class GDeb
{
public:

  class Package;

  struct Config {
    bool adv_mode : 1;
    bool show_special : 1;
    bool allow_install : 1;
    bool show_unknown : 1;
    bool use_notebook : 1;
    bool horizontal : 1;
    bool show_title : 1;

    bool operator==(const Config & rhs) {
      return rhs.adv_mode == adv_mode &&
      rhs.show_special == show_special &&
      rhs.allow_install == allow_install && 
      rhs.show_unknown == show_unknown &&
      rhs.use_notebook == use_notebook &&
      rhs.horizontal == horizontal;
    }

    Config() :
      adv_mode(false),
      show_special(true),
      allow_install(true),
      show_unknown(true),
      use_notebook(true),
      horizontal(false),
      show_title(true)
      {}

    // default copy constructor/assignment is fine
  };

	enum PageType {
		PageDescription, PageContents, PageLinks, PageTypeEnd
	};

  const Config& config() const { return conf_; }

  GDeb(const string & app_name);

  virtual ~GDeb();

  // get the toplevel widget
  GtkWidget* widget(); 

  // sets the current page
  void set_page (PageType p);

  // changes the package data
  void set_package (Package* pkg);

  // Install new config.
  void set_config (const Config & c);

protected:

  Config conf_;

  GtkWidget* toplevel_;
  GtkWidget* title_;
  GtkWidget* package_;
  GtkWidget* short_desc_;

  GtkWidget* status_;
  GtkWidget* installed_size_;
  GtkWidget* section_;
  GtkWidget* priority_;
  GtkWidget* size_;

  GtkWidget* notebook_;

  GtkWidget* pages_[PageTypeEnd];

  GtkWidget* long_desc_;

  Package* pkg_;

  string name_;

  // rebuilds the widgets to match configuration
  // set_config nukes any widgets that need to go away
  void rebuild ();  
  
  // fill in info in widgets to reflect current package.
  void refresh();


  // private to prevent use
  GDeb(const GDeb &);
};

class GDeb::Package
{
public:
	virtual ~Package (void) {};
  virtual string Name() = 0;
  virtual string Version() = 0;
  virtual string Description_Short() = 0;
  virtual string Description_Long() = 0;
  virtual string Section() = 0;
  virtual string Priority() = 0;
  virtual string Size() = 0;
  virtual string Installed_Size() = 0;
  virtual string Maintainer() = 0;
  virtual string PackageStatus() = 0;
  virtual string Current_Version() = 0;
  virtual string Architecture() = 0;
  virtual string Source() = 0;
  virtual string Filename() = 0;
	virtual string Filelist (void) = 0;
	virtual string Author (void) = 0;
	virtual string Homepage (void) = 0;
  virtual bool   Essential() = 0;
  virtual bool   Downloadable() = 0;
  virtual bool   Automatic()    = 0;
  virtual vector<string> Provides() = 0;
  virtual vector<string> PreDepends() = 0;
  virtual vector<string> Depends() = 0;
  virtual vector<string> Recommends() = 0;
  virtual vector<string> Suggests() = 0;
  virtual vector<string> Conflicts() = 0;
  virtual vector<string> Replaces() = 0;
  
  // Actions
  virtual void Install() = 0;
  virtual void Delete() = 0;
  virtual void Keep() = 0;

};

#endif
