/** -*- Mode: C++; tab-width: 4 -*-
 * vim: sw=4 ts=4:
 *
 * Gnome Apt progress indicator dialog class
 *
 * 	(C) 1998 Havoc Pennington <hp@pobox.com>
 * 	    2002, 2003 Filip Van Raemdonck <mechanix@debian.org>
 *
 * This program is free software; you can redistribute it and/or 
 * modify it under the terms of the GNU General Public License as 
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307
 * USA
 *
 * 	$Id$
 *
 **/

#include <gtk/gtk.h>

#include "dialogprogress.h"

void 
OpDialogProgress::Update()
{
   if (CheckChange() == false)
      return;

   char s[300];
   
	if (MajorChange) {
		const gchar* str = Op.c_str();
		if (!g_utf8_validate (str, -1, NULL)) {
			str = g_locale_to_utf8 (str, -1, NULL, NULL, NULL);
		}
		gtk_label_set_text (GTK_LABEL (label_), str);
	}

	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (bar_), Percent / 100.0);

   // flush
   while (gtk_events_pending())
     gtk_main_iteration();
}

void
OpDialogProgress::Done (void) {
	gtk_progress_bar_set_fraction (GTK_PROGRESS_BAR (bar_), 0.0);
}

OpDialogProgress::OpDialogProgress (GtkWidget* vbox) {
	g_assert (vbox);

  bar_ = gtk_progress_bar_new();
  label_ = gtk_label_new("");

	gtk_box_pack_start (GTK_BOX (vbox), label_, FALSE, FALSE, 0);
	gtk_box_pack_start (GTK_BOX (vbox), bar_, FALSE, FALSE, 0);

	gtk_widget_show_all (vbox);
}
