------------------------------------------------------------------------------
--                                                                          --
--                GNU ADA RUN-TIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--                 I N T E R F A C E S . V X W O R K S . I O                --
--                                                                          --
--                                  B o d y                                 --
--                                                                          --
--                             $Revision: 1.1 $
--                                                                          --
--             Copyright (C) 2002, Free Software Foundation, Inc.           --
--                                                                          --
-- GNARL is free software; you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion. GNARL is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNARL; see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNARL was developed by the GNARL team at Florida State University. It is --
-- now maintained by Ada Core Technologies Inc. in cooperation with Florida --
-- State University (http://www.gnat.com).                                  --
--                                                                          --
------------------------------------------------------------------------------

package body Interfaces.VxWorks.IO is

   --------------------------
   -- Enable_Get_Immediate --
   --------------------------

   procedure Enable_Get_Immediate
     (File : CSTR.FILEs; Success : out Boolean)
   is
      Status : int;
      Fd     : int;

   begin
      Fd := fileno (File);
      Status := ioctl (Fd, FIOSETOPTIONS, OPT_RAW);

      if Status /= int (ERROR) then
         Success := True;
      else
         Success := False;
      end if;
   end Enable_Get_Immediate;

   ---------------------------
   -- Disable_Get_Immediate --
   ---------------------------

   procedure Disable_Get_Immediate
     (File : CSTR.FILEs; Success : out Boolean)
   is
      Status : int;
      Fd     : int;

   begin
      Fd := fileno (File);
      Status := ioctl (Fd, FIOSETOPTIONS, OPT_TERMINAL);

      if Status /= int (ERROR) then
         Success := True;
      else
         Success := False;
      end if;
   end Disable_Get_Immediate;

end Interfaces.VxWorks.IO;
