-----------------------------------------------------------------------
--                               G N A T L I B                       --
--                                                                   --
--                         Copyright (C) 2006-2008, AdaCore          --
--                                                                   --
-- GPS is free  software;  you can redistribute it and/or modify  it --
-- under the terms of the GNU General Public License as published by --
-- the Free Software Foundation; either version 2 of the License, or --
-- (at your option) any later version.                               --
--                                                                   --
-- This program is  distributed in the hope that it will be  useful, --
-- but  WITHOUT ANY WARRANTY;  without even the  implied warranty of --
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU --
-- General Public License for more details. You should have received --
-- a copy of the GNU General Public License along with this program; --
-- if not,  write to the  Free Software Foundation, Inc.,  59 Temple --
-- Place - Suite 330, Boston, MA 02111-1307, USA.                    --
-----------------------------------------------------------------------

with Ada.Text_IO;          use Ada.Text_IO;
with Ada.Command_Line;     use Ada.Command_Line;
with GNAT.Email.Parser;    use GNAT.Email, GNAT.Email.Parser;
with GNAT.Email.Mailboxes; use GNAT.Email.Mailboxes;

procedure Test_Email4 is
   Box : Mbox;
   Stored : Stored_Mailbox;
   Iter   : Stored_Mailbox_Cursor;
   Count  : Natural := 0;
begin
   Open (Box, Filename => "email_data/FA11-011/bug");
   Store (Stored, Box, Factory  => Parse_No_Payload'Access);

   Open (Box, Filename => "email_data/FA11-011/comment");
   Store (Stored, Box, Factory  => Parse_No_Payload'Access);

   Iter := Stored_Mailbox_Cursor (First (Stored));
   while Has_Element (Iter) loop
      Count := Count + 1;
      Next (Iter, Stored);
   end loop;

   if Count /= 14 then
      Put_Line ("Incorrect parsing of multiple files with a single mbox,"
                & " found" & Count'Img & " messages instead of 14");
      Set_Exit_Status (1);
   end if;
end Test_Email4;
